/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import Beans.Announcement;
import MessageWindow.Message;
import MessageWindow.PMEX_MyTab;
import MessageWindow.RSSMessage;
import MessageWindow.ShowMessage;
import MessageWindow.ShowSearchResult;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LogsTC;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AbstractDocument;
import kse.gui.bean.MarginCallBean;
import kse.util.LogsKSE;
import languages.LanguageConstant;

public class PMEX_MessageDisplay
extends JPanel
implements HyperlinkListener {
    JPopupMenu popupMenu = new JPopupMenu();
    JMenuItem selectAll = new JMenuItem("Select All");
    JMenuItem copy = new JMenuItem("Copy");
    JMenuItem markAsRead = new JMenuItem("Mark As Read");
    JMenuItem markAsUnread = new JMenuItem("Mark As Unread");
    public Message message = null;
    public RSSMessage feed = null;
    private JTable table;
    public int totalMsg = 0;
    private Color readColor = Color.LIGHT_GRAY;
    private Color blinkColor = Color.YELLOW;
    String type = "";
    private ShowSearchResult showSearchResult = null;
    private int searchCount;
    public MarginCallBean margin;
    public Announcement announcement;
    private Vector<PMEX_MessageDisplay> rows = null;
    private String find = "";
    private PMEX_MyTab myTabPMEX = null;
    private int totalMessage;
    private static ShowMessage newsShowMessage;
    private static ShowMessage boardShowMessage;
    private static ShowMessage houseShowMessage;
    public JEditorPane editorPaneBody;
    public JEditorPane editorPaneHeader;
    private JLabel lblMore;

    public PMEX_MessageDisplay(PMEX_MyTab myTab, Message m, JTable table, String type, Vector<PMEX_MessageDisplay> rows) {
        DocumentListener[] listeners;
        this.rows = rows;
        this.myTabPMEX = myTab;
        this.SetValue(m, table, type);
        AbstractDocument doc = (AbstractDocument)this.editorPaneBody.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
        doc = (AbstractDocument)this.editorPaneHeader.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
        this.setText();
    }

    public PMEX_MessageDisplay(ShowSearchResult sp, Message m, JTable table, String type, int count, Vector<PMEX_MessageDisplay> rows, String find) {
        DocumentListener[] listeners;
        this.showSearchResult = sp;
        this.searchCount = count;
        this.rows = rows;
        this.find = find;
        this.SetValue(m, table, type);
        this.setTextSearch(true);
        AbstractDocument doc = (AbstractDocument)this.editorPaneBody.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
        doc = (AbstractDocument)this.editorPaneHeader.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
    }

    private void SetValue(Message m, JTable table, String type) {
        this.table = table;
        this.message = m;
        this.type = type;
        if (type.equalsIgnoreCase(LanguageConstant.News)) {
            this.totalMsg = LogsKSE.newsMsgCount;
            this.readColor = MyColors.newsReadBG;
        } else if (type.equalsIgnoreCase("Commodity News")) {
            this.totalMsg = LogsKSE.newsPMEXMsgCount;
            this.readColor = MyColors.newsReadBG;
        } else if (type.equalsIgnoreCase("HOUSE_MESSAGE")) {
            this.totalMsg = LogsKSE.houseMsgCount;
            this.readColor = MyColors.houseReadBG;
        }
        this.initComponents();
        this.editorPaneHeader.setContentType("text/html");
        this.editorPaneHeader.addHyperlinkListener(this);
        this.editorPaneBody.setContentType("text/html");
        this.editorPaneBody.addHyperlinkListener(this);
        this.lblMore.setCursor(Cursor.getPredefinedCursor(12));
        this.setPopupMenu();
    }

    private void setPopupMenu() {
        this.markAsRead.setIcon(new ImageIcon(this.getClass().getResource("/Images/markRead.png")));
        this.markAsRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PMEX_MessageDisplay.this.markAsRead();
            }
        });
        this.markAsUnread.setIcon(new ImageIcon(this.getClass().getResource("/Images/markUnread.png")));
        this.markAsUnread.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PMEX_MessageDisplay.this.markAsUnread();
            }
        });
        this.selectAll.setIcon(new ImageIcon(this.getClass().getResource("/Images/paste.png")));
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PMEX_MessageDisplay.this.editorPaneHeader.selectAll();
                PMEX_MessageDisplay.this.editorPaneBody.selectAll();
            }
        });
        this.copy.setIcon(new ImageIcon(this.getClass().getResource("/Images/paste.png")));
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Util.setClipboard((String)(PMEX_MessageDisplay.this.editorPaneHeader.getSelectedText() + PMEX_MessageDisplay.this.editorPaneBody.getSelectedText()));
            }
        });
        this.popupMenu.add(this.markAsRead);
        this.popupMenu.add(this.markAsUnread);
    }

    public void setColor(boolean status) {
        if (this.message != null) {
            if (status && this.message.isRead) {
                String color = Integer.toHexString(this.blinkColor.getRGB() & 0xFFFFFF);
                this.setTextRead(color);
            } else if (status && !this.message.isRead) {
                String color = Integer.toHexString(this.blinkColor.getRGB() & 0xFFFFFF);
                this.setTextUnRead(color);
            } else if (this.message.isRead) {
                String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
                this.setTextRead(color);
            } else {
                String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
                this.setTextUnRead(color);
            }
        }
    }

    private void setText() {
        if (this.message != null) {
            if (this.message.isRead) {
                this.setTextRead(true);
            } else {
                this.setTextUnRead(true);
            }
        }
    }

    public void setTextUpdated() {
        if (this.type.equalsIgnoreCase(LanguageConstant.News)) {
            this.totalMsg = LogsKSE.newsMsgCount;
        } else if (this.type.equalsIgnoreCase("Commodity News")) {
            this.totalMsg = LogsKSE.newsPMEXMsgCount;
        } else if (this.type.equalsIgnoreCase("HOUSE_MESSAGE")) {
            this.totalMsg = LogsKSE.houseMsgCount;
        }
        if (this.message != null) {
            if (this.message.isRead) {
                if (!this.find.equalsIgnoreCase("")) {
                    this.setTextSearch(false);
                } else {
                    this.setTextRead(false);
                }
            } else if (!this.find.equalsIgnoreCase("")) {
                this.setTextSearch(false);
            } else {
                this.setTextUnRead(false);
            }
        }
    }

    private void setTextRead(boolean isNewLine) {
        if (isNewLine && this.message != null) {
            this.message.msgNo = this.table.getRowCount() + 1;
        }
        String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
        if (this.message != null) {
            StringBuilder sbHeader = new StringBuilder();
            sbHeader.append("<html>");
            sbHeader.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sbHeader.append("<tr width='100%' COLOR='#373737' BGColor='#").append(color).append("'>");
            sbHeader.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
            sbHeader.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>");
            sbHeader.append("<b>");
            sbHeader.append("<a href='' style='color:#373737; text-decoration:none'>").append(this.message.subject.value.trim());
            if (this.message.description.value.trim().length() > 0) {
                sbHeader.append(" (").append(this.message.description.value.trim()).append(")");
            }
            sbHeader.append("</a>");
            sbHeader.append("</b>");
            sbHeader.append("</font>");
            sbHeader.append("</td>");
            sbHeader.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
            sbHeader.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >").append(this.message.dateTime.value.trim()).append(" | ").append(Util.format0digit((String)(this.message.msgNo + ""))).append(" of ").append(Util.format0digit((String)(this.totalMsg + ""))).append("</td>");
            sbHeader.append("</tr>");
            sbHeader.append("</table>");
            sbHeader.append("</html>");
            StringBuilder sbBody = new StringBuilder();
            sbBody.append("<html>");
            sbBody.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sbBody.append("<tr >");
            sbBody.append("<td style='margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>").append(this.message.detail.value.trim()).append("</font></div></td>");
            sbBody.append("</tr>");
            sbBody.append("</table>");
            sbBody.append("</html>");
            this.editorPaneHeader.setText(sbHeader.toString());
            this.editorPaneBody.setText(sbBody.toString());
            this.table.addNotify();
        }
    }

    private void setTextUnRead(boolean isNewLine) {
        if (isNewLine && this.message != null) {
            this.message.msgNo = this.table.getRowCount() + 1;
        }
        String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
        if (this.message != null) {
            StringBuilder sbHeader = new StringBuilder();
            sbHeader.append("<html>");
            sbHeader.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sbHeader.append("<tr COLOR='#373737' BGColor='#").append(color).append("'>");
            sbHeader.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
            sbHeader.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>");
            sbHeader.append("<b>");
            sbHeader.append("<a href='' style='color:#373737; text-decoration:none'>").append(this.message.subject.value);
            if (this.message.description.value.trim().length() > 0) {
                sbHeader.append(" (").append(this.message.description.value).append(")");
            }
            sbHeader.append("</a>");
            sbHeader.append("</b>");
            sbHeader.append("</font>");
            sbHeader.append("</td>");
            sbHeader.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
            sbHeader.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >").append(this.message.dateTime.value).append(" | ").append(Util.format0digit((String)(this.message.msgNo + ""))).append(" of ").append(Util.format0digit((String)(this.totalMsg + ""))).append("</font></td>");
            sbHeader.append("</tr>");
            sbHeader.append("</table>");
            sbHeader.append("</html>");
            StringBuilder sbBody = new StringBuilder();
            sbBody.append("<html>");
            sbBody.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sbBody.append("<tr >");
            sbBody.append("<td style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>").append(this.message.detail.value).append("</b></font></div></td>");
            sbBody.append("</tr>");
            sbBody.append("</table>");
            sbBody.append("</html>");
            this.editorPaneHeader.setText(sbHeader.toString());
            this.editorPaneBody.setText(sbBody.toString());
            this.table.addNotify();
        }
    }

    private void setTextRead(String color) {
        if (this.message != null) {
            StringBuilder sbHeader = new StringBuilder();
            sbHeader.append("<html>");
            sbHeader.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sbHeader.append("<tr COLOR='#373737' BGColor='#").append(color).append("'>");
            sbHeader.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
            sbHeader.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b><a href='' style='color:#373737; text-decoration:none'>").append(this.message.subject.value);
            if (this.message.description.value.trim().length() > 0) {
                sbHeader.append(" (").append(this.message.description.value).append(")");
            }
            sbHeader.append("</a></b></font></td>");
            sbHeader.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
            sbHeader.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >").append(this.message.dateTime.value).append(" | ").append(Util.format0digit((String)(this.message.msgNo + ""))).append(" of ").append(Util.format0digit((String)(this.totalMsg + ""))).append("</font></td>");
            sbHeader.append("</tr>");
            sbHeader.append("</table>");
            sbHeader.append("</html>");
            StringBuilder sbBody = new StringBuilder();
            sbBody.append("<html>");
            sbBody.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sbBody.append("<tr >");
            sbBody.append("<td style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>").append(this.message.detail.value).append("</font></div></td>");
            sbBody.append("</tr>");
            sbBody.append("</table>");
            sbBody.append("</html>");
            this.editorPaneHeader.setText(sbHeader.toString());
            this.editorPaneBody.setText(sbBody.toString());
            this.table.addNotify();
        }
    }

    private void setTextSearch(boolean st) {
        if (this.message != null) {
            if (this.message.isRead) {
                this.setTextReadSearch(st);
            } else {
                this.setTextUnReadSearch(st);
            }
        }
    }

    private void setTextReadSearch(boolean isNewLine) {
        if (isNewLine && this.message != null) {
            this.message.msgNo = this.table.getRowCount() + 1;
        }
        String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
        if (this.message != null) {
            StringBuilder sbHeader = new StringBuilder();
            sbHeader.append("<html>");
            sbHeader.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sbHeader.append("<tr COLOR='#373737' BGColor='#").append(color).append("'>");
            sbHeader.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
            sbHeader.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>");
            sbHeader.append("<b>");
            sbHeader.append("<a href='' style='color:#373737; text-decoration:none'>").append(this.HightLight(this.message.subject.value, this.find));
            if (this.message.description.value.trim().length() > 0) {
                sbHeader.append(" (").append(this.HightLight(this.message.description.value, this.find)).append(")");
            }
            sbHeader.append("</a>");
            sbHeader.append("</b>");
            sbHeader.append("</font>");
            sbHeader.append("</td>");
            sbHeader.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
            sbHeader.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >").append(this.message.dateTime.value).append(" | ").append(Util.format0digit((String)(this.message.msgNo + ""))).append(" of ").append(Util.format0digit((String)(this.searchCount + ""))).append("</font></td>");
            sbHeader.append("</tr>");
            sbHeader.append("</table>");
            sbHeader.append("</html>");
            StringBuilder sbBody = new StringBuilder();
            sbBody.append("<html>");
            sbBody.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sbBody.append("<tr >");
            sbBody.append("<td style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>").append(this.HightLight(this.message.detail.value, this.find)).append("</font></div></td>");
            sbBody.append("</tr>");
            sbBody.append("</table>");
            sbBody.append("</html>");
            this.editorPaneHeader.setText(sbHeader.toString());
            this.editorPaneBody.setText(sbBody.toString());
            this.table.addNotify();
        }
    }

    private void setTextUnReadSearch(boolean isNewLine) {
        if (isNewLine && this.message != null) {
            this.message.msgNo = this.table.getRowCount() + 1;
        }
        if (this.message != null) {
            String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
            StringBuilder sbHeader = new StringBuilder();
            sbHeader.append("<html>");
            sbHeader.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sbHeader.append("<tr COLOR='#373737' BGColor='#").append(color).append("'>");
            sbHeader.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
            sbHeader.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>");
            sbHeader.append("<b>");
            sbHeader.append("<a href='' style='color:#373737; text-decoration:none'>").append(this.HightLight(this.message.subject.value, this.find));
            if (this.message.description.value.trim().length() > 0) {
                sbHeader.append(" (").append(this.HightLight(this.message.description.value, this.find)).append(")");
            }
            sbHeader.append("</a></b></font></td>");
            sbHeader.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
            sbHeader.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >").append(this.message.dateTime.value).append(" | ").append(Util.format0digit((String)(this.message.msgNo + ""))).append(" of ").append(Util.format0digit((String)(this.searchCount + ""))).append("</font></td>");
            sbHeader.append("</tr>");
            sbHeader.append("</table>");
            sbHeader.append("</html>");
            StringBuilder sbBody = new StringBuilder();
            sbBody.append("<html>");
            sbBody.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sbBody.append("<tr >");
            sbBody.append("<td style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>").append(this.HightLight(this.message.detail.value, this.find)).append("</b></font></div></td>");
            sbBody.append("</tr>");
            sbBody.append("</table>");
            sbBody.append("</html>");
            this.editorPaneHeader.setText(sbHeader.toString());
            this.editorPaneBody.setText(sbBody.toString());
            this.table.addNotify();
        }
    }

    private void setTextUnRead(String color) {
        if (this.message != null) {
            StringBuilder sbHeader = new StringBuilder();
            sbHeader.append("<html>");
            sbHeader.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sbHeader.append("<tr COLOR='#373737' BGColor='#").append(color).append("'>");
            sbHeader.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
            sbHeader.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>");
            sbHeader.append("<a href='' style='color:#373737; text-decoration:none'>").append(this.message.subject.value);
            if (this.message.description.value.trim().length() > 0) {
                sbHeader.append(" (").append(this.message.description.value).append(")");
            }
            sbHeader.append("</a></b></font></td>");
            sbHeader.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
            sbHeader.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >").append(this.message.dateTime.value).append(" | ").append(Util.format0digit((String)(this.message.msgNo + ""))).append(" of ").append(Util.format0digit((String)(this.totalMsg + ""))).append("</font></td>");
            sbHeader.append("</tr>");
            sbHeader.append("</table>");
            sbHeader.append("</html>");
            StringBuilder sbBody = new StringBuilder();
            sbBody.append("<html>");
            sbBody.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sbBody.append("<tr >");
            sbBody.append("<td style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>").append(this.message.detail.value).append("</b></font></div></td>");
            sbBody.append("</tr>");
            sbBody.append("</table>");
            sbBody.append("</html>");
            this.editorPaneHeader.setText(sbHeader.toString());
            this.editorPaneBody.setText(sbBody.toString());
            this.table.addNotify();
        }
    }

    private void initComponents() {
        this.editorPaneBody = new JEditorPane();
        this.lblMore = new JLabel();
        this.editorPaneHeader = new JEditorPane();
        this.setBackground(new Color(255, 255, 255));
        this.editorPaneBody.setEditable(false);
        this.editorPaneBody.setText("12345678");
        this.editorPaneBody.setMaximumSize(new Dimension(500, 200));
        this.editorPaneBody.setMinimumSize(new Dimension(106, 200));
        this.editorPaneBody.setName("editorPaneBody");
        this.editorPaneBody.setPreferredSize(new Dimension(500, 200));
        this.editorPaneBody.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PMEX_MessageDisplay.this.editorPaneBodyMousePressed(evt);
            }
        });
        this.lblMore.setForeground(new Color(153, 153, 153));
        this.lblMore.setHorizontalAlignment(4);
        this.lblMore.setText("more..");
        this.lblMore.setName("lblMore");
        this.lblMore.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PMEX_MessageDisplay.this.lblMoreMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PMEX_MessageDisplay.this.lblMoreMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PMEX_MessageDisplay.this.lblMoreMousePressed(evt);
            }
        });
        this.editorPaneHeader.setEditable(false);
        this.editorPaneHeader.setText("123");
        this.editorPaneHeader.setMaximumSize(new Dimension(500, 200));
        this.editorPaneHeader.setMinimumSize(new Dimension(106, 200));
        this.editorPaneHeader.setName("editorPaneHeader");
        this.editorPaneHeader.setPreferredSize(new Dimension(500, 200));
        this.editorPaneHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PMEX_MessageDisplay.this.editorPaneHeaderMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.editorPaneBody, -1, 158, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMore, -2, 36, -2)).addComponent(this.editorPaneHeader, -2, 0, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.editorPaneHeader, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblMore)).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.editorPaneBody, -2, 0, Short.MAX_VALUE)));
    }

    private void editorPaneBodyMousePressed(MouseEvent evt) {
        this.setMousePressed(evt);
    }

    private void lblMoreMousePressed(MouseEvent evt) {
        this.showPopup();
    }

    private void lblMoreMouseEntered(MouseEvent evt) {
        this.lblMore.setForeground(MyColors.tabPaneselectedForeground);
    }

    private void lblMoreMouseExited(MouseEvent evt) {
        this.lblMore.setForeground(new Color(153, 153, 153));
    }

    private void editorPaneHeaderMousePressed(MouseEvent evt) {
        this.setMousePressed(evt);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.showPopup();
        }
    }

    private void showPopup() {
        if (this.message != null) {
            this.message.isRead = true;
            this.setRead(true, this.message.id.value);
            if (!this.find.equalsIgnoreCase("")) {
                this.setTextSearch(false);
            } else {
                this.setTextRead(false);
            }
            if (this.showSearchResult != null) {
                if (this.showSearchResult.myTabPMEX != null) {
                    if (LanguageConstant.News.equalsIgnoreCase(this.message.type.value)) {
                        if (newsShowMessage != null) {
                            newsShowMessage.dispose();
                        }
                        newsShowMessage = new ShowMessage(Mediator.getInstance().msgCenter.newsTabPMEX, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                        LogsTC.showMessageWidow.push(newsShowMessage);
                    } else if ("Commodity News".equalsIgnoreCase(this.message.type.value)) {
                        if (newsShowMessage != null) {
                            newsShowMessage.dispose();
                        }
                        newsShowMessage = new ShowMessage(Mediator.getInstance().msgCenter.newsTabPMEX, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                        LogsTC.showMessageWidow.push(newsShowMessage);
                    } else if ("BOARD_MEETING".equalsIgnoreCase(this.message.type.value)) {
                        if (boardShowMessage != null) {
                            boardShowMessage.dispose();
                        }
                        boardShowMessage = new ShowMessage(Mediator.getInstance().msgCenter.newsTabPMEX, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                        LogsTC.showMessageWidow.push(boardShowMessage);
                    } else if ("HOUSE_MESSAGE".equalsIgnoreCase(this.message.type.value)) {
                        if (houseShowMessage != null) {
                            houseShowMessage.dispose();
                        }
                        houseShowMessage = new ShowMessage(Mediator.getInstance().msgCenter.newsTabPMEX, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                        LogsTC.showMessageWidow.push(houseShowMessage);
                    }
                    this.showSearchResult.myTabPMEX.setReadunRead(this.message);
                }
            } else if ("Commodity News".equalsIgnoreCase(this.message.type.value)) {
                if (newsShowMessage != null) {
                    newsShowMessage.dispose();
                }
                newsShowMessage = new ShowMessage(this.myTabPMEX, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                LogsTC.showMessageWidow.push(newsShowMessage);
            }
        }
    }

    protected void setRead(final boolean status, final String id) {
        new Thread("PMEX Message Display setRead"){

            @Override
            public void run() {
                try {
                    if (PMEX_MessageDisplay.this.message != null) {
                        WebService.getInstance().getPort().updateUserMessages(LogCommon.UserID, PMEX_MessageDisplay.this.message.type.value, id, status);
                    } else if (PMEX_MessageDisplay.this.announcement != null && AppConfig.loginMode != LoginMode.PMEX) {
                        WebService.getInstance().getPort().updateUserMessages(LogCommon.UserID, LanguageConstant.Announcement, id, status);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    public static String convert(String str) {
        StringBuffer ostr = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                ostr.append(ch);
                continue;
            }
            ostr.append("\\u");
            String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
            for (int j = 0; j < 4 - hex.length(); ++j) {
                ostr.append("0");
            }
            ostr.append(hex.toLowerCase());
        }
        return new String(ostr);
    }

    public String HightLight(String originaltext, String findwhat) {
        if (findwhat == null) {
            return originaltext;
        }
        if (findwhat.equalsIgnoreCase("")) {
            return originaltext;
        }
        int findwhatlength = findwhat.length();
        String Title2 = "";
        String TitleInUpperCase = originaltext.toUpperCase();
        String findwhatInUpperCase = findwhat.toUpperCase();
        int Cursor2 = 0;
        int index = 0;
        while (TitleInUpperCase.indexOf(findwhatInUpperCase) > -1) {
            index = TitleInUpperCase.indexOf(findwhatInUpperCase);
            Title2 = Title2 + originaltext.substring(Cursor2, index) + "<span style='background-color:yellow'>" + originaltext.substring(index, index + findwhatlength) + "</span>";
            originaltext = originaltext.substring(index + findwhatlength, originaltext.length());
            if (TitleInUpperCase.length() > index + findwhatlength) {
                // empty if block
            }
            TitleInUpperCase = TitleInUpperCase.substring(index + findwhatlength, TitleInUpperCase.length());
        }
        Title2 = Title2.length() == 0 ? originaltext : Title2 + originaltext.substring(0, originaltext.length());
        return Title2;
    }

    private void markAsRead() {
        if (this.message != null) {
            this.message.isRead = true;
            this.setTextRead(false);
            this.setColor(false);
            this.setRead(true, this.message.id.value);
            if (!this.find.equalsIgnoreCase("")) {
                this.setTextReadSearch(false);
            }
            if (this.showSearchResult != null && this.showSearchResult.myTabPMEX != null) {
                this.showSearchResult.myTabPMEX.setReadunRead(this.message);
            }
        }
    }

    private void markAsUnread() {
        if (this.message != null) {
            this.message.isRead = false;
            this.setTextUnRead(false);
            this.setColor(false);
            this.setRead(false, this.message.id.value);
            if (!this.find.equalsIgnoreCase("")) {
                this.setTextUnReadSearch(false);
            }
            if (this.showSearchResult != null && this.showSearchResult.myTabPMEX != null) {
                this.showSearchResult.myTabPMEX.setReadunRead(this.message);
            }
        }
    }

    private void setMousePressed(MouseEvent evt) {
        if (this.myTabPMEX != null) {
            this.myTabPMEX.stopBlink(this.message.id.value);
        }
        if (SwingUtilities.isRightMouseButton(evt)) {
            if (this.editorPaneBody.getSelectedText() == null) {
                this.copy.setEnabled(false);
            } else {
                this.copy.setEnabled(true);
            }
            if (this.message != null) {
                if (this.message.isRead) {
                    this.markAsRead.setEnabled(false);
                    this.markAsUnread.setEnabled(true);
                } else {
                    this.markAsRead.setEnabled(true);
                    this.markAsUnread.setEnabled(false);
                }
            }
            this.popupMenu.show(this.editorPaneBody, evt.getX(), evt.getY());
        }
    }
}

