/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import CATALYST.Control.MarketFeed;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.Utilities;
import CustomComponent.MyTime;
import MessageWindow.MessageRender;
import MessageWindow.PriceAlert;
import MessageWindow.PriceAlertModel;
import MessageWindow.PriceDisplay;
import MessageWindow.ReadWrite;
import MessageWindow.SetIndicesAlert;
import MessageWindow.SetPriceAlerts;
import MyDocking.Mediator;
import MyDocking.MessageWindowCenter;
import Utilities.Voice;
import common.bean.ExchangeStateBean;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import org.jdesktop.swingx.JXCollapsiblePane;

public class PriceAlertTab
extends JPanel
implements ActionListener {
    private static final double DAY_MILLIS = 8.64054E7;
    private static final double WEEK_MILLIS = 6.048378E8;
    private static final double MONTH_MILLIS = 2.62989955845E9;
    private static final double YEAR_MILLIS = 3.157253316E10;
    public Mediator mediator = Mediator.getInstance();
    private MessageWindowCenter msgCenter = MessageWindowCenter.getInstance();
    String[] columnNames = new String[]{""};
    public Vector<PriceDisplay> rows = new Vector();
    Hashtable<Long, PriceDisplay> unTriggred = new Hashtable();
    Hashtable<Long, Timer> timerMap = new Hashtable();
    Vector columns = new Vector();
    MessageRender priceAlertRender = new MessageRender();
    PriceAlertModel model = new PriceAlertModel(this.rows);
    public static int rowNumber = 0;
    JMenuItem priceAlertMenu = new JMenuItem("Set Scrip Alert   ");
    JMenuItem indexAlertMenu = new JMenuItem("Set Index Alert   ");
    JMenuItem editMenu = new JMenuItem("Edit        ");
    JMenuItem deleteMenu = new JMenuItem("Delete      ");
    JMenuItem deleteAllMenu = new JMenuItem("Delete All    ");
    JMenuItem priceAlertMenuScr = new JMenuItem("Set Scrip Alert   ");
    JMenuItem indexAlertMenuScr = new JMenuItem("Set Index Alert   ");
    ReadWrite readWrite = new ReadWrite();
    MyTime myTime = MyTime.getInstance();
    private Point point = new Point();
    HashMap<String, PriceAlert> keyMap = new HashMap();
    private String lastKey;
    HashSet<String> scripSet = new HashSet();
    HashMap<String, PriceAlert> scripList = new HashMap();
    private JLabel lblCount = new JLabel(" ");
    public static int TotalMessage = 0;
    private boolean isScripOpen = false;
    SetPriceAlerts setPriceAlerts = null;
    private JButton btnSetScripAlert;
    private JButton btnSetindicesAlert;
    private JButton btnTest;
    private ButtonGroup buttonGroup1;
    private JXCollapsiblePane collapsiblePane;
    public JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu popupMenuScrollPane;
    private JPopupMenu popupMenuTable;
    public JTable table;
    private JToolBar toolBar;

    public PriceAlertTab(String type) {
        try {
            this.initComponents();
            this.btnSetScripAlert.setToolTipText("Set Scrip Alert");
            this.btnSetindicesAlert.setToolTipText("Set Index Alert");
            this.btnSetScripAlert.setName("PriceAlertTab -> btnSetScripAlert");
            this.btnSetindicesAlert.setName("PriceAlertTab -> btnSetindicesAlert");
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columns.addElement(this.columnNames[i]);
            }
            this.toolBar.add(Box.createHorizontalGlue());
            this.lblCount.setHorizontalAlignment(4);
            this.toolBar.add(this.lblCount);
            this.model.setDataVector(this.rows, this.columns);
            this.table.setModel(this.model);
            this.table.setDefaultRenderer(Object.class, this.priceAlertRender);
            TableColumn com = this.table.getColumnModel().getColumn(0);
            com.setCellEditor(this.priceAlertRender);
            this.table.setTableHeader(null);
            this.table.setRowHeight(90);
            this.table.setSelectionMode(0);
            this.setPopupMenu();
            this.msgCenter.setPriceAlertTab(this);
            this.setOldData();
            this.collapsiblePane.setCollapsed(true);
            this.setRecordCount();
            this.setScripAlert();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setRecordCount() {
        String countRecord = this.table.getRowCount() + " Record(s)  ";
        this.lblCount.setText(countRecord);
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PriceAlertTab.this.table.addNotify();
                    PriceAlertTab.this.table.repaint();
                }
            });
        }
    }

    public synchronized void update() {
        Enumeration<PriceDisplay> e = this.unTriggred.elements();
        while (e.hasMoreElements()) {
            PriceDisplay pd = e.nextElement();
            PriceAlert pa = pd.priceAlert;
            if (pa.isIndex) continue;
            MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(pa.scrip, pa.market);
            boolean status = false;
            if (mktFeed == null) continue;
            double mktValue = -999999.0;
            try {
                mktValue = Double.parseDouble(this.getMktValue(pa.field, mktFeed).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String operation = pa.operator;
            double value = -999999.0;
            try {
                value = Double.parseDouble(pa.value.trim());
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            if (operation.equalsIgnoreCase("Greater Than")) {
                if (mktValue > value) {
                    status = true;
                }
            } else if (operation.equalsIgnoreCase("Greater Than OR Equal")) {
                if (mktValue >= value) {
                    status = true;
                }
            } else if (operation.equalsIgnoreCase("Less Than")) {
                if (mktValue < value) {
                    status = true;
                }
            } else if (operation.equalsIgnoreCase("Less Than OR Equal")) {
                if (mktValue <= value) {
                    status = true;
                }
            } else if (operation.equalsIgnoreCase("Equal") && mktValue == value) {
                status = true;
            }
            if (!status) continue;
            this.unTriggred.remove(pa.id);
            pa.isTriggered = true;
            pa.triggeredAt = LogsKSE.sdfMessage.format(this.myTime.getDate2());
            pa.triggeredValue = mktValue + "";
            pd.setText();
            this.tableDataChange();
            this.readWrite.write(this.rows);
            this.timerMap.put(pa.id, this.Blink(pa.id, true));
            if (this.scripList.containsKey(pa.scrip + pa.id)) {
                this.scripList.remove(pa.scrip + pa.id);
            }
            this.addSymbolInMarketWatch();
            if (pa.isDesktopAlert && this.mediator.toasterManager != null) {
                this.mediator.toasterManager.showToaster(this.mediator.toasterManager, "Scrip Alert", pa.triggeredText, "Alerts");
            }
            if (!pa.isVoice) continue;
            Voice.getInstance().Speak(pa.VoiceText);
        }
    }

    public synchronized void ExSReceived() {
        Enumeration<PriceDisplay> en = this.unTriggred.elements();
        while (en.hasMoreElements()) {
            PriceDisplay pd = en.nextElement();
            PriceAlert pa = pd.priceAlert;
            String Mkt = pa.index;
            Mkt = Mkt.replace(" ", "").toUpperCase();
            if (!pa.isIndex) continue;
            ExchangeStateBean exsFeed = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get(Mkt);
            boolean status = false;
            if (exsFeed == null) continue;
            double exsValue = this.getExSValue(pa.field, exsFeed);
            String operation = pa.operator;
            double value = -999999.0;
            try {
                value = Double.parseDouble(pa.value.trim());
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            if (operation.equalsIgnoreCase("Greater Than")) {
                if (exsValue > value) {
                    status = true;
                }
            } else if (operation.equalsIgnoreCase("Greater Than OR Equal")) {
                if (exsValue >= value) {
                    status = true;
                }
            } else if (operation.equalsIgnoreCase("Less Than")) {
                if (exsValue < value) {
                    status = true;
                }
            } else if (operation.equalsIgnoreCase("Less Than OR Equal")) {
                if (exsValue <= value) {
                    status = true;
                }
            } else if (operation.equalsIgnoreCase("Equal") && exsValue == value) {
                status = true;
            }
            if (!status) continue;
            pa.isTriggered = true;
            pa.triggeredAt = LogsKSE.sdfMessage.format(this.myTime.getDate2());
            pa.triggeredValue = exsValue + "";
            pd.setText();
            this.tableDataChange();
            this.readWrite.write(this.rows);
            this.timerMap.put(pa.id, this.Blink(pa.id, true));
            this.unTriggred.remove(pa.id);
            if (pa.isDesktopAlert && this.mediator.toasterManager != null) {
                this.mediator.toasterManager.showToaster(this.mediator.toasterManager, "Index Alert", pa.triggeredText, "Alerts");
            }
            if (!pa.isVoice) continue;
            String text = pa.VoiceText;
            text = text.replaceAll("KSE", "K S E");
            text = text.replaceAll("KMI", "K M I");
            text = text.replaceAll("ALLSHR", "All shares");
            text = text.replaceAll("OGTi", "O G T I");
            text = text.replaceAll("BKTi", "B K T I");
            text = text.replaceAll(",", "");
            Voice.getInstance().Speak(text);
        }
    }

    private String getMktValue(String value, MarketFeed mktFeed) {
        if (value.equalsIgnoreCase("Buy Volume")) {
            return mktFeed.bvol;
        }
        if (value.equalsIgnoreCase("Buy")) {
            return mktFeed.buy;
        }
        if (value.equalsIgnoreCase("Sell")) {
            return mktFeed.sell;
        }
        if (value.equalsIgnoreCase("Sell Volume")) {
            return mktFeed.svol;
        }
        if (value.equalsIgnoreCase("Last Price")) {
            return mktFeed.lTrdPrice;
        }
        if (value.equalsIgnoreCase("Total Volume")) {
            return mktFeed.totVolume;
        }
        if (value.equalsIgnoreCase("High")) {
            return mktFeed.high;
        }
        if (value.equalsIgnoreCase("Low")) {
            return mktFeed.low;
        }
        if (value.equalsIgnoreCase("Total Trades")) {
            return mktFeed.totTrades;
        }
        if (value.equalsIgnoreCase("Change")) {
            return mktFeed.change;
        }
        if (value.equalsIgnoreCase("Average")) {
            return mktFeed.average;
        }
        if (value.equalsIgnoreCase("Last Trade Volume")) {
            return mktFeed.ltrdVolume;
        }
        if (value.equalsIgnoreCase("Close Price")) {
            return mktFeed.closePrice;
        }
        if (value.equalsIgnoreCase("Spread")) {
            return this.getSpread(mktFeed, false);
        }
        if (value.equalsIgnoreCase("Spread %")) {
            return this.getSpread(mktFeed, true);
        }
        return "";
    }

    public String getSpread(MarketFeed feedfutue, boolean isPercent) {
        String val = "";
        String regSymbol = "";
        if (feedfutue.symbol.equalsIgnoreCase("FUT")) {
            regSymbol = feedfutue.symbol.split("\\-", -1)[0];
        }
        MarketFeed feedregular = this.mediator.MwPanel.GetSingleFeed(regSymbol, "REG");
        try {
            if (feedregular != null) {
                String month;
                Double diff = Double.parseDouble(feedfutue.buy) - Double.parseDouble(feedregular.sell);
                val = diff + "";
                if (isPercent && MarketWatch.isCalculatePercentage && MarketWatch.SettleRemainingDays.containsKey(month = Utilities.GetSymbolMonthFromSymbol((String)(feedfutue.symbol + ":FUT")))) {
                    Integer remainigDays = (Integer)MarketWatch.SettleRemainingDays.get(month);
                    Double futureBuy = Double.parseDouble(feedfutue.buy);
                    Double RegSell = Double.parseDouble(feedregular.sell);
                    Double per = (futureBuy - RegSell) / RegSell / (double)remainigDays.intValue() * 365.0 * 100.0;
                    val = per + "";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    private double getExSValue(String value, ExchangeStateBean exsFeed) {
        if (value.equalsIgnoreCase("Index")) {
            return exsFeed.getIndex();
        }
        if (value.equalsIgnoreCase("Change")) {
            return exsFeed.getIndexChange();
        }
        if (value.equalsIgnoreCase("Volume")) {
            return exsFeed.getCVol();
        }
        if (value.equalsIgnoreCase("Value")) {
            return exsFeed.getVal();
        }
        return 0.0;
    }

    private void setPopupMenu() {
        this.priceAlertMenu.setIcon(new ImageIcon(this.getClass().getResource("/Images/PriceAlert12x12.png")));
        this.indexAlertMenu.setIcon(new ImageIcon(this.getClass().getResource("/Images/PriceAlert12x12.png")));
        this.editMenu.setIcon(new ImageIcon(this.getClass().getResource("/Images/edit12x12.png")));
        this.deleteMenu.setIcon(new ImageIcon(this.getClass().getResource("/Images/delete.png")));
        this.deleteAllMenu.setIcon(new ImageIcon(this.getClass().getResource("/Images/close12x12.png")));
        this.priceAlertMenuScr.setIcon(new ImageIcon(this.getClass().getResource("/Images/PriceAlert12x12.png")));
        this.indexAlertMenuScr.setIcon(new ImageIcon(this.getClass().getResource("/Images/PriceAlert12x12.png")));
        this.priceAlertMenu.addActionListener(this);
        this.indexAlertMenu.addActionListener(this);
        this.editMenu.addActionListener(this);
        this.deleteMenu.addActionListener(this);
        this.deleteAllMenu.addActionListener(this);
        this.priceAlertMenuScr.addActionListener(this);
        this.indexAlertMenuScr.addActionListener(this);
        this.popupMenuScrollPane.add(this.priceAlertMenuScr);
        this.popupMenuScrollPane.add(this.indexAlertMenuScr);
        this.popupMenuTable.add(this.priceAlertMenu);
        this.popupMenuTable.add(this.indexAlertMenu);
        this.popupMenuTable.add(this.editMenu);
        this.popupMenuTable.add(this.deleteMenu);
        this.popupMenuTable.add(this.deleteAllMenu);
    }

    public synchronized void addRow(PriceAlert pa) {
        if (pa != null) {
            String key = pa.getKey();
            if (this.keyMap.containsKey(key)) {
                int rowNo = this.getRowNo(this.keyMap.get((Object)key).id);
                this.table.getSelectionModel().setSelectionInterval(rowNo, rowNo);
                JOptionPane.showMessageDialog(null, "Scrip alert with same parameters already exists");
                return;
            }
            this.keyMap.put(key, pa);
            PriceDisplay pd = new PriceDisplay(this, pa);
            if (LogCommon.isTop) {
                this.rows.add(0, pd);
            } else {
                this.rows.add(this.rows.size(), pd);
            }
            if (!pa.isTriggered) {
                this.unTriggred.put(pa.id, pd);
            }
            if (pa.isIndex) {
                this.ExSReceived();
            } else if (!pa.isIndex) {
                this.update();
            }
            this.updateALLRows(false);
            this.addSymbolInMarketWatch();
            this.readWrite.write(this.rows);
            this.tableDataChange();
            Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
            this.setRecordCount();
        }
    }

    public void editRow() {
        if (rowNumber >= 0) {
            PriceAlert pa = this.rows.get((int)PriceAlertTab.rowNumber).priceAlert;
            if (pa.isTriggered) {
                JOptionPane.showMessageDialog(null, "Triggered Alert can not be edited");
                return;
            }
            this.lastKey = pa.getKey();
            if (!pa.isIndex) {
                this.collapsiblePane.setCollapsed(true);
                this.collapsiblePane.removeAll();
                SetPriceAlerts spa = new SetPriceAlerts(this, pa);
                spa.setValues(pa);
                this.collapsiblePane.add((Component)spa);
                this.collapsiblePane.setCollapsed(false);
            } else {
                this.collapsiblePane.setCollapsed(true);
                this.collapsiblePane.removeAll();
                SetIndicesAlert spa = new SetIndicesAlert(this, pa);
                spa.setValues(pa);
                this.collapsiblePane.add((Component)spa);
                this.collapsiblePane.setCollapsed(false);
            }
        }
    }

    public synchronized void editRow(PriceAlert pa) {
        if (pa != null) {
            String key;
            PriceDisplay pd = this.rows.get(this.getRowNo(pa.id));
            pd.priceAlert = pa;
            this.unTriggred.put(pa.id, pd);
            if (this.timerMap.containsKey(pa.id)) {
                this.timerMap.get(pa.id).stop();
            }
            if (this.keyMap.containsKey(this.lastKey)) {
                this.keyMap.remove(this.lastKey);
            }
            if (!this.keyMap.containsKey(key = pa.getKey())) {
                this.keyMap.put(key, pa);
            }
            pd.setText();
            if (pa.isIndex) {
                this.ExSReceived();
            } else {
                this.update();
            }
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            this.tableDataChange();
            this.readWrite.write(this.rows);
        }
    }

    public void deleteRow() {
        int choise;
        if (rowNumber >= 0 && (choise = JOptionPane.showConfirmDialog(null, "Do you want to delete this alert?", "Delete Alert", 0)) == 0) {
            PriceAlert pa = this.rows.get((int)PriceAlertTab.rowNumber).priceAlert;
            String strKey = pa.getKey();
            if (this.keyMap.containsKey(strKey)) {
                this.keyMap.remove(strKey);
            }
            if (this.scripList.containsKey(pa.scrip + pa.id)) {
                this.scripList.remove(pa.scrip + pa.id);
            }
            this.scripSet.clear();
            Iterator<String> en = this.scripList.keySet().iterator();
            while (en.hasNext()) {
                PriceAlert palert = this.scripList.get(en.next().toString());
                this.scripSet.add(palert.scrip);
            }
            this.rows.remove(rowNumber);
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            --TotalMessage;
            this.updateALLRows(true);
            this.addSymbolInMarketWatch();
            this.tableDataChange();
            this.readWrite.write(this.rows);
            this.setRecordCount();
        }
    }

    private void deleteAllRows() {
        int choise = JOptionPane.showConfirmDialog(null, "Do you want to delete all alerts?", "Delete All Alerts", 0);
        if (choise == 0) {
            this.rows.clear();
            this.keyMap.clear();
            this.scripList.clear();
            this.unTriggred.clear();
            TotalMessage = 0;
            this.timerMap.clear();
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            this.addSymbolInMarketWatch();
            this.tableDataChange();
            this.readWrite.write(this.rows);
            this.setRecordCount();
        }
    }

    public synchronized Timer Blink(final long idNO, boolean isStart) {
        int rowNo;
        final Timer BlinkTimmer = new Timer(0, null){

            @Override
            public void stop() {
                int rowNo = PriceAlertTab.this.getRowNo(idNO);
                if (rowNo >= 0) {
                    PriceAlertTab.this.rows.get(rowNo).setColor(false);
                    PriceAlertTab.this.tableDataChange();
                    super.stop();
                }
            }
        };
        ActionListener ac = new ActionListener(){
            int i = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.i >= AppConfig.BlinkInterval) {
                    int rowNo = PriceAlertTab.this.getRowNo(idNO);
                    if (rowNo >= 0) {
                        PriceDisplay pd = PriceAlertTab.this.rows.get(rowNo);
                        pd.setColor(true);
                        BlinkTimmer.stop();
                        PriceAlertTab.this.tableDataChange();
                    }
                } else {
                    int rowNo = PriceAlertTab.this.getRowNo(idNO);
                    if (rowNo >= 0) {
                        PriceDisplay pd = PriceAlertTab.this.rows.get(rowNo);
                        if (this.i % 2 == 0) {
                            pd.setColor(false);
                        } else {
                            pd.setColor(true);
                        }
                        PriceAlertTab.this.tableDataChange();
                        ++this.i;
                    }
                }
            }
        };
        if (isStart && (rowNo = this.getRowNo(idNO)) >= 0) {
            PriceAlert pa = this.rows.get((int)rowNo).priceAlert;
            this.unTriggred.remove(pa.id);
            BlinkTimmer.addActionListener(ac);
            BlinkTimmer.setDelay(500);
            BlinkTimmer.setRepeats(true);
        }
        return BlinkTimmer;
    }

    public void stopBlink(int rowNo) {
        PriceAlert pa = this.rows.get((int)rowNo).priceAlert;
        if (this.timerMap.containsKey(pa.id)) {
            this.timerMap.get(pa.id).stop();
        }
    }

    private int getRowNo(long msgID) {
        int rowNo = 0;
        for (int i = 0; i < this.rows.size(); ++i) {
            PriceAlert pa = this.rows.elementAt((int)i).priceAlert;
            if (pa.id != msgID) continue;
            return i;
        }
        return rowNo;
    }

    private void initComponents() {
        this.popupMenuScrollPane = new JPopupMenu();
        this.popupMenuTable = new JPopupMenu();
        this.btnTest = new JButton();
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.toolBar = new JToolBar();
        this.btnSetScripAlert = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.btnSetindicesAlert = new JButton();
        this.collapsiblePane = new JXCollapsiblePane();
        this.popupMenuScrollPane.setName("popupMenuScrollPane");
        this.popupMenuTable.setName("popupMenuTable");
        this.btnTest.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.btnTest.setFocusable(false);
        this.btnTest.setHorizontalTextPosition(0);
        this.btnTest.setMaximumSize(new Dimension(35, 18));
        this.btnTest.setMinimumSize(new Dimension(35, 18));
        this.btnTest.setName("btnTest");
        this.btnTest.setPreferredSize(new Dimension(15, 12));
        this.btnTest.setVerticalTextPosition(3);
        this.btnTest.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PriceAlertTab.this.btnTestMousePressed(evt);
            }
        });
        this.btnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PriceAlertTab.this.btnTestActionPerformed(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.jScrollPane1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PriceAlertTab.this.jScrollPane1MousePressed(evt);
            }
        });
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null}}, new String[]{"Market", "Scrip", "Field", "Operator", "Notification", "Value", "Set Date", "Expire Date", "Status", "Triggered", "Triggered Value"}));
        this.table.setName("table");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                PriceAlertTab.this.tableMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PriceAlertTab.this.tableMousePressed(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PriceAlertTab.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setMaximumSize(new Dimension(116, 21));
        this.toolBar.setMinimumSize(new Dimension(116, 21));
        this.toolBar.setName("toolBar");
        this.toolBar.setPreferredSize(new Dimension(100, 18));
        this.btnSetScripAlert.setIcon(new ImageIcon(this.getClass().getResource("/Images/alert.png")));
        this.btnSetScripAlert.setText("Scrip Alert");
        this.btnSetScripAlert.setFocusable(false);
        this.btnSetScripAlert.setHorizontalTextPosition(4);
        this.btnSetScripAlert.setMaximumSize(new Dimension(85, 18));
        this.btnSetScripAlert.setMinimumSize(new Dimension(85, 18));
        this.btnSetScripAlert.setName("btnSetScripAlert");
        this.btnSetScripAlert.setPreferredSize(new Dimension(85, 18));
        this.btnSetScripAlert.setVerticalTextPosition(3);
        this.btnSetScripAlert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PriceAlertTab.this.btnSetScripAlertActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnSetScripAlert);
        this.jSeparator1.setName("jSeparator1");
        this.toolBar.add(this.jSeparator1);
        this.btnSetindicesAlert.setIcon(new ImageIcon(this.getClass().getResource("/Images/alert.png")));
        this.btnSetindicesAlert.setText("Index Alert");
        this.btnSetindicesAlert.setFocusable(false);
        this.btnSetindicesAlert.setHorizontalTextPosition(4);
        this.btnSetindicesAlert.setMaximumSize(new Dimension(85, 18));
        this.btnSetindicesAlert.setMinimumSize(new Dimension(85, 18));
        this.btnSetindicesAlert.setName("btnSetindicesAlert");
        this.btnSetindicesAlert.setPreferredSize(new Dimension(85, 18));
        this.btnSetindicesAlert.setVerticalTextPosition(3);
        this.btnSetindicesAlert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PriceAlertTab.this.btnSetindicesAlertActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnSetindicesAlert);
        this.collapsiblePane.setName("collapsiblePane");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -1, 328, Short.MAX_VALUE).addComponent((Component)this.collapsiblePane, -1, 328, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 328, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -2, 21, -2).addGap(0, 0, 0).addComponent((Component)this.collapsiblePane, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 61, Short.MAX_VALUE)));
    }

    private void tableMousePressed(MouseEvent evt) {
    }

    private void jScrollPane1MousePressed(MouseEvent evt) {
        this.showPopupMenu(evt, true);
    }

    private void btnSetScripAlertActionPerformed(ActionEvent evt) {
        this.setScripAlert();
    }

    private void btnTestMousePressed(MouseEvent evt) {
    }

    private void btnTestActionPerformed(ActionEvent evt) {
    }

    private void tableMouseMoved(MouseEvent evt) {
        this.point = evt.getPoint();
        rowNumber = this.table.rowAtPoint(this.point);
        try {
            int rowindex = this.table.rowAtPoint(evt.getPoint());
            this.table.editCellAt(rowindex, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void tableMouseExited(MouseEvent evt) {
    }

    private void cbIndicesAlertActionPerformed(ActionEvent evt) {
    }

    private void cbScripAlertActionPerformed(ActionEvent evt) {
    }

    private void btnSetindicesAlertActionPerformed(ActionEvent evt) {
        this.setIndicesAlert();
    }

    public void showPopupMenu(MouseEvent evt, boolean isScollpane) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            if (!this.collapsiblePane.isCollapsed()) {
                this.collapsiblePane.setCollapsed(true);
            }
            if (isScollpane) {
                this.popupMenuScrollPane.show(this.table, evt.getX(), evt.getY());
            } else {
                this.popupMenuTable.show(this.table, evt.getX(), evt.getY());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand().trim();
        if (cmd.equalsIgnoreCase("Set Scrip Alert")) {
            this.setAlert(true);
        }
        if (cmd.equalsIgnoreCase("Set Index Alert")) {
            this.setAlert(false);
        } else if (cmd.equalsIgnoreCase("Edit")) {
            this.editRow();
        } else if (cmd.equalsIgnoreCase("Delete")) {
            this.deleteRow();
        } else if (cmd.equalsIgnoreCase("Delete All")) {
            this.deleteAllRows();
        }
    }

    public int getEstDiff(int calUnit, Date d1, Date d2) {
        long diff = d2.getTime() - d1.getTime();
        if (diff < 0L) {
            return -1;
        }
        switch (calUnit) {
            case 5: 
            case 8: {
                return (int)((double)diff / 8.64054E7 + 0.5);
            }
            case 3: {
                return (int)((double)diff / 6.048378E8 + 0.5);
            }
            case 2: {
                return (int)((double)diff / 2.62989955845E9 + 0.5);
            }
            case 1: {
                return (int)((double)diff / 3.157253316E10 + 0.5);
            }
        }
        return 0;
    }

    private void setAlert(boolean isScrip) {
        boolean state = this.collapsiblePane.isCollapsed();
        if (!state) {
            this.collapsiblePane.setCollapsed(!state);
            return;
        }
        if (!isScrip) {
            this.setIndicesAlert();
        } else if (isScrip) {
            this.setScripAlert();
        }
    }

    private void setScripAlert() {
        boolean state = this.collapsiblePane.isCollapsed();
        if (!state && this.isScripOpen) {
            this.collapsiblePane.setCollapsed(!state);
            return;
        }
        this.collapsiblePane.removeAll();
        this.setPriceAlerts = new SetPriceAlerts(this);
        this.collapsiblePane.add((Component)this.setPriceAlerts);
        this.collapsiblePane.setCollapsed(false);
        this.isScripOpen = true;
        this.repaint();
    }

    private void setIndicesAlert() {
        boolean state = this.collapsiblePane.isCollapsed();
        if (!state && !this.isScripOpen) {
            this.collapsiblePane.setCollapsed(!state);
            return;
        }
        this.collapsiblePane.removeAll();
        this.collapsiblePane.add((Component)new SetIndicesAlert(this));
        this.collapsiblePane.setCollapsed(false);
        this.isScripOpen = false;
        this.repaint();
    }

    private void setOldData() {
        try {
            Vector v = this.readWrite.Read();
            if (v != null) {
                TotalMessage = v.size();
                for (int i = v.size() - 1; i >= 0; --i) {
                    Object obj = v.get(i);
                    if (!(obj instanceof PriceAlert)) continue;
                    PriceAlert priceAlert = (PriceAlert)v.get(i);
                    if (!priceAlert.isIndex) {
                        this.scripSet.add(priceAlert.scrip);
                        this.scripList.put(priceAlert.scrip + priceAlert.id, priceAlert);
                    }
                    try {
                        Date exp = LogsKSE.sdfMessage.parse(priceAlert.expireDate);
                        Date triAt = null;
                        if (!priceAlert.triggeredAt.equalsIgnoreCase("")) {
                            triAt = LogsKSE.sdfMessage.parse(priceAlert.triggeredAt);
                        }
                        if (triAt != null) {
                            Date date = this.myTime.getDate2();
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(date);
                            cal.set(11, 0);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            cal.set(14, 0);
                            date = cal.getTime();
                            cal.setTime(triAt);
                            cal.set(11, 0);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            cal.set(14, 0);
                            triAt = cal.getTime();
                            if (priceAlert.notification.equalsIgnoreCase("Once Only")) {
                                if (exp.compareTo(date) == -1) {
                                    --TotalMessage;
                                    continue;
                                }
                            } else if (priceAlert.notification.equalsIgnoreCase("Once a Day")) {
                                if (triAt.compareTo(date) != 0 && exp.compareTo(date) == -1) {
                                    --TotalMessage;
                                    continue;
                                }
                                if (priceAlert.isTriggered && triAt.compareTo(date) != 0) {
                                    priceAlert.isTriggered = false;
                                }
                            }
                        }
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                    }
                    if (priceAlert.id > SetPriceAlerts.id) {
                        SetPriceAlerts.id = priceAlert.id;
                    }
                    this.addRow(priceAlert);
                }
                this.readWrite.write(this.rows);
                this.tableDataChange();
            }
            this.updateALLRows(true);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public void addSymbolInMarketWatch() {
        this.scripSet.clear();
        Iterator<String> en = this.scripList.keySet().iterator();
        while (en.hasNext()) {
            PriceAlert palert = this.scripList.get(en.next().toString());
            if (UtilKSE.GetMarketFromsymbol((String)palert.scrip).equalsIgnoreCase("FUT")) {
                this.scripSet.add(palert.scrip.split("\\-", -1)[0]);
            }
            this.scripSet.add(palert.scrip);
        }
        String symbols = "";
        LogCommon.PriceAlertScrip = "";
        for (String item : this.scripSet) {
            if (item.equalsIgnoreCase("")) continue;
            symbols = symbols + item + ";";
        }
        String[] symbol = symbols.split(";");
        for (int i = 0; i < symbol.length; ++i) {
            if (symbol[i].equalsIgnoreCase("")) continue;
            LogCommon.PriceAlertScrip = LogCommon.PriceAlertScrip + symbol[i] + ":" + UtilKSE.GetMarketFromsymbol((String)symbol[i]) + ";";
        }
        Mediator.getInstance().sendFeedSymbols("", "Price Alert Tab");
    }

    private void updateALLRows(boolean isDelete) {
        if (isDelete) {
            for (int i = 0; i < this.rows.size(); ++i) {
                PriceDisplay priceDisplay = this.rows.elementAt(i);
                priceDisplay.priceAlert.msgNo = this.rows.size() - i;
                priceDisplay.setText();
            }
        } else {
            for (int i = 0; i < this.rows.size(); ++i) {
                this.rows.elementAt(i).setText();
            }
        }
    }

    public void initForPriceAlert(String scrip, String market) {
        this.isScripOpen = false;
        this.setScripAlert();
        this.setPriceAlerts.setScrip(scrip, market);
    }

    public void setAllScrip() {
        if (this.setPriceAlerts != null) {
            this.setPriceAlerts.setInitData();
        }
    }

    public void setSelectedScrip() {
        if (this.setPriceAlerts != null) {
            this.setPriceAlerts.setSelectedScrip();
        }
    }
}

