/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.PriceAlert;
import MessageWindow.PriceAlertTab;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;
import kse.util.UtilKSE;

public class PriceDisplay
extends JPanel {
    public PriceAlert priceAlert;
    JTable table;
    private final PriceAlertTab priceAlertTab;
    public JEditorPane editorPane;
    private JLabel lblDelete;
    private JLabel lblEdit;

    public PriceDisplay(PriceAlertTab pat, PriceAlert priceAlert) {
        this.priceAlert = priceAlert;
        this.table = pat.table;
        this.priceAlertTab = pat;
        this.initComponents();
        this.lblDelete.setCursor(Cursor.getPredefinedCursor(12));
        this.lblEdit.setCursor(Cursor.getPredefinedCursor(12));
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditorKit(new HTMLEditorKit());
        this.setText();
    }

    public void setText() {
        if (this.priceAlert != null) {
            if (this.priceAlert.isIndex && this.priceAlert.isTriggered) {
                this.setIndexTrigeredText(false);
            } else if (this.priceAlert.isIndex && !this.priceAlert.isTriggered) {
                this.setIndexUnTrigeredText(false);
            } else if (!this.priceAlert.isIndex && this.priceAlert.isTriggered) {
                this.setScripTrigeredText(false);
            } else if (!this.priceAlert.isIndex && !this.priceAlert.isTriggered) {
                this.setScripUnTrigeredText(false);
            }
        }
    }

    void setColor(boolean b) {
        if (this.priceAlert != null) {
            if (this.priceAlert.isIndex) {
                this.setIndexTrigeredText(b);
            } else {
                this.setScripTrigeredText(b);
            }
        }
    }

    private void setScripTrigeredText(boolean isBlink) {
        if (this.priceAlert != null) {
            boolean isInt = false;
            String alertString = this.getAlertString();
            String triggeredText = this.priceAlert.scrip;
            String scripname = this.priceAlert.scrip.split("\\-")[0];
            String marketormonthname = "";
            if (this.priceAlert.scrip.split("\\-").length == 2) {
                marketormonthname = this.priceAlert.scrip.split("\\-")[1];
            }
            if (UtilKSE.MonthName.containsKey(marketormonthname.toUpperCase())) {
                marketormonthname = (String)UtilKSE.MonthName.get(marketormonthname);
            }
            String voiceText = Util.MakeSingleCharacterVoice((String)this.priceAlert.scrip.split("\\-")[0]) + " " + marketormonthname;
            String filed = this.priceAlert.field;
            if (filed.equalsIgnoreCase("Buy Volume")) {
                triggeredText = triggeredText + " buyers volume is ";
                voiceText = voiceText + " buyers volume is ";
                isInt = true;
            } else if (filed.equalsIgnoreCase("Buy")) {
                triggeredText = triggeredText + " buyer at Rs ";
                voiceText = voiceText + " buyer at Rupees";
                isInt = false;
            } else if (filed.equalsIgnoreCase("Sell")) {
                triggeredText = triggeredText + " seller at Rs ";
                voiceText = voiceText + " seller at Rupees ";
                isInt = false;
            } else if (filed.equalsIgnoreCase("Sell Volume")) {
                triggeredText = triggeredText + " sellers volume is ";
                voiceText = voiceText + " sellers volume is ";
                isInt = true;
            } else if (filed.equalsIgnoreCase("Last Price")) {
                triggeredText = triggeredText + " trading at Rs ";
                voiceText = voiceText + " trading at Rupees ";
                isInt = false;
            } else if (filed.equalsIgnoreCase("Total Volume")) {
                triggeredText = triggeredText + " total volume is ";
                voiceText = voiceText + " total volume is ";
                isInt = true;
            } else if (filed.equalsIgnoreCase("High")) {
                triggeredText = triggeredText + " high is Rs ";
                voiceText = voiceText + " high is Rupees ";
                isInt = false;
            } else if (filed.equalsIgnoreCase("Low")) {
                triggeredText = triggeredText + " low is Rs ";
                voiceText = voiceText + " low is Rupees ";
                isInt = false;
            } else if (filed.equalsIgnoreCase("Total Trades")) {
                triggeredText = triggeredText + " total trades are ";
                voiceText = voiceText + " total trades are ";
                isInt = true;
            } else if (filed.equalsIgnoreCase("Change")) {
                triggeredText = triggeredText + " change is Rs ";
                voiceText = voiceText + " change is Rupees ";
                isInt = false;
            } else if (filed.equalsIgnoreCase("Average")) {
                triggeredText = triggeredText + " average price is Rs ";
                voiceText = voiceText + " average price is Rupees ";
                isInt = false;
            } else if (filed.equalsIgnoreCase("Last Trade Volume")) {
                triggeredText = triggeredText + " last volume is ";
                voiceText = voiceText + " last volume is ";
                isInt = true;
            } else if (filed.equalsIgnoreCase("Close Price")) {
                triggeredText = triggeredText + " closing price was Rs ";
                voiceText = voiceText + " closing price was Rupees ";
                isInt = false;
            } else if (filed.equalsIgnoreCase("Spread")) {
                triggeredText = triggeredText + " spread price was Rs ";
                voiceText = voiceText + " spread price was Rupees ";
                isInt = true;
            } else if (filed.equalsIgnoreCase("Spread %")) {
                triggeredText = triggeredText + " spread % at ";
                voiceText = voiceText + " spread % at ";
                isInt = true;
            }
            String value = "";
            if (isInt) {
                value = Util.format0digit((String)this.priceAlert.value);
                triggeredText = triggeredText + Util.format0digit((String)this.priceAlert.triggeredValue);
                voiceText = voiceText + Util.format0digit((String)this.priceAlert.triggeredValue);
            } else {
                value = "PKR. " + Util.format2digit((String)this.priceAlert.value) + "/-";
                triggeredText = triggeredText + Util.format2digit((String)this.priceAlert.triggeredValue) + "/-";
                voiceText = voiceText + this.priceAlert.triggeredValue;
            }
            this.priceAlert.VoiceText = voiceText;
            this.priceAlert.triggeredText = triggeredText;
            String color = "";
            color = isBlink ? Integer.toHexString(Color.YELLOW.getRGB() & 0xFFFFFF) : Integer.toHexString(new Color(192, 252, 178).getRGB() & 0xFFFFFF);
            String scripname_ = this.priceAlert.scripName;
            if (scripname_.length() > 0) {
                scripname_ = "(" + scripname_ + ")";
            }
            String HtmlText = "<table width='100%' border='0px' cellpadding ='0px' cellspacing='0px'><tr style='height:15px; background-color:#" + color + "'><td width='90%' style='margin:2px; padding-left:2px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b> " + this.priceAlert.market + " " + this.priceAlert.scrip + " " + scripname_ + "</b></font><font style='color:#999999 ; font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' > (Triggered)</font></td><td nowrap='nowrap' color='#000000' valign=top style='text-align:right;margin:3px; padding-right:3px;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.priceAlert.setDate + " | " + this.priceAlert.msgNo + " of " + PriceAlertTab.TotalMessage + "</font></td></tr><tr><td colspan=2 style='font-family: Tahoma, Tahoma; font-size:11pt;margin:2px; padding-left:2px;font-weight:bold; HEIGHT: 19px'>" + this.priceAlert.triggeredText + "</td></tr><tr><td colspan=2 style='color:#999999 ; font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal;margin:2px; padding-left:2px;'><table width=100%><tr><td width=20%><b>Parameters: </b></td><td width=33%>Field: <b>" + this.priceAlert.field + "</b></td><td width=33%>Operation: <b>" + this.priceAlert.operator + "</b></td><td width=33%>Value: <b>" + value + "</b></td></tr><tr><td width=20%></td><td width=33%>Notification: <b>" + this.priceAlert.notification + "</b></td><td width=33%>" + alertString + "</td><td width=33%>Expiry: <b>" + this.priceAlert.expireDate.split("\\|")[0] + "</b></td></tr></table></td></tr></table>";
            this.editorPane.setText(HtmlText);
            this.tableDataChange();
        }
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PriceDisplay.this.table.addNotify();
                    PriceDisplay.this.table.repaint();
                }
            });
        }
    }

    private void setScripUnTrigeredText(boolean isNewLine) {
        if (this.priceAlert != null) {
            boolean isInt = false;
            String alertString = this.getAlertString();
            String filed = this.priceAlert.field;
            if (filed.equalsIgnoreCase("Buy Volume")) {
                isInt = true;
            } else if (filed.equalsIgnoreCase("Buy")) {
                isInt = false;
            } else if (filed.equalsIgnoreCase("Sell")) {
                isInt = false;
            } else if (filed.equalsIgnoreCase("Sell Volume")) {
                isInt = true;
            } else if (filed.equalsIgnoreCase("Last Price")) {
                isInt = false;
            } else if (filed.equalsIgnoreCase("Total Volume")) {
                isInt = true;
            } else if (filed.equalsIgnoreCase("High")) {
                isInt = false;
            } else if (filed.equalsIgnoreCase("Low")) {
                isInt = false;
            } else if (filed.equalsIgnoreCase("Total Trades")) {
                isInt = true;
            } else if (filed.equalsIgnoreCase("Change")) {
                isInt = false;
            } else if (filed.equalsIgnoreCase("Average")) {
                isInt = false;
            } else if (filed.equalsIgnoreCase("Last Trade Volume")) {
                isInt = true;
            } else if (filed.equalsIgnoreCase("Close Price")) {
                isInt = false;
            }
            String value = "";
            value = isInt ? Util.format0digit((String)this.priceAlert.value) : "PKR " + Util.format2digit((String)this.priceAlert.value) + "/-";
            String topHeaderColor = Integer.toHexString(new Color(161, 161, 161).getRGB() & 0xFFFFFF);
            String lowerBoxcolor = Integer.toHexString(new Color(255, 255, 255).getRGB() & 0xFFFFFF);
            String topHeaderFontColor = Integer.toHexString(new Color(111, 111, 111).getRGB() & 0xFFFFFF);
            String lowerBoxfontColor = Integer.toHexString(new Color(164, 164, 164).getRGB() & 0xFFFFFF);
            String scripname_ = this.priceAlert.scripName;
            if (scripname_.length() > 0) {
                scripname_ = "(" + scripname_ + ")";
            }
            String HtmlText = "<table width='100%' border='0px' cellpadding ='0px' cellspacing='0px' bgcolor='" + lowerBoxcolor + "'><tr style='height:15px; background-color:#" + topHeaderColor + "'><td width='90%' style='margin:2px; padding-left:2px;' color='#" + topHeaderFontColor + "'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b> " + this.priceAlert.market + " " + this.priceAlert.scrip + " " + scripname_ + "</b></font></td><td nowrap='nowrap' color='#" + topHeaderFontColor + "' valign=top style='text-align:right;margin:3px; padding-right:3px;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.priceAlert.setDate + " | " + this.priceAlert.msgNo + " of " + PriceAlertTab.TotalMessage + "</font></td></tr><tr><td colspan=2 style='color:#000000; font-family: Tahoma, Tahoma; font-size:11pt;margin:2px; padding-left:2px;font-weight:bold; HEIGHT: 19px'> Un Triggered </td></tr><tr><td colspan=2 style='color:#" + lowerBoxfontColor + " ; font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal;margin:2px; padding-left:2px;'><table width=100%><tr><td width=20% style='color:#" + lowerBoxfontColor + " ;'><b>Parameters: </b></td><td width=33% style='color:#" + lowerBoxfontColor + " ;'>Field: <b>" + this.priceAlert.field + "</b></td><td width=33% style='color:#" + lowerBoxfontColor + " ;'>Operation: <b>" + this.priceAlert.operator + "</b></td><td width=33% style='color:#" + lowerBoxfontColor + " ;'>Value: <b>" + value + "</b></td></tr><tr><td width=20%></td><td width=33% style='color:#" + lowerBoxfontColor + " ;'>Notification: <b>" + this.priceAlert.notification + "</b></td><td width=33% style='color:#" + lowerBoxfontColor + " ;'>" + alertString + "</td><td width=33% style='color:#" + lowerBoxfontColor + " ;'>Expiry: <b>" + this.priceAlert.expireDate.split("\\|")[0] + "</b></td></tr></table></td></tr></table>";
            this.editorPane.setText(HtmlText);
            this.tableDataChange();
        }
    }

    private void setIndexTrigeredText(boolean isBlink) {
        if (this.priceAlert != null) {
            boolean isInt = false;
            String alertString = this.getAlertString();
            String filed = this.priceAlert.field;
            isInt = filed.equalsIgnoreCase("Volume");
            String triggeredText = "";
            String voiceText = "";
            if (filed.equalsIgnoreCase("Index")) {
                triggeredText = this.priceAlert.index + " Index is " + Util.format2digit((String)this.priceAlert.triggeredValue) + " points";
                voiceText = this.priceAlert.index + " Index is " + Util.format2digit((String)this.priceAlert.triggeredValue);
            } else if (filed.equalsIgnoreCase("Change")) {
                triggeredText = this.priceAlert.index + " Change is " + Util.format2digit((String)this.priceAlert.triggeredValue) + " points";
                voiceText = this.priceAlert.index + " Change is " + Util.format2digit((String)this.priceAlert.triggeredValue);
            } else if (filed.equalsIgnoreCase("Volume")) {
                String Value_ = UtilKSE.getFormattedValue((String)this.priceAlert.triggeredValue, (String)"###");
                triggeredText = this.priceAlert.index + " Volume is " + Util.inMillion((long)Long.parseLong(Value_));
                voiceText = this.priceAlert.index + " Volume is " + Util.inMillion((long)Long.parseLong(Value_)).replaceAll("m", " ") + "million";
            } else if (filed.equalsIgnoreCase("Value")) {
                triggeredText = this.priceAlert.index + " Value is " + Util.format0digit((String)this.priceAlert.triggeredValue);
                voiceText = this.priceAlert.index + " Value is " + Util.format0digit((String)this.priceAlert.triggeredValue);
            }
            this.priceAlert.triggeredText = triggeredText;
            this.priceAlert.VoiceText = voiceText;
            String value = "";
            value = isInt ? Util.format0digit((String)this.priceAlert.value) : Util.format2digit((String)this.priceAlert.value);
            String color = "";
            color = isBlink ? Integer.toHexString(Color.YELLOW.getRGB() & 0xFFFFFF) : Integer.toHexString(new Color(192, 252, 178).getRGB() & 0xFFFFFF);
            String HtmlText = "<table width='100%' border='0px' cellpadding ='0px' cellspacing='0px'><tr style='height:15px; background-color:#" + color + "'><td width='90%' style='margin:2px; padding-left:2px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b> " + this.priceAlert.index + "</b></font><font style='color:#999999 ; font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' > (Triggered)</font></td><td nowrap='nowrap' color='#000000' valign=top style='text-align:right;margin:3px; padding-right:3px;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.priceAlert.setDate + " | " + this.priceAlert.msgNo + " of " + PriceAlertTab.TotalMessage + "</font></td></tr><tr><td colspan=2 style='font-family: Tahoma, Tahoma; font-size:11pt;margin:2px; padding-left:2px;font-weight:bold; HEIGHT: 19px'>" + this.priceAlert.triggeredText + "</td></tr><tr><td colspan=2 style='color:#999999 ; font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal;margin:2px; padding-left:2px;'><table width=100%><tr><td width=20%><b>Parameters: </b></td><td width=33%>Field: </b>" + this.priceAlert.field + "</b></td><td width=33%>Operation: <b>" + this.priceAlert.operator + "</b></td><td width=33%>Value: <b>" + value + "</b></td></tr><tr><td width=20%></td><td width=33%>Notification: <b>" + this.priceAlert.notification + "</b></td><td width=33%>" + alertString + "</td><td width=33%>Expiry: <b>" + this.priceAlert.expireDate.split("\\|")[0] + "</b></td></tr></table></td></tr></table>";
            this.editorPane.setText(HtmlText);
            this.tableDataChange();
        }
    }

    private void setIndexUnTrigeredText(boolean isNewLine) {
        if (this.priceAlert != null) {
            boolean rs = false;
            boolean isInt = false;
            String alertString = this.getAlertString();
            String filed = this.priceAlert.field;
            isInt = filed.equalsIgnoreCase("Volume");
            String value = "";
            value = isInt ? Util.format0digit((String)this.priceAlert.value) : Util.format2digit((String)this.priceAlert.value);
            String topHeaderColor = Integer.toHexString(new Color(161, 161, 161).getRGB() & 0xFFFFFF);
            String lowerBoxcolor = Integer.toHexString(new Color(255, 255, 255).getRGB() & 0xFFFFFF);
            String topHeaderFontColor = Integer.toHexString(new Color(111, 111, 111).getRGB() & 0xFFFFFF);
            String lowerBoxfontColor = Integer.toHexString(new Color(164, 164, 164).getRGB() & 0xFFFFFF);
            String HtmlText = "<table width='100%' border='0px' cellpadding ='0px' cellspacing='0px' bgcolor='" + lowerBoxcolor + "'><tr style='height:15px; background-color:#" + topHeaderColor + "'><td width='90%' style='margin:2px; padding-left:2px;' color='#" + topHeaderFontColor + "'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b> " + this.priceAlert.index + "</b></font></td><td nowrap='nowrap' color='#" + topHeaderFontColor + "' valign=top style='text-align:right;margin:3px; padding-right:3px;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.priceAlert.setDate + " | " + this.priceAlert.msgNo + " of " + PriceAlertTab.TotalMessage + "</font></td></tr><tr><td colspan=2 style='color:#000000; font-family: Tahoma, Tahoma; font-size:11pt;margin:2px; padding-left:2px;font-weight:bold; HEIGHT: 19px'> Un Triggered </td></tr><tr><td colspan=2 style='color:#" + lowerBoxfontColor + " ; font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal;margin:2px; padding-left:2px;'><table width=100%><tr><td width=20% style='color:#" + lowerBoxfontColor + " ;'><b>Parameters: </b></td><td width=33% style='color:#" + lowerBoxfontColor + " ;'>Field: <b>" + this.priceAlert.field + "</b></td><td width=33% style='color:#" + lowerBoxfontColor + " ;'>Operation: <b>" + this.priceAlert.operator + "</b></td><td width=33% style='color:#" + lowerBoxfontColor + " ;'>Value: <b>" + value + "</b></td></tr><tr><td width=20%></td><td width=33% style='color:#" + lowerBoxfontColor + " ;'>Notification: <b>" + this.priceAlert.notification + "</b></td><td width=33% style='color:#" + lowerBoxfontColor + " ;'>" + alertString + "</td><td width=33% style='color:#" + lowerBoxfontColor + " ;'>Expiry: <b>" + this.priceAlert.expireDate.split("\\|")[0] + "</b></td></tr></table></td></tr></table>";
            this.editorPane.setText(HtmlText);
            this.tableDataChange();
        }
    }

    private void initComponents() {
        this.editorPane = new JEditorPane();
        this.lblDelete = new JLabel();
        this.lblEdit = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.editorPane.setEditable(false);
        this.editorPane.setText("hjgkh kjgjkg kjgk kjgk kjgk kjgk gkgk kjg kujhgikg kg kgk k jgkjgk gkjg kjg");
        this.editorPane.setMaximumSize(new Dimension(500, 200));
        this.editorPane.setMinimumSize(new Dimension(106, 200));
        this.editorPane.setPreferredSize(new Dimension(500, 200));
        this.editorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PriceDisplay.this.editorPaneMousePressed(evt);
            }
        });
        this.lblDelete.setFont(new Font("Tahoma", 0, 10));
        this.lblDelete.setForeground(new Color(153, 153, 153));
        this.lblDelete.setText("| Delete");
        this.lblDelete.setVerticalAlignment(1);
        this.lblDelete.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PriceDisplay.this.lblDeleteMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PriceDisplay.this.lblDeleteMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PriceDisplay.this.lblDeleteMousePressed(evt);
            }
        });
        this.lblEdit.setFont(new Font("Tahoma", 0, 10));
        this.lblEdit.setForeground(new Color(153, 153, 153));
        this.lblEdit.setHorizontalAlignment(4);
        this.lblEdit.setText("Edit ");
        this.lblEdit.setVerticalAlignment(1);
        this.lblEdit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PriceDisplay.this.lblEditMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PriceDisplay.this.lblEditMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PriceDisplay.this.lblEditMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(102, 102, 102).addComponent(this.lblEdit, -2, 40, -2).addGap(0, 0, 0).addComponent(this.lblDelete, -2, 40, -2)).addComponent(this.editorPane, GroupLayout.Alignment.TRAILING, -1, 182, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.editorPane, -2, 19, Short.MAX_VALUE).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDelete).addComponent(this.lblEdit))));
    }

    private void editorPaneMousePressed(MouseEvent evt) {
        this.priceAlertTab.stopBlink(PriceAlertTab.rowNumber);
        this.setText();
        this.priceAlertTab.showPopupMenu(evt, false);
    }

    private void lblDeleteMousePressed(MouseEvent evt) {
        this.priceAlertTab.deleteRow();
    }

    private void lblEditMousePressed(MouseEvent evt) {
        this.priceAlertTab.editRow();
    }

    private void lblEditMouseEntered(MouseEvent evt) {
        this.lblEdit.setForeground(MyColors.tabPaneselectedForeground);
    }

    private void lblEditMouseExited(MouseEvent evt) {
        this.lblEdit.setForeground(new Color(153, 153, 153));
    }

    private void lblDeleteMouseEntered(MouseEvent evt) {
        this.lblDelete.setForeground(MyColors.tabPaneselectedForeground);
    }

    private void lblDeleteMouseExited(MouseEvent evt) {
        this.lblDelete.setForeground(new Color(153, 153, 153));
    }

    private String getAlertString() {
        String alertType = "Alert: <b>";
        if (this.priceAlert != null) {
            if (this.priceAlert.isDesktopAlert) {
                alertType = alertType + "Desktop Alert";
            }
            if (this.priceAlert.isVoice) {
                alertType = alertType + ", Voice";
            }
            if (this.priceAlert.isSMS) {
                alertType = alertType + "and SMS";
            }
        }
        alertType = alertType + "</b>";
        return alertType;
    }
}

