/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.MarginCallTab;
import MessageWindow.MessageDisplay;
import MessageWindow.SearchNotFound;
import MessageWindow.ShowMarginCallSearchResult;
import MyDocking.TradeCast;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import kse.gui.bean.MarginCallBean;

public class SearchPanelMarginCall
extends JPanel {
    private ShowMarginCallSearchResult showMarginCallSearchResult = null;
    private MarginCallTab marginCallTab;
    private final String MarginCallType = "First Margin Call|Second Margin Call|Final Margin Call";
    private JButton btnGo;
    private ButtonGroup buttonGroup1;
    private JComboBox cbAccount;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel lblMessage;
    private JRadioButton rbAccount;
    private JRadioButton rbCallType;
    private JRadioButton rbName;

    public SearchPanelMarginCall(MarginCallTab mt) {
        this.initComponents();
        this.marginCallTab = mt;
        this.setValues();
    }

    public SearchPanelMarginCall(ShowMarginCallSearchResult sp, MarginCallTab mt) {
        this.showMarginCallSearchResult = sp;
        this.marginCallTab = mt;
        this.setValues();
    }

    private void setValues() {
        this.initComponents();
        this.cbAccount.setModel(new DefaultComboBoxModel<Object>(this.marginCallTab.accountSet.toArray()));
    }

    public void callSearch() {
        int i;
        this.lblMessage.setText(" ");
        if (this.rbAccount.isSelected()) {
            if (this.cbAccount.getSelectedItem() == null) {
                this.lblMessage.setText("Please select Account");
                this.cbAccount.requestFocus();
                return;
            }
        } else if (this.rbName.isSelected()) {
            if (this.cbAccount.getSelectedItem() == null) {
                this.lblMessage.setText("Please select Name");
                this.cbAccount.requestFocus();
                return;
            }
        } else if (this.rbCallType.isSelected() && this.cbAccount.getSelectedItem() == null) {
            this.lblMessage.setText("Please select Call Type");
            this.cbAccount.requestFocus();
            return;
        }
        Vector<MessageDisplay> temp = new Vector<MessageDisplay>();
        String find = this.cbAccount.getSelectedItem().toString();
        if (this.rbAccount.isSelected()) {
            for (i = 0; i < this.marginCallTab.rows.size(); ++i) {
                MessageDisplay md = this.marginCallTab.rows.get(i);
                if (!md.margin.account.equalsIgnoreCase(find)) continue;
                MarginCallBean mar = md.margin;
                MessageDisplay display = new MessageDisplay(this.marginCallTab, mar, this.marginCallTab.table, this.marginCallTab.type, this.marginCallTab.rows);
                temp.add(display);
            }
        } else if (this.rbName.isSelected()) {
            for (i = 0; i < this.marginCallTab.rows.size(); ++i) {
                MessageDisplay md = this.marginCallTab.rows.get(i);
                if (md.margin.name.indexOf(find) != 0) continue;
                MarginCallBean mar = md.margin;
                MessageDisplay display = new MessageDisplay(this.marginCallTab, mar, this.marginCallTab.table, this.marginCallTab.type, this.marginCallTab.rows);
                temp.add(display);
            }
        } else if (this.rbCallType.isSelected()) {
            for (i = 0; i < this.marginCallTab.rows.size(); ++i) {
                MessageDisplay md = this.marginCallTab.rows.get(i);
                if (md.margin.call.indexOf(find) != 0) continue;
                MarginCallBean mar = md.margin;
                MessageDisplay display = new MessageDisplay(this.marginCallTab, mar, this.marginCallTab.table, this.marginCallTab.type, this.marginCallTab.rows);
                temp.add(display);
            }
        }
        if (temp.size() <= 0) {
            SearchNotFound ss = new SearchNotFound((Frame)TradeCast.getInstance().frame, true, find);
            ss.setVisible(true);
        } else if (this.showMarginCallSearchResult != null) {
            this.showMarginCallSearchResult.setSearchResult(temp);
        } else {
            ShowMarginCallSearchResult showSearchResult = new ShowMarginCallSearchResult(this.marginCallTab, TradeCast.getInstance().frame, false);
            showSearchResult.setVisible(true);
            showSearchResult.setSearchResult(temp);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.lblMessage = new JLabel();
        this.btnGo = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.rbAccount = new JRadioButton();
        this.rbName = new JRadioButton();
        this.cbAccount = new JComboBox();
        this.rbCallType = new JRadioButton();
        this.btnGo.setText("Go");
        this.btnGo.setName("SearchPanelMarginCall -> btnGo");
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanelMarginCall.this.btnGoActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Find what");
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.jLabel4.setText("Search:");
        this.buttonGroup1.add(this.rbAccount);
        this.rbAccount.setSelected(true);
        this.rbAccount.setText("Account");
        this.rbAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanelMarginCall.this.rbAccountActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbName);
        this.rbName.setText("Name");
        this.rbName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanelMarginCall.this.rbNameActionPerformed(evt);
            }
        });
        this.cbAccount.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbAccount.setMaximumSize(new Dimension(75, 20));
        this.cbAccount.setMinimumSize(new Dimension(75, 20));
        this.cbAccount.setPreferredSize(new Dimension(75, 20));
        this.buttonGroup1.add(this.rbCallType);
        this.rbCallType.setText("Call Type");
        this.rbCallType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanelMarginCall.this.rbCallTypeActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbAccount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbCallType).addGap(14, 14, 14).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbAccount, -2, 117, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMessage, -1, 134, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -2, 20, -2).addComponent(this.rbAccount).addComponent(this.rbName).addComponent(this.rbCallType).addComponent(this.cbAccount, -2, 20, -2).addComponent(this.jLabel2).addComponent(this.btnGo, -2, 12, -2)).addComponent(this.lblMessage, -2, 23, -2));
        layout.linkSize(1, this.btnGo, this.cbAccount);
    }

    private void btnGoActionPerformed(ActionEvent evt) {
        this.callSearch();
    }

    private void rbNameActionPerformed(ActionEvent evt) {
        this.cbAccount.setModel(new DefaultComboBoxModel<Object>(this.marginCallTab.nameSet.toArray()));
    }

    private void rbAccountActionPerformed(ActionEvent evt) {
        this.cbAccount.setModel(new DefaultComboBoxModel<Object>(this.marginCallTab.accountSet.toArray()));
    }

    private void rbCallTypeActionPerformed(ActionEvent evt) {
        this.cbAccount.setModel(new DefaultComboBoxModel<String>("First Margin Call|Second Margin Call|Final Margin Call".split("\\|")));
    }
}

