/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import CustomComponent.MyTime;
import MessageWindow.AnnouncementLiveTab;
import MessageWindow.AnnouncementTab;
import MessageWindow.BoardMeetingTab;
import MessageWindow.MyTab;
import MessageWindow.SearchNotFound;
import MessageWindow.ShowAnnouncementSearchResult;
import MessageWindow.ShowSearchResult;
import MyDocking.TradeCast;
import Utilities.CompressManager;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.JTextFieldFilter;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import languages.LanguageConstant;
import login.LoginServer;
import org.jdesktop.swingx.JXDatePicker;

public class SearchPanelScrip
extends JPanel {
    java.util.Date date = MyTime.getInstance().getDate2();
    private String type;
    private LoginServer port = null;
    private MyTab myTab;
    private ShowSearchResult sp = null;
    private AnnouncementTab announcementTab;
    private AnnouncementLiveTab announcementLiveTab;
    private ShowAnnouncementSearchResult showAnnouncementSearchResult;
    private BoardMeetingTab boardMeetingTab;
    AutoCompleteSupport support = null;
    private JButton btnGo;
    private ButtonGroup buttonGroup1;
    private JComboBox cbScrip;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel lblMessage;
    private JRadioButton rbFindWhat;
    private JRadioButton rbScrip;
    private JTextField txtFind;
    private JXDatePicker txtFromDate;
    private JXDatePicker txtToDate;

    public SearchPanelScrip(MyTab myTab, String type) {
        this.myTab = myTab;
        this.type = type;
        if (type.equalsIgnoreCase("Board Meetings")) {
            this.type = "Board_Meeting";
        }
        this.setValues();
    }

    public SearchPanelScrip(ShowSearchResult sp, MyTab myTab, String type) {
        this.sp = sp;
        this.myTab = myTab;
        this.type = type;
        if (type.equalsIgnoreCase("Board Meetings")) {
            this.type = "Board_Meeting";
        }
        this.setValues();
    }

    public SearchPanelScrip(AnnouncementTab announcementTab, String type) {
        this.announcementTab = announcementTab;
        this.type = type;
        this.setValues();
    }

    public SearchPanelScrip(AnnouncementLiveTab announcementLiveTab, String type) {
        this.announcementLiveTab = announcementLiveTab;
        this.type = type;
        this.setValues();
    }

    public SearchPanelScrip(ShowAnnouncementSearchResult showAnnouncementSearchResult, AnnouncementTab announcementTab, String type) {
        this.announcementTab = announcementTab;
        this.showAnnouncementSearchResult = showAnnouncementSearchResult;
        this.type = type;
        if (type.equalsIgnoreCase("BOARD_MEETING")) {
            this.type = "Board_Meeting";
        }
        this.setValues();
    }

    public SearchPanelScrip(ShowAnnouncementSearchResult showAnnouncementSearchResult, AnnouncementLiveTab announcementLiveTab, String type) {
        this.announcementLiveTab = announcementLiveTab;
        this.showAnnouncementSearchResult = showAnnouncementSearchResult;
        this.type = type;
        if (type.equalsIgnoreCase("Board Meetings")) {
            this.type = "Board_Meeting";
        }
        this.setValues();
    }

    public SearchPanelScrip(ShowSearchResult sp, BoardMeetingTab boardMeetingTab, String type) {
        this.sp = sp;
        this.boardMeetingTab = boardMeetingTab;
        this.type = type;
        if (type.equalsIgnoreCase("Board Meetings")) {
            this.type = "Board_Meeting";
        }
        this.setValues();
    }

    private boolean isValidInput() {
        boolean status = false;
        this.lblMessage.setText(" ");
        String find = this.txtFind.getText();
        String scrip = "";
        if (this.cbScrip.getSelectedItem() != null) {
            scrip = this.cbScrip.getSelectedItem().toString();
        }
        if (this.txtFromDate.getDate() == null) {
            this.lblMessage.setText("Please select From date");
            this.txtFromDate.requestFocus();
            return status;
        }
        if (this.txtToDate.getDate() == null) {
            this.lblMessage.setText("Please select To date");
            this.txtToDate.requestFocus();
            return status;
        }
        if (find.trim().length() <= 0 && this.rbFindWhat.isSelected()) {
            this.lblMessage.setText("Please enter text for search");
            this.txtFind.requestFocus();
            return status;
        }
        if (scrip.trim().length() <= 0 && this.rbScrip.isSelected()) {
            this.lblMessage.setText("Please select scrip for search");
            this.cbScrip.requestFocus();
            return status;
        }
        if (!this.txtFromDate.getDate().before(this.txtToDate.getDate()) && this.txtFromDate.getDate().compareTo(this.txtToDate.getDate()) != 0) {
            this.lblMessage.setText(" ");
            JOptionPane.showMessageDialog(this, "From date should be greater then or equal To date.", "Wrong Date", 2);
            this.txtFromDate.requestFocus();
            return status;
        }
        status = true;
        return status;
    }

    private boolean isValidInputForBoardMeeting() {
        boolean status = false;
        this.lblMessage.setText(" ");
        if (this.txtFromDate.getDate() == null) {
            this.lblMessage.setText("Please select From date");
            this.txtFromDate.requestFocus();
            return status;
        }
        if (this.txtToDate.getDate() == null) {
            this.lblMessage.setText("Please select To date");
            this.txtToDate.requestFocus();
            return status;
        }
        if (!this.txtFromDate.getDate().before(this.txtToDate.getDate()) && this.txtFromDate.getDate().compareTo(this.txtToDate.getDate()) != 0) {
            this.lblMessage.setText(" ");
            JOptionPane.showMessageDialog(this, "From date should be greater then or equal To date.", "Wrong Date", 2);
            this.txtFromDate.requestFocus();
            return status;
        }
        status = true;
        return status;
    }

    private void setValues() {
        if (this.port == null) {
            try {
                this.port = WebService.getInstance().getPort();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.initComponents();
        this.txtFromDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtFromDate.setDate(this.date);
        this.txtToDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtToDate.setDate(this.date);
        this.txtFind.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 ", 70));
        this.setDate();
    }

    public void callMyTabSearch() {
        if (this.isValidInput()) {
            String toDate;
            String find = this.txtFind.getText();
            String fromDate = new Date(this.txtFromDate.getDate().getTime()) + "";
            String result = CompressManager.unzipStringFromBytes(this.port.userMessagesSearch(fromDate, toDate = new Date(this.txtToDate.getDate().getTime()) + "", find, this.type, LogCommon.UserID));
            if (result.equalsIgnoreCase("No Record(s) found") || result.trim().length() <= 1) {
                SearchNotFound ss = new SearchNotFound((Frame)TradeCast.getInstance().frame, true, find);
                ss.setVisible(true);
            } else if (this.sp != null) {
                this.sp.addAllDataWithoutBlink(result, find);
                this.sp.requestFocus();
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
            } else {
                ShowSearchResult showSearchResult = new ShowSearchResult(this.myTab, TradeCast.getInstance().frame, false, this.type);
                showSearchResult.addAllDataWithoutBlink(result, find);
                showSearchResult.setVisible2(true);
                showSearchResult.requestFocus();
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
            }
        }
    }

    public void callBoardMeetingTabSearch() {
        if (this.isValidInputForBoardMeeting()) {
            String toDate;
            String fromDate;
            String result;
            String find = this.txtFind.getText();
            if (this.rbScrip.isSelected()) {
                find = "OnlyScrip" + this.cbScrip.getSelectedItem().toString();
            }
            if ((result = CompressManager.unzipStringFromBytes(this.port.userMessagesSearch(fromDate = new Date(this.txtFromDate.getDate().getTime()) + "", toDate = new Date(this.txtToDate.getDate().getTime()) + "", find, "BOARD_MEETING", LogCommon.UserID))).equalsIgnoreCase("No Record(s) found") || result.trim().length() <= 1) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                SearchNotFound ss = new SearchNotFound((Frame)TradeCast.getInstance().frame, true, find.replaceAll("OnlyScrip", ""));
                ss.setVisible(true);
            } else if (this.sp != null) {
                this.sp.addBoardMeetingData(result, find.replaceAll("OnlyScrip", ""));
                this.sp.requestFocus();
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
            } else {
                ShowSearchResult showSearchResult = new ShowSearchResult(this.boardMeetingTab, TradeCast.getInstance().frame, false, this.type);
                showSearchResult.addBoardMeetingData(result, find.replaceAll("OnlyScrip", ""));
                showSearchResult.setVisible2(true);
                showSearchResult.requestFocus();
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
            }
        }
    }

    private void callAnnouncementTabSearch() {
        if (this.isValidInput()) {
            final String find = this.rbScrip.isSelected() ? "OnlyScrip" + this.cbScrip.getSelectedItem().toString() : this.txtFind.getText();
            String fromDate = new Date(this.txtFromDate.getDate().getTime()) + "";
            String toDate = new Date(this.txtToDate.getDate().getTime()) + "";
            final String result = CompressManager.unzipStringFromBytes(this.port.userMessagesSearch(fromDate, toDate, find, this.type, LogCommon.UserID));
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
            if (result.equalsIgnoreCase("No Record(s) found") || result.trim().length() <= 1) {
                SearchNotFound ss = new SearchNotFound((Frame)TradeCast.getInstance().frame, true, find.replaceAll("OnlyScrip", ""));
                ss.setVisible(true);
            } else if (this.showAnnouncementSearchResult != null) {
                if (this.announcementTab != null) {
                    this.showAnnouncementSearchResult.addAllData(result, find.replaceAll("OnlyScrip", ""));
                } else if (this.announcementLiveTab != null) {
                    this.showAnnouncementSearchResult.addAllDataLive(result, find.replaceAll("OnlyScrip", ""));
                }
                this.showAnnouncementSearchResult.requestFocus();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ShowAnnouncementSearchResult showSearchResult = null;
                            if (SearchPanelScrip.this.announcementTab != null) {
                                showSearchResult = new ShowAnnouncementSearchResult(SearchPanelScrip.this.announcementTab, TradeCast.getInstance().frame, false, SearchPanelScrip.this.type);
                                showSearchResult.setVisible(true);
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException ex) {
                                    Logger.getLogger(SearchPanelScrip.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                showSearchResult.addAllData(result, find.replaceAll("OnlyScrip", ""));
                            }
                            if (SearchPanelScrip.this.announcementLiveTab != null) {
                                showSearchResult = new ShowAnnouncementSearchResult(SearchPanelScrip.this.announcementLiveTab, TradeCast.getInstance().frame, false, SearchPanelScrip.this.type);
                                showSearchResult.setVisible(true);
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException ex) {
                                    Logger.getLogger(SearchPanelScrip.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                showSearchResult.addAllDataLive(result, find.replaceAll("OnlyScrip", ""));
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.lblMessage = new JLabel();
        this.txtFind = new JTextField();
        this.btnGo = new JButton();
        this.jLabel1 = new JLabel();
        this.txtFromDate = new JXDatePicker();
        this.jLabel2 = new JLabel();
        this.txtToDate = new JXDatePicker();
        this.jLabel4 = new JLabel();
        this.cbScrip = new JComboBox();
        this.rbFindWhat = new JRadioButton();
        this.rbScrip = new JRadioButton();
        this.lblMessage.setText(" ");
        this.txtFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanelScrip.this.txtFindActionPerformed(evt);
            }
        });
        this.txtFind.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SearchPanelScrip.this.txtFindFocusGained(evt);
            }
        });
        this.btnGo.setText("Go");
        this.btnGo.setName("SearchPanelScrip -> btnGo");
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanelScrip.this.btnGoActionPerformed(evt);
            }
        });
        this.jLabel1.setText("From");
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy");
        String today = formatter.format(this.date);
        this.txtFromDate.setLinkDay(new java.util.Date(System.currentTimeMillis()), "Today is " + today);
        this.jLabel2.setText("   To");
        SimpleDateFormat formatter2 = new SimpleDateFormat("MMM dd, yyyy");
        String today2 = formatter2.format(this.date);
        this.txtToDate.setLinkDay(new java.util.Date(System.currentTimeMillis()), "Today is " + today2);
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.jLabel4.setText("Search:");
        this.cbScrip.setEditable(true);
        this.cbScrip.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbScrip.setEnabled(false);
        this.cbScrip.setMinimumSize(new Dimension(98, 18));
        this.buttonGroup1.add(this.rbFindWhat);
        this.rbFindWhat.setSelected(true);
        this.rbFindWhat.setText("Find what");
        this.rbFindWhat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanelScrip.this.rbFindWhatActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbScrip);
        this.rbScrip.setText("Scrip");
        this.rbScrip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanelScrip.this.rbScripActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtFromDate, -2, 92, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtToDate, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbFindWhat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtFind, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbScrip).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbScrip, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMessage, -1, 13, Short.MAX_VALUE)));
        layout.linkSize(0, new Component[]{this.txtFromDate, this.txtToDate});
        layout.linkSize(0, this.cbScrip, this.txtFind);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -2, 18, -2).addComponent((Component)this.txtFromDate, -2, 20, -2).addComponent(this.jLabel1, -2, 18, -2).addComponent(this.jLabel2, -2, 18, -2).addComponent((Component)this.txtToDate, -2, 18, -2).addComponent(this.rbFindWhat, -2, 16, -2).addComponent(this.txtFind, -2, 18, -2).addComponent(this.lblMessage, -2, 18, -2).addComponent(this.rbScrip, -2, 16, -2).addComponent(this.cbScrip, -2, -1, -2).addComponent(this.btnGo, -2, 20, -2)));
        layout.linkSize(1, new Component[]{this.jLabel1, this.jLabel2, this.txtFromDate});
        layout.linkSize(1, new Component[]{this.cbScrip, this.txtFind, this.txtToDate});
    }

    private void btnGoActionPerformed(ActionEvent evt) {
        this.callSearch();
    }

    private void txtFindFocusGained(FocusEvent evt) {
        this.txtFind.selectAll();
    }

    private void callSearch() {
        if (this.myTab != null) {
            new Thread("myTab callSearch"){

                @Override
                public void run() {
                    Util.setMessage((JLabel)SearchPanelScrip.this.lblMessage, (MessageType)MessageType.Loading, (String)"Searching...");
                    SearchPanelScrip.this.callMyTabSearch();
                    Util.setMessage((JLabel)SearchPanelScrip.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                }
            }.start();
        } else if (this.announcementTab != null) {
            new Thread("announcementTab callSearch"){

                @Override
                public void run() {
                    Util.setMessage((JLabel)SearchPanelScrip.this.lblMessage, (MessageType)MessageType.Loading, (String)"Searching...");
                    SearchPanelScrip.this.callAnnouncementTabSearch();
                    Util.setMessage((JLabel)SearchPanelScrip.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                }
            }.start();
        } else if (this.announcementLiveTab != null) {
            new Thread("announcementLiveTab callSearch"){

                @Override
                public void run() {
                    Util.setMessage((JLabel)SearchPanelScrip.this.lblMessage, (MessageType)MessageType.Loading, (String)"Searching...");
                    SearchPanelScrip.this.callAnnouncementTabSearch();
                    Util.setMessage((JLabel)SearchPanelScrip.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                }
            }.start();
        } else if (this.boardMeetingTab != null) {
            new Thread("announcementTab callSearch"){

                @Override
                public void run() {
                    Util.setMessage((JLabel)SearchPanelScrip.this.lblMessage, (MessageType)MessageType.Loading, (String)"Searching...");
                    SearchPanelScrip.this.callBoardMeetingTabSearch();
                    Util.setMessage((JLabel)SearchPanelScrip.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                }
            }.start();
        }
    }

    private void txtFindActionPerformed(ActionEvent evt) {
        this.callSearch();
    }

    private void rbFindWhatActionPerformed(ActionEvent evt) {
        this.txtFind.setEnabled(true);
        this.cbScrip.setEnabled(false);
    }

    private void rbScripActionPerformed(ActionEvent evt) {
        this.txtFind.setEnabled(false);
        this.cbScrip.setEnabled(true);
    }

    public void setDate() {
        if (this.type.equalsIgnoreCase(LanguageConstant.News) || this.type.equalsIgnoreCase("Commodity News") || this.type.equalsIgnoreCase("HOUSE_MESSAGE") || this.type.equalsIgnoreCase("Board_Meeting")) {
            this.txtFromDate.setDate(Util.addSubtractDaysFormDate((java.util.Date)this.date, (int)(-1 * LogCommon.tabMessageDays)));
        }
        if (this.type.equalsIgnoreCase(LanguageConstant.Announcement)) {
            this.txtFromDate.setDate(Util.addSubtractDaysFormDate((java.util.Date)this.date, (int)(-1 * LogCommon.AnnouncementMessageDays)));
        }
    }

    private void setScrip2() {
        if (this.support == null) {
            Vector v = new Vector(LogCommon.SymbolAndSymbolName.keySet());
            v.add(0, "");
            Collections.sort(v);
            this.cbScrip.setModel(new DefaultComboBoxModel(v));
            this.support = AutoCompleteSupport.install((JComboBox)this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])v.toArray()));
        }
    }

    protected void setScrip() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setScrip2();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchPanelScrip.this.setScrip2();
                }
            });
        }
    }
}

