/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import CustomComponent.MyTime;
import MessageWindow.AnnouncementScripDetail;
import MessageWindow.BoardMeetingScripDetail;
import MessageWindow.SearchNotFound;
import MessageWindow.ShowAnnouncementScripDetailSearchResult;
import MessageWindow.ShowSearchResultScripDetail;
import MyDocking.TradeCast;
import Utilities.CompressManager;
import Utilities.LogsTC;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.JTextFieldFilter;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import languages.LanguageConstant;
import login.LoginServer;
import org.jdesktop.swingx.JXDatePicker;

public class SearchPanelScripDetail
extends JPanel {
    java.util.Date date = MyTime.getInstance().getDate2();
    private String type;
    private LoginServer port = null;
    private ShowSearchResultScripDetail showSearchResultScripDetail = null;
    private AnnouncementScripDetail announcementTab;
    private ShowAnnouncementScripDetailSearchResult showAnnouncementSearchResult;
    private BoardMeetingScripDetail boardMeetingScripDetail;
    AutoCompleteSupport support = null;
    String symbol;
    private JButton btnGo;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel lblFind;
    private JLabel lblMessage;
    private JTextField txtFind;
    private JXDatePicker txtFromDate;
    private JXDatePicker txtToDate;

    public void setSymbol(String symbol) {
        this.symbol = symbol;
        this.txtFind.setText(symbol);
    }

    public SearchPanelScripDetail(AnnouncementScripDetail announcementTab, String type) {
        this.announcementTab = announcementTab;
        this.type = type;
        this.setValues();
    }

    public SearchPanelScripDetail(ShowAnnouncementScripDetailSearchResult showAnnouncementSearchResult, AnnouncementScripDetail announcementTab, String type) {
        this.announcementTab = announcementTab;
        this.showAnnouncementSearchResult = showAnnouncementSearchResult;
        this.type = type;
        if (type.equalsIgnoreCase("Board Meetings")) {
            this.type = "Board_Meeting";
        }
        this.setValues();
    }

    public SearchPanelScripDetail(ShowSearchResultScripDetail showSearchResultScripDetail, BoardMeetingScripDetail boardMeetingScripDetail, String type) {
        this.showSearchResultScripDetail = showSearchResultScripDetail;
        this.boardMeetingScripDetail = boardMeetingScripDetail;
        this.type = type;
        if (type.equalsIgnoreCase("Board Meetings")) {
            this.type = "Board_Meeting";
        }
        this.setValues();
    }

    private boolean isValidInput() {
        boolean status = false;
        this.lblMessage.setText(" ");
        String find = this.txtFind.getText();
        String scrip = "";
        if (this.txtFromDate.getDate() == null) {
            this.lblMessage.setText("Please select From date");
            this.txtFromDate.requestFocus();
            return status;
        }
        if (this.txtToDate.getDate() == null) {
            this.lblMessage.setText("Please select To date");
            this.txtToDate.requestFocus();
            return status;
        }
        if (find.trim().length() <= 0) {
            this.lblMessage.setText("Please enter text for search");
            this.txtFind.requestFocus();
            return status;
        }
        if (!this.txtFromDate.getDate().before(this.txtToDate.getDate()) && this.txtFromDate.getDate().compareTo(this.txtToDate.getDate()) != 0) {
            this.lblMessage.setText(" ");
            JOptionPane.showMessageDialog(this, "From date should be greater then or equal To date.", "Wrong Date", 2);
            this.txtFromDate.requestFocus();
            return status;
        }
        status = true;
        return status;
    }

    private boolean isValidInputForBoardMeeting() {
        boolean status = false;
        this.lblMessage.setText(" ");
        if (this.txtFromDate.getDate() == null) {
            this.lblMessage.setText("Please select From date");
            this.txtFromDate.requestFocus();
            return status;
        }
        if (this.txtToDate.getDate() == null) {
            this.lblMessage.setText("Please select To date");
            this.txtToDate.requestFocus();
            return status;
        }
        if (!this.txtFromDate.getDate().before(this.txtToDate.getDate()) && this.txtFromDate.getDate().compareTo(this.txtToDate.getDate()) != 0) {
            this.lblMessage.setText(" ");
            JOptionPane.showMessageDialog(this, "From date should be greater then or equal To date.", "Wrong Date", 2);
            this.txtFromDate.requestFocus();
            return status;
        }
        status = true;
        return status;
    }

    private void setValues() {
        if (this.port == null) {
            try {
                this.port = WebService.getInstance().getPort();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.initComponents();
        this.txtFromDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtFromDate.setDate(this.date);
        this.txtToDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtToDate.setDate(this.date);
        this.txtFind.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 ", 70));
        this.setDate();
    }

    public void callBoardMeetingTabSearch() {
        if (this.isValidInputForBoardMeeting()) {
            String find = this.txtFind.getText();
            String fromDate = new Date(this.txtFromDate.getDate().getTime()) + "";
            String toDate = new Date(this.txtToDate.getDate().getTime()) + "";
            String result = CompressManager.unzipStringFromBytes(this.port.userMessagesSearch(fromDate, toDate, find, "BOARD_MEETING", LogCommon.UserID));
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
            if (result.equalsIgnoreCase("No Record(s) found") || result.trim().length() <= 1) {
                SearchNotFound ss = new SearchNotFound((Frame)TradeCast.getInstance().frame, true, find.replaceAll("OnlyScrip", ""));
                ss.setVisible(true);
            } else if (this.showSearchResultScripDetail != null) {
                this.showSearchResultScripDetail.addBoardMeetingData(result, find.replaceAll("OnlyScrip", ""));
                this.showSearchResultScripDetail.requestFocus();
            } else {
                ShowSearchResultScripDetail showSearchResult = new ShowSearchResultScripDetail(this.boardMeetingScripDetail, TradeCast.getInstance().frame, false, this.type);
                showSearchResult.setVisible(true);
                showSearchResult.addBoardMeetingData(result, find.replaceAll("OnlyScrip", ""));
                showSearchResult.requestFocus();
            }
        }
    }

    public void callAnnouncementTabSearch() {
        if (this.isValidInput()) {
            final String find = this.txtFind.getText();
            String fromDate = new Date(this.txtFromDate.getDate().getTime()) + "";
            String toDate = new Date(this.txtToDate.getDate().getTime()) + "";
            final String result = CompressManager.unzipStringFromBytes(this.port.userMessagesSearch(fromDate, toDate, find, this.type, LogCommon.UserID));
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
            if (result.equalsIgnoreCase("No Record(s) found") || result.trim().length() <= 1) {
                SearchNotFound ss = new SearchNotFound((Frame)TradeCast.getInstance().frame, true, find.replaceAll("OnlyScrip", ""));
                ss.setVisible(true);
            } else if (this.showAnnouncementSearchResult != null) {
                this.showAnnouncementSearchResult.addAllData(result, find.replaceAll("OnlyScrip", ""));
                this.showAnnouncementSearchResult.requestFocus();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ShowAnnouncementScripDetailSearchResult showSearchResult = new ShowAnnouncementScripDetailSearchResult(SearchPanelScripDetail.this.announcementTab, TradeCast.getInstance().frame, false, SearchPanelScripDetail.this.type);
                            showSearchResult.setVisible(true);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(SearchPanelScripDetail.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            showSearchResult.addAllData(result, find.replaceAll("OnlyScrip", ""));
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.lblMessage = new JLabel();
        this.txtFind = new JTextField();
        this.btnGo = new JButton();
        this.jLabel1 = new JLabel();
        this.txtFromDate = new JXDatePicker();
        this.jLabel2 = new JLabel();
        this.txtToDate = new JXDatePicker();
        this.jLabel4 = new JLabel();
        this.lblFind = new JLabel();
        this.lblMessage.setText(" ");
        this.txtFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanelScripDetail.this.txtFindActionPerformed(evt);
            }
        });
        this.txtFind.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SearchPanelScripDetail.this.txtFindFocusGained(evt);
            }
        });
        this.btnGo.setText("Go");
        this.btnGo.setName("SearchPanelScripDetail -> btnGo");
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanelScripDetail.this.btnGoActionPerformed(evt);
            }
        });
        this.jLabel1.setText("From");
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy");
        String today = formatter.format(this.date);
        this.txtFromDate.setLinkDay(new java.util.Date(System.currentTimeMillis()), "Today is " + today);
        this.jLabel2.setText("   To");
        SimpleDateFormat formatter2 = new SimpleDateFormat("MMM dd, yyyy");
        String today2 = formatter2.format(this.date);
        this.txtToDate.setLinkDay(new java.util.Date(System.currentTimeMillis()), "Today is " + today2);
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.jLabel4.setText("Search:");
        this.lblFind.setText("Find what");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtFromDate, -2, 92, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtToDate, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblFind, -2, 49, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtFind, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE)));
        layout.linkSize(0, new Component[]{this.txtFromDate, this.txtToDate});
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -2, 18, -2).addComponent((Component)this.txtFromDate, -2, 20, -2).addComponent(this.jLabel1, -2, 18, -2).addComponent(this.jLabel2, -2, 18, -2).addComponent((Component)this.txtToDate, -2, 18, -2).addComponent(this.txtFind, -2, 18, -2).addComponent(this.lblMessage, -2, 18, -2).addComponent(this.btnGo, -2, 20, -2).addComponent(this.lblFind)));
        layout.linkSize(1, new Component[]{this.jLabel1, this.jLabel2, this.txtFromDate});
        layout.linkSize(1, new Component[]{this.txtFind, this.txtToDate});
    }

    private void btnGoActionPerformed(ActionEvent evt) {
        this.callSearch();
    }

    private void txtFindFocusGained(FocusEvent evt) {
        this.txtFind.selectAll();
    }

    private void callSearch() {
        if (this.announcementTab != null) {
            new Thread(){

                @Override
                public void run() {
                    Util.setMessage((JLabel)SearchPanelScripDetail.this.lblMessage, (MessageType)MessageType.Loading, (String)"Searching...");
                    SearchPanelScripDetail.this.callAnnouncementTabSearch();
                    Util.setMessage((JLabel)SearchPanelScripDetail.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                }
            }.start();
        } else if (this.boardMeetingScripDetail != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Util.setMessage((JLabel)SearchPanelScripDetail.this.lblMessage, (MessageType)MessageType.Loading, (String)"Searching...");
                    SearchPanelScripDetail.this.callBoardMeetingTabSearch();
                    Util.setMessage((JLabel)SearchPanelScripDetail.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                }
            });
        }
    }

    private void txtFindActionPerformed(ActionEvent evt) {
        this.callSearch();
    }

    public void setDate() {
        if (this.type.equalsIgnoreCase(LanguageConstant.News) || this.type.equalsIgnoreCase("Commodity News") || this.type.equalsIgnoreCase("HOUSE_MESSAGE") || this.type.equalsIgnoreCase("Board_Meeting")) {
            this.txtFromDate.setDate(Util.addSubtractDaysFormDate((java.util.Date)this.date, (int)(-1 * LogCommon.tabMessageDays)));
        }
        if (this.type.equalsIgnoreCase(LanguageConstant.Announcement)) {
            this.txtFromDate.setDate(Util.addSubtractDaysFormDate((java.util.Date)this.date, (int)(-1 * LogCommon.AnnouncementMessageDays)));
        }
    }

    protected void setScrip() {
        if (this.support == null) {
            Vector v = new Vector(LogCommon.SymbolAndSymbolName.keySet());
            v.add(0, "");
            Collections.sort(v);
        }
    }
}

