/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import CustomComponent.MyTime;
import MessageWindow.PriceAlert;
import MessageWindow.PriceAlertTab;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import org.jdesktop.swingx.JXDatePicker;

public class SetIndicesAlert
extends JPanel {
    HashMap<String, String> keyMapIndices = new HashMap();
    String indices = "|KSE 100|KSE 30|KMI 30|KMIALLSHR|OGTi|BKTi|ALLSHR";
    String fields = "|Index|Change|Volume";
    String operation = "|Greater Than|Greater Than OR Equal|Less Than|Less Than OR Equal|Equal";
    String notification = "Once Only|Once a Day";
    PriceAlertTab pat = null;
    public static long id = 0L;
    private PriceAlert pa;
    Date date = MyTime.getInstance().getDate2();
    String typeMsg = "Alert type not selected";
    private JButton btnOk;
    private JComboBox cbField;
    private JComboBox cbIndices;
    private JComboBox cbNotification;
    private JComboBox cbOperation;
    private JCheckBox isPopup;
    private JCheckBox isSMS;
    private JCheckBox isVoice;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSpinner spValue;
    private JXDatePicker txtExpire;

    public SetIndicesAlert(PriceAlertTab pat) {
        this.pat = pat;
        this.init();
        this.setFocus();
        this.setInitData();
    }

    public SetIndicesAlert(PriceAlertTab pat, PriceAlert pa) {
        this.pat = pat;
        this.pa = pa;
        this.init();
        this.setFocus();
        this.setInitData();
    }

    private void setInitData() {
        this.cbIndices.setModel(new DefaultComboBoxModel<String>(this.indices.split("\\|", -1)));
        this.cbField.setModel(new DefaultComboBoxModel<String>(this.fields.split("\\|", -1)));
        this.cbOperation.setModel(new DefaultComboBoxModel<String>(this.operation.split("\\|", -1)));
        this.cbNotification.setModel(new DefaultComboBoxModel<String>(this.notification.split("\\|", -1)));
        this.spValue.setModel(new SpinnerNumberModel(0, 0, 9999999, 1));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbIndices, (EventList)GlazedLists.eventListOf((Object[])this.indices.split("\\|", -1)));
        support.setStrict(true);
        this.setValueType("");
        this.isSMS.setVisible(false);
        this.isPopup.setText("Desktop Alert");
        this.txtExpire.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtExpire.setDate(this.date);
        this.txtExpire.setLightWeightPopupEnabled(true);
        this.cbIndices.setSelectedItem("KSE 100");
        try {
            this.cbNotification.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.cbField.setSelectedItem("Change");
        this.cbOperation.setSelectedItem("Greater Than");
    }

    private void setFocus() {
        this.cbIndices.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SetIndicesAlert.this.cbIndices.getSelectedItem() == null) {
                        JOptionPane.showMessageDialog(null, "Index not selected");
                        SetIndicesAlert.this.cbIndices.requestFocus();
                        return;
                    }
                    if (SetIndicesAlert.this.cbIndices.getSelectedItem().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Index not selected");
                        SetIndicesAlert.this.cbIndices.requestFocus();
                        return;
                    }
                    SetIndicesAlert.this.cbField.requestFocus();
                }
            }
        });
        this.cbField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SetIndicesAlert.this.cbField.getSelectedItem().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Field not selected");
                        SetIndicesAlert.this.cbField.requestFocus();
                        return;
                    }
                    SetIndicesAlert.this.cbOperation.requestFocus();
                }
            }
        });
        this.cbOperation.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SetIndicesAlert.this.cbOperation.getSelectedItem().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Operation not selected");
                        SetIndicesAlert.this.cbOperation.requestFocus();
                        return;
                    }
                    ((JSpinner.DefaultEditor)SetIndicesAlert.this.spValue.getEditor()).getTextField().requestFocus();
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spValue.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SetIndicesAlert.this.spValue.getValue().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Value not selected");
                        ((JSpinner.DefaultEditor)SetIndicesAlert.this.spValue.getEditor()).getTextField().requestFocus();
                        return;
                    }
                    SetIndicesAlert.this.cbNotification.requestFocus();
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spValue.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.cbNotification.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SetIndicesAlert.this.cbNotification.getSelectedItem().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Notification not selected");
                        SetIndicesAlert.this.cbNotification.requestFocus();
                        return;
                    }
                    SetIndicesAlert.this.txtExpire.requestFocus();
                }
            }
        });
        this.txtExpire.getEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SetIndicesAlert.this.txtExpire.getDate() == null) {
                        JOptionPane.showMessageDialog(null, "Expiry not selected");
                        SetIndicesAlert.this.txtExpire.requestFocus();
                        return;
                    }
                    if (SetIndicesAlert.this.txtExpire.getDate().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Expiry not selected");
                        SetIndicesAlert.this.txtExpire.requestFocus();
                        return;
                    }
                    SetIndicesAlert.this.isPopup.requestFocus();
                }
            }
        });
        this.isPopup.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SetIndicesAlert.this.isVoice.requestFocus();
                }
            }
        });
        this.isVoice.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SetIndicesAlert.this.btnOk.requestFocus();
                }
            }
        });
    }

    private PriceAlert getValues() {
        PriceAlert part = new PriceAlert();
        if (this.cbIndices.isEnabled()) {
            part.id = ++id;
        } else if (this.pa != null) {
            part.id = this.pa.id;
            part.msgNo = this.pa.msgNo;
        }
        part.index = this.cbIndices.getSelectedItem().toString().toUpperCase();
        part.market = UtilKSE.GetMarketFromsymbol((String)part.scrip);
        part.field = this.cbField.getSelectedItem().toString();
        part.operator = this.cbOperation.getSelectedItem().toString();
        part.notification = this.cbNotification.getSelectedItem().toString();
        part.value = this.spValue.getValue().toString();
        part.isDesktopAlert = this.isPopup.isSelected();
        part.isVoice = this.isVoice.isSelected();
        part.isSMS = this.isSMS.isSelected();
        part.isTriggered = false;
        part.isIndex = true;
        String key = part.getKey();
        if (this.keyMapIndices.containsKey(key)) {
            JOptionPane.showMessageDialog(null, "Index alert with same parameters already exists");
        } else {
            this.keyMapIndices.put(key, "");
        }
        part.expireDate = LogsKSE.sdfMessage.format(this.txtExpire.getDate());
        part.setDate = MyTime.getInstance().getCurrentDateAndTime();
        return part;
    }

    protected void setValues(PriceAlert pa) {
        this.setValueType(pa.field);
        this.cbIndices.setEnabled(false);
        this.cbIndices.setSelectedItem(pa.index);
        this.cbField.setSelectedItem(pa.field);
        this.cbOperation.setSelectedItem(pa.operator);
        this.cbNotification.setSelectedItem(pa.notification);
        this.spValue.setValue(Double.parseDouble(pa.value.replaceAll("\\,", "")));
        try {
            this.txtExpire.setDate(LogsKSE.sdfMessage.parse(pa.expireDate));
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        this.isPopup.setSelected(pa.isDesktopAlert);
        this.isVoice.setSelected(pa.isVoice);
        this.isSMS.setSelected(pa.isSMS);
    }

    private void setValueType(String filed) {
        if (filed.equalsIgnoreCase("Volume")) {
            this.spValue.setModel(new SpinnerNumberModel(0, 0, 9999999, 1));
        } else {
            this.spValue.setModel(new SpinnerNumberModel(0.0, 0.0, 9999999.99, 0.1));
        }
    }

    public void init() {
        this.jLabel1 = new JLabel();
        this.cbIndices = new JComboBox();
        this.btnOk = new JButton();
        this.jLabel2 = new JLabel();
        this.cbField = new JComboBox();
        this.jLabel3 = new JLabel();
        this.cbOperation = new JComboBox();
        this.jLabel4 = new JLabel();
        this.spValue = new JSpinner();
        this.jLabel5 = new JLabel();
        this.cbNotification = new JComboBox();
        this.jLabel6 = new JLabel();
        this.isPopup = new JCheckBox();
        this.isVoice = new JCheckBox();
        this.isSMS = new JCheckBox();
        this.txtExpire = new JXDatePicker();
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Indices");
        this.jLabel1.setName("jLabel1");
        this.cbIndices.setEditable(true);
        this.cbIndices.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbIndices.setMinimumSize(new Dimension(98, 18));
        this.cbIndices.setName("cbScrip");
        this.btnOk.setText("OK");
        this.btnOk.setName("btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetIndicesAlert.this.btnOkActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Field");
        this.jLabel2.setName("jLabel2");
        this.cbField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbField.setName("cbField");
        this.cbField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetIndicesAlert.this.cbFieldActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Operation");
        this.jLabel3.setName("jLabel3");
        this.cbOperation.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbOperation.setName("cbOperation");
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Value");
        this.jLabel4.setName("jLabel4");
        this.spValue.setModel(new SpinnerNumberModel());
        this.spValue.setName("spValue");
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("Notification");
        this.jLabel5.setName("jLabel5");
        this.cbNotification.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbNotification.setName("cbNotification");
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("Expiry");
        this.jLabel6.setName("jLabel6");
        this.isPopup.setSelected(true);
        this.isPopup.setText("Popup");
        this.isPopup.setName("isPopup");
        this.isPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetIndicesAlert.this.isPopupActionPerformed(evt);
            }
        });
        this.isVoice.setText("Voice");
        this.isVoice.setName("isVoice");
        this.isVoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetIndicesAlert.this.isVoiceActionPerformed(evt);
            }
        });
        this.isSMS.setText("SMS");
        this.isSMS.setEnabled(false);
        this.isSMS.setName("isSMS");
        this.isSMS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetIndicesAlert.this.isSMSActionPerformed(evt);
            }
        });
        this.txtExpire.setName("txtExpire");
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy");
        String today = formatter.format(this.date);
        this.txtExpire.setLinkDay(new Date(System.currentTimeMillis()), "Today is " + today);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbIndices, -2, 64, -2).addComponent(this.jLabel1, -2, 64, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.cbField, -2, 101, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.cbOperation, 0, 132, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spValue, -2, 57, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.cbNotification, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtExpire, -2, 92, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.isPopup).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.isSMS)).addGroup(layout.createSequentialGroup().addComponent(this.isVoice).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOk, -1, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.cbField, this.jLabel2);
        layout.linkSize(0, this.jLabel4, this.spValue);
        layout.linkSize(0, this.cbNotification, this.jLabel5);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel1)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbOperation, -2, -1, -2).addComponent(this.cbField, -2, -1, -2).addComponent(this.spValue, -2, -1, -2).addComponent(this.cbNotification, -2, -1, -2).addComponent((Component)this.txtExpire, -2, 12, -2).addComponent(this.isVoice, -2, 14, -2).addComponent(this.cbIndices, -2, -1, -2).addComponent(this.btnOk))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.isPopup, -2, 13, -2).addComponent(this.isSMS, -2, 14, -2)));
        layout.linkSize(1, new Component[]{this.cbNotification, this.txtExpire});
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbIndices = new JComboBox();
        this.btnOk = new JButton();
        this.jLabel2 = new JLabel();
        this.cbField = new JComboBox();
        this.jLabel3 = new JLabel();
        this.cbOperation = new JComboBox();
        this.jLabel4 = new JLabel();
        this.spValue = new JSpinner();
        this.jLabel5 = new JLabel();
        this.cbNotification = new JComboBox();
        this.jLabel6 = new JLabel();
        this.isPopup = new JCheckBox();
        this.isVoice = new JCheckBox();
        this.isSMS = new JCheckBox();
        this.txtExpire = new JXDatePicker();
        this.setPreferredSize(new Dimension(649, 40));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Index");
        this.jLabel1.setName("jLabel1");
        this.cbIndices.setEditable(true);
        this.cbIndices.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbIndices.setMinimumSize(new Dimension(98, 18));
        this.cbIndices.setName("cbIndices");
        this.btnOk.setText("OK");
        this.btnOk.setName("SetIndicesAlert -> btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetIndicesAlert.this.btnOkActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Field");
        this.jLabel2.setMaximumSize(new Dimension(56, 14));
        this.jLabel2.setMinimumSize(new Dimension(56, 14));
        this.jLabel2.setName("jLabel2");
        this.jLabel2.setPreferredSize(new Dimension(56, 14));
        this.cbField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbField.setMaximumSize(new Dimension(56, 20));
        this.cbField.setMinimumSize(new Dimension(56, 20));
        this.cbField.setName("cbField");
        this.cbField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetIndicesAlert.this.cbFieldActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Operation");
        this.jLabel3.setName("jLabel3");
        this.cbOperation.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbOperation.setMaximumSize(new Dimension(56, 20));
        this.cbOperation.setMinimumSize(new Dimension(56, 20));
        this.cbOperation.setName("cbOperation");
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Value");
        this.jLabel4.setMaximumSize(new Dimension(29, 14));
        this.jLabel4.setMinimumSize(new Dimension(29, 14));
        this.jLabel4.setName("jLabel4");
        this.jLabel4.setPreferredSize(new Dimension(29, 14));
        this.spValue.setMaximumSize(new Dimension(29, 20));
        this.spValue.setName("spValue");
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("Notification");
        this.jLabel5.setMaximumSize(new Dimension(56, 14));
        this.jLabel5.setMinimumSize(new Dimension(56, 14));
        this.jLabel5.setName("jLabel5");
        this.jLabel5.setPreferredSize(new Dimension(56, 14));
        this.cbNotification.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbNotification.setMaximumSize(new Dimension(56, 20));
        this.cbNotification.setMinimumSize(new Dimension(56, 20));
        this.cbNotification.setName("cbNotification");
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("Expiry");
        this.jLabel6.setName("jLabel6");
        this.isPopup.setSelected(true);
        this.isPopup.setText("Popup");
        this.isPopup.setName("isPopup");
        this.isPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetIndicesAlert.this.isPopupActionPerformed(evt);
            }
        });
        this.isVoice.setText("Voice");
        this.isVoice.setName("isVoice");
        this.isVoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetIndicesAlert.this.isVoiceActionPerformed(evt);
            }
        });
        this.isSMS.setText("SMS");
        this.isSMS.setEnabled(false);
        this.isSMS.setName("isSMS");
        this.isSMS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetIndicesAlert.this.isSMSActionPerformed(evt);
            }
        });
        this.txtExpire.setMaximumSize(new Dimension(116, 18));
        this.txtExpire.setMinimumSize(new Dimension(116, 18));
        this.txtExpire.setName("txtExpire");
        this.txtExpire.setPreferredSize(new Dimension(116, 18));
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy");
        String today = formatter.format(this.date);
        this.txtExpire.setLinkDay(new Date(System.currentTimeMillis()), "Today is " + today);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.cbIndices, 0, 65, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.cbField, -2, 101, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.cbOperation, 0, 128, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spValue, -2, 57, -2).addComponent(this.jLabel4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6, -2, 94, -2)).addGroup(layout.createSequentialGroup().addComponent(this.cbNotification, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtExpire, -2, 94, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.isPopup).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.isSMS)).addGroup(layout.createSequentialGroup().addComponent(this.isVoice).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOk))).addContainerGap(11, Short.MAX_VALUE)));
        layout.linkSize(0, this.cbField, this.jLabel2);
        layout.linkSize(0, this.jLabel4, this.spValue);
        layout.linkSize(0, this.cbNotification, this.jLabel5);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel4, -2, -1, -2).addComponent(this.jLabel5, -2, -1, -2).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jLabel6).addComponent(this.isPopup, -2, 13, -2).addComponent(this.isSMS, -2, 14, -2)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbIndices, -2, -1, -2).addComponent(this.cbOperation, -2, -1, -2).addComponent(this.cbField, -2, -1, -2).addComponent(this.spValue, -2, -1, -2).addComponent(this.cbNotification, -2, -1, -2).addComponent((Component)this.txtExpire, -2, -1, -2).addComponent(this.isVoice, -2, 14, -2).addComponent(this.btnOk))));
        layout.linkSize(1, new Component[]{this.cbNotification, this.txtExpire});
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.cbIndices.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(null, "Index not selected");
            this.cbIndices.requestFocus();
            return;
        }
        if (this.cbIndices.getSelectedItem().toString().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Index not selected");
            this.cbIndices.requestFocus();
            return;
        }
        if (this.cbField.getSelectedItem().toString().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Field not selected");
            this.cbField.requestFocus();
            return;
        }
        if (this.cbOperation.getSelectedItem().toString().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Operation not selected");
            this.cbOperation.requestFocus();
            return;
        }
        if (this.spValue.getValue().toString().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Value not selected");
            this.spValue.requestFocus();
            return;
        }
        if (this.cbNotification.getSelectedItem().toString().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Notification not selected");
            this.cbNotification.requestFocus();
            return;
        }
        if (this.txtExpire.getDate() == null) {
            JOptionPane.showMessageDialog(null, "Expiry not selected");
            this.txtExpire.requestFocus();
            return;
        }
        if (this.txtExpire.getDate().toString().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Expiry not selected");
            this.txtExpire.requestFocus();
            return;
        }
        Date exp = this.txtExpire.getDate();
        Date dd = MyTime.getInstance().getDate2();
        Calendar cal = Calendar.getInstance();
        cal.setTime(dd);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        dd = cal.getTime();
        if (exp.before(dd)) {
            JOptionPane.showMessageDialog(null, "Expiry date must be ahead of current date");
            this.txtExpire.requestFocus();
            return;
        }
        if (!(this.isPopup.isSelected() || this.isSMS.isSelected() || this.isVoice.isSelected())) {
            JOptionPane.showMessageDialog(null, this.typeMsg);
            this.isPopup.requestFocus();
            return;
        }
        if (this.cbIndices.isEnabled()) {
            this.pat.addRow(this.getValues());
            this.reset();
        } else if (!this.cbIndices.isEnabled()) {
            this.pat.editRow(this.getValues());
            this.reset();
        }
        if (this.pat.table.getCellEditor() != null) {
            this.pat.table.getCellEditor().cancelCellEditing();
        }
    }

    private void isPopupActionPerformed(ActionEvent evt) {
        if (!(this.isPopup.isSelected() || this.isVoice.isSelected() || this.isSMS.isSelected())) {
            JOptionPane.showMessageDialog(null, this.typeMsg);
        }
    }

    private void isVoiceActionPerformed(ActionEvent evt) {
        if (!(this.isPopup.isSelected() || this.isVoice.isSelected() || this.isSMS.isSelected())) {
            JOptionPane.showMessageDialog(null, this.typeMsg);
        }
    }

    private void isSMSActionPerformed(ActionEvent evt) {
        if (!(this.isPopup.isSelected() || this.isVoice.isSelected() || this.isSMS.isSelected())) {
            JOptionPane.showMessageDialog(null, this.typeMsg);
        }
    }

    private void cbFieldActionPerformed(ActionEvent evt) {
        if (this.cbField.getSelectedItem() == null) {
            return;
        }
        this.setValueType(this.cbField.getSelectedItem().toString());
    }

    private void reset() {
        try {
            this.cbField.setSelectedIndex(0);
            this.spValue.setValue(0);
            this.cbIndices.setSelectedIndex(0);
            this.cbNotification.setSelectedIndex(0);
            this.cbOperation.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

