/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import CATALYST.Control.MarketWatch;
import CustomComponent.MyTime;
import MessageWindow.PriceAlert;
import MessageWindow.PriceAlertTab;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.LogCommon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import kse.util.LogsKSE;
import org.jdesktop.swingx.JXDatePicker;

public class SetPriceAlerts
extends JPanel {
    Date date = MyTime.getInstance().getDate2();
    String fields = "|Buy Volume|Buy|Sell|Sell Volume|Last Price|Total Volume|High|Low|Total Trades|Change|Average|Last Trade Volume|Close Price";
    String operation = "|Greater Than|Greater Than OR Equal|Less Than|Less Than OR Equal|Equal";
    String notification = "Once Only|Once a Day";
    PriceAlertTab priceAlertTab = null;
    public static long id = 0L;
    PriceAlert pa = null;
    String typeMsg = "Alert type not selected";
    AutoCompleteSupport autoCompleteMarket;
    AutoCompleteSupport autoCompleteScrip;
    private JButton btnOk;
    private JComboBox cbField;
    private JComboBox cbMarket;
    private JComboBox cbNotification;
    private JComboBox cbOperation;
    private JComboBox cbScrip;
    private JCheckBox isPopup;
    private JCheckBox isVoice;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JSpinner spValue;
    private JXDatePicker txtExpire;

    public SetPriceAlerts(PriceAlertTab pat, PriceAlert pa) {
        this.priceAlertTab = pat;
        this.pa = pa;
        if (MarketWatch.isCalculatePercentage) {
            this.fields = this.fields + "|Spread|Spread %";
        }
        this.initComponents();
        this.setInitData();
        this.setFocus();
    }

    public SetPriceAlerts(PriceAlertTab pat) {
        this.priceAlertTab = pat;
        if (MarketWatch.isCalculatePercentage) {
            this.fields = this.fields + "|Spread|Spread %";
        }
        this.initComponents();
        this.setInitData();
        this.setFocus();
    }

    public void setMarkets() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SetPriceAlerts.this.autoCompleteMarket != null && SetPriceAlerts.this.autoCompleteMarket.isInstalled()) {
                        SetPriceAlerts.this.autoCompleteMarket.uninstall();
                    }
                    Vector<String> allMarket = new Vector<String>();
                    for (int i = 0; i < LogCommon.markets.length; ++i) {
                        allMarket.addElement(LogCommon.markets[i]);
                    }
                    SetPriceAlerts.this.cbMarket.setModel(new DefaultComboBoxModel(allMarket));
                    SetPriceAlerts.this.autoCompleteMarket = AutoCompleteSupport.install((JComboBox)SetPriceAlerts.this.cbMarket, (EventList)GlazedLists.eventListOf((Object[])allMarket.toArray()));
                    SetPriceAlerts.this.cbMarket.setSelectedItem("REG");
                    SetPriceAlerts.this.autoCompleteMarket.setStrict(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void setSelectedScrip() {
        this.cbScrip.setSelectedItem(LogsKSE.SelectedSymbol);
    }

    public void setInitData() {
        this.setAllScrip();
        this.cbField.setModel(new DefaultComboBoxModel<String>(this.fields.split("\\|", -1)));
        this.cbOperation.setModel(new DefaultComboBoxModel<String>(this.operation.split("\\|", -1)));
        this.cbNotification.setModel(new DefaultComboBoxModel<String>(this.notification.split("\\|", -1)));
        this.cbField.setSelectedItem("Last Price");
        this.cbOperation.setSelectedItem("Greater Than");
        this.spValue.setModel(new SpinnerNumberModel(0, 0, 9999999, 1));
        this.isPopup.setText("Desktop Alert");
        this.txtExpire.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtExpire.setDate(this.date);
        this.txtExpire.setLightWeightPopupEnabled(true);
        try {
            this.cbNotification.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setMarkets();
    }

    public void setAllScrip() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SetPriceAlerts.this.autoCompleteScrip != null && SetPriceAlerts.this.autoCompleteScrip.isInstalled()) {
                        SetPriceAlerts.this.autoCompleteScrip.uninstall();
                    }
                    Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
                    Vector<String> newScrip = new Vector<String>();
                    for (int i = 0; i < allScrip.size(); ++i) {
                        Object object = allScrip.elementAt(i);
                        if (newScrip.contains(object.toString().split("\\-", -1)[0])) continue;
                        newScrip.add(object.toString().split("\\-", -1)[0]);
                    }
                    Collections.sort(newScrip);
                    SetPriceAlerts.this.cbScrip.setModel(new DefaultComboBoxModel(newScrip));
                    SetPriceAlerts.this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)SetPriceAlerts.this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])newScrip.toArray()));
                    SetPriceAlerts.this.autoCompleteScrip.setStrict(false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void setFocus() {
        this.cbScrip.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SetPriceAlerts.this.cbScrip.getSelectedItem() == null) {
                        JOptionPane.showMessageDialog(null, "Scrip not selected");
                        SetPriceAlerts.this.cbScrip.requestFocus();
                        return;
                    }
                    if (SetPriceAlerts.this.cbScrip.getSelectedItem().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Scrip not selected");
                        SetPriceAlerts.this.cbScrip.requestFocus();
                        return;
                    }
                    SetPriceAlerts.this.cbField.requestFocus();
                }
            }
        });
        this.cbMarket.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 10) {
                    if (SetPriceAlerts.this.cbMarket.getSelectedItem() == null) {
                        JOptionPane.showMessageDialog(null, "Market not selected");
                        SetPriceAlerts.this.cbMarket.requestFocus();
                        return;
                    }
                    if (SetPriceAlerts.this.cbMarket.getSelectedItem().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Market not selected");
                        SetPriceAlerts.this.cbMarket.requestFocus();
                        return;
                    }
                    SetPriceAlerts.this.cbScrip.requestFocus();
                }
            }
        });
        this.cbField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SetPriceAlerts.this.cbField.getSelectedItem().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Field not selected");
                        SetPriceAlerts.this.cbField.requestFocus();
                        return;
                    }
                    SetPriceAlerts.this.cbOperation.requestFocus();
                }
            }
        });
        this.cbOperation.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SetPriceAlerts.this.cbOperation.getSelectedItem().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Operation not selected");
                        SetPriceAlerts.this.cbOperation.requestFocus();
                        return;
                    }
                    ((JSpinner.DefaultEditor)SetPriceAlerts.this.spValue.getEditor()).getTextField().requestFocus();
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spValue.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SetPriceAlerts.this.spValue.getValue().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Value not selected");
                        ((JSpinner.DefaultEditor)SetPriceAlerts.this.spValue.getEditor()).getTextField().requestFocus();
                        return;
                    }
                    SetPriceAlerts.this.cbNotification.requestFocus();
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spValue.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.cbNotification.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SetPriceAlerts.this.cbNotification.getSelectedItem().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Notification not selected");
                        SetPriceAlerts.this.cbNotification.requestFocus();
                        return;
                    }
                    SetPriceAlerts.this.txtExpire.requestFocus();
                }
            }
        });
        this.txtExpire.getEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (SetPriceAlerts.this.txtExpire.getDate() == null) {
                        JOptionPane.showMessageDialog(null, "Expiry not selected");
                        SetPriceAlerts.this.txtExpire.requestFocus();
                        return;
                    }
                    if (SetPriceAlerts.this.txtExpire.getDate().toString().equalsIgnoreCase("")) {
                        JOptionPane.showMessageDialog(null, "Expiry not selected");
                        SetPriceAlerts.this.txtExpire.requestFocus();
                        return;
                    }
                    SetPriceAlerts.this.isPopup.requestFocus();
                }
            }
        });
        this.isPopup.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SetPriceAlerts.this.isVoice.requestFocus();
                }
            }
        });
        this.isVoice.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SetPriceAlerts.this.btnOk.requestFocus();
                }
            }
        });
    }

    private PriceAlert getValues() {
        PriceAlert part = new PriceAlert();
        if (this.cbScrip.isEnabled()) {
            part.id = ++id;
            part.msgNo = this.priceAlertTab.rows.size() + 1;
            ++PriceAlertTab.TotalMessage;
        } else if (this.pa != null) {
            part.id = this.pa.id;
            part.msgNo = this.pa.msgNo;
        }
        String symbol = part.scrip;
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        part.scrip = this.cbScrip.getSelectedItem().toString().toUpperCase();
        part.scripName = this.priceAlertTab.mediator.getSymbolTitle(symbol);
        part.market = this.cbMarket.getSelectedItem().toString();
        part.field = this.cbField.getSelectedItem().toString();
        part.operator = this.cbOperation.getSelectedItem().toString();
        part.notification = this.cbNotification.getSelectedItem().toString();
        part.value = this.spValue.getValue().toString();
        part.isDesktopAlert = this.isPopup.isSelected();
        part.isVoice = this.isVoice.isSelected();
        part.isSMS = false;
        part.isTriggered = false;
        part.expireDate = LogsKSE.sdfMessage.format(this.txtExpire.getDate());
        part.setDate = MyTime.getInstance().getCurrentDateAndTime();
        return part;
    }

    protected void setValues(PriceAlert pa) {
        this.setValueType(pa.field);
        this.cbScrip.setEnabled(false);
        this.cbScrip.setSelectedItem(pa.scrip);
        this.cbField.setSelectedItem(pa.field);
        this.cbOperation.setSelectedItem(pa.operator);
        this.cbNotification.setSelectedItem(pa.notification);
        this.spValue.setValue(Double.parseDouble(pa.value.replaceAll("\\,", "")));
        try {
            this.txtExpire.setDate(LogsKSE.sdfMessage.parse(pa.expireDate));
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        this.isPopup.setSelected(pa.isDesktopAlert);
        this.isVoice.setSelected(pa.isVoice);
    }

    private void setValueType(String filed) {
        if (filed.equalsIgnoreCase("Buy Volume")) {
            this.spValue.setModel(new SpinnerNumberModel(0, 0, 9999999, 1));
        } else if (filed.equalsIgnoreCase("Buy")) {
            this.spValue.setModel(new SpinnerNumberModel(0.0, 0.0, 9999999.99, 0.1));
        } else if (filed.equalsIgnoreCase("Sell")) {
            this.spValue.setModel(new SpinnerNumberModel(0.0, 0.0, 9999999.99, 0.1));
        } else if (filed.equalsIgnoreCase("Sell Volume")) {
            this.spValue.setModel(new SpinnerNumberModel(0, 0, 9999999, 1));
        } else if (filed.equalsIgnoreCase("Last Price")) {
            this.spValue.setModel(new SpinnerNumberModel(0.0, 0.0, 9999999.99, 0.1));
        } else if (filed.equalsIgnoreCase("Total Volume")) {
            this.spValue.setModel(new SpinnerNumberModel(0, 0, 9999999, 1));
        } else if (filed.equalsIgnoreCase("High")) {
            this.spValue.setModel(new SpinnerNumberModel(0.0, 0.0, 9999999.99, 0.1));
        } else if (filed.equalsIgnoreCase("Low")) {
            this.spValue.setModel(new SpinnerNumberModel(0.0, 0.0, 9999999.99, 0.1));
        } else if (filed.equalsIgnoreCase("Total Trades")) {
            this.spValue.setModel(new SpinnerNumberModel(0, 0, 9999999, 1));
        } else if (filed.equalsIgnoreCase("Change")) {
            this.spValue.setModel(new SpinnerNumberModel(0.0, 0.0, 9999999.99, 0.1));
        } else if (filed.equalsIgnoreCase("Average")) {
            this.spValue.setModel(new SpinnerNumberModel(0.0, 0.0, 9999999.99, 0.1));
        } else if (filed.equalsIgnoreCase("Last Trade Volume")) {
            this.spValue.setModel(new SpinnerNumberModel(0, 0, 9999999, 1));
        } else if (filed.equalsIgnoreCase("Close Price")) {
            this.spValue.setModel(new SpinnerNumberModel(0.0, 0.0, 9999999.99, 0.1));
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbScrip = new JComboBox();
        this.btnOk = new JButton();
        this.jLabel2 = new JLabel();
        this.cbField = new JComboBox();
        this.jLabel3 = new JLabel();
        this.cbOperation = new JComboBox();
        this.jLabel4 = new JLabel();
        this.spValue = new JSpinner();
        this.jLabel5 = new JLabel();
        this.cbNotification = new JComboBox();
        this.jLabel6 = new JLabel();
        this.isPopup = new JCheckBox();
        this.isVoice = new JCheckBox();
        this.txtExpire = new JXDatePicker();
        this.cbMarket = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Scrip");
        this.jLabel1.setName("jLabel1");
        this.cbScrip.setEditable(true);
        this.cbScrip.setMinimumSize(new Dimension(98, 18));
        this.cbScrip.setName("cbScrip");
        this.cbScrip.setNextFocusableComponent(this.cbField);
        this.btnOk.setText("OK");
        this.btnOk.setMaximumSize(new Dimension(47, 17));
        this.btnOk.setMinimumSize(new Dimension(47, 17));
        this.btnOk.setName("SetPriceAlerts -> btnOk");
        this.btnOk.setPreferredSize(new Dimension(47, 17));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetPriceAlerts.this.btnOkActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Field");
        this.jLabel2.setName("jLabel2");
        this.cbField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbField.setName("cbField");
        this.cbField.setNextFocusableComponent(this.cbOperation);
        this.cbField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetPriceAlerts.this.cbFieldActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Operation");
        this.jLabel3.setName("jLabel3");
        this.cbOperation.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbOperation.setName("cbOperation");
        this.cbOperation.setNextFocusableComponent(this.spValue);
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Value");
        this.jLabel4.setName("jLabel4");
        this.spValue.setModel(new SpinnerNumberModel());
        this.spValue.setName("spValue");
        this.spValue.setNextFocusableComponent(this.cbNotification);
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("Notification");
        this.jLabel5.setName("jLabel5");
        this.cbNotification.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbNotification.setName("cbNotification");
        this.cbNotification.setNextFocusableComponent((Component)this.txtExpire);
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("Expiry");
        this.jLabel6.setName("jLabel6");
        this.isPopup.setSelected(true);
        this.isPopup.setText("Desktop Alert");
        this.isPopup.setName("isPopup");
        this.isPopup.setNextFocusableComponent(this.isVoice);
        this.isPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetPriceAlerts.this.isPopupActionPerformed(evt);
            }
        });
        this.isVoice.setText("Voice");
        this.isVoice.setName("isVoice");
        this.isVoice.setNextFocusableComponent(this.btnOk);
        this.isVoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetPriceAlerts.this.isVoiceActionPerformed(evt);
            }
        });
        this.txtExpire.setName("txtExpire");
        this.txtExpire.setNextFocusableComponent((Component)this.isPopup);
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy");
        String today = formatter.format(this.date);
        this.txtExpire.setLinkDay(new Date(System.currentTimeMillis()), "Today is " + today);
        this.cbMarket.setEditable(true);
        this.cbMarket.setMinimumSize(new Dimension(98, 18));
        this.cbMarket.setName("cbMarket");
        this.cbMarket.setNextFocusableComponent(this.cbScrip);
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("Market");
        this.jLabel7.setName("jLabel7");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7, -2, 65, -2).addGap(5, 5, 5).addComponent(this.jLabel1, -2, 65, -2).addGap(5, 5, 5).addComponent(this.jLabel2, -2, 110, -2).addGap(5, 5, 5).addComponent(this.jLabel3, -2, 140, -2).addGap(5, 5, 5).addComponent(this.jLabel4, -2, 60, -2).addGap(5, 5, 5).addComponent(this.jLabel5, -2, 70, -2).addGap(5, 5, 5).addComponent(this.jLabel6, -2, 95, -2).addGap(5, 5, 5).addComponent(this.isPopup, -2, 140, -2)).addGroup(layout.createSequentialGroup().addComponent(this.cbMarket, -2, 65, -2).addGap(5, 5, 5).addComponent(this.cbScrip, -2, 65, -2).addGap(5, 5, 5).addComponent(this.cbField, -2, 110, -2).addGap(5, 5, 5).addComponent(this.cbOperation, -2, 140, -2).addGap(5, 5, 5).addComponent(this.spValue, -2, 60, -2).addGap(5, 5, 5).addComponent(this.cbNotification, -2, 70, -2).addGap(5, 5, 5).addComponent((Component)this.txtExpire, -2, 95, -2).addGap(5, 5, 5).addComponent(this.isVoice).addGap(19, 19, 19).addComponent(this.btnOk, -2, 70, -2)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.isPopup, -2, 15, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbMarket, -2, -1, -2).addComponent(this.cbScrip, -2, -1, -2).addComponent(this.cbField, -2, -1, -2).addComponent(this.cbOperation, -2, -1, -2).addComponent(this.spValue, -2, -1, -2).addComponent(this.cbNotification, -2, -1, -2).addComponent((Component)this.txtExpire, -2, 20, -2).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.isVoice, -2, 15, -2).addComponent(this.btnOk, -2, -1, -2))))));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.cbMarket.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(null, "Market not selected");
            this.cbMarket.requestFocus();
            return;
        }
        if (this.cbScrip.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(null, "Scrip not selected");
            this.cbScrip.requestFocus();
            return;
        }
        if (this.cbScrip.getSelectedItem().toString().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Scrip not selected");
            this.cbScrip.requestFocus();
            return;
        }
        if (this.cbField.getSelectedItem().toString().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Field not selected");
            this.cbField.requestFocus();
            return;
        }
        if (this.cbOperation.getSelectedItem().toString().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Operation not selected");
            this.cbOperation.requestFocus();
            return;
        }
        if (this.spValue.getValue().toString().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Value not selected");
            this.spValue.requestFocus();
            return;
        }
        if (this.cbNotification.getSelectedItem().toString().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Notification not selected");
            this.cbNotification.requestFocus();
            return;
        }
        if (this.txtExpire.getDate() == null) {
            JOptionPane.showMessageDialog(null, "Expiry not selected");
            this.txtExpire.requestFocus();
            return;
        }
        if (this.txtExpire.getDate().toString().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(null, "Expiry not selected");
            this.txtExpire.requestFocus();
            return;
        }
        Date exp = this.txtExpire.getDate();
        Date dd = MyTime.getInstance().getDate2();
        Calendar cal = Calendar.getInstance();
        cal.setTime(dd);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        dd = cal.getTime();
        if (exp.before(dd)) {
            JOptionPane.showMessageDialog(null, "Expiry date must be ahead of current date");
            this.txtExpire.requestFocus();
            return;
        }
        if (!this.isPopup.isSelected() && !this.isVoice.isSelected()) {
            JOptionPane.showMessageDialog(null, this.typeMsg);
            this.isPopup.requestFocus();
            return;
        }
        if ((this.cbField.getSelectedItem().toString().equalsIgnoreCase("Spread") || this.cbField.getSelectedItem().toString().equalsIgnoreCase("Spread %")) && this.cbMarket.getSelectedItem().toString().equalsIgnoreCase("REG")) {
            JOptionPane.showMessageDialog(null, "Spread OR Spread % is not allowed in Regular Market.");
            return;
        }
        if (this.cbScrip.isEnabled()) {
            if (this.priceAlertTab.scripSet.size() >= 10) {
                JOptionPane.showMessageDialog(null, "You can not add more than 10 alerts");
                return;
            }
            if (this.priceAlertTab.scripSet.contains(this.cbScrip.getSelectedItem().toString())) {
                this.priceAlertTab.addRow(this.getValues());
                this.reset();
            } else {
                PriceAlert pra = this.getValues();
                this.priceAlertTab.scripList.put(pra.scrip + pra.id, pra);
                this.priceAlertTab.addRow(pra);
                this.reset();
            }
        } else if (!this.cbScrip.isEnabled()) {
            this.priceAlertTab.editRow(this.getValues());
            this.reset();
        }
        if (this.priceAlertTab.table.getCellEditor() != null) {
            this.priceAlertTab.table.getCellEditor().cancelCellEditing();
        }
    }

    private void isPopupActionPerformed(ActionEvent evt) {
        if (!this.isPopup.isSelected() && !this.isVoice.isSelected()) {
            JOptionPane.showMessageDialog(null, this.typeMsg);
        }
    }

    private void isVoiceActionPerformed(ActionEvent evt) {
        if (!this.isPopup.isSelected() && !this.isVoice.isSelected()) {
            JOptionPane.showMessageDialog(null, this.typeMsg);
        }
    }

    private void cbFieldActionPerformed(ActionEvent evt) {
        if (this.cbField.getSelectedItem() == null) {
            return;
        }
        this.setValueType(this.cbField.getSelectedItem().toString());
    }

    private void reset() {
        try {
            this.cbScrip.setEditable(true);
            this.cbScrip.setSelectedItem("");
            this.spValue.setValue(0);
            this.cbField.setSelectedIndex(0);
            this.cbOperation.setSelectedIndex(0);
            this.cbNotification.setSelectedIndex(0);
            this.cbMarket.setSelectedItem("REG");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void setScrip(String scrip, String market) {
        this.cbScrip.setSelectedItem(scrip);
        this.cbField.requestFocus();
    }
}

