/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import Beans.Announcement;
import MessageWindow.AnnouncementLiveTab;
import MessageWindow.AnnouncementTab;
import MessageWindow.DisplayModel;
import MessageWindow.MessageDisplay;
import MessageWindow.MessageRender;
import MessageWindow.SearchPanelScrip;
import MyDocking.Mediator;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXCollapsiblePane;

public class ShowAnnouncementSearchResult
extends JDialog {
    String[] columnNames = new String[]{""};
    Vector<MessageDisplay> rows = new Vector();
    Vector columns = new Vector();
    DisplayModel model = new DisplayModel(this.rows, true);
    final int idIndex = 0;
    String type = "";
    Mediator mediator = Mediator.getInstance();
    MessageRender messageRender = new MessageRender();
    private boolean isAsec = true;
    private JButton dropDownDec;
    private JButton dropDownAsc;
    private JLabel lblCount = new JLabel(" ");
    public AnnouncementTab announcementTab;
    public AnnouncementLiveTab announcementLiveTab;
    private SearchPanelScrip searchPanel;
    private JButton btnAsen;
    private JButton btnDecn;
    private JButton btnSearch;
    private ButtonGroup buttonGroup1;
    private JXCollapsiblePane collapsiblePane;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JLabel lblMessage;
    private JCheckBoxMenuItem menuCompany;
    private JCheckBoxMenuItem menuDate;
    private JCheckBoxMenuItem menuScrip;
    private JPopupMenu sortMenu;
    private JTable table;
    private JToolBar toolBar;

    public ShowAnnouncementSearchResult(AnnouncementTab announcementTab, JFrame parent, boolean modal, String type) {
        super((Frame)parent, modal);
        this.type = type;
        this.announcementTab = announcementTab;
        this.searchPanel = new SearchPanelScrip(this, announcementTab, type);
        this.initCommon(parent);
    }

    public ShowAnnouncementSearchResult(AnnouncementLiveTab announcementLiveTab, JFrame parent, boolean modal, String type) {
        super((Frame)parent, modal);
        this.type = type;
        this.announcementLiveTab = announcementLiveTab;
        this.searchPanel = new SearchPanelScrip(this, announcementLiveTab, type);
        this.initCommon(parent);
    }

    private void initCommon(JFrame parent) {
        this.initComponents();
        if (Util.isWindow7()) {
            this.menuCompany.setIcon(null);
            this.menuDate.setIcon(null);
            this.menuScrip.setIcon(null);
        }
        this.setTitle("Search results");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/Images/search12.png")).getImage());
        this.btnDecn.setLayout(new BorderLayout());
        this.btnDecn.setMargin(new Insets(-5, -5, -5, -5));
        this.dropDownDec = new BasicArrowButton(5);
        this.dropDownDec.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.dropDownDec.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ShowAnnouncementSearchResult.this.isAsec = false;
                ShowAnnouncementSearchResult.this.sortMenu.show(ShowAnnouncementSearchResult.this.btnDecn, evt.getX() + 2, evt.getY() + 7);
            }
        });
        this.btnDecn.add((Component)this.dropDownDec, "East");
        this.btnAsen.setLayout(new BorderLayout());
        this.btnAsen.setMargin(new Insets(-5, -5, -5, -5));
        this.dropDownAsc = new BasicArrowButton(5);
        this.dropDownAsc.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.dropDownAsc.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ShowAnnouncementSearchResult.this.isAsec = true;
                ShowAnnouncementSearchResult.this.sortMenu.show(ShowAnnouncementSearchResult.this.btnAsen, evt.getX() + 2, evt.getY() + 7);
            }
        });
        this.btnAsen.add((Component)this.dropDownAsc, "East");
        this.toolBar.add(Box.createHorizontalGlue());
        this.lblCount.setHorizontalAlignment(4);
        this.toolBar.add(this.lblCount);
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columns.addElement(this.columnNames[i]);
        }
        this.model.setDataVector(this.rows, this.columns);
        this.table.setModel(this.model);
        this.table.setDefaultRenderer(Object.class, this.messageRender);
        TableColumn com = this.table.getColumnModel().getColumn(0);
        com.setCellEditor(this.messageRender);
        this.table.setTableHeader(null);
        this.table.setRowHeight(200);
        this.table.setSelectionMode(0);
        this.collapsiblePane.add((Component)this.searchPanel);
        this.searchPanel.setScrip();
        this.collapsiblePane.setCollapsed(true);
        this.setDialogLocation(parent);
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowAnnouncementSearchResult.this.dispose();
            }
        });
    }

    private void setDialogLocation(Frame f) {
        Rectangle r = f.getBounds();
        int x = r.x + (r.width - this.getSize().width) / 2;
        int y = r.y + (r.height - this.getSize().height) / 2;
        this.setLocation(x, y);
    }

    public synchronized void addAllData(String msg, String find) {
        this.rows.clear();
        this.table.addNotify();
        if (msg.indexOf("~") >= 0) {
            String[] rowsVal = msg.split("\\~", -1);
            AnnouncementTab.TotalMessageSearch = rowsVal.length - 1;
            AnnouncementTab.MessageNoSearch = 0;
            for (int i = 0; i < rowsVal.length; ++i) {
                if (rowsVal[i].indexOf("@") < 0) continue;
                String[] columnVal = rowsVal[i].split("\\@", -1);
                Announcement announcement = null;
                try {
                    announcement = this.announcementTab.parse(columnVal, true);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                }
                if (announcement == null) {
                    --AnnouncementTab.TotalMessageSearch;
                    continue;
                }
                MessageDisplay display = new MessageDisplay(this, this.announcementTab, announcement, this.table, this.rows, find, AnnouncementTab.TotalMessageSearch);
                if (LogCommon.isTop) {
                    this.rows.add(0, display);
                } else {
                    this.rows.add(this.rows.size(), display);
                }
                this.table.addNotify();
                this.table.repaint();
                Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
            }
        }
        this.lblCount.setText(Util.format0digit((String)(this.rows.size() + "")) + " Record(s)  ");
    }

    public synchronized void addAllDataLive(String msg, String find) {
        this.rows.clear();
        this.table.addNotify();
        if (msg.indexOf("~") >= 0) {
            String[] rowsVal = msg.split("\\~", -1);
            AnnouncementLiveTab.TotalMessageSearch = rowsVal.length - 1;
            AnnouncementLiveTab.MessageNoSearch = 0;
            for (int i = 0; i < rowsVal.length; ++i) {
                if (rowsVal[i].indexOf("@") < 0) continue;
                String[] columnVal = rowsVal[i].split("\\@", -1);
                Announcement announcement = null;
                try {
                    announcement = this.announcementLiveTab.parse(columnVal, true);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                }
                if (announcement == null) {
                    --AnnouncementLiveTab.TotalMessageSearch;
                    continue;
                }
                MessageDisplay display = new MessageDisplay(this, this.announcementLiveTab, announcement, this.table, this.rows, find, AnnouncementLiveTab.TotalMessageSearch);
                if (LogCommon.isTop) {
                    this.rows.add(0, display);
                } else {
                    this.rows.add(this.rows.size(), display);
                }
                this.table.addNotify();
                this.table.repaint();
                Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
            }
        }
        this.lblCount.setText(Util.format0digit((String)(this.rows.size() + "")) + " Record(s)  ");
    }

    public void callSort(int index, boolean ascSec) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        this.announcementTab.callSort(this.rows, index, ascSec);
        this.table.tableChanged(new TableModelEvent(this.model));
        this.table.repaint();
    }

    private void initComponents() {
        this.sortMenu = new JPopupMenu();
        this.menuDate = new JCheckBoxMenuItem();
        this.menuCompany = new JCheckBoxMenuItem();
        this.menuScrip = new JCheckBoxMenuItem();
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.jSeparator1 = new JSeparator();
        this.lblMessage = new JLabel();
        this.toolBar = new JToolBar();
        this.btnSearch = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.btnAsen = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.btnDecn = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jPanel1 = new JPanel();
        this.collapsiblePane = new JXCollapsiblePane();
        this.sortMenu.setName("sortMenu");
        this.buttonGroup1.add(this.menuDate);
        this.menuDate.setSelected(true);
        this.menuDate.setText("Date");
        this.menuDate.setIcon(new ImageIcon(this.getClass().getResource("/Images/date16.png")));
        this.menuDate.setName("menuDate");
        this.menuDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowAnnouncementSearchResult.this.menuDateActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDate);
        this.buttonGroup1.add(this.menuCompany);
        this.menuCompany.setText("Company");
        this.menuCompany.setIcon(new ImageIcon(this.getClass().getResource("/Images/subject16.png")));
        this.menuCompany.setName("menuCompany");
        this.menuCompany.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowAnnouncementSearchResult.this.menuCompanyActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuCompany);
        this.buttonGroup1.add(this.menuScrip);
        this.menuScrip.setText("Scrip");
        this.menuScrip.setIcon(new ImageIcon(this.getClass().getResource("/Images/description16.png")));
        this.menuScrip.setName("menuScrip");
        this.menuScrip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowAnnouncementSearchResult.this.menuScripActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuScrip);
        this.setDefaultCloseOperation(2);
        this.jScrollPane1.setName("jScrollPane1");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setName("table");
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ShowAnnouncementSearchResult.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.jSeparator1.setName("jSeparator1");
        this.lblMessage.setText(" ");
        this.lblMessage.setName("lblMessage");
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setMaximumSize(new Dimension(116, 21));
        this.toolBar.setMinimumSize(new Dimension(116, 21));
        this.toolBar.setName("toolBar");
        this.toolBar.setPreferredSize(new Dimension(100, 18));
        this.btnSearch.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.btnSearch.setText("Search");
        this.btnSearch.setFocusable(false);
        this.btnSearch.setHorizontalTextPosition(4);
        this.btnSearch.setMaximumSize(new Dimension(18, 18));
        this.btnSearch.setMinimumSize(new Dimension(18, 18));
        this.btnSearch.setName("btnSearch");
        this.btnSearch.setPreferredSize(new Dimension(61, 18));
        this.btnSearch.setVerticalTextPosition(3);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowAnnouncementSearchResult.this.btnSearchActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnSearch);
        this.jSeparator2.setName("jSeparator2");
        this.toolBar.add(this.jSeparator2);
        this.btnAsen.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.btnAsen.setToolTipText("Sort Ascending");
        this.btnAsen.setFocusable(false);
        this.btnAsen.setHorizontalTextPosition(0);
        this.btnAsen.setMaximumSize(new Dimension(38, 18));
        this.btnAsen.setMinimumSize(new Dimension(38, 18));
        this.btnAsen.setName("btnAsen");
        this.btnAsen.setPreferredSize(new Dimension(38, 18));
        this.btnAsen.setVerticalTextPosition(3);
        this.btnAsen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowAnnouncementSearchResult.this.btnAsenActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnAsen);
        this.jSeparator3.setName("jSeparator3");
        this.toolBar.add(this.jSeparator3);
        this.btnDecn.setIcon(new ImageIcon(this.getClass().getResource("/Images/descending12.png")));
        this.btnDecn.setToolTipText("Sort Descending");
        this.btnDecn.setFocusable(false);
        this.btnDecn.setHorizontalTextPosition(0);
        this.btnDecn.setMaximumSize(new Dimension(38, 18));
        this.btnDecn.setMinimumSize(new Dimension(38, 18));
        this.btnDecn.setName("btnDecn");
        this.btnDecn.setPreferredSize(new Dimension(38, 18));
        this.btnDecn.setVerticalTextPosition(3);
        this.btnDecn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowAnnouncementSearchResult.this.btnDecnActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDecn);
        this.jSeparator4.setName("jSeparator4");
        this.toolBar.add(this.jSeparator4);
        this.jPanel1.setName("jPanel1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 647, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.toolBar.add(this.jPanel1);
        this.collapsiblePane.setName("collapsiblePane");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblMessage, -1, 800, Short.MAX_VALUE).addContainerGap()).addComponent(this.jSeparator1, -1, 820, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -1, 810, Short.MAX_VALUE).addContainerGap()).addComponent((Component)this.collapsiblePane, -1, 820, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 820, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.toolBar, -2, 21, -2).addGap(0, 0, 0).addComponent((Component)this.collapsiblePane, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 403, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addComponent(this.lblMessage)));
        this.pack();
    }

    private void btnSearchActionPerformed(ActionEvent evt) {
        boolean state = this.collapsiblePane.isCollapsed();
        this.collapsiblePane.setCollapsed(!state);
    }

    private void btnAsenActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(1, true);
        } else if (this.menuCompany.isSelected()) {
            this.callSort(2, true);
        } else if (this.menuScrip.isSelected()) {
            this.callSort(4, true);
        }
    }

    private void btnDecnActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(1, false);
        } else if (this.menuCompany.isSelected()) {
            this.callSort(2, false);
        } else if (this.menuScrip.isSelected()) {
            this.callSort(4, false);
        }
    }

    private void menuDateActionPerformed(ActionEvent evt) {
        this.callSort(1, this.isAsec);
    }

    private void menuCompanyActionPerformed(ActionEvent evt) {
        this.callSort(2, this.isAsec);
    }

    private void menuScripActionPerformed(ActionEvent evt) {
        this.callSort(4, this.isAsec);
    }

    private void tableMouseMoved(MouseEvent evt) {
        try {
            int rowindex = this.table.rowAtPoint(evt.getPoint());
            this.table.editCellAt(rowindex, 0);
            TableCellEditor tableCellEditor = this.table.getCellEditor(rowindex, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

