/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.Message;
import MessageWindow.MyTab;
import MyDocking.TradeCast;
import common.gui.util.AppConfig;
import common.gui.util.ImageUtil;
import common.gui.util.MyColors;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class ShowHouseMessagePopup
extends JDialog {
    private Color readColor = MyColors.houseReadBG;
    private Message message;
    SimpleDateFormat dfDay = new SimpleDateFormat("EEEE, MMM dd, yyyy");
    private JButton btnClose;
    private JEditorPane editorPane;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JPopupMenu popupMenu;

    public ShowHouseMessagePopup(MyTab myTab, Message message, String title) {
        super((Frame)TradeCast.getInstance().frame, false);
        this.message = message;
        this.initComponents();
        this.setBounds(0, 0, 642, 288);
        this.editorPane.setContentType("text/html");
        this.setAllValues(TradeCast.getInstance().frame, message, title);
    }

    private void setAllValues(JFrame parent, Message message, String title) {
        this.mySetTitle(title);
        this.setUnReadText();
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.jScrollPane1 = new JScrollPane();
        this.editorPane = new JEditorPane();
        this.jSeparator1 = new JSeparator();
        this.btnClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.editorPane.setEditable(false);
        this.editorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ShowHouseMessagePopup.this.editorPaneMousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.editorPane);
        this.btnClose.setText("Close");
        this.btnClose.setName("ShowHouseMessagePopup -> btnClose");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowHouseMessagePopup.this.btnCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnClose, -2, 69, -2).addGap(5, 5, 5)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 254, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addComponent(this.btnClose).addGap(3, 3, 3)));
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void editorPaneMousePressed(MouseEvent evt) {
    }

    private void mySetTitle(String title) {
        if (title.equalsIgnoreCase("HOUSE_MESSAGE")) {
            this.setTitle(AppConfig.companyName);
            try {
                if (AppConfig.houseIcon == null) {
                    AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setIconImage(AppConfig.houseIcon);
        }
    }

    private void setUnReadText() {
        String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
        sb.append("<tr COLOR='#373737' BGColor='#" + color + "' >");
        sb.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
        sb.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>" + this.message.subject.value);
        if (this.message.description.value.trim().length() > 0) {
            sb.append(" (" + this.message.description.value + ")");
        }
        sb.append("</b></font></td>");
        sb.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
        sb.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value + "</font></td>");
        sb.append("</tr>");
        sb.append("<tr >");
        sb.append("<td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>" + this.message.detail.value + "</b></font></div></td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</html>");
        this.editorPane.setText(sb.toString());
        this.editorPane.setCaretPosition(0);
    }
}

