/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import Beans.Announcement;
import MessageWindow.AnnouncementLiveTab;
import MessageWindow.AnnouncementScripDetail;
import MessageWindow.AnnouncementTab;
import MessageWindow.BoardMeetingTab;
import MessageWindow.MarginCallTab;
import MessageWindow.Message;
import MessageWindow.MessageDisplay;
import MessageWindow.MyTab;
import MessageWindow.PMEX_MessageDisplay;
import MessageWindow.PMEX_MyTab;
import MyDocking.MessageWindowCenter;
import MyDocking.TradeCast;
import Utilities.LogsTC;
import common.gui.util.AppConfig;
import common.gui.util.ImageUtil;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import kse.gui.bean.MarginCallBean;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class ShowMessage
extends JDialog
implements HyperlinkListener {
    JMenuItem selectAll = new JMenuItem("Select All");
    JMenuItem copy = new JMenuItem("Copy");
    JMenuItem markAsRead = new JMenuItem("Mark As Read");
    JMenuItem markAsUnread = new JMenuItem("Mark As Unread");
    Image newsIcon = null;
    Image boradMeeting = null;
    Image marginIcon = null;
    Image AnnouncementIcon = null;
    private int totalMsg = 0;
    private Color readColor = Color.LIGHT_GRAY;
    private Color blinkColor = Color.YELLOW;
    private Message message;
    private boolean isRead = true;
    private MessageDisplay md;
    private PMEX_MessageDisplay mdPMEX;
    private MyTab myTab = null;
    private PMEX_MyTab myTabPMEX = null;
    private Vector<MessageDisplay> rows;
    private Vector<PMEX_MessageDisplay> rowsPMEX;
    private int rowindex = 0;
    private MarginCallBean margin;
    private Announcement announcement;
    SimpleDateFormat dfDay = new SimpleDateFormat("EEEE, MMM dd, yyyy");
    final String find = "";
    private AnnouncementTab announcementTab;
    private AnnouncementLiveTab announcementLiveTab;
    private AnnouncementScripDetail announcementScripDetail;
    private int totalMessage;
    public static boolean isAnnouncementsSearchOpen = false;
    private Timer timer;
    public static Rectangle lastBound = new Rectangle(100, 100, 100, 100);
    private static boolean isFirstTime = false;
    private final int cascadingGap = 30;
    private BoardMeetingTab boardMeetingTab;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnClose;
    private JButton btnNext;
    private JButton btnPrevious;
    private JEditorPane editorPane;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JPopupMenu popupMenu;

    public ShowMessage(MyTab myTab, JFrame parent, Message message, String title, MessageDisplay md, Vector<MessageDisplay> rows) {
        super((Frame)parent, false);
        this.myTab = myTab;
        this.newsIcon = new ImageIcon(this.getClass().getResource("/Images/News16.png")).getImage();
        this.boradMeeting = new ImageIcon(this.getClass().getResource("/Images/Meeting16x16.png")).getImage();
        this.marginIcon = new ImageIcon(this.getClass().getResource("/Images/MarginCall16x16.png")).getImage();
        this.AnnouncementIcon = new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")).getImage();
        this.setAllValues(parent, message, title, md, rows);
    }

    public ShowMessage(PMEX_MyTab myTab, JFrame parent, Message message, String title, PMEX_MessageDisplay md, Vector<PMEX_MessageDisplay> rows) {
        super((Frame)parent, false);
        this.myTabPMEX = myTab;
        this.newsIcon = new ImageIcon(this.getClass().getResource("/Images/News16.png")).getImage();
        this.boradMeeting = new ImageIcon(this.getClass().getResource("/Images/Meeting16x16.png")).getImage();
        this.marginIcon = new ImageIcon(this.getClass().getResource("/Images/MarginCall16x16.png")).getImage();
        this.AnnouncementIcon = new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")).getImage();
        this.setAllValues(parent, message, title, md, rows);
    }

    public ShowMessage(JFrame parent, MarginCallBean margin, MessageDisplay md, Vector<MessageDisplay> rows) {
        super((Frame)parent, false);
        this.margin = margin;
        this.setIconImage(this.marginIcon);
        this.newsIcon = new ImageIcon(this.getClass().getResource("/Images/News16.png")).getImage();
        this.boradMeeting = new ImageIcon(this.getClass().getResource("/Images/Meeting16x16.png")).getImage();
        this.marginIcon = new ImageIcon(this.getClass().getResource("/Images/MarginCall16x16.png")).getImage();
        this.AnnouncementIcon = new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")).getImage();
        this.setAllValues(parent, md, rows);
    }

    public ShowMessage(JFrame parent, AnnouncementTab announcementTab, Announcement announcement, MessageDisplay md, Vector<MessageDisplay> rows, int totalMessage) {
        super((Frame)parent, false);
        this.totalMessage = totalMessage;
        this.announcementTab = announcementTab;
        this.newsIcon = new ImageIcon(this.getClass().getResource("/Images/News16.png")).getImage();
        this.boradMeeting = new ImageIcon(this.getClass().getResource("/Images/Meeting16x16.png")).getImage();
        this.marginIcon = new ImageIcon(this.getClass().getResource("/Images/MarginCall16x16.png")).getImage();
        this.AnnouncementIcon = new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")).getImage();
        this.setAllValues(parent, announcement, LanguageConstant.Announcement, md, rows);
    }

    public ShowMessage(AnnouncementTab announcementTab, JFrame parent, Announcement announcement, MessageDisplay md, Vector<MessageDisplay> rows, int totalMessage) {
        super((Frame)parent, false);
        this.announcementTab = announcementTab;
        this.totalMessage = totalMessage;
        this.newsIcon = new ImageIcon(this.getClass().getResource("/Images/News16.png")).getImage();
        this.boradMeeting = new ImageIcon(this.getClass().getResource("/Images/Meeting16x16.png")).getImage();
        this.marginIcon = new ImageIcon(this.getClass().getResource("/Images/MarginCall16x16.png")).getImage();
        this.AnnouncementIcon = new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")).getImage();
        this.setAllValues(parent, announcement, LanguageConstant.Announcement, md, rows);
    }

    public ShowMessage(JFrame parent, AnnouncementLiveTab announcementLiveTab, Announcement announcement, MessageDisplay md, Vector<MessageDisplay> rows, int totalMessage) {
        super((Frame)parent, false);
        this.totalMessage = totalMessage;
        this.announcementLiveTab = announcementLiveTab;
        this.newsIcon = new ImageIcon(this.getClass().getResource("/Images/News16.png")).getImage();
        this.boradMeeting = new ImageIcon(this.getClass().getResource("/Images/Meeting16x16.png")).getImage();
        this.marginIcon = new ImageIcon(this.getClass().getResource("/Images/MarginCall16x16.png")).getImage();
        this.AnnouncementIcon = new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")).getImage();
        this.setAllValues(parent, announcement, LanguageConstant.Announcement, md, rows);
    }

    public ShowMessage(AnnouncementLiveTab announcementLiveTab, JFrame parent, Announcement announcement, MessageDisplay md, Vector<MessageDisplay> rows, int totalMessage) {
        super((Frame)parent, false);
        this.announcementLiveTab = announcementLiveTab;
        this.totalMessage = totalMessage;
        this.newsIcon = new ImageIcon(this.getClass().getResource("/Images/News16.png")).getImage();
        this.boradMeeting = new ImageIcon(this.getClass().getResource("/Images/Meeting16x16.png")).getImage();
        this.marginIcon = new ImageIcon(this.getClass().getResource("/Images/MarginCall16x16.png")).getImage();
        this.AnnouncementIcon = new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")).getImage();
        this.setAllValues(parent, announcement, LanguageConstant.Announcement, md, rows);
    }

    public ShowMessage(JFrame parent, AnnouncementScripDetail announcementScripDetail, Announcement announcement, MessageDisplay md, Vector<MessageDisplay> rows, int totalMessage) {
        super((Frame)parent, false);
        this.totalMessage = totalMessage;
        this.announcementScripDetail = announcementScripDetail;
        this.newsIcon = new ImageIcon(this.getClass().getResource("/Images/News16.png")).getImage();
        this.boradMeeting = new ImageIcon(this.getClass().getResource("/Images/Meeting16x16.png")).getImage();
        this.marginIcon = new ImageIcon(this.getClass().getResource("/Images/MarginCall16x16.png")).getImage();
        this.AnnouncementIcon = new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")).getImage();
        this.setAllValues(parent, announcement, LanguageConstant.Announcement, md, rows);
    }

    public ShowMessage(AnnouncementScripDetail announcementScripDetail, JFrame parent, Announcement announcement, MessageDisplay md, Vector<MessageDisplay> rows, int totalMessage) {
        super((Frame)parent, false);
        this.announcementScripDetail = announcementScripDetail;
        this.totalMessage = totalMessage;
        this.newsIcon = new ImageIcon(this.getClass().getResource("/Images/News16.png")).getImage();
        this.boradMeeting = new ImageIcon(this.getClass().getResource("/Images/Meeting16x16.png")).getImage();
        this.marginIcon = new ImageIcon(this.getClass().getResource("/Images/MarginCall16x16.png")).getImage();
        this.AnnouncementIcon = new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")).getImage();
        this.setAllValues(parent, announcement, LanguageConstant.Announcement, md, rows);
    }

    public ShowMessage(BoardMeetingTab boardMeetingTab, JFrame parent, Message message, String type, MessageDisplay md, Vector<MessageDisplay> rows) {
        super((Frame)parent, false);
        this.boardMeetingTab = boardMeetingTab;
        this.newsIcon = new ImageIcon(this.getClass().getResource("/Images/News16.png")).getImage();
        this.boradMeeting = new ImageIcon(this.getClass().getResource("/Images/Meeting16x16.png")).getImage();
        this.marginIcon = new ImageIcon(this.getClass().getResource("/Images/MarginCall16x16.png")).getImage();
        this.AnnouncementIcon = new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")).getImage();
        this.setAllValues(parent, message, type, md, rows);
    }

    private void setAllValues(JFrame parent, MessageDisplay md, Vector<MessageDisplay> rows) {
        this.md = md;
        this.rows = rows;
        this.initComponents();
        this.btnNext.setText("Next");
        this.setDialogLocation(parent);
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditorKit(new HTMLEditorKit());
        this.setMinimumSize(new Dimension(350, 200));
        this.totalMsg = rows.size();
        this.setMarginCallText(false);
        this.setResizable(true);
        this.setTitle("Margin Calls");
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowMessage.this.closeIt();
            }
        });
        this.setRowIndex();
        this.setVisible(true);
        this.setPopupMenu();
    }

    private void setAllValues(JFrame parent, Message message, String type, MessageDisplay md, Vector<MessageDisplay> rows) {
        this.message = message;
        this.md = md;
        this.rows = rows;
        this.initComponents();
        this.btnNext.setText("Next");
        this.setDialogLocation(parent);
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditorKit(new HTMLEditorKit());
        this.setMinimumSize(new Dimension(350, 200));
        this.totalMsg = rows.size();
        this.mySetTitle(type);
        if (type.equalsIgnoreCase("BOARD_MEETING")) {
            this.setBoardMeetingText();
        } else {
            this.setReadText();
        }
        this.setResizable(true);
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowMessage.this.closeIt();
            }
        });
        this.setRowIndex();
        this.setVisible(true);
        this.setPopupMenu();
    }

    private void setAllValues(JFrame parent, Message message, String type, PMEX_MessageDisplay md, Vector<PMEX_MessageDisplay> rows) {
        this.message = message;
        this.mdPMEX = md;
        this.rowsPMEX = rows;
        this.initComponents();
        this.btnNext.setText("Next");
        this.setDialogLocation(parent);
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditorKit(new HTMLEditorKit());
        this.setMinimumSize(new Dimension(350, 200));
        this.totalMsg = rows.size();
        this.mySetTitle(type);
        if (type.equalsIgnoreCase("BOARD_MEETING")) {
            this.setBoardMeetingText();
        } else {
            this.setReadText();
        }
        this.setResizable(true);
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowMessage.this.closeIt();
            }
        });
        this.setRowIndex();
        this.setVisible(true);
        this.setPopupMenu();
    }

    private void setAllValues(JFrame parent, Announcement announcement, String title, MessageDisplay md, Vector<MessageDisplay> rows) {
        this.announcement = announcement;
        this.md = md;
        this.rows = rows;
        this.initComponents();
        this.btnNext.setText("Next");
        this.setDialogLocation(parent);
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditorKit(new HTMLEditorKit());
        this.editorPane.addHyperlinkListener(this);
        this.setMinimumSize(new Dimension(350, 200));
        this.setTitle(this.languageCentre.getValue(title));
        this.setIconImage(this.AnnouncementIcon);
        this.setAnnouncementText(true, this.totalMessage);
        this.setResizable(true);
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowMessage.this.closeIt();
            }
        });
        this.setRowIndex();
        this.setVisible(true);
        this.setPopupMenuForAnnouncement();
    }

    private void closeIt() {
        this.dispose();
        this.disposeMe();
    }

    private void setDialogLocation(Frame f) {
        Rectangle r = f.getBounds();
        int x = r.x + (r.width - this.getSize().width) / 2;
        int y = r.y + (r.height - this.getSize().height) / 2;
        this.setLocation(x, y);
    }

    public void disposeMe() {
        if (!LogsTC.showMessageWidow.isEmpty() && LogsTC.showMessageWidow.size() != 1) {
            LogsTC.showMessageWidow.pop();
        }
        TradeCast.getInstance().setShowMessageFocus();
    }

    private void setPopupMenu() {
        this.markAsRead.setIcon(new ImageIcon(this.getClass().getResource("/Images/markRead.png")));
        this.markAsRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowMessage.this.markAsRead();
            }
        });
        this.markAsUnread.setIcon(new ImageIcon(this.getClass().getResource("/Images/markUnread.png")));
        this.markAsUnread.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowMessage.this.markAsUnread();
            }
        });
        this.selectAll.setIcon(new ImageIcon(this.getClass().getResource("/Images/paste.png")));
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowMessage.this.editorPane.selectAll();
            }
        });
        this.copy.setIcon(new ImageIcon(this.getClass().getResource("/Images/paste.png")));
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Util.setClipboard((String)ShowMessage.this.editorPane.getSelectedText());
            }
        });
        if (this.message != null) {
            this.popupMenu.add(this.markAsRead);
            this.popupMenu.add(this.markAsUnread);
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.selectAll);
            this.popupMenu.add(this.copy);
        } else if (this.margin != null) {
            this.popupMenu.add(this.selectAll);
            this.popupMenu.add(this.copy);
        }
    }

    private void setPopupMenuForAnnouncement() {
        this.markAsRead.setIcon(new ImageIcon(this.getClass().getResource("/Images/markRead.png")));
        this.markAsRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowMessage.this.markAsRead();
            }
        });
        this.markAsUnread.setIcon(new ImageIcon(this.getClass().getResource("/Images/markUnread.png")));
        this.markAsUnread.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowMessage.this.markAsUnread();
            }
        });
        this.selectAll.setIcon(new ImageIcon(this.getClass().getResource("/Images/paste.png")));
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowMessage.this.editorPane.selectAll();
            }
        });
        this.copy.setIcon(new ImageIcon(this.getClass().getResource("/Images/paste.png")));
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Util.setClipboard((String)ShowMessage.this.editorPane.getSelectedText());
            }
        });
        if (this.announcement != null) {
            this.popupMenu.add(this.markAsRead);
            this.popupMenu.add(this.markAsUnread);
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.selectAll);
            this.popupMenu.add(this.copy);
        }
    }

    private void setNavigationText(int rowNo) {
        if (this.message != null) {
            if (this.rows != null) {
                this.message = this.rows.get((int)rowNo).message;
            }
            if (this.rowsPMEX != null) {
                this.message = this.rowsPMEX.get((int)rowNo).message;
            }
            this.markAsRead();
        } else if (this.margin != null) {
            this.margin = this.rows.get((int)rowNo).margin;
            this.setMarginCallText(false);
        } else if (this.announcement != null) {
            if (this.announcementScripDetail != null) {
                this.announcement = this.rows.get((int)rowNo).announcement;
                this.announcement.isRead = true;
                if (isAnnouncementsSearchOpen) {
                    this.setAnnouncementText(true, AnnouncementScripDetail.TotalMessageSearch);
                } else {
                    this.setAnnouncementText(true, AnnouncementScripDetail.TotalMessage);
                }
                this.markAsRead();
            } else {
                this.announcement = this.rows.get((int)rowNo).announcement;
                this.announcement.isRead = true;
                if (isAnnouncementsSearchOpen) {
                    this.setAnnouncementText(true, AnnouncementTab.TotalMessageSearch);
                } else {
                    if (this.announcementTab != null) {
                        this.setAnnouncementText(true, AnnouncementTab.TotalMessage);
                    }
                    if (this.announcementLiveTab != null) {
                        this.setAnnouncementText(true, AnnouncementLiveTab.TotalMessage);
                    }
                }
                this.markAsRead();
            }
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.jScrollPane1 = new JScrollPane();
        this.editorPane = new JEditorPane();
        this.jSeparator1 = new JSeparator();
        this.btnClose = new JButton();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.setDefaultCloseOperation(2);
        this.editorPane.setEditable(false);
        this.editorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ShowMessage.this.editorPaneMousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.editorPane);
        this.btnClose.setText("Close");
        this.btnClose.setName("ShowMessage -> btnClose");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowMessage.this.btnCloseActionPerformed(evt);
            }
        });
        this.btnPrevious.setText("Previous");
        this.btnPrevious.setName("ShowMessage -> btnPrevious");
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowMessage.this.btnPreviousActionPerformed(evt);
            }
        });
        this.btnNext.setText("Next");
        this.btnNext.setName("ShowMessage -> btnNext");
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowMessage.this.btnNextActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.btnPrevious).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNext, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnClose, -2, 69, -2).addGap(5, 5, 5)));
        layout.linkSize(0, this.btnClose, this.btnNext, this.btnPrevious);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 254, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnClose).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnNext).addComponent(this.btnPrevious))).addGap(3, 3, 3)));
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.closeIt();
    }

    private void editorPaneMousePressed(MouseEvent evt) {
        this.editorPane.requestFocus();
        if (SwingUtilities.isRightMouseButton(evt)) {
            if (this.editorPane.getSelectedText() == null) {
                this.copy.setEnabled(false);
            } else {
                this.copy.setEnabled(true);
            }
            if (this.isRead) {
                this.markAsRead.setEnabled(false);
                this.markAsUnread.setEnabled(true);
            } else {
                this.markAsRead.setEnabled(true);
                this.markAsUnread.setEnabled(false);
            }
            this.popupMenu.show(this.editorPane, evt.getX(), evt.getY());
        }
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        if (--this.rowindex <= 0) {
            this.btnNext.setEnabled(false);
            this.btnPrevious.setEnabled(true);
            this.setNavigationText(this.rowindex);
        } else if (this.rowindex > 0) {
            this.btnPrevious.setEnabled(true);
            this.setNavigationText(this.rowindex);
        } else {
            ++this.rowindex;
        }
        this.editorPane.setCaretPosition(0);
    }

    private void btnPreviousActionPerformed(ActionEvent evt) {
        if (this.rows != null) {
            if (++this.rowindex >= this.rows.size() - 1) {
                this.btnPrevious.setEnabled(false);
                this.btnNext.setEnabled(true);
                this.setNavigationText(this.rowindex);
            } else if (this.rowindex < this.rows.size()) {
                this.btnNext.setEnabled(true);
                this.setNavigationText(this.rowindex);
            } else {
                --this.rowindex;
            }
        } else if (this.rowsPMEX != null) {
            if (++this.rowindex >= this.rowsPMEX.size() - 1) {
                this.btnPrevious.setEnabled(false);
                this.btnNext.setEnabled(true);
                this.setNavigationText(this.rowindex);
            } else if (this.rowindex < this.rowsPMEX.size()) {
                this.btnNext.setEnabled(true);
                this.setNavigationText(this.rowindex);
            } else {
                --this.rowindex;
            }
        }
        this.editorPane.setCaretPosition(0);
    }

    private void mySetTitle(String title) {
        if (title.equalsIgnoreCase(LanguageConstant.News)) {
            this.setTitle(this.languageCentre.getValue(LanguageConstant.News));
            this.setIconImage(this.newsIcon);
            this.readColor = MyColors.newsReadBG;
        }
        if (title.equalsIgnoreCase("Commodity News")) {
            this.setTitle("Commodity News");
            this.setIconImage(this.newsIcon);
            this.readColor = MyColors.newsReadBG;
        } else if (title.equalsIgnoreCase("HOUSE_MESSAGE")) {
            this.setTitle(AppConfig.companyName);
            try {
                if (AppConfig.houseIcon == null) {
                    AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setIconImage(AppConfig.houseIcon);
            this.readColor = MyColors.houseReadBG;
        } else if (title.equalsIgnoreCase("BOARD_MEETING")) {
            this.setTitle(this.languageCentre.getValue(LanguageConstant.BoardMeeting));
            this.setIconImage(this.boradMeeting);
            this.readColor = MyColors.boardReadBG;
        }
    }

    private void setReadText() {
        this.isRead = true;
        String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
        sb.append("<tr COLOR='#373737' BGColor='#" + color + "'>");
        sb.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
        sb.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>" + this.message.subject.value);
        if (this.message.description.value.trim().length() > 0) {
            sb.append(" (" + this.message.description.value + ")");
        }
        sb.append(" </b></font></td>");
        sb.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
        sb.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value + " | " + Util.format0digit((String)(this.message.msgNo + "")) + " of " + Util.format0digit((String)(this.totalMsg + "")) + "</font></td>");
        sb.append("</tr>");
        sb.append("<tr >");
        sb.append("<td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>" + this.message.detail.value + "</font></div></td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</html>");
        this.editorPane.setText(sb.toString());
        this.editorPane.setCaretPosition(0);
    }

    private void setUnReadText() {
        this.isRead = false;
        String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
        sb.append("<tr COLOR='#373737' BGColor='#" + color + "' >");
        sb.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
        sb.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>" + this.message.subject.value);
        if (this.message.description.value.trim().length() > 0) {
            sb.append(" (" + this.message.description.value + ")");
        }
        sb.append("</b></font></td>");
        sb.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
        sb.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value + " | " + Util.format0digit((String)(this.message.msgNo + "")) + " of " + Util.format0digit((String)(this.totalMsg + "")) + "</font></td>");
        sb.append("</tr>");
        sb.append("<tr >");
        sb.append("<td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>" + this.message.detail.value + "</b></font></div></td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</html>");
        this.editorPane.setText(sb.toString());
        this.editorPane.setCaretPosition(0);
    }

    private void setBoardMeetingText() {
        if (this.message != null) {
            if (this.message.isRead) {
                this.setBoardMeetingTextRead(true);
            } else {
                this.setBoardMeetingTextUnRead(true);
            }
        }
    }

    private void setBoardMeetingTextRead(boolean isNewLine) {
        String color = Integer.toHexString(MyColors.boardReadBG.getRGB() & 0xFFFFFF);
        String HtmlText = "<html><table border=0px CELLPADDING='-1' width='100%' height='100px'><tr width='100%' COLOR='#373737' BGColor='#" + color + "'><td width='92%' style='margin:2px; padding-left:2px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b><a href='' style='color:#373737; text-decoration:none'>" + ShowMessage.HightLight(this.message.subject.value.trim(), "") + " (" + ShowMessage.HightLight(this.message.description.value.trim(), "") + ")</a></b></font></td><td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value.trim() + " | " + Util.format0digit((String)(this.message.msgNo + "")) + " of " + Util.format0digit((String)(this.totalMsg + "")) + "</td></tr><tr ><td colspan=2 style='margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>" + ShowMessage.HightLight(this.message.detail.value.trim(), "") + "</font></div></td></tr></table></html>";
        this.editorPane.setText(HtmlText);
        this.editorPane.setCaretPosition(0);
    }

    private void setBoardMeetingTextUnRead(boolean isNewLine) {
        String color = Integer.toHexString(MyColors.boardReadBG.getRGB() & 0xFFFFFF);
        if (this.message != null) {
            String HtmlText = "<html><table border=0px CELLPADDING='-1' width='100%' height='100px'><tr COLOR='#373737' BGColor='#" + color + "'><td width='92%' style='margin:2px; padding-left:2px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b><a href='' style='color:#373737; text-decoration:none'>" + ShowMessage.HightLight(this.message.subject.value, "") + " (" + ShowMessage.HightLight(this.message.description.value, "") + ")</a></b></font></td><td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value + " | " + Util.format0digit((String)(this.message.msgNo + "")) + " of " + Util.format0digit((String)(this.totalMsg + "")) + "</font></td></tr><tr ><td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>" + ShowMessage.HightLight(this.message.detail.value, "") + "</b></font></div></td></tr></table></html>";
            this.editorPane.setText(HtmlText);
            this.editorPane.setCaretPosition(0);
        }
    }

    public void setMarginCallText(boolean isBlink) {
        if (LogsKSE.MarginCallText.indexOf("~~") >= 0) {
            String[] DynamicText = LogsKSE.MarginCallText.split("\\~~", -1);
            String HtmlText = "";
            DynamicText[0] = DynamicText[0].replaceAll("%ACCOUNT%", this.margin.account);
            DynamicText[0] = DynamicText[0].replaceAll("%CALL%", this.margin.call);
            DynamicText[0] = DynamicText[0].replaceAll("%ACCOUNTNAME%", this.margin.name);
            DynamicText[0] = DynamicText[0].replaceAll("%RS%", this.margin.shortfall);
            DynamicText[0] = DynamicText[0].replaceAll("%PERCENT%", this.margin.shortfallPer + "%");
            DynamicText[0] = DynamicText[0].replaceAll("%DATETIME%", this.margin.dateTime + " | " + this.margin.msgID + " of " + MarginCallTab.TotalMessage);
            DynamicText[1] = DynamicText[1].replaceAll("%ACCOUNT%", this.margin.account);
            DynamicText[1] = DynamicText[1].replaceAll("%CALL%", this.margin.call);
            DynamicText[1] = DynamicText[1].replaceAll("%ACCOUNTNAME%", this.margin.name);
            DynamicText[1] = DynamicText[1].replaceAll("%RS%", this.margin.shortfall);
            DynamicText[1] = DynamicText[1].replaceAll("%PERCENT%", this.margin.shortfallPer + "%");
            DynamicText[1] = DynamicText[1].replaceAll("%DATETIME%", this.margin.dateTime + " | " + this.margin.msgID + " of " + MarginCallTab.TotalMessage);
            DynamicText[2] = DynamicText[2].replaceAll("%ACCOUNT%", this.margin.account);
            DynamicText[2] = DynamicText[2].replaceAll("%CALL%", this.margin.call);
            DynamicText[2] = DynamicText[2].replaceAll("%ACCOUNTNAME%", this.margin.name);
            DynamicText[2] = DynamicText[2].replaceAll("%RS%", this.margin.shortfall);
            DynamicText[2] = DynamicText[2].replaceAll("%PERCENT%", this.margin.shortfallPer + "%");
            DynamicText[2] = DynamicText[2].replaceAll("%DATETIME%", this.margin.dateTime + " | " + this.margin.msgID + " of " + MarginCallTab.TotalMessage);
            String color = "ffcc66";
            if (this.margin.call.equalsIgnoreCase("First Margin Call")) {
                color = Integer.toHexString(MyColors.marginCall1st.getRGB() & 0xFFFFFF);
                if (isBlink) {
                    color = Integer.toHexString(Color.YELLOW.getRGB() & 0xFFFFFF);
                }
                DynamicText[0] = DynamicText[0].replaceAll("%HEADERBGCOLOR%", color);
                HtmlText = DynamicText[0];
            } else if (this.margin.call.equalsIgnoreCase("Second Margin Call")) {
                color = Integer.toHexString(MyColors.marginCall2nd.getRGB() & 0xFFFFFF);
                if (isBlink) {
                    color = Integer.toHexString(Color.YELLOW.getRGB() & 0xFFFFFF);
                }
                DynamicText[1] = DynamicText[1].replaceAll("%HEADERBGCOLOR%", color);
                HtmlText = DynamicText[1];
            } else if (this.margin.call.equalsIgnoreCase("Final Margin Call")) {
                color = Integer.toHexString(MyColors.marginCall3rd.getRGB() & 0xFFFFFF);
                if (isBlink) {
                    color = Integer.toHexString(Color.YELLOW.getRGB() & 0xFFFFFF);
                }
                DynamicText[2] = DynamicText[2].replaceAll("%HEADERBGCOLOR%", color);
                HtmlText = DynamicText[2];
            }
            this.editorPane.setText(HtmlText);
            this.editorPane.setCaretPosition(0);
        }
    }

    private void setRowIndex() {
        block12: {
            block13: {
                if (this.rows == null) break block13;
                for (int i = 0; i < this.rows.size(); ++i) {
                    MessageDisplay messageDisplay = this.rows.elementAt(i);
                    if (messageDisplay.message != null) {
                        if (!messageDisplay.message.id.value.equalsIgnoreCase(this.message.id.value)) continue;
                        this.rowindex = i;
                        if (i == this.rows.size() - 1) {
                            this.btnPrevious.setEnabled(false);
                        }
                        if (i != 0) break block12;
                        this.btnNext.setEnabled(false);
                        break block12;
                    }
                    if (messageDisplay.margin != null) {
                        if (!messageDisplay.margin.account.equalsIgnoreCase(this.margin.account)) continue;
                        this.rowindex = i;
                        if (i == this.rows.size() - 1) {
                            this.btnPrevious.setEnabled(false);
                        }
                        if (i != 0) break block12;
                        this.btnNext.setEnabled(false);
                        break block12;
                    }
                    if (messageDisplay.announcement == null || !messageDisplay.announcement.id.equalsIgnoreCase(this.announcement.id)) continue;
                    this.rowindex = i;
                    if (i == this.rows.size() - 1) {
                        this.btnPrevious.setEnabled(false);
                    }
                    if (i != 0) break block12;
                    this.btnNext.setEnabled(false);
                    break block12;
                }
                break block12;
            }
            if (this.rowsPMEX == null) break block12;
            for (int i = 0; i < this.rowsPMEX.size(); ++i) {
                PMEX_MessageDisplay messageDisplay = this.rowsPMEX.elementAt(i);
                if (messageDisplay.message != null) {
                    if (!messageDisplay.message.id.value.equalsIgnoreCase(this.message.id.value)) continue;
                    this.rowindex = i;
                    if (i == this.rowsPMEX.size() - 1) {
                        this.btnPrevious.setEnabled(false);
                    }
                    if (i != 0) break;
                    this.btnNext.setEnabled(false);
                    break;
                }
                if (messageDisplay.margin != null) {
                    if (!messageDisplay.margin.account.equalsIgnoreCase(this.margin.account)) continue;
                    this.rowindex = i;
                    if (i == this.rowsPMEX.size() - 1) {
                        this.btnPrevious.setEnabled(false);
                    }
                    if (i != 0) break;
                    this.btnNext.setEnabled(false);
                    break;
                }
                if (messageDisplay.announcement == null || !messageDisplay.announcement.id.equalsIgnoreCase(this.announcement.id)) continue;
                this.rowindex = i;
                if (i == this.rowsPMEX.size() - 1) {
                    this.btnPrevious.setEnabled(false);
                }
                if (i != 0) break;
                this.btnNext.setEnabled(false);
                break;
            }
        }
    }

    private void setAnnouncementText(String color, int totalMessage) {
        if (this.announcement.isRead && this.announcement.isManualEntry) {
            this.setAnnouncementTextRead(color, totalMessage);
        } else if (!this.announcement.isRead && this.announcement.isManualEntry) {
            this.setAnnouncementTextUnRead(color, totalMessage);
        } else if (this.announcement.isRead && !this.announcement.isManualEntry) {
            this.setAnnouncementFileTextRead(color, totalMessage);
        } else if (!this.announcement.isRead && !this.announcement.isManualEntry) {
            this.setAnnouncementFileTextUnRead(color, totalMessage);
        }
    }

    public void setAnnouncementText(boolean status, int totalMessage) {
        String color = Integer.toHexString(MyColors.AnnouncementsBG.getRGB() & 0xFFFFFF);
        if (status) {
            color = Integer.toHexString(MyColors.AnnouncementsBG.getRGB() & 0xFFFFFF);
            this.setAnnouncementText(color, totalMessage);
        } else {
            color = Integer.toHexString(Color.YELLOW.getRGB() & 0xFFFFFF);
            this.setAnnouncementText(color, totalMessage);
        }
    }

    private void setAnnouncementTextRead(String color, int totalMessage) {
        StringBuilder sb = new StringBuilder();
        String td = "<td colspan = '2' style='padding-left:3px; margin-top:3px'>";
        sb.append("<html>");
        sb.append("<table style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal' width='100%' border='0px' cellpadding ='0px' cellspacing='0px' bgcolor='white'>");
        sb.append("<tr style='height:15px; background-color:#" + color + "'>");
        sb.append("<td style='margin:2px; padding-left:2px; height: 15px;' color='black'>");
        sb.append("<b>");
        sb.append(ShowMessage.HightLight(this.announcement.scrip + " (" + this.announcement.company + ")", ""));
        sb.append("</b>");
        sb.append("</td>");
        sb.append("<td nowrap='nowrap' color='light-gray' valign=top style='text-align:right;margin:3px; padding-right:3px; height: 15px;'>");
        sb.append(this.announcement.dateTime);
        sb.append(" | " + Util.format0digit((String)(this.announcement.msgNo + "")) + " of " + Util.format0digit((String)(totalMessage + "")));
        sb.append("</td>");
        sb.append("</tr>");
        if (!this.announcement.AGM.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append(ShowMessage.HightLight("Annual General Meeting will be held on " + this.announcement.AGM, ""));
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.EPS.equalsIgnoreCase("")) {
            boolean isDouble = false;
            try {
                Double.parseDouble(this.announcement.EPS);
                isDouble = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append("<tr >");
            sb.append(td);
            if (isDouble) {
                sb.append(ShowMessage.HightLight("Earning per Share is Rs. " + Util.format2digit((String)this.announcement.EPS) + "/-", ""));
            } else {
                sb.append(ShowMessage.HightLight("Earning per Share is " + this.announcement.EPS, ""));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.FYE.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append(ShowMessage.HightLight("Financial year ended " + this.announcement.FYE, ""));
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.PLBeforeTax.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            double dd = 0.0;
            try {
                dd = Double.parseDouble(this.announcement.PLBeforeTax);
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Profit / Loss before Taxation is " + this.announcement.PLBeforeTax, ""));
            }
            if (dd >= 0.0) {
                sb.append(ShowMessage.HightLight("Profit before Taxation is Rs. " + Util.format0digit((String)this.announcement.PLBeforeTax) + " Million", ""));
            } else {
                sb.append(ShowMessage.HightLight("Loss before Taxation is Rs. " + Util.format0digit((String)this.announcement.PLBeforeTax) + " Million", ""));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.PLAfterTax.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            double dd = 0.0;
            try {
                dd = Double.parseDouble(this.announcement.PLAfterTax);
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Profit / Loss after Taxation is " + this.announcement.PLAfterTax, ""));
            }
            if (dd >= 0.0) {
                sb.append(ShowMessage.HightLight("Profit after Taxation is Rs. " + Util.format0digit((String)this.announcement.PLAfterTax) + " Million", ""));
            } else {
                sb.append(ShowMessage.HightLight("Loss after Taxation is Rs. " + Util.format0digit((String)this.announcement.PLAfterTax) + " Million", ""));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.bookClosureStartDate.equalsIgnoreCase("")) {
            Date date2;
            try {
                date2 = this.dfDay.parse(this.announcement.bookClosureStartDate);
                this.announcement.bookClosureStartDate = LogsTC.dateFormatAcc.format(date2);
            }
            catch (ParseException date2) {
                // empty catch block
            }
            try {
                date2 = this.dfDay.parse(this.announcement.bookClosureEndDate);
                this.announcement.bookClosureEndDate = LogsTC.dateFormatAcc.format(date2);
            }
            catch (ParseException date3) {
                // empty catch block
            }
            sb.append("<tr >");
            sb.append(td);
            sb.append(ShowMessage.HightLight("Book Closure from " + this.announcement.bookClosureStartDate + " to " + this.announcement.bookClosureEndDate, ""));
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.divedend.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            try {
                Double.parseDouble(this.announcement.divedend);
                sb.append(ShowMessage.HightLight("Dividend issued for the " + this.announcement.period + " is " + Util.format2digit((String)this.announcement.divedend) + "%", ""));
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Dividend issued for the " + this.announcement.period + " is " + this.announcement.divedend, ""));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (this.announcement.divedend.equalsIgnoreCase("") && !this.announcement.period.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append("Period (" + ShowMessage.HightLight(this.announcement.period, "") + ")");
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.bonus.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            try {
                Double.parseDouble(this.announcement.bonus);
                sb.append(ShowMessage.HightLight("Bonus shares issued for the " + this.announcement.period + " are " + Util.format2digit((String)this.announcement.bonus) + "%", ""));
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Bonus shares issued for the " + this.announcement.period + " are " + this.announcement.bonus, ""));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.right.equalsIgnoreCase("") && !this.announcement.premium.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            try {
                Double.parseDouble(this.announcement.premium);
                sb.append(ShowMessage.HightLight("Right shares issued for the " + this.announcement.period + " are " + Util.format2digit((String)this.announcement.right) + "%, at the Premium of Rs. " + Util.format2digit((String)this.announcement.premium) + "/- per share", ""));
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Right shares issued for the " + this.announcement.period + " are " + this.announcement.right + "%, at the Premium of " + this.announcement.premium + " per share", ""));
            }
            sb.append("</td>");
            sb.append("</tr>");
        } else if (!this.announcement.right.equalsIgnoreCase("") && !this.announcement.discount.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            try {
                Double.parseDouble(this.announcement.discount);
                sb.append(ShowMessage.HightLight("Right shares issued for the " + this.announcement.period + " are " + Util.format2digit((String)this.announcement.right) + "%, at the Discount of " + Util.format2digit((String)this.announcement.discount) + "%", ""));
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Right shares issued for the " + this.announcement.period + " are " + this.announcement.right + "%, at the Discount of " + this.announcement.discount + "%", ""));
            }
            sb.append("</td>");
            sb.append("</tr>");
        } else if (!this.announcement.right.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            try {
                Double.parseDouble(this.announcement.right);
                sb.append(ShowMessage.HightLight("Right shares issued " + Util.format2digit((String)this.announcement.right) + "%, at Par Value", ""));
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Right shares issued " + this.announcement.right + "%, at Par Value", ""));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.fileData.equalsIgnoreCase("")) {
            if (this.announcement.fileData.indexOf("|") >= 0) {
                String[] data = this.announcement.fileData.split("\\|");
                for (int i = 0; i < data.length; ++i) {
                    String string = data[i];
                    sb.append("<tr >");
                    sb.append(td);
                    sb.append(ShowMessage.HightLight(string, ""));
                    sb.append("</td>");
                    sb.append("</tr>");
                }
            } else {
                sb.append("<tr >");
                sb.append(td);
                sb.append(ShowMessage.HightLight(this.announcement.fileData, ""));
                sb.append("</td>");
                sb.append("</tr>");
            }
        }
        sb.append(ShowMessage.getHyperLinkText(this.announcement.hyperLink, ""));
        sb.append("</table>");
        sb.append("</html>");
        this.editorPane.setText(sb.toString());
        this.editorPane.setCaretPosition(0);
    }

    private void setAnnouncementTextUnRead(String color, int totalMessage) {
        StringBuilder sb = new StringBuilder();
        String td = "<td colspan = '2' style='padding-left:3px; margin-top:3px'>";
        sb.append("<html>");
        sb.append("<table style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal' width='100%' border='0px' cellpadding ='0px' cellspacing='0px' bgcolor='white'>");
        sb.append("<tr style='height:15px; background-color:#" + color + "'>");
        sb.append("<td style='margin:2px; padding-left:2px; height: 15px;' color='black'>");
        sb.append("<b >");
        sb.append(ShowMessage.HightLight(this.announcement.scrip + " (" + this.announcement.company + ")", ""));
        sb.append("</b >");
        sb.append("</td>");
        sb.append("<td nowrap='nowrap' color='light-gray' valign=top style='text-align:right;margin:3px; padding-right:3px; height: 15px;'>");
        sb.append(this.announcement.dateTime);
        sb.append(" | " + Util.format0digit((String)(this.announcement.msgNo + "")) + " of " + Util.format0digit((String)(totalMessage + "")));
        sb.append("</td>");
        sb.append("</tr>");
        if (!this.announcement.AGM.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b>");
            sb.append(ShowMessage.HightLight("Annual General Meeting will be held on " + this.announcement.AGM, ""));
            sb.append("</b>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.EPS.equalsIgnoreCase("")) {
            boolean isDouble = false;
            try {
                Double.parseDouble(this.announcement.EPS);
                isDouble = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b>");
            if (isDouble) {
                sb.append(ShowMessage.HightLight("Earning per Share is Rs. " + Util.format2digit((String)this.announcement.EPS) + "/-", ""));
            } else {
                sb.append(ShowMessage.HightLight("Earning per Share is " + this.announcement.EPS, ""));
            }
            sb.append("</b>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.FYE.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b>");
            sb.append(ShowMessage.HightLight("Financial year ended " + this.announcement.FYE, ""));
            sb.append("</b>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.PLBeforeTax.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b>");
            double dd = 0.0;
            try {
                dd = Double.parseDouble(this.announcement.PLBeforeTax);
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Profit / Loss before Taxation is " + this.announcement.PLBeforeTax, ""));
            }
            if (dd >= 0.0) {
                sb.append(ShowMessage.HightLight("Profit before Taxation is Rs. " + Util.format0digit((String)this.announcement.PLBeforeTax) + " Million", ""));
            } else {
                sb.append(ShowMessage.HightLight("Loss before Taxation is Rs. " + Util.format0digit((String)this.announcement.PLBeforeTax) + " Million", ""));
            }
            sb.append("</b>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.PLAfterTax.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b>");
            double dd = 0.0;
            try {
                dd = Double.parseDouble(this.announcement.PLAfterTax);
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Profit / Loss after Taxation is " + this.announcement.PLAfterTax, ""));
            }
            if (dd >= 0.0) {
                sb.append(ShowMessage.HightLight("Profit after Taxation is Rs. " + Util.format0digit((String)this.announcement.PLAfterTax) + " Million", ""));
            } else {
                sb.append(ShowMessage.HightLight("Loss after Taxation is Rs. " + Util.format0digit((String)this.announcement.PLAfterTax) + " Million", ""));
            }
            sb.append("</b>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.bookClosureStartDate.equalsIgnoreCase("")) {
            Date date2;
            try {
                date2 = this.dfDay.parse(this.announcement.bookClosureStartDate);
                this.announcement.bookClosureStartDate = LogsTC.dateFormatAcc.format(date2);
            }
            catch (ParseException date2) {
                // empty catch block
            }
            try {
                date2 = this.dfDay.parse(this.announcement.bookClosureEndDate);
                this.announcement.bookClosureEndDate = LogsTC.dateFormatAcc.format(date2);
            }
            catch (ParseException date3) {
                // empty catch block
            }
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b>");
            sb.append(ShowMessage.HightLight("Book Closure from " + this.announcement.bookClosureStartDate + " to " + this.announcement.bookClosureEndDate, ""));
            sb.append("<b>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.divedend.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b>");
            try {
                Double.parseDouble(this.announcement.divedend);
                sb.append(ShowMessage.HightLight("Dividend issued for the " + this.announcement.period + " is " + Util.format2digit((String)this.announcement.divedend) + "%", ""));
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Dividend issued for the " + this.announcement.period + " is " + this.announcement.divedend, ""));
            }
            sb.append("</b>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (this.announcement.divedend.equalsIgnoreCase("") && !this.announcement.period.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b >Period (" + ShowMessage.HightLight(this.announcement.period, "") + ")</b>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.bonus.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b>");
            try {
                Double.parseDouble(this.announcement.bonus);
                sb.append(ShowMessage.HightLight("Bonus shares issued for the " + this.announcement.period + " are " + Util.format2digit((String)this.announcement.bonus) + "%", ""));
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Bonus shares issued for the " + this.announcement.period + " are " + this.announcement.bonus, ""));
            }
            sb.append("<b>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.right.equalsIgnoreCase("") && !this.announcement.premium.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b>");
            try {
                Double.parseDouble(this.announcement.premium);
                sb.append(ShowMessage.HightLight("Right shares issued for the " + this.announcement.period + " are " + Util.format2digit((String)this.announcement.right) + "%, at the Premium of Rs. " + Util.format2digit((String)this.announcement.premium) + "/- per share", ""));
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Right shares issued for the " + this.announcement.period + " are " + this.announcement.right + "%, at the Premium of " + this.announcement.premium + " per share", ""));
            }
            sb.append("</b>");
            sb.append("</td>");
            sb.append("</tr>");
        } else if (!this.announcement.right.equalsIgnoreCase("") && !this.announcement.discount.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b>");
            try {
                Double.parseDouble(this.announcement.discount);
                sb.append(ShowMessage.HightLight("Right shares issued for the " + this.announcement.period + " are " + Util.format2digit((String)this.announcement.right) + "%, at the Discount of " + Util.format2digit((String)this.announcement.discount) + "%", ""));
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Right shares issued for the " + this.announcement.period + " are " + this.announcement.right + "%, at the Discount of " + this.announcement.discount + "%", ""));
            }
            sb.append("</b>");
            sb.append("</td>");
            sb.append("</tr>");
        } else if (!this.announcement.right.equalsIgnoreCase("")) {
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b>");
            try {
                Double.parseDouble(this.announcement.right);
                sb.append(ShowMessage.HightLight("Right shares issued " + Util.format2digit((String)this.announcement.right) + "%, at Par Value", ""));
            }
            catch (Exception ex) {
                sb.append(ShowMessage.HightLight("Right shares issued " + this.announcement.right + "%, at Par Value", ""));
            }
            sb.append("</b>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        if (!this.announcement.fileData.equalsIgnoreCase("")) {
            if (this.announcement.fileData.indexOf("|") >= 0) {
                String[] data = this.announcement.fileData.split("\\|");
                for (int i = 0; i < data.length; ++i) {
                    String string = data[i];
                    sb.append("<tr >");
                    sb.append(td);
                    sb.append("<b>");
                    sb.append(ShowMessage.HightLight(string, ""));
                    sb.append("</b>");
                    sb.append("</td>");
                    sb.append("</tr>");
                }
            } else {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                sb.append(ShowMessage.HightLight(this.announcement.fileData, ""));
                sb.append("</b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
        }
        sb.append(ShowMessage.getHyperLinkText(this.announcement.hyperLink, ""));
        sb.append("</table>");
        sb.append("</html>");
        this.editorPane.setText(sb.toString());
        this.editorPane.setCaretPosition(0);
    }

    private void setAnnouncementFileTextUnRead(String color, int totalMessage) {
        StringBuilder sb = new StringBuilder();
        String td = "<td colspan = '2' style='padding-left:3px; margin-top:3px'>";
        sb.append("<html>");
        sb.append("<table style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal' width='100%' border='0px' cellpadding ='0px' cellspacing='0px' bgcolor='white'>");
        sb.append("<tr style='height:15px; background-color:#" + color + "'>");
        sb.append("<td style='margin:2px; padding-left:2px; height: 15px;' color='black'>");
        sb.append("<b >");
        sb.append(ShowMessage.HightLight(this.announcement.scrip + " (" + this.announcement.company + ")", ""));
        sb.append("</b >");
        sb.append("</td>");
        sb.append("<td nowrap='nowrap' color='light-gray' valign=top style='text-align:right;margin:3px; padding-right:3px; height: 15px;'>");
        sb.append(this.announcement.dateTime);
        sb.append(" | " + Util.format0digit((String)(this.announcement.msgNo + "")) + " of " + Util.format0digit((String)(totalMessage + "")));
        sb.append("</td>");
        sb.append("</tr>");
        if (this.announcement.fileData.indexOf("|") >= 0) {
            String[] data = this.announcement.fileData.split("\\|");
            for (int i = 0; i < data.length; ++i) {
                String string = data[i];
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                sb.append(ShowMessage.HightLight(string, ""));
                sb.append("</b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
        } else {
            sb.append("<tr >");
            sb.append(td);
            sb.append("<b>");
            sb.append(ShowMessage.HightLight(this.announcement.fileData, ""));
            sb.append("</b>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        sb.append(ShowMessage.getHyperLinkText(this.announcement.hyperLink, ""));
        sb.append("</table>");
        sb.append("</html>");
        this.editorPane.setText(sb.toString());
        this.editorPane.setCaretPosition(0);
    }

    private void setAnnouncementFileTextRead(String color, int totalMessage) {
        StringBuilder sb = new StringBuilder();
        String td = "<td colspan = '2' style='padding-left:3px; margin-top:3px'>";
        sb.append("<html>");
        sb.append("<table style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal' width='100%' border='0px' cellpadding ='0px' cellspacing='0px' bgcolor='white'>");
        sb.append("<tr style='height:15px; background-color:#" + color + "'>");
        sb.append("<td style='margin:2px; padding-left:2px; height: 15px;' color='black'>");
        sb.append("<b>");
        sb.append(ShowMessage.HightLight(this.announcement.scrip + " (" + this.announcement.company + ")", ""));
        sb.append("</b>");
        sb.append("</td>");
        sb.append("<td nowrap='nowrap' color='light-gray' valign=top style='text-align:right;margin:3px; padding-right:3px; height: 15px;'>");
        sb.append(this.announcement.dateTime);
        sb.append(" | " + Util.format0digit((String)(this.announcement.msgNo + "")) + " of " + Util.format0digit((String)(totalMessage + "")));
        sb.append("</td>");
        sb.append("</tr>");
        if (this.announcement.fileData.indexOf("|") >= 0) {
            String[] data = this.announcement.fileData.split("\\|");
            for (int i = 0; i < data.length; ++i) {
                String string = data[i];
                sb.append("<tr >");
                sb.append(td);
                sb.append(ShowMessage.HightLight(string, ""));
                sb.append("</td>");
                sb.append("</tr>");
            }
        } else {
            sb.append("<tr >");
            sb.append(td);
            sb.append(ShowMessage.HightLight(this.announcement.fileData, ""));
            sb.append("</td>");
            sb.append("</tr>");
        }
        sb.append(ShowMessage.getHyperLinkText(this.announcement.hyperLink, ""));
        sb.append("</table>");
        sb.append("</html>");
        this.editorPane.setText(sb.toString());
        this.editorPane.setCaretPosition(0);
    }

    private static String HightLight(String company, String find) {
        return company;
    }

    private void markAsRead() {
        if (this.message != null) {
            this.message.isRead = true;
            this.isRead = true;
            if (this.message.type.value.equalsIgnoreCase("BOARD_MEETING")) {
                this.setBoardMeetingText();
            } else {
                this.setReadText();
                if (this.md != null) {
                    this.md.setColor(false);
                } else {
                    this.mdPMEX.setColor(false);
                }
            }
            if (this.md != null) {
                this.md.setRead(true, this.message.id.value);
            } else {
                this.mdPMEX.setRead(true, this.message.id.value);
            }
            if (this.myTab != null) {
                this.myTab.setReadunRead(this.message);
            } else if (this.boardMeetingTab != null) {
                this.boardMeetingTab.setReadunRead(this.message);
            }
        } else if (this.announcement != null) {
            this.announcement.isRead = true;
            this.isRead = true;
            if (this.announcementScripDetail != null) {
                if (isAnnouncementsSearchOpen) {
                    this.setAnnouncementText(true, AnnouncementScripDetail.TotalMessageSearch);
                } else {
                    this.setAnnouncementText(true, AnnouncementScripDetail.TotalMessage);
                }
                this.md.setAnnouncementText(true, AnnouncementScripDetail.TotalMessage);
                this.md.setRead(true, this.announcement.id);
                if (this.announcementTab != null) {
                    this.announcementTab.setReadunRead(this.announcement);
                }
            } else {
                if (isAnnouncementsSearchOpen) {
                    this.setAnnouncementText(true, AnnouncementTab.TotalMessageSearch);
                } else {
                    if (this.announcementTab != null) {
                        this.setAnnouncementText(true, AnnouncementTab.TotalMessage);
                        this.md.setAnnouncementText(true, AnnouncementTab.TotalMessage);
                    }
                    if (this.announcementLiveTab != null) {
                        this.setAnnouncementText(true, AnnouncementLiveTab.TotalMessage);
                        this.md.setAnnouncementText(true, AnnouncementLiveTab.TotalMessage);
                    }
                }
                this.md.setRead(true, this.announcement.id);
                if (this.announcementTab != null) {
                    this.announcementTab.setReadunRead(this.announcement);
                }
            }
        }
    }

    private void markAsUnread() {
        if (this.message != null) {
            this.setUnReadText();
            this.message.isRead = false;
            this.isRead = false;
            if (this.md != null) {
                this.md.setColor(false);
                this.md.setRead(false, this.message.id.value);
            } else {
                this.mdPMEX.setColor(false);
                this.mdPMEX.setRead(false, this.message.id.value);
            }
            if (this.myTab != null) {
                this.myTab.setReadunRead(this.message);
            } else if (this.boardMeetingTab != null) {
                this.boardMeetingTab.setReadunRead(this.message);
            }
        } else if (this.announcement != null) {
            this.announcement.isRead = false;
            this.isRead = false;
            if (isAnnouncementsSearchOpen) {
                this.setAnnouncementText(true, AnnouncementTab.TotalMessageSearch);
            } else {
                if (this.announcementTab != null) {
                    this.setAnnouncementText(true, AnnouncementTab.TotalMessage);
                    this.md.setAnnouncementText(true, AnnouncementTab.TotalMessage);
                }
                if (this.announcementLiveTab != null) {
                    this.setAnnouncementText(true, AnnouncementLiveTab.TotalMessage);
                    this.md.setAnnouncementText(true, AnnouncementLiveTab.TotalMessage);
                }
            }
            this.md.setRead(false, this.announcement.id);
            if (this.announcementTab != null) {
                this.announcementTab.setReadunRead(this.announcement);
            }
        }
    }

    public static String getHyperLinkText(String HyperLink, String find) {
        StringBuilder sb = new StringBuilder();
        if (HyperLink.contains("|")) {
            String[] ahref = HyperLink.split("\\|", -1);
            for (int i = 0; i < ahref.length; ++i) {
                String string = ahref[i];
                sb.append(ShowMessage.makeHyperLink(string, find));
            }
        } else {
            return ShowMessage.makeHyperLink(HyperLink, find);
        }
        return sb.toString();
    }

    static String makeHyperLink(String HyperLink, String find) {
        StringBuilder sb = new StringBuilder();
        if (HyperLink.length() > 0) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append("<a href='").append(AppConfig.AnnouncementURL).append(HyperLink).append("' style='text-decoration:none'>");
            sb.append(ShowMessage.HightLight(HyperLink, find));
            sb.append("</a>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        return sb.toString();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (e.getDescription().indexOf("http://") == 0 || e.getDescription().indexOf("https://") == 0)) {
            MessageWindowCenter.openAnnouncementLink(e, this.announcement, e.getDescription());
        }
    }
}

