/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import CustomComponent.NxGLabelGradeint;
import CustomComponent.RoundBorderPanel;
import MessageWindow.UserMessageAllValues;
import MessageWindow.UserMessageValue;
import MyDocking.Mediator;
import common.gui.util.MyColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kse.gui.bean.MarginCallBean;
import kse.util.LogsKSE;

public class UserMessage
extends JPanel {
    public Color HeadingColorLight = new Color(249, 89, 77);
    public Color HeadingColorDark = new Color(254, 176, 171);
    Color start = Color.WHITE;
    Color end = Color.WHITE;
    private JLabel jLabel1;
    private NxGLabelGradeint lblTitle;
    private JPanel pnlHeader;
    private JPanel pnlValues;

    public UserMessage() {
        this.initComponents();
        Mediator.getInstance().setUserMessage(this);
        this.jLabel1.setVisible(false);
        this.lblTitle.setGradient(this.HeadingColorLight, this.HeadingColorDark);
        this.lblTitle.setForeground(Color.WHITE);
        ((UserMessageAllValues)this.pnlValues).setUserMessage(this);
        this.setVisible(false);
    }

    private void addMessages(Component com, boolean isRestart) {
        this.addMessages2(com, isRestart);
    }

    private void addMessages2(Component com, boolean isRestart) {
        ((UserMessageAllValues)this.pnlValues).add(com);
        if (isRestart) {
            ((UserMessageAllValues)this.pnlValues).StartOrStopTimer();
        }
    }

    @Override
    public void paint(Graphics g) {
        this.setOpaque(false);
        Graphics2D g2 = (Graphics2D)g;
        int height = this.getHeight();
        int width = this.getWidth();
        GradientPaint painter = new GradientPaint(0.0f, 0.0f, this.end, 0.0f, height / 2, this.start);
        g2.setPaint(painter);
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, (double)height / 2.0);
        g2.fill(rect);
        painter = new GradientPaint(0.0f, height / 2, this.start, 0.0f, height, this.end);
        g2.setPaint(painter);
        rect = new Rectangle2D.Double(0.0, (double)height / 2.0 - 1.0, width, height);
        g2.fill(rect);
        super.paint(g);
    }

    private void initComponents() {
        this.pnlHeader = new RoundBorderPanel(this.HeadingColorLight, this.HeadingColorDark, 0);
        this.lblTitle = new NxGLabelGradeint();
        this.pnlValues = UserMessageAllValues.getInstance();
        this.jLabel1 = new JLabel();
        this.setMinimumSize(new Dimension(0, 30));
        this.setPreferredSize(new Dimension(0, 30));
        this.setLayout(new BoxLayout(this, 2));
        this.pnlHeader.setMinimumSize(new Dimension(100, 30));
        this.pnlHeader.setPreferredSize(new Dimension(100, 30));
        this.lblTitle.setHorizontalAlignment(0);
        this.lblTitle.setText("Message(s)");
        this.lblTitle.setFont(new Font("Tahoma", 1, 11));
        this.lblTitle.setMaximumSize(new Dimension(100, 30));
        this.lblTitle.setMinimumSize(new Dimension(100, 30));
        this.lblTitle.setPreferredSize(new Dimension(100, 30));
        GroupLayout pnlHeaderLayout = new GroupLayout(this.pnlHeader);
        this.pnlHeader.setLayout(pnlHeaderLayout);
        pnlHeaderLayout.setHorizontalGroup(pnlHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTitle, -2, -1, -2));
        pnlHeaderLayout.setVerticalGroup(pnlHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTitle, -1, 30, Short.MAX_VALUE));
        this.add(this.pnlHeader);
        this.pnlValues.setMinimumSize(new Dimension(0, 30));
        this.pnlValues.setOpaque(false);
        this.pnlValues.setPreferredSize(new Dimension(0, 30));
        this.pnlValues.setLayout(new BoxLayout(this.pnlValues, 0));
        this.jLabel1.setText("jLabel1");
        this.jLabel1.setMaximumSize(new Dimension(34, 30));
        this.jLabel1.setMinimumSize(new Dimension(34, 30));
        this.jLabel1.setOpaque(true);
        this.jLabel1.setPreferredSize(new Dimension(34, 30));
        this.pnlValues.add(this.jLabel1);
        this.add(this.pnlValues);
    }

    public int getContentSize() {
        return Toolkit.getDefaultToolkit().getScreenSize().width - this.pnlHeader.getPreferredSize().width;
    }

    public void addMarginCall(ArrayList<MarginCallBean> list) {
        for (int i = 0; i < list.size(); ++i) {
            MarginCallBean margin = list.get(i);
            if (LogsKSE.MarginCallText.indexOf("~~") < 0) continue;
            String HtmlText = "";
            Color col = MyColors.marginCall1st;
            if (margin.call.equalsIgnoreCase("First Margin Call")) {
                HtmlText = "First Margin Call for Account " + margin.account;
            } else if (margin.call.equalsIgnoreCase("Second Margin Call")) {
                col = MyColors.marginCall2nd;
                HtmlText = "Second Margin Call for Account " + margin.account;
            } else if (margin.call.equalsIgnoreCase("Final Margin Call")) {
                col = MyColors.marginCall3rd;
                HtmlText = "Final Margin Call for Account " + margin.account;
            }
            if (i == list.size() - 1) {
                this.addMessages(new UserMessageValue(HtmlText, col, margin, this), true);
                continue;
            }
            this.addMessages(new UserMessageValue(HtmlText, col, margin, this), false);
        }
    }

    public void removeAllMarginCall() {
        for (Component com : this.pnlValues.getComponents()) {
            if (!(com instanceof UserMessageValue) || ((UserMessageValue)com).getMargin() == null) continue;
            this.pnlValues.remove(com);
        }
        this.repaint();
    }

    public Vector<MarginCallBean> getAllMarginCall() {
        Vector<MarginCallBean> v = new Vector<MarginCallBean>();
        for (Component com : this.pnlValues.getComponents()) {
            if (!(com instanceof UserMessageValue) || ((UserMessageValue)com).getMargin() == null) continue;
            v.add(((UserMessageValue)com).getMargin());
        }
        return v;
    }

    public void setForVisible() {
        if (((UserMessageAllValues)this.pnlValues).getComponents().length <= 1) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }
}

