/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.MarginCallList;
import MessageWindow.UserMessage;
import MyDocking.Mediator;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import kse.gui.bean.MarginCallBean;

public class UserMessageValue
extends JPanel {
    private MarginCallBean margin = null;
    Color start = Color.PINK;
    Color end = Color.PINK.brighter().brighter().brighter();
    private boolean isLinearGradient = true;
    private final UserMessage userMessage;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;

    public UserMessageValue(String text, Color col, MarginCallBean margin, UserMessage userMessage) {
        this.initComponents();
        this.margin = margin;
        this.userMessage = userMessage;
        int diff = 10;
        this.lblMessage.setText("  " + text + "  ");
        this.start = col;
        this.end = Color.WHITE;
        int wid = Util.getStringWidth((JLabel)this.lblMessage);
        Rectangle rec = this.lblMessage.getBounds();
        rec.width = wid;
        this.lblMessage.setBounds(rec);
        Rectangle rec2 = this.jSeparator1.getBounds();
        rec2.x = wid + 5;
        if (Util.isMacOSX()) {
            this.jLabel1.setVisible(true);
            rec2.width = 2;
            this.jSeparator1.setVisible(false);
        } else {
            this.jLabel1.setVisible(false);
            this.jSeparator1.setVisible(true);
        }
        this.jLabel1.setBounds(rec2);
        this.jSeparator1.setBounds(rec2);
        Dimension d = new Dimension(wid + diff, 30);
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
    }

    public MarginCallBean getMargin() {
        return this.margin;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isLinearGradient) {
            this.setOpaque(false);
            int width = this.getWidth();
            int height = this.getHeight();
            GradientPaint paint = new GradientPaint(0.0f, height, this.start, 0.0f, 0.0f, this.end, false);
            Graphics2D g2d = (Graphics2D)g;
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, width, height);
            g2d.setPaint(oldPaint);
            super.paint(g);
        } else {
            this.setOpaque(false);
            Graphics2D g2 = (Graphics2D)g;
            int height = this.getHeight();
            int width = this.getWidth();
            GradientPaint painter = new GradientPaint(0.0f, 0.0f, this.end, 0.0f, height / 2, this.start);
            g2.setPaint(painter);
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, (double)height / 2.0);
            g2.fill(rect);
            painter = new GradientPaint(0.0f, height / 2, this.start, 0.0f, height, this.end);
            g2.setPaint(painter);
            rect = new Rectangle2D.Double(0.0, (double)height / 2.0 - 1.0, width, height);
            g2.fill(rect);
            super.paint(g);
        }
    }

    private void initComponents() {
        this.lblMessage = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.setPreferredSize(new Dimension(5, 30));
        this.setLayout(null);
        this.lblMessage.setFont(new Font("Tahoma", 1, 11));
        this.lblMessage.setText("TOOL_TIP_TEXT_KEYTOOL_TIP_TEXT_KEYTOOL_TIP_TEXT_KEYTOOL_TIP_TEXT_KEY");
        this.lblMessage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UserMessageValue.this.lblMessageMouseClicked(evt);
            }
        });
        this.add(this.lblMessage);
        this.lblMessage.setBounds(2, 0, 18, 30);
        this.jSeparator1.setOrientation(1);
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(20, 4, 3, 22);
        this.jLabel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setOpaque(true);
        this.add(this.jLabel1);
        this.jLabel1.setBounds(22, 4, 1, 22);
    }

    private void lblMessageMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            MarginCallList l = MarginCallList.getInstance(this.userMessage, this.margin);
            Mediator.getInstance().setMarginCallList(l);
        }
    }
}

