/*
 * Decompiled with CFR 0.152.
 */
package Orders;

import Beans.OrderBean;
import RendersNModels.ExecuteMarketOrderRender;
import common.gui.component.NxGDialogBox;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class ExecuteMarketDialog
extends NxGDialogBox {
    private LanguageCentre languageCentre = new LanguageCentre();
    DefaultTableModel executeModel = new DefaultTableModel();
    public int Option = 1;
    private static ArrayList<OrderBean> list = new ArrayList();
    private JButton btnDecline;
    private JButton btnExecute;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable table;

    public ExecuteMarketDialog(Frame parent, ArrayList<OrderBean> list2, boolean isShowTime) {
        super(parent, true);
        this.setTitle(this.languageCentre.getValue(LanguageConstant.OrderConfirmation));
        this.initComponents();
        list.clear();
        list.addAll(list2);
        this.executeModel = (DefaultTableModel)this.table.getModel();
        Toolkit kit = this.getToolkit();
        Dimension d = kit.getScreenSize();
        this.setLocation(d.width / 4, d.height / 4);
        ((JLabel)((Object)this.table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        this.removeRow();
        for (int i = 0; i < list.size(); ++i) {
            OrderBean ord = list.get(i);
            this.executeModel.addRow(new Object[]{ord.getMarket(), ord.getScrip(), ord.getOrderTransactionType(), ord.getVolumeString(), ord.getAccount(), ord.getPrice(), ord.getTime()});
        }
        if (!isShowTime) {
            this.table.removeColumn(this.table.getColumn(this.languageCentre.getValue(LanguageConstant.Time)));
        }
        this.table.setModel(this.executeModel);
        this.table.setDefaultRenderer(Object.class, new ExecuteMarketOrderRender());
        this.setLanguageValues();
        this.setVisible(true);
    }

    public void removeRow() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.executeModel.removeRow(0);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.btnDecline = new JButton();
        this.btnExecute = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(370, 250));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                ExecuteMarketDialog.this.formWindowActivated(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                ExecuteMarketDialog.this.formWindowClosing(evt);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ExecuteMarketDialog.this.formFocusGained(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Market", "Scrip", "Order Type", "Volume", "Account", "Price", "Time"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setEnabled(false);
        this.table.setName("table");
        this.jScrollPane1.setViewportView(this.table);
        this.table.getColumnModel().getColumn(0).setResizable(false);
        this.table.getColumnModel().getColumn(1).setResizable(false);
        this.table.getColumnModel().getColumn(2).setResizable(false);
        this.table.getColumnModel().getColumn(4).setResizable(false);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(130);
        this.table.getColumnModel().getColumn(6).setHeaderValue("Time");
        this.btnDecline.setText("Decline");
        this.btnDecline.setName("ExecuteMarketDialog -> btnDecline");
        this.btnDecline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExecuteMarketDialog.this.btnDeclineActionPerformed(evt);
            }
        });
        this.btnExecute.setText("Execute");
        this.btnExecute.setName("ExecuteMarketDialog -> btnExecute");
        this.btnExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExecuteMarketDialog.this.btnExecuteActionPerformed(evt);
            }
        });
        this.jSeparator1.setName("jSeparator1");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(406, Short.MAX_VALUE).addComponent(this.btnExecute).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDecline).addContainerGap()).addComponent(this.jSeparator1, -1, 560, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 560, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 290, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.jSeparator1, -2, 3, -2).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnExecute, -2, 22, -2).addComponent(this.btnDecline, -2, 22, -2)).addGap(5, 5, 5)));
        this.pack();
    }

    private void btnExecuteActionPerformed(ActionEvent evt) {
        this.Option = 0;
        this.dispose();
    }

    private void btnDeclineActionPerformed(ActionEvent evt) {
        this.Option = 1;
        this.dispose();
    }

    private void formFocusGained(FocusEvent evt) {
        this.btnDecline.setSelected(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.Option = 1;
        this.dispose();
    }

    private void formWindowActivated(WindowEvent evt) {
        this.btnExecute.requestFocus();
    }

    private void setLanguageValues() {
        this.btnDecline.setText(this.languageCentre.getValue(LanguageConstant.Decline));
        this.btnExecute.setText(this.languageCentre.getValue(LanguageConstant.Execute));
        JTableHeader th = this.table.getTableHeader();
        TableColumnModel tcm = th.getColumnModel();
        TableColumn tc = tcm.getColumn(0);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.Market));
        tc = tcm.getColumn(1);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.Scrip));
        tc = tcm.getColumn(2);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.OrderType));
        tc = tcm.getColumn(3);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.Volume));
        tc = tcm.getColumn(4);
        tc.setHeaderValue(this.languageCentre.getValue("Account"));
        tc = tcm.getColumn(5);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.Price));
        tc = tcm.getColumn(6);
        tc.setHeaderValue(this.languageCentre.getValue(LanguageConstant.Time));
    }
}

