/*
 * Decompiled with CFR 0.152.
 */
package Orders;

import Beans.BuySellOrder;
import Beans.OrderBean;
import common.gui.component.NxGDialogBox;
import common.gui.util.AppConfig;
import common.gui.util.ImageUtil;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class PriceOutOfRange
extends NxGDialogBox {
    private BuySellOrder ord;
    private OrderBean bean;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JTextField lblEnteredPrice;
    private JTextField lblLowerRange;
    private JTextField lblScrip;
    private JTextField lblUpperRange;

    public PriceOutOfRange(JFrame frame, boolean b, BuySellOrder ord) {
        super((Frame)frame, b);
        this.setTitle(this.languageCentre.getValue(LanguageConstant.PriceOutOfRange));
        this.ord = ord;
        this.initComponents();
        if (ord.OrderType.equalsIgnoreCase("SLO")) {
            this.lblEnteredPrice.setText(Util.format2digit((String)(ord.Limit + "")));
        } else {
            this.lblEnteredPrice.setText(Util.format2digit((String)(ord.Price + "")));
        }
        this.lblScrip.setText(ord.Symbol);
        this.lblLowerRange.setText(Util.format2digit((String)(ord.lowerlock + "")));
        this.lblUpperRange.setText(Util.format2digit((String)(ord.uppercap + "")));
        this.init2();
    }

    public PriceOutOfRange(JFrame frame, boolean b, OrderBean ord) {
        super((Frame)frame, b);
        this.setTitle(this.languageCentre.getValue(LanguageConstant.PriceOutOfRange));
        this.bean = ord;
        this.initComponents();
        if (ord.getOrderType().equalsIgnoreCase("SLO")) {
            this.lblEnteredPrice.setText(Util.format2digit((String)(ord.getLimit() + "")));
        } else {
            this.lblEnteredPrice.setText(Util.format2digit((String)(ord.getPrice() + "")));
        }
        this.lblScrip.setText(ord.getScrip());
        this.lblLowerRange.setText(Util.format2digit((String)(ord.getLowerLock() + "")));
        this.lblUpperRange.setText(Util.format2digit((String)(ord.getUpperCap() + "")));
        this.init2();
    }

    public PriceOutOfRange(JFrame frame, boolean b, String Scrip, String EnteredPrice, String uppercap, String lowerlock) {
        super((Frame)frame, b);
        this.setTitle(this.languageCentre.getValue(LanguageConstant.PriceOutOfRange));
        this.initComponents();
        this.lblScrip.setText(Scrip);
        this.lblLowerRange.setText(Util.format2digit((String)(lowerlock + "")));
        this.lblUpperRange.setText(Util.format2digit((String)(uppercap + "")));
        this.lblEnteredPrice.setText(Util.format2digit((String)(EnteredPrice + "")));
        this.init2();
    }

    private void init2() {
        int width = 376;
        int height = 240;
        this.setMaximumSize(new Dimension(width, height));
        this.setMinimumSize(new Dimension(width, height));
        Toolkit kit = this.getToolkit();
        Dimension d = kit.getScreenSize();
        this.setLocation(d.width / 2 - width / 2, d.height / 2 - height / 2);
        try {
            if (AppConfig.houseIcon == null) {
                AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
            }
            if (AppConfig.houseIcon != null) {
                this.setIconImage(new ImageIcon(AppConfig.houseIcon).getImage());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblEnteredPrice.setBackground(Color.WHITE);
        this.lblLowerRange.setBackground(Color.WHITE);
        this.lblScrip.setBackground(Color.WHITE);
        this.lblUpperRange.setBackground(Color.WHITE);
        this.lblEnteredPrice.setEnabled(false);
        this.lblLowerRange.setEnabled(false);
        this.lblScrip.setEnabled(false);
        this.lblUpperRange.setEnabled(false);
        this.lblEnteredPrice.setDisabledTextColor(Color.BLACK);
        this.lblLowerRange.setDisabledTextColor(Color.BLACK);
        this.lblScrip.setDisabledTextColor(Color.BLACK);
        this.lblUpperRange.setDisabledTextColor(Color.BLACK);
        this.lblUpperRange.setDisabledTextColor(new Color(0, 128, 0));
        this.lblLowerRange.setDisabledTextColor(MyColors.errorMessageFG);
        this.setLanguageValues();
        this.setVisible(true);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.btnOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblEnteredPrice = new JTextField();
        this.lblScrip = new JTextField();
        this.jPanel2 = new JPanel();
        this.lblUpperRange = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.lblLowerRange = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 1, this.jLabel3.getFont().getSize() + 3));
        this.jLabel3.setText("Price Out Of Range");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(50, 0, 200, 40);
        this.jLabel4.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/alert22.png")));
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(20, 0, 34, 40);
        this.jLabel6.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/HeaderBG.png")));
        this.getContentPane().add(this.jLabel6);
        this.jLabel6.setBounds(-120, -20, 650, 60);
        this.getContentPane().add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 170, 380, 2);
        this.btnOK.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/tick.png")));
        this.btnOK.setText("OK");
        this.btnOK.setName("PriceOutOfRange -> btnOK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PriceOutOfRange.this.btnOKActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.btnOK);
        this.btnOK.setBounds(280, 180, 80, 25);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Entered Price"));
        this.jPanel1.setLayout(null);
        this.jLabel1.setText("Scrip");
        this.jPanel1.add(this.jLabel1);
        this.jLabel1.setBounds(30, 23, 70, 20);
        this.jLabel2.setText("Entered Price");
        this.jPanel1.add(this.jLabel2);
        this.jLabel2.setBounds(190, 23, 70, 20);
        this.lblEnteredPrice.setHorizontalAlignment(4);
        this.lblEnteredPrice.setEnabled(false);
        this.jPanel1.add(this.lblEnteredPrice);
        this.lblEnteredPrice.setBounds(260, 23, 80, 20);
        this.lblScrip.setEnabled(false);
        this.jPanel1.add(this.lblScrip);
        this.lblScrip.setBounds(90, 23, 80, 20);
        this.getContentPane().add(this.jPanel1);
        this.jPanel1.setBounds(0, 40, 370, 60);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Price Range"));
        this.jPanel2.setLayout(null);
        this.lblUpperRange.setHorizontalAlignment(4);
        this.lblUpperRange.setEnabled(false);
        this.jPanel2.add(this.lblUpperRange);
        this.lblUpperRange.setBounds(260, 23, 80, 20);
        this.jLabel5.setText("Upper Cap");
        this.jPanel2.add(this.jLabel5);
        this.jLabel5.setBounds(190, 23, 70, 20);
        this.jLabel7.setText("Lower Lock");
        this.jPanel2.add(this.jLabel7);
        this.jLabel7.setBounds(30, 23, 70, 20);
        this.lblLowerRange.setHorizontalAlignment(4);
        this.lblLowerRange.setEnabled(false);
        this.jPanel2.add(this.lblLowerRange);
        this.lblLowerRange.setBounds(90, 23, 80, 20);
        this.getContentPane().add(this.jPanel2);
        this.jPanel2.setBounds(0, 100, 370, 60);
        this.pack();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void setLanguageValues() {
        this.jLabel3.setText(this.languageCentre.getValue(LanguageConstant.PriceOutOfRange));
        this.btnOK.setText(this.languageCentre.getValue(LanguageConstant.OK));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(this.languageCentre.getValue(LanguageConstant.EnteredPrice)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(this.languageCentre.getValue(LanguageConstant.PriceRange)));
        this.jLabel1.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.jLabel2.setText(this.languageCentre.getValue(LanguageConstant.EnteredPrice));
        this.jLabel5.setText(this.languageCentre.getValue(LanguageConstant.UpperCap));
        this.jLabel7.setText(this.languageCentre.getValue(LanguageConstant.LowerLock));
    }
}

