/*
 * Decompiled with CFR 0.152.
 */
package RendersNModels;

import CATALYST.Control.MarketFeed;
import RendersNModels.DQData;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import windows.DQSetting;
import windows.DetailedQuote;

public class DQDataModel
extends AbstractTableModel {
    protected Hashtable _m_vector;
    protected Vector m_vector;
    protected int m_sortCol = 0;
    protected boolean m_sortAsc = true;
    protected int Asc_Desc_Default = 0;
    DQData stockData = null;
    String Symbol;
    DetailedQuote DQ;

    public DQDataModel(DetailedQuote DQ_) {
        this.DQ = DQ_;
        this.m_vector = new Vector();
        this.stockData = new DQData(this);
        this.m_vector.add(this.stockData);
    }

    public Vector getvectorlist() {
        return this.m_vector;
    }

    void RaiseNotifyEvent(String message) {
    }

    @Override
    public int getRowCount() {
        return DQSetting.rowCount;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        try {
            Object td = this.m_vector.get(0);
            if (td != null && td instanceof DQData) {
                DQData temp = (DQData)td;
                this.refresh();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public boolean isCellEditable(int nRow, int nCol) {
        return false;
    }

    @Override
    public Object getValueAt(int nRow, int nCol) {
        if (nRow < 0 || nRow >= this.getRowCount()) {
            return "";
        }
        if (this.m_vector.size() == 0) {
            return "";
        }
        DQData data = (DQData)this.m_vector.elementAt(0);
        Dimension dd = new Dimension(nRow, nCol);
        if (DQSetting.view.containsKey(dd)) {
            if (nCol == 0 || nCol == 2) {
                data.stringData.get((Object)((Object)DQSetting.view.get((Object)dd))).RowNum = nRow;
                return data.stringData.get((Object)DQSetting.view.get(dd));
            }
            data.valueData.get((Object)((Object)DQSetting.view.get((Object)dd))).RowNum = nRow;
            return data.valueData.get((Object)DQSetting.view.get(dd));
        }
        return "";
    }

    public void Clear() {
        this.m_vector.clear();
        this.stockData = new DQData(this);
        this.m_vector.add(this.stockData);
        this.refresh();
    }

    public void setDataValues(MarketFeed mktFeed) {
        try {
            this.stockData.Set_LastTradeTime_Value(mktFeed.lTrdTime);
            this.stockData.Set_LastTradePrice_Value(mktFeed.lTrdPrice);
            this.stockData.Set_LastTradeVolume_Value(mktFeed.ltrdVolume);
            this.stockData.Set_Change_Value(mktFeed.change);
            Double per = 0.0;
            if (Double.parseDouble(mktFeed.lTrdPrice.replaceAll("\\,", "")) > 0.0) {
                try {
                    double ch_ = Double.parseDouble(mktFeed.change.replaceAll("\\,", ""));
                    double ltrd_ = Double.parseDouble(mktFeed.lTrdPrice.replaceAll("\\,", ""));
                    per = ch_ / (ltrd_ - ch_) * 100.0;
                }
                catch (Exception ex) {
                    per = 0.0;
                }
            }
            this.stockData.Set_PerChange_Value(per);
            this.stockData.Set_Volume_Value(mktFeed.totVolume);
            try {
                per = Double.parseDouble(mktFeed.totVolume.replaceAll("\\,", "")) * Double.parseDouble(mktFeed.average.replaceAll("\\,", ""));
            }
            catch (Exception ex) {
                per = 0.0;
            }
            this.stockData.Set_ApproximatedValue_Value(per);
            this.stockData.Set_Trades_Value(mktFeed.totTrades);
            if (Double.parseDouble(mktFeed.totTrades.replaceAll("\\,", "")) > 0.0) {
                try {
                    per = Double.parseDouble(mktFeed.totVolume.replaceAll("\\,", "")) / Double.parseDouble(mktFeed.totTrades.replaceAll("\\,", ""));
                }
                catch (Exception ex) {
                    per = 0.0;
                }
            }
            this.stockData.Set_AverageTradeVolume_Value(per);
            try {
                per = Double.parseDouble(mktFeed.lTrdPrice.replaceAll("\\,", "")) - Double.parseDouble(mktFeed.change.replaceAll("\\,", ""));
            }
            catch (Exception ex) {
                per = 0.0;
            }
            this.stockData.Set_PreviousClose_Value(per);
            double Spread = 0.0;
            try {
                Spread = Double.parseDouble(mktFeed.sell.replaceAll("\\,", "")) - Double.parseDouble(mktFeed.buy.replaceAll("\\,", ""));
            }
            catch (Exception ex) {
                Spread = 0.0;
            }
            this.stockData.Set_Spread_Value(Spread);
            if (Double.parseDouble(mktFeed.lTrdPrice.replaceAll("\\,", "")) > 0.0) {
                try {
                    per = Spread / Double.parseDouble(mktFeed.lTrdPrice.replaceAll("\\,", "")) * 100.0;
                }
                catch (Exception ex) {
                    per = 0.0;
                }
            }
            this.stockData.Set_PerSpread_Value(per);
            this.stockData.Set_High_Value(mktFeed.high);
            this.stockData.Set_Low_Value(mktFeed.low);
            this.stockData.Set_Average_Value(mktFeed.average);
            double range = 0.0;
            try {
                range = Double.parseDouble(mktFeed.high.replaceAll("\\,", "")) - Double.parseDouble(mktFeed.low.replaceAll("\\,", ""));
            }
            catch (Exception ex) {
                range = 0.0;
            }
            this.stockData.Set_CurrentRange_Value(range);
            try {
                per = range / Double.parseDouble(mktFeed.lTrdPrice.replaceAll("\\,", "")) * 100.0;
            }
            catch (Exception ex) {
                per = 0.0;
            }
            this.stockData.Set_PerCurrentRange_Value(per);
            this.refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDataValues(String Symbol, String result, MarketFeed mktFeed) {
        if (result.indexOf(";") > 0) {
            String[] val = result.split("\\;", -1);
            String OpenRate = val[0];
            String LastTradeDate = val[1];
            if (LastTradeDate == null || LastTradeDate.equalsIgnoreCase("null")) {
                LastTradeDate = "";
            } else {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                    Date date = formatter.parse(LastTradeDate);
                    formatter = new SimpleDateFormat("MMM dd, yyyy");
                    LastTradeDate = formatter.format(date);
                }
                catch (Exception formatter) {
                    // empty catch block
                }
            }
            String Week52High = val[2].trim().replaceAll("\\,", "");
            String Week52Low = val[3].trim().replaceAll("\\,", "");
            String Week52Average = val[4].trim().replaceAll("\\,", "");
            double high52 = Double.parseDouble(Week52High.trim().replaceAll("\\,", ""));
            double low52 = Double.parseDouble(Week52Low.trim().replaceAll("\\,", ""));
            double average52 = Double.parseDouble(Week52Average.trim().replaceAll("\\,", ""));
            this.stockData.Set_TodaysOpen_Value(OpenRate);
            this.stockData.Set_LastTradeDate_Value(LastTradeDate);
            this.stockData.Set_52WeekHigh_Value(high52);
            this.stockData.Set_52WeekLow_Value(low52);
            this.stockData.Set_52WeekAverage_Value(average52);
            double today52PerHigh = 0.0;
            if (high52 > 0.0) {
                try {
                    today52PerHigh = Math.abs((Double.parseDouble(mktFeed.lTrdPrice.replaceAll("\\,", "")) - high52) / high52 * 100.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.stockData.Set_PerTodayAnd52WeekHigh_Value(today52PerHigh);
            double today52PerLow = 0.0;
            if (low52 > 0.0) {
                try {
                    today52PerLow = Math.abs((Double.parseDouble(mktFeed.lTrdPrice.replaceAll("\\,", "")) - low52) / low52 * 100.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.stockData.Set_PerTodayAnd52WeekLow_Value(today52PerLow);
            double average52Per = 0.0;
            if (average52 > 0.0) {
                try {
                    average52Per = Math.abs((average52 - Double.parseDouble(mktFeed.lTrdPrice.replaceAll("\\,", ""))) / average52 * 100.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.stockData.Set_PerTodayAnd52WeekAverage_Value(average52Per);
            double week52range = high52 - low52;
            this.stockData.Set_52WeekRange_Value(week52range);
            double range52Per = 0.0;
            if (Double.parseDouble(mktFeed.average) > 0.0) {
                range52Per = Math.abs(week52range / Double.parseDouble(mktFeed.lTrdPrice) * 100.0);
            }
            this.stockData.Set_Per52WeekRange_Value(range52Per);
        }
        this.refresh();
    }

    public void setDataValues(String TotalBidQuantity, String TotalOfferQuantity, String NoOfBids, String NoOfOffers) {
        try {
            this.stockData.Set_TotalBidQuantity_Value(TotalBidQuantity);
            this.stockData.Set_TotalOfferQuantity_Value(TotalOfferQuantity);
            double bidOfferRatio = 0.0;
            try {
                bidOfferRatio = Double.parseDouble(TotalBidQuantity + "") / Double.parseDouble(TotalOfferQuantity + "");
                if (Double.isInfinite(bidOfferRatio)) {
                    bidOfferRatio = 0.0;
                }
            }
            catch (Exception ex) {
                bidOfferRatio = 0.0;
            }
            this.stockData.Set_BidOfferRatio_Value(bidOfferRatio);
            this.stockData.Set_NoOfBids_Value(NoOfBids);
            this.stockData.Set_NoOfOffers_Value(NoOfOffers);
            this.refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDataValues(String cps, MarketFeed mktFeed) {
        if (cps.indexOf(":") > 0) {
            double uppLimit = Double.parseDouble(cps.split(":")[0].replaceAll("\\,", ""));
            double lowerLimit = Double.parseDouble(cps.split(":")[1].replaceAll("\\,", ""));
            double range = uppLimit - lowerLimit;
            double perC = Double.parseDouble(mktFeed.lTrdPrice.replaceAll("\\,", "")) - Double.parseDouble(mktFeed.change.replaceAll("\\,", ""));
            double perRange = 0.0;
            try {
                perRange = range / perC * 100.0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.stockData.Set_MaximumPrice_Value(uppLimit);
            this.stockData.Set_MinimumPrice_Value(lowerLimit);
            this.stockData.Set_MarketRange_Value(range);
            this.stockData.Set_PerMarketRange_Value(perRange);
        }
        this.refresh();
    }

    public void refresh() {
        this.fireTableDataChanged();
        this.DQ.SelectRow();
    }

    protected void datachangedevent() {
        this.fireTableDataChanged();
    }
}

