/*
 * Decompiled with CFR 0.152.
 */
package RendersNModels;

import RendersNModels.DQBackColor;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DetailQuoteRenderer
extends DefaultTableCellRenderer {
    Color old = Color.red;
    private int row;

    public DetailQuoteRenderer() {
        super.setVerticalTextPosition(0);
        this.setVerticalTextPosition(0);
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof DQBackColor) {
            DQBackColor bc = (DQBackColor)value;
            super.setValue(value);
            if (bc.bgcolor == MyColors.MarketWatchIncreaseColor || bc.bgcolor == MyColors.MarketWatchDecreaseColor) {
                this.setBackground(bc.bgcolor);
            } else if (bc.bgcolor == Color.LIGHT_GRAY) {
                if (bc.RowNum % 2 == 0) {
                    this.setBackground(MyColors.cellRenderEven);
                } else {
                    this.setBackground(MyColors.cellRenderOdd);
                }
            }
            this.setForeground(bc.fgcolor);
        } else {
            super.setValue(value);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel cell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (column % 2 == 0) {
            cell.setFont(AppConfig.defaultPlanFont);
            cell.setHorizontalAlignment(2);
        } else {
            cell.setFont(cell.getFont().deriveFont(1));
            cell.setHorizontalAlignment(4);
        }
        if (isSelected) {
            cell.setOpaque(true);
            cell.setBackground(MyColors.SelectionFG);
        } else {
            cell.setBackground(super.getBackground());
        }
        this.row = row;
        return cell;
    }
}

