/*
 * Decompiled with CFR 0.152.
 */
package RendersNModels;

import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class OpenAndCDCRender
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel ret = (JLabel)super.getTableCellRendererComponent(tblDataTable, value, isSelected, hasFocus, row, column);
        ret.setForeground(Color.BLACK);
        if (value == null) {
            value = "";
        }
        if (column == 0) {
            ret.setHorizontalAlignment(2);
        } else {
            ret.setHorizontalAlignment(4);
        }
        if (row % 2 == 0) {
            ret.setBackground(MyColors.cellRenderEven);
        } else {
            ret.setBackground(MyColors.cellRenderOdd);
        }
        if (isSelected) {
            ret.setBackground(MyColors.SelectionFG);
        }
        if (column == 0 && value != null) {
            ret.setText(" " + value);
        } else if (column == 1 && value != null) {
            ret.setText(Util.format0digit((String)(value + "")) + " ");
        } else if (column == 2 && value != null) {
            ret.setText(Util.format2digit((String)(value + "")) + " ");
        } else if (column == 3 && value != null) {
            double pNl = 0.0;
            try {
                pNl = Double.parseDouble(value.toString().replaceAll("\\,", ""));
            }
            catch (NumberFormatException ex) {
                pNl = 0.0;
            }
            if (pNl >= 0.0) {
                ret.setForeground(new Color(0, 100, 0));
            } else {
                ret.setForeground(Color.RED);
            }
            ret.setText(Util.format2digit((String)(value + "")) + " ");
        } else {
            ret.setForeground(Color.BLACK);
        }
        return ret;
    }
}

