/*
 * Decompiled with CFR 0.152.
 */
package RendersNModels;

import CustomComponent.NxGLabelGradeint;
import CustomComponent.NxGTableCellRender;
import Utilities.LogsTC;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JTable;

public class OrderHistoryRender
extends NxGTableCellRender {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Date d;
        NxGLabelGradeint cell = new NxGLabelGradeint();
        cell.setText(" " + value + " ");
        cell.setHorizontalAlignment(2);
        if (column == 1 || column == 2 || column == 3) {
            cell.setHorizontalAlignment(4);
        }
        if (table.getModel().getColumnClass(column) == Double.class || table.getModel().getColumnClass(column) == Float.class) {
            cell.setText(Util.format2digit((String)value.toString()) + " ");
            cell.setHorizontalAlignment(4);
        }
        if (table.getModel().getColumnClass(column) == Integer.class || table.getModel().getColumnClass(column) == Long.class) {
            cell.setText(Util.format0digit((String)value.toString()) + " ");
            cell.setHorizontalAlignment(4);
        }
        if (table.getModel().getColumnClass(column) == Date.class) {
            try {
                d = (Date)value;
                cell.setText(" " + LogsTC.dateFormatAcc.format(d));
                cell.setHorizontalAlignment(2);
            }
            catch (Exception e) {
                e.printStackTrace();
                cell.setText(" ");
            }
        }
        if (table.getModel().getColumnClass(column) == java.sql.Date.class) {
            try {
                d = (java.sql.Date)value;
                cell.setText(" " + LogsTC.dateFormatAcc.format(d));
                cell.setHorizontalAlignment(4);
            }
            catch (Exception e) {
                e.printStackTrace();
                cell.setText(" ");
            }
        }
        if (column == 4) {
            String val = table.getValueAt(row, 4).toString().trim();
            if (val.equalsIgnoreCase("Buy")) {
                cell.setForeground(MyColors.tradeLogBuyFG);
            } else if (val.equalsIgnoreCase("SEL") || val.equalsIgnoreCase("SELL")) {
                cell.setForeground(MyColors.tradeLogSellFG);
            }
            cell.setHorizontalAlignment(0);
        }
        if (row % 2 == 0) {
            cell.setGradient(this.getOddColorStart(), this.getOddColorEnd());
        } else {
            cell.setGradient(this.getEvenColorStart(), this.getEvenColorEnd());
        }
        if (isSelected) {
            cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
            cell.setForeground(Color.WHITE);
        }
        if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
            cell.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
            cell.setForeground(Color.WHITE);
        }
        return cell;
    }
}

