/*
 * Decompiled with CFR 0.152.
 */
package RendersNModels;

import CustomComponent.NxGLabelGradeint;
import CustomComponent.NxGTableCellRender;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class TopGainerCellRenderer
extends NxGTableCellRender {
    private LanguageCentre languageCentre = new LanguageCentre();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        NxGLabelGradeint cell = new NxGLabelGradeint();
        String colName = table.getColumnName(column);
        cell.setForeground(Color.BLACK);
        if (obj == null) {
            obj = "";
        }
        if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Scrip))) {
            cell.setFont(AppConfig.defaultPlanFont);
            cell.setHorizontalAlignment(2);
            cell.setText(" " + obj.toString().trim() + " ");
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue("Contract"))) {
            cell.setFont(AppConfig.defaultPlanFont);
            cell.setHorizontalAlignment(2);
            cell.setText(" " + obj.toString().trim() + " ");
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Company))) {
            cell.setFont(AppConfig.defaultPlanFont);
            cell.setHorizontalAlignment(2);
            cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Last))) {
            cell.setForeground(MyColors.GainerFontGB);
            cell.setFont(cell.getFont().deriveFont(1));
            cell.setHorizontalAlignment(4);
            cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue("Change"))) {
            cell.setFont(AppConfig.defaultPlanFont);
            cell.setHorizontalAlignment(4);
            cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PercentChange))) {
            cell.setFont(AppConfig.defaultPlanFont);
            cell.setHorizontalAlignment(4);
            cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Volume))) {
            cell.setForeground(MyColors.LeaderFontGB);
            cell.setFont(cell.getFont().deriveFont(1));
            cell.setHorizontalAlignment(4);
            cell.setText(" " + Util.format0digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Trades))) {
            cell.setFont(AppConfig.defaultPlanFont);
            cell.setHorizontalAlignment(4);
            cell.setText(" " + Util.format0digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
        }
        if (row < 31) {
            cell.setGradient(MyColors.GainerColor[row], MyColors.GainerColor[row].brighter());
        } else {
            cell.setBackground(Color.white);
        }
        if (isSelected) {
            cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
            cell.setForeground(Color.WHITE);
        }
        if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
            cell.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
            cell.setForeground(Color.WHITE);
        }
        return cell;
    }
}

