/*
 * Decompiled with CFR 0.152.
 */
package RendersNModels;

import CustomComponent.NxGLabelGradeint;
import CustomComponent.NxGTableCellRender;
import MyDocking.Mediator;
import Utilities.LogsTC;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTable;

public class WithdrawStatementCellRender
extends NxGTableCellRender {
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy");

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        NxGLabelGradeint cell = new NxGLabelGradeint();
        cell.setForeground(MyColors.cellRenderFG);
        cell.setVerticalAlignment(0);
        String columnName2 = table.getColumnName(column);
        if (obj == null) {
            obj = "";
        }
        if (columnName2.equalsIgnoreCase("Serail No")) {
            cell.setHorizontalAlignment(2);
            cell.setText(" " + obj.toString() + " ");
        } else if (columnName2.equalsIgnoreCase("Requested Date")) {
            cell.setHorizontalAlignment(2);
            try {
                Date dd = this.df.parse(obj.toString().trim());
                cell.setText(" " + LogsTC.dateFormatAcc.format(dd));
                Mediator.getInstance().println("Logs.dateFormatAcc.format(dd)" + LogsTC.dateFormatAcc.format(dd));
            }
            catch (ParseException ex) {
                try {
                    Date dd2 = this.df2.parse(obj.toString().trim());
                    cell.setText(" " + LogsTC.dateFormatAcc.format(dd2));
                    Mediator.getInstance().println("Logs.dateFormatAcc.format(dd2)" + LogsTC.dateFormatAcc.format(dd2));
                }
                catch (ParseException ex1) {
                    cell.setText(" " + obj.toString() + " ");
                }
            }
        } else if (columnName2.equalsIgnoreCase("Amount Requested")) {
            cell.setHorizontalAlignment(4);
            cell.setText(" " + Util.format2digit((String)obj.toString()) + " ");
        } else if (columnName2.equalsIgnoreCase("Amount Approved")) {
            cell.setHorizontalAlignment(4);
            cell.setText(" " + Util.format2digit((String)obj.toString()) + " ");
        } else if (columnName2.equalsIgnoreCase("Withdrawal Mode")) {
            cell.setHorizontalAlignment(2);
            cell.setText(" " + obj.toString() + " ");
        } else if (columnName2.equalsIgnoreCase("Comments")) {
            cell.setHorizontalAlignment(2);
            cell.setText(" " + obj.toString() + " ");
        } else if (columnName2.equalsIgnoreCase("Status")) {
            cell.setHorizontalAlignment(2);
            cell.setText(" " + obj.toString() + " ");
        } else {
            cell.setHorizontalAlignment(2);
            cell.setText(" " + obj.toString() + " ");
        }
        if (row % 2 == 0) {
            cell.setGradient(this.getOddColorStart(), this.getOddColorEnd());
        } else {
            cell.setGradient(this.getEvenColorStart(), this.getEvenColorEnd());
        }
        if (isSelected) {
            cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
            cell.setForeground(Color.WHITE);
        }
        if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
            cell.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
            cell.setForeground(Color.WHITE);
        }
        return cell;
    }
}

