/*
 * Decompiled with CFR 0.152.
 */
package SC;

import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.OpenAndCDCRender;
import Utilities.LoadLogs;
import Utilities.LogsTC;
import Utilities.ThreadWithName;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class OpenAndCDC
extends JPanel {
    private LanguageCentre languageCentre = new LanguageCentre();
    private boolean isRun = true;
    private double totalPortfolio = 0.0;
    double total = 0.0;
    Thread refresh = null;
    DefaultTableModel tabModel = new DefaultTableModel(){
        boolean[] canEdit = new boolean[]{false, false, false, false};

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.canEdit[columnIndex];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < 0 || row >= this.getRowCount()) {
                return "";
            }
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            return rowVector.elementAt(column);
        }
    };
    public Vector rows = new Vector();
    public Vector columns = new Vector();
    String[] columnNames = new String[]{"Scrip", "Net Quantity", "MKT Rate", "Profit/Loss"};
    public static String SCMktSymbols = "";
    Mediator mediator = Mediator.getInstance();
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private JButton btnRefersh;
    public JComboBox cbAccountNo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblAccount;
    private JLabel lblMessage;
    private JLabel lblProfitLoss;
    private JLabel lblRemainingCash;
    private JLabel lblTime;
    private JLabel lblTotalPortfolio;
    private JTable tblCDC;
    Runnable RefreshTimer = new Runnable(){

        @Override
        public void run() {
            try {
                while (OpenAndCDC.this.isRun) {
                    Thread.sleep(90000L);
                    OpenAndCDC.this.loadDefaultAccount();
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                OpenAndCDC.this.mediator.PrintLog(ex, "");
            }
        }
    };

    public OpenAndCDC() {
        this.initComponents();
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        try {
            this.cbAccountNo.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        support.setStrict(true);
        this.initTable();
        this.setRender();
        this.mediator.setOpenAndCDC(this);
        if (this.refresh == null) {
            this.refresh = new Thread(this.RefreshTimer, "OpenAndCDC RefreshTimer");
            this.refresh.start();
        }
        this.loadDefaultAccount();
    }

    public void initTable() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columns.addElement(this.columnNames[i]);
        }
        this.tabModel.setDataVector(this.rows, this.columns);
        this.tblCDC.setModel(this.tabModel);
        this.tblCDC.getTableHeader().setReorderingAllowed(false);
        this.tblCDC.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.tblCDC.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.tblCDC.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.tblCDC.getColumnModel().getColumn(3).setPreferredWidth(90);
        this.tblCDC.setSelectionMode(0);
        JTableHeader header = this.tblCDC.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
    }

    public synchronized void updateTable(String Log) {
        System.err.println("CDC updateTable = " + Log);
        this.mediator.println(Log);
        if (Log.trim().length() <= 1 || Log.equalsIgnoreCase("~0.0")) {
            this.lblMessage.setText("No record found");
            this.lblMessage.setIcon(null);
            this.lblMessage.setForeground(Color.BLACK);
        } else if (Log.equalsIgnoreCase("Exception")) {
            this.lblMessage.setText("Error in loading Open & CDC Position");
            this.lblMessage.setIcon(null);
            this.lblMessage.setForeground(Color.BLACK);
        } else if (Log.indexOf("~") >= 0) {
            String remaining = Log.split("~")[1];
            this.lblRemainingCash.setText(Util.format2digit((String)remaining));
            int net = 0;
            double mktRate = 0.0;
            this.lblTime.setText("Last Updated Time " + MyTime.getInstance().getTime() + "");
            String[] rowVal = Log.split("~")[0].split("\\|", -1);
            this.removeTable();
            this.rows.clear();
            this.total = 0.0;
            for (int i = 0; i < rowVal.length - 1; ++i) {
                String syMkt;
                Vector<String> rowVecotr = new Vector<String>();
                if (rowVal[i].trim().equalsIgnoreCase("")) continue;
                String[] columnVal = rowVal[i].split("\\;", -1);
                if (!columnVal[0].equalsIgnoreCase("") && SCMktSymbols.indexOf(syMkt = columnVal[0] + ":" + UtilKSE.GetMarketFromsymbol((String)columnVal[0]) + ";") < 0) {
                    SCMktSymbols = SCMktSymbols + syMkt;
                }
                for (int j = 0; j < this.columnNames.length; ++j) {
                    if (j == 1) {
                        net = Integer.parseInt(columnVal[j]);
                    }
                    if (j == 2) {
                        mktRate = Double.parseDouble(columnVal[j]);
                    }
                    if (j == 3) {
                        double val = Double.parseDouble(columnVal[j]);
                        columnVal[j] = Util.format2digit((String)columnVal[j]);
                        this.total += val;
                    }
                    rowVecotr.addElement(columnVal[j]);
                }
                this.totalPortfolio += mktRate * (double)net;
                this.rows.addElement(rowVecotr);
                this.tblCDC.addNotify();
            }
            this.total = Util.round((double)this.total, (int)2);
            this.totalPortfolio = Util.round((double)this.totalPortfolio, (int)2);
            if (this.total == 0.0) {
                this.lblProfitLoss.setForeground(Color.BLACK);
            } else if (this.total > 0.0) {
                this.lblProfitLoss.setForeground(new Color(0, 100, 0));
            } else {
                this.lblProfitLoss.setForeground(Color.RED);
            }
            this.lblProfitLoss.setText(Util.format2digit((String)(this.total + "")));
            this.lblTotalPortfolio.setText(Util.format2digit((String)(this.totalPortfolio + "")));
            this.totalPortfolio = 0.0;
            this.lblMessage.setIcon(null);
            this.lblMessage.setText(Util.format0digit((String)(this.tblCDC.getModel().getRowCount() + "")) + " Record(s)");
        }
    }

    public void sendFeedSymbol() {
    }

    public void setRender() {
        this.tblCDC.setDefaultRenderer(Object.class, new OpenAndCDCRender());
    }

    public synchronized void loadDefaultAccount() {
        if (this.cbAccountNo.getSelectedItem() != null) {
            if (!this.cbAccountNo.getSelectedItem().toString().equalsIgnoreCase("")) {
                this.lblMessage.setForeground(MyColors.successMessageFG);
                this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblMessage.setIcon(this.loaderIcon);
                LoadLogs accSt = new LoadLogs("OpenAndCDC=", true);
                new ThreadWithName(accSt, "OpenAndCDC").start();
            } else {
                this.lblMessage.setText("Please Select Account");
            }
        }
    }

    public void stopOpenAndCDC() {
        this.isRun = false;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblCDC = new JTable();
        this.lblAccount = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.btnRefersh = new JButton();
        this.lblTime = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.lblMessage = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.lblTotalPortfolio = new JLabel();
        this.lblProfitLoss = new JLabel();
        this.lblRemainingCash = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.setPreferredSize(new Dimension(360, 395));
        this.jScrollPane1.setName("jScrollPane1");
        this.tblCDC.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tblCDC.setName("tblCDC");
        this.tblCDC.setSelectionForeground(new Color(0, 0, 0));
        this.jScrollPane1.setViewportView(this.tblCDC);
        this.lblAccount.setText("Account");
        this.lblAccount.setName("lblAccount");
        this.cbAccountNo.setName("cbAccountNo");
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OpenAndCDC.this.cbAccountNoItemStateChanged(evt);
            }
        });
        this.cbAccountNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenAndCDC.this.cbAccountNoActionPerformed(evt);
            }
        });
        this.btnRefersh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefersh.setText("Refresh");
        this.btnRefersh.setName("OpenAndCDC -> btnRefersh");
        this.btnRefersh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenAndCDC.this.btnRefershActionPerformed(evt);
            }
        });
        this.lblTime.setHorizontalAlignment(2);
        this.lblTime.setIcon(new ImageIcon(this.getClass().getResource("/Images/lastUpdateTime16.png")));
        this.lblTime.setText(" ");
        this.lblTime.setName("lblTime");
        this.jSeparator1.setName("jSeparator1");
        this.lblMessage.setText(" ");
        this.lblMessage.setName("lblMessage");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel1.setName("jPanel1");
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Remaining Cash After Nill Position");
        this.jLabel4.setName("jLabel4");
        this.jLabel1.setText("Profit / Loss");
        this.jLabel1.setName("jLabel1");
        this.jLabel3.setText("Total Portfolio Value");
        this.jLabel3.setName("jLabel3");
        this.lblTotalPortfolio.setFont(new Font("Tahoma", 1, 11));
        this.lblTotalPortfolio.setHorizontalAlignment(4);
        this.lblTotalPortfolio.setText("0.0");
        this.lblTotalPortfolio.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblTotalPortfolio.setName("lblTotalPortfolio");
        this.lblProfitLoss.setFont(new Font("Tahoma", 1, 11));
        this.lblProfitLoss.setHorizontalAlignment(4);
        this.lblProfitLoss.setText("0.0");
        this.lblProfitLoss.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblProfitLoss.setName("lblProfitLoss");
        this.lblRemainingCash.setFont(new Font("Tahoma", 1, 11));
        this.lblRemainingCash.setHorizontalAlignment(4);
        this.lblRemainingCash.setText("0.0");
        this.lblRemainingCash.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblRemainingCash.setName("lblRemainingCash");
        this.jLabel2.setText("Rs");
        this.jLabel2.setName("jLabel2");
        this.jLabel5.setText("Rs");
        this.jLabel5.setName("jLabel5");
        this.jLabel6.setText("Rs");
        this.jLabel6.setName("jLabel6");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 57, -2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addGap(7, 7, 7).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblProfitLoss, -1, 149, Short.MAX_VALUE).addComponent(this.lblTotalPortfolio, GroupLayout.Alignment.LEADING, -1, 144, Short.MAX_VALUE).addComponent(this.lblRemainingCash, GroupLayout.Alignment.LEADING, -1, 144, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 14, -2).addComponent(this.jLabel2).addComponent(this.lblProfitLoss, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTotalPortfolio, -2, 15, -2).addComponent(this.jLabel3, -2, 14, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblRemainingCash, -2, 15, -2).addComponent(this.jLabel4).addComponent(this.jLabel6))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblMessage, -2, 148, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblTime, -2, 192, -2)).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.lblAccount, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbAccountNo, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRefersh))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAccount, -2, 17, -2).addComponent(this.cbAccountNo, -2, 20, -2).addComponent(this.btnRefersh)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 255, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.jPanel1, -2, -1, -2).addGap(3, 3, 3).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMessage, -2, 14, -2).addComponent(this.lblTime, -2, 14, -2))));
    }

    private void cbAccountNoActionPerformed(ActionEvent evt) {
    }

    private void btnRefershActionPerformed(ActionEvent evt) {
        this.loadDefaultAccount();
    }

    private void cbAccountNoItemStateChanged(ItemEvent evt) {
        this.loadDefaultAccount();
    }

    private synchronized void removeTable() {
        DefaultTableModel model = (DefaultTableModel)this.tblCDC.getModel();
        int numrows = model.getRowCount();
        for (int i = 0; i < numrows; ++i) {
            model.removeRow(0);
        }
    }
}

