/*
 * Decompiled with CFR 0.152.
 */
package SC;

import CATALYST.Control.MarketFeed;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.MultiLineHeaderRenderer;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import kse.util.UtilKSE;

public class TradingSignal
extends JPanel {
    private boolean isRun = true;
    DefaultTableModel tableModel = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    };
    public Vector rows = new Vector();
    public Vector columns = new Vector();
    Object[] columnNames = new Object[]{"Scrip", "Last\nSignal\nDate", "Last\nSignal\nType", "Last\nSignal\nRate", "Next Signal", "Current", "High", "Low", "Details"};
    String allLog = "";
    String removeSymbol = "";
    Font plainFont = AppConfig.defaultPlanFont;
    JTextField txtSymbol = new JTextField();
    HashMap tradeMap = new HashMap();
    Thread refresh = null;
    Mediator mediator = Mediator.getInstance();
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    public static String Symbol = "";
    private JButton btnRefresh;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JLabel lblScripName;
    private JLabel lblTime;
    private JTable tblSignal;
    Runnable RefreshTimer = new Runnable(){

        @Override
        public void run() {
            try {
                while (TradingSignal.this.isRun) {
                    Thread.sleep(90000L);
                    TradingSignal.this.loadPrefrences();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                TradingSignal.this.mediator.PrintLog(ex, "");
            }
        }
    };

    public TradingSignal() {
        this.initComponents();
        this.lblScripName.setFont(this.lblScripName.getFont().deriveFont(1));
        this.initTable();
        this.setRender();
        this.mediator.setTradingSignal(this);
        this.btnRefresh.setVisible(true);
        this.intTableSymbol();
        this.loadPrefrences();
        if (this.refresh == null) {
            this.refresh = new Thread(this.RefreshTimer);
            this.refresh.start();
        }
    }

    public void stopTradingSignal() {
        this.isRun = false;
    }

    public void loadPrefrences() {
        if (LogCommon.TradingSymbols.length() > 1) {
            this.lblMessage.setText("Getting data of all symbol");
            this.lblMessage.setIcon(this.loaderIcon);
            try {
                LoadLogs accSt = new LoadLogs("TradingSignalAllSymbols=", true);
                new ThreadWithName(accSt, "TradingSignalAllSymbols").start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.mediator.PrintLog(ex, "");
            }
        } else {
            this.lblMessage.setText(" ");
            this.lblMessage.setIcon(null);
        }
    }

    public void removeSymbolFormFeed() {
        LogCommon.TradingSymbols = "";
        for (int i = 0; i < this.tblSignal.getRowCount(); ++i) {
            LogCommon.TradingSymbols = this.tblSignal.getValueAt(i, 0) != null ? LogCommon.TradingSymbols + this.tblSignal.getValueAt(i, 0) + ";" : LogCommon.TradingSymbols + ";";
        }
        this.mediator.sendFeedSymbols("", "Technical Singal (For SC) : removeSymbolFormFeed ");
    }

    public void setErrorResult() {
        this.lblMessage.setForeground(Color.BLACK);
        this.lblMessage.setText("Error in loading data");
        this.lblMessage.setIcon(null);
    }

    private int GetRow(String symbol) {
        int k = -1;
        for (int i = 0; i < this.tblSignal.getRowCount(); ++i) {
            String sym;
            if (this.tblSignal.getValueAt(i, 0) == null || !(sym = this.tblSignal.getValueAt(i, 0).toString()).trim().equalsIgnoreCase(symbol)) continue;
            return i;
        }
        return k;
    }

    private void GetSingalSymbolFeed() {
        Symbol = this.txtSymbol.getText().trim();
        this.lblMessage.setText(" ");
        int k = this.tblSignal.getSelectedRow();
        if (Symbol.equalsIgnoreCase("")) {
            this.emptyRow(k);
            return;
        }
        LogCommon.TradingSymbols = "";
        String symbo = this.tblSignal.getValueAt(k, 0).toString();
        for (int i = 0; i < this.tblSignal.getRowCount(); ++i) {
            if (this.tblSignal.getValueAt(i, 0) == null || k == i) continue;
            String symbol = this.tblSignal.getValueAt(i, 0).toString();
            LogCommon.TradingSymbols = LogCommon.TradingSymbols + symbol + ";";
        }
        if (LogCommon.TradingSymbols.indexOf(Symbol) >= 0) {
            this.lblMessage.setText("Scrip already added");
            this.emptyRow(k);
            UtilKSE.SelectRow((JTable)this.tblSignal, (JScrollPane)this.jScrollPane1, (int)this.GetRow(symbo));
            return;
        }
        LogCommon.TradingSymbols = LogCommon.TradingSymbols + Symbol + ";";
        this.lblMessage.setText("Getting data of " + Symbol);
        this.lblMessage.setIcon(this.loaderIcon);
        if (Symbol.length() > 1) {
            if (!this.tradeMap.containsKey(Symbol)) {
                LoadLogs accSt = new LoadLogs("TradingSymbol=", true);
                new Thread((Runnable)accSt, "TradingSymbol").start();
            } else {
                this.updateTableNew();
            }
            this.addSymbolInMarketWatch(this.txtSymbol.getText());
        } else {
            this.updateTableNew();
        }
        this.lblTime.setText("Last Updated Time " + MyTime.getInstance().getTime());
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
    }

    public String setSingalFeed(String feed) {
        if (feed == null || feed.equals("") || feed.equalsIgnoreCase("Null")) {
            feed = feed + Symbol + ";;;;;";
        }
        this.tradeMap.put(Symbol, feed);
        this.updateTableNew();
        return feed + "|";
    }

    private void emptyRow(int selectedRow) {
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.tblSignal.getModel().setValueAt("", selectedRow, i);
        }
    }

    private void initTable() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columns.addElement((String)this.columnNames[i]);
        }
        for (int k = 0; k < 25; ++k) {
            Vector<String> ro = new Vector<String>();
            for (int i = 0; i < this.columnNames.length; ++i) {
                ro.add(i, "");
            }
            this.rows.addElement(ro);
        }
        this.tableModel.setDataVector(this.rows, this.columns);
        this.tblSignal.setModel(this.tableModel);
        this.tblSignal.setSelectionMode(0);
        this.tblSignal.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.tblSignal.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.tblSignal.getColumnModel().getColumn(2).setPreferredWidth(40);
        this.tblSignal.getColumnModel().getColumn(3).setPreferredWidth(60);
        this.tblSignal.getColumnModel().getColumn(4).setPreferredWidth(300);
        this.tblSignal.getColumnModel().getColumn(5).setPreferredWidth(60);
        this.tblSignal.getColumnModel().getColumn(6).setPreferredWidth(60);
        this.tblSignal.getColumnModel().getColumn(7).setPreferredWidth(60);
        this.tblSignal.getColumnModel().getColumn(8).setPreferredWidth(50);
        final Cursor handCursor = new Cursor(12);
        final Cursor defaultCursor = new Cursor(0);
        this.tblSignal.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                TableColumnModel colModel = TradingSignal.this.tblSignal.getColumnModel();
                int vColIndex = colModel.getColumnIndexAtX(e.getX());
                int mColIndex = TradingSignal.this.tblSignal.convertColumnIndexToModel(vColIndex);
                if ("Details".equalsIgnoreCase(TradingSignal.this.tblSignal.getColumnName(mColIndex).toString())) {
                    TradingSignal.this.tblSignal.setCursor(handCursor);
                } else {
                    TradingSignal.this.tblSignal.setCursor(defaultCursor);
                }
            }
        });
        this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
        this.txtSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 9) {
                    TradingSignal.this.GetSingalSymbolFeed();
                    TradingSignal.this.SetName(TradingSignal.this.txtSymbol.getText());
                }
            }
        });
        this.txtSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TradingSignal.this.GetSingalSymbolFeed();
                TradingSignal.this.SetName(TradingSignal.this.txtSymbol.getText());
            }
        });
        this.txtSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TradingSignal.this.txtSymbol.selectAll();
            }
        });
        DefaultCellEditor editor = new DefaultCellEditor(this.txtSymbol);
        this.tblSignal.getColumn("Scrip").setCellEditor(editor);
        MultiLineHeaderRenderer renderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> e = this.tblSignal.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            e.nextElement().setHeaderRenderer(renderer);
        }
        this.tblSignal.getTableHeader().setReorderingAllowed(false);
        JTableHeader header = this.tblSignal.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        this.tblSignal.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = TradingSignal.this.tblSignal.getSelectedRow();
                Object ob = TradingSignal.this.tblSignal.getValueAt(row, 0);
                if (ob != null) {
                    TradingSignal.this.SetName(ob.toString());
                } else {
                    TradingSignal.this.lblScripName.setText(" ");
                }
            }
        });
    }

    private void intTableSymbol() {
        String[] symbols = LogCommon.TradingSymbols.split("\\;", -1);
        for (int i = 0; i < 25; ++i) {
            Vector v = (Vector)this.rows.get(i);
            try {
                v.add(0, symbols[i]);
                continue;
            }
            catch (Exception ex) {
                v.add(0, "");
            }
        }
    }

    public void setRender() {
        final Color buyColorBG = new Color(0, 199, 206);
        final Color sellColorBG = new Color(214, 178, 189);
        for (int k = 0; k < this.columnNames.length; ++k) {
            this.tblSignal.getColumn(this.columnNames[k]).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    String val = "";
                    String prefix = "";
                    JLabel cell = (JLabel)super.getTableCellRendererComponent(tblDataTable, value, isSelected, hasFocus, row, column);
                    cell.setForeground(Color.BLACK);
                    Color finalBGColor = null;
                    try {
                        if (tblDataTable.getModel().getValueAt(row, 2) != null) {
                            String colorCondition = tblDataTable.getModel().getValueAt(row, 2) + "";
                            if (colorCondition.equalsIgnoreCase("Buy")) {
                                prefix = "Sell Today When Price Closes Below ";
                                finalBGColor = buyColorBG;
                            } else if (colorCondition.equalsIgnoreCase("Sell")) {
                                prefix = "Buy Today When Price Closes Above ";
                                finalBGColor = sellColorBG;
                            } else {
                                finalBGColor = null;
                            }
                        }
                        if (column == 8) {
                            value = "";
                        }
                        if (value == null || value.toString().equalsIgnoreCase("Null")) {
                            val = "";
                        } else if (value != null) {
                            val = value.toString();
                        }
                        if ("Details".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                            if (tblDataTable.getValueAt(row, 0) != null && !tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                                cell.setText("<HTMl><U>Details</U></HTML>");
                                cell.setHorizontalAlignment(0);
                                cell.setForeground(MyColors.ForgotPincodeFG);
                                cell.setFont(cell.getFont().deriveFont(1));
                            }
                        } else if ("Scrip".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                            if (tblDataTable.getValueAt(row, 0) != null) {
                                if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                                    cell.setText(" " + val + " ");
                                    cell.setHorizontalAlignment(2);
                                    cell.setForeground(Color.BLACK);
                                    cell.setFont(cell.getFont().deriveFont(1));
                                } else {
                                    cell.setText("");
                                }
                            }
                        } else if ("Last\nSignal\nDate".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                            if (tblDataTable.getValueAt(row, 0) != null) {
                                if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                                    cell.setHorizontalAlignment(2);
                                    cell.setText(" " + val + " ");
                                    cell.setFont(TradingSignal.this.plainFont);
                                } else {
                                    cell.setText("");
                                }
                            }
                        } else if ("Last\nSignal\nType".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                            if (tblDataTable.getValueAt(row, 0) != null) {
                                if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                                    cell.setText(" " + val + " ");
                                    cell.setHorizontalAlignment(2);
                                    cell.setFont(TradingSignal.this.plainFont);
                                } else {
                                    cell.setText("");
                                }
                            }
                        } else if ("Last\nSignal\nRate".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                            if (tblDataTable.getValueAt(row, 0) != null) {
                                if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                                    cell.setText(Util.format2digit((String)val) + " ");
                                    cell.setHorizontalAlignment(4);
                                    cell.setFont(TradingSignal.this.plainFont);
                                } else {
                                    cell.setText("");
                                }
                            }
                        } else if ("Next Signal".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                            if (tblDataTable.getValueAt(row, 0) != null) {
                                if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                                    cell.setText(" " + prefix + val + " ");
                                    cell.setHorizontalAlignment(2);
                                    cell.setFont(cell.getFont().deriveFont(1));
                                } else {
                                    cell.setText("");
                                }
                            }
                        } else if ("Current".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                            if (tblDataTable.getValueAt(row, 0) != null) {
                                if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                                    cell.setText(Util.format2digit((String)val) + " ");
                                    cell.setHorizontalAlignment(4);
                                    cell.setForeground(Color.BLACK);
                                    cell.setFont(cell.getFont().deriveFont(1));
                                } else {
                                    cell.setText("");
                                }
                            }
                        } else if ("High".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                            if (tblDataTable.getValueAt(row, 0) != null) {
                                if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                                    cell.setText(Util.format2digit((String)val) + " ");
                                    cell.setHorizontalAlignment(4);
                                    cell.setForeground(Color.BLACK);
                                    cell.setFont(TradingSignal.this.plainFont);
                                } else {
                                    cell.setText("");
                                }
                            }
                        } else if ("Low".equalsIgnoreCase(tblDataTable.getColumnName(column).toString()) && tblDataTable.getValueAt(row, 0) != null) {
                            if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                                cell.setText(Util.format2digit((String)val) + " ");
                                cell.setHorizontalAlignment(4);
                                cell.setForeground(Color.BLACK);
                                cell.setFont(TradingSignal.this.plainFont);
                            } else {
                                cell.setText("");
                            }
                        }
                        if (finalBGColor == null) {
                            if (row % 2 == 0) {
                                cell.setBackground(MyColors.cellRenderEven);
                            } else {
                                cell.setBackground(MyColors.cellRenderOdd);
                            }
                        } else {
                            cell.setBackground(finalBGColor);
                        }
                        if (isSelected) {
                            cell.setBackground(MyColors.SelectionFG);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return cell;
                }
            });
        }
    }

    public void printall() {
        Iterator iterator = this.tradeMap.entrySet().iterator();
        while (iterator.hasNext()) {
        }
    }

    public synchronized void updateTableNew() {
        for (int row = 0; row < this.tblSignal.getRowCount(); ++row) {
            String symbol = "";
            String feed = ";;;;;;;";
            if (this.tblSignal.getValueAt(row, 0) == null) {
                for (int j = 0; j < this.columnNames.length - 2; ++j) {
                    this.tblSignal.getModel().setValueAt("", row, j + 1);
                }
                continue;
            }
            if (this.tblSignal.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                for (int j = 0; j < this.columnNames.length - 2; ++j) {
                    this.tblSignal.getModel().setValueAt("", row, j + 1);
                }
                continue;
            }
            symbol = this.tblSignal.getValueAt(row, 0).toString();
            if (this.tradeMap.containsKey(symbol) && (feed = this.tradeMap.get(symbol).toString()).equalsIgnoreCase("Null")) continue;
            String[] columnVal = feed.split("\\;", -1);
            Vector ro = (Vector)this.rows.get(row);
            String rate = this.GetCurrentHighLow(columnVal[0].toUpperCase());
            String[] crHilow = rate.split("\\|", -1);
            for (int col = 0; col < this.columnNames.length; ++col) {
                String val = "";
                if (col == 1) {
                    val = columnVal[1];
                    ro.remove(col);
                    ro.add(col, val);
                    continue;
                }
                if (col == 2) {
                    val = columnVal[2];
                    ro.remove(col);
                    ro.add(col, val);
                    continue;
                }
                if (col == 3) {
                    val = columnVal[3];
                    ro.remove(col);
                    ro.add(col, val);
                    continue;
                }
                if (col == 4) {
                    val = columnVal[4];
                    ro.remove(col);
                    ro.add(col, val);
                    continue;
                }
                if (col == 5) {
                    val = crHilow[0];
                    ro.remove(col);
                    ro.add(col, val);
                    continue;
                }
                if (col == 6) {
                    val = crHilow[1];
                    ro.remove(col);
                    ro.add(col, val);
                    continue;
                }
                if (col != 7) continue;
                val = crHilow[2];
                ro.remove(col);
                ro.add(col, val);
            }
        }
        this.tblSignal.addNotify();
    }

    public synchronized void updateTableNew(String Log) {
        this.mediator.println("in trading  = " + Log);
        this.setMapValue(Log);
        if (Log.equalsIgnoreCase("")) {
            this.lblMessage.setText("No record found");
            this.lblMessage.setIcon(null);
            return;
        }
        int rowVal = this.tblSignal.getRowCount();
        for (int row = 0; row < rowVal; ++row) {
            String feed = ";;;;;;;";
            if (this.tblSignal.getValueAt(row, 0) == null) continue;
            String symbol = this.tblSignal.getValueAt(row, 0).toString().toUpperCase();
            String rate = this.GetCurrentHighLow(symbol);
            String[] crHilow = rate.split("\\|", -1);
            if (this.tradeMap.containsKey(symbol)) {
                feed = this.tradeMap.get(symbol).toString();
            }
            String[] columnVal = feed.split("\\;", -1);
            Vector ro = (Vector)this.rows.get(row);
            for (int col = 0; col < this.columnNames.length; ++col) {
                String val = "";
                if (col == 1) {
                    val = columnVal[1];
                    ro.remove(col);
                    ro.add(col, val);
                    continue;
                }
                if (col == 2) {
                    val = columnVal[2];
                    ro.remove(col);
                    ro.add(col, val);
                    continue;
                }
                if (col == 3) {
                    val = columnVal[3];
                    ro.remove(col);
                    ro.add(col, val);
                    continue;
                }
                if (col == 4) {
                    val = columnVal[4];
                    ro.remove(col);
                    ro.add(col, val);
                    continue;
                }
                if (col == 5) {
                    val = crHilow[0];
                    ro.remove(col);
                    ro.add(col, val);
                    continue;
                }
                if (col == 6) {
                    val = crHilow[1];
                    ro.remove(col);
                    ro.add(col, val);
                    continue;
                }
                if (col != 7) continue;
                val = crHilow[2];
                ro.remove(col);
                ro.add(col, val);
            }
        }
        this.tblSignal.addNotify();
        this.lblTime.setText("Last Updated Time " + MyTime.getInstance().getTime());
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
    }

    private void setMapValue(String Log) {
        String[] rowVal = Log.split("\\|", -1);
        this.tradeMap.clear();
        for (int row = 0; row < rowVal.length - 1; ++row) {
            String symbol;
            String[] columnVal;
            if (rowVal[row].trim().equalsIgnoreCase("") || (columnVal = rowVal[row].split("\\;", -1))[0].trim().equalsIgnoreCase("") || columnVal[0].equalsIgnoreCase("null") || columnVal.length < 5 || this.tradeMap.containsKey(symbol = columnVal[0].toString().toUpperCase())) continue;
            this.tradeMap.put(symbol, rowVal[row]);
        }
    }

    private String GetCurrentHighLow(String symbol) {
        String rate = "||";
        MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(symbol, UtilKSE.GetMarketFromsymbol((String)symbol));
        if (mktFeed != null) {
            rate = mktFeed.lTrdPrice + "|" + mktFeed.high + "|" + mktFeed.low;
        }
        return rate;
    }

    public void addSymbolInMarketWatch(String symbolList) {
        String symbol2 = UtilKSE.getUniqueSymbols((String)LogCommon.TradingSymbols, (String)symbolList);
        String withmarket = "";
        String[] symbol = symbol2.split(";");
        for (int i = 0; i < symbol.length; ++i) {
            if (symbol[i].equalsIgnoreCase("")) continue;
            withmarket = withmarket + symbol[i] + ":" + UtilKSE.GetMarketFromsymbol((String)symbol[i]) + ";";
        }
        this.mediator.sendFeedSymbols(withmarket, "Trading Singal (For SC) : addSymbolInMarketWatch");
    }

    public void SetName(String symbol) {
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblScripName.setText("Invalid Scrip");
            this.lblScripName.setIcon(null);
        } else {
            this.lblScripName.setText(this.mediator.getSymbolTitle(symbol));
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblSignal = new JTable();
        this.jSeparator1 = new JSeparator();
        this.lblScripName = new JLabel();
        this.btnRefresh = new JButton();
        this.lblMessage = new JLabel();
        this.lblTime = new JLabel();
        this.jScrollPane1.setName("jScrollPane1");
        this.tblSignal.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null, null}}, new String[]{"Symbol", "Last Signal Date", "Last Signal Type", "Last Signal Trade", "Next Signal", "Current", "High", "Low", "Detail"}));
        this.tblSignal.setName("tblSignal");
        this.tblSignal.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TradingSignal.this.tblSignalMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tblSignal);
        this.jSeparator1.setName("jSeparator1");
        this.lblScripName.setText(" ");
        this.lblScripName.setName("lblScripName");
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setName("TradingSignal -> btnRefresh");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TradingSignal.this.btnRefreshActionPerformed(evt);
            }
        });
        this.lblMessage.setText("Message");
        this.lblMessage.setName("lblMessage");
        this.lblTime.setIcon(new ImageIcon(this.getClass().getResource("/Images/lastUpdateTime16.png")));
        this.lblTime.setText("Last Updated Time 13:15:55 PKT ");
        this.lblTime.setName("lblTime");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lblScripName, -1, 313, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblMessage, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblTime).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnRefresh).addContainerGap()).addComponent(this.jSeparator1, -1, 794, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 794, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 245, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnRefresh, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTime).addComponent(this.lblScripName).addComponent(this.lblMessage)).addGap(4, 4, 4)))));
    }

    private void tblSignalMouseClicked(MouseEvent evt) {
        JTable table_ = (JTable)evt.getSource();
        TableColumnModel colModel = table_.getColumnModel();
        this.removeSymbol = table_.getValueAt(table_.getSelectedRow(), 0) + "";
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        int mColIndex = this.tblSignal.convertColumnIndexToModel(vColIndex);
        if ("Details".equalsIgnoreCase(this.tblSignal.getColumnName(mColIndex).toString())) {
            try {
                String symbol = this.tblSignal.getValueAt(this.tblSignal.getSelectedRow(), 0).toString();
                if (!symbol.equalsIgnoreCase("")) {
                    Desktop.getDesktop().browse(URI.create(AppConfig.tradingSignalURL + symbol + "&days=30"));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.mediator.PrintLog(ex, "");
            }
        }
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.loadPrefrences();
    }
}

