/*
 * Decompiled with CFR 0.152.
 */
package SC;

import Beans.TransHistoryBean;
import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.MultiLineHeaderRenderer;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import languages.LanguageCentre;
import languages.LanguageConstant;
import login.LoginServer;
import org.jdesktop.swingx.JXDatePicker;
import reports.Jasper_Report;
import reports.Report_TransactionHistory;

public class Trans
extends JPanel
implements ReportControlListener {
    private LanguageCentre languageCentre = new LanguageCentre();
    final Color redColor = new Color(247, 59, 59);
    final Color greenColor = new Color(13, 153, 13);
    private static final int UIN = 0;
    private static final int Symbol = 1;
    private static final int TradeDate = 2;
    private static final int SettleDate = 3;
    private static final int Pur_Quantity = 4;
    private static final int Pur_Rate = 5;
    private static final int Pur_RateAfterComm = 6;
    private static final int Pur_Amount = 7;
    private static final int Pur_AmountAfterComm = 8;
    private static final int Sel_Quantity = 9;
    private static final int Sel_Rate = 10;
    private static final int Sel_RateAfterComm = 11;
    private static final int Sel_Amount = 12;
    private static final int Sel_AmountAfterComm = 13;
    int emptyRangeEnd = 3;
    int puchaseRangeEnd = 8;
    int sellRangeEnd = 13;
    private JTextComponent editorAccount;
    private JTextComponent editorScrip;
    public String JRXMLFileName = "TransactionHistory.jrxml";
    private AutoCompleteSupport autoCompleteScrip;
    String[] columnNames = new String[]{"UIN", "Scrip", "Trade\nDate", "Settlement\nDate", "Quantaty", "Rate", "Rate After\nCommission", "Amount", "Amount After\nCommission", "Quantaty", "Rate", "Rate After\nCommission", "Amount", "Amount After\nCommission"};
    TranHistoryModel model = new TranHistoryModel();
    public Vector<TransHistoryBean> rows = new Vector();
    private int xx;
    Thread thear1 = new Thread(new Thread(){

        @Override
        public void run() {
            try {
                LoginServer port;
                String result;
                Trans.this.removeTable();
                SimpleDateFormat smp = new SimpleDateFormat("yyyy-MM-dd");
                String clientCode = Trans.this.cbAccountNo.getSelectedItem().toString().trim();
                String startDate = smp.format(Trans.this.txtStartDate.getDate());
                String endDate = smp.format(Trans.this.txtEndDate.getDate());
                String scrip = Trans.this.cbScrip.getSelectedItem().toString();
                if (scrip.equalsIgnoreCase("All")) {
                    scrip = "";
                }
                if ((result = (port = WebService.getInstance().getPort()).getClientTransactionSummary(LogCommon.UserID, clientCode, startDate, endDate, scrip)).equalsIgnoreCase("Error")) {
                    Util.setMessage((JLabel)Trans.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in Loading");
                } else if (result.equalsIgnoreCase("No Record(s) found")) {
                    Util.setMessage((JLabel)Trans.this.lblMessage, (MessageType)MessageType.Information, (String)"No Record(s) found");
                } else if (result.equalsIgnoreCase("AccountNotAssign")) {
                    Util.setMessage((JLabel)Trans.this.lblMessage, (MessageType)MessageType.Error, (String)("Account '" + clientCode + "' is Not assign"));
                } else {
                    Trans.this.fillTable(result);
                }
            }
            catch (Exception ex) {
                Util.setMessage((JLabel)Trans.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in Loading Transatction History");
                ex.printStackTrace();
                Mediator.getInstance().PrintLog(ex, "");
            }
        }
    });
    private JButton btnGet;
    private JComboBox cbAccountNo;
    private JComboBox cbScrip;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private ReportControl reportControl1;
    private JScrollPane spHeader;
    private JScrollPane spTable;
    private JTable table;
    private JTable tblHeader;
    private JXDatePicker txtEndDate;
    private JXDatePicker txtStartDate;

    public Trans() {
        this.initComponents();
        this.txtStartDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtEndDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.table.getTableHeader().setReorderingAllowed(false);
        this.rows = new Vector();
        this.table.setModel(this.model);
        this.model.DefualtSort();
        this.setAccounts();
        this.setScrip();
        this.setTable();
        this.setRender();
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                Trans.this.changeMargin();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.table.getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Trans.this.xx = e.getX();
            }
        });
        this.changeMargin();
        this.spTable.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Rectangle rec = Trans.this.table.getVisibleRect();
                rec.y = 10;
                Trans.this.spHeader.getHorizontalScrollBar().setValue(rec.x);
            }
        });
        this.reportControl1.addListener(this);
        this.setFocus();
    }

    public void changeMargin() {
        try {
            TableColumnModel colModel = this.table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(this.xx);
            colModel.getColumn(vColIndex);
            int width1 = 0;
            for (int i = 0; i <= this.emptyRangeEnd; ++i) {
                width1 += this.table.getColumn(this.table.getColumnName(i)).getPreferredWidth();
            }
            this.tblHeader.getColumn(this.tblHeader.getColumnName(0)).setPreferredWidth(width1);
            int width2 = 0;
            for (int j = this.emptyRangeEnd + 1; j <= this.puchaseRangeEnd; ++j) {
                width2 += this.table.getColumn(this.table.getColumnName(j)).getPreferredWidth();
            }
            this.tblHeader.getColumn(this.tblHeader.getColumnName(1)).setPreferredWidth(width2);
            int ww = this.table.getPreferredSize().width - (width1 + width2);
            this.tblHeader.getColumn(this.tblHeader.getColumnName(2)).setPreferredWidth(ww);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAccounts() {
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        support.setStrict(true);
        if (LogCommon.preferredAccount.trim().length() > 0) {
            this.cbAccountNo.setSelectedItem(LogCommon.preferredAccount);
        } else {
            this.cbAccountNo.setSelectedItem("");
        }
        this.editorAccount = (JTextComponent)this.cbAccountNo.getEditor().getEditorComponent();
        this.editorAccount.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    Trans.this.cbScrip.requestFocus();
                }
            }
        });
        this.removeTable();
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
        this.txtStartDate.setDate(MyTime.getInstance().getDate2());
        this.txtEndDate.setDate(MyTime.getInstance().getDate2());
    }

    private void setScrip() {
        Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
        allScrip.addElement("ALL");
        Collections.sort(allScrip);
        this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
        this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
        this.cbScrip.setSelectedItem("ALL");
        this.editorScrip = (JTextComponent)this.cbScrip.getEditor().getEditorComponent();
        this.editorScrip.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    Trans.this.txtStartDate.requestFocus();
                }
            }
        });
    }

    private void setTable() {
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoCreateRowSorter(false);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        MultiLineHeaderRenderer renderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> e = this.table.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            e.nextElement().setHeaderRenderer(renderer);
        }
        MultiLineHeaderRenderer renderer2 = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> ee = this.tblHeader.getColumnModel().getColumns();
        while (ee.hasMoreElements()) {
            ee.nextElement().setHeaderRenderer(renderer2);
        }
        JTableHeader header2 = this.tblHeader.getTableHeader();
        ((JLabel)((Object)header2.getDefaultRenderer())).setHorizontalAlignment(0);
        ((JLabel)((Object)header2.getDefaultRenderer())).setFont(((JLabel)((Object)header2.getDefaultRenderer())).getFont().deriveFont(1));
        int i = 0;
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(80);
    }

    private synchronized void fillTable(String result) {
        this.lblMessage.setForeground(Color.BLACK);
        this.removeTable();
        String symbol = "";
        long purQuantity = 0L;
        double purRate = 0.0;
        double purRateAfterComm = 0.0;
        double purAmount = 0.0;
        double purAmountAfterComm = 0.0;
        long selQuantity = 0L;
        double selRate = 0.0;
        double selRateAfterComm = 0.0;
        double selAmount = 0.0;
        double selAmountAfterComm = 0.0;
        int purDiv = 0;
        int selDiv = 0;
        if (result.indexOf("=") >= 0) {
            String[] str1 = result.split("=");
            String[] Row2 = str1[1].split("\\|", -1);
            for (int rowCount = 0; rowCount < Row2.length - 1; ++rowCount) {
                TransHistoryBean a;
                TransHistoryBean th = this.parse(Row2[rowCount].split("\\;", -1));
                if (rowCount == 0) {
                    symbol = th.Symbol;
                }
                if (th.Symbol.equalsIgnoreCase(symbol)) {
                    this.rows.addElement(th);
                    purQuantity += th.Pur_Quantity;
                    purRate += th.Pur_Rate;
                    purRateAfterComm += th.Pur_RateAfterComm;
                    purAmount += th.Pur_Amount;
                    purAmountAfterComm += th.Pur_AmountAfterComm;
                    selQuantity += th.Sel_Quantity;
                    selRate += th.Sel_Rate;
                    selRateAfterComm += th.Sel_RateAfterComm;
                    selAmount += th.Sel_Amount;
                    selAmountAfterComm += th.Sel_AmountAfterComm;
                    if (th.Pur_Rate > 0.0) {
                        ++purDiv;
                    }
                    if (th.Sel_Rate > 0.0) {
                        ++selDiv;
                    }
                } else {
                    a = new TransHistoryBean();
                    a.Pur_Quantity = purQuantity;
                    a.Pur_Rate = purAmount / (double)purQuantity;
                    a.Pur_RateAfterComm = purAmountAfterComm / (double)purQuantity;
                    a.Pur_Amount = purAmount;
                    a.Pur_AmountAfterComm = purAmountAfterComm;
                    a.Sel_Quantity = selQuantity;
                    a.Sel_Rate = selAmount / (double)selQuantity;
                    a.Sel_RateAfterComm = selAmountAfterComm / (double)selQuantity;
                    a.Sel_Amount = selAmount;
                    a.Sel_AmountAfterComm = selAmountAfterComm;
                    a.Symbol = "Total";
                    a.TradeDate = "Profit / Loss";
                    a.SettleDate = selAmount - purAmount + "";
                    this.rows.addElement(a);
                    this.rows.addElement(th);
                    symbol = th.Symbol;
                    purQuantity = th.Pur_Quantity;
                    purRate = th.Pur_Rate;
                    purRateAfterComm = th.Pur_RateAfterComm;
                    purAmount = th.Pur_Amount;
                    purAmountAfterComm = th.Pur_AmountAfterComm;
                    selQuantity = th.Sel_Quantity;
                    selRate = th.Sel_Rate;
                    selRateAfterComm = th.Sel_RateAfterComm;
                    selAmount = th.Sel_Amount;
                    selAmountAfterComm = th.Sel_AmountAfterComm;
                    purDiv = 0;
                    selDiv = 0;
                    if (th.Pur_Rate > 0.0) {
                        purDiv = 1;
                    }
                    if (th.Sel_Rate > 0.0) {
                        selDiv = 1;
                    }
                }
                if (rowCount != Row2.length - 2) continue;
                a = new TransHistoryBean();
                a.Symbol = symbol;
                a.Pur_Quantity = purQuantity;
                a.Pur_Rate = purAmount / (double)purQuantity;
                a.Pur_RateAfterComm = purAmountAfterComm / (double)purQuantity;
                a.Pur_Amount = purAmount;
                a.Pur_AmountAfterComm = purAmountAfterComm;
                a.Sel_Quantity = selQuantity;
                a.Sel_Rate = selAmount / (double)selQuantity;
                a.Sel_RateAfterComm = selAmountAfterComm / (double)selQuantity;
                a.Sel_Amount = selAmount;
                a.Sel_AmountAfterComm = selAmountAfterComm;
                a.Symbol = "Total";
                a.TradeDate = "Profit / Loss";
                a.SettleDate = selAmount - purAmount + "";
                this.rows.addElement(a);
            }
            this.model.refresh();
            this.lblMessage.setText(Row2.length - 1 + " Record(s)");
            this.lblMessage.setIcon(null);
        } else {
            this.lblMessage.setText(result);
            this.lblMessage.setIcon(null);
        }
        this.table.setModel(this.model);
        this.model.DefualtSort();
    }

    public void removeTable() {
        if (this.model != null) {
            this.rows.clear();
            this.table.addNotify();
        }
    }

    private TransHistoryBean parse(String[] data) {
        TransHistoryBean tb = new TransHistoryBean();
        tb.UIN = data[0];
        tb.Symbol = data[1];
        tb.TradeDate = data[2];
        tb.SettleDate = data[3];
        try {
            tb.Pur_Quantity = Long.parseLong(data[4]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tb.Pur_Rate = Double.parseDouble(data[5]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tb.Pur_RateAfterComm = Double.parseDouble(data[6]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tb.Pur_Amount = Double.parseDouble(data[7]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tb.Pur_AmountAfterComm = Double.parseDouble(data[8]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tb.Sel_Quantity = Long.parseLong(data[9]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tb.Sel_Rate = Double.parseDouble(data[10]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tb.Sel_RateAfterComm = Double.parseDouble(data[11]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tb.Sel_Amount = Double.parseDouble(data[12]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tb.Sel_AmountAfterComm = Double.parseDouble(data[13]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tb;
    }

    private void getData() {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        if (this.cbAccountNo.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select account.");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().length() <= 0 || this.cbAccountNo.getSelectedItem().toString().equalsIgnoreCase("")) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select account.");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.txtStartDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select Start date.");
            this.txtStartDate.requestFocus();
            return;
        }
        if (this.txtEndDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select End date.");
            this.txtEndDate.requestFocus();
            return;
        }
        if (!this.txtStartDate.getDate().before(this.txtEndDate.getDate()) && this.txtStartDate.getDate().compareTo(this.txtEndDate.getDate()) != 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Start date should be less then or equal to end date.");
            this.txtStartDate.requestFocus();
            return;
        }
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
        new Thread(this.thear1).start();
    }

    private void initComponents() {
        this.cbAccountNo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.spHeader = new JScrollPane();
        this.tblHeader = new JTable();
        this.txtStartDate = new JXDatePicker();
        this.jLabel3 = new JLabel();
        this.txtEndDate = new JXDatePicker();
        this.lblMessage = new JLabel();
        this.btnGet = new JButton();
        this.spTable = new JScrollPane();
        this.table = new JTable();
        this.jSeparator1 = new JSeparator();
        this.reportControl1 = new ReportControl();
        this.cbScrip = new JComboBox();
        this.jLabel4 = new JLabel();
        this.cbAccountNo.setEditable(true);
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Trans.this.cbAccountNoItemStateChanged(evt);
            }
        });
        this.jLabel1.setText("Account");
        this.jLabel2.setText("Start Date");
        this.jPanel1.setBackground(new Color(0, 0, 204));
        this.spHeader.setHorizontalScrollBarPolicy(31);
        this.spHeader.setEnabled(false);
        this.spHeader.setFocusable(false);
        this.tblHeader.setModel(new DefaultTableModel(new Object[0][], new String[]{"", "Purchase", "Sale"}));
        this.tblHeader.setAutoResizeMode(0);
        this.tblHeader.setEnabled(false);
        this.tblHeader.setFocusable(false);
        this.tblHeader.setRequestFocusEnabled(false);
        this.tblHeader.getTableHeader().setResizingAllowed(false);
        this.tblHeader.getTableHeader().setReorderingAllowed(false);
        this.spHeader.setViewportView(this.tblHeader);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spHeader, -1, 790, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spHeader, -2, 21, -2));
        this.txtStartDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Trans.this.txtStartDateActionPerformed(evt);
            }
        });
        this.jLabel3.setText("End Date");
        this.txtEndDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Trans.this.txtEndDateActionPerformed(evt);
            }
        });
        this.lblMessage.setText("jLabel1");
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setName("Trans -> btnGet");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Trans.this.btnGetActionPerformed(evt);
            }
        });
        this.spTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                Trans.this.spTableComponentMoved(evt);
            }
        });
        this.spTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Trans.this.spTablePropertyChange(evt);
            }
        });
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setAutoResizeMode(0);
        this.spTable.setViewportView(this.table);
        this.cbScrip.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel4.setText("Scrip");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 810, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.spTable, GroupLayout.Alignment.LEADING, -1, 790, Short.MAX_VALUE).addComponent(this.lblMessage, GroupLayout.Alignment.LEADING, -2, 350, -2).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1, -2, 53, -2).addGap(2, 2, 2).addComponent(this.cbAccountNo, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -2, 34, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbScrip, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtStartDate, -2, -1, -2).addGap(7, 7, 7).addComponent(this.jLabel3).addGap(5, 5, 5).addComponent((Component)this.txtEndDate, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGet).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE).addComponent(this.reportControl1, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbAccountNo, -2, 22, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -2, 20, -2).addComponent(this.cbScrip, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, 18, -2).addComponent((Component)this.txtStartDate, -2, -1, -2).addComponent((Component)this.txtEndDate, -2, -1, -2)).addComponent(this.btnGet, -2, 22, -2).addComponent(this.jLabel2, -2, 18, -2)).addComponent(this.reportControl1, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, 0).addComponent(this.spTable, -1, 210, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addGap(0, 0, 0).addComponent(this.lblMessage, -2, 22, -2)));
    }

    private void cbAccountNoItemStateChanged(ItemEvent evt) {
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.getData();
    }

    private void spTableComponentMoved(ComponentEvent evt) {
    }

    private void spTablePropertyChange(PropertyChangeEvent evt) {
    }

    private void txtStartDateActionPerformed(ActionEvent evt) {
        this.txtEndDate.requestFocus();
    }

    private void txtEndDateActionPerformed(ActionEvent evt) {
        this.btnGet.requestFocus();
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_TransactionHistory Report = new Report_TransactionHistory(this.JRXMLFileName, this.table.getModel());
        this.SetParamter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_TransactionHistory Report = new Report_TransactionHistory(this.JRXMLFileName, this.table.getModel());
        this.SetParamter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Transaction History-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(this, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        Report_TransactionHistory Report = new Report_TransactionHistory(this.JRXMLFileName, this.table.getModel());
        this.SetParamter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Transaction History-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null) {
            String FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion();
            boolean result = Report.ExportToPdf(FileName);
            if (result) {
                int Option = JOptionPane.showConfirmDialog(this, "Transaction History report created. Do you want to open it?", "PDF", 0);
                if (Option == 0) {
                    try {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error in creating pdf file.");
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_TransactionHistory Report = new Report_TransactionHistory(this.JRXMLFileName, this.table.getModel());
        this.SetParamter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void SetParamter(Jasper_Report Report) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        param.put("AccountNo", this.cbAccountNo.getSelectedItem().toString());
        param.put("AccountName", LogsTC.accountAll.get(this.cbAccountNo.getSelectedItem().toString()).getName());
        param.put("FromDate", LogsTC.dateFormatAcc.format(this.txtStartDate.getDate()));
        param.put("ToDate", LogsTC.dateFormatAcc.format(this.txtEndDate.getDate()));
        Report.SetParameter(param);
    }

    private void setFocus() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                    Trans.this.cbAccountNo.requestFocus();
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Trans.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }.start();
    }

    private void setRender() {
        this.table.setDefaultRenderer(Object.class, new TranHistoryRender());
    }

    class TranHistoryModel
    extends AbstractTableModel {
        protected int sortCol = 0;
        protected boolean isSortAsc = true;
        protected int m_result = 0;
        protected int columnsCount = 1;
        public Hashtable<String, TransHistoryBean> ht = new Hashtable();
        Class[] types = new Class[]{Object.class, Object.class, Object.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class};

        TranHistoryModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return Object.class;
        }

        public void refresh() {
            super.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return Trans.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return Trans.this.rows == null ? 0 : Trans.this.rows.size();
        }

        @Override
        public String getColumnName(int col) {
            return Trans.this.columnNames[col];
        }

        @Override
        public Object getValueAt(int nRow, int nCol) {
            if (nRow < 0 || nRow >= this.getRowCount()) {
                return "";
            }
            TransHistoryBean row = Trans.this.rows.elementAt(nRow);
            switch (nCol) {
                case 0: {
                    return row.UIN;
                }
                case 1: {
                    return row.Symbol;
                }
                case 2: {
                    return row.TradeDate;
                }
                case 3: {
                    return row.SettleDate;
                }
                case 4: {
                    return row.Pur_Quantity;
                }
                case 5: {
                    return row.Pur_Rate;
                }
                case 6: {
                    return row.Pur_RateAfterComm;
                }
                case 7: {
                    return row.Pur_Amount;
                }
                case 8: {
                    return row.Pur_AmountAfterComm;
                }
                case 9: {
                    return row.Sel_Quantity;
                }
                case 10: {
                    return row.Sel_Rate;
                }
                case 11: {
                    return row.Sel_RateAfterComm;
                }
                case 12: {
                    return row.Sel_Amount;
                }
                case 13: {
                    return row.Sel_AmountAfterComm;
                }
            }
            return row;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        public void redraw() {
            this.fireTableStructureChanged();
        }

        public void DefualtSort() {
            this.refresh();
        }
    }

    class TranHistoryRender
    extends DefaultTableCellRenderer {
        TranHistoryRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel cell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setForeground(Color.BLACK);
            cell.setFont(AppConfig.defaultPlanFont);
            if (value == null) {
                value = "";
            }
            if (row % 2 == 0) {
                cell.setBackground(MyColors.cellRenderEven);
            } else {
                cell.setBackground(MyColors.cellRenderOdd);
            }
            if (column == 0) {
                cell.setText(" " + value.toString().trim() + " ");
                cell.setHorizontalAlignment(2);
            } else if (column == 1) {
                cell.setText(" " + value.toString().trim() + " ");
                cell.setHorizontalAlignment(2);
            } else if (column == 2) {
                cell.setText(" " + value + " ");
                cell.setHorizontalAlignment(2);
            } else if (column == 3) {
                cell.setText(" " + Util.format0digit((String)value.toString().trim()) + " ");
                cell.setHorizontalAlignment(2);
            } else if (column == 4) {
                cell.setText(" " + Util.format0digit((String)value.toString().trim()) + " ");
                cell.setHorizontalAlignment(4);
            } else if (column == 5) {
                cell.setText(" " + Util.format4digit((String)value.toString().trim()) + " ");
                cell.setHorizontalAlignment(4);
            } else if (column == 6) {
                cell.setText(" " + Util.format4digit((String)value.toString().trim()) + " ");
                cell.setHorizontalAlignment(4);
            } else if (column == 7) {
                cell.setText(" " + Util.format4digit((String)value.toString().trim()) + " ");
                cell.setHorizontalAlignment(4);
            } else if (column == 8) {
                cell.setText(" " + Util.format4digit((String)value.toString().trim()) + " ");
                cell.setHorizontalAlignment(4);
            } else if (column == 9) {
                cell.setText(" " + Util.format0digit((String)value.toString().trim()) + " ");
                cell.setHorizontalAlignment(4);
            } else if (column == 10) {
                cell.setText(" " + Util.format4digit((String)value.toString().trim()) + " ");
                cell.setHorizontalAlignment(4);
            } else if (column == 11) {
                cell.setText(" " + Util.format4digit((String)value.toString().trim()) + " ");
                cell.setHorizontalAlignment(4);
            } else if (column == 12) {
                cell.setText(" " + Util.format4digit((String)value.toString().trim()) + " ");
                cell.setHorizontalAlignment(4);
            } else if (column == 13) {
                cell.setText(" " + Util.format4digit((String)value.toString().trim()) + " ");
                cell.setHorizontalAlignment(4);
            }
            if (table.getValueAt(row, 2).toString().equalsIgnoreCase("Profit / Loss")) {
                if (column == 3) {
                    double dd = 0.0;
                    try {
                        dd = Double.parseDouble(value.toString().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (dd < 0.0) {
                        cell.setText(" (" + Util.format0digit((String)((dd *= -1.0) + "")) + ") ");
                        cell.setForeground(Trans.this.redColor);
                    } else {
                        cell.setText(" " + Util.format0digit((String)value.toString().trim()) + " ");
                        cell.setForeground(Trans.this.greenColor);
                    }
                    cell.setHorizontalAlignment(4);
                } else {
                    cell.setForeground(Color.WHITE);
                }
                cell.setBackground(Color.GRAY.darker());
                cell.setFont(cell.getFont().deriveFont(1));
            } else {
                cell.setForeground(Color.BLACK);
            }
            if (isSelected) {
                cell.setBackground(MyColors.SelectionFG);
            }
            return cell;
        }
    }
}

