/*
 * Decompiled with CFR 0.152.
 */
package Screener;

import Beans.StatementBean;
import BeansContainer.StatementContainer;
import BeansContainer.YearContainer;
import Control.JasperFileChooser;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.FinancialStatementModel;
import RendersNModels.StatementTableCellRender;
import RendersNModels.TableHeaderRenderer;
import Screener.FinancialStatement;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import com.google.gson.Gson;
import common.gui.component.NxGScrollBarUI;
import common.gui.util.AppConfig;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import languages.LanguageCentre;
import languages.LanguageConstant;
import reports.DynamicStatementReport;
import reports.Jasper_Statement;

public class AnnualStatement
extends JPanel
implements ReportControlListener {
    FinancialStatementModel model = null;
    Vector<String> colVector = new Vector();
    Vector<Vector<String>> rowVector = new Vector();
    private AutoCompleteSupport autoCompleteScrip;
    Mediator mediator = Mediator.getInstance();
    public String symbol;
    public String statement;
    private final FinancialStatement financialStatement;
    StatementTableCellRender render = new StatementTableCellRender();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JLabel lblMsg;
    private JPanel pnl;
    private JScrollPane scrollPane;
    private JTable table;

    public AnnualStatement(FinancialStatement container) {
        this.initComponents();
        this.financialStatement = container;
        Border b = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        Border pnlborder = BorderFactory.createLineBorder(Color.DARK_GRAY, 1);
        this.model = new FinancialStatementModel((Vector)this.rowVector, (Vector)this.colVector);
        this.table.setModel(this.model);
        this.table.getTableHeader().setDefaultRenderer(new TableHeaderRenderer(this.table));
        this.scrollPane.setBorder(b);
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        JScrollBar vbar = this.scrollPane.getVerticalScrollBar();
        NxGScrollBarUI ui2 = new NxGScrollBarUI();
        ui2.setMyScrollBarUI(vbar);
        vbar.setPreferredSize(new Dimension(7, 0));
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    private String getStatement() {
        return this.statement;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    private String getSymbol() {
        return this.symbol;
    }

    private void initComponents() {
        this.pnl = new JPanel();
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.lblMsg = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.pnl.setBackground(new Color(255, 255, 255));
        this.pnl.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaptionBorder));
        this.table.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.table.setSelectionForeground(new Color(0, 0, 0));
        this.table.getTableHeader().setResizingAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.scrollPane.setViewportView(this.table);
        GroupLayout pnlLayout = new GroupLayout(this.pnl);
        this.pnl.setLayout(pnlLayout);
        pnlLayout.setHorizontalGroup(pnlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane));
        pnlLayout.setVerticalGroup(pnlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 241, Short.MAX_VALUE));
        this.lblMsg.setFont(new Font("Tahoma", 1, 11));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblMsg, -1, 560, Short.MAX_VALUE).addGap(2, 2, 2)).addComponent(this.pnl, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnl, -1, -1, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.lblMsg, -2, 20, -2)));
    }

    public void getData() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (AnnualStatement.this.getSymbol() != null && AnnualStatement.this.getStatement() != null) {
                    Util.setMessage((JLabel)AnnualStatement.this.lblMsg, (MessageType)MessageType.Loading, (String)AnnualStatement.this.languageCentre.getValue(LanguageConstant.Loading));
                    AnnualStatement.this.setWindowHight(false);
                    AnnualStatement.this.callReport();
                    AnnualStatement.this.setWindowHight(true);
                }
            }
        }, "Scrip Detial AnnualStatement getdata").start();
    }

    private void setWindowHight(boolean isDataLoaded) {
        if (isDataLoaded) {
            Dimension n = new Dimension(0, this.table.getRowCount() * this.table.getRowHeight());
            this.setPreferredSize(n);
            int hight = (int)n.getHeight() + 107;
            this.financialStatement.setPreferredSize(new Dimension(0, hight));
        } else {
            Dimension n = new Dimension(0, 0);
            this.setPreferredSize(n);
            int hight = (int)n.getHeight() + 107;
            this.financialStatement.setPreferredSize(new Dimension(0, hight));
        }
    }

    public void callReport() {
        Gson gson = new Gson();
        try {
            String inputLine;
            this.rowVector.clear();
            this.colVector.clear();
            this.model.setColumnCount(0);
            this.tableDataChange();
            String type = "Statement";
            String scrip = this.getSymbol();
            String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/DataServiceServlet?service=" + type + "&scrip=" + scrip + "&market=" + this.getStatement();
            StringBuilder sb = new StringBuilder();
            URL url = new URL(call);
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine);
            }
            in.close();
            this.mediator.println("Annual Statement Call = " + call);
            this.mediator.println("Annual Statement HTML = " + sb.toString());
            String val = sb.toString();
            if (val.length() > 0) {
                StatementContainer statementCont = (StatementContainer)gson.fromJson(val, StatementContainer.class);
                if (statementCont.list.size() > 0) {
                    this.DisplayData(statementCont);
                } else {
                    Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)"No record found");
                }
            } else {
                Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)"No record found");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaint();
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnnualStatement.this.repaint();
                    AnnualStatement.this.model.fireTableDataChanged();
                    AnnualStatement.this.table.addNotify();
                    AnnualStatement.this.table.repaint();
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private void DisplayData(StatementContainer statementContainer) {
        List list = statementContainer.list;
        if (list.size() > 0) {
            void var9_17;
            void var9_15;
            TreeMap groupIndex = statementContainer.groupIndex;
            Map groupFileds = statementContainer.groupFileds;
            if (list.size() > 0) {
                this.colVector.addElement(" ");
            }
            String space = "";
            List allYear = statementContainer.list;
            for (int j = 0; j < allYear.size(); ++j) {
                YearContainer con = (YearContainer)allYear.get(j);
                if (con.list.size() <= 0) continue;
                StatementBean statementBean = (StatementBean)con.list.get(0);
                this.colVector.addElement(statementBean.year + space);
                space = space + " ";
            }
            ArrayList all = new ArrayList();
            for (Map.Entry entry : groupIndex.entrySet()) {
                all.add(entry.getValue());
            }
            Collections.sort(all);
            int loop = (Integer)all.get(all.size() - 1);
            boolean bl = false;
            while (var9_15 <= loop) {
                for (Map.Entry entry : groupIndex.entrySet()) {
                    Vector<String> rowVal;
                    String group = (String)entry.getKey();
                    Integer integer = (Integer)entry.getValue();
                    if (integer.intValue() != var9_15 || !groupFileds.containsKey(integer)) continue;
                    this.addGroupRow("<html> <font size = '3' color='" + MyColors.StatementHeadingColor + "'>&nbsp;&nbsp;<b>" + group + "</b></font></html>");
                    ArrayList fielddList = (ArrayList)groupFileds.get(integer);
                    for (int i = 0; i < fielddList.size(); ++i) {
                        String field = (String)fielddList.get(i);
                        Vector<String> rowValues = new Vector<String>(4);
                        rowValues.add("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font size = '3'>" + field + "</font></html>");
                        double tempVal = 0.0;
                        for (int j = 0; j < list.size(); ++j) {
                            YearContainer yearContainer = (YearContainer)list.get(j);
                            for (int k = 0; k < yearContainer.list.size(); ++k) {
                                StatementBean statementBean = (StatementBean)yearContainer.list.get(k);
                                if (!statementBean.field.equalsIgnoreCase(field)) continue;
                                try {
                                    tempVal += Double.parseDouble(statementBean.value);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                rowValues.add("<html><font size = '3'>" + Util.format2digit((String)statementBean.value) + "&nbsp;</font></html>");
                            }
                        }
                        if (tempVal != 0.0) {
                            this.rowVector.add(rowValues);
                        }
                        tempVal = 0.0;
                    }
                    if (this.rowVector.size() <= 0 || (rowVal = this.rowVector.get(this.rowVector.size() - 1)).get(0).indexOf("<html> <font size = '3' color='") != 0) continue;
                    this.rowVector.remove(this.rowVector.size() - 1);
                }
                ++var9_15;
            }
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)this.mediator.getSymbolTitle(this.getSymbol()));
            this.model.setDataVector(this.rowVector, this.colVector);
            this.table.setModel(this.model);
            boolean bl2 = false;
            while (var9_17 < this.colVector.size()) {
                this.table.getColumn(this.colVector.elementAt((int)var9_17)).setCellRenderer(this.render);
                ++var9_17;
            }
            this.table.getColumn(this.table.getColumnName(0)).setPreferredWidth(220);
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)this.mediator.getSymbolTitle(this.getSymbol()));
        } else {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)"No record found");
        }
        this.tableDataChange();
    }

    private void addGroupRow(String group) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.colVector.size(); ++i) {
            if (i == 0) {
                v.add(group);
                continue;
            }
            v.add("");
        }
        this.rowVector.add(v);
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Jasper_Statement.Statement = this.getStatement();
        Jasper_Statement.Symbol = this.mediator.getSymbolTitle(this.getSymbol());
        DynamicStatementReport dynamic = new DynamicStatementReport("Statement.jrxml", this.table.getModel());
        if (!dynamic.isHasPage()) {
            return;
        }
        dynamic.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Jasper_Statement.Statement = this.getStatement();
        Jasper_Statement.Symbol = this.mediator.getSymbolTitle(this.getSymbol());
        DynamicStatementReport dynamic = new DynamicStatementReport("Statement.jrxml", this.table.getModel());
        if (!dynamic.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Statement-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = dynamic.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        Jasper_Statement.Statement = this.getStatement();
        Jasper_Statement.Symbol = this.mediator.getSymbolTitle(this.getSymbol());
        DynamicStatementReport dynamic = new DynamicStatementReport("Statement.jrxml", this.table.getModel());
        if (!dynamic.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Statement-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null) {
            String FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion();
            boolean result = dynamic.ExportToPdf(FileName);
            if (result) {
                int Option = JOptionPane.showConfirmDialog(null, "Statement report created. Do you want to open it?", "PDF", 0);
                if (Option == 0) {
                    try {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                JOptionPane.showMessageDialog(null, "Error in creating pdf file.");
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Jasper_Statement.Statement = this.getStatement();
        Jasper_Statement.Symbol = this.mediator.getSymbolTitle(this.getSymbol());
        DynamicStatementReport dynamic = new DynamicStatementReport("Statement.jrxml", this.table.getModel());
        if (!dynamic.isHasPage()) {
            return;
        }
        dynamic.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
    }
}

