/*
 * Decompiled with CFR 0.152.
 */
package Screener;

import Beans.StatementBean;
import BeansContainer.StatementContainer;
import BeansContainer.YearContainer;
import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.FinancialStatementModel;
import RendersNModels.StatementTableCellRender;
import RendersNModels.TableHeaderRenderer;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import com.google.gson.Gson;
import common.gui.component.NxGLabelGradeint;
import common.gui.component.NxGScrollBarUI;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Title;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXImagePanel;
import org.jdesktop.swingx.JXLabel;
import reports.DynamicStatementReport;
import reports.Jasper_Statement;

public class AnnualStatement_Single
extends JPanel
implements ReportControlListener {
    FinancialStatementModel model = null;
    Vector<String> colVector = new Vector();
    Vector<Vector<String>> rowVector = new Vector();
    private AutoCompleteSupport autoCompleteScrip;
    Mediator mediator = Mediator.getInstance();
    boolean isDataLoading = false;
    private Color selectedTextColor = Util.convertToColor((String)MyColors.StatementHeadingColor, (Color)Color.BLUE);
    private Color disableTextColor = Color.darkGray;
    private final Color selectedTab = new Color(201, 211, 227);
    private final Color disbaleTab = new Color(230, 230, 230);
    private String statement = "CF";
    StatementTableCellRender render = new StatementTableCellRender();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JComboBox cmbSymbol;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JLabel lblBalanceStatement;
    private JLabel lblCashFlow;
    private JXLabel lblDescription;
    private JLabel lblDisclaimer;
    private JLabel lblIncomeStatement;
    private JXImagePanel lblLogo;
    private JLabel lblMsg;
    private JLabel lblScripBrowse;
    private JLabel lblScripDetails;
    private JLabel lblSrch;
    private JLabel lblSymbol;
    private JLabel lblSymbolName;
    private JPanel pnl;
    private ReportControl reportControl1;
    private JTable table;

    public AnnualStatement_Single() {
        this.initComponents();
        this.reportControl1.setVisible(false);
        Border b = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        Border pnlborder = BorderFactory.createLineBorder(Color.DARK_GRAY, 1);
        this.reportControl1.addListener(this);
        this.reportControl1.ShowCustomExportButton();
        this.model = new FinancialStatementModel((Vector)this.rowVector, (Vector)this.colVector);
        this.table.setModel(this.model);
        this.table.getTableHeader().setDefaultRenderer(new TableHeaderRenderer(this.table));
        this.setAllScrip();
        this.jScrollPane1.setBorder(b);
        this.jScrollPane1.setHorizontalScrollBarPolicy(30);
        this.jScrollPane1.setVerticalScrollBarPolicy(20);
        JScrollBar vbar = this.jScrollPane1.getVerticalScrollBar();
        NxGScrollBarUI ui2 = new NxGScrollBarUI();
        ui2.setMyScrollBarUI(vbar);
        vbar.setPreferredSize(new Dimension(7, 0));
        this.table.setSelectionMode(0);
        this.table.setSelectionBackground(MyColors.MarketWatchSelectedRowColor);
        this.cmbSymbol.setMaximumRowCount(30);
        String mktSymbol = UtilKSE.GetMarketFromsymbol((String)LogsKSE.SelectedSymbol);
        if (mktSymbol.equalsIgnoreCase("FUT") || mktSymbol.equalsIgnoreCase("IPO")) {
            if (LogsKSE.SelectedSymbol.indexOf("-") > 0) {
                this.cmbSymbol.setSelectedItem(LogsKSE.SelectedSymbol.split("\\-", -1)[0]);
            }
        } else {
            this.cmbSymbol.setSelectedItem(LogsKSE.SelectedSymbol);
        }
        this.lblScripBrowse.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
        this.lblScripBrowse.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AnnualStatement_Single.this.mediator.tradecast.ShowDynamicForm(FormName.ScripBrowse, LanguageConstant.ScripBrowse);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                AnnualStatement_Single.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(12));
                AnnualStatement_Single.this.lblScripBrowse.setText("<html><u><b>" + AnnualStatement_Single.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AnnualStatement_Single.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(0));
                AnnualStatement_Single.this.lblScripBrowse.setText("<html><b>" + AnnualStatement_Single.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
            }
        });
        this.lblScripDetails.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/scripDetail.png")));
        this.lblScripDetails.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripDetail) + "</b></html>");
        this.lblScripDetails.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AnnualStatement_Single.this.mediator.openScripDetails(AnnualStatement_Single.this.cmbSymbol.getSelectedItem().toString());
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                AnnualStatement_Single.this.lblScripDetails.setCursor(Cursor.getPredefinedCursor(12));
                AnnualStatement_Single.this.lblScripDetails.setText("<html><u><b>" + AnnualStatement_Single.this.languageCentre.getValue(LanguageConstant.ScripDetail) + "</b></u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AnnualStatement_Single.this.lblScripDetails.setCursor(Cursor.getPredefinedCursor(0));
                AnnualStatement_Single.this.lblScripDetails.setText("<html><b>" + AnnualStatement_Single.this.languageCentre.getValue(LanguageConstant.ScripDetail) + "</b></html>");
            }
        });
        this.lblDisclaimer.setText("<html><b>" + Title.Disclaimer + "</b></html>");
        this.lblDisclaimer.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AnnualStatement_Single.this.mediator.OpenDisclimerWindow();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                AnnualStatement_Single.this.lblDisclaimer.setCursor(Cursor.getPredefinedCursor(12));
                AnnualStatement_Single.this.lblDisclaimer.setText("<html><u><b>" + Title.Disclaimer + "</b></u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AnnualStatement_Single.this.lblDisclaimer.setCursor(Cursor.getPredefinedCursor(0));
                AnnualStatement_Single.this.lblDisclaimer.setText("<html><b>" + Title.Disclaimer + "</b></html>");
            }
        });
        this.cashFlowStatement();
        this.scripChanged();
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.lblMsg = new JLabel();
        this.reportControl1 = new ReportControl();
        this.pnl = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.lblIncomeStatement = new NxGLabelGradeint();
        this.lblBalanceStatement = new NxGLabelGradeint();
        this.lblCashFlow = new NxGLabelGradeint();
        this.jPanel2 = new JPanel();
        this.lblSymbol = new JLabel();
        this.jLabel3 = new JLabel();
        this.lblSymbolName = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.cmbSymbol = new JComboBox();
        this.lblDescription = new JXLabel();
        this.lblScripBrowse = new JLabel();
        this.lblSrch = new JLabel();
        this.lblLogo = new JXImagePanel();
        this.lblScripDetails = new JLabel();
        this.lblDisclaimer = new JLabel();
        this.lblMsg.setFont(new Font("Tahoma", 1, 11));
        this.pnl.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaptionBorder));
        this.table.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.table.setSelectionForeground(new Color(0, 0, 0));
        this.table.getTableHeader().setResizingAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout pnlLayout = new GroupLayout(this.pnl);
        this.pnl.setLayout(pnlLayout);
        pnlLayout.setHorizontalGroup(pnlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
        pnlLayout.setVerticalGroup(pnlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 118, Short.MAX_VALUE));
        this.lblIncomeStatement.setHorizontalAlignment(0);
        this.lblIncomeStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/IncomeStatement32.png")));
        this.lblIncomeStatement.setText("Income Statement");
        this.lblIncomeStatement.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.lblIncomeStatement.setIconTextGap(15);
        this.lblIncomeStatement.setPreferredSize(new Dimension(260, 57));
        this.lblIncomeStatement.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnnualStatement_Single.this.lblIncomeStatementMousePressed(evt);
            }
        });
        this.lblBalanceStatement.setHorizontalAlignment(0);
        this.lblBalanceStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/BalanceSheet32.png")));
        this.lblBalanceStatement.setText("Balance Sheet");
        this.lblBalanceStatement.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.lblBalanceStatement.setIconTextGap(15);
        this.lblBalanceStatement.setPreferredSize(new Dimension(260, 57));
        this.lblBalanceStatement.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnnualStatement_Single.this.lblBalanceStatementMousePressed(evt);
            }
        });
        this.lblCashFlow.setHorizontalAlignment(0);
        this.lblCashFlow.setIcon(new ImageIcon(this.getClass().getResource("/Images/CashFlow32.png")));
        this.lblCashFlow.setText("Cash Flow");
        this.lblCashFlow.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.lblCashFlow.setIconTextGap(15);
        this.lblCashFlow.setPreferredSize(new Dimension(260, 57));
        this.lblCashFlow.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnnualStatement_Single.this.lblCashFlowMousePressed(evt);
            }
        });
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.lblSymbol.setFont(new Font("Tahoma", 1, 14));
        this.lblSymbol.setHorizontalAlignment(0);
        this.lblSymbol.setText(" ");
        this.lblSymbol.setHorizontalTextPosition(0);
        this.jLabel3.setBackground(new Color(153, 153, 153));
        this.jLabel3.setOpaque(true);
        this.lblSymbolName.setFont(new Font("Tahoma", 1, 14));
        this.lblSymbolName.setText(" ");
        this.jSeparator3.setOrientation(1);
        this.cmbSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnualStatement_Single.this.cmbSymbolActionPerformed(evt);
            }
        });
        this.lblDescription.setLineWrap(true);
        this.lblDescription.setText(" ");
        this.lblDescription.setVerticalAlignment(1);
        this.lblDescription.setVerticalTextPosition(1);
        this.lblScripBrowse.setIcon(new ImageIcon(this.getClass().getResource("/Images/symDetail2.png")));
        this.lblScripBrowse.setText("Scrip Browse");
        this.lblSrch.setHorizontalAlignment(2);
        this.lblSrch.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.lblSrch.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AnnualStatement_Single.this.lblSrchMousePressed(evt);
            }
        });
        this.lblLogo.setBackground(new Color(255, 255, 255));
        this.lblLogo.setPreferredSize(new Dimension(65, 65));
        GroupLayout lblLogoLayout = new GroupLayout((Container)this.lblLogo);
        this.lblLogo.setLayout((LayoutManager)lblLogoLayout);
        lblLogoLayout.setHorizontalGroup(lblLogoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 110, Short.MAX_VALUE));
        lblLogoLayout.setVerticalGroup(lblLogoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 80, Short.MAX_VALUE));
        this.lblScripDetails.setIcon(new ImageIcon(this.getClass().getResource("/Images/symDetail2.png")));
        this.lblScripDetails.setText("Scrip Browse");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(5, 5, 5).addComponent((Component)this.lblLogo, -2, 110, -2).addGap(5, 5, 5).addComponent(this.jSeparator3, -2, -1, -2).addGap(8, 8, 8).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.lblSymbol, -2, 70, -2).addGap(5, 5, 5).addComponent(this.jLabel3, -2, 1, -2).addGap(9, 9, 9).addComponent(this.lblSymbolName, -1, -1, Short.MAX_VALUE).addGap(30, 30, 30)).addComponent(this.jSeparator2).addComponent((Component)this.lblDescription, -1, -1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.cmbSymbol, -2, 80, -2).addGap(5, 5, 5).addComponent(this.lblSrch, -2, 20, -2)).addComponent(this.lblScripBrowse, -2, 100, -2)).addGap(5, 5, 5)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblScripDetails, -2, 100, -2).addContainerGap()))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(5, 5, 5).addComponent((Component)this.lblLogo, -2, 80, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jSeparator3, -2, 70, -2)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGap(17, 17, 17).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbSymbol, -2, -1, -2).addComponent(this.lblSrch, -2, 20, -2)).addGap(8, 8, 8).addComponent(this.lblScripBrowse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblScripDetails)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSymbol).addGroup(jPanel2Layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jLabel3, -2, 15, -2)).addComponent(this.lblSymbolName)).addGap(6, 6, 6).addComponent(this.jSeparator2, -2, -1, -2).addGap(5, 5, 5).addComponent((Component)this.lblDescription, -2, 45, -2))));
        this.lblDisclaimer.setIcon(new ImageIcon(this.getClass().getResource("/Images/disclaimer.png")));
        this.lblDisclaimer.setText(" Disclaimer");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblMsg, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reportControl1, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblDisclaimer, -2, 80, -2)).addComponent(this.pnl, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.lblCashFlow, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.lblIncomeStatement, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.lblBalanceStatement, -2, 0, Short.MAX_VALUE)).addComponent(this.jSeparator1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCashFlow, -2, 25, -2).addComponent(this.lblIncomeStatement, -2, 25, -2).addComponent(this.lblBalanceStatement, -2, 25, -2)).addGap(5, 5, 5).addComponent(this.pnl, -1, -1, Short.MAX_VALUE).addGap(5, 5, 5).addComponent(this.jSeparator1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblMsg, -1, 20, Short.MAX_VALUE).addComponent(this.lblDisclaimer, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reportControl1, -2, 10, -2)))));
    }

    private void cmbSymbolActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            this.scripChanged();
        }
    }

    private void lblSrchMousePressed(MouseEvent evt) {
        this.scripChanged();
    }

    private void lblIncomeStatementMousePressed(MouseEvent evt) {
        this.incomeStatement();
    }

    private void lblBalanceStatementMousePressed(MouseEvent evt) {
        this.balanceSheet();
    }

    private void lblCashFlowMousePressed(MouseEvent evt) {
        this.cashFlowStatement();
    }

    private void getData() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!AnnualStatement_Single.this.isDataLoading) {
                    AnnualStatement_Single.this.isDataLoading = true;
                    AnnualStatement_Single.this.setDisable(AnnualStatement_Single.this.isDataLoading);
                    Util.setMessage((JLabel)AnnualStatement_Single.this.lblMsg, (MessageType)MessageType.Loading, (String)AnnualStatement_Single.this.languageCentre.getValue(LanguageConstant.Loading));
                    AnnualStatement_Single.this.callReport();
                    AnnualStatement_Single.this.isDataLoading = false;
                    AnnualStatement_Single.this.setDisable(AnnualStatement_Single.this.isDataLoading);
                }
            }
        }, "AnnualStatement getdata").start();
    }

    private void setDisable(boolean dataLoading) {
        this.lblCashFlow.setEnabled(!dataLoading);
        this.lblBalanceStatement.setEnabled(!dataLoading);
        this.lblCashFlow.setEnabled(!dataLoading);
        this.cmbSymbol.setEnabled(!dataLoading);
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaint();
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnnualStatement_Single.this.repaint();
                    AnnualStatement_Single.this.model.fireTableDataChanged();
                    AnnualStatement_Single.this.table.addNotify();
                    AnnualStatement_Single.this.table.repaint();
                }
            });
        }
    }

    public void callReport() {
        Gson gson = new Gson();
        try {
            String inputLine;
            this.rowVector.clear();
            this.colVector.clear();
            this.model.setColumnCount(0);
            this.tableDataChange();
            String type = "Statement";
            String scrip = this.cmbSymbol.getSelectedItem().toString();
            String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/DataServiceServlet?service=" + type + "&scrip=" + scrip + "&market=" + this.getStatement();
            StringBuilder sb = new StringBuilder();
            URL url = new URL(call);
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine);
            }
            in.close();
            this.mediator.println("Annual Statement Call = " + call);
            this.mediator.println("Annual Statement HTML = " + sb.toString());
            String val = sb.toString();
            if (val.length() > 0) {
                StatementContainer statementCont = (StatementContainer)gson.fromJson(val, StatementContainer.class);
                if (statementCont.list.size() > 0) {
                    this.DisplayData(statementCont);
                } else {
                    Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)"No record found");
                }
            } else {
                Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)"No record found");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setAllScrip() {
        try {
            if (this.autoCompleteScrip != null && this.autoCompleteScrip.isInstalled()) {
                this.autoCompleteScrip.uninstall();
            }
            Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
            Vector<String> newScrip = new Vector<String>();
            for (int i = 0; i < allScrip.size(); ++i) {
                Object object = allScrip.elementAt(i);
                if (newScrip.contains(object.toString().split("\\-", -1)[0])) continue;
                newScrip.add(object.toString().split("\\-", -1)[0]);
            }
            Collections.sort(newScrip);
            this.cmbSymbol.setModel(new DefaultComboBoxModel(newScrip));
            this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)this.cmbSymbol, (EventList)GlazedLists.eventListOf((Object[])newScrip.toArray()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void DisplayData(StatementContainer statementContainer) {
        List list = statementContainer.list;
        if (list.size() > 0) {
            void var9_17;
            void var9_15;
            TreeMap groupIndex = statementContainer.groupIndex;
            Map groupFileds = statementContainer.groupFileds;
            if (list.size() > 0) {
                this.colVector.addElement(" ");
            }
            String space = "";
            List allYear = statementContainer.list;
            for (int j = 0; j < allYear.size(); ++j) {
                YearContainer con = (YearContainer)allYear.get(j);
                if (con.list.size() <= 0) continue;
                StatementBean statementBean = (StatementBean)con.list.get(0);
                this.colVector.addElement(statementBean.year + space);
                space = space + " ";
            }
            ArrayList all = new ArrayList();
            for (Map.Entry entry : groupIndex.entrySet()) {
                all.add(entry.getValue());
            }
            Collections.sort(all);
            int loop = (Integer)all.get(all.size() - 1);
            boolean bl = false;
            while (var9_15 <= loop) {
                for (Map.Entry entry : groupIndex.entrySet()) {
                    Vector<String> rowVal;
                    String group = (String)entry.getKey();
                    Integer integer = (Integer)entry.getValue();
                    if (integer.intValue() != var9_15 || !groupFileds.containsKey(integer)) continue;
                    this.addGroupRow("<html> <font size = '3' color='" + MyColors.StatementHeadingColor + "'>&nbsp;&nbsp;<b>" + group + "</b></font></html>");
                    ArrayList fielddList = (ArrayList)groupFileds.get(integer);
                    for (int i = 0; i < fielddList.size(); ++i) {
                        String field = (String)fielddList.get(i);
                        Vector<String> rowValues = new Vector<String>(4);
                        rowValues.add("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font size = '3'>" + field + "</font></html>");
                        double tempVal = 0.0;
                        for (int j = 0; j < list.size(); ++j) {
                            YearContainer yearContainer = (YearContainer)list.get(j);
                            for (int k = 0; k < yearContainer.list.size(); ++k) {
                                StatementBean statementBean = (StatementBean)yearContainer.list.get(k);
                                if (!statementBean.field.equalsIgnoreCase(field)) continue;
                                try {
                                    tempVal += Double.parseDouble(statementBean.value);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                rowValues.add("<html><font size = '3'>" + Util.format2digit((String)statementBean.value) + "&nbsp;</font></html>");
                            }
                        }
                        if (tempVal != 0.0) {
                            this.rowVector.add(rowValues);
                        }
                        tempVal = 0.0;
                    }
                    if (this.rowVector.size() <= 0 || (rowVal = this.rowVector.get(this.rowVector.size() - 1)).get(0).indexOf("<html> <font size = '3' color='") != 0) continue;
                    this.rowVector.remove(this.rowVector.size() - 1);
                }
                ++var9_15;
            }
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)this.mediator.getSymbolTitle(this.getSymbol()));
            this.model.setDataVector(this.rowVector, this.colVector);
            this.table.setModel(this.model);
            boolean bl2 = false;
            while (var9_17 < this.colVector.size()) {
                this.table.getColumn(this.colVector.elementAt((int)var9_17)).setCellRenderer(this.render);
                ++var9_17;
            }
            this.table.getColumn(this.table.getColumnName(0)).setPreferredWidth(220);
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)this.mediator.getSymbolTitle(this.getSymbol()));
        } else {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)"No record found");
        }
        this.tableDataChange();
    }

    private void addGroupRow(String group) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.colVector.size(); ++i) {
            if (i == 0) {
                v.add(group);
                continue;
            }
            v.add("");
        }
        this.rowVector.add(v);
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Jasper_Statement.Statement = this.statement;
        Jasper_Statement.Symbol = this.mediator.getSymbolTitle(this.cmbSymbol.getSelectedItem().toString());
        DynamicStatementReport dynamic = new DynamicStatementReport("Statement.jrxml", this.table.getModel());
        if (!dynamic.isHasPage()) {
            return;
        }
        dynamic.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Jasper_Statement.Statement = this.statement;
        Jasper_Statement.Symbol = this.mediator.getSymbolTitle(this.cmbSymbol.getSelectedItem().toString());
        DynamicStatementReport dynamic = new DynamicStatementReport("Statement.jrxml", this.table.getModel());
        if (!dynamic.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Statement-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = dynamic.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        Jasper_Statement.Statement = this.statement;
        Jasper_Statement.Symbol = this.mediator.getSymbolTitle(this.cmbSymbol.getSelectedItem().toString());
        DynamicStatementReport dynamic = new DynamicStatementReport("Statement.jrxml", this.table.getModel());
        if (!dynamic.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Statement-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null) {
            String FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion();
            boolean result = dynamic.ExportToPdf(FileName);
            if (result) {
                int Option = JOptionPane.showConfirmDialog(null, "Statement report created. Do you want to open it?", "PDF", 0);
                if (Option == 0) {
                    try {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                JOptionPane.showMessageDialog(null, "Error in creating pdf file.");
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Jasper_Statement.Statement = this.statement;
        Jasper_Statement.Symbol = this.mediator.getSymbolTitle(this.cmbSymbol.getSelectedItem().toString());
        DynamicStatementReport dynamic = new DynamicStatementReport("Statement.jrxml", this.table.getModel());
        if (!dynamic.isHasPage()) {
            return;
        }
        dynamic.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
    }

    private void scripChanged() {
        if (this.cmbSymbol.getSelectedItem().toString().trim().length() <= 0) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select scrip");
            this.cmbSymbol.requestFocus();
        } else {
            String symbol = this.cmbSymbol.getSelectedItem().toString();
            this.lblSymbol.setText(symbol);
            this.lblSymbol.setToolTipText(this.lblSymbol.getText());
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
            this.lblSymbolName.setToolTipText(this.lblSymbolName.getText());
            this.getData();
            this.setImages(symbol);
            this.setDescription(symbol);
        }
    }

    private void setImages(final String symbol) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/CompanyImages/" + symbol.toUpperCase() + ".GIF";
                    BufferedImage image = ImageUtil.downloadImage((String)call);
                    if (image != null) {
                        AnnualStatement_Single.this.lblLogo.setImage((Image)image);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void setDescription(final String symbol) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String inputLine;
                    String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/DataServiceServlet?service=ScripDescription&scrip=" + symbol;
                    StringBuilder sb = new StringBuilder();
                    URL url = new URL(call);
                    URLConnection yc = url.openConnection();
                    BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                    while ((inputLine = in.readLine()) != null) {
                        sb.append(inputLine);
                    }
                    in.close();
                    AnnualStatement_Single.this.lblDescription.setText(sb.toString());
                    AnnualStatement_Single.this.lblDescription.setToolTipText(AnnualStatement_Single.this.lblDescription.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void cashFlowStatement() {
        this.statement = "CF";
        this.lblCashFlow.setIcon(new ImageIcon(this.getClass().getResource("/Images/CashFlow32.png")));
        this.lblIncomeStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/IncomeStatementDisable32.png")));
        this.lblBalanceStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/BalanceSheetDisable32.png")));
        this.lblCashFlow.setForeground(this.selectedTextColor);
        this.lblIncomeStatement.setForeground(this.disableTextColor);
        this.lblBalanceStatement.setForeground(this.disableTextColor);
        ((NxGLabelGradeint)this.lblCashFlow).setGradient(this.selectedTab, this.selectedTab.brighter());
        ((NxGLabelGradeint)this.lblIncomeStatement).setGradient(this.disbaleTab, this.disbaleTab.brighter());
        ((NxGLabelGradeint)this.lblBalanceStatement).setGradient(this.disbaleTab, this.disbaleTab.brighter());
        this.scripChanged();
    }

    private void incomeStatement() {
        this.statement = "IS";
        this.lblCashFlow.setIcon(new ImageIcon(this.getClass().getResource("/Images/CashFlowDisable32.png")));
        this.lblIncomeStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/IncomeStatement32.png")));
        this.lblBalanceStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/BalanceSheetDisable32.png")));
        this.lblCashFlow.setForeground(this.disableTextColor);
        this.lblIncomeStatement.setForeground(this.selectedTextColor);
        this.lblBalanceStatement.setForeground(this.disableTextColor);
        ((NxGLabelGradeint)this.lblCashFlow).setGradient(this.disbaleTab, this.disbaleTab.brighter());
        ((NxGLabelGradeint)this.lblIncomeStatement).setGradient(this.selectedTab, this.selectedTab.brighter());
        ((NxGLabelGradeint)this.lblBalanceStatement).setGradient(this.disbaleTab, this.disbaleTab.brighter());
        this.scripChanged();
    }

    private void balanceSheet() {
        this.statement = "BS";
        this.lblCashFlow.setIcon(new ImageIcon(this.getClass().getResource("/Images/CashFlowDisable32.png")));
        this.lblIncomeStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/IncomeStatementDisable32.png")));
        this.lblBalanceStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/BalanceSheet32.png")));
        this.lblCashFlow.setForeground(this.disableTextColor);
        this.lblIncomeStatement.setForeground(this.disableTextColor);
        this.lblBalanceStatement.setForeground(this.selectedTextColor);
        ((NxGLabelGradeint)this.lblCashFlow).setGradient(this.disbaleTab, this.disbaleTab.brighter());
        ((NxGLabelGradeint)this.lblIncomeStatement).setGradient(this.disbaleTab, this.disbaleTab.brighter());
        ((NxGLabelGradeint)this.lblBalanceStatement).setGradient(this.selectedTab, this.selectedTab.brighter());
        this.scripChanged();
    }

    private String getStatement() {
        return this.statement;
    }

    private String getSymbol() {
        return this.cmbSymbol.getSelectedItem().toString();
    }
}

