/*
 * Decompiled with CFR 0.152.
 */
package Screener;

import MyDocking.Mediator;
import MyDocking.TradeCast;
import Screener.ScriptDetails;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXImagePanel;
import org.jdesktop.swingx.JXLabel;

public class CompanyHeader
extends JPanel {
    private AutoCompleteSupport autoCompleteScrip;
    Mediator mediator = Mediator.getInstance();
    ScriptDetails scriptDetails = null;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JComboBox cmbSymbol;
    private JLabel jLabel1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JXLabel lblDescription;
    private JLabel lblDetailQuote;
    private JXImagePanel lblLogo;
    private JLabel lblScripBrowse;
    private JLabel lblSrch;
    private JLabel lblSymbol;
    private JLabel lblSymbolName;

    public CompanyHeader(ScriptDetails scriptDetails) {
        this.initComponents();
        this.mediator.setCompanyHeader(this);
        this.setBounds(0, 0, 800, 75);
        this.setPreferredSize(new Dimension(800, 75));
        this.scriptDetails = scriptDetails;
        this.setAllScrip();
        this.cmbSymbol.setMaximumRowCount(30);
        String mktSymbol = UtilKSE.GetMarketFromsymbol((String)LogsKSE.SelectedSymbol);
        if (mktSymbol.equalsIgnoreCase("FUT") || mktSymbol.equalsIgnoreCase("IPO")) {
            if (LogsKSE.SelectedSymbol.indexOf("-") > 0) {
                this.cmbSymbol.setSelectedItem(LogsKSE.SelectedSymbol.split("\\-", -1)[0]);
            }
        } else {
            this.cmbSymbol.setSelectedItem(LogsKSE.SelectedSymbol);
        }
        this.setSymbol(this.cmbSymbol.getSelectedItem().toString());
        scriptDetails.setSymbol(this.cmbSymbol.getSelectedItem().toString());
        this.lblScripBrowse.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
        this.lblScripBrowse.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CompanyHeader.this.mediator.tradecast.ShowDynamicForm(FormName.ScripBrowse, LanguageConstant.ScripBrowse);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CompanyHeader.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(12));
                CompanyHeader.this.lblScripBrowse.setText("<html><u><b>" + CompanyHeader.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CompanyHeader.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(0));
                CompanyHeader.this.lblScripBrowse.setText("<html><b>" + CompanyHeader.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
            }
        });
        this.lblDetailQuote.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.DetailedQuote) + "</b></html>");
        this.lblDetailQuote.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TradeCast.getInstance().ShowDynamicForm(FormName.DetailedQuote, LanguageConstant.DetailedQuote);
                CompanyHeader.this.mediator.detailedQuote.AddSymbol(UtilKSE.GetMarketFromsymbol((String)CompanyHeader.this.cmbSymbol.getSelectedItem().toString()), CompanyHeader.this.cmbSymbol.getSelectedItem().toString());
                CompanyHeader.this.mediator.detailedQuote.setTitle("");
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CompanyHeader.this.lblDetailQuote.setCursor(Cursor.getPredefinedCursor(12));
                CompanyHeader.this.lblDetailQuote.setText("<html><u><b>" + CompanyHeader.this.languageCentre.getValue(LanguageConstant.DetailedQuote) + "</b></u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CompanyHeader.this.lblDetailQuote.setCursor(Cursor.getPredefinedCursor(0));
                CompanyHeader.this.lblDetailQuote.setText("<html><b>" + CompanyHeader.this.languageCentre.getValue(LanguageConstant.DetailedQuote) + "</b></html>");
            }
        });
    }

    public void setSymbol(String symbol) {
        this.lblSymbol.setText(symbol);
        this.lblSymbol.setToolTipText(this.lblSymbol.getText());
        this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        this.lblSymbolName.setToolTipText(this.lblSymbolName.getText());
        this.lblLogo.setImage(null);
        this.lblDescription.setText("");
        this.lblDescription.setToolTipText(null);
        this.setImages(symbol);
        this.setDescription(symbol);
    }

    public void setAllScrip() {
        try {
            if (this.autoCompleteScrip != null && this.autoCompleteScrip.isInstalled()) {
                this.autoCompleteScrip.uninstall();
            }
            Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
            Vector<String> newScrip = new Vector<String>();
            for (int i = 0; i < allScrip.size(); ++i) {
                Object object = allScrip.elementAt(i);
                if (newScrip.contains(object.toString().split("\\-", -1)[0])) continue;
                newScrip.add(object.toString().split("\\-", -1)[0]);
            }
            Collections.sort(newScrip);
            this.cmbSymbol.setModel(new DefaultComboBoxModel(newScrip));
            this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)this.cmbSymbol, (EventList)GlazedLists.eventListOf((Object[])newScrip.toArray()));
            this.autoCompleteScrip.setStrict(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setScripBrowse(String scrip) {
        this.cmbSymbol.setSelectedItem(scrip);
        this.scriptDetails.setSymbol(this.cmbSymbol.getSelectedItem().toString());
        this.setSymbol(this.cmbSymbol.getSelectedItem().toString());
    }

    private void initComponents() {
        this.lblSymbol = new JLabel();
        this.jLabel1 = new JLabel();
        this.lblSymbolName = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.cmbSymbol = new JComboBox();
        this.lblDescription = new JXLabel();
        this.lblScripBrowse = new JLabel();
        this.lblSrch = new JLabel();
        this.lblLogo = new JXImagePanel();
        this.lblDetailQuote = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.lblSymbol.setFont(new Font("Tahoma", 1, 14));
        this.lblSymbol.setHorizontalAlignment(0);
        this.lblSymbol.setText(" ");
        this.lblSymbol.setHorizontalTextPosition(0);
        this.lblSymbol.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CompanyHeader.this.lblSymbolMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CompanyHeader.this.lblSymbolMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CompanyHeader.this.lblSymbolMousePressed(evt);
            }
        });
        this.jLabel1.setBackground(new Color(153, 153, 153));
        this.jLabel1.setOpaque(true);
        this.lblSymbolName.setFont(new Font("Tahoma", 1, 14));
        this.lblSymbolName.setText(" ");
        this.jSeparator3.setOrientation(1);
        this.cmbSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompanyHeader.this.cmbSymbolActionPerformed(evt);
            }
        });
        this.lblDescription.setLineWrap(true);
        this.lblDescription.setText(" ");
        this.lblDescription.setVerticalAlignment(1);
        this.lblDescription.setVerticalTextPosition(1);
        this.lblScripBrowse.setIcon(new ImageIcon(this.getClass().getResource("/Images/symDetail2.png")));
        this.lblScripBrowse.setText("Scrip Browse");
        this.lblSrch.setHorizontalAlignment(2);
        this.lblSrch.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.lblSrch.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                CompanyHeader.this.lblSrchMousePressed(evt);
            }
        });
        this.lblLogo.setBackground(new Color(255, 255, 255));
        this.lblLogo.setPreferredSize(new Dimension(65, 65));
        this.lblLogo.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CompanyHeader.this.lblLogoMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CompanyHeader.this.lblLogoMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CompanyHeader.this.lblLogoMousePressed(evt);
            }
        });
        GroupLayout lblLogoLayout = new GroupLayout((Container)this.lblLogo);
        this.lblLogo.setLayout((LayoutManager)lblLogoLayout);
        lblLogoLayout.setHorizontalGroup(lblLogoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 110, Short.MAX_VALUE));
        lblLogoLayout.setVerticalGroup(lblLogoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 80, Short.MAX_VALUE));
        this.lblDetailQuote.setIcon(new ImageIcon(this.getClass().getResource("/Images/detailQuote.png")));
        this.lblDetailQuote.setText("Detail Quote");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent((Component)this.lblLogo, -2, 110, -2).addGap(5, 5, 5).addComponent(this.jSeparator3, -2, -1, -2).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblSymbol, -2, 70, -2).addGap(5, 5, 5).addComponent(this.jLabel1, -2, 1, -2).addGap(9, 9, 9).addComponent(this.lblSymbolName, -1, -1, Short.MAX_VALUE).addGap(30, 30, 30)).addComponent(this.jSeparator2).addComponent((Component)this.lblDescription, -1, -1, Short.MAX_VALUE)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cmbSymbol, -2, 80, -2).addGap(5, 5, 5).addComponent(this.lblSrch, -2, 20, -2)).addComponent(this.lblScripBrowse, -2, 100, -2)).addContainerGap()).addComponent(this.lblDetailQuote, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent((Component)this.lblLogo, -2, 80, -2)).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jSeparator3, -2, 70, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbSymbol, -2, -1, -2).addComponent(this.lblSrch, -2, 20, -2)).addGap(8, 8, 8).addComponent(this.lblScripBrowse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblDetailQuote)).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSymbol).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jLabel1, -2, 15, -2)).addComponent(this.lblSymbolName)).addGap(6, 6, 6).addComponent(this.jSeparator2, -2, -1, -2).addGap(5, 5, 5).addComponent((Component)this.lblDescription, -2, 45, -2))));
    }

    private void cmbSymbolActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            this.scripChanged();
        }
    }

    private void lblSrchMousePressed(MouseEvent evt) {
        this.scripChanged();
    }

    private void lblLogoMousePressed(MouseEvent evt) {
        this.openCompanyInfo();
    }

    private void lblLogoMouseEntered(MouseEvent evt) {
        this.lblLogo.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void lblLogoMouseExited(MouseEvent evt) {
        this.lblLogo.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void lblSymbolMousePressed(MouseEvent evt) {
        this.openCompanyInfo();
    }

    private void lblSymbolMouseEntered(MouseEvent evt) {
        this.lblSymbol.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void lblSymbolMouseExited(MouseEvent evt) {
        this.lblSymbol.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setImages(final String symbol) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/CompanyImages/" + symbol.toUpperCase() + ".GIF";
                    BufferedImage image = ImageUtil.downloadImage((String)call);
                    if (image != null) {
                        CompanyHeader.this.lblLogo.setImage((Image)image);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void setDescription(final String symbol) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String inputLine;
                    String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/DataServiceServlet?service=ScripDescription&scrip=" + symbol;
                    StringBuilder sb = new StringBuilder();
                    URL url = new URL(call);
                    URLConnection yc = url.openConnection();
                    BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                    while ((inputLine = in.readLine()) != null) {
                        sb.append(inputLine);
                    }
                    in.close();
                    CompanyHeader.this.lblDescription.setText(sb.toString());
                    CompanyHeader.this.lblDescription.setToolTipText(CompanyHeader.this.lblDescription.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void scripChanged() {
        if (this.scriptDetails != null) {
            this.scriptDetails.setSymbol(this.cmbSymbol.getSelectedItem().toString());
        }
        this.setSymbol(this.cmbSymbol.getSelectedItem().toString());
    }

    private void openCompanyInfo() {
        this.mediator.openCompanyInfo(this.cmbSymbol.getSelectedItem().toString());
    }
}

