/*
 * Decompiled with CFR 0.152.
 */
package Screener;

import Beans.StatementBean;
import BeansContainer.StatementContainer;
import BeansContainer.YearContainer;
import Control.JasperFileChooser;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.FinancialStatementModel;
import RendersNModels.StatementTableCellRender;
import RendersNModels.TableHeaderRenderer;
import Screener.FinancialStatement;
import com.google.gson.Gson;
import common.gui.component.NxGScrollBarUI;
import common.gui.util.AppConfig;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import languages.LanguageCentre;
import languages.LanguageConstant;
import reports.DynamicQuarterReport;
import reports.Jasper_QuarterStatement;

public class QuarterStatement
extends JPanel
implements ActionListener,
ReportControlListener {
    int columnWidth = 1;
    int columnTitleWidth = 250;
    int width = 0;
    Mediator mediator = Mediator.getInstance();
    FinancialStatementModel model = null;
    FinancialStatementModel modelHeader = null;
    Vector<String> colVector = new Vector();
    Vector<String> colHeaderVector = new Vector();
    Vector<Vector<String>> rowVector = new Vector();
    public TreeMap<String, Integer> columnW = new TreeMap();
    private String ReportUrl = "http://localhost:8080/TradeCastTest/";
    String statement;
    String symbol;
    private final FinancialStatement financialStatement;
    StatementTableCellRender render = new StatementTableCellRender();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JLabel lblMsg;
    private JPanel pnl;
    private JScrollPane scrollPane;
    private JScrollPane spHeader;
    private JTable table;
    private JTable tblHeader;

    public QuarterStatement(FinancialStatement financialStatement) {
        this.initComponents();
        this.financialStatement = financialStatement;
        Border b = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        Border pnlborder = BorderFactory.createLineBorder(Color.DARK_GRAY, 1);
        this.model = new FinancialStatementModel((Vector)this.rowVector, (Vector)this.colVector);
        this.modelHeader = new FinancialStatementModel(null, (Vector)this.colHeaderVector);
        this.spHeader.setBorder(b);
        this.spHeader.getViewport().setBackground(Color.WHITE);
        this.scrollPane.setBorder(b);
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        JScrollBar vbar = this.scrollPane.getVerticalScrollBar();
        NxGScrollBarUI ui2 = new NxGScrollBarUI();
        ui2.setMyScrollBarUI(vbar);
        vbar.setPreferredSize(new Dimension(7, 0));
        this.table.getTableHeader().setDefaultRenderer(new TableHeaderRenderer(this.table));
        this.tblHeader.getTableHeader().setDefaultRenderer(new TableHeaderRenderer(this.tblHeader));
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                QuarterStatement.this.changeMargin();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    private String getStatement() {
        return this.statement;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    private String getSymbol() {
        return this.symbol;
    }

    private void initComponents() {
        this.pnl = new JPanel();
        this.spHeader = new JScrollPane();
        this.tblHeader = new JTable();
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.lblMsg = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setCursor(new Cursor(0));
        this.pnl.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaptionBorder));
        this.spHeader.setHorizontalScrollBarPolicy(31);
        this.spHeader.setVerticalScrollBarPolicy(21);
        this.tblHeader.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.tblHeader.getTableHeader().setResizingAllowed(false);
        this.tblHeader.getTableHeader().setReorderingAllowed(false);
        this.spHeader.setViewportView(this.tblHeader);
        this.table.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.table.setSelectionForeground(new Color(0, 0, 0));
        this.table.getTableHeader().setResizingAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.scrollPane.setViewportView(this.table);
        GroupLayout pnlLayout = new GroupLayout(this.pnl);
        this.pnl.setLayout(pnlLayout);
        pnlLayout.setHorizontalGroup(pnlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spHeader).addComponent(this.scrollPane));
        pnlLayout.setVerticalGroup(pnlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlLayout.createSequentialGroup().addComponent(this.spHeader, -2, 20, -2).addGap(0, 0, 0).addComponent(this.scrollPane, -1, 62, Short.MAX_VALUE)));
        this.lblMsg.setFont(new Font("Tahoma", 1, 11));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblMsg, -2, 580, -2).addContainerGap(20, Short.MAX_VALUE)).addComponent(this.pnl, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnl, -1, -1, Short.MAX_VALUE).addGap(2, 2, 2).addComponent(this.lblMsg, -2, 20, -2)));
    }

    public void getData() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (QuarterStatement.this.getSymbol() != null && QuarterStatement.this.getStatement() != null) {
                    Util.setMessage((JLabel)QuarterStatement.this.lblMsg, (MessageType)MessageType.Loading, (String)QuarterStatement.this.languageCentre.getValue(LanguageConstant.Loading));
                    QuarterStatement.this.setWindowHight(false);
                    QuarterStatement.this.callReport();
                    QuarterStatement.this.setWindowHight(true);
                }
            }
        }, "Scrip Detail QuarterStatement").start();
    }

    private void setWindowHight(boolean isDataLoaded) {
        if (isDataLoaded) {
            Dimension n = new Dimension(0, this.table.getRowCount() * this.table.getRowHeight());
            this.setPreferredSize(n);
            int hight = (int)n.getHeight() + 126;
            this.financialStatement.setPreferredSize(new Dimension(0, hight));
        } else {
            Dimension n = new Dimension(0, 0);
            this.setPreferredSize(n);
            int hight = (int)n.getHeight() + 126;
            this.financialStatement.setPreferredSize(new Dimension(0, hight));
        }
    }

    private void callReport() {
        Gson gson = new Gson();
        try {
            String inputLine;
            this.rowVector.clear();
            this.colVector.clear();
            this.colHeaderVector.clear();
            this.columnW.clear();
            this.model.setColumnCount(0);
            this.modelHeader.setColumnCount(0);
            this.tableDataChange();
            String type = "QuarterStatement";
            String scrip = this.getSymbol();
            String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/DataServiceServlet?service=" + type + "&scrip=" + scrip + "&market=" + this.getStatement();
            StringBuilder sb = new StringBuilder();
            URL url = new URL(call);
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine);
            }
            in.close();
            this.mediator.println("Scrip Detail Quarterly Statement URL = " + call);
            this.mediator.println("Scrip Detail Quarterly Statement HTML = " + sb.toString());
            String val = sb.toString();
            if (val.length() > 0) {
                StatementContainer statementCont = (StatementContainer)gson.fromJson(val, StatementContainer.class);
                if (statementCont.list.size() > 0) {
                    this.DisplayData(statementCont);
                } else {
                    this.NoDataFound();
                }
            } else {
                this.NoDataFound();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void NoDataFound() {
        Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)"No record found");
        this.tableDataChange();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaint();
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
            this.table.getTableHeader().repaint();
            this.modelHeader.fireTableDataChanged();
            this.tblHeader.addNotify();
            this.tblHeader.repaint();
            this.tblHeader.getTableHeader().repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QuarterStatement.this.repaint();
                    QuarterStatement.this.model.fireTableDataChanged();
                    QuarterStatement.this.table.addNotify();
                    QuarterStatement.this.table.repaint();
                    QuarterStatement.this.table.getTableHeader().repaint();
                    QuarterStatement.this.modelHeader.fireTableDataChanged();
                    QuarterStatement.this.tblHeader.addNotify();
                    QuarterStatement.this.tblHeader.repaint();
                    QuarterStatement.this.tblHeader.getTableHeader().repaint();
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private void DisplayData(StatementContainer statementContainer) {
        List list = statementContainer.list;
        if (list.size() > 0) {
            void var10_20;
            void var10_18;
            TreeMap groupIndex = statementContainer.groupIndex;
            Map groupFileds = statementContainer.groupFileds;
            this.colHeaderVector.addElement(" ");
            List allYear = statementContainer.list;
            for (int i = allYear.size() - 1; i >= 0; --i) {
                YearContainer con = (YearContainer)allYear.get(i);
                StatementBean stateBean = (StatementBean)con.list.get(0);
                if (this.colHeaderVector.contains(stateBean.year)) continue;
                this.colHeaderVector.addElement(stateBean.year);
            }
            this.colVector.add(" ");
            String space = "";
            List allYear2 = statementContainer.list;
            for (int j = 0; j < allYear2.size(); ++j) {
                YearContainer yearCont = (YearContainer)allYear.get(j);
                if (yearCont.list.size() <= 0) continue;
                StatementBean statementBean = (StatementBean)yearCont.list.get(0);
                if (statementBean.accountType.equalsIgnoreCase("HY")) {
                    statementBean.accountType = "FY";
                } else if (statementBean.accountType.equalsIgnoreCase("FY")) {
                    statementBean.accountType = "HY";
                }
                this.colVector.addElement(statementBean.accountType + space);
                if (this.columnW.containsKey(statementBean.year)) {
                    ++this.columnWidth;
                    this.columnW.put(statementBean.year, this.columnWidth);
                } else {
                    this.columnWidth = 1;
                    this.columnW.put(statementBean.year, this.columnWidth);
                }
                space = space + " ";
            }
            ArrayList all = new ArrayList();
            for (Map.Entry entry : groupIndex.entrySet()) {
                all.add(entry.getValue());
            }
            Collections.sort(all);
            int loop = (Integer)all.get(all.size() - 1) + 1;
            boolean bl = true;
            while (var10_18 < loop) {
                for (Map.Entry entry : groupIndex.entrySet()) {
                    Vector<String> rowVal;
                    String group = (String)entry.getKey();
                    Integer integer = (Integer)entry.getValue();
                    if (integer.intValue() != var10_18 || !groupFileds.containsKey(integer)) continue;
                    this.addGroupRow("<html> <font size = '3' color='" + MyColors.StatementHeadingColor + "'>&nbsp;&nbsp;<b>" + group + "</b></font></html>");
                    ArrayList fielddList = (ArrayList)groupFileds.get(integer);
                    for (int i = 0; i < fielddList.size(); ++i) {
                        String field = (String)fielddList.get(i);
                        Vector<String> rowValues = new Vector<String>(4);
                        rowValues.add("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font size = '3'>" + field + "</font></html>");
                        double tempVal = 0.0;
                        for (int j = list.size() - 1; j >= 0; --j) {
                            YearContainer yearContainer = (YearContainer)list.get(j);
                            for (int k = 0; k < yearContainer.list.size(); ++k) {
                                StatementBean statementBean = (StatementBean)yearContainer.list.get(k);
                                if (!statementBean.field.equalsIgnoreCase(field)) continue;
                                try {
                                    tempVal += Double.parseDouble(statementBean.value);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                rowValues.add("<html><font size = '3'>" + Util.format2digit((String)statementBean.value) + "&nbsp;</font></html>");
                            }
                        }
                        if (tempVal != 0.0) {
                            this.rowVector.add(rowValues);
                        }
                        tempVal = 0.0;
                    }
                    if (this.rowVector.size() <= 0 || (rowVal = this.rowVector.get(this.rowVector.size() - 1)).get(0).indexOf("<html> <font size = '3' color='") != 0) continue;
                    this.rowVector.remove(this.rowVector.size() - 1);
                }
                ++var10_18;
            }
            this.modelHeader.setDataVector(null, this.colHeaderVector);
            this.tblHeader.setModel(this.modelHeader);
            this.model.setDataVector(this.rowVector, this.colVector);
            this.table.setModel(this.model);
            this.table.getColumn(this.table.getColumnName(0)).setMaxWidth(this.columnTitleWidth);
            this.table.getColumn(this.table.getColumnName(0)).setMinWidth(this.columnTitleWidth);
            this.tblHeader.getColumn(this.table.getColumnName(0)).setMaxWidth(this.columnTitleWidth);
            this.tblHeader.getColumn(this.table.getColumnName(0)).setMinWidth(this.columnTitleWidth);
            boolean bl2 = false;
            while (var10_20 < this.colVector.size()) {
                this.table.getColumn(this.colVector.elementAt((int)var10_20)).setCellRenderer(this.render);
                ++var10_20;
            }
            this.table.setSelectionMode(0);
            this.table.setSelectionBackground(MyColors.MarketWatchSelectedRowColor);
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)this.mediator.getSymbolTitle(this.getSymbol()));
        } else {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Normal, (String)"No record found");
        }
        this.tableDataChange();
    }

    private void addGroupRow(String group) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.colVector.size(); ++i) {
            if (i == 0) {
                v.add(group);
                continue;
            }
            v.add("");
        }
        this.rowVector.add(v);
    }

    public void changeMargin() {
        try {
            this.width = this.table.getColumn(this.table.getColumnName(1)).getWidth();
            if (this.columnW.size() > 0) {
                for (int i = 1; i < this.tblHeader.getColumnCount(); ++i) {
                    if (!this.columnW.containsKey(this.tblHeader.getColumnName(i))) continue;
                    int newW = this.width * this.columnW.get(this.tblHeader.getColumnName(i));
                    this.tblHeader.getColumn(this.tblHeader.getColumnName(i)).setMaxWidth(newW);
                    this.tblHeader.getColumn(this.tblHeader.getColumnName(i)).setMinWidth(newW);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Jasper_QuarterStatement.Statement = this.getStatement();
        Jasper_QuarterStatement.Symbol = this.mediator.getSymbolTitle(this.getSymbol());
        DynamicQuarterReport dynamic = new DynamicQuarterReport("QuarterStatement.jrxml", this.table.getModel(), this.tblHeader.getModel(), this.columnW);
        if (!dynamic.isHasPage()) {
            return;
        }
        dynamic.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Jasper_QuarterStatement.Statement = this.getStatement();
        Jasper_QuarterStatement.Symbol = this.mediator.getSymbolTitle(this.getSymbol());
        DynamicQuarterReport dynamic = new DynamicQuarterReport("QuarterStatement.jrxml", this.table.getModel(), this.tblHeader.getModel(), this.columnW);
        if (!dynamic.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Quarter Statement-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = dynamic.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        Jasper_QuarterStatement.Statement = this.getStatement();
        Jasper_QuarterStatement.Symbol = this.mediator.getSymbolTitle(this.getSymbol());
        DynamicQuarterReport dynamic = new DynamicQuarterReport("QuarterStatement.jrxml", this.table.getModel(), this.tblHeader.getModel(), this.columnW);
        if (!dynamic.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Quarter Statement-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null) {
            String FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion();
            boolean result = dynamic.ExportToPdf(FileName);
            if (result) {
                int Option = JOptionPane.showConfirmDialog(null, "Quarter Statement report created. Do you want to open it?", "PDF", 0);
                if (Option == 0) {
                    try {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                JOptionPane.showMessageDialog(null, "Error in creating pdf file.");
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Jasper_QuarterStatement.Statement = this.getStatement();
        Jasper_QuarterStatement.Symbol = this.mediator.getSymbolTitle(this.getSymbol());
        DynamicQuarterReport dynamic = new DynamicQuarterReport("QuarterStatement.jrxml", this.table.getModel(), this.tblHeader.getModel(), this.columnW);
        if (!dynamic.isHasPage()) {
            return;
        }
        dynamic.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
    }

    public void SetParamter(Jasper_QuarterStatement Report) {
        HashMap param = new HashMap();
        if (System.getProperty("TradeCastURL") != null) {
            this.ReportUrl = System.getProperty("TradeCastURL") + "/HouseImages";
        }
        Report.parameters.put("URL", this.ReportUrl);
        Report.parameters.put("Statement", this.getStatement());
        Report.parameters.put("Symbol", this.mediator.getSymbolTitle(this.getSymbol()));
        Report.parameters.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
    }
}

