/*
 * Decompiled with CFR 0.152.
 */
package Sockets;

import Beans.MessageWindowBean;
import CATALYST.Control.Utilities;
import CATALYST.Socket.MessageRecieveEvent;
import CATALYST.Socket.MessageRecieveListner;
import CATALYST.Socket.MyTcp;
import CATALYST.Socket.Security;
import CATALYST.Socket.SocketStatus;
import CATALYST.Socket.Status;
import CustomComponent.MyOptionPane;
import CustomComponent.MyTime;
import MessageWindow.ReadWrite;
import MyDocking.Mediator;
import Orders.BunchOrder;
import Orders.KSE_FastOrder;
import Orders.OrderErrorPopup;
import Orders.OrderImport;
import Utilities.LogsTC;
import Utilities.UtilTC;
import Watches.LiquidateAllOrderDialog;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.services.WebService;
import http.HttpStatus;
import java.awt.Color;
import java.net.InetAddress;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import kse.util.LogsKSE;
import languages.LanguageConstant;
import pmex.gui.bean.TradedOrderBean;
import pmex.gui.bean.WorkingOrderBean;
import pmex.gui.util.LogsPMEX;

public class TradeClient
implements MessageRecieveListner {
    public MyTcp TStcp = null;
    Mediator mediator = Mediator.getInstance();
    private boolean FirstAttempt = true;
    public SocketStatus MS = new SocketStatus();

    public TradeClient() {
        this.MS.SocketName = "TradeCast Server";
        this.MS.HouseName = AppConfig.houseName;
        this.MS.UserID = LogCommon.UserID;
        this.MS.ServerIP = AppConfig.tradeCastIP;
        this.MS.ServerIPList = AppConfig.tradeCastIPList;
        this.MS.Port = AppConfig.tradeCastServerPort;
        this.MS.ConnectAttempt = 5;
        this.MS.Debug = false;
        this.MS.EnablePingPong = true;
        this.MS.isDoQueueEmptyOnConnect = false;
        this.MS.PingPongMessage = "MSG-CLIENT|HI_FROM_CLIENT||*";
        this.MS.MessageParser = "*";
        this.MS.isWriteLogIntoFile = LogCommon.isWriteLogIntoFile;
        Security security = null;
        try {
            security = new Security("catalyst");
        }
        catch (Exception ex) {
            this.mediator.PrintLog(ex, "");
            ex.printStackTrace();
        }
        this.TStcp = new MyTcp(this.MS, security);
        this.TStcp.setName("Trade Client Thread");
        this.TStcp.addListener((MessageRecieveListner)this);
        this.TStcp.start();
    }

    public void Disconnect() {
        this.TStcp.Dispose();
    }

    public void MessageRecieved(MessageRecieveEvent event) {
        this.TradeCastServerReceivedMessages(event);
    }

    public void ConnectionStatus(MessageRecieveEvent event) {
        String Msg = event.getmessage();
        Status status = event.getConnectionStatus();
        if (this.mediator != null) {
            this.mediator.WriteConnectionInFile("Trade Server: " + event.getConnectionStatus().name() + " , " + Msg);
        }
        if (status != Status.NewIP && status != Status.UnableTosend && status != Status.UnableToReceive) {
            this.mediator.SetConnectionStatus(this, event.getConnectionStatus().toString());
            if (status == Status.Active) {
                LogsKSE.TradeOnTCP = true;
            }
        }
        if (status == Status.UnableTosend && (event.getmessage().indexOf("NEW_ORDER") >= 0 || event.getmessage().indexOf("CANCEL_ORDER") >= 0)) {
            LogsKSE.AllowNextOrder = true;
            this.mediator.WriteOrderinFile(event.getexception());
        }
        if (Msg.indexOf("Unable To Connect to server") >= 0) {
            LogsKSE.isAuthenticated = false;
            if (AppConfig.HTTPFeedURL.length() == 0 && AppConfig.HTTPTradeURL.length() == 0) {
                AppConfig.setAllValues();
                JOptionPane.showMessageDialog(null, "You have been disconnected from Trade Server.\nPlease try again!", "Disconnection", 0);
                System.exit(0);
            } else if (LogsTC.Http_Trade_Status == HttpStatus.InActive) {
                if (!this.mediator.ConnectToHttp()) {
                    AppConfig.setAllValues();
                    JOptionPane.showMessageDialog(null, "You have been disconnected from Trade Server.\nPlease try again!", "Disconnection", 0);
                    System.exit(0);
                }
                return;
            }
        }
        if (status == Status.Active) {
            if (this.FirstAttempt) {
                this.mediator.msgCenter.AddMessageInMsgWin("<>" + this.mediator.myTime.getTime() + " - Trade Server: " + Msg);
                if (!LogsKSE.isPartialLogin) {
                    this.mediator.SendMsgToTradeServer("MSG-CLIENT|AUTHENTICATE|" + LogCommon.UserID + "|" + LogCommon.UserPassword);
                } else {
                    this.mediator.SendMsgToTradeServer("MSG-CLIENT|AUTHENTICATE_PARTIAL|" + LogCommon.UserID + "|" + LogCommon.UserPassword + "|" + LogsKSE.UserPasswordIndex.replaceAll("\\|", "~") + "|");
                }
                this.FirstAttempt = false;
            } else {
                this.mediator.msgCenter.AddMessageInMsgWin("<>" + this.mediator.myTime.getTime() + " - Trade Server: " + Msg);
                this.mediator.SendMsgToTradeServer("MSG-CLIENT|NEW_CLIENT_RETRY|" + LogCommon.UserCode + "|" + LogCommon.UserID);
                LogsKSE.AllowNextOrder = true;
                new Thread("TradeClient GetMarketStatus"){

                    @Override
                    public void run() {
                        TradeClient.this.mediator.GetMarketStatus();
                    }
                }.start();
            }
        } else if (status == Status.Reconnecting) {
            this.mediator.msgCenter.AddMessageInMsgWin("<>" + this.mediator.myTime.getTime() + " - Trade Server: " + Msg);
            this.mediator.WriteConnectionInFile("Trade Server: " + this.mediator.myTime.getTime() + " , " + event.getConnectionStatus().name() + " , " + event.getmessage());
        } else if (status == Status.NewIP && !this.FirstAttempt) {
            this.SetWebServiceUrl(Msg);
        }
    }

    private void TradeCastServerReceivedMessages(MessageRecieveEvent Event2) {
        try {
            this.mediator.println(Event2.getmessage());
            String[] responseList = Utilities.split((String)Event2.getmessage(), (char)'*');
            for (int i = 0; i < responseList.length; ++i) {
                if (responseList[i].length() <= 0) continue;
                String[] originalmessage = Utilities.split((String)responseList[i], (char)'|');
                String messgeUpperCase = responseList[i].toUpperCase();
                String[] messageWithIndex = Utilities.split((String)messgeUpperCase, (char)'|');
                if (messgeUpperCase.indexOf("HI_FROM_SERVER") >= 0) {
                    this.mediator.setServerTimeOnToolBar(messageWithIndex[3]);
                    continue;
                }
                if (messgeUpperCase.equalsIgnoreCase("UXQQR78")) {
                    JOptionPane.showMessageDialog(null, "Trade Server is down.\nPlease try after few minutes!", "Disconnection", 0);
                    System.exit(0);
                }
                if (messageWithIndex[1].compareTo("WELCOME") == 0) {
                    LogsKSE.AllowNextOrder = true;
                    this.mediator.SendMsgToTradeServer(new String[]{"STORED_MESSAGE_LIST", LogCommon.UserCode});
                    this.PrintMsg(responseList[i]);
                    continue;
                }
                if (messageWithIndex[1].compareTo("AUTHENTICATE_END") == 0) {
                    if (messageWithIndex[2].indexOf("TRUE") >= 0) {
                        this.mediator.SendMsgToTradeServer("MSG-CLIENT|NEW_CLIENT|" + LogCommon.UserCode + "|" + LogCommon.UserID);
                        String localip = InetAddress.getLocalHost().getHostAddress();
                        this.mediator.SendMsgToTradeServer("MSG-CLIENT|LOCALIP|" + LogCommon.UserCode + "|" + LogCommon.UserID + "|" + localip);
                        LogsKSE.isAuthenticated = true;
                        if (LogsTC.Http_Trade_Status != HttpStatus.Active) continue;
                        Mediator.getInstance().SetConnectionStatus(Mediator.getInstance().tradeclient, "Restricted");
                        continue;
                    }
                    if (messageWithIndex[2].equalsIgnoreCase("YOUR LAST SESSION NOT EXPIRED. PLEASE WAIT...")) {
                        JOptionPane.showMessageDialog(null, "Another client is already connected using the same credentials!", "Disconnection", 0);
                        System.exit(0);
                        continue;
                    }
                    JOptionPane.showMessageDialog(null, messageWithIndex[2], "Error Message", 0);
                    System.exit(0);
                    continue;
                }
                if (messageWithIndex[1].compareTo("STORED_MESSAGE") == 0) {
                    this.mediator.SendMsgToTradeServer(new String[]{"ORDER_EXE_ACK", LogCommon.UserCode, messageWithIndex[2].split("\\^", -1)[0]});
                    continue;
                }
                if (messageWithIndex[1].compareTo("ENDUP") == 0) {
                    LogsKSE.isAuthenticated = false;
                    AppConfig.setAllValues();
                    JOptionPane.showMessageDialog(null, "You have been disconnected form Trade Server!", "Disconnection", 1);
                    System.exit(0);
                    continue;
                }
                if (messageWithIndex[1].compareTo("ORDER_NUM") == 0 && messageWithIndex[2].trim().length() > 0) {
                    LogsKSE.orderNumber = Integer.parseInt(messageWithIndex[2]);
                    continue;
                }
                if (messageWithIndex[1].compareTo("PMEX_ORDER_NUM") == 0 && messageWithIndex[2].trim().length() > 0) {
                    LogsPMEX.orderNumber = Long.parseLong(messageWithIndex[2].trim());
                    continue;
                }
                if (messageWithIndex[1].compareTo("PAYMENT_REQUEST_BRANCH_LIST_END") == 0) {
                    if (this.mediator.withdrawalRequest != null) {
                        this.mediator.withdrawalRequest.setBranchs(messageWithIndex[2]);
                    }
                    if (this.mediator.withdrawalChequeAndBankRequest == null) continue;
                    this.mediator.withdrawalChequeAndBankRequest.setBranchs(messageWithIndex[2]);
                    continue;
                }
                if (messageWithIndex[1].compareTo("USER_AVAILABLE_CASH_END") == 0) {
                    if (this.mediator.withdrawalRequest != null) {
                        this.mediator.withdrawalRequest.setAccountAmount(messageWithIndex[2]);
                    }
                    if (this.mediator.withdrawalBankRequest != null) {
                        this.mediator.withdrawalBankRequest.setAccountAmount(messageWithIndex[2]);
                    }
                    if (this.mediator.withdrawalChequeAndBankRequest != null) {
                        this.mediator.withdrawalChequeAndBankRequest.setAccountAmount(messageWithIndex[2]);
                    }
                    if (this.mediator.jsFundTransfer == null) continue;
                    this.mediator.jsFundTransfer.setAccountAmountEquity(messageWithIndex[2]);
                    continue;
                }
                if (messageWithIndex[1].compareTo("DEPOSITWITHDRAW_END") == 0) {
                    if (this.mediator.withdrawalRequest != null) {
                        this.mediator.withdrawalRequest.SetReponseMsg(Utilities.split((String)responseList[i], (char)'|')[2]);
                    }
                    if (this.mediator.withdrawalBankRequest != null) {
                        this.mediator.withdrawalBankRequest.SetReponseMsg(Utilities.split((String)responseList[i], (char)'|')[2]);
                    }
                    if (this.mediator.withdrawalChequeAndBankRequest == null) continue;
                    this.mediator.withdrawalChequeAndBankRequest.SetReponseMsg(Utilities.split((String)responseList[i], (char)'|')[2]);
                    continue;
                }
                if (messageWithIndex[1].compareTo("ACCOUNT_STATEMENT_END") == 0) {
                    if (messageWithIndex[2].compareTo("INVALID PIN") == 0) {
                        this.mediator.accountstatement.Update("INVALID PIN");
                        continue;
                    }
                    this.mediator.accountstatement.Update(LogsTC.accountStatement.toString());
                    continue;
                }
                if (messageWithIndex[1].compareTo("CASH_WITHDRAWAL_STATEMENT_END") == 0) {
                    this.mediator.withdrawstatement.Update(messageWithIndex[2]);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("EXPOSURE_LIMIT")) {
                    if (this.mediator.exposureWatch == null) continue;
                    this.mediator.exposureWatch.fillExposureNew(messageWithIndex[2], "Exposure");
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("COLLATERAL")) {
                    if (this.mediator.exposureWatch == null) continue;
                    this.mediator.exposureWatch.fillExposureNew(messageWithIndex[2], "Collaterals");
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("OPENPOSITION")) {
                    if (this.mediator.exposureWatch == null) continue;
                    this.mediator.exposureWatch.fillExposureNew(messageWithIndex[2], "OpenPosition");
                    continue;
                }
                if (messageWithIndex[1].compareTo("GET_USER_ACTIVE_ACCOUNTS") == 0) {
                    LogsKSE.AccountString = messageWithIndex[3];
                    continue;
                }
                if (messageWithIndex[1].compareTo("ACCOUNT_SYN") == 0) {
                    UtilTC.GetAccounts(LogCommon.UserID);
                    this.mediator.tradeoutLog.updateAccount();
                    this.mediator.outStandingLog.updateAccount();
                    this.mediator.activityLog.updateAccount();
                    if (AppConfig.isPortfolioAdv) {
                        if (this.mediator.portfolioWatchAdv == null) continue;
                        this.mediator.portfolioWatchAdv.updateAccount();
                        continue;
                    }
                    if (this.mediator.portfolioWatch == null) continue;
                    this.mediator.portfolioWatch.updateAccount();
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("ORDER_EXE")) {
                    this.mediator.onOrderResponseEvent(originalmessage[4].replace('#', '|'), true);
                    this.mediator.SendMsgToTradeServer(new String[]{"ORDER_EXE_ACK", LogCommon.UserCode, Utilities.split((String)messageWithIndex[2], (char)'^')[0]});
                    this.PrintMsg(responseList[i]);
                    this.mediator.WriteOrderResponseinFile(responseList[i]);
                    if (responseList[i].toUpperCase().indexOf("CANCELLED") < 0 || this.mediator.cancel == null) continue;
                    this.mediator.tradecast.CloseForm(FormName.Cancel);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("PMEX_ORDER_EXE")) {
                    this.mediator.onOrderResponseEvent(originalmessage[4].replace('#', '|'), true);
                    this.mediator.SendMsgToTradeServer(new String[]{"ORDER_EXE_ACK", LogCommon.UserCode, Utilities.split((String)messageWithIndex[2], (char)'^')[0]});
                    this.PrintMsg(responseList[i]);
                    this.mediator.WriteOrderResponseinFile(responseList[i]);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("ORDER_EXE_LOG")) {
                    this.orderExeLogProcess(originalmessage, responseList[i]);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("ACCOUNT_ORDER_EXE")) {
                    this.PrintMsg(responseList[i]);
                    this.mediator.WriteOrderResponseinFile(responseList[i]);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("ACCOUNT_PMEX_ORDER_EXE")) {
                    this.PrintMsg(responseList[i]);
                    this.mediator.WriteOrderResponseinFile(responseList[i]);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("ACCOUNT_ORDER_EXE_LOG")) {
                    if (LogsTC.accountAll.size() < 50) {
                        this.mediator.onOrderViewReceiveEvent(originalmessage[4].replace('#', '|'), false);
                        if (this.mediator.outStandingLog != null) {
                            this.mediator.outStandingLog.UpdateTable();
                        }
                    }
                    this.mediator.WriteOrderResponseinFile(responseList[i]);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("ORDER_SENT")) {
                    LogsKSE.AllowNextOrder = true;
                    this.PrintMsg(responseList[i]);
                    this.mediator.WriteOrderResponseinFile(responseList[i]);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("ORDER_MST")) {
                    String MarketCode = messageWithIndex[3];
                    String MarketStatus = messageWithIndex[4];
                    if (MarketCode.indexOf("REG") >= 0) {
                        LogsKSE.MarketStauts = MarketStatus;
                        if (MarketStatus.toUpperCase().indexOf("HALTED") >= 0 || MarketStatus.toUpperCase().indexOf("SUS") >= 0) {
                            this.mediator.SetMarketStatus("Closed", Color.red);
                            this.mediator.setMarketWatch_MarketStatus(false);
                            LogsKSE.isMarketOpen = false;
                        } else if (MarketStatus.toUpperCase().indexOf("PRE") >= 0) {
                            this.mediator.SetMarketStatus("Pre-Opened", new Color(0, 108, 0));
                            this.mediator.setMarketWatch_MarketStatus(true);
                            LogsKSE.isMarketOpen = true;
                            this.mediator.initOffHourSettings(false, false);
                        } else if (MarketStatus.toUpperCase().indexOf("OPN") >= 0) {
                            this.mediator.SetMarketStatus("Opened", new Color(0, 108, 0));
                            this.mediator.setMarketWatch_MarketStatus(true);
                            LogsKSE.isMarketOpen = true;
                            this.mediator.initOffHourSettings(false, false);
                        } else if (MarketStatus.toUpperCase().indexOf("OHO") >= 0) {
                            this.mediator.SetMarketStatus("OHO", new Color(0, 108, 0));
                            this.mediator.setMarketWatch_MarketStatus(true);
                            LogsKSE.isMarketOpen = true;
                            this.mediator.initOffHourSettings(true, false);
                        } else if (MarketStatus.toUpperCase().indexOf("OHP") >= 0) {
                            this.mediator.SetMarketStatus("Pre-Open", new Color(0, 108, 0));
                            this.mediator.setMarketWatch_MarketStatus(true);
                            LogsKSE.isMarketOpen = true;
                            this.mediator.initOffHourSettings(false, false);
                        } else if (MarketStatus.toUpperCase().indexOf("OHR") >= 0) {
                            this.mediator.SetMarketStatus("OHR", new Color(0, 108, 0));
                            this.mediator.setMarketWatch_MarketStatus(true);
                            LogsKSE.isMarketOpen = true;
                        } else if (MarketStatus.toUpperCase().indexOf("OHC") >= 0) {
                            this.mediator.SetMarketStatus("OHC", Color.red);
                            this.mediator.setMarketWatch_MarketStatus(false);
                            LogsKSE.isMarketOpen = false;
                        } else if (MarketStatus.toUpperCase().indexOf("OHS") >= 0) {
                            this.mediator.SetMarketStatus("OHS", Color.red);
                            this.mediator.setMarketWatch_MarketStatus(false);
                            LogsKSE.isMarketOpen = false;
                        } else if (MarketStatus.toUpperCase().indexOf("PCL") >= 0 || MarketStatus.toUpperCase().indexOf("POSTCLOSED") >= 0 || MarketStatus.toUpperCase().indexOf("POST_CLOSED") >= 0) {
                            this.mediator.SetMarketStatus("PostClosed", new Color(0, 108, 0));
                            this.mediator.setMarketWatch_MarketStatus(true);
                            LogsKSE.isMarketOpen = true;
                            this.mediator.initOffHourSettings(false, false);
                        }
                        if (MarketStatus.toUpperCase().indexOf("SUS") >= 0) {
                            new Thread("TradeClient Save Profiles on Market SUS"){

                                @Override
                                public void run() {
                                    if (TradeClient.this.mediator != null) {
                                        try {
                                            int delay = (int)Math.random() * 5000;
                                            Thread.sleep(delay);
                                            TradeClient.this.mediator.SaveProfile(false);
                                            TradeClient.this.mediator.SaveProfilePMEX(false);
                                            TradeClient.this.mediator.SaveProfilePMEX_Matrix(false);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    AppConfig.setAllValues();
                                }
                            }.start();
                        }
                    }
                    this.PrintMarketStatusMessages(originalmessage[2]);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("ORDER_CATS")) {
                    final String myMessage = messageWithIndex[2];
                    new Thread("TradeClient ALERT"){

                        @Override
                        public void run() {
                            if (myMessage.indexOf("ALERT$") >= 0) {
                                String[] m = myMessage.split("\\$", -1);
                                MyOptionPane.showMessage(MessageType.Information, m[1], AppConfig.companyName, false);
                            }
                        }
                    }.start();
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("ORDERSENDTOMARKETFAIL")) {
                    LogsKSE.AllowNextOrder = true;
                    if (LogsKSE.IsInBunchOrderProcess) {
                        BunchOrder.SendBasketOrder();
                    }
                    if (LogsKSE.IsInKSEFastOrderProcess) {
                        KSE_FastOrder.sendKSEFastOrder();
                    }
                    if (LogsKSE.IsInLiquidateOrderProcess) {
                        LiquidateAllOrderDialog.SendLiquidateAllOrder();
                    }
                    if (LogsKSE.IsInOrderExportProcess) {
                        OrderImport.SendBasketOrder();
                    }
                    this.PrintMsg(responseList[i]);
                    this.mediator.WriteOrderResponseinFile(responseList[i]);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("ORDER_VALIDATE_OK")) {
                    LogsKSE.AllowNextOrder = true;
                    this.PrintMsg(responseList[i]);
                    this.mediator.WriteOrderResponseinFile(responseList[i]);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("ACCOUNT NOT ALLOCATED")) {
                    LogsKSE.AllowNextOrder = true;
                    this.PrintMsg(responseList[i]);
                    this.mediator.WriteOrderResponseinFile(responseList[i]);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("OrderSendToMarketSuccess")) {
                    this.PrintMsg(responseList[i]);
                    this.mediator.WriteOrderResponseinFile(responseList[i]);
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("MSGWINDOW")) {
                    if (this.mediator.msgwin == null) continue;
                    this.mediator.msgwin.messageAckReceived(messageWithIndex[2], messageWithIndex[3], "");
                    continue;
                }
                if (messageWithIndex[1].equalsIgnoreCase("MARGINCALL")) {
                    if (this.mediator.msgwin == null) continue;
                    this.mediator.msgwin.messageAckReceived("", LanguageConstant.MarginCall, messageWithIndex[2]);
                    continue;
                }
                if (!messageWithIndex[1].equalsIgnoreCase("MSGWINDOW_DEL") || this.mediator.msgwin == null) continue;
                if (SwingUtilities.isEventDispatchThread()) {
                    this.mediator.msgwin.messageDeleteAckReceived(messageWithIndex[2], messageWithIndex[3], "");
                    continue;
                }
                final String msg2 = messageWithIndex[2];
                final String msg3 = messageWithIndex[3];
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TradeClient.this.mediator.msgwin.messageDeleteAckReceived(msg2, msg3, "");
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mediator.PrintLog(ex, Event2.getmessage());
        }
    }

    private void PrintMarketStatusMessages(String Message2) {
        String MSGTIME = MyTime.getInstance().getTime();
        Message2 = Message2.replaceAll("Opened", "Open");
        this.mediator.msgCenter.AddMessageInMsgWin("Exc<>" + MSGTIME + " - " + Message2);
    }

    private void PrintMsg(String Msg) {
        block38: {
            try {
                Msg = Msg.replaceAll("Pin", "PIN");
                Msg = Msg.replaceAll("pin", "PIN");
                String Header1 = Utilities.split((String)Msg, (char)'|')[1];
                Header1 = Header1.toUpperCase();
                String BGColor = "";
                String ForColor = "";
                String MSGTIME = MyTime.getInstance().getTime();
                if (Header1.indexOf("WELCOME") >= 0) {
                    BGColor = "#FF9900";
                    ForColor = "#ffffff";
                    this.mediator.msgCenter.AddMessageInMsgWin("<>" + MSGTIME + " - " + AppConfig.welcomeMsg, BGColor, ForColor);
                }
                if (Header1.indexOf("ACCOUNT_ORDER_EXE") >= 0) {
                    if (LogCommon.isShowOthersTraderMessages) {
                        Color bg = Color.LIGHT_GRAY;
                        Color fg = Color.darkGray.darker();
                        String nn = Utilities.split((String)Msg, (char)'|')[2];
                        String mm = Utilities.split((String)nn, (char)'^')[1];
                        if (Msg.toUpperCase().indexOf("BOUGHT") > 0) {
                            this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + this.mediator.myTime.getTime() + " - " + mm, bg, fg);
                        } else if (Msg.toUpperCase().indexOf("SOLD") > 0) {
                            this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + this.mediator.myTime.getTime() + " - " + mm, bg, fg);
                        } else if (Msg.toUpperCase().indexOf("CANCELLED") > 0) {
                            if (Msg.toUpperCase().indexOf("BUY") > -1) {
                                this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + mm, bg, fg);
                            } else {
                                this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + mm, bg, fg);
                            }
                        } else if (Msg.toUpperCase().indexOf("QUEUED") >= 0) {
                            mm = mm.replace("NOR ", "");
                            mm = mm.replace("SLO ", "");
                            mm = mm.replace("Sell Order SHS", "Short Sell Order");
                            if (Msg.toUpperCase().indexOf("BUY") >= 0) {
                                this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + mm, bg, fg);
                            } else if (Msg.toUpperCase().indexOf("SELL") >= 0) {
                                this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + mm, bg, fg);
                            }
                        } else if (Msg.toUpperCase().indexOf("PENDING") >= 0) {
                            mm = mm.replace("NOR ", "");
                            mm = mm.replace("SLO ", "");
                            mm = mm.replace("Sell Order SHS", "Short Sell Order");
                            if (Msg.toUpperCase().indexOf("BUY") >= 0) {
                                this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + mm, bg, fg);
                            } else if (Msg.toUpperCase().indexOf("SELL") >= 0) {
                                this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + mm, bg, fg);
                            }
                        } else {
                            if (mm.indexOf(" Error in Line") > 0) {
                                String temp1 = "";
                                String temp2 = "";
                                int index = mm.indexOf(" Error in Line");
                                temp1 = mm.substring(0, index - 1);
                                if (mm.length() > index + 26) {
                                    temp2 = mm.substring(index + 26);
                                    mm = temp1 + temp2;
                                }
                            }
                            this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + this.mediator.myTime.getTime() + " - " + mm, bg, fg);
                        }
                    }
                    break block38;
                }
                if (Header1.indexOf("PMEX_ORDER_EXE") >= 0) {
                    this.handle_PMEX_ORDER_EXE_packet(Msg);
                    break block38;
                }
                if (Header1.indexOf("ORDER_EXE") >= 0) {
                    this.handle_ORDER_EXE_packet(Msg);
                    break block38;
                }
                if (Header1.indexOf("ORDER_SENT") >= 0) {
                    String message = "Order<>" + this.mediator.myTime.getTime() + " - " + Utilities.split((String)Msg, (char)'|')[2];
                    Color fg = new Color(255, 255, 255);
                    Color bg = new Color(51, 102, 0);
                    this.addMessage(message, fg, bg);
                    this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
                    break block38;
                }
                if (Header1.equalsIgnoreCase("ORDERSENDTOMARKETFAIL")) {
                    if (LogCommon.isErrorMessageInMessageWindow) {
                        String message = "Order<>" + this.mediator.myTime.getTime() + " - " + Utilities.split((String)Msg, (char)'|')[2];
                        Color fg = MyColors.ErrorBGInMsgWin;
                        Color bg = MyColors.ErrorFGInMsgWin;
                        this.addMessage(message, fg, bg);
                        this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
                    }
                    if (LogCommon.isErrorMessageInPopupWindow) {
                        final String mes = Msg;
                        new Thread(){

                            @Override
                            public void run() {
                                new OrderErrorPopup(Utilities.split((String)mes, (char)'|')[2], false);
                            }
                        }.start();
                    }
                    break block38;
                }
                if (Header1.indexOf("REJECTED") > 0) {
                    String message = "Order<>" + this.mediator.myTime.getTime() + " - " + Utilities.split((String)Msg, (char)'|')[2];
                    Color fg = new Color(255, 255, 255);
                    Color bg = Color.BLACK;
                    this.addMessage(message, fg, bg);
                    this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
                    if (this.mediator.GetMarketStatusText().equalsIgnoreCase("PostClosed") && Utilities.split((String)Msg, (char)'|')[2].toUpperCase().indexOf("TRIGGER PRICE IS OUT OF RANGE") >= 0) {
                        this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + this.mediator.myTime.getTime() + " - Limit Price in PostClosed Market should be equal to Close Price", new Color(255, 255, 255), Color.BLACK);
                    }
                    break block38;
                }
                if (Header1.indexOf("ACCOUNT_STATEMENT_END") >= 0) {
                    this.mediator.msgCenter.AddMessageInMsgWin("<>" + MSGTIME + " - Account Statement loaded successfully!");
                } else if (Header1.indexOf("CASH_WITHDRAWAL_STATEMENT_END") >= 0) {
                    this.mediator.msgCenter.AddMessageInMsgWin("<>" + MSGTIME + " - Cash Withdrawal Statement loaded successfully!");
                }
            }
            catch (Exception ex) {
                this.mediator.PrintLog(ex, Msg);
            }
        }
    }

    public void ConnectionStrength(MessageRecieveEvent event) {
    }

    private void SetWebServiceUrl(String Msg) {
        if (AppConfig.WebServiceURL.indexOf(Msg) <= 0) {
            for (int i = 0; i < AppConfig.WebServiceURLList.size(); ++i) {
                if (AppConfig.WebServiceURLList.get(i).toString().indexOf(Msg) <= 0) continue;
                AppConfig.WebServiceURL = AppConfig.WebServiceURLList.get(i).toString();
                try {
                    WebService.SetInstanceNull();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
        }
    }

    private void addMessage(String message, Color fg, Color bg) {
        MessageWindowBean b = new MessageWindowBean(message, fg, bg);
        this.mediator.messages.add(b);
        new Thread(new Runnable(){

            @Override
            public void run() {
                new ReadWrite().write(TradeClient.this.mediator.messages);
            }
        }, "MessageWindowBean Thread").start();
    }

    private void handle_ORDER_EXE_packet(String Msg) {
        String MSGTIME = MyTime.getInstance().getTime();
        String nn = Utilities.split((String)Msg, (char)'|')[2];
        String mm = Utilities.split((String)nn, (char)'^')[1];
        if (Msg.toUpperCase().indexOf("REJ") > 0) {
            String message = "Order<>" + this.mediator.myTime.getTime() + " - " + mm;
            Color fg = new Color(255, 255, 255);
            Color bg = Color.BLACK;
            this.addMessage(message, fg, bg);
            this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
            if (this.mediator.GetMarketStatusText().equalsIgnoreCase("PostClosed") && mm.toUpperCase().indexOf("TRIGGER PRICE IS OUT OF RANGE") >= 0) {
                this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + this.mediator.myTime.getTime() + " - Limit Price in PostClosed Market should be equal to Close Price", new Color(255, 255, 255), Color.BLACK);
            }
        } else if (Msg.toUpperCase().indexOf("BOUGHT") > 0) {
            String message = "Order<>" + this.mediator.myTime.getTime() + " - " + mm;
            Color fg = new Color(0, 199, 206);
            Color bg = new Color(0, 0, 148);
            this.addMessage(message, fg, bg);
            this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
        } else if (Msg.toUpperCase().indexOf("SOLD") > 0) {
            String message = "Order<>" + this.mediator.myTime.getTime() + " - " + mm;
            Color fg = new Color(214, 178, 189);
            Color bg = new Color(222, 8, 181);
            this.addMessage(message, fg, bg);
            this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
        } else if (Msg.toUpperCase().indexOf("CANCELLED PENDING") > 0) {
            if (Msg.toUpperCase().indexOf("BUY") > 0) {
                String message = "Order<>" + this.mediator.myTime.getTime() + " - " + mm;
                Color fg = MyColors.BuyOHRowCancel;
                Color bg = MyColors.BuyOHTxtCancel;
                this.addMessage(message, fg, bg);
                this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
            } else if (Msg.toUpperCase().indexOf("SEL") > 0) {
                String message = "Order<>" + this.mediator.myTime.getTime() + " - " + mm;
                Color fg = MyColors.SelOHRowCancel;
                Color bg = MyColors.SelOHTxtCancel;
                this.addMessage(message, fg, bg);
                this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
            }
        } else if (Msg.toUpperCase().indexOf("PENDING") > 0) {
            if (Msg.toUpperCase().indexOf("BUY") > 0) {
                String message = "Order<>" + this.mediator.myTime.getTime() + " - " + mm;
                Color fg = MyColors.BuyOHRowColor;
                Color bg = MyColors.BuyOHTxtColor;
                this.addMessage(message, fg, bg);
                this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
            } else if (Msg.toUpperCase().indexOf("SELL") > 0) {
                String message = "Order<>" + this.mediator.myTime.getTime() + " - " + mm;
                Color fg = MyColors.SelOHRowColor;
                Color bg = MyColors.SelOHTxtColor;
                this.addMessage(message, fg, bg);
                this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
            }
        } else if (Msg.toUpperCase().indexOf("CANCELLED") > 0) {
            if (Msg.toUpperCase().indexOf("BUY") > -1) {
                String message = "Order<>" + MSGTIME + " - " + mm;
                Color fg = Color.WHITE;
                Color bg = new Color(123, 115, 24);
                this.addMessage(message, fg, bg);
                this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
            } else {
                String message = "Order<>" + MSGTIME + " - " + mm;
                Color fg = Color.WHITE;
                Color bg = new Color(206, 90, 99);
                this.addMessage(message, fg, bg);
                this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
            }
        } else if (Msg.toUpperCase().indexOf("QUEUED") >= 0) {
            mm = mm.replace("NOR ", "");
            mm = mm.replace("SLO ", "");
            mm = mm.replace("Sell Order SHS", "Short Sell Order");
            if (Msg.toUpperCase().indexOf("BUY") >= 0) {
                String message = "Order<>" + MSGTIME + " - " + mm;
                Color fg = Color.WHITE;
                Color bg = new Color(0, 195, 198);
                this.addMessage(message, fg, bg);
                this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
            } else if (Msg.toUpperCase().indexOf("SELL") >= 0) {
                String message = "Order<>" + MSGTIME + " - " + mm;
                Color fg = Color.WHITE;
                Color bg = new Color(208, 108, 169);
                this.addMessage(message, fg, bg);
                this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
            }
        } else {
            if (mm.indexOf(" Error in Line") > 0) {
                String temp1 = "";
                String temp2 = "";
                int index = mm.indexOf(" Error in Line");
                temp1 = mm.substring(0, index - 1);
                if (mm.length() > index + 26) {
                    temp2 = mm.substring(index + 26);
                    mm = temp1 + temp2;
                }
            }
            String message = "Order<>" + this.mediator.myTime.getTime() + " - " + mm;
            Color fg = new Color(255, 255, 255);
            Color bg = Color.BLACK;
            this.addMessage(message, fg, bg);
            this.mediator.msgCenter.AddMessageInMsgWin(message, fg, bg);
        }
    }

    private void handle_PMEX_ORDER_EXE_packet(String Msg) {
        String MSGTIME = MyTime.getInstance().getTime();
        String[] message = Msg.split("\\|", -1);
        String packetType = message[4];
        if (packetType.indexOf("PNOR$") >= 0) {
            this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + message[2], Color.ORANGE, new Color(123, 115, 24));
        } else if (packetType.indexOf("NOR$") >= 0) {
            WorkingOrderBean b = this.makeWorkingOrderBeanAndAddInWorkingOrder(Msg);
            if (b != null && !b.isAlradyAdded()) {
                if (b.getTransactionType().equalsIgnoreCase("Buy")) {
                    this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + message[2], Color.white, new Color(0, 195, 198));
                } else if (b.getTransactionType().equalsIgnoreCase("Sell")) {
                    this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + message[2], Color.WHITE, new Color(208, 108, 169));
                }
            }
        } else if (packetType.indexOf("FIL$") >= 0) {
            TradedOrderBean b = this.makeTradedOrderBeanAndAddInLog(Msg);
            if (b != null) {
                if (b.getTransactionType().equalsIgnoreCase("Buy")) {
                    this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + message[2], new Color(0, 199, 206), new Color(0, 0, 148));
                } else if (b.getTransactionType().equalsIgnoreCase("Sell")) {
                    this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + message[2], new Color(214, 178, 189), new Color(222, 8, 181));
                }
                if (b.getRemainingVolume() <= 0L) {
                    this.removeFromWorkingOrder(b.getOrderID());
                } else {
                    this.updateWorkingOrderRowsOnPartialFill(b);
                }
            }
        } else if (packetType.indexOf("CXLREJ$") >= 0) {
            this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + message[2], Color.WHITE, new Color(123, 115, 24));
        } else if (packetType.indexOf("REJ$") >= 0) {
            this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + message[2], Color.WHITE, Color.RED);
        } else if (packetType.indexOf("PCHG$") >= 0) {
            this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + message[2], Color.WHITE, new Color(123, 115, 24));
        } else if (packetType.indexOf("CHG$") >= 0) {
            this.makeWorkingOrderBeanAndUpdateInWorkingOrder(Msg);
            this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + message[2], Color.WHITE, new Color(223, 115, 224));
        } else if (packetType.indexOf("PCXL$") >= 0) {
            this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + message[2], Color.WHITE, new Color(123, 115, 24));
        } else if (packetType.indexOf("CXL$") >= 0) {
            this.removeFromWorkingOrder(Msg);
            this.mediator.msgCenter.AddMessageInMsgWin("Order<>" + MSGTIME + " - " + message[2], Color.WHITE, new Color(123, 115, 24));
        }
    }

    private WorkingOrderBean makeWorkingOrderBeanAndAddInWorkingOrder(String Msg) {
        WorkingOrderBean b = null;
        if (Msg.indexOf("$") >= 0) {
            String[] messges = Msg.split("\\$", -1);
            b = WorkingOrderBean.parse((String)messges[2]);
            WorkingOrderBean b2 = this.mediator.pmex_WorkingOrder.getExistingOrderBean(b.getOrderID());
            if (b2 != null) {
                b.setIsAlradyAdded(true);
                this.mediator.pmex_WorkingOrder.orderPacketUpdate(b);
            } else {
                this.mediator.pmex_WorkingOrder.orderPacketReceived(b);
            }
        }
        return b;
    }

    private WorkingOrderBean makeWorkingOrderBeanAndUpdateInWorkingOrder(String Msg) {
        WorkingOrderBean b = null;
        if (Msg.indexOf("$") >= 0) {
            String[] messges = Msg.split("\\$", -1);
            b = WorkingOrderBean.parse((String)messges[2]);
            b.setTrader(LogCommon.UserID);
            this.mediator.pmex_WorkingOrder.orderPacketUpdate(b);
        }
        return b;
    }

    private WorkingOrderBean updateWorkingOrderRowsOnPartialFill(TradedOrderBean b) {
        WorkingOrderBean wb = this.mediator.pmex_WorkingOrder.getExistingOrderBean(b.getOrderID());
        if (wb != null) {
            wb.setQuantity(b.getRemainingVolume());
            wb.setClientOrderID(b.getClientOrderID());
            wb.setTrader(LogCommon.UserID);
            this.mediator.pmex_WorkingOrder.orderPacketUpdate(wb);
        }
        return wb;
    }

    private TradedOrderBean makeTradedOrderBeanAndAddInLog(String Msg) {
        TradedOrderBean b = null;
        if (Msg.indexOf("$") >= 0) {
            String[] messges = Msg.split("\\$", -1);
            b = TradedOrderBean.parse((String)messges[2]);
            this.mediator.pmex_TradedOrder.orderPacketReceived(b);
            if (this.mediator.pmex_BuyingPower != null) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(2000L);
                            TradeClient.this.mediator.pmex_BuyingPower.getTraderPositionWebService();
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                }).start();
            }
        }
        return b;
    }

    private void removeFromWorkingOrder(String cancelOrTreadeOrderID) {
        if (cancelOrTreadeOrderID.indexOf("$") >= 0) {
            String[] messges = cancelOrTreadeOrderID.split("\\$", -1);
            this.mediator.pmex_WorkingOrder.removeOrderRow(messges[1]);
            this.mediator.pmex_WorkingOrder.sendMarketOrder(messges[1]);
        } else {
            this.mediator.pmex_WorkingOrder.removeOrderRow(cancelOrTreadeOrderID);
        }
    }

    private void orderExeLogProcess(String[] originalmessage, String responseList) {
        this.mediator.onOrderViewReceiveEvent(originalmessage[4].replace('#', '|'), true);
        if (this.mediator.outStandingLog != null) {
            this.mediator.outStandingLog.UpdateTable();
        }
        if (this.mediator.portfolioWatchAdv != null && LogsTC.accountAll.size() < 50) {
            this.mediator.portfolioWatchAdv.onTradeLogReceived(originalmessage[4].replace('#', '|'), true);
        }
        this.mediator.WriteOrderResponseinFile(responseList);
    }
}

