/*
 * Decompiled with CFR 0.152.
 */
package Ticker;

import MyDocking.Mediator;
import MyDocking.TradeCast;
import Ticker.Ticker;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import kse.util.UtilKSE;
import languages.LanguageConstant;

public class TickerPanel
extends JPanel {
    private int height = 30;
    private int width = 295;
    private int defaultSize = 250;
    private final int padding = 5;
    private Ticker ticker;
    private JSeparator jSeparator1;
    public JLabel lblChange;
    public JLabel lblChangeImage;
    public JLabel lblLtrdPrice;
    public JLabel lblPercentChange;
    public JLabel lblScrip;
    public JLabel lblScripName;
    public JLabel lblTradeVol;

    public TickerPanel(Ticker ticker) {
        this.ticker = ticker;
        this.initComponents();
        this.lblChangeImage.setText("");
        this.lblLtrdPrice.setText("");
        this.lblTradeVol.setText("");
        this.lblPercentChange.setText("");
        this.lblScrip.setText("");
        this.lblScripName.setText("");
        this.lblChange.setText("");
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(false);
        this.setMinimumSize(new Dimension(this.width, this.height));
        this.setMaximumSize(new Dimension(this.width, this.height));
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.setBounds(0, 0, this.width, this.height);
    }

    public void setSize() {
        int yy = 0;
        if (!this.lblScripName.isVisible()) {
            yy = 5;
        }
        int scripWidth = Util.getStringWidth((JLabel)this.lblScrip) + 5;
        int LtrdPriceWidth = Util.getStringWidth((JLabel)this.lblLtrdPrice);
        int changeWidth = Util.getStringWidth((JLabel)this.lblChange) + 5;
        int percentChangeWidth = Util.getStringWidth((JLabel)this.lblPercentChange) + 5;
        int trdWidth = Util.getStringWidth((JLabel)this.lblTradeVol);
        int nameWidth = Util.getStringWidth((JLabel)this.lblScripName);
        this.lblScrip.setBounds(0, yy, scripWidth, 14);
        int widthNow = scripWidth;
        this.lblLtrdPrice.setBounds(widthNow, yy, LtrdPriceWidth, 14);
        this.lblChange.setBounds(widthNow += LtrdPriceWidth, yy, changeWidth, 14);
        this.lblChangeImage.setBounds(widthNow += changeWidth, yy, 18, 14);
        this.lblPercentChange.setBounds(widthNow += 18, yy, percentChangeWidth, 14);
        this.lblTradeVol.setBounds(widthNow += percentChangeWidth, yy, trdWidth, 14);
        if ((widthNow += trdWidth) > nameWidth) {
            this.lblScripName.setBounds(0, 14, widthNow, 12);
            this.jSeparator1.setBounds(widthNow + 5, 0, 3, this.height);
            widthNow += 8;
        } else {
            this.lblScripName.setBounds(0, 14, nameWidth, 12);
            this.jSeparator1.setBounds(nameWidth + 5, 0, 3, this.height);
            widthNow = nameWidth + 8;
        }
        this.setMinimumSize(new Dimension(widthNow += 5, this.height));
        this.setMaximumSize(new Dimension(widthNow, this.height));
        this.setPreferredSize(new Dimension(widthNow, this.height));
        this.setBounds(0, 0, widthNow, this.height);
    }

    private void initComponents() {
        this.lblScrip = new JLabel();
        this.lblLtrdPrice = new JLabel();
        this.lblChange = new JLabel();
        this.lblChangeImage = new JLabel();
        this.lblPercentChange = new JLabel();
        this.lblTradeVol = new JLabel();
        this.lblScripName = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                TickerPanel.this.formMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                TickerPanel.this.formMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                TickerPanel.this.formMousePressed(evt);
            }
        });
        this.setLayout(null);
        this.lblScrip.setForeground(new Color(29, 58, 252));
        this.lblScrip.setHorizontalAlignment(2);
        this.lblScrip.setText("ASMLRAL-NOV");
        this.lblScrip.setMinimumSize(new Dimension(0, 14));
        this.lblScrip.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                TickerPanel.this.lblScripMousePressed(evt);
            }
        });
        this.add(this.lblScrip);
        this.lblScrip.setBounds(0, 0, 70, 14);
        this.lblLtrdPrice.setForeground(new Color(29, 58, 252));
        this.lblLtrdPrice.setHorizontalAlignment(4);
        this.lblLtrdPrice.setText("8,888.88");
        this.add(this.lblLtrdPrice);
        this.lblLtrdPrice.setBounds(72, 0, 44, 14);
        this.lblChange.setForeground(new Color(29, 58, 252));
        this.lblChange.setHorizontalAlignment(4);
        this.lblChange.setText("(-888.88");
        this.add(this.lblChange);
        this.lblChange.setBounds(120, 0, 44, 14);
        this.lblChangeImage.setForeground(new Color(29, 58, 252));
        this.lblChangeImage.setHorizontalAlignment(0);
        this.lblChangeImage.setIcon(new ImageIcon(this.getClass().getResource("/Images/level.png")));
        this.lblChangeImage.setText(")");
        this.lblChangeImage.setHorizontalTextPosition(4);
        this.add(this.lblChangeImage);
        this.lblChangeImage.setBounds(164, 0, 18, 14);
        this.lblPercentChange.setForeground(new Color(29, 58, 252));
        this.lblPercentChange.setText("-8.88%)");
        this.add(this.lblPercentChange);
        this.lblPercentChange.setBounds(184, 0, 45, 14);
        this.lblTradeVol.setForeground(new Color(29, 58, 252));
        this.lblTradeVol.setHorizontalAlignment(2);
        this.lblTradeVol.setText("88,888,888");
        this.add(this.lblTradeVol);
        this.lblTradeVol.setBounds(230, 0, 56, 14);
        this.lblScripName.setFont(new Font("Tahoma", 0, 9));
        this.lblScripName.setForeground(new Color(29, 58, 252));
        this.lblScripName.setHorizontalAlignment(0);
        this.lblScripName.setText("Pakistan Petrolium Limited");
        this.lblScripName.setVerticalAlignment(1);
        this.add(this.lblScripName);
        this.lblScripName.setBounds(0, 14, 290, 12);
        this.jSeparator1.setOrientation(1);
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(288, 0, 3, 30);
    }

    private void lblScripMousePressed(MouseEvent evt) {
    }

    private void formMousePressed(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt)) {
            if (AppConfig.isHistoricalDataWatch) {
                this.openScripDetail();
            } else {
                this.openDetailQuote();
            }
        } else {
            this.ticker.popup.show(this, evt.getX(), evt.getY());
        }
    }

    private void formMouseEntered(MouseEvent evt) {
        this.ticker.VP.StopTicker = true;
    }

    private void formMouseExited(MouseEvent evt) {
        this.ticker.VP.StopTicker = false;
    }

    private void openDetailQuote() {
        try {
            TradeCast.getInstance().ShowDynamicForm(FormName.DetailedQuote, LanguageConstant.DetailedQuote);
            if (Mediator.getInstance().detailedQuote != null) {
                Mediator.getInstance().detailedQuote.AddSymbol(UtilKSE.GetMarketFromsymbol((String)this.lblScrip.getText()), this.lblScrip.getText());
                Mediator.getInstance().detailedQuote.setTitle("");
            }
        }
        catch (Exception ex) {
            Mediator.getInstance().PrintLog(ex, "");
        }
    }

    private void openScripDetail() {
        try {
            Mediator.getInstance().openScripDetails(this.lblScrip.getText());
        }
        catch (Exception ex) {
            Mediator.getInstance().PrintLog(ex, "");
        }
    }
}

