/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import Beans.MarketWatchBean;
import CATALYST.Control.ColumnData;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MarketWatchEvent;
import CATALYST.Control.MarketWatchListner;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import Watches.HistoricalValuePanelContainer;
import common.gui.component.JTextFieldFilter;
import common.gui.component.NxGScrollBarUI;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.interfaces.MarketData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.text.Document;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXCollapsiblePane;

public class FutureWatchHistorical
extends JPanel
implements MarketWatchListner,
MarketData,
ActionListener {
    private HistoricalValuePanelContainer pnlHistoricalDataContainer = null;
    private Mediator mediator = Mediator.getInstance();
    public MarketWatch Mwh;
    public MarketWatch MwhSpread;
    private String FutureSymbols = "";
    private boolean isLoadFuture = true;
    public boolean isSpread = false;
    private int spreadColumnWidth = 80;
    private String lastScrip = "";
    private String lastMarket = "";
    private boolean isLastScrip = false;
    private int dividerSize = 88;
    JScrollPane spliterScrollPane = new JScrollPane();
    private HashMap<String, Integer> columnIndexFurute = new HashMap();
    private HashMap<String, Integer> columnIndexRegularFurute = new HashMap();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnAnnualStatement;
    private JToggleButton btnChange;
    private JButton btnDetail;
    private JButton btnQuarterlyStatement;
    private JButton btnScripDetail;
    private JXCollapsiblePane collapsiblePane;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JToolBar jToolBar1;
    private JLabel lblNew;
    private JLabel lblScripBrowse;
    private JLabel lblSymbol;
    private JLabel lblSymbolName;
    private JPanel pnlTools;
    private JPanel pnlWatch;
    private JRadioButton rdFuture;
    private JRadioButton rdRegularFuture;
    private JSplitPane splitPane;
    private JTextField txtSymbol;

    private void setColumnIndexFuture() {
        int index = 0;
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.Market), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.Scrip), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("BuyVol"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.Buy), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.Sell), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("SellVol"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.LastPrice), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("Change"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.High), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.Low), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.TotalVolume), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.Average), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.PercentChange), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.LowerLock), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.UpperCap), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.Trade), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.CompanySnapshot), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("MarketCap"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("Period"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("P/E"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("DividendYield"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("P/B"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("EPS"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("Dir"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("LTrdTime"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("TotalTrd"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("LTrdVolume"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.ClosePrice), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.OpenPrice), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.State), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue(LanguageConstant.Flag), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("OutstandingShares"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("52WeekLow"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("52WeekAvg"), index++);
        this.columnIndexFurute.put(this.languageCentre.getValue("52WeekHigh"), index++);
    }

    private void setColumnIndexRegularFuture() {
        int index = 0;
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.Market), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.Scrip), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("BuyVol"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.Buy), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.Sell), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("SellVol"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.LastPrice), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("Change"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.High), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.Low), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.TotalVolume), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.Average), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.PercentChange), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.LowerLock), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.UpperCap), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.Trade), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.CompanySnapshot), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("MarketCap"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("Period"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("Spread"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("P/E"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("DividendYield"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("P/B"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("EPS"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("Dir"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("LTrdTime"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("TotalTrd"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("LTrdVolume"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.ClosePrice), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.OpenPrice), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.State), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue(LanguageConstant.Flag), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("OutstandingShares"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("52WeekLow"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("52WeekAvg"), index++);
        this.columnIndexRegularFurute.put(this.languageCentre.getValue("52WeekHigh"), index++);
    }

    public FutureWatchHistorical() {
        try {
            this.initComponents();
            this.setColumnIndexFuture();
            this.setColumnIndexRegularFuture();
            this.mediator.setFutureWatchHistorical(this);
            this.Mwh = new MarketWatch(LanguageConstant.FutureWatch, this.columnIndexFurute);
            this.MwhSpread = new MarketWatch(LanguageConstant.FutureWatch, this.columnIndexRegularFurute);
            if (MarketWatch.isCalculatePercentage) {
                this.spreadColumnWidth = 150;
            }
            this.pnlHistoricalDataContainer = new HistoricalValuePanelContainer(this, this.lblSymbolName);
            ColumnData[] m_columns = new ColumnData[]{new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Scrip), 100, 2), new ColumnData(this.Mwh, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.High), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Low), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LowerLock), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.UpperCap), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Trade), 80, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.CompanySnapshot), 150, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Analytics), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Graph), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("MarketCap"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Period"), 80, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("P/E"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("DividendYield"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("P/B"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("EPS"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.OpenPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.State), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue("OutstandingShares"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekLow"), 90, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekAvg"), 90, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekHigh"), 90, 4)};
            ColumnData[] m_columns_spread = new ColumnData[]{new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.Scrip), 100, 2), new ColumnData(this.MwhSpread, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.High), 70, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.Low), 70, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.LowerLock), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.UpperCap), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.Trade), 80, 0), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.CompanySnapshot), 150, 0), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.Analytics), 100, 0), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.Graph), 100, 0), new ColumnData(this.MwhSpread, this.languageCentre.getValue("MarketCap"), 120, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("Period"), 80, 0), new ColumnData(this.MwhSpread, this.languageCentre.getValue("Spread"), this.spreadColumnWidth, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("P/E"), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("DividendYield"), 120, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("P/B"), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("EPS"), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.MwhSpread, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.OpenPrice), 80, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.State), 50, 2), new ColumnData(this.MwhSpread, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2), new ColumnData(this.MwhSpread, this.languageCentre.getValue("OutstandingShares"), 120, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("52WeekLow"), 90, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("52WeekAvg"), 90, 4), new ColumnData(this.MwhSpread, this.languageCentre.getValue("52WeekHigh"), 90, 4)};
            this.Mwh.isHistoricalDataWatch = AppConfig.isHistoricalDataWatch;
            this.Mwh.ChangeAllColorAndFonts(MyColors.MarketWatchRowColor, MyColors.MarketWatchSelectedRowColor, MyColors.MarketWatchIncreaseColor, MyColors.MarketWatchDecreaseColor, LogCommon.MarketWatchFont);
            this.Mwh.SetHeight = new JFrame().getToolkit().getScreenSize().height - 500;
            this.Mwh.SetWidth = new JFrame().getToolkit().getScreenSize().width + 130;
            this.Mwh.setMarket(LogCommon.markets);
            this.Mwh.Debug = false;
            this.Mwh.addListener((MarketWatchListner)this);
            this.Mwh.isUserAddScrip = false;
            this.Mwh.isDuplicateScrip = false;
            this.Mwh.ShowTradeButton = AppConfig.ShowTradeButton;
            this.Mwh.ShowCompanySnapButton = AppConfig.ShowCompanySnapshotButton;
            this.Mwh.ShowGraphButton = AppConfig.ShowGraphButton;
            this.Mwh.ShowAnalyticsButton = AppConfig.ShowAnalyticsButton;
            this.Mwh.isStandardCapital = AppConfig.isStandardCapital;
            this.Mwh.init(m_columns);
            this.Mwh.setDefaultColumnIndex();
            this.Mwh.comboBox.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
            this.Mwh.comboBox.removeItem("");
            this.MwhSpread.isHistoricalDataWatch = AppConfig.isHistoricalDataWatch;
            this.MwhSpread.ChangeAllColorAndFonts(MyColors.MarketWatchRowColor, MyColors.MarketWatchSelectedRowColor, MyColors.MarketWatchIncreaseColor, MyColors.MarketWatchDecreaseColor, LogCommon.MarketWatchFont);
            this.MwhSpread.SetHeight = new JFrame().getToolkit().getScreenSize().height - 500;
            this.MwhSpread.SetWidth = new JFrame().getToolkit().getScreenSize().width + 130;
            this.MwhSpread.setMarket(LogCommon.markets);
            this.MwhSpread.Debug = false;
            this.MwhSpread.addListener((MarketWatchListner)this);
            this.MwhSpread.isUserAddScrip = false;
            this.MwhSpread.isDuplicateScrip = true;
            this.MwhSpread.ShowTradeButton = AppConfig.ShowTradeButton;
            this.MwhSpread.ShowCompanySnapButton = AppConfig.ShowCompanySnapshotButton;
            this.MwhSpread.ShowGraphButton = AppConfig.ShowGraphButton;
            this.MwhSpread.ShowAnalyticsButton = AppConfig.ShowAnalyticsButton;
            this.MwhSpread.isStandardCapital = AppConfig.isStandardCapital;
            this.MwhSpread.init(m_columns_spread);
            this.MwhSpread.setDefaultColumnIndex();
            this.MwhSpread.comboBox.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
            this.MwhSpread.comboBox.removeItem("");
            this.MwhSpread.m_table.moveColumn(this.MwhSpread.m_table.getColumnModel().getColumnIndex(this.languageCentre.getValue("Spread")), 6);
            this.txtSymbol.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    FutureWatchHistorical.this.txtSymbol.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
            this.lblScripBrowse.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
            this.lblScripBrowse.setIcon(new ImageIcon(this.getClass().getResource("/Images/symDetail2.png")));
            this.lblScripBrowse.setVisible(true);
            this.lblSymbolName.setFont(this.lblSymbolName.getFont().deriveFont(1));
            this.lblSymbol.setFont(this.lblSymbol.getFont().deriveFont(1));
            this.rdFuture.addActionListener(this);
            this.rdRegularFuture.addActionListener(this);
            this.rdFuture.setActionCommand("Future");
            this.rdRegularFuture.setActionCommand("Regular / Future");
            this.rdFuture.setSelected(true);
            ButtonGroup group = new ButtonGroup();
            group.add(this.rdFuture);
            group.add(this.rdRegularFuture);
            this.lblScripBrowse.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ((FutureWatchHistorical)FutureWatchHistorical.this).mediator.tradecast.ShowDynamicForm(FormName.ScripBrowse, LanguageConstant.ScripBrowse);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    FutureWatchHistorical.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(12));
                    FutureWatchHistorical.this.lblScripBrowse.setText("<html><u><b>" + FutureWatchHistorical.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></u></html>");
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FutureWatchHistorical.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(0));
                    FutureWatchHistorical.this.lblScripBrowse.setText("<html><b>" + FutureWatchHistorical.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
                }
            });
            this.txtSymbol.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        String symbol = FutureWatchHistorical.this.txtSymbol.getText();
                        Object sm = null;
                        if (symbol.indexOf("-") > 1) {
                            if (FutureWatchHistorical.this.FutureSymbols.indexOf(symbol) > 0) {
                                FutureWatchHistorical.this.Mwh.AddSymbolInMarketWatch(symbol + ";" + UtilKSE.GetMarketFromsymbol((String)FutureWatchHistorical.this.txtSymbol.getText()), false, false);
                            } else {
                                FutureWatchHistorical.this.txtSymbol.select(0, FutureWatchHistorical.this.txtSymbol.getText().length());
                            }
                            return;
                        }
                        FutureWatchHistorical.this.txtSymbol.select(0, FutureWatchHistorical.this.txtSymbol.getText().length());
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
            this.collapsiblePane.add((Component)this.pnlHistoricalDataContainer);
            JPanel pnl = new JPanel();
            pnl.setBackground(Color.red);
            pnl.setLayout(new BorderLayout());
            pnl.add((Component)this.collapsiblePane, "Center");
            this.spliterScrollPane.setHorizontalScrollBarPolicy(30);
            this.spliterScrollPane.setVerticalScrollBarPolicy(20);
            UIManager.put("ScrollBar.background", 1);
            JScrollBar vbar = this.spliterScrollPane.getVerticalScrollBar();
            NxGScrollBarUI ui2 = new NxGScrollBarUI();
            ui2.setMyScrollBarUI(vbar);
            vbar.setPreferredSize(new Dimension(7, 0));
            this.spliterScrollPane.setHorizontalScrollBarPolicy(30);
            this.spliterScrollPane.setViewportView(pnl);
            this.splitPane.setBorder(null);
            this.splitPane.setLeftComponent(this.spliterScrollPane);
            this.setCollaspe();
            this.empty();
            this.isSpread = false;
            this.pnlWatch.add((Component)this.Mwh, "Center");
            this.pnlWatch.revalidate();
            this.setFutureSymbol(this.FutureSymbols, true);
            this.btnScripDetail.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/scripDetail.png")));
            this.btnAnnualStatement.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/AnnualStatements.png")));
            this.btnQuarterlyStatement.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/QuarterlyStatement.png")));
            if (LogCommon.NewCount > 2) {
                this.jToolBar1.remove(this.lblNew);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLanguageValues();
    }

    public synchronized void MarketWatchMessageReceived(MarketWatchEvent event) {
        this.mediator.MarketWatchMessageReceived(event, this);
    }

    public void SymbolChange(String string) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.rdFuture.isSelected()) {
            if (this.isSpread) {
                this.setFutureSymbol(this.FutureSymbols, true);
                this.isSpread = false;
                this.pnlWatch.remove((Component)this.MwhSpread);
                this.pnlWatch.add((Component)this.Mwh, "Center");
            }
        } else if (this.rdRegularFuture.isSelected() && !this.isSpread) {
            this.setFutureSymbol(this.getScripWithRegular(this.FutureSymbols), true);
            this.isSpread = true;
            this.pnlWatch.remove((Component)this.Mwh);
            this.pnlWatch.add((Component)this.MwhSpread, "Center");
        }
    }

    public void GetSymbol() {
        if (this.isLoadFuture) {
            LoadLogs log = new LoadLogs("GetFutureSymbol=", true);
            new ThreadWithName(log, "GetFutureSymbol").start();
            LoadLogs log2 = new LoadLogs("GetFutureRemainingDays=", true);
            new ThreadWithName(log2, "GetFutureRemainingDays").start();
        } else {
            this.SendFeedRequest();
        }
    }

    public void setFutureSymbol(String str, boolean isReload) {
        if (str.trim().length() <= 0) {
            return;
        }
        this.isLoadFuture = false;
        if (!isReload) {
            this.FutureSymbols = str;
        }
        this.SendFeedRequest();
        this.Mwh.RemoveAllSymbolFromWatch();
        this.MwhSpread.RemoveAllSymbolFromWatch();
        String[] Symbols = str.split("\\|", -1);
        this.isLastScrip = false;
        for (int i = 0; i < Symbols.length; ++i) {
            if (Symbols[i].length() <= 0) continue;
            if (this.rdFuture.isSelected()) {
                this.Mwh.AddSymbolInMarketWatch(Symbols[i].replace(':', ';'), false, false);
                continue;
            }
            this.MwhSpread.AddSymbolInMarketWatch(Symbols[i].replace(':', ';'), false, false);
        }
        this.mediator.setMarketData("MarketWatchAllScrip", str.replaceAll("\\|", ";"), "", null, this);
        this.isLastScrip = true;
        if (this.rdFuture.isSelected()) {
            this.Mwh.SelectRow(0);
        } else {
            this.MwhSpread.SelectRow(0);
        }
        Util.ScrollToFirstOrLastRow((boolean)true, (JTable)this.Mwh.GetTable(), (JScrollPane)this.Mwh.scrollPane);
    }

    public void setFutureRemainingDays(String result) {
        String[] furRemain = result.split("\\|", -1);
        for (int i = 0; i < furRemain.length; ++i) {
            if (furRemain[i].length() <= 0) continue;
            String[] ss = furRemain[i].split("\\:", -1);
            MarketWatch.SettleRemainingDays.put(ss[0], Integer.parseInt(ss[1]));
        }
    }

    public void SendFeedRequest() {
        if ((this.FutureSymbols != null || !this.FutureSymbols.equalsIgnoreCase("")) && this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FutureWatch))) {
            if (this.rdFuture.isSelected()) {
                this.mediator.SendMsgToFeedServer("MKT-FEED|" + this.FutureSymbols.replaceAll("\\|", ";"), "Future Watch Historical (Future Symbol only): SendFeedRequest");
            } else {
                this.mediator.SendMsgToFeedServer("MKT-FEED|" + this.getScripWithRegular(this.FutureSymbols).replaceAll("\\|", ";"), " Future Watch Historical (Future/ Regular Symbol only): SendFeedRequest");
            }
        }
    }

    public void SetEmpty(String symbol, boolean isNew) {
        this.txtSymbol.setText("");
        this.lblSymbolName.setText("");
        this.lastMarket = "";
        this.lastScrip = "";
        this.pnlHistoricalDataContainer.empty();
    }

    public void SetSymbol(String symbol, boolean isNew) {
        this.txtSymbol.setText(symbol);
        String market = UtilKSE.GetMarketFromsymbol((String)symbol);
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText("Invalid Scrip");
        } else {
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        }
        this.lastMarket = market;
        this.lastScrip = symbol;
        if (this.isLastScrip && !isNew && !this.collapsiblePane.isCollapsed()) {
            this.addHistoricalData(market, symbol);
        }
    }

    public void SetSymbol(String symbol) {
        this.txtSymbol.setText(symbol);
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText("Invalid Scrip");
        } else {
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        }
    }

    private String getScripWithRegular(String futureSymbol) {
        StringBuilder ScripWithRegular = new StringBuilder();
        if (futureSymbol.indexOf("|") >= 0) {
            String[] fut;
            for (String futSingle : fut = futureSymbol.split("\\|", -1)) {
                if (futSingle.indexOf("-") < 0) continue;
                ScripWithRegular.append(futSingle.split("\\-", -1)[0]).append(":REG|").append(futSingle).append("|").append("-:-|");
            }
        }
        return ScripWithRegular.toString();
    }

    private void setCollaspe() {
        boolean state = this.collapsiblePane.isCollapsed();
        if (state) {
            this.btnDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
            this.addHistoricalData(this.lastMarket, this.lastScrip);
            this.splitPane.setDividerLocation(this.dividerSize);
            this.splitPane.setDividerSize(5);
        } else {
            this.btnDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
            this.splitPane.setDividerLocation(0);
            this.splitPane.setDividerSize(0);
            this.spliterScrollPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (FutureWatchHistorical.this.collapsiblePane.isCollapsed()) {
                        FutureWatchHistorical.this.spliterScrollPane.setMinimumSize(new Dimension(0, 0));
                    } else if (FutureWatchHistorical.this.btnChange.isSelected()) {
                        FutureWatchHistorical.this.spliterScrollPane.setMinimumSize(new Dimension(0, 40));
                    } else {
                        FutureWatchHistorical.this.spliterScrollPane.setMinimumSize(new Dimension(0, 20));
                    }
                }
            });
        }
        this.splitPane.setEnabled(state);
        this.collapsiblePane.setCollapsed(!state);
    }

    private void initComponents() {
        this.pnlTools = new JPanel();
        this.lblScripBrowse = new JLabel();
        this.lblSymbol = new JLabel();
        this.txtSymbol = new JTextField();
        this.lblSymbolName = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblNew = new JLabel();
        this.btnScripDetail = new JButton();
        this.btnAnnualStatement = new JButton();
        this.btnQuarterlyStatement = new JButton();
        this.btnDetail = new JButton();
        this.btnChange = new JToggleButton();
        this.rdFuture = new JRadioButton();
        this.rdRegularFuture = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.splitPane = new JSplitPane();
        this.collapsiblePane = new JXCollapsiblePane();
        this.pnlWatch = new JPanel();
        this.pnlTools.setPreferredSize(new Dimension(470, 26));
        this.lblScripBrowse.setIcon(new ImageIcon(this.getClass().getResource("/Images/symDetail2.png")));
        this.lblScripBrowse.setText("Scrip Browse");
        this.lblSymbol.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.lblSymbol.setText("Scrip");
        this.lblSymbol.setHorizontalTextPosition(2);
        this.txtSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FutureWatchHistorical.this.txtSymbolFocusGained(evt);
            }
        });
        this.lblSymbolName.setText("name");
        this.lblSymbolName.setMinimumSize(new Dimension(0, 14));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMaximumSize(new Dimension(65, 25));
        this.jToolBar1.setMinimumSize(new Dimension(65, 25));
        this.jToolBar1.setPreferredSize(new Dimension(65, 25));
        this.jToolBar1.add(this.filler1);
        this.lblNew.setIcon(new ImageIcon(this.getClass().getResource("/Images/new.gif")));
        this.lblNew.setMaximumSize(new Dimension(30, 21));
        this.lblNew.setMinimumSize(new Dimension(30, 21));
        this.lblNew.setPreferredSize(new Dimension(30, 21));
        this.jToolBar1.add(this.lblNew);
        this.btnScripDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnScripDetail.setToolTipText("Scrip Details");
        this.btnScripDetail.setFocusable(false);
        this.btnScripDetail.setHorizontalTextPosition(0);
        this.btnScripDetail.setName("FutureWatchHistorical -> btnScripDetail");
        this.btnScripDetail.setVerticalTextPosition(3);
        this.btnScripDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FutureWatchHistorical.this.btnScripDetailActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnScripDetail);
        this.btnAnnualStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnAnnualStatement.setToolTipText("Annual Statements");
        this.btnAnnualStatement.setFocusable(false);
        this.btnAnnualStatement.setHorizontalTextPosition(0);
        this.btnAnnualStatement.setName("FutureWatchHistorical -> btnAnnualStatement");
        this.btnAnnualStatement.setVerticalTextPosition(3);
        this.btnAnnualStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FutureWatchHistorical.this.btnAnnualStatementActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnAnnualStatement);
        this.btnQuarterlyStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnQuarterlyStatement.setToolTipText("Quarterly Statements");
        this.btnQuarterlyStatement.setFocusable(false);
        this.btnQuarterlyStatement.setHorizontalTextPosition(0);
        this.btnQuarterlyStatement.setName("FutureWatchHistorical -> btnQuarterlyStatement");
        this.btnQuarterlyStatement.setVerticalTextPosition(3);
        this.btnQuarterlyStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FutureWatchHistorical.this.btnQuarterlyStatementActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnQuarterlyStatement);
        this.btnDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
        this.btnDetail.setText("Details");
        this.btnDetail.setToolTipText("Details");
        this.btnDetail.setFocusable(false);
        this.btnDetail.setHorizontalTextPosition(4);
        this.btnDetail.setMaximumSize(new Dimension(65, 23));
        this.btnDetail.setMinimumSize(new Dimension(65, 23));
        this.btnDetail.setName("FutureWatchHistorical -> btnDetail");
        this.btnDetail.setVerticalTextPosition(3);
        this.btnDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FutureWatchHistorical.this.btnDetailActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnDetail);
        this.btnChange.setIcon(new ImageIcon(this.getClass().getResource("/Images/switch16.png")));
        this.btnChange.setFocusable(false);
        this.btnChange.setHorizontalTextPosition(0);
        this.btnChange.setName("FutureWatchHistorical -> btnChange");
        this.btnChange.setVerticalTextPosition(3);
        this.btnChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FutureWatchHistorical.this.btnChangeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnChange);
        this.rdFuture.setSelected(true);
        this.rdFuture.setText("Future");
        this.rdRegularFuture.setText("Regular / Future");
        GroupLayout pnlToolsLayout = new GroupLayout(this.pnlTools);
        this.pnlTools.setLayout(pnlToolsLayout);
        pnlToolsLayout.setHorizontalGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlToolsLayout.createSequentialGroup().addContainerGap().addComponent(this.lblScripBrowse, -2, 95, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSymbolName, -1, 36, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rdFuture, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdRegularFuture, -2, 118, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jToolBar1, -2, 193, -2)));
        pnlToolsLayout.setVerticalGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlToolsLayout.createSequentialGroup().addGap(2, 2, 2).addGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblScripBrowse, -2, 22, -2).addComponent(this.lblSymbol, -2, 22, -2).addComponent(this.txtSymbol, -2, 22, -2).addGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSymbolName, -2, 22, -2).addComponent(this.rdFuture).addComponent(this.rdRegularFuture)).addComponent(this.jToolBar1, -2, 22, -2))));
        this.splitPane.setOrientation(0);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setLeftComponent((Component)this.collapsiblePane);
        this.pnlWatch.setLayout(new BorderLayout());
        this.splitPane.setBottomComponent(this.pnlWatch);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, GroupLayout.Alignment.TRAILING));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, -1, 184, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlTools, -1, 643, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlTools, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)));
    }

    private void btnDetailActionPerformed(ActionEvent evt) {
        this.setCollaspe();
    }

    private void txtSymbolFocusGained(FocusEvent evt) {
        this.txtSymbol.selectAll();
    }

    private void btnChangeActionPerformed(ActionEvent evt) {
        this.pnlHistoricalDataContainer.setLayout();
        this.dividerSize = this.btnChange.isSelected() ? 160 : 88;
        if (this.splitPane.getDividerSize() > 0) {
            this.splitPane.setDividerLocation(this.dividerSize);
        }
    }

    private void btnAnnualStatementActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.Statement, LanguageConstant.AnnualStatements);
    }

    private void btnQuarterlyStatementActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.QuarterStatement, LanguageConstant.QuarterlyStatements);
    }

    private void btnScripDetailActionPerformed(ActionEvent evt) {
        this.mediator.openScripDetails(LogsKSE.SelectedSymbol);
        LogCommon.NewCount += 2;
    }

    public void addHistoricalData(String market, String scrip) {
        if (scrip.length() > 0) {
            Util.setMessage((JLabel)this.lblSymbolName, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
            this.pnlHistoricalDataContainer.addHistoricalData(market, scrip);
        }
    }

    public void setMarketData(String market, String scrip, MarketWatchBean b) {
        if (this.rdFuture.isSelected()) {
            this.Mwh.setMarketData(market, scrip, b.period, b.marketcap, b.pricetoearning, b.dividendYield, b.pricetobook, b.eps, b.outstandingshares, b._52weekavgvol, b._52weekhigh, b._52weeklow);
        } else if (this.rdRegularFuture.isSelected()) {
            this.MwhSpread.setMarketData(market, scrip, b.period, b.marketcap, b.pricetoearning, b.dividendYield, b.pricetobook, b.eps, b.outstandingshares, b._52weekavgvol, b._52weekhigh, b._52weeklow);
        }
    }

    public void SymbolRemove(String Symbol, String Market) {
        this.Mwh.RemoveSymbolFromWatch(Symbol + ";" + Market);
    }

    public void SymbolRemove(String string, boolean b) {
        this.empty();
    }

    private void empty() {
        this.lblSymbolName.setText("");
        this.txtSymbol.setText("");
        this.pnlHistoricalDataContainer.empty();
    }

    private void setLanguageValues() {
        this.lblScripBrowse.setText(this.languageCentre.getValue(LanguageConstant.ScripBrowse));
        this.lblSymbol.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.btnScripDetail.setToolTipText(this.languageCentre.getValue(LanguageConstant.ScripDetail));
        this.btnAnnualStatement.setToolTipText(this.languageCentre.getValue(LanguageConstant.AnnualStatements));
        this.btnQuarterlyStatement.setToolTipText(this.languageCentre.getValue(LanguageConstant.QuarterlyStatements));
        this.btnDetail.setText(this.languageCentre.getValue(LanguageConstant.Details));
        this.btnDetail.setToolTipText(this.languageCentre.getValue(LanguageConstant.Details));
        this.rdFuture.setText(this.languageCentre.getValue(LanguageConstant.Future));
        this.rdRegularFuture.setText(this.languageCentre.getValue(LanguageConstant.RegularFuture));
    }
}

