/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import Beans.TechnicalsBean;
import Beans.ValueBean;
import BeansContainer.AllContainer;
import BeansContainer.FundamentalsContainer;
import BeansContainer.PerformanceContainer;
import BeansContainer.TechnicalsContainer;
import BeansContainer.ValuationContainer;
import CATALYST.Control.MarketFeed;
import MyDocking.Mediator;
import Utilities.LogsTC;
import com.google.gson.Gson;
import common.gui.component.NxGHeaderPanel;
import common.gui.component.NxGScrollBarUI;
import common.gui.component.NxGScrollPane;
import common.gui.layout.NxGWrapLayout;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.interfaces.MarketData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kse.gui.HeaderPanel;
import kse.gui.ValuePanelColumn;
import kse.gui.ValuePanelRow;
import kse.util.HistoricalDataType;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class HistoricalValuePanelContainer
extends JPanel {
    private BufferedImage img2;
    private ImageIcon img;
    private final int Width = 220;
    private final int Height = 145;
    private final int HeaderHeightColumn = 30;
    private final int HeaderWidthColumn = 218;
    private final int HeaderHeightRow = 20;
    private final int HeaderWidthRow = 110;
    public static final int DividerSizeRow = 88;
    public static final int DividerSizeColumn = 160;
    private boolean isVerticalLayout = false;
    private String market;
    private String scrip;
    private Color bgColor = Color.WHITE;
    private int scrollPaneWidth = 0;
    private int PnlDataWidth = 0;
    private final JLabel lblMessage;
    private LanguageCentre languageCentre = new LanguageCentre();

    public HistoricalValuePanelContainer(MarketData marketWatchHistoricalData, JLabel lblMessage) {
        this.initComponents();
        this.setLayoutPanel();
        this.setBorder(BorderFactory.createEmptyBorder());
        this.lblMessage = lblMessage;
    }

    private void setLayoutPanel() {
        if (this.isVerticalLayout) {
            NxGWrapLayout n = new NxGWrapLayout();
            this.setLayout((LayoutManager)n);
        } else {
            BoxLayout box = new BoxLayout(this, 1);
            this.setLayout(box);
        }
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 391, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 116, Short.MAX_VALUE));
    }

    public void setLayout() {
        this.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.isVerticalLayout = !this.isVerticalLayout;
        this.setLayoutPanel();
        this.addHistoricalData(this.market, this.scrip);
    }

    private void addHeaderColumn(JPanel p, HistoricalDataType type) {
        ImageIcon icon = null;
        if (type == HistoricalDataType.Fundamentals) {
            icon = new ImageIcon(this.getClass().getResource("/Images/fundamental24.png"));
        } else if (type == HistoricalDataType.Performance) {
            icon = new ImageIcon(this.getClass().getResource("/Images/performance24.png"));
        } else if (type == HistoricalDataType.Technicals) {
            icon = new ImageIcon(this.getClass().getResource("/Images/technical24.png"));
        } else if (type == HistoricalDataType.Valuations) {
            icon = new ImageIcon(this.getClass().getResource("/Images/valuation24.png"));
        }
        NxGHeaderPanel lblTitle = new NxGHeaderPanel();
        lblTitle.setHeading(type.toString());
        lblTitle.setHeaderImage(icon);
        lblTitle.setPreferredSize(new Dimension(218, 30));
        p.add((Component)lblTitle);
    }

    private void addValuesPanelColumn(HistoricalDataType type, List list) {
        JLabel lblSpace = new JLabel();
        lblSpace.setPreferredSize(new Dimension(220, 5));
        NxGWrapLayout layoutSingleData = new NxGWrapLayout(0);
        layoutSingleData.setHgap(0);
        layoutSingleData.setVgap(0);
        JPanel pnlSingleData = new JPanel((LayoutManager)layoutSingleData);
        pnlSingleData.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
        pnlSingleData.setPreferredSize(new Dimension(220, 145));
        NxGWrapLayout layoutData = new NxGWrapLayout(1);
        layoutData.setHgap(2);
        layoutData.setVgap(2);
        JPanel pnlData = new JPanel((LayoutManager)layoutData);
        JScrollPane scrollPane = new JScrollPane(pnlData);
        UIManager.put("ScrollBar.background", 1);
        JScrollBar vbar = scrollPane.getVerticalScrollBar();
        NxGScrollBarUI ui2 = new NxGScrollBarUI();
        ui2.setMyScrollBarUI(vbar);
        vbar.setPreferredSize(new Dimension(7, 0));
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setPreferredSize(new Dimension(218, 112));
        scrollPane.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0, 0)));
        this.addHeaderColumn(pnlSingleData, type);
        for (int i = 0; i < list.size(); ++i) {
            ValueBean bean = (ValueBean)list.get(i);
            ValuePanelColumn pnlValue = new ValuePanelColumn(bean.title, bean.title_tooltip, bean.value, bean.value_tooltip, bean.color);
            pnlData.add((Component)pnlValue);
        }
        pnlSingleData.add(scrollPane);
        this.add(pnlSingleData);
        this.repaint();
    }

    private void addHeaderRow(JPanel p, HistoricalDataType type, JSeparator sepRow) {
        ImageIcon icon = null;
        if (type == HistoricalDataType.Fundamentals) {
            icon = new ImageIcon(this.getClass().getResource("/Images/fundamental12.png"));
        } else if (type == HistoricalDataType.Performance) {
            icon = new ImageIcon(this.getClass().getResource("/Images/performance12.png"));
        } else if (type == HistoricalDataType.Technicals) {
            icon = new ImageIcon(this.getClass().getResource("/Images/technical12.png"));
        } else if (type == HistoricalDataType.Valuations) {
            icon = new ImageIcon(this.getClass().getResource("/Images/valuation12.png"));
        }
        HeaderPanel pnlTitle = new HeaderPanel();
        pnlTitle.setHeading(type.toString());
        pnlTitle.setHeaderImage(icon);
        pnlTitle.setPreferredSize(new Dimension(110, 20));
        pnlTitle.setSize(new Dimension(110, 20));
        pnlTitle.setMaximumSize(new Dimension(110, 20));
        pnlTitle.setMinimumSize(new Dimension(110, 20));
        JPanel pnl = new JPanel(new FlowLayout(0, 0, 0));
        pnl.add((Component)pnlTitle);
        p.add(pnl);
    }

    private void addValuesPanelRow(HistoricalDataType type, List list) {
        JPanel pnlSingleData = new JPanel();
        pnlSingleData.setBackground(this.bgColor);
        BoxLayout box = new BoxLayout(pnlSingleData, 2);
        pnlSingleData.setLayout(box);
        pnlSingleData.setAlignmentX(0.0f);
        pnlSingleData.setPreferredSize(new Dimension(0, 20));
        JPanel pnlData = new JPanel();
        pnlData.setLayout(new BoxLayout(pnlData, 0));
        pnlData.setOpaque(true);
        pnlData.setBackground(this.bgColor);
        this.addHeaderRow(pnlSingleData, type, null);
        for (int i = 0; i < list.size(); ++i) {
            ValueBean bean = (ValueBean)list.get(i);
            ValuePanelRow pnlValue = new ValuePanelRow(bean.title, bean.title_tooltip, bean.value, bean.value_tooltip, bean.color);
            pnlData.add((Component)pnlValue);
        }
        if (list.size() > 0) {
            final NxGScrollPane scrollPane = new NxGScrollPane();
            scrollPane.addComponent((JComponent)pnlData);
            scrollPane.setComponentParent((Component)this);
            scrollPane.setIsHorizontal(true);
            scrollPane.setBars(15, 20);
            scrollPane.setShowScroll(true);
            scrollPane.setIsAlwaysOpen(true);
            scrollPane.setBorders(false);
            scrollPane.setBackground(this.bgColor);
            scrollPane.setIsMouseWheelListner(false);
            pnlData.setSize(new Dimension(0, 18));
            pnlSingleData.add((Component)scrollPane);
            pnlSingleData.setPreferredSize(new Dimension(0, 20));
            scrollPane.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    HistoricalValuePanelContainer.this.scrollPaneWidth = e.getComponent().getWidth();
                }
            });
            pnlData.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    HistoricalValuePanelContainer.this.PnlDataWidth = e.getComponent().getWidth();
                    if (HistoricalValuePanelContainer.this.PnlDataWidth > HistoricalValuePanelContainer.this.scrollPaneWidth) {
                        scrollPane.setDisableImages(true);
                    } else {
                        scrollPane.setDisableImages(false);
                    }
                }
            });
        } else {
            JPanel pnlEmpty = new JPanel();
            pnlEmpty.setLayout(new BorderLayout(0, 0));
            pnlEmpty.setBackground(this.bgColor);
            pnlSingleData.add(pnlEmpty);
            pnlSingleData.setPreferredSize(new Dimension(0, 20));
        }
        Box box2 = Box.createVerticalBox();
        box2.setOpaque(false);
        box2.setBackground(this.bgColor);
        JLabel lblSep = new JLabel();
        lblSep.setOpaque(false);
        lblSep.setBackground(Color.LIGHT_GRAY);
        Dimension d = new Dimension(1, 1);
        lblSep.setSize(d);
        lblSep.setPreferredSize(d);
        box2.add(pnlSingleData);
        box2.add(lblSep);
        this.add(box2);
    }

    private String getHistoricalDataSingleAndAdd(String type, String market, String scrip) {
        Gson gson = new Gson();
        String val = this.getHistoricalDataFromServer(type, market, scrip);
        AllContainer allContainer = (AllContainer)gson.fromJson(val, AllContainer.class);
        LogsTC.HistoricalData.put(scrip, allContainer);
        this.updateTechnicals(market, scrip, allContainer);
        this.setHistoricalData(market, scrip, allContainer);
        return "";
    }

    public synchronized void addHistoricalData(String market, String scrip) {
        this.market = market;
        this.scrip = scrip;
        if (scrip != null && scrip.trim().length() > 0) {
            new Thread((Runnable)new HistoricalDataLoad(market, scrip), "addHistoricalData").start();
        }
    }

    public void empty() {
        this.removeAll();
        this.repaint();
    }

    private String getHistoricalDataFromServer(String type, String market, String scrip) {
        try {
            String inputLine;
            String encodedUrl = URLEncoder.encode(scrip, "UTF-8");
            String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/DataServiceServlet?service=" + type + "&scrip=" + encodedUrl;
            StringBuilder sb = new StringBuilder();
            URL url = new URL(call);
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine);
            }
            in.close();
            Mediator.getInstance().println("Historical Value URL = " + call);
            Mediator.getInstance().println("Historical Value HTML = " + sb.toString());
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private synchronized void setHistoricalData(String market, String scrip, final AllContainer allContainer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistoricalValuePanelContainer.this.empty();
                if (allContainer != null) {
                    FundamentalsContainer fundamentalsContainer = allContainer.getFundamentalsContainer();
                    PerformanceContainer performanceContainer = allContainer.getPerformanceContainer();
                    TechnicalsContainer technicalsContainer = allContainer.getTechnicalsContainer();
                    ValuationContainer valuationContainer = allContainer.getValuationContainer();
                    if (HistoricalValuePanelContainer.this.isVerticalLayout) {
                        HistoricalValuePanelContainer.this.addValuesPanelColumn(HistoricalDataType.Valuations, valuationContainer.list);
                        HistoricalValuePanelContainer.this.addValuesPanelColumn(HistoricalDataType.Fundamentals, fundamentalsContainer.list);
                        HistoricalValuePanelContainer.this.addValuesPanelColumn(HistoricalDataType.Performance, performanceContainer.list);
                        HistoricalValuePanelContainer.this.addValuesPanelColumn(HistoricalDataType.Technicals, technicalsContainer.list);
                        HistoricalValuePanelContainer.this.repaint();
                    } else {
                        HistoricalValuePanelContainer.this.addValuesPanelRow(HistoricalDataType.Valuations, valuationContainer.list);
                        HistoricalValuePanelContainer.this.addValuesPanelRow(HistoricalDataType.Fundamentals, fundamentalsContainer.list);
                        HistoricalValuePanelContainer.this.addValuesPanelRow(HistoricalDataType.Performance, performanceContainer.list);
                        HistoricalValuePanelContainer.this.addValuesPanelRow(HistoricalDataType.Technicals, technicalsContainer.list);
                        HistoricalValuePanelContainer.this.setBackground(Color.WHITE);
                        HistoricalValuePanelContainer.this.repaint();
                    }
                }
            }
        });
    }

    private void updateTechnicals(String Market, String scrip, AllContainer allContainer) {
        TechnicalsContainer ValCont = allContainer.getTechnicalsContainer();
        ValCont.list.clear();
        MarketFeed feed = Mediator.getInstance().MwPanel.GetSingleFeed(scrip, Market);
        if (feed != null) {
            double high = Double.parseDouble(feed.high);
            double low = Double.parseDouble(feed.low);
            double closePrice = Double.parseDouble(feed.closePrice);
            double pivot = (high + low + closePrice) / 3.0;
            double support1 = 2.0 * pivot - high;
            double support2 = pivot - (high - low);
            double support3 = pivot - 2.0 * (high - low);
            double resistance1 = 2.0 * pivot - low;
            double resistance2 = pivot + (high - low);
            double resistance3 = pivot + 2.0 * (high - low);
            TechnicalsBean highBean = new TechnicalsBean();
            highBean.title = "High";
            highBean.value = Util.format2digit((String)(high + "")) + " PKR";
            ValCont.add(highBean);
            TechnicalsBean lowBean = new TechnicalsBean();
            lowBean.title = "Low";
            lowBean.value = Util.format2digit((String)("" + low)) + " PKR";
            ValCont.add(lowBean);
            TechnicalsBean closePriceBean = new TechnicalsBean();
            closePriceBean.title = "Close Price";
            closePriceBean.value = Util.format2digit((String)("" + closePrice)) + " PKR";
            ValCont.add(closePriceBean);
            TechnicalsBean support1Bean = new TechnicalsBean();
            support1Bean.title = "Support-1";
            support1Bean.value = Util.format2digit((String)("" + support1)) + " PKR";
            ValCont.add(support1Bean);
            TechnicalsBean support2Bean = new TechnicalsBean();
            support2Bean.title = "Support-2";
            support2Bean.value = Util.format2digit((String)("" + support2)) + " PKR";
            ValCont.add(support2Bean);
            TechnicalsBean support3Bean = new TechnicalsBean();
            support3Bean.title = "Support-3";
            support3Bean.value = Util.format2digit((String)("" + support3)) + " PKR";
            ValCont.add(support3Bean);
            TechnicalsBean resistance1Bean = new TechnicalsBean();
            resistance1Bean.title = "Resistance-1";
            resistance1Bean.value = Util.format2digit((String)("" + resistance1)) + " PKR";
            ValCont.add(resistance1Bean);
            TechnicalsBean resistance2Bean = new TechnicalsBean();
            resistance2Bean.title = "Resistance-2";
            resistance2Bean.value = Util.format2digit((String)("" + resistance2)) + " PKR";
            ValCont.add(resistance2Bean);
            TechnicalsBean resistance3Bean = new TechnicalsBean();
            resistance3Bean.title = "Resistance-3";
            resistance3Bean.value = Util.format2digit((String)("" + resistance3)) + " PKR";
            ValCont.add(resistance3Bean);
        }
    }

    private class HistoricalDataLoad
    extends Thread {
        private final String market2;
        private final String scrip2;

        public HistoricalDataLoad(String market, String scrip) {
            this.market2 = market;
            this.scrip2 = scrip;
            this.setName("HistoricalDataLoad (" + market + " , " + scrip + ")");
        }

        @Override
        public void run() {
            HistoricalValuePanelContainer.this.empty();
            Util.setMessage((JLabel)HistoricalValuePanelContainer.this.lblMessage, (MessageType)MessageType.Loading, (String)HistoricalValuePanelContainer.this.languageCentre.getValue(LanguageConstant.Loading));
            try {
                if (LogsTC.HistoricalData.containsKey(this.scrip2)) {
                    HistoricalValuePanelContainer.this.updateTechnicals(HistoricalValuePanelContainer.this.market, this.scrip2, LogsTC.HistoricalData.get(this.scrip2));
                    HistoricalValuePanelContainer.this.setHistoricalData(this.market2, this.scrip2, LogsTC.HistoricalData.get(this.scrip2));
                } else {
                    HistoricalValuePanelContainer.this.getHistoricalDataSingleAndAdd("HistoricalData", this.market2, this.scrip2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.scrip2.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(this.scrip2.trim())) {
                Util.setMessage((JLabel)HistoricalValuePanelContainer.this.lblMessage, (MessageType)MessageType.Normal, (String)"Invalid Scrip");
            } else {
                Util.setMessage((JLabel)HistoricalValuePanelContainer.this.lblMessage, (MessageType)MessageType.Normal, (String)Mediator.getInstance().getSymbolTitle(this.scrip2));
            }
        }
    }
}

