/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import Beans.MarketWatchBean;
import CATALYST.Control.ColumnData;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MarketWatchEvent;
import CATALYST.Control.MarketWatchListner;
import CustomComponent.ToolBarArrowButton;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import Watches.HistoricalValuePanelContainer;
import Watches.MarketWatchPanel;
import Watches.MarketWatchScripSettingDialog;
import common.gui.component.JTextFieldFilter;
import common.gui.component.NxGScrollBarUI;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.interfaces.MarketData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.text.Document;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXCollapsiblePane;

public class MyMarketWatchHistorical
extends JPanel
implements MarketWatchListner,
MarketData {
    public MarketWatch marketWatch;
    public JPopupMenu popup = new JPopupMenu();
    public static String ltPrice = "";
    private Mediator mediator = Mediator.getInstance();
    private final MarketWatchPanel marketWatchPanel;
    private HistoricalValuePanelContainer pnlHistoricalDataContainer = null;
    private String lastScrip = "";
    private String lastMarket = "";
    private int dividerSize = 88;
    JScrollPane spliterScrollPane = new JScrollPane();
    private HashMap<String, Integer> columnIndex = new HashMap();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnAnnualStatement;
    private JToggleButton btnChange;
    private JButton btnDetail;
    private JButton btnQuarterlyStatement;
    private JButton btnSaveProfile;
    private JButton btnScripDetail;
    private JXCollapsiblePane collapsiblePane;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JLabel lblNew;
    private JLabel lblScripBrowse;
    private JLabel lblSymbol;
    private JLabel lblSymbolName;
    private JPanel pnlTools;
    private JPanel pnlWatch;
    private JSplitPane splitPane;
    private JToolBar toolBar;
    private JTextField txtSymbol;

    private void setColumnIndex() {
        int index = 0;
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Market), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Scrip), index++);
        this.columnIndex.put(this.languageCentre.getValue("BuyVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Buy), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Sell), index++);
        this.columnIndex.put(this.languageCentre.getValue("SellVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LastPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue("Change"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.High), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Low), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.TotalVolume), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Average), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.PercentChange), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LowerLock), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.UpperCap), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Trade), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.CompanySnapshot), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Analytics), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Graph), index++);
        this.columnIndex.put(this.languageCentre.getValue("MarketCap"), index++);
        this.columnIndex.put(this.languageCentre.getValue("Period"), index++);
        this.columnIndex.put(this.languageCentre.getValue("P/E"), index++);
        this.columnIndex.put(this.languageCentre.getValue("DividendYield"), index++);
        this.columnIndex.put(this.languageCentre.getValue("P/B"), index++);
        this.columnIndex.put(this.languageCentre.getValue("EPS"), index++);
        this.columnIndex.put(this.languageCentre.getValue("Dir"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdTime"), index++);
        this.columnIndex.put(this.languageCentre.getValue("TotalTrd"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdVolume"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.ClosePrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.OpenPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.State), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Flag), index++);
        this.columnIndex.put(this.languageCentre.getValue("OutstandingShares"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekLow"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekAvg"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekHigh"), index++);
    }

    public MyMarketWatchHistorical(final MarketWatchPanel marketWatchPanel, String name) {
        this.marketWatchPanel = marketWatchPanel;
        try {
            this.initComponents();
            this.setColumnIndex();
            this.marketWatch = new MarketWatch(name, this.columnIndex);
            this.pnlHistoricalDataContainer = new HistoricalValuePanelContainer(this, this.lblSymbolName);
            ColumnData[] m_columns = new ColumnData[]{new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.Scrip), 100, 2), new ColumnData(this.marketWatch, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.High), 70, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.Low), 70, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.LowerLock), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.UpperCap), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.Trade), 80, 0), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.CompanySnapshot), 150, 0), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.Analytics), 100, 0), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.Graph), 100, 0), new ColumnData(this.marketWatch, this.languageCentre.getValue("MarketCap"), 120, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue("Period"), 80, 0), new ColumnData(this.marketWatch, this.languageCentre.getValue("P/E"), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue("DividendYield"), 120, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue("P/B"), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue("EPS"), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.marketWatch, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.OpenPrice), 80, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.State), 50, 2), new ColumnData(this.marketWatch, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2), new ColumnData(this.marketWatch, this.languageCentre.getValue("OutstandingShares"), 120, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue("52WeekLow"), 90, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue("52WeekAvg"), 90, 4), new ColumnData(this.marketWatch, this.languageCentre.getValue("52WeekHigh"), 90, 4)};
            this.marketWatch.isHistoricalDataWatch = AppConfig.isHistoricalDataWatch;
            this.marketWatch.ChangeAllColorAndFonts(MyColors.MarketWatchRowColor, MyColors.MarketWatchSelectedRowColor, MyColors.MarketWatchIncreaseColor, MyColors.MarketWatchDecreaseColor, LogCommon.MarketWatchFont);
            this.marketWatch.SetHeight = new JFrame().getToolkit().getScreenSize().height - 500;
            this.marketWatch.SetWidth = new JFrame().getToolkit().getScreenSize().width + 130;
            this.marketWatch.setMarket(LogCommon.markets);
            this.marketWatch.Debug = true;
            this.marketWatch.addListener((MarketWatchListner)this);
            this.marketWatch.allowedScripLimit = 100;
            this.marketWatch.isUserAddScrip = true;
            this.marketWatch.ShowTradeButton = AppConfig.ShowTradeButton;
            this.marketWatch.ShowCompanySnapButton = AppConfig.ShowCompanySnapshotButton;
            this.marketWatch.ShowGraphButton = AppConfig.ShowGraphButton;
            this.marketWatch.ShowAnalyticsButton = AppConfig.ShowAnalyticsButton;
            this.marketWatch.isStandardCapital = AppConfig.isStandardCapital;
            this.marketWatch.init(m_columns);
            this.marketWatch.comboBox.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
            this.marketWatch.comboBox.removeItem("");
            this.lblSymbolName.setFont(this.lblSymbolName.getFont().deriveFont(1));
            this.lblSymbol.setFont(this.lblSymbol.getFont().deriveFont(1));
            this.lblScripBrowse.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
            ((ToolBarArrowButton)this.btnSaveProfile).RegisterPopMenu(new String[]{this.languageCentre.getValue("SaveProfile"), this.languageCentre.getValue("ReloadProfile"), this.languageCentre.getValue("ScripSetting")}, new String[]{"/Images/save.png", "/Images/reload.png", "/Images/prefrences.png"});
            ((ToolBarArrowButton)this.btnSaveProfile).addListener(new ToolBarArrowButton.ArrowButtonActionListener(){

                @Override
                public void popupActionPerformed(ToolBarArrowButton.ArrowButtonActionEvent e) {
                }

                @Override
                public void actionPerformed(ToolBarArrowButton.ArrowButtonActionEvent e) {
                    if (e.Text.equalsIgnoreCase(MyMarketWatchHistorical.this.languageCentre.getValue("SaveProfile"))) {
                        if (MyMarketWatchHistorical.this.mediator != null) {
                            new Thread("Save Profile"){

                                @Override
                                public void run() {
                                    MyMarketWatchHistorical.this.mediator.SaveProfile(false);
                                    marketWatchPanel.SetColumnToSave();
                                    AppConfig.setAllValues();
                                }
                            }.start();
                        }
                    } else if (e.Text.equalsIgnoreCase(MyMarketWatchHistorical.this.languageCentre.getValue("ReloadProfile"))) {
                        LoadLogs PREFERENCES = new LoadLogs("PREFERENCESRELOAD=", true);
                        new ThreadWithName(PREFERENCES, "PREFERENCESRELOAD").start();
                    } else if (e.Text.equalsIgnoreCase(MyMarketWatchHistorical.this.languageCentre.getValue("ScripSetting"))) {
                        if (marketWatchPanel.getSelectedTab().equalsIgnoreCase(MyMarketWatchHistorical.this.languageCentre.getValue(LanguageConstant._1stProfile))) {
                            MarketWatchScripSettingDialog dialog = new MarketWatchScripSettingDialog(((MyMarketWatchHistorical)MyMarketWatchHistorical.this).mediator.tradecast.frame, true, MyMarketWatchHistorical.this.marketWatch, LogsKSE.page1Symbol);
                            dialog.setVisible(true);
                        } else if (marketWatchPanel.getSelectedTab().equalsIgnoreCase(MyMarketWatchHistorical.this.languageCentre.getValue(LanguageConstant._2ndProfile))) {
                            MarketWatchScripSettingDialog dialog = new MarketWatchScripSettingDialog(((MyMarketWatchHistorical)MyMarketWatchHistorical.this).mediator.tradecast.frame, true, MyMarketWatchHistorical.this.marketWatch, LogsKSE.page2Symbol);
                            dialog.setVisible(true);
                        } else if (marketWatchPanel.getSelectedTab().equalsIgnoreCase(MyMarketWatchHistorical.this.languageCentre.getValue(LanguageConstant._3rdProfile))) {
                            MarketWatchScripSettingDialog dialog = new MarketWatchScripSettingDialog(((MyMarketWatchHistorical)MyMarketWatchHistorical.this).mediator.tradecast.frame, true, MyMarketWatchHistorical.this.marketWatch, LogsKSE.page3Symbol);
                            dialog.setVisible(true);
                        }
                    }
                }
            });
            this.pnlWatch.add((Component)this.marketWatch, "Center");
            this.pnlWatch.repaint();
            this.lblScripBrowse.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ((MyMarketWatchHistorical)MyMarketWatchHistorical.this).mediator.tradecast.ShowDynamicForm(FormName.ScripBrowse, LanguageConstant.ScripBrowse);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    MyMarketWatchHistorical.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(12));
                    MyMarketWatchHistorical.this.lblScripBrowse.setText("<html><u><b>" + MyMarketWatchHistorical.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></u></html>");
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    MyMarketWatchHistorical.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(0));
                    MyMarketWatchHistorical.this.lblScripBrowse.setText("<html><b>" + MyMarketWatchHistorical.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
                }
            });
            this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
            this.collapsiblePane.add((Component)this.pnlHistoricalDataContainer);
            JPanel pnl = new JPanel();
            pnl.setLayout(new BorderLayout());
            pnl.add((Component)this.collapsiblePane, "Center");
            this.spliterScrollPane.setHorizontalScrollBarPolicy(30);
            this.spliterScrollPane.setVerticalScrollBarPolicy(20);
            UIManager.put("ScrollBar.background", 1);
            JScrollBar vbar = this.spliterScrollPane.getVerticalScrollBar();
            NxGScrollBarUI ui2 = new NxGScrollBarUI();
            ui2.setMyScrollBarUI(vbar);
            vbar.setPreferredSize(new Dimension(7, 0));
            this.spliterScrollPane.setHorizontalScrollBarPolicy(30);
            this.spliterScrollPane.setViewportView(pnl);
            this.splitPane.setBorder(null);
            this.splitPane.setTopComponent(this.spliterScrollPane);
            this.setCollaspe();
            this.mediator.setMarketWatchHistoricalPanel(this);
            this.empty();
            this.btnScripDetail.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/scripDetail.png")));
            this.btnAnnualStatement.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/AnnualStatements.png")));
            this.btnQuarterlyStatement.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/QuarterlyStatement.png")));
            if (LogCommon.NewCount > 2) {
                this.toolBar.remove(this.lblNew);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLanguageValues();
    }

    public void move(JTable table, int mIndex, int sIndex) {
        table.moveColumn(mIndex, sIndex);
    }

    private void setCollaspe() {
        boolean state = this.collapsiblePane.isCollapsed();
        if (state) {
            this.btnDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
            this.addHistoricalData(this.lastMarket, this.lastScrip);
            this.splitPane.setDividerLocation(this.dividerSize);
            this.splitPane.setDividerSize(5);
        } else {
            this.btnDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
            this.splitPane.setDividerLocation(0);
            this.splitPane.setDividerSize(0);
            this.spliterScrollPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (MyMarketWatchHistorical.this.collapsiblePane.isCollapsed()) {
                        MyMarketWatchHistorical.this.spliterScrollPane.setMinimumSize(new Dimension(0, 0));
                    } else if (MyMarketWatchHistorical.this.btnChange.isSelected()) {
                        MyMarketWatchHistorical.this.spliterScrollPane.setMinimumSize(new Dimension(0, 40));
                    } else {
                        MyMarketWatchHistorical.this.spliterScrollPane.setMinimumSize(new Dimension(0, 20));
                    }
                }
            });
        }
        this.splitPane.setEnabled(state);
        this.collapsiblePane.setCollapsed(!state);
    }

    private void initComponents() {
        this.pnlTools = new JPanel();
        this.lblScripBrowse = new JLabel();
        this.lblSymbol = new JLabel();
        this.txtSymbol = new JTextField();
        this.lblSymbolName = new JLabel();
        this.toolBar = new JToolBar();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblNew = new JLabel();
        this.btnScripDetail = new JButton();
        this.btnAnnualStatement = new JButton();
        this.btnQuarterlyStatement = new JButton();
        this.btnSaveProfile = new ToolBarArrowButton(5);
        this.btnDetail = new JButton();
        this.btnChange = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.splitPane = new JSplitPane();
        this.collapsiblePane = new JXCollapsiblePane();
        this.pnlWatch = new JPanel();
        this.pnlTools.setPreferredSize(new Dimension(470, 26));
        this.lblScripBrowse.setIcon(new ImageIcon(this.getClass().getResource("/Images/symDetail2.png")));
        this.lblScripBrowse.setText("Scrip Browse");
        this.lblSymbol.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.lblSymbol.setText("Scrip");
        this.lblSymbol.setHorizontalTextPosition(2);
        this.txtSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyMarketWatchHistorical.this.txtSymbolActionPerformed(evt);
            }
        });
        this.txtSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MyMarketWatchHistorical.this.txtSymbolFocusGained(evt);
            }
        });
        this.lblSymbolName.setText("name");
        this.lblSymbolName.setMinimumSize(new Dimension(0, 14));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.add(this.filler1);
        this.lblNew.setIcon(new ImageIcon(this.getClass().getResource("/Images/new.gif")));
        this.lblNew.setMaximumSize(new Dimension(30, 21));
        this.lblNew.setMinimumSize(new Dimension(30, 21));
        this.lblNew.setPreferredSize(new Dimension(30, 21));
        this.toolBar.add(this.lblNew);
        this.btnScripDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnScripDetail.setToolTipText("Scrip Details");
        this.btnScripDetail.setFocusable(false);
        this.btnScripDetail.setHorizontalTextPosition(0);
        this.btnScripDetail.setName("MyMarketWatchHistorical -> btnScripDetail");
        this.btnScripDetail.setVerticalTextPosition(3);
        this.btnScripDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyMarketWatchHistorical.this.btnScripDetailActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnScripDetail);
        this.btnAnnualStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnAnnualStatement.setToolTipText("Annual Statements");
        this.btnAnnualStatement.setFocusable(false);
        this.btnAnnualStatement.setHorizontalTextPosition(0);
        this.btnAnnualStatement.setName("MyMarketWatchHistorical -> btnAnnualStatement");
        this.btnAnnualStatement.setVerticalTextPosition(3);
        this.btnAnnualStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyMarketWatchHistorical.this.btnAnnualStatementActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnAnnualStatement);
        this.btnQuarterlyStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnQuarterlyStatement.setToolTipText("Quarterly Statements");
        this.btnQuarterlyStatement.setFocusable(false);
        this.btnQuarterlyStatement.setHorizontalTextPosition(0);
        this.btnQuarterlyStatement.setName("MyMarketWatchHistorical -> btnQuarterlyStatement");
        this.btnQuarterlyStatement.setVerticalTextPosition(3);
        this.btnQuarterlyStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyMarketWatchHistorical.this.btnQuarterlyStatementActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnQuarterlyStatement);
        this.btnSaveProfile.setIcon(new ImageIcon(this.getClass().getResource("/Images/save.png")));
        this.btnSaveProfile.setToolTipText("");
        this.btnSaveProfile.setFocusable(false);
        this.btnSaveProfile.setHorizontalTextPosition(4);
        this.btnSaveProfile.setMaximumSize(new Dimension(40, 23));
        this.btnSaveProfile.setMinimumSize(new Dimension(40, 23));
        this.btnSaveProfile.setName("MyMarketWatchHistorical -> btnSaveProfile");
        this.btnSaveProfile.setPreferredSize(new Dimension(93, 23));
        this.btnSaveProfile.setVerticalTextPosition(3);
        this.toolBar.add(this.btnSaveProfile);
        this.btnDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
        this.btnDetail.setText("Details");
        this.btnDetail.setToolTipText("Details");
        this.btnDetail.setFocusable(false);
        this.btnDetail.setHorizontalTextPosition(4);
        this.btnDetail.setMaximumSize(new Dimension(65, 23));
        this.btnDetail.setMinimumSize(new Dimension(65, 23));
        this.btnDetail.setName("MyMarketWatchHistorical -> btnDetail");
        this.btnDetail.setPreferredSize(new Dimension(65, 23));
        this.btnDetail.setVerticalTextPosition(3);
        this.btnDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyMarketWatchHistorical.this.btnDetailActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDetail);
        this.btnChange.setIcon(new ImageIcon(this.getClass().getResource("/Images/switch16.png")));
        this.btnChange.setFocusable(false);
        this.btnChange.setHorizontalTextPosition(0);
        this.btnChange.setName("MyMarketWatchHistorical -> btnChange");
        this.btnChange.setVerticalTextPosition(3);
        this.btnChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyMarketWatchHistorical.this.btnChangeActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnChange);
        GroupLayout pnlToolsLayout = new GroupLayout(this.pnlTools);
        this.pnlTools.setLayout(pnlToolsLayout);
        pnlToolsLayout.setHorizontalGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlToolsLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblScripBrowse, -2, 95, -2).addGap(10, 10, 10).addComponent(this.lblSymbol, -2, 50, -2).addGap(5, 5, 5).addComponent(this.txtSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSymbolName, -1, 46, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toolBar, -2, 225, -2)));
        pnlToolsLayout.setVerticalGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlToolsLayout.createSequentialGroup().addGap(2, 2, 2).addGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblScripBrowse, -2, 22, -2).addComponent(this.lblSymbol, -2, 22, -2).addComponent(this.txtSymbol, -2, 22, -2).addComponent(this.lblSymbolName, -2, 22, -2).addComponent(this.toolBar, -2, 22, -2))));
        this.splitPane.setOrientation(0);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setTopComponent((Component)this.collapsiblePane);
        this.pnlWatch.setLayout(new BorderLayout());
        this.splitPane.setBottomComponent(this.pnlWatch);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, -1, 120, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlTools, -1, 499, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(3, 3, 3)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlTools, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)));
    }

    private void btnDetailActionPerformed(ActionEvent evt) {
        this.setCollaspe();
    }

    private void txtSymbolFocusGained(FocusEvent evt) {
        this.txtSymbol.selectAll();
    }

    private void txtSymbolActionPerformed(ActionEvent evt) {
        String symbol = this.txtSymbol.getText();
        String[] sm = null;
        if (symbol.indexOf("-") <= 1) {
            this.marketWatch.AddSymbolInMarketWatch(symbol + ";REG", true, false);
            this.txtSymbol.select(0, this.txtSymbol.getText().length());
            return;
        }
        sm = this.txtSymbol.getText().split("-");
        if ("REG".equalsIgnoreCase(UtilKSE.GetMarketFromsymbol((String)symbol))) {
            this.marketWatch.AddSymbolInMarketWatch(sm[0] + ";REG", true, false);
        } else {
            this.marketWatch.AddSymbolInMarketWatch(this.txtSymbol.getText() + ";" + UtilKSE.GetMarketFromsymbol((String)this.txtSymbol.getText()), true, false);
        }
        this.txtSymbol.select(0, this.txtSymbol.getText().length());
    }

    private void btnChangeActionPerformed(ActionEvent evt) {
        this.pnlHistoricalDataContainer.setLayout();
        this.dividerSize = this.btnChange.isSelected() ? 160 : 88;
        if (this.splitPane.getDividerSize() > 0) {
            this.splitPane.setDividerLocation(this.dividerSize);
        }
    }

    private void btnAnnualStatementActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.Statement, LanguageConstant.AnnualStatements);
    }

    private void btnQuarterlyStatementActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.QuarterStatement, LanguageConstant.QuarterlyStatements);
    }

    private void btnScripDetailActionPerformed(ActionEvent evt) {
        this.mediator.openScripDetails(LogsKSE.SelectedSymbol);
        LogCommon.NewCount += 2;
    }

    public synchronized void MarketWatchMessageReceived(MarketWatchEvent event) {
        this.mediator.MarketWatchMessageReceived(event, this);
    }

    public void SetEmpty(String symbol, boolean isNew) {
        this.txtSymbol.setText("");
        this.lblSymbolName.setText("");
        this.lastMarket = "";
        this.lastScrip = "";
        this.pnlHistoricalDataContainer.empty();
    }

    public void SetSymbol(String symbol, boolean isNew) {
        this.txtSymbol.setText(symbol);
        String market = UtilKSE.GetMarketFromsymbol((String)symbol);
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText("Invalid Scrip");
        } else {
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        }
        this.lastMarket = market;
        this.lastScrip = symbol;
        if (!isNew && !this.collapsiblePane.isCollapsed()) {
            this.addHistoricalData(market, symbol);
        }
    }

    public void addHistoricalData(String market, String scrip) {
        if (scrip.length() > 0) {
            this.pnlHistoricalDataContainer.addHistoricalData(market, scrip);
        }
    }

    public void setMarketData(String market, String scrip, MarketWatchBean b) {
        this.marketWatch.setMarketData(market, scrip, b.period, b.marketcap, b.pricetoearning, b.dividendYield, b.pricetobook, b.eps, b.outstandingshares, b._52weekavgvol, b._52weekhigh, b._52weeklow);
    }

    public void SymbolRemove(String Symbol, String Market) {
        this.marketWatch.RemoveSymbolFromWatch(Symbol + ";" + Market);
    }

    public void SymbolRemove(String Symbol, boolean b) {
        this.empty();
    }

    private void empty() {
        this.lblSymbolName.setText("");
        this.txtSymbol.setText("");
        this.pnlHistoricalDataContainer.empty();
    }

    private void setLanguageValues() {
        this.lblScripBrowse.setText(this.languageCentre.getValue(LanguageConstant.ScripBrowse));
        this.lblSymbol.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.btnScripDetail.setToolTipText(this.languageCentre.getValue(LanguageConstant.ScripDetail));
        this.btnAnnualStatement.setToolTipText(this.languageCentre.getValue(LanguageConstant.AnnualStatements));
        this.btnQuarterlyStatement.setToolTipText(this.languageCentre.getValue(LanguageConstant.QuarterlyStatements));
        this.btnDetail.setText(this.languageCentre.getValue(LanguageConstant.Details));
        this.btnDetail.setToolTipText(this.languageCentre.getValue(LanguageConstant.Details));
    }
}

