/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import Beans.OrderBean;
import CATALYST.Control.MarketFeed;
import CustomComponent.MyOptionPane;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Orders.OrderConfirmation;
import Utilities.OutstandingLogUtil;
import Watches.LiquidateAllOrderDialog;
import Watches.PortfolioWatchAdv;
import Watches.PortfolioWatchHistorical;
import common.gui.component.NxGDialogBox;
import common.gui.util.AppConfig;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;

public class PortfolioDetail
extends JPanel {
    private boolean isCollateral = true;
    private String scrip = "";
    private Mediator mediator = Mediator.getInstance();
    Color Green = new Color(0, 153, 0);
    private PortfolioWatchAdv portfolioWatchAdv;
    private PortfolioWatchHistorical portfolioWatchHistorical;
    private final int indexSECURITY_INVESTMENT = 0;
    private final int indexSECURITY_CURRENT_VALUE = 1;
    private final int indexSECURITYPL = 2;
    private final int indexSESSION_INVESTMENT = 3;
    private final int indexSESSION_CURRENT_VALUE = 4;
    private final int indexSESSIONPL = 5;
    private final int indexCASH = 6;
    private final int indexCOLLATERALS = 7;
    private final int indexLEDGER_BAL = 8;
    private final int indexREALIZE_PL = 9;
    private final int indexUNREALIZE_PL = 10;
    private final int indexSOLD_COLLATERALS = 11;
    private final int indexNET_WORTH = 12;
    private String holding = "0";
    private final String disclaimer = "Disclaimer";
    private NxGDialogBox jd;
    private boolean isBuy;
    private double perTotalInvestment;
    private double perScripInvestment;
    private double perCollaterals;
    private double perSold;
    private long netQuantity;
    private double currentWorth;
    private final Color OtherCollateralsColor = new Color(170, 213, 164);
    private final Color scripColor = new Color(16, 173, 12);
    private final Color collateralsColor = new Color(16, 173, 12);
    private final Color cashColor = new Color(141, 136, 41);
    private String collateralsType = "";
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnLiquidateAll;
    private JButton btnLiquidateSingle;
    private ButtonGroup buttonGroup1;
    private JRadioButton isPrice;
    private JRadioButton isVolume;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JLabel lblAvgPrice;
    private JLabel lblDisclaimer;
    private JLabel lblLegendCollateral;
    private JLabel lblLegendHoldingType;
    private JLabel lblLegendScrip;
    private JLabel lblLengendCash;
    private JLabel lblMessage;
    private JLabel lblNetWorth;
    private JLabel lblScripWorth;
    private JLabel lblTabType;
    private JPanel pnlChartPortfolio;
    private JPanel pnlChartScrip;
    private JTextField txtAvgPrice;
    private JTextField txtCurrentPrice;
    private JTextField txtCurrentWorth;
    private JTextField txtHoldingCurrentWorth;
    private JTextField txtHoldingInvestment;
    private JTextField txtHoldingProfitLoss;
    private JTextField txtInvestment;
    private JTextField txtNetQuantity;
    private JTextField txtNetWorth;
    private JTextField txtPofitLoss;
    private JTextField txtWorthCollaterals;
    private JTextField txtWorthLedgerBalance;
    private JTextField txtWorthProfitLoss;
    private JTextField txtWorthSoldCollaterals;

    public PortfolioDetail(PortfolioWatchAdv portfolioWatchAdv, PortfolioWatchHistorical portfolioWatchHistorical) {
        try {
            this.portfolioWatchAdv = portfolioWatchAdv;
            this.portfolioWatchHistorical = portfolioWatchHistorical;
            this.initComponents();
            this.setTextField();
            if (!AppConfig.isAvgPriceInMarketWatch) {
                this.lblAvgPrice.setText("Close Price");
            }
            this.lblDisclaimer.setText("<html><b>Disclaimer</b></html>");
            this.lblDisclaimer.setCursor(Cursor.getPredefinedCursor(12));
            this.lblDisclaimer.setVisible(false);
            if (AppConfig.houseName.equalsIgnoreCase("JSGCL")) {
                this.txtNetWorth.setVisible(false);
                this.jLabel1.setVisible(false);
                this.lblNetWorth.setVisible(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mediator.PrintLog(ex, "");
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.lblAvgPrice = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.txtNetQuantity = new JTextField();
        this.txtAvgPrice = new JTextField();
        this.txtInvestment = new JTextField();
        this.txtCurrentPrice = new JTextField();
        this.txtCurrentWorth = new JTextField();
        this.txtPofitLoss = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.pnlChartScrip = new JPanel();
        this.btnLiquidateSingle = new JButton();
        this.lblTabType = new JLabel();
        this.jLabel10 = new JLabel();
        this.txtHoldingInvestment = new JTextField();
        this.jLabel11 = new JLabel();
        this.txtHoldingCurrentWorth = new JTextField();
        this.jLabel9 = new JLabel();
        this.txtHoldingProfitLoss = new JTextField();
        this.btnLiquidateAll = new JButton();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel17 = new JLabel();
        this.lblNetWorth = new JLabel();
        this.pnlChartPortfolio = new JPanel();
        this.txtWorthCollaterals = new JTextField();
        this.txtWorthLedgerBalance = new JTextField();
        this.txtWorthProfitLoss = new JTextField();
        this.txtWorthSoldCollaterals = new JTextField();
        this.txtNetWorth = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.lblLegendScrip = new JLabel();
        this.lblLegendHoldingType = new JLabel();
        this.lblScripWorth = new JLabel();
        this.lblLengendCash = new JLabel();
        this.lblLegendCollateral = new JLabel();
        this.lblDisclaimer = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.isPrice = new JRadioButton();
        this.isVolume = new JRadioButton();
        this.lblMessage = new JLabel();
        this.jSeparator5 = new JSeparator();
        this.jPanel1.setLayout(null);
        this.jLabel2.setText("Net Quantity");
        this.jPanel1.add(this.jLabel2);
        this.jLabel2.setBounds(10, 40, 80, 20);
        this.lblAvgPrice.setText("Avg. Price ");
        this.jPanel1.add(this.lblAvgPrice);
        this.lblAvgPrice.setBounds(10, 65, 60, 20);
        this.jLabel4.setText("Investment");
        this.jPanel1.add(this.jLabel4);
        this.jLabel4.setBounds(10, 90, 60, 20);
        this.jLabel5.setText("Current Price");
        this.jPanel1.add(this.jLabel5);
        this.jLabel5.setBounds(10, 115, 63, 20);
        this.jLabel6.setText("Current Worth");
        this.jPanel1.add(this.jLabel6);
        this.jLabel6.setBounds(10, 140, 70, 20);
        this.jLabel7.setText("Profit / Loss");
        this.jPanel1.add(this.jLabel7);
        this.jLabel7.setBounds(10, 165, 60, 20);
        this.txtNetQuantity.setEditable(false);
        this.txtNetQuantity.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtNetQuantity);
        this.txtNetQuantity.setBounds(102, 40, 90, 20);
        this.txtAvgPrice.setEditable(false);
        this.txtAvgPrice.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtAvgPrice);
        this.txtAvgPrice.setBounds(102, 65, 90, 20);
        this.txtInvestment.setEditable(false);
        this.txtInvestment.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtInvestment);
        this.txtInvestment.setBounds(102, 90, 90, 20);
        this.txtCurrentPrice.setEditable(false);
        this.txtCurrentPrice.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtCurrentPrice);
        this.txtCurrentPrice.setBounds(102, 115, 90, 20);
        this.txtCurrentWorth.setEditable(false);
        this.txtCurrentWorth.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtCurrentWorth);
        this.txtCurrentWorth.setBounds(102, 140, 90, 20);
        this.txtPofitLoss.setEditable(false);
        this.txtPofitLoss.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtPofitLoss);
        this.txtPofitLoss.setBounds(102, 165, 90, 20);
        this.jSeparator1.setOrientation(1);
        this.jPanel1.add(this.jSeparator1);
        this.jSeparator1.setBounds(540, 10, 10, 170);
        GroupLayout pnlChartScripLayout = new GroupLayout(this.pnlChartScrip);
        this.pnlChartScrip.setLayout(pnlChartScripLayout);
        pnlChartScripLayout.setHorizontalGroup(pnlChartScripLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 110, Short.MAX_VALUE));
        pnlChartScripLayout.setVerticalGroup(pnlChartScripLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 90, Short.MAX_VALUE));
        this.jPanel1.add(this.pnlChartScrip);
        this.pnlChartScrip.setBounds(215, 50, 110, 90);
        this.btnLiquidateSingle.setText("Liquidate");
        this.btnLiquidateSingle.setName("PortfolioDetail -> btnLiquidateSingle");
        this.btnLiquidateSingle.setOpaque(false);
        this.btnLiquidateSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioDetail.this.btnLiquidateSingleActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnLiquidateSingle);
        this.btnLiquidateSingle.setBounds(210, 160, 120, 23);
        this.lblTabType.setFont(new Font("Tahoma", 1, 11));
        this.lblTabType.setHorizontalAlignment(0);
        this.lblTabType.setText("Collaterals");
        this.jPanel1.add(this.lblTabType);
        this.lblTabType.setBounds(360, 10, 170, 20);
        this.jLabel10.setText("Investment");
        this.jPanel1.add(this.jLabel10);
        this.jLabel10.setBounds(350, 50, 60, 20);
        this.txtHoldingInvestment.setEditable(false);
        this.txtHoldingInvestment.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtHoldingInvestment);
        this.txtHoldingInvestment.setBounds(443, 50, 90, 20);
        this.jLabel11.setText("Current Worth");
        this.jPanel1.add(this.jLabel11);
        this.jLabel11.setBounds(350, 80, 70, 20);
        this.txtHoldingCurrentWorth.setEditable(false);
        this.txtHoldingCurrentWorth.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtHoldingCurrentWorth);
        this.txtHoldingCurrentWorth.setBounds(443, 80, 90, 20);
        this.jLabel9.setText("Profit / Loss");
        this.jPanel1.add(this.jLabel9);
        this.jLabel9.setBounds(350, 110, 60, 20);
        this.txtHoldingProfitLoss.setEditable(false);
        this.txtHoldingProfitLoss.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtHoldingProfitLoss);
        this.txtHoldingProfitLoss.setBounds(443, 110, 90, 20);
        this.btnLiquidateAll.setText("Liquidate All Collateral");
        this.btnLiquidateAll.setToolTipText("Liquidate All Collaterals");
        this.btnLiquidateAll.setName("PortfolioDetail -> btnLiquidateAll");
        this.btnLiquidateAll.setOpaque(false);
        this.btnLiquidateAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioDetail.this.btnLiquidateAllActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnLiquidateAll);
        this.btnLiquidateAll.setBounds(350, 160, 180, 23);
        this.jLabel12.setFont(new Font("Tahoma", 1, 11));
        this.jLabel12.setHorizontalAlignment(0);
        this.jLabel12.setText("Portfolio Worth");
        this.jPanel1.add(this.jLabel12);
        this.jLabel12.setBounds(570, 10, 320, 20);
        this.jLabel13.setText("Collaterals");
        this.jPanel1.add(this.jLabel13);
        this.jLabel13.setBounds(550, 40, 60, 20);
        this.jLabel14.setText("Ledger Balance");
        this.jPanel1.add(this.jLabel14);
        this.jLabel14.setBounds(550, 65, 80, 20);
        this.jLabel15.setText("Profit / Loss");
        this.jPanel1.add(this.jLabel15);
        this.jLabel15.setBounds(550, 90, 60, 20);
        this.jLabel17.setText("Sold Collaterals");
        this.jPanel1.add(this.jLabel17);
        this.jLabel17.setBounds(550, 115, 75, 20);
        this.lblNetWorth.setText("Net Worth");
        this.jPanel1.add(this.lblNetWorth);
        this.lblNetWorth.setBounds(550, 165, 50, 20);
        GroupLayout pnlChartPortfolioLayout = new GroupLayout(this.pnlChartPortfolio);
        this.pnlChartPortfolio.setLayout(pnlChartPortfolioLayout);
        pnlChartPortfolioLayout.setHorizontalGroup(pnlChartPortfolioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 110, Short.MAX_VALUE));
        pnlChartPortfolioLayout.setVerticalGroup(pnlChartPortfolioLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 90, Short.MAX_VALUE));
        this.jPanel1.add(this.pnlChartPortfolio);
        this.pnlChartPortfolio.setBounds(755, 50, 110, 90);
        this.txtWorthCollaterals.setEditable(false);
        this.txtWorthCollaterals.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtWorthCollaterals);
        this.txtWorthCollaterals.setBounds(648, 40, 90, 20);
        this.txtWorthLedgerBalance.setEditable(false);
        this.txtWorthLedgerBalance.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtWorthLedgerBalance);
        this.txtWorthLedgerBalance.setBounds(648, 65, 90, 20);
        this.txtWorthProfitLoss.setEditable(false);
        this.txtWorthProfitLoss.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtWorthProfitLoss);
        this.txtWorthProfitLoss.setBounds(648, 90, 90, 20);
        this.txtWorthSoldCollaterals.setEditable(false);
        this.txtWorthSoldCollaterals.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtWorthSoldCollaterals);
        this.txtWorthSoldCollaterals.setBounds(648, 115, 90, 20);
        this.txtNetWorth.setEditable(false);
        this.txtNetWorth.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtNetWorth);
        this.txtNetWorth.setBounds(645, 165, 90, 20);
        this.jSeparator2.setOrientation(1);
        this.jPanel1.add(this.jSeparator2);
        this.jSeparator2.setBounds(745, 40, 10, 140);
        this.jSeparator3.setOrientation(1);
        this.jPanel1.add(this.jSeparator3);
        this.jSeparator3.setBounds(200, 40, 10, 140);
        this.jSeparator4.setOrientation(1);
        this.jPanel1.add(this.jSeparator4);
        this.jSeparator4.setBounds(340, 10, 10, 170);
        this.lblLegendScrip.setFont(new Font("Tahoma", 0, 10));
        this.lblLegendScrip.setIcon(new ImageIcon(this.getClass().getResource("/Images/boxgreen.jpg")));
        this.lblLegendScrip.setText(" ");
        this.lblLegendScrip.setMaximumSize(new Dimension(206, 8));
        this.lblLegendScrip.setMinimumSize(new Dimension(206, 8));
        this.lblLegendScrip.setPreferredSize(new Dimension(206, 8));
        this.jPanel1.add(this.lblLegendScrip);
        this.lblLegendScrip.setBounds(215, 40, 110, 10);
        this.lblLegendHoldingType.setFont(new Font("Tahoma", 0, 10));
        this.lblLegendHoldingType.setHorizontalAlignment(2);
        this.lblLegendHoldingType.setIcon(new ImageIcon(this.getClass().getResource("/Images/boxlimegreen.jpg")));
        this.lblLegendHoldingType.setText(" ");
        this.jPanel1.add(this.lblLegendHoldingType);
        this.lblLegendHoldingType.setBounds(215, 140, 110, 15);
        this.lblScripWorth.setFont(new Font("Tahoma", 1, 11));
        this.lblScripWorth.setHorizontalAlignment(0);
        this.lblScripWorth.setText("Scrip Worth");
        this.jPanel1.add(this.lblScripWorth);
        this.lblScripWorth.setBounds(140, 10, 80, 20);
        this.lblLengendCash.setFont(new Font("Tahoma", 0, 10));
        this.lblLengendCash.setHorizontalAlignment(2);
        this.lblLengendCash.setIcon(new ImageIcon(this.getClass().getResource("/Images/boxgold.jpg")));
        this.lblLengendCash.setText("Cash");
        this.jPanel1.add(this.lblLengendCash);
        this.lblLengendCash.setBounds(755, 40, 110, 10);
        this.lblLegendCollateral.setFont(new Font("Tahoma", 0, 10));
        this.lblLegendCollateral.setHorizontalAlignment(2);
        this.lblLegendCollateral.setIcon(new ImageIcon(this.getClass().getResource("/Images/boxgreen.jpg")));
        this.lblLegendCollateral.setText("Collaterals");
        this.lblLegendCollateral.setMaximumSize(new Dimension(206, 16));
        this.lblLegendCollateral.setMinimumSize(new Dimension(206, 16));
        this.lblLegendCollateral.setPreferredSize(new Dimension(206, 16));
        this.jPanel1.add(this.lblLegendCollateral);
        this.lblLegendCollateral.setBounds(755, 140, 110, 16);
        this.lblDisclaimer.setIcon(new ImageIcon(this.getClass().getResource("/Images/Margin12x12.png")));
        this.lblDisclaimer.setText("Disclaimer");
        this.lblDisclaimer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PortfolioDetail.this.lblDisclaimerMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PortfolioDetail.this.lblDisclaimerMouseExited(evt);
            }
        });
        this.jPanel1.add(this.lblDisclaimer);
        this.lblDisclaimer.setBounds(10, 10, 80, 20);
        this.jLabel1.setText("Rs.");
        this.jPanel1.add(this.jLabel1);
        this.jLabel1.setBounds(628, 165, 16, 20);
        this.jLabel8.setText("PKR");
        this.jPanel1.add(this.jLabel8);
        this.jLabel8.setBounds(82, 65, 19, 20);
        this.jLabel16.setText("PKR");
        this.jPanel1.add(this.jLabel16);
        this.jLabel16.setBounds(82, 90, 20, 20);
        this.jLabel19.setText("PKR");
        this.jPanel1.add(this.jLabel19);
        this.jLabel19.setBounds(82, 115, 20, 20);
        this.jLabel20.setText("PKR");
        this.jPanel1.add(this.jLabel20);
        this.jLabel20.setBounds(82, 140, 19, 20);
        this.jLabel21.setText("PKR");
        this.jPanel1.add(this.jLabel21);
        this.jLabel21.setBounds(82, 165, 20, 20);
        this.jLabel22.setText("PKR");
        this.jPanel1.add(this.jLabel22);
        this.jLabel22.setBounds(422, 50, 20, 20);
        this.jLabel23.setText("PKR");
        this.jPanel1.add(this.jLabel23);
        this.jLabel23.setBounds(422, 80, 20, 20);
        this.jLabel24.setText("PKR");
        this.jPanel1.add(this.jLabel24);
        this.jLabel24.setBounds(422, 110, 20, 20);
        this.jLabel25.setText("PKR");
        this.jPanel1.add(this.jLabel25);
        this.jLabel25.setBounds(628, 40, 19, 20);
        this.jLabel26.setText("PKR");
        this.jPanel1.add(this.jLabel26);
        this.jLabel26.setBounds(628, 65, 19, 20);
        this.jLabel27.setText("PKR");
        this.jPanel1.add(this.jLabel27);
        this.jLabel27.setBounds(628, 90, 19, 20);
        this.jLabel28.setText("PKR");
        this.jPanel1.add(this.jLabel28);
        this.jLabel28.setBounds(628, 115, 19, 20);
        this.buttonGroup1.add(this.isPrice);
        this.isPrice.setFont(new Font("Tahoma", 0, 8));
        this.isPrice.setSelected(true);
        this.isPrice.setText("By Price");
        this.isPrice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PortfolioDetail.this.isPriceItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.isPrice);
        this.isPrice.setBounds(210, 23, 55, 15);
        this.buttonGroup1.add(this.isVolume);
        this.isVolume.setFont(new Font("Tahoma", 0, 8));
        this.isVolume.setText("By Volume");
        this.isVolume.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PortfolioDetail.this.isVolumeItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.isVolume);
        this.isVolume.setBounds(270, 23, 64, 15);
        this.lblMessage.setText(" ");
        this.lblMessage.setMaximumSize(new Dimension(12, 18));
        this.lblMessage.setMinimumSize(new Dimension(12, 18));
        this.lblMessage.setPreferredSize(new Dimension(12, 18));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator5, -1, 880, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 870, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblMessage, -2, 320, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 191, -2).addGap(0, 0, 0).addComponent(this.jSeparator5, -2, 3, -2).addGap(1, 1, 1).addComponent(this.lblMessage, -2, -1, -2)));
    }

    private void btnLiquidateSingleActionPerformed(ActionEvent evt) {
        if (LogCommon.isUnattended) {
            return;
        }
        if (LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP")) {
            MyOptionPane.showMessage(MessageType.Information, "Liquidate Order is not allowed in Off Hour Transaction", "Liquidate Order", true);
            return;
        }
        if (this.portfolioWatchAdv != null) {
            this.openTradeWindowAdvance();
        } else if (this.portfolioWatchHistorical != null) {
            this.openTradeWindowHistorical();
        }
    }

    private void btnLiquidateAllActionPerformed(ActionEvent evt) {
        try {
            if (LogCommon.isUnattended) {
                return;
            }
            if (LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP")) {
                MyOptionPane.showMessage(MessageType.Information, "Liquidate All Order is not allowed in Off Hour Transaction", "Liquidate All Order", true);
                return;
            }
            if (this.portfolioWatchAdv != null) {
                this.setOrderFromAdvance();
            } else if (this.portfolioWatchHistorical != null) {
                this.setOrderFromHistorical();
            }
        }
        catch (Exception ex) {
            this.mediator.PrintLog(ex, "");
        }
    }

    private void lblDisclaimerMouseEntered(MouseEvent evt) {
        this.lblDisclaimer.setText("<html><u><b>Disclaimer</b></u></html>");
    }

    private void lblDisclaimerMouseExited(MouseEvent evt) {
        this.lblDisclaimer.setText("<html><b>Disclaimer</b></html>");
    }

    private void isVolumeItemStateChanged(ItemEvent evt) {
        this.updateScripChartValues();
    }

    private void isPriceItemStateChanged(ItemEvent evt) {
        this.updateScripChartValues();
    }

    protected void setScripValues(String scrip, boolean isFeed) {
        if (scrip.trim().equalsIgnoreCase("")) {
            return;
        }
        this.netQuantity = 0L;
        this.currentWorth = 0.0;
        this.btnLiquidateSingle.setText("Liquidate " + scrip);
        this.btnLiquidateSingle.setToolTipText("Liquidate '" + scrip + "' on Market Price");
        this.lblLegendScrip.setText(scrip);
        this.lblLegendScrip.setIcon(new ImageIcon(this.getClass().getResource("/Images/boxgreen.jpg")));
        this.lblLegendHoldingType.setText("Other " + this.lblTabType.getText());
        this.lblLegendHoldingType.setToolTipText("Other " + this.lblTabType.getText());
        this.lblLegendHoldingType.setIcon(new ImageIcon(this.getClass().getResource("/Images/boxlimegreen.jpg")));
        MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeedAdv(scrip, UtilKSE.GetMarketFromsymbol((String)scrip));
        if (mktFeed != null) {
            double avgPrice = 0.0;
            double investment = 0.0;
            double currentPrice = 0.0;
            double profitLoss = 0.0;
            this.txtCurrentPrice.setHorizontalAlignment(4);
            this.txtCurrentWorth.setHorizontalAlignment(4);
            this.txtPofitLoss.setHorizontalAlignment(4);
            this.txtPofitLoss.setForeground(Color.BLACK);
            try {
                this.netQuantity = Long.parseLong(mktFeed.netQty);
                this.isBuy = this.netQuantity < 0L;
                avgPrice = AppConfig.isAvgPriceInMarketWatch ? Double.parseDouble(mktFeed.avgPrice) : Double.parseDouble(mktFeed.closePrice);
                investment = (double)this.netQuantity * avgPrice;
                double templtrdprice = 0.0;
                try {
                    templtrdprice = Double.parseDouble(mktFeed.lTrdPrice);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (templtrdprice == 0.0) {
                    try {
                        currentPrice = Double.parseDouble(mktFeed.closePrice);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    try {
                        currentPrice = templtrdprice;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.currentWorth = (double)this.netQuantity * currentPrice;
                profitLoss = this.currentWorth - investment;
                this.txtNetQuantity.setText(Util.format0digit((String)(this.netQuantity + "")));
                this.txtAvgPrice.setText(Util.format2digit((String)(avgPrice + "")));
                this.txtInvestment.setText(Util.format2digit((String)(Math.abs(investment) + "")));
                this.txtCurrentPrice.setText(Util.format2digit((String)(currentPrice + "")));
                this.txtCurrentWorth.setText(Util.format2digit((String)(Math.abs(this.currentWorth) + "")));
                this.txtPofitLoss.setText(Util.format2digit((String)(Math.abs(profitLoss) + "")));
                if (!LogCommon.isUnattended) {
                    this.enableDisableButton(true);
                }
                if (mktFeed.direction.equalsIgnoreCase("+")) {
                    this.txtCurrentPrice.setForeground(this.Green);
                } else if (mktFeed.direction.equalsIgnoreCase("-")) {
                    this.txtCurrentPrice.setForeground(Color.RED);
                } else {
                    this.txtCurrentPrice.setForeground(Color.BLACK);
                }
                if (profitLoss == 0.0) {
                    this.txtPofitLoss.setForeground(Color.BLACK);
                } else if (profitLoss > 0.0) {
                    this.txtPofitLoss.setForeground(this.Green);
                } else {
                    this.txtPofitLoss.setForeground(Color.RED);
                }
                if (this.isPrice.isSelected()) {
                    this.createScripChart(this.currentWorth, Double.parseDouble(this.holding));
                } else if (this.isVolume.isSelected()) {
                    if (this.portfolioWatchAdv != null) {
                        this.createScripChart(this.netQuantity, this.portfolioWatchAdv.netQty);
                    } else if (this.portfolioWatchHistorical != null) {
                        this.createScripChart(this.netQuantity, this.portfolioWatchHistorical.netQty);
                    }
                }
            }
            catch (Exception ex) {
                if (this.netQuantity > 0L) {
                    this.txtNetQuantity.setText(Util.format0digit((String)(Math.abs(this.netQuantity) + "")));
                }
                if (avgPrice > 0.0) {
                    this.txtAvgPrice.setText(Util.format2digit((String)(avgPrice + "")));
                }
                if (this.netQuantity > 0L && avgPrice > 0.0) {
                    this.txtInvestment.setText(Util.format2digit((String)(Math.abs(investment) + "")));
                }
                this.txtCurrentPrice.setText("");
                this.txtCurrentWorth.setText("");
                this.txtPofitLoss.setText("");
                this.txtCurrentPrice.setHorizontalAlignment(2);
                this.txtCurrentWorth.setHorizontalAlignment(2);
                this.txtPofitLoss.setHorizontalAlignment(2);
                this.pnlChartScrip.removeAll();
                this.pnlChartScrip.repaint();
            }
        } else {
            this.pnlChartScrip.removeAll();
            this.pnlChartScrip.repaint();
            this.lblLegendScrip.setText("");
            this.lblLegendHoldingType.setText("");
            this.lblLegendScrip.setIcon(null);
            this.lblLegendHoldingType.setIcon(null);
            this.txtNetQuantity.setText("");
            this.txtAvgPrice.setText("");
            this.txtInvestment.setText("");
            this.txtCurrentPrice.setText("");
            this.txtCurrentWorth.setText("");
            this.txtPofitLoss.setText("");
            this.lblLegendScrip.setText("");
            this.enableDisableButton(false);
            this.pnlChartScrip.removeAll();
            this.pnlChartScrip.repaint();
        }
        this.scrip = scrip;
    }

    protected synchronized void setTabType(String val, boolean type) {
        this.isCollateral = type;
        this.btnLiquidateAll.setText("Liquidate All " + val);
        this.btnLiquidateAll.setToolTipText(this.btnLiquidateAll.getText() + " on Market Price");
        this.lblTabType.setText(val);
    }

    private void setTextField() {
        Color bgColor = Color.WHITE;
        this.txtWorthProfitLoss.setBackground(bgColor);
        this.txtAvgPrice.setBackground(bgColor);
        this.txtWorthCollaterals.setBackground(bgColor);
        this.txtCurrentPrice.setBackground(bgColor);
        this.txtCurrentWorth.setBackground(bgColor);
        this.txtHoldingCurrentWorth.setBackground(bgColor);
        this.txtWorthSoldCollaterals.setBackground(bgColor);
        this.txtInvestment.setBackground(bgColor);
        this.txtHoldingInvestment.setBackground(bgColor);
        this.txtNetQuantity.setBackground(bgColor);
        this.txtWorthLedgerBalance.setBackground(bgColor);
        this.txtPofitLoss.setBackground(bgColor);
        this.txtHoldingProfitLoss.setBackground(bgColor);
        this.txtNetWorth.setBackground(bgColor);
    }

    protected synchronized void setHoldings(String investment, String value, String profitLoss) {
        this.txtHoldingInvestment.setText(Util.format2digit((String)investment));
        this.txtHoldingCurrentWorth.setText(Util.format2digit((String)value));
        this.holding = investment;
        double proLoss = Double.parseDouble(profitLoss);
        if (proLoss == 0.0) {
            this.txtHoldingProfitLoss.setForeground(Color.BLACK);
        } else if (proLoss > 0.0) {
            this.txtHoldingProfitLoss.setForeground(this.Green);
        } else {
            this.txtHoldingProfitLoss.setForeground(Color.RED);
        }
        this.txtHoldingProfitLoss.setText(Util.format2digit((String)(Math.abs(proLoss) + "")));
    }

    protected synchronized void setHoldingReset() {
        this.txtHoldingInvestment.setText("");
        this.txtHoldingCurrentWorth.setText("");
        this.txtHoldingProfitLoss.setText("");
    }

    protected synchronized void setPortfolioWorth(String COLLATERALS, String LEDGER_BAL, String REALIZE_PL, String UNREALIZE_PL, String SOLD_COLLATERALS, String NET_WORTH) {
        double collaterals = 0.0;
        double ledgerBal = 0.0;
        double realizedPL = 0.0;
        double unrealizedPL = 0.0;
        double soldCollaterals = 0.0;
        double profitLoss = 0.0;
        double netWorth = 0.0;
        this.pnlChartPortfolio.removeAll();
        this.pnlChartPortfolio.repaint();
        this.lblLegendCollateral.setText(this.collateralsType);
        this.lblLegendCollateral.setIcon(new ImageIcon(this.getClass().getResource("/Images/boxgreen.jpg")));
        this.lblLengendCash.setText("Cash");
        this.lblLengendCash.setIcon(new ImageIcon(this.getClass().getResource("/Images/boxgold.jpg")));
        try {
            collaterals = Double.parseDouble(COLLATERALS);
            ledgerBal = Double.parseDouble(LEDGER_BAL);
            realizedPL = Double.parseDouble(REALIZE_PL);
            unrealizedPL = Double.parseDouble(UNREALIZE_PL);
            soldCollaterals = Double.parseDouble(SOLD_COLLATERALS);
            netWorth = collaterals + ledgerBal + realizedPL + unrealizedPL + soldCollaterals;
            profitLoss = realizedPL + unrealizedPL;
            this.txtWorthCollaterals.setText(Util.format2digit((String)COLLATERALS));
            this.txtWorthLedgerBalance.setText(Util.format2digit((String)LEDGER_BAL));
            this.txtWorthProfitLoss.setText(Util.format2digit((String)(Math.abs(profitLoss) + "")));
            this.txtWorthSoldCollaterals.setText(Util.format2digit((String)SOLD_COLLATERALS));
            this.txtNetWorth.setText(Util.format2digit((String)(netWorth + "")));
            if (profitLoss == 0.0) {
                this.txtWorthProfitLoss.setForeground(Color.BLACK);
            } else if (profitLoss > 0.0) {
                this.txtWorthProfitLoss.setForeground(this.Green);
            } else {
                this.txtWorthProfitLoss.setForeground(Color.RED);
            }
            this.createPortfolioChart(collaterals, ledgerBal, soldCollaterals);
        }
        catch (Exception ex) {
            this.lblLegendCollateral.setText(" ");
            this.lblLegendCollateral.setIcon(null);
            this.lblLengendCash.setText(" ");
            this.lblLengendCash.setIcon(null);
            this.txtWorthCollaterals.setText("");
            this.txtWorthLedgerBalance.setText("");
            this.txtWorthProfitLoss.setText("");
            this.txtWorthSoldCollaterals.setText("");
            this.txtNetWorth.setText("");
            this.pnlChartPortfolio.removeAll();
            this.pnlChartPortfolio.repaint();
            this.mediator.PrintLog(ex, "");
        }
    }

    private void getPortfolioDetail() {
        new Thread("getPortfolioDetail"){

            @Override
            public void run() {
                try {
                    Util.setMessage((JLabel)PortfolioDetail.this.lblMessage, (MessageType)MessageType.Loading, (String)PortfolioDetail.this.languageCentre.getValue(LanguageConstant.Loading));
                    String result = "";
                    if (PortfolioDetail.this.portfolioWatchAdv != null) {
                        result = WebService.getInstance().getPort().getInfo(LogCommon.UserID, "GetPortfolioDetail=", PortfolioDetail.this.portfolioWatchAdv.getSelectedAccountNo());
                    } else if (PortfolioDetail.this.portfolioWatchHistorical != null) {
                        result = WebService.getInstance().getPort().getInfo(LogCommon.UserID, "GetPortfolioDetail=", PortfolioDetail.this.portfolioWatchHistorical.getSelectedAccountNo());
                    }
                    if (result.indexOf("|") > 0) {
                        String[] values = result.split("\\|", -1);
                        String SECURITY_INVESTMENT = values[0];
                        String SECURITY_CURRENT_VALUE = values[1];
                        String SECURITYPL = values[2];
                        String SESSION_INVESTMENT = values[3];
                        String SESSION_CURRENT_VALUE = values[4];
                        String SESSIONPL = values[5];
                        String CASH = values[6];
                        String COLLATERALS = values[7];
                        String LEDGER_BAL = values[8];
                        String REALIZE_PL = values[9];
                        String UNREALIZE_PL = values[10];
                        String SOLD_COLLATERALS = values[11];
                        if (PortfolioDetail.this.portfolioWatchAdv != null) {
                            if (((PortfolioDetail)PortfolioDetail.this).portfolioWatchAdv.rdCollateral.isSelected()) {
                                PortfolioDetail.this.setHoldings(SECURITY_INVESTMENT, SECURITY_CURRENT_VALUE, SECURITYPL);
                            } else {
                                PortfolioDetail.this.setHoldings(SESSION_INVESTMENT, SESSION_CURRENT_VALUE, SESSIONPL);
                            }
                        } else if (PortfolioDetail.this.portfolioWatchHistorical != null) {
                            if (((PortfolioDetail)PortfolioDetail.this).portfolioWatchHistorical.rdCollateral.isSelected()) {
                                PortfolioDetail.this.setHoldings(SECURITY_INVESTMENT, SECURITY_CURRENT_VALUE, SECURITYPL);
                            } else {
                                PortfolioDetail.this.setHoldings(SESSION_INVESTMENT, SESSION_CURRENT_VALUE, SESSIONPL);
                            }
                        }
                        PortfolioDetail.this.setPortfolioWorth(COLLATERALS, LEDGER_BAL, REALIZE_PL, UNREALIZE_PL, SOLD_COLLATERALS, "");
                    } else {
                        PortfolioDetail.this.setHoldingReset();
                    }
                    if (PortfolioDetail.this.portfolioWatchAdv != null) {
                        if (((PortfolioDetail)PortfolioDetail.this).portfolioWatchAdv.rdCollateral.isSelected()) {
                            PortfolioDetail.this.setTabType(((PortfolioDetail)PortfolioDetail.this).portfolioWatchAdv.rdCollateral.getText(), true);
                        } else {
                            PortfolioDetail.this.setTabType(((PortfolioDetail)PortfolioDetail.this).portfolioWatchAdv.rdOpenPosition.getText(), false);
                        }
                    } else if (PortfolioDetail.this.portfolioWatchHistorical != null) {
                        if (((PortfolioDetail)PortfolioDetail.this).portfolioWatchHistorical.rdCollateral.isSelected()) {
                            PortfolioDetail.this.setTabType(((PortfolioDetail)PortfolioDetail.this).portfolioWatchHistorical.rdCollateral.getText(), true);
                        } else {
                            PortfolioDetail.this.setTabType(((PortfolioDetail)PortfolioDetail.this).portfolioWatchHistorical.rdOpenPosition.getText(), false);
                        }
                    }
                    Util.setMessage((JLabel)PortfolioDetail.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                }
                catch (Exception ex) {
                    if (PortfolioDetail.this.portfolioWatchAdv != null) {
                        if (((PortfolioDetail)PortfolioDetail.this).portfolioWatchAdv.rdCollateral.isSelected()) {
                            Util.setMessage((JLabel)PortfolioDetail.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Collaterals");
                        } else {
                            Util.setMessage((JLabel)PortfolioDetail.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Open Position");
                        }
                        ((PortfolioDetail)PortfolioDetail.this).portfolioWatchAdv.Mwh.RemoveAllSymbolFromWatch();
                    } else if (PortfolioDetail.this.portfolioWatchHistorical != null) {
                        if (((PortfolioDetail)PortfolioDetail.this).portfolioWatchHistorical.rdCollateral.isSelected()) {
                            Util.setMessage((JLabel)PortfolioDetail.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Collaterals");
                        } else {
                            Util.setMessage((JLabel)PortfolioDetail.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Open Position");
                        }
                        ((PortfolioDetail)PortfolioDetail.this).portfolioWatchHistorical.Mwh.RemoveAllSymbolFromWatch();
                    }
                    PortfolioDetail.this.mediator.PrintLog(ex, "");
                }
            }
        }.start();
    }

    protected void setDetails() {
        this.getPortfolioDetail();
    }

    protected void resetScripField() {
        LogsKSE.SelectedSymbol = "";
        this.lblLegendCollateral.setText("");
        this.lblLegendHoldingType.setText("");
        this.lblLegendScrip.setText("");
        this.lblLengendCash.setText("");
        this.lblLegendCollateral.setIcon(null);
        this.lblLegendHoldingType.setIcon(null);
        this.lblLegendScrip.setIcon(null);
        this.lblLengendCash.setIcon(null);
        this.txtAvgPrice.setText("");
        this.txtCurrentPrice.setText("");
        this.txtCurrentWorth.setText("");
        this.txtHoldingCurrentWorth.setText("");
        this.txtHoldingInvestment.setText("");
        this.txtHoldingProfitLoss.setText("");
        this.txtInvestment.setText("");
        this.txtNetQuantity.setText("");
        this.txtNetWorth.setText("");
        this.txtPofitLoss.setText("");
        this.txtWorthCollaterals.setText("");
        this.txtWorthLedgerBalance.setText("");
        this.txtWorthProfitLoss.setText("");
        this.txtWorthSoldCollaterals.setText("");
        this.btnLiquidateSingle.setText("Liquidate");
        this.btnLiquidateSingle.setToolTipText(this.btnLiquidateSingle.getText());
        this.enableDisableButton(false);
        this.pnlChartScrip.removeAll();
        this.pnlChartScrip.repaint();
        this.pnlChartPortfolio.removeAll();
        this.pnlChartPortfolio.repaint();
        if (this.portfolioWatchAdv != null) {
            this.portfolioWatchAdv.Mwh.RemoveAllSymbolFromWatch();
        } else if (this.portfolioWatchHistorical != null) {
            this.portfolioWatchHistorical.Mwh.RemoveAllSymbolFromWatch();
        }
    }

    private DefaultPieDataset createScripDatasetAdvance(double currentWorth, double totalInvestment) {
        DefaultPieDataset result = new DefaultPieDataset();
        try {
            if (this.portfolioWatchAdv.Scriplist.size() == 1) {
                result.setValue((Comparable)((Object)this.scrip), (Number)new Double(currentWorth));
            } else {
                this.perScripInvestment = currentWorth / totalInvestment * 100.0;
                this.perTotalInvestment = 100.0 - this.perScripInvestment;
                result.setValue((Comparable)((Object)("Others " + this.lblTabType.getText())), (Number)new Double(totalInvestment - currentWorth));
                result.setValue((Comparable)((Object)this.scrip), (Number)new Double(currentWorth));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private DefaultPieDataset createScripDatasetHistorical(double currentWorth, double totalInvestment) {
        DefaultPieDataset result = new DefaultPieDataset();
        try {
            if (this.portfolioWatchHistorical.Scriplist.size() == 1) {
                result.setValue((Comparable)((Object)this.scrip), (Number)new Double(currentWorth));
            } else {
                this.perScripInvestment = currentWorth / totalInvestment * 100.0;
                this.perTotalInvestment = 100.0 - this.perScripInvestment;
                result.setValue((Comparable)((Object)("Others " + this.lblTabType.getText())), (Number)new Double(totalInvestment - currentWorth));
                result.setValue((Comparable)((Object)this.scrip), (Number)new Double(currentWorth));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private JFreeChart createScripChart(DefaultPieDataset dataset) {
        JFreeChart chart = ChartFactory.createPieChart3D(null, (PieDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        Point2D.Float center = new Point2D.Float(150.0f, 90.0f);
        float radius = 300.0f;
        float[] dist = new float[]{0.0f, 0.5f};
        RadialGradientPaint p = new RadialGradientPaint(center, radius, dist, new Color[]{this.OtherCollateralsColor, this.OtherCollateralsColor.brighter()});
        RadialGradientPaint p2 = new RadialGradientPaint(center, radius, dist, new Color[]{this.scripColor, this.scripColor.brighter()});
        plot.setLabelGenerator(null);
        plot.setBackgroundAlpha(0.0f);
        plot.setForegroundAlpha(0.3f);
        plot.setInsets(RectangleInsets.ZERO_INSETS);
        plot.setNoDataMessage("");
        plot.setSectionPaint((Comparable)((Object)this.scrip), (Paint)p2);
        plot.setSectionPaint((Comparable)((Object)("Others " + this.lblTabType.getText())), (Paint)p);
        plot.setToolTipGenerator(new PieToolTipGenerator(){

            public String generateToolTip(PieDataset ds, Comparable com) {
                try {
                    if (PortfolioDetail.this.isPrice.isSelected()) {
                        if (ds.getKeys().contains("Others " + PortfolioDetail.this.lblTabType.getText())) {
                            return PortfolioDetail.this.scrip + " : " + Util.format2digit((String)(ds.getValue((Comparable)((Object)PortfolioDetail.this.scrip)) + "")) + "  (" + Util.format2digit((String)(PortfolioDetail.this.perScripInvestment + "")) + "%)  |  Others " + PortfolioDetail.this.lblTabType.getText() + " : " + Util.format2digit((String)(ds.getValue((Comparable)((Object)("Others " + PortfolioDetail.this.lblTabType.getText()))) + "")) + "  (" + Util.format2digit((String)(PortfolioDetail.this.perTotalInvestment + "")) + "%)";
                        }
                        return PortfolioDetail.this.scrip + " : " + Util.format2digit((String)(ds.getValue((Comparable)((Object)PortfolioDetail.this.scrip)) + "")) + "  (100.00%)  |  Others " + PortfolioDetail.this.lblTabType.getText() + " :  0.00  (0.00%)";
                    }
                    if (PortfolioDetail.this.isVolume.isSelected()) {
                        if (ds.getKeys().contains("Others " + PortfolioDetail.this.lblTabType.getText())) {
                            return PortfolioDetail.this.scrip + " : " + Util.format0digit((String)(ds.getValue((Comparable)((Object)PortfolioDetail.this.scrip)) + "")) + "  (" + Util.format2digit((String)(PortfolioDetail.this.perScripInvestment + "")) + "%)  |  Others " + PortfolioDetail.this.lblTabType.getText() + " : " + Util.format0digit((String)(ds.getValue((Comparable)((Object)("Others " + PortfolioDetail.this.lblTabType.getText()))) + "")) + "  (" + Util.format2digit((String)(PortfolioDetail.this.perTotalInvestment + "")) + "%)";
                        }
                        return PortfolioDetail.this.scrip + " : " + Util.format0digit((String)(ds.getValue((Comparable)((Object)PortfolioDetail.this.scrip)) + "")) + "  (100%)  |  Others " + PortfolioDetail.this.lblTabType.getText() + " :  0  (0%)";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "";
            }
        });
        return chart;
    }

    private void createScripChart(final double scripInvestment, final double totalInvestment) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int diffWidth = 6;
                int diffheight = 6;
                DefaultPieDataset dataset = null;
                if (PortfolioDetail.this.portfolioWatchAdv != null) {
                    dataset = PortfolioDetail.this.createScripDatasetAdvance(scripInvestment, totalInvestment);
                } else if (PortfolioDetail.this.portfolioWatchHistorical != null) {
                    dataset = PortfolioDetail.this.createScripDatasetHistorical(scripInvestment, totalInvestment);
                }
                JFreeChart chart = PortfolioDetail.this.createScripChart(dataset);
                chart.setBackgroundPaint(null);
                ChartPanel chartPanel = new ChartPanel(chart);
                chartPanel.setPreferredSize(new Dimension(((PortfolioDetail)PortfolioDetail.this).pnlChartScrip.getSize().width + diffWidth, ((PortfolioDetail)PortfolioDetail.this).pnlChartScrip.getSize().height + diffheight));
                chartPanel.setBounds(-diffWidth / 2, -diffheight / 2, ((PortfolioDetail)PortfolioDetail.this).pnlChartScrip.getSize().width + diffWidth, ((PortfolioDetail)PortfolioDetail.this).pnlChartScrip.getSize().height + diffheight);
                chartPanel.setPopupMenu(null);
                PortfolioDetail.this.pnlChartScrip.removeAll();
                PortfolioDetail.this.pnlChartScrip.add((Component)chartPanel);
                PortfolioDetail.this.pnlChartScrip.repaint();
            }
        });
    }

    private DefaultPieDataset createPortfolioDataset(double collaterals, double ledgerBalance, double soldCollaterals) {
        DefaultPieDataset result = new DefaultPieDataset();
        double sold = ledgerBalance + soldCollaterals;
        double allInv = collaterals + sold;
        this.perCollaterals = collaterals / allInv * 100.0;
        this.perSold = sold / allInv * 100.0;
        result.setValue((Comparable)((Object)this.lblLegendCollateral.getText()), (Number)new Double(collaterals));
        result.setValue((Comparable)((Object)this.lblLengendCash.getText()), (Number)new Double(sold));
        return result;
    }

    private JFreeChart createPortfolioChart(DefaultPieDataset dataset) {
        JFreeChart chart = ChartFactory.createPieChart3D(null, (PieDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        Point2D.Float center = new Point2D.Float(150.0f, 90.0f);
        float radius = 300.0f;
        float[] dist = new float[]{0.0f, 0.5f};
        RadialGradientPaint p = new RadialGradientPaint(center, radius, dist, new Color[]{this.collateralsColor, this.collateralsColor.brighter()});
        RadialGradientPaint p2 = new RadialGradientPaint(center, radius, dist, new Color[]{this.cashColor, this.cashColor.brighter()});
        plot.setLabelGenerator(null);
        plot.setBackgroundAlpha(0.0f);
        plot.setForegroundAlpha(0.3f);
        plot.setInsets(RectangleInsets.ZERO_INSETS);
        plot.setNoDataMessage("");
        plot.setSectionPaint((Comparable)((Object)this.lblLengendCash.getText()), (Paint)p2);
        plot.setSectionPaint((Comparable)((Object)this.lblLegendCollateral.getText()), (Paint)p);
        plot.setToolTipGenerator(new PieToolTipGenerator(){

            public String generateToolTip(PieDataset ds, Comparable com) {
                try {
                    return PortfolioDetail.this.lblLengendCash.getText() + " : " + Util.format2digit((String)(ds.getValue((Comparable)((Object)PortfolioDetail.this.lblLengendCash.getText())) + "")) + "  (" + Util.format2digit((String)(PortfolioDetail.this.perSold + "")) + "%)  |  " + PortfolioDetail.this.lblLegendCollateral.getText() + " : " + Util.format2digit((String)(ds.getValue((Comparable)((Object)PortfolioDetail.this.lblLegendCollateral.getText())) + "")) + "  (" + Util.format2digit((String)(PortfolioDetail.this.perCollaterals + "")) + "%)";
                }
                catch (Exception ex) {
                    return "";
                }
            }
        });
        return chart;
    }

    private void createPortfolioChart(final double collaterals, final double ledgerBalance, final double soldCollaterals) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int diffWidth = 6;
                int diffheight = 6;
                DefaultPieDataset dataset = PortfolioDetail.this.createPortfolioDataset(collaterals, ledgerBalance, soldCollaterals);
                JFreeChart chart = PortfolioDetail.this.createPortfolioChart(dataset);
                chart.setBackgroundPaint(null);
                chart.setBorderPaint((Paint)PortfolioDetail.this.Green);
                chart.setBorderVisible(false);
                ChartPanel chartPanel = new ChartPanel(chart);
                chartPanel.setPreferredSize(new Dimension(((PortfolioDetail)PortfolioDetail.this).pnlChartPortfolio.getSize().width + 6, ((PortfolioDetail)PortfolioDetail.this).pnlChartPortfolio.getSize().height + 6 + 100));
                chartPanel.setBounds(-3, -3, ((PortfolioDetail)PortfolioDetail.this).pnlChartPortfolio.getSize().width + 6, ((PortfolioDetail)PortfolioDetail.this).pnlChartPortfolio.getSize().height + 6);
                chartPanel.setPopupMenu(null);
                chartPanel.setOpaque(true);
                PortfolioDetail.this.pnlChartPortfolio.removeAll();
                PortfolioDetail.this.pnlChartPortfolio.add((Component)chartPanel);
                PortfolioDetail.this.pnlChartPortfolio.repaint();
            }
        });
    }

    public void openTradeWindowAdvance() {
        if (LogCommon.isUnattended) {
            return;
        }
        if (this.scrip.trim().length() <= 0) {
            return;
        }
        if (this.txtNetQuantity.getText().trim().length() <= 0) {
            return;
        }
        if (this.portfolioWatchAdv.getSelectedAccountNo().equalsIgnoreCase("")) {
            return;
        }
        String Market = UtilKSE.GetMarketFromsymbol((String)this.scrip);
        if (!OutstandingLogUtil.isScripInOutstandinglog(this.scrip, this.portfolioWatchAdv.getSelectedAccountNo())) {
            int Volume = Integer.parseInt(this.txtNetQuantity.getText().replaceAll("\\,", ""));
            String Account = this.portfolioWatchAdv.getSelectedAccountNo();
            String TransType = "";
            String WinType = "";
            if (this.isBuy) {
                TransType = "BUY";
                WinType = "Buy";
            } else {
                TransType = "SELL";
                WinType = "Sell";
            }
            OrderBean bean = new OrderBean();
            bean.setMarket(Market);
            bean.setOrderType("MKT");
            bean.setOrderTransactionType(TransType);
            bean.setScrip(this.scrip);
            bean.setVolume(Volume);
            bean.setPrice(0.0);
            bean.setAccount(Account);
            bean.setPIN("");
            if (bean.getOrderTransactionType().equalsIgnoreCase("SELL")) {
                bean.setOrderTransactionType("SEL");
            } else if (WinType.equalsIgnoreCase("SHORT SELL")) {
                bean.setOrderTransactionType("SHS");
            }
            this.openWindow(bean);
        } else {
            String msg = Util.format0digit((String)(OutstandingLogUtil.ScripInOutstandinglogCount(this.scrip) + "")) + " shares of '" + this.scrip + "' are already outstanding in the market and can not be liquidated.";
            MyOptionPane.showMessage(MessageType.Information, msg, "Liquidate Order", true);
        }
    }

    public void openTradeWindowHistorical() {
        if (LogCommon.isUnattended) {
            return;
        }
        if (this.scrip.trim().length() <= 0) {
            return;
        }
        if (this.txtNetQuantity.getText().trim().length() <= 0) {
            return;
        }
        if (this.portfolioWatchHistorical.getSelectedAccountNo().equalsIgnoreCase("")) {
            return;
        }
        String Market = UtilKSE.GetMarketFromsymbol((String)this.scrip);
        if (!OutstandingLogUtil.isScripInOutstandinglog(this.scrip, this.portfolioWatchHistorical.getSelectedAccountNo())) {
            int Volume = Integer.parseInt(this.txtNetQuantity.getText().replaceAll("\\,", ""));
            String Account = this.portfolioWatchHistorical.getSelectedAccountNo();
            String TransType = "";
            String WinType = "";
            if (this.isBuy) {
                TransType = "BUY";
                WinType = "Buy";
            } else {
                TransType = "SELL";
                WinType = "Sell";
            }
            OrderBean bean = new OrderBean();
            bean.setMarket(Market);
            bean.setOrderType("MKT");
            bean.setOrderTransactionType(TransType);
            bean.setScrip(this.scrip);
            bean.setVolume(Volume);
            bean.setPrice(0.0);
            bean.setAccount(Account);
            bean.setPIN("");
            if (bean.getOrderTransactionType().equalsIgnoreCase("SELL")) {
                bean.setOrderTransactionType("SEL");
            } else if (WinType.equalsIgnoreCase("SHORT SELL")) {
                bean.setOrderTransactionType("SHS");
            }
            this.openWindow(bean);
        } else {
            String msg = Util.format0digit((String)(OutstandingLogUtil.ScripInOutstandinglogCount(this.scrip) + "")) + " shares of '" + this.scrip + "' are already outstanding in the market and can not be liquidated.";
            MyOptionPane.showMessage(MessageType.Information, msg, "Liquidate Order", true);
        }
    }

    private void openWindow(OrderBean ord) {
        String WinType = ord.getOrderTransactionType();
        OrderConfirmation OC = new OrderConfirmation(WinType, ord, true);
        this.jd = new NxGDialogBox((Frame)TradeCast.getInstance().frame, true);
        try {
            if (AppConfig.houseIcon == null) {
                AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jd.setIconImage(AppConfig.houseIcon);
        this.jd.getContentPane().add(OC);
        if (WinType.equalsIgnoreCase("Sell")) {
            this.jd.setTitle(this.languageCentre.getValue(LanguageConstant.Sell) + " " + this.languageCentre.getValue(LanguageConstant.OrderConfirmation));
        } else if (WinType.equalsIgnoreCase("Buy")) {
            this.jd.setTitle(this.languageCentre.getValue(LanguageConstant.Buy) + " " + this.languageCentre.getValue(LanguageConstant.OrderConfirmation));
        } else {
            this.jd.setTitle(this.languageCentre.getValue(WinType.replaceAll("\\s", "")) + " " + this.languageCentre.getValue(LanguageConstant.OrderConfirmation));
        }
        if (Util.isWindow7()) {
            this.jd.setSize(320, 225);
        } else {
            this.jd.setSize(320, 220);
        }
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension d = kit.getScreenSize();
        this.jd.setLocation(new Point((d.width - 320) / 2, (d.height - 190) / 2));
        this.jd.setResizable(false);
        this.jd.setVisible(true);
    }

    public void setMessage(MessageType messageType, String message) {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)messageType, (String)message);
    }

    protected void enableDisableButton(boolean b) {
        if (!this.scrip.equalsIgnoreCase("")) {
            MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(this.scrip, UtilKSE.GetMarketFromsymbol((String)this.scrip));
            if (mktFeed == null) {
                this.btnLiquidateAll.setEnabled(false);
                this.btnLiquidateSingle.setEnabled(false);
            } else if (LogsKSE.MarketStauts.toUpperCase().indexOf("PRE") >= 0 || LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP")) {
                this.btnLiquidateAll.setEnabled(false);
                this.btnLiquidateSingle.setEnabled(false);
            } else {
                this.btnLiquidateAll.setEnabled(b);
                this.btnLiquidateSingle.setEnabled(b);
            }
        } else {
            this.btnLiquidateAll.setEnabled(false);
            this.btnLiquidateSingle.setEnabled(false);
        }
    }

    private void updateScripChartValues() {
        if (this.isPrice.isSelected()) {
            this.createScripChart(this.currentWorth, Double.parseDouble(this.holding));
        } else if (this.isVolume.isSelected()) {
            if (this.portfolioWatchAdv != null) {
                this.createScripChart(this.netQuantity, this.portfolioWatchAdv.netQty);
            } else if (this.portfolioWatchHistorical != null) {
                this.createScripChart(this.netQuantity, this.portfolioWatchHistorical.netQty);
            }
        }
    }

    void setRBName(String get) {
        this.collateralsType = get;
        this.lblLegendCollateral.setText(get);
        this.lblLegendCollateral.setToolTipText(get);
    }

    private void setOrderFromAdvance() {
        Hashtable all = this.portfolioWatchAdv.Mwh.GetAllScripWithFeed();
        if (this.portfolioWatchAdv.Scriplist.size() > 0) {
            ArrayList<OrderBean> executelist = new ArrayList<OrderBean>();
            ArrayList<OrderBean> outstandinglist = new ArrayList<OrderBean>();
            for (int i = 0; i < this.portfolioWatchAdv.Scriplist.size(); ++i) {
                String scr = this.portfolioWatchAdv.Scriplist.get(i);
                MarketFeed feed = (MarketFeed)all.get(scr);
                int vol = Integer.parseInt(feed.netQty.replaceAll("\\,", ""));
                OrderBean ord = new OrderBean();
                ord.setAccount(this.portfolioWatchAdv.getSelectedAccountNo());
                ord.setMarket(feed.market);
                ord.setVolume(Math.abs(vol));
                ord.setScrip(feed.symbol);
                if (vol >= 0) {
                    ord.setOrderType("SEL");
                    ord.setOrderTransactionType("SEL");
                } else {
                    ord.setOrderType("BUY");
                    ord.setOrderTransactionType("BUY");
                }
                if (this.isInOusstandingLog(scr)) {
                    outstandinglist.add(ord);
                    continue;
                }
                executelist.add(ord);
            }
            LiquidateAllOrderDialog executeMarket = new LiquidateAllOrderDialog(TradeCast.getInstance().frame, this.portfolioWatchAdv.getSelectedAccountNo(), executelist, outstandinglist);
            executelist.clear();
        }
    }

    private void setOrderFromHistorical() {
        Hashtable all = this.portfolioWatchHistorical.Mwh.GetAllScripWithFeed();
        if (this.portfolioWatchHistorical.Scriplist.size() > 0) {
            ArrayList<OrderBean> executelist = new ArrayList<OrderBean>();
            ArrayList<OrderBean> outstandinglist = new ArrayList<OrderBean>();
            for (int i = 0; i < this.portfolioWatchHistorical.Scriplist.size(); ++i) {
                String scr = this.portfolioWatchHistorical.Scriplist.get(i);
                MarketFeed feed = (MarketFeed)all.get(scr);
                int vol = Integer.parseInt(feed.netQty.replaceAll("\\,", ""));
                OrderBean ord = new OrderBean();
                ord.setAccount(this.portfolioWatchHistorical.getSelectedAccountNo());
                ord.setMarket(feed.market);
                ord.setVolume(Math.abs(vol));
                ord.setScrip(feed.symbol);
                if (vol >= 0) {
                    ord.setOrderType("SEL");
                    ord.setOrderTransactionType("SEL");
                } else {
                    ord.setOrderType("BUY");
                    ord.setOrderTransactionType("BUY");
                }
                if (this.isInOusstandingLog(scr)) {
                    outstandinglist.add(ord);
                    continue;
                }
                executelist.add(ord);
            }
            LiquidateAllOrderDialog executeMarket = new LiquidateAllOrderDialog(TradeCast.getInstance().frame, this.portfolioWatchHistorical.getSelectedAccountNo(), executelist, outstandinglist);
            executelist.clear();
        }
    }

    private boolean isInOusstandingLog(String scr) {
        boolean isFound = false;
        if (scr.indexOf(";") >= 0) {
            String sym = scr.split("\\;", -1)[0];
            if (this.portfolioWatchAdv != null) {
                if (OutstandingLogUtil.isScripInOutstandinglog(sym, this.portfolioWatchAdv.getSelectedAccountNo())) {
                    isFound = true;
                }
            } else if (this.portfolioWatchHistorical != null && OutstandingLogUtil.isScripInOutstandinglog(sym, this.portfolioWatchHistorical.getSelectedAccountNo())) {
                isFound = true;
            }
        }
        return isFound;
    }
}

