/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import Beans.MarketWatchBean;
import Beans.Tradelog;
import CATALYST.Control.ColumnData;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MarketWatchEvent;
import CATALYST.Control.MarketWatchListner;
import CATALYST.Control.Utilities;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LoadLogs;
import Utilities.LogsTC;
import Utilities.ThreadWithName;
import Watches.HistoricalValuePanelContainer;
import Watches.PortfolioDetail;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.JTextFieldFilter;
import common.gui.component.NxGScrollBarUI;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.interfaces.MarketData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Document;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXCollapsiblePane;

public class PortfolioWatchHistorical
extends JPanel
implements MarketWatchListner,
ActionListener,
MarketData {
    PortfolioDetail portfolioDetail = null;
    private HistoricalValuePanelContainer pnlHistoricalDataContainer = null;
    AutoCompleteSupport autoComplete = null;
    public MarketWatch Mwh;
    private Mediator mediator = Mediator.getInstance();
    private String scrip = "";
    ArrayList<String> Scriplist = new ArrayList();
    ArrayList<Timer> list = new ArrayList();
    private Timer timer = new Timer(){

        @Override
        public void cancel() {
            PortfolioWatchHistorical.this.list.remove(this);
            super.cancel();
        }
    };
    long lastCallTime = 0L;
    private final long delayInRefresh = 30000L;
    public int netQty = 0;
    private Hashtable<String, String> Tab = new Hashtable();
    public static final int indexScrip = 0;
    public static final int indexNetQuantity = 1;
    public static final int indexAvgPrice = 2;
    public static final int indexCloseProce = 3;
    public String lastValues = "";
    private String lastScrip = "";
    private String lastMarket = "";
    private boolean isScripLoaded = false;
    private boolean LoadSymbol = true;
    JPanel pnl = new JPanel(new BorderLayout(0, 0));
    private int dividerSize = 88;
    private boolean isFlag = false;
    private boolean isHistorical = true;
    JScrollPane spliterScrollPane = new JScrollPane();
    private HashMap<String, Integer> columnIndex = new HashMap();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnAnnualStatement;
    private JToggleButton btnChange;
    private JToggleButton btnExpand;
    private JButton btnQuarterlyStatement;
    private JButton btnRefresh;
    private JButton btnScripDetail;
    private JButton btnWatchAdvDetail;
    private JComboBox cbAccountNo;
    private JXCollapsiblePane collapsiblePane;
    private JXCollapsiblePane collapsiblePaneHist;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTable jTable1;
    private JToolBar jToolBar1;
    private JLabel lblAccount;
    private JLabel lblNew;
    private JLabel lblSymbol;
    private JLabel lblSymbolName;
    private JPanel pnlMain;
    public JRadioButton rdCollateral;
    public JRadioButton rdOpenPosition;
    private JScrollPane scrollPane;
    private JSplitPane splitPane;
    private JTextField txtSymbol;

    private void setColumnIndex() {
        int index = 0;
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Market), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Scrip), index++);
        this.columnIndex.put(this.languageCentre.getValue("BuyVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Buy), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Sell), index++);
        this.columnIndex.put(this.languageCentre.getValue("SellVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LastPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue("Change"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.High), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Low), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.TotalVolume), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Average), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.PercentChange), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LowerLock), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.UpperCap), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Trade), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.CompanySnapshot), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Analytics), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Graph), index++);
        this.columnIndex.put(this.languageCentre.getValue("MarketCap"), index++);
        this.columnIndex.put(this.languageCentre.getValue("NetQuantity"), index++);
        if (AppConfig.isAvgPriceInMarketWatch) {
            this.columnIndex.put(this.languageCentre.getValue("AveragePrice"), index++);
        }
        this.columnIndex.put(this.languageCentre.getValue("Period"), index++);
        this.columnIndex.put(this.languageCentre.getValue("P/E"), index++);
        this.columnIndex.put(this.languageCentre.getValue("DividendYield"), index++);
        this.columnIndex.put(this.languageCentre.getValue("P/B"), index++);
        this.columnIndex.put(this.languageCentre.getValue("EPS"), index++);
        this.columnIndex.put(this.languageCentre.getValue("Dir"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdTime"), index++);
        this.columnIndex.put(this.languageCentre.getValue("TotalTrd"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdVolume"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.ClosePrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.OpenPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.State), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Flag), index++);
        this.columnIndex.put(this.languageCentre.getValue("OutstandingShares"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekLow"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekAvg"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekHigh"), index++);
    }

    public PortfolioWatchHistorical() {
        try {
            this.initComponents();
            this.setColumnIndex();
            this.mediator.setPortfolioWatchHistorical(this);
            this.Mwh = new MarketWatch("Portfolio", this.columnIndex);
            boolean index = false;
            this.pnlHistoricalDataContainer = new HistoricalValuePanelContainer(this, this.lblSymbolName);
            ColumnData[] m_columns_with_avg_price = new ColumnData[]{new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Scrip), 100, 2), new ColumnData(this.Mwh, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.High), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Low), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LowerLock), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.UpperCap), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Trade), 90, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.CompanySnapshot), 150, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Analytics), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Graph), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("MarketCap"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("NetQuantity"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("AveragePrice"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Period"), 80, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("P/E"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("DividendYield"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("P/B"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("EPS"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.OpenPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.State), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue("OutstandingShares"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekLow"), 90, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekAvg"), 90, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekHigh"), 90, 4)};
            ColumnData[] m_columns = new ColumnData[]{new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Scrip), 100, 2), new ColumnData(this.Mwh, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.High), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Low), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LowerLock), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.UpperCap), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Trade), 90, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.CompanySnapshot), 150, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Analytics), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Graph), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("MarketCap"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("NetQuantity"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Period"), 80, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("P/E"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("DividendYield"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("P/B"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("EPS"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.OpenPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.State), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue("OutstandingShares"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekLow"), 90, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekAvg"), 90, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekHigh"), 90, 4)};
            this.Mwh.isHistoricalDataWatch = AppConfig.isHistoricalDataWatch;
            this.Mwh.ChangeAllColorAndFonts(MyColors.MarketWatchRowColor, MyColors.MarketWatchSelectedRowColor, MyColors.MarketWatchIncreaseColor, MyColors.MarketWatchDecreaseColor, LogCommon.MarketWatchFont);
            this.Mwh.SetHeight = new JFrame().getToolkit().getScreenSize().height - 500;
            this.Mwh.SetWidth = new JFrame().getToolkit().getScreenSize().width + 130;
            this.Mwh.setVisible(true);
            this.Mwh.setMarket(LogCommon.markets);
            this.Mwh.Debug = false;
            this.Mwh.addListener((MarketWatchListner)this);
            this.Mwh.isUserAddScrip = false;
            this.Mwh.isDuplicateScrip = false;
            this.Mwh.ShowTradeButton = AppConfig.ShowTradeButton;
            this.Mwh.ShowCompanySnapButton = AppConfig.ShowCompanySnapshotButton;
            this.Mwh.ShowGraphButton = AppConfig.ShowGraphButton;
            this.Mwh.ShowAnalyticsButton = AppConfig.ShowAnalyticsButton;
            this.Mwh.isStandardCapital = AppConfig.isStandardCapital;
            if (AppConfig.isAvgPriceInMarketWatch) {
                this.Mwh.init(m_columns_with_avg_price);
            } else {
                this.Mwh.init(m_columns);
            }
            this.Mwh.setDefaultColumnIndex();
            this.txtSymbol.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    PortfolioWatchHistorical.this.txtSymbol.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
            this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
            this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
            this.autoComplete = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
            this.autoComplete.setStrict(true);
            this.cbAccountNo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (evt.getModifiers() == 16) {
                        PortfolioWatchHistorical.this.SendScripRequest();
                    } else if (evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                        PortfolioWatchHistorical.this.SendScripRequest();
                    }
                }
            });
            this.rdOpenPosition.addActionListener(this);
            this.rdCollateral.addActionListener(this);
            this.btnRefresh.addActionListener(this);
            this.rdCollateral.setSelected(true);
            ButtonGroup group = new ButtonGroup();
            group.add(this.rdOpenPosition);
            group.add(this.rdCollateral);
            this.lblSymbolName.setFont(this.lblSymbolName.getFont().deriveFont(1));
            this.lblSymbolName.setText(" ");
            this.txtSymbol.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        if (PortfolioWatchHistorical.this.SymbolExist()) {
                            PortfolioWatchHistorical.this.Mwh.AddSymbolInMarketWatch(PortfolioWatchHistorical.this.txtSymbol.getText() + ";" + UtilKSE.GetMarketFromsymbol((String)PortfolioWatchHistorical.this.txtSymbol.getText()), false, false);
                        }
                        PortfolioWatchHistorical.this.txtSymbol.select(0, PortfolioWatchHistorical.this.txtSymbol.getText().length());
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.portfolioDetail = new PortfolioDetail(null, this);
            this.scrollPane.setViewportView((Component)this.Mwh);
            this.spliterScrollPane.setHorizontalScrollBarPolicy(31);
            this.spliterScrollPane.setVerticalScrollBarPolicy(20);
            UIManager.put("ScrollBar.background", 1);
            JScrollBar vbar = this.spliterScrollPane.getVerticalScrollBar();
            NxGScrollBarUI ui2 = new NxGScrollBarUI();
            ui2.setMyScrollBarUI(vbar);
            vbar.setPreferredSize(new Dimension(7, 0));
            this.spliterScrollPane.setHorizontalScrollBarPolicy(31);
            this.spliterScrollPane.setViewportView(this.jPanel2);
            this.splitPane.setBorder(null);
            this.splitPane.setTopComponent(this.spliterScrollPane);
            this.collapsiblePane.add((Component)this.portfolioDetail);
            this.collapsiblePaneHist.add((Component)this.pnlHistoricalDataContainer);
            this.collapsiblePane.setCollapsed(true);
            this.collapsiblePaneHist.setCollapsed(true);
            this.splitPane.setDividerLocation(0);
            this.splitPane.setBorder(null);
            this.splitPane.setDividerSize(0);
            this.empty();
            this.Mwh.scrollPane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    Rectangle rec = PortfolioWatchHistorical.this.Mwh.GetTable().getVisibleRect();
                }
            });
            this.btnScripDetail.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/scripDetail.png")));
            this.btnAnnualStatement.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/AnnualStatements.png")));
            this.btnQuarterlyStatement.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/QuarterlyStatement.png")));
            if (LogCommon.NewCount > 2) {
                this.jToolBar1.remove(this.lblNew);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mediator.PrintLog(ex, "");
        }
        this.Tab.put("a", this.languageCentre.getValue("ClientInfo"));
        this.Tab.put("b", this.languageCentre.getValue("Portfolio"));
        this.Tab.put("c", this.languageCentre.getValue("Collaterals"));
        this.Tab.put("d", this.languageCentre.getValue("OpenPosition"));
        this.Tab.put("g", this.languageCentre.getValue("CumulativeSummary"));
        this.setLanguageValues();
    }

    private void empty() {
        this.lblSymbolName.setText("");
        this.txtSymbol.setText("");
        this.pnlHistoricalDataContainer.empty();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblAccount = new JLabel();
        this.txtSymbol = new JTextField();
        this.lblSymbolName = new JLabel();
        this.lblSymbol = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.jToolBar1 = new JToolBar();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.rdCollateral = new JRadioButton();
        this.rdOpenPosition = new JRadioButton();
        this.lblNew = new JLabel();
        this.btnScripDetail = new JButton();
        this.btnAnnualStatement = new JButton();
        this.btnQuarterlyStatement = new JButton();
        this.btnRefresh = new JButton();
        this.btnWatchAdvDetail = new JButton();
        this.btnExpand = new JToggleButton();
        this.btnChange = new JToggleButton();
        this.splitPane = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.collapsiblePane = new JXCollapsiblePane();
        this.collapsiblePaneHist = new JXCollapsiblePane();
        this.pnlMain = new JPanel();
        this.scrollPane = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.jPanel1.setMinimumSize(new Dimension(0, 25));
        this.jPanel1.setPreferredSize(new Dimension(473, 25));
        this.lblAccount.setFont(new Font("Tahoma", 1, 11));
        this.lblAccount.setText("Account");
        this.lblSymbolName.setText("jLabel2");
        this.lblSymbol.setFont(new Font("Tahoma", 1, 11));
        this.lblSymbol.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.lblSymbol.setText("Scrip");
        this.lblSymbol.setHorizontalTextPosition(2);
        this.cbAccountNo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.add(this.filler1);
        this.rdCollateral.setText("Collaterals");
        this.rdCollateral.setFocusable(false);
        this.rdCollateral.setHorizontalTextPosition(4);
        this.rdCollateral.setMaximumSize(new Dimension(110, 23));
        this.rdCollateral.setMinimumSize(new Dimension(110, 23));
        this.rdCollateral.setPreferredSize(new Dimension(80, 23));
        this.rdCollateral.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioWatchHistorical.this.rdCollateralActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.rdCollateral);
        this.rdOpenPosition.setText("Open Position");
        this.rdOpenPosition.setFocusable(false);
        this.rdOpenPosition.setHorizontalTextPosition(4);
        this.rdOpenPosition.setMaximumSize(new Dimension(110, 23));
        this.rdOpenPosition.setMinimumSize(new Dimension(110, 23));
        this.rdOpenPosition.setPreferredSize(new Dimension(90, 23));
        this.jToolBar1.add(this.rdOpenPosition);
        this.lblNew.setIcon(new ImageIcon(this.getClass().getResource("/Images/new.gif")));
        this.lblNew.setMaximumSize(new Dimension(30, 21));
        this.lblNew.setMinimumSize(new Dimension(30, 21));
        this.lblNew.setPreferredSize(new Dimension(30, 21));
        this.jToolBar1.add(this.lblNew);
        this.btnScripDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnScripDetail.setToolTipText("Scrip Details");
        this.btnScripDetail.setFocusable(false);
        this.btnScripDetail.setHorizontalTextPosition(0);
        this.btnScripDetail.setName("PortfolioWatchHistorical -> btnScripDetail");
        this.btnScripDetail.setVerticalTextPosition(3);
        this.btnScripDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioWatchHistorical.this.btnScripDetailActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnScripDetail);
        this.btnAnnualStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnAnnualStatement.setToolTipText("Annual Statements");
        this.btnAnnualStatement.setFocusable(false);
        this.btnAnnualStatement.setHorizontalTextPosition(0);
        this.btnAnnualStatement.setName("PortfolioWatchHistorical -> btnAnnualStatement");
        this.btnAnnualStatement.setVerticalTextPosition(3);
        this.btnAnnualStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioWatchHistorical.this.btnAnnualStatementActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnAnnualStatement);
        this.btnQuarterlyStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnQuarterlyStatement.setToolTipText("Quarterly Statements");
        this.btnQuarterlyStatement.setFocusable(false);
        this.btnQuarterlyStatement.setHorizontalTextPosition(0);
        this.btnQuarterlyStatement.setName("PortfolioWatchHistorical -> btnQuarterlysttement");
        this.btnQuarterlyStatement.setVerticalTextPosition(3);
        this.btnQuarterlyStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioWatchHistorical.this.btnQuarterlyStatementActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnQuarterlyStatement);
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setToolTipText("Refresh");
        this.btnRefresh.setFocusable(false);
        this.btnRefresh.setHorizontalTextPosition(4);
        this.btnRefresh.setMaximumSize(new Dimension(23, 23));
        this.btnRefresh.setMinimumSize(new Dimension(23, 23));
        this.btnRefresh.setName("PortfolioWatchHistorical -> btnRefresh");
        this.btnRefresh.setPreferredSize(new Dimension(23, 23));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioWatchHistorical.this.btnRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnRefresh);
        this.btnWatchAdvDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
        this.btnWatchAdvDetail.setText("Details");
        this.btnWatchAdvDetail.setFocusable(false);
        this.btnWatchAdvDetail.setHorizontalTextPosition(4);
        this.btnWatchAdvDetail.setMaximumSize(new Dimension(65, 23));
        this.btnWatchAdvDetail.setMinimumSize(new Dimension(65, 23));
        this.btnWatchAdvDetail.setName("PortfolioWatchHistorical -> btnWatchAdvDetail");
        this.btnWatchAdvDetail.setPreferredSize(new Dimension(65, 23));
        this.btnWatchAdvDetail.setVerticalTextPosition(3);
        this.btnWatchAdvDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioWatchHistorical.this.btnWatchAdvDetailActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnWatchAdvDetail);
        this.btnWatchAdvDetail.getAccessibleContext().setAccessibleName("Detail");
        this.btnExpand.setIcon(new ImageIcon(this.getClass().getResource("/Images/RightArrow.png")));
        this.btnExpand.setFocusable(false);
        this.btnExpand.setHorizontalTextPosition(0);
        this.btnExpand.setName("PortfolioWatchHistorical -> btnExpand");
        this.btnExpand.setVerticalTextPosition(3);
        this.btnExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioWatchHistorical.this.btnExpandActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnExpand);
        this.btnChange.setIcon(new ImageIcon(this.getClass().getResource("/Images/switch16.png")));
        this.btnChange.setEnabled(false);
        this.btnChange.setFocusable(false);
        this.btnChange.setHorizontalTextPosition(0);
        this.btnChange.setName("PortfolioWatchHistorical -> btnChange");
        this.btnChange.setVerticalTextPosition(3);
        this.btnChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PortfolioWatchHistorical.this.btnChangeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnChange);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.lblAccount).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbAccountNo, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblSymbol).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblSymbolName, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jToolBar1, -2, -1, -2).addGap(3, 3, 3)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(3, 3, 3).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtSymbol, -2, -1, -2).addComponent(this.lblSymbolName).addComponent(this.cbAccountNo, -2, -1, -2).addComponent(this.lblAccount, -2, 14, -2).addComponent(this.lblSymbol))).addComponent(this.jToolBar1, -2, 25, -2)).addContainerGap()));
        jPanel1Layout.linkSize(1, this.lblSymbol, this.lblSymbolName);
        this.splitPane.setOrientation(0);
        this.collapsiblePane.setDirection(JXCollapsiblePane.Direction.RIGHT);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.collapsiblePane, -1, -1, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.collapsiblePane, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addGap(1, 1, 1).addComponent((Component)this.collapsiblePaneHist, -1, 732, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.collapsiblePaneHist, -2, -1, -2).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.splitPane.setLeftComponent(this.jPanel2);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.scrollPane.setViewportView(this.jTable1);
        GroupLayout pnlMainLayout = new GroupLayout(this.pnlMain);
        this.pnlMain.setLayout(pnlMainLayout);
        pnlMainLayout.setHorizontalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 733, Short.MAX_VALUE));
        pnlMainLayout.setVerticalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 94, Short.MAX_VALUE));
        this.splitPane.setBottomComponent(this.pnlMain);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 735, Short.MAX_VALUE).addComponent(this.splitPane, -2, 0, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(1, 1, 1).addComponent(this.splitPane)));
    }

    private void rdCollateralActionPerformed(ActionEvent evt) {
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
    }

    private void btnWatchAdvDetailActionPerformed(ActionEvent evt) {
        this.setCollapseHistorical();
    }

    private void btnExpandActionPerformed(ActionEvent evt) {
        if (!this.collapsiblePane.isCollapsed()) {
            this.btnChange.setEnabled(true);
            this.collapsiblePaneHist.setCollapsed(false);
            this.addHistoricalData(this.lastMarket, this.lastScrip);
            this.collapsiblePane.setCollapsed(true);
            if (this.isFlag) {
                this.splitPane.setDividerLocation(160);
            } else {
                this.splitPane.setDividerLocation(88);
            }
        } else if (!this.collapsiblePaneHist.isCollapsed()) {
            this.btnChange.setEnabled(false);
            this.collapsiblePane.setCollapsed(false);
            this.collapsiblePaneHist.setCollapsed(true);
            this.splitPane.setDividerLocation(220);
        }
    }

    private void btnChangeActionPerformed(ActionEvent evt) {
        this.pnlHistoricalDataContainer.setLayout();
        if (this.btnChange.isSelected()) {
            this.dividerSize = 160;
            this.isFlag = true;
        } else {
            this.dividerSize = 88;
            this.isFlag = false;
        }
        if (this.splitPane.getDividerSize() >= 0) {
            this.jPanel2.setMinimumSize(new Dimension(0, this.dividerSize));
            this.splitPane.setDividerLocation(this.dividerSize);
        }
    }

    private void btnAnnualStatementActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.Statement, LanguageConstant.AnnualStatements);
    }

    private void btnQuarterlyStatementActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.QuarterStatement, LanguageConstant.QuarterlyStatements);
    }

    private void btnScripDetailActionPerformed(ActionEvent evt) {
        this.mediator.openScripDetails(LogsKSE.SelectedSymbol);
        LogCommon.NewCount += 2;
    }

    public String getSelectedAccountNo() {
        String account = "";
        if (this.cbAccountNo.getSelectedItem() != null) {
            account = this.cbAccountNo.getSelectedItem().toString();
        }
        return account;
    }

    public void addHistoricalData(String market, String scrip) {
        if (scrip.length() > 0) {
            this.pnlHistoricalDataContainer.addHistoricalData(market, scrip);
        }
    }

    private void setCollapseHistorical() {
        boolean state = this.collapsiblePane.isCollapsed();
        if (this.btnExpand.isSelected()) {
            if (!this.collapsiblePaneHist.isCollapsed()) {
                this.btnWatchAdvDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
                this.collapsiblePaneHist.setCollapsed(true);
                this.splitPane.setDividerLocation(0);
                this.splitPane.setDividerSize(0);
            } else {
                this.btnChange.setEnabled(true);
                this.collapsiblePaneHist.setCollapsed(false);
                this.addHistoricalData(this.lastMarket, this.lastScrip);
                this.collapsiblePane.setCollapsed(true);
                if (this.isFlag) {
                    this.splitPane.setDividerLocation(160);
                } else {
                    this.splitPane.setDividerLocation(88);
                }
                this.btnWatchAdvDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
            }
        } else if (state) {
            this.btnWatchAdvDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
            this.splitPane.setDividerLocation(220);
            this.splitPane.setDividerSize(5);
            this.splitPane.setEnabled(state);
            this.collapsiblePane.setCollapsed(!state);
        } else {
            this.btnWatchAdvDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
            this.splitPane.setDividerLocation(0);
            this.jPanel2.setMinimumSize(new Dimension(0, 0));
            this.splitPane.setDividerSize(0);
            this.splitPane.setEnabled(state);
            this.collapsiblePane.setCollapsed(!state);
        }
    }

    public synchronized void MarketWatchMessageReceived(MarketWatchEvent event) {
        this.mediator.MarketWatchMessageReceived(event, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.SendScripRequest();
        this.portfolioDetail.setDetails();
    }

    public void SetEmpty(String symbol, boolean isNew) {
        this.txtSymbol.setText("");
        this.lblSymbolName.setText("");
        this.lastMarket = "";
        this.lastScrip = "";
        this.pnlHistoricalDataContainer.empty();
    }

    public void SetSymbol(String symbol, boolean isNew) {
        if (symbol.trim().equalsIgnoreCase("")) {
            return;
        }
        this.txtSymbol.setText(symbol);
        this.SetScripValuesOnDetail(symbol);
        String market = UtilKSE.GetMarketFromsymbol((String)symbol);
        this.scrip = symbol;
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText("Invalid Scrip");
        } else {
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        }
        this.lastMarket = market;
        this.lastScrip = symbol;
        if (!isNew && !this.collapsiblePaneHist.isCollapsed()) {
            this.addHistoricalData(market, symbol);
        }
    }

    public void SendFeedRequest() {
        if (this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PortfolioWatch))) {
            this.mediator.SendMsgToFeedServer("MKT-FEED", "Portfolio Watch Historical : SendFeedRequest");
        }
    }

    public void setSymbol(String str) {
        this.LoadSymbol = false;
        this.SendFeedRequest();
        this.Mwh.RemoveAllSymbolFromWatch();
        String[] Symbols = str.split("\\;", -1);
        for (int i = 0; i < Symbols.length; ++i) {
            if (Symbols[i].length() <= 0) continue;
            this.Mwh.AddSymbolInMarketWatch(Symbols[i].replace(':', ';'), false, false);
        }
        this.Mwh.SelectRow(0);
        this.isScripLoaded = true;
        Util.ScrollToFirstOrLastRow((boolean)true, (JTable)this.Mwh.GetTable(), (JScrollPane)this.Mwh.scrollPane);
    }

    public void SymbolRemove(String Symbol, String Market) {
        this.Mwh.RemoveSymbolFromWatch(Symbol + ";" + Market);
    }

    public void SymbolRemove(String string, boolean b) {
        this.empty();
    }

    public synchronized void SendScripRequest() {
        if (this.rdOpenPosition.isSelected()) {
            LoadLogs OpenPositionScrip = new LoadLogs("OpenPositionScrip=", true);
            new ThreadWithName(OpenPositionScrip, "OpenPositionScrip").start();
        } else if (this.rdCollateral.isSelected()) {
            LoadLogs CollateralScrip = new LoadLogs("CollateralScrip=", true);
            new ThreadWithName(CollateralScrip, "CollateralScrip").start();
        }
        this.portfolioDetail.resetScripField();
        this.portfolioDetail.setDetails();
        this.txtSymbol.setText("");
        this.lblSymbolName.setText("");
        try {
            this.cbAccountNo.setToolTipText(LogsTC.accountAll.get(this.cbAccountNo.getSelectedItem().toString().trim()).toString());
        }
        catch (Exception ex) {
            this.cbAccountNo.setToolTipText(null);
        }
    }

    public void setAllScrip(String scrip) {
        try {
            LogsKSE.PortfolioWatchScrip = "";
            this.netQty = 0;
            this.Mwh.RemoveAllSymbolFromWatch();
            this.Scriplist.clear();
            if (scrip.indexOf("|") >= 0) {
                String[] row = scrip.split("\\|", -1);
                for (int i = 0; i < row.length; ++i) {
                    if (row[i].equalsIgnoreCase("")) continue;
                    String[] data = row[i].split("\\;", -1);
                    String sym = data[0] + ":" + UtilKSE.GetMarketFromsymbol((String)data[0]) + ";";
                    this.Scriplist.add(data[0] + ";" + UtilKSE.GetMarketFromsymbol((String)data[0]));
                    LogsKSE.PortfolioWatchScrip = LogsKSE.PortfolioWatchScrip + sym;
                    this.Mwh.AddSymbolInPortfolioMarketWatch(data[0], UtilKSE.GetMarketFromsymbol((String)data[0]), data[1], data[2], data[3], false, false);
                    this.netQty += Integer.parseInt(data[1]);
                }
            } else {
                this.portfolioDetail.resetScripField();
                this.txtSymbol.setText("");
                this.lblSymbolName.setText("");
            }
            this.mediator.setMarketData("MarketWatchAllScrip", LogsKSE.PortfolioWatchScrip.replaceAll("\\|", ";"), "", null, this);
            this.mediator.SendMsgToFeedServer("MKT-FEED|" + LogsKSE.PortfolioWatchScrip, "Portfolio Watch Historical: setAllScrip");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mediator.PrintLog(ex, "");
        }
    }

    public void setScrip() {
        try {
            if (this.lastValues.indexOf("|") >= 0) {
                String[] row = this.lastValues.split("\\|", -1);
                for (int i = 0; i < row.length; ++i) {
                    if (row[i].equalsIgnoreCase("")) continue;
                    String[] data = row[i].split("\\;", -1);
                    this.Mwh.setNetQtyAvgPriceAndClosePrice(data[0], UtilKSE.GetMarketFromsymbol((String)data[0]), data[1], data[2], data[3]);
                }
            }
        }
        catch (Exception ex) {
            this.mediator.PrintLog(ex, "");
        }
    }

    public void updateAccount() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (PortfolioWatchHistorical.this.autoComplete != null) {
                        PortfolioWatchHistorical.this.autoComplete.uninstall();
                        PortfolioWatchHistorical.this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
                        PortfolioWatchHistorical.this.autoComplete = AutoCompleteSupport.install((JComboBox)PortfolioWatchHistorical.this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
                        PortfolioWatchHistorical.this.autoComplete.setStrict(true);
                        PortfolioWatchHistorical.this.SendScripRequest();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void SetScripValuesOnDetail(String scrip) {
        if (this.portfolioDetail != null) {
            this.portfolioDetail.setScripValues(scrip, false);
        }
    }

    public void FeedReceived() {
        if (this.portfolioDetail != null) {
            this.portfolioDetail.setScripValues(this.scrip, true);
        }
        this.setScrip();
    }

    public void openTradeWindow() {
        if (!LogsKSE.MarketStauts.equalsIgnoreCase("OHO") && !LogsKSE.MarketStauts.equalsIgnoreCase("OHP")) {
            this.portfolioDetail.openTradeWindowHistorical();
        }
    }

    public void onTradeLogReceived(String message, boolean isMyOrder) {
        try {
            String[] fillog;
            if (message.indexOf("FIL$") >= 0 && (fillog = Utilities.split((String)message, (char)'$')).length >= 2) {
                this.prepairForParse(fillog[2]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void prepairForParse(String log) throws Exception {
        String[] logList = Utilities.split((String)log, (char)'|');
        for (int i = 0; i < logList.length; ++i) {
            if (logList[i].trim().length() <= 0 || logList[i].trim().length() <= 0) continue;
            this.parse(logList[i]);
        }
    }

    public void parse(String order_string) {
        try {
            Tradelog tlog = new Tradelog();
            if (tlog.parse(order_string)) {
                this.refresh(tlog);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private boolean SymbolExist() {
        String scr = this.txtSymbol.getText() + ";" + UtilKSE.GetMarketFromsymbol((String)this.txtSymbol.getText());
        return this.Scriplist.contains(scr);
    }

    private void refresh(Tradelog tlog) {
        String account = tlog.Tradelog_ACCOUNT;
        String scr = tlog.Tradelog_SYMBOL + ";" + UtilKSE.GetMarketFromsymbol((String)tlog.Tradelog_SYMBOL);
        if ((account.equalsIgnoreCase(this.getSelectedAccountNo()) || this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PortfolioWatch))) && this.Scriplist.contains(scr)) {
            long diff = Calendar.getInstance().getTimeInMillis() - this.lastCallTime;
            if (diff >= 30000L) {
                this.lastCallTime += diff;
                MyTimerTask timerTask = new MyTimerTask();
                this.timer = new Timer();
                this.list.add(this.timer);
                this.timer.schedule((TimerTask)timerTask, 30000L);
            } else {
                try {
                    this.timer.cancel();
                    MyTimerTask timerTask = new MyTimerTask();
                    this.timer = new Timer();
                    this.list.add(this.timer);
                    this.timer.schedule((TimerTask)timerTask, 30000L);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    public void setMessage(MessageType messageType, String message) {
        this.portfolioDetail.setMessage(messageType, message);
    }

    public void enableDisableButton(boolean b) {
        this.portfolioDetail.enableDisableButton(b);
    }

    public void initOffHourSettings(boolean isOffHour) {
        this.portfolioDetail.enableDisableButton(isOffHour);
    }

    public void setRBName() {
        if (LogsKSE.Portfolio_Tab_Detail != null && LogsKSE.Portfolio_Tab_Detail.length() > 0) {
            LogsKSE.Portfolio_Tab_Detail = LogsKSE.Portfolio_Tab_Detail.replaceAll("\\|", "");
            String[] TabList = LogsKSE.Portfolio_Tab_Detail.split("\\;", -1);
            for (int i = 0; i < TabList.length; ++i) {
                if (TabList[i].length() <= 0) continue;
                this.Tab.put(TabList[i].split("\\,", -1)[1], TabList[i].split("\\,", -1)[0]);
            }
        }
        this.SetTabNames();
    }

    private void SetTabNames() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.rdCollateral.setText(this.Tab.get("c"));
            this.rdOpenPosition.setText(this.Tab.get("d"));
            this.portfolioDetail.setRBName(this.Tab.get("c"));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PortfolioWatchHistorical.this.rdCollateral.setText((String)PortfolioWatchHistorical.this.Tab.get("c"));
                    PortfolioWatchHistorical.this.rdOpenPosition.setText((String)PortfolioWatchHistorical.this.Tab.get("d"));
                    PortfolioWatchHistorical.this.portfolioDetail.setRBName((String)PortfolioWatchHistorical.this.Tab.get("c"));
                }
            });
        }
    }

    public void setMarketData(String market, String scrip, MarketWatchBean b) {
        this.Mwh.setMarketData(market, scrip, b.period, b.marketcap, b.pricetoearning, b.dividendYield, b.pricetobook, b.eps, b.outstandingshares, b._52weekavgvol, b._52weekhigh, b._52weeklow);
    }

    public void GetSymbol() {
        if (this.LoadSymbol) {
            LoadLogs PortfolioSymbol = new LoadLogs("PortfolioSymbol=", true);
            new ThreadWithName(PortfolioSymbol, "PortfolioSymbol").start();
        } else {
            this.SendScripRequest();
        }
    }

    private void setLanguageValues() {
        this.lblAccount.setText(this.languageCentre.getValue("Account"));
        this.lblSymbol.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.rdCollateral.setText(this.languageCentre.getValue("Collaterals"));
        this.rdOpenPosition.setText(this.languageCentre.getValue("OpenPosition"));
        this.btnRefresh.setToolTipText(this.languageCentre.getValue(LanguageConstant.Refresh));
        this.btnWatchAdvDetail.setText(this.languageCentre.getValue(LanguageConstant.Details));
        this.btnWatchAdvDetail.getAccessibleContext().setAccessibleName(this.languageCentre.getValue(LanguageConstant.Details));
        this.btnScripDetail.setToolTipText(this.languageCentre.getValue(LanguageConstant.ScripDetails));
        this.btnAnnualStatement.setToolTipText(this.languageCentre.getValue(LanguageConstant.AnnualStatements));
        this.btnQuarterlyStatement.setToolTipText(this.languageCentre.getValue(LanguageConstant.QuarterlyStatements));
    }

    class MyTimerTask
    extends TimerTask {
        MyTimerTask() {
        }

        @Override
        public void run() {
            PortfolioWatchHistorical.this.SendScripRequest();
        }
    }
}

