/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import Beans.MarketWatchBean;
import CATALYST.Control.ColumnData;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MarketWatchEvent;
import CATALYST.Control.MarketWatchListner;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import Watches.HistoricalValuePanelContainer;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.JTextFieldFilter;
import common.gui.component.NxGScrollBarUI;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.interfaces.MarketData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.text.Document;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXCollapsiblePane;

public class SectorWatchHistorical
extends JPanel
implements MarketWatchListner,
MarketData,
ActionListener {
    public MarketWatch Mwh;
    public JPopupMenu popup = new JPopupMenu();
    public static String ltPrice = "";
    public static String sys = "";
    private Mediator mediator = Mediator.getInstance();
    private String LastSector = "";
    private AutoCompleteSupport autoComplete;
    private HistoricalValuePanelContainer pnlHistoricalDataContainer = null;
    private String lastScrip = "";
    private String lastMarket = "";
    private boolean isScripLoaded = false;
    private boolean LoadSymbol = true;
    private boolean isLastScrip = false;
    private int dividerSize = 88;
    JScrollPane spliterScrollPane = new JScrollPane();
    private HashMap<String, Integer> columnIndex = new HashMap();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnAnnualStatement;
    private JToggleButton btnChange;
    private JButton btnDetail;
    private JButton btnQuarterlyStatement;
    private JButton btnScripDetail;
    private JComboBox cbSectorlist;
    private JXCollapsiblePane collapsiblePane;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JToolBar jToolBar1;
    private JLabel lblNew;
    private JLabel lblSectorCount;
    private JLabel lblSectorPerformance;
    private JLabel lblSymbol;
    private JLabel lblSymbolName;
    private JPanel pnlTools;
    private JPanel pnlWatch;
    private JSplitPane splitPane;
    private JTextField txtSymbol;

    private void setColumnIndex() {
        int index = 0;
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Market), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Scrip), index++);
        this.columnIndex.put(this.languageCentre.getValue("BuyVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Buy), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Sell), index++);
        this.columnIndex.put(this.languageCentre.getValue("SellVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LastPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue("Change"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.High), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Low), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.TotalVolume), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Average), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.PercentChange), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LowerLock), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.UpperCap), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Trade), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.CompanySnapshot), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Analytics), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Graph), index++);
        this.columnIndex.put(this.languageCentre.getValue("MarketCap"), index++);
        this.columnIndex.put(this.languageCentre.getValue("Period"), index++);
        this.columnIndex.put(this.languageCentre.getValue("P/E"), index++);
        this.columnIndex.put(this.languageCentre.getValue("DividendYield"), index++);
        this.columnIndex.put(this.languageCentre.getValue("P/B"), index++);
        this.columnIndex.put(this.languageCentre.getValue("EPS"), index++);
        this.columnIndex.put(this.languageCentre.getValue("Dir"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdTime"), index++);
        this.columnIndex.put(this.languageCentre.getValue("TotalTrd"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdVolume"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.ClosePrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.OpenPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.State), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Flag), index++);
        this.columnIndex.put(this.languageCentre.getValue("OutstandingShares"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekLow"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekAvg"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekHigh"), index++);
    }

    public SectorWatchHistorical() {
        try {
            this.initComponents();
            this.setColumnIndex();
            this.Mwh = new MarketWatch(LanguageConstant.SectorWatch, this.columnIndex);
            this.mediator.setSectorWatchHistorical(this);
            this.pnlHistoricalDataContainer = new HistoricalValuePanelContainer(this, this.lblSymbolName);
            ColumnData[] m_columns = new ColumnData[]{new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Scrip), 100, 2), new ColumnData(this.Mwh, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.High), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Low), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LowerLock), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.UpperCap), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Trade), 80, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.CompanySnapshot), 150, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Analytics), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Graph), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("MarketCap"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Period"), 80, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("P/E"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("DividendYield"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("P/B"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("EPS"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.OpenPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.State), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue("OutstandingShares"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekLow"), 90, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekAvg"), 90, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekHigh"), 90, 4)};
            this.Mwh.isHistoricalDataWatch = AppConfig.isHistoricalDataWatch;
            this.Mwh.ChangeAllColorAndFonts(MyColors.MarketWatchRowColor, MyColors.MarketWatchSelectedRowColor, MyColors.MarketWatchIncreaseColor, MyColors.MarketWatchDecreaseColor, LogCommon.MarketWatchFont);
            this.Mwh.setMarket(LogCommon.markets);
            this.Mwh.Debug = false;
            this.Mwh.addListener((MarketWatchListner)this);
            this.Mwh.isUserAddScrip = false;
            this.Mwh.ShowTradeButton = AppConfig.ShowTradeButton;
            this.Mwh.ShowCompanySnapButton = AppConfig.ShowCompanySnapshotButton;
            this.Mwh.ShowGraphButton = AppConfig.ShowGraphButton;
            this.Mwh.ShowAnalyticsButton = AppConfig.ShowAnalyticsButton;
            this.Mwh.isStandardCapital = AppConfig.isStandardCapital;
            this.Mwh.init(m_columns);
            this.Mwh.setDefaultColumnIndex();
            this.Mwh.comboBox.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
            this.Mwh.comboBox.removeItem("");
            this.pnlWatch.add((Component)this.Mwh, "Center");
            this.pnlWatch.repaint();
            this.lblSectorPerformance.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.SectorPerformance) + "</b></html>");
            this.lblSectorPerformance.setIcon(new ImageIcon(this.getClass().getResource("/Images/sectorPer.png")));
            this.lblSectorPerformance.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ((SectorWatchHistorical)SectorWatchHistorical.this).mediator.tradecast.ShowDynamicForm(FormName.SectorPerformance, LanguageConstant.SectorPerformance);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    SectorWatchHistorical.this.lblSectorPerformance.setCursor(Cursor.getPredefinedCursor(12));
                    SectorWatchHistorical.this.lblSectorPerformance.setText("<html><u><b>" + SectorWatchHistorical.this.languageCentre.getValue(LanguageConstant.SectorPerformance) + "</b></u></html>");
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SectorWatchHistorical.this.lblSectorPerformance.setCursor(Cursor.getPredefinedCursor(0));
                    SectorWatchHistorical.this.lblSectorPerformance.setText("<html><b>" + SectorWatchHistorical.this.languageCentre.getValue(LanguageConstant.SectorPerformance) + "</b></html>");
                }
            });
            this.cbSectorlist.addActionListener(this);
            this.cbSectorlist.setForeground(Color.GRAY);
            this.cbSectorlist.setMaximumRowCount(30);
            this.lblSymbolName.setFont(this.lblSymbolName.getFont().deriveFont(1));
            this.lblSymbol.setFont(this.lblSymbol.getFont().deriveFont(1));
            this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
            this.collapsiblePane.add((Component)this.pnlHistoricalDataContainer);
            JPanel pnl = new JPanel();
            pnl.setBackground(Color.red);
            pnl.setLayout(new BorderLayout());
            pnl.add((Component)this.collapsiblePane, "Center");
            this.spliterScrollPane.setHorizontalScrollBarPolicy(30);
            this.spliterScrollPane.setVerticalScrollBarPolicy(20);
            UIManager.put("ScrollBar.background", 1);
            JScrollBar vbar = this.spliterScrollPane.getVerticalScrollBar();
            NxGScrollBarUI ui2 = new NxGScrollBarUI();
            ui2.setMyScrollBarUI(vbar);
            vbar.setPreferredSize(new Dimension(7, 0));
            this.spliterScrollPane.setHorizontalScrollBarPolicy(30);
            this.spliterScrollPane.setViewportView(pnl);
            this.splitPane.setBorder(null);
            this.splitPane.setLeftComponent(this.spliterScrollPane);
            this.setCollaspe();
            this.empty();
            this.btnScripDetail.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/scripDetail.png")));
            this.btnAnnualStatement.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/AnnualStatements.png")));
            this.btnQuarterlyStatement.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/QuarterlyStatement.png")));
            if (LogCommon.NewCount > 2) {
                this.jToolBar1.remove(this.lblNew);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLanguageValues();
    }

    void SetSectorInCombo(ArrayList SectorName) {
        if (this.cbSectorlist.getItemCount() <= 1) {
            Vector<String> Sector = new Vector<String>();
            Sector.add("Please Select a Sector");
            for (int i = 0; i < SectorName.size(); ++i) {
                if (SectorName.get(i).toString().trim().length() <= 0 || SectorName.get(i).toString().trim().equalsIgnoreCase("100INDEX") || SectorName.get(i).toString().trim().equalsIgnoreCase("30INDEX") || SectorName.get(i).toString().trim().equalsIgnoreCase("KMI30INDEX") || SectorName.get(i).toString().trim().equalsIgnoreCase("OGTIINDEX") || SectorName.get(i).toString().trim().equalsIgnoreCase("BKTIINDEX") || SectorName.get(i).toString().trim().equalsIgnoreCase("UPP9") || SectorName.get(i).toString().trim().equalsIgnoreCase("NITPGI") || SectorName.get(i).toString().trim().equalsIgnoreCase("NBPPGI") || SectorName.get(i).toString().trim().equalsIgnoreCase("MZNPI") || SectorName.get(i).toString().trim().equalsIgnoreCase("KMIALLSHR")) continue;
                Sector.add(SectorName.get(i).toString());
            }
            if (this.autoComplete != null) {
                this.autoComplete.uninstall();
            }
            this.cbSectorlist.setModel(new DefaultComboBoxModel(Sector));
            this.autoComplete = AutoCompleteSupport.install((JComboBox)this.cbSectorlist, (EventList)GlazedLists.eventListOf((Object[])Sector.toArray()));
            this.autoComplete.setStrict(true);
            String Sector2 = this.cbSectorlist.getSelectedItem().toString();
            if (Sector2.equalsIgnoreCase("Please Select a Sector")) {
                int count = this.cbSectorlist.getItemCount() - 1;
                if (count <= 1) {
                    this.lblSectorCount.setText(count + " " + this.languageCentre.getValue(LanguageConstant.Sector));
                } else {
                    this.lblSectorCount.setText(count + " " + this.languageCentre.getValue(LanguageConstant.Sectors));
                }
            }
        }
    }

    void SectorSelectChange() {
        String Sector = this.cbSectorlist.getSelectedItem().toString();
        if (Sector.equalsIgnoreCase("Please Select a Sector")) {
            this.Mwh.RemoveAllSymbolFromWatch();
            this.txtSymbol.setText("");
            this.lblSymbolName.setText("");
            int count = this.cbSectorlist.getItemCount() - 1;
            if (count <= 1) {
                this.lblSectorCount.setText(count + " " + this.languageCentre.getValue(LanguageConstant.Sector));
            } else {
                this.lblSectorCount.setText(count + " " + this.languageCentre.getValue(LanguageConstant.Sector));
            }
            return;
        }
        if (!this.LastSector.equalsIgnoreCase(Sector)) {
            this.Mwh.RemoveAllSymbolFromWatch();
            this.isLastScrip = false;
            this.mediator.SendMsgToFeedServer("MKT-FEED|SECTOR:" + Sector, "Sector Watch Historical : SectorSelectChange False");
            if (LogCommon.SectorAndIndicesSymbol.containsKey(Sector)) {
                StringBuilder sb = new StringBuilder();
                ArrayList Arr = (ArrayList)LogCommon.SectorAndIndicesSymbol.get(Sector);
                for (int i = 0; i < Arr.size(); ++i) {
                    if (Arr.get(i).toString().trim().length() <= 0) continue;
                    this.Mwh.AddSymbolInMarketWatch(Arr.get(i).toString().trim() + ";REG", false, false);
                    sb.append(Arr.get(i).toString().trim()).append(":REG;");
                }
                this.mediator.setMarketData("MarketWatchAllScrip", sb.toString(), "", null, this);
                this.isLastScrip = true;
                this.Mwh.SelectRow(0);
                Util.ScrollToFirstOrLastRow((boolean)true, (JTable)this.Mwh.GetTable(), (JScrollPane)this.Mwh.scrollPane);
                this.lblSectorCount.setText(Arr.size() - 1 + " " + this.languageCentre.getValue(LanguageConstant.Scrip));
            }
            this.LastSector = Sector;
        } else {
            this.mediator.SendMsgToFeedServer("MKT-FEED|SECTOR:" + Sector, "Sector Watch Historical : SectorSelectChange True");
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.cbSectorlist) {
            this.SectorSelectChange();
            if (this.cbSectorlist.getSelectedIndex() == 0) {
                this.cbSectorlist.setForeground(Color.GRAY);
            } else {
                this.cbSectorlist.setForeground(Color.BLACK);
            }
        }
    }

    private void setCollaspe() {
        boolean state = this.collapsiblePane.isCollapsed();
        if (state) {
            this.btnDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
            this.addHistoricalData(this.lastMarket, this.lastScrip);
            this.splitPane.setDividerLocation(this.dividerSize);
            this.splitPane.setDividerSize(5);
        } else {
            this.btnDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
            this.splitPane.setDividerLocation(0);
            this.splitPane.setDividerSize(0);
            this.spliterScrollPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (SectorWatchHistorical.this.collapsiblePane.isCollapsed()) {
                        SectorWatchHistorical.this.spliterScrollPane.setMinimumSize(new Dimension(0, 0));
                    } else if (SectorWatchHistorical.this.btnChange.isSelected()) {
                        SectorWatchHistorical.this.spliterScrollPane.setMinimumSize(new Dimension(0, 40));
                    } else {
                        SectorWatchHistorical.this.spliterScrollPane.setMinimumSize(new Dimension(0, 20));
                    }
                }
            });
        }
        this.splitPane.setEnabled(state);
        this.collapsiblePane.setCollapsed(!state);
    }

    private boolean SymbolExist() {
        ArrayList Arr;
        return LogCommon.SectorAndIndicesSymbol.containsKey(this.cbSectorlist.getSelectedItem().toString()) && (Arr = (ArrayList)LogCommon.SectorAndIndicesSymbol.get(this.cbSectorlist.getSelectedItem().toString())).contains(this.txtSymbol.getText());
    }

    private void initComponents() {
        this.pnlTools = new JPanel();
        this.lblSymbol = new JLabel();
        this.txtSymbol = new JTextField();
        this.lblSymbolName = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblNew = new JLabel();
        this.btnScripDetail = new JButton();
        this.btnAnnualStatement = new JButton();
        this.btnQuarterlyStatement = new JButton();
        this.btnDetail = new JButton();
        this.btnChange = new JToggleButton();
        this.lblSectorPerformance = new JLabel();
        this.lblSectorCount = new JLabel();
        this.cbSectorlist = new JComboBox();
        this.jPanel1 = new JPanel();
        this.splitPane = new JSplitPane();
        this.collapsiblePane = new JXCollapsiblePane();
        this.pnlWatch = new JPanel();
        this.pnlTools.setPreferredSize(new Dimension(470, 26));
        this.lblSymbol.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.lblSymbol.setText("Scrip");
        this.lblSymbol.setHorizontalTextPosition(2);
        this.txtSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SectorWatchHistorical.this.txtSymbolActionPerformed(evt);
            }
        });
        this.txtSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SectorWatchHistorical.this.txtSymbolFocusGained(evt);
            }
        });
        this.lblSymbolName.setText("name");
        this.lblSymbolName.setMinimumSize(new Dimension(0, 14));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setPreferredSize(new Dimension(67, 25));
        this.jToolBar1.add(this.filler1);
        this.lblNew.setIcon(new ImageIcon(this.getClass().getResource("/Images/new.gif")));
        this.lblNew.setMaximumSize(new Dimension(30, 21));
        this.lblNew.setMinimumSize(new Dimension(30, 21));
        this.lblNew.setPreferredSize(new Dimension(30, 21));
        this.jToolBar1.add(this.lblNew);
        this.btnScripDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnScripDetail.setToolTipText("Scrip Details");
        this.btnScripDetail.setFocusable(false);
        this.btnScripDetail.setHorizontalTextPosition(0);
        this.btnScripDetail.setName("SectorWatchHistorical -> btnScripDetail");
        this.btnScripDetail.setVerticalTextPosition(3);
        this.btnScripDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SectorWatchHistorical.this.btnScripDetailActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnScripDetail);
        this.btnAnnualStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnAnnualStatement.setToolTipText("Annual Statements");
        this.btnAnnualStatement.setFocusable(false);
        this.btnAnnualStatement.setHorizontalTextPosition(0);
        this.btnAnnualStatement.setName("SectorWatchHistorical -> btnAnnualStatement");
        this.btnAnnualStatement.setVerticalTextPosition(3);
        this.btnAnnualStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SectorWatchHistorical.this.btnAnnualStatementActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnAnnualStatement);
        this.btnQuarterlyStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnQuarterlyStatement.setToolTipText("Quarterly Statements");
        this.btnQuarterlyStatement.setFocusable(false);
        this.btnQuarterlyStatement.setHorizontalTextPosition(0);
        this.btnQuarterlyStatement.setName("SectorWatchHistorical -> btnQuarterlystatement");
        this.btnQuarterlyStatement.setVerticalTextPosition(3);
        this.btnQuarterlyStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SectorWatchHistorical.this.btnQuarterlyStatementActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnQuarterlyStatement);
        this.btnDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
        this.btnDetail.setText("Details");
        this.btnDetail.setToolTipText("Details");
        this.btnDetail.setFocusable(false);
        this.btnDetail.setHorizontalTextPosition(4);
        this.btnDetail.setMaximumSize(new Dimension(65, 23));
        this.btnDetail.setMinimumSize(new Dimension(65, 23));
        this.btnDetail.setName("SectorWatchHistorical -> btnDetail");
        this.btnDetail.setPreferredSize(new Dimension(65, 23));
        this.btnDetail.setVerticalTextPosition(3);
        this.btnDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SectorWatchHistorical.this.btnDetailActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnDetail);
        this.btnChange.setIcon(new ImageIcon(this.getClass().getResource("/Images/switch16.png")));
        this.btnChange.setFocusable(false);
        this.btnChange.setHorizontalTextPosition(0);
        this.btnChange.setName("SectorWatchHistorical -> btnChange");
        this.btnChange.setVerticalTextPosition(3);
        this.btnChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SectorWatchHistorical.this.btnChangeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnChange);
        this.lblSectorPerformance.setText("Sector Performance");
        this.lblSectorCount.setHorizontalAlignment(4);
        this.lblSectorCount.setText("999 Sectors");
        this.lblSectorCount.setMaximumSize(new Dimension(60, 14));
        this.lblSectorCount.setMinimumSize(new Dimension(60, 14));
        this.lblSectorCount.setPreferredSize(new Dimension(60, 14));
        this.cbSectorlist.setEditable(true);
        GroupLayout pnlToolsLayout = new GroupLayout(this.pnlTools);
        this.pnlTools.setLayout(pnlToolsLayout);
        pnlToolsLayout.setHorizontalGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlToolsLayout.createSequentialGroup().addContainerGap().addComponent(this.lblSectorPerformance, -2, 140, -2).addGap(6, 6, 6).addComponent(this.lblSectorCount, -2, 60, -2).addGap(4, 4, 4).addComponent(this.cbSectorlist, -2, 160, -2).addGap(14, 14, 14).addComponent(this.lblSymbol, -2, 50, -2).addGap(5, 5, 5).addComponent(this.txtSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSymbolName, -1, 8, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar1, -2, 191, -2)));
        pnlToolsLayout.setVerticalGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlToolsLayout.createSequentialGroup().addGap(2, 2, 2).addGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSectorPerformance, -2, 22, -2).addComponent(this.lblSectorCount, -2, 22, -2).addComponent(this.cbSectorlist, -2, 22, -2).addComponent(this.lblSymbol, -2, 22, -2).addComponent(this.txtSymbol, -2, 22, -2).addComponent(this.lblSymbolName, -2, 22, -2).addComponent(this.jToolBar1, -2, 22, -2))));
        this.splitPane.setOrientation(0);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setLeftComponent((Component)this.collapsiblePane);
        this.pnlWatch.setLayout(new BorderLayout());
        this.splitPane.setBottomComponent(this.pnlWatch);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, -1, 180, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlTools, -1, 706, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(2, 2, 2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlTools, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private void btnDetailActionPerformed(ActionEvent evt) {
        this.setCollaspe();
    }

    private void txtSymbolFocusGained(FocusEvent evt) {
        this.txtSymbol.selectAll();
    }

    private void txtSymbolActionPerformed(ActionEvent evt) {
        if (this.SymbolExist()) {
            String symbol = this.txtSymbol.getText();
            String[] sm = null;
            if (symbol.indexOf("-") <= 1) {
                this.Mwh.AddSymbolInMarketWatch(symbol + ";REG", false, false);
                this.txtSymbol.select(0, this.txtSymbol.getText().length());
                return;
            }
            sm = this.txtSymbol.getText().split("-");
            if ("REG".equalsIgnoreCase(UtilKSE.GetMarketFromsymbol((String)symbol))) {
                this.Mwh.AddSymbolInMarketWatch(symbol + ";REG", false, false);
            } else {
                this.Mwh.AddSymbolInMarketWatch(symbol + ";" + UtilKSE.GetMarketFromsymbol((String)this.txtSymbol.getText()), false, false);
            }
            this.txtSymbol.select(0, this.txtSymbol.getText().length());
        }
    }

    private void btnChangeActionPerformed(ActionEvent evt) {
        this.pnlHistoricalDataContainer.setLayout();
        this.dividerSize = this.btnChange.isSelected() ? 160 : 88;
        if (this.splitPane.getDividerSize() > 0) {
            this.splitPane.setDividerLocation(this.dividerSize);
        }
    }

    private void btnAnnualStatementActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.Statement, LanguageConstant.AnnualStatements);
    }

    private void btnQuarterlyStatementActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.QuarterStatement, LanguageConstant.QuarterlyStatements);
    }

    private void btnScripDetailActionPerformed(ActionEvent evt) {
        this.mediator.openScripDetails(LogsKSE.SelectedSymbol);
        LogCommon.NewCount += 2;
    }

    public synchronized void MarketWatchMessageReceived(MarketWatchEvent event) {
        this.mediator.MarketWatchMessageReceived(event, this);
    }

    public void addHistoricalData(String market, String scrip) {
        if (scrip.length() > 0) {
            Util.setMessage((JLabel)this.lblSymbolName, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
            this.pnlHistoricalDataContainer.addHistoricalData(market, scrip);
        }
    }

    public void setMarketData(String market, String scrip, MarketWatchBean b) {
        this.Mwh.setMarketData(market, scrip, b.period, b.marketcap, b.pricetoearning, b.dividendYield, b.pricetobook, b.eps, b.outstandingshares, b._52weekavgvol, b._52weekhigh, b._52weeklow);
    }

    public void SymbolRemove(String Symbol, String Market) {
        this.Mwh.RemoveSymbolFromWatch(Symbol + ";" + Market);
    }

    public void SymbolRemove(String string, boolean b) {
        this.empty();
    }

    private void empty() {
        this.lblSymbolName.setText("");
        this.txtSymbol.setText("");
        this.pnlHistoricalDataContainer.empty();
    }

    public void SendFeedRequest() {
        if (this.LastSector.length() > 0) {
            this.mediator.SendMsgToFeedServer("MKT-FEED|SECTOR:" + this.LastSector, "Sector Watch Historical : SendFeedRequest");
        }
    }

    public void SetEmpty(String symbol, boolean isNew) {
        this.txtSymbol.setText("");
        this.lblSymbolName.setText("");
        this.lastMarket = "";
        this.lastScrip = "";
        this.pnlHistoricalDataContainer.empty();
    }

    public void SetSymbol(String symbol, boolean isNew) {
        this.txtSymbol.setText(symbol);
        String market = UtilKSE.GetMarketFromsymbol((String)symbol);
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText(this.languageCentre.getValue(LanguageConstant.InvalidScrip));
        } else {
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        }
        this.lastMarket = market;
        this.lastScrip = symbol;
        if (this.isLastScrip && !isNew && !this.collapsiblePane.isCollapsed()) {
            this.addHistoricalData(market, symbol);
        }
    }

    public void SetSymbol(String symbol) {
        this.txtSymbol.setText(symbol);
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText(this.languageCentre.getValue(LanguageConstant.InvalidScrip));
        } else {
            String name = this.mediator.getSymbolTitle(symbol);
            int lastIndex = name.lastIndexOf("-");
            if (lastIndex > 0) {
                name = name.substring(0, lastIndex);
            }
            this.lblSymbolName.setText(name);
        }
    }

    public void setSymbol(String str) {
        this.LoadSymbol = false;
        this.SendFeedRequest();
        this.Mwh.RemoveAllSymbolFromWatch();
        String[] Symbols = str.split("\\;", -1);
        for (int i = 0; i < Symbols.length; ++i) {
            if (Symbols[i].length() <= 0) continue;
            this.Mwh.AddSymbolInMarketWatch(Symbols[i].replace(':', ';'), false, false);
        }
        this.Mwh.SelectRow(0);
        this.isScripLoaded = true;
        Util.ScrollToFirstOrLastRow((boolean)true, (JTable)this.Mwh.GetTable(), (JScrollPane)this.Mwh.scrollPane);
    }

    public void SetSectorComboSelected(String selectedText) {
        this.cbSectorlist.setSelectedItem(selectedText);
    }

    public void GetSymbol() {
        if (this.LoadSymbol) {
            LoadLogs log = new LoadLogs("SectorSymbol=", true);
            new ThreadWithName(log, "SectorSymbol").start();
        } else {
            this.SendFeedRequest();
        }
    }

    private void setLanguageValues() {
        this.lblSymbol.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.btnScripDetail.setToolTipText(this.languageCentre.getValue(LanguageConstant.ScripDetails));
        this.btnAnnualStatement.setToolTipText(this.languageCentre.getValue(LanguageConstant.AnnualStatements));
        this.btnQuarterlyStatement.setToolTipText(this.languageCentre.getValue(LanguageConstant.QuarterlyStatements));
        this.btnDetail.setText(this.languageCentre.getValue(LanguageConstant.Details));
        this.btnDetail.setToolTipText(this.languageCentre.getValue(LanguageConstant.Details));
        this.lblSectorPerformance.setText(this.languageCentre.getValue(LanguageConstant.SectorPerformance));
    }
}

