/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import Beans.MarketWatchBean;
import CATALYST.Control.ColumnData;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MarketWatchEvent;
import CATALYST.Control.MarketWatchListner;
import CATALYST.Control.Utilities;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import Watches.HistoricalValuePanelContainer;
import common.gui.component.JTextFieldFilter;
import common.gui.component.NxGScrollBarUI;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.interfaces.MarketData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.text.Document;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXCollapsiblePane;

public class SpotWatchHistorical
extends JPanel
implements MarketWatchListner,
MarketData {
    public MarketWatch Mwh;
    public JPopupMenu popup = new JPopupMenu();
    public static String ltPrice = "";
    private Mediator mediator = Mediator.getInstance();
    private HistoricalValuePanelContainer pnlHistoricalDataContainer = null;
    private ArrayList<String> SpotSymbols = new ArrayList<String>(){

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < SpotWatchHistorical.this.SpotSymbols.size(); ++i) {
                sb.append((String)SpotWatchHistorical.this.SpotSymbols.get(i));
            }
            return sb.toString();
        }
    };
    private boolean LoadSpot = true;
    private boolean isScripLoaded = false;
    private boolean isLastScrip = false;
    private String lastScrip = "";
    private String lastMarket = "";
    private int dividerSize = 88;
    JScrollPane spliterScrollPane = new JScrollPane();
    private HashMap<String, Integer> columnIndex = new HashMap();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnAnnualStatement;
    private JToggleButton btnChange;
    private JButton btnDetail;
    private JButton btnQuarterlyStatement;
    private JButton btnScripDetail;
    private JXCollapsiblePane collapsiblePane;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JToolBar jToolBar1;
    private JLabel lblNew;
    private JLabel lblScripBrowse;
    private JLabel lblSymbol;
    private JLabel lblSymbolName;
    private JPanel pnlTools;
    private JPanel pnlWatch;
    private JSplitPane splitPane;
    private JTextField txtSymbol;

    private void setColumnIndex() {
        int index = 0;
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Market), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Scrip), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LowerLock), index++);
        this.columnIndex.put(this.languageCentre.getValue("Payout"), index++);
        this.columnIndex.put(this.languageCentre.getValue("MarketCap"), index++);
        this.columnIndex.put(this.languageCentre.getValue("BuyVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Buy), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Sell), index++);
        this.columnIndex.put(this.languageCentre.getValue("SellVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.UpperCap), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LastPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue("Change"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.PercentChange), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Trade), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Analytics), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Graph), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.CompanySnapshot), index++);
        this.columnIndex.put(this.languageCentre.getValue("Period"), index++);
        this.columnIndex.put(this.languageCentre.getValue("P/E"), index++);
        this.columnIndex.put(this.languageCentre.getValue("DividendYield"), index++);
        this.columnIndex.put(this.languageCentre.getValue("P/B"), index++);
        this.columnIndex.put(this.languageCentre.getValue("EPS"), index++);
        this.columnIndex.put(this.languageCentre.getValue("Dir"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdTime"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.TotalVolume), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Low), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Average), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.High), index++);
        this.columnIndex.put(this.languageCentre.getValue("TotalTrd"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdVolume"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.ClosePrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.OpenPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.State), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Flag), index++);
        this.columnIndex.put(this.languageCentre.getValue("OutstandingShares"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekLow"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekAvg"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekHigh"), index++);
    }

    public SpotWatchHistorical() {
        try {
            this.initComponents();
            this.setColumnIndex();
            this.mediator.setSpotWatchHistorical(this);
            this.Mwh = new MarketWatch("Spot Watch", this.columnIndex);
            this.pnlHistoricalDataContainer = new HistoricalValuePanelContainer(this, this.lblSymbolName);
            ColumnData[] m_columns = new ColumnData[]{new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Scrip), 100, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LowerLock), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Payout"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("MarketCap"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.UpperCap), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Trade), 80, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.CompanySnapshot), 150, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Analytics), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Graph), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("Period"), 80, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("P/E"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("DividendYield"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("P/B"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("EPS"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Low), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.High), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.OpenPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.State), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue("OutstandingShares"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekLow"), 90, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekAvg"), 90, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("52WeekHigh"), 90, 4)};
            this.Mwh.isHistoricalDataWatch = AppConfig.isHistoricalDataWatch;
            this.Mwh.ChangeAllColorAndFonts(MyColors.MarketWatchRowColor, MyColors.MarketWatchSelectedRowColor, MyColors.MarketWatchIncreaseColor, MyColors.MarketWatchDecreaseColor, LogCommon.MarketWatchFont);
            this.Mwh.SetHeight = new JFrame().getToolkit().getScreenSize().height - 500;
            this.Mwh.SetWidth = new JFrame().getToolkit().getScreenSize().width + 130;
            this.Mwh.setMarket(LogCommon.markets);
            this.Mwh.Debug = false;
            this.Mwh.addListener((MarketWatchListner)this);
            this.Mwh.isUserAddScrip = false;
            this.Mwh.ShowTradeButton = AppConfig.ShowTradeButton;
            this.Mwh.ShowCompanySnapButton = AppConfig.ShowCompanySnapshotButton;
            this.Mwh.ShowGraphButton = AppConfig.ShowGraphButton;
            this.Mwh.ShowAnalyticsButton = AppConfig.ShowAnalyticsButton;
            this.Mwh.isStandardCapital = AppConfig.isStandardCapital;
            this.Mwh.init(m_columns);
            this.Mwh.setDefaultColumnIndex();
            this.Mwh.comboBox.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
            this.Mwh.comboBox.removeItem("");
            this.pnlWatch.add((Component)this.Mwh, "Center");
            this.pnlWatch.repaint();
            this.lblScripBrowse.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
            this.lblSymbol.setFont(this.lblSymbol.getFont().deriveFont(1));
            this.lblSymbol.setText("Scrip ");
            this.lblSymbol.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
            this.lblSymbol.setHorizontalTextPosition(2);
            this.lblSymbolName.setFont(this.lblSymbolName.getFont().deriveFont(1));
            this.lblSymbol.setHorizontalAlignment(4);
            this.lblScripBrowse.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ((SpotWatchHistorical)SpotWatchHistorical.this).mediator.tradecast.ShowDynamicForm(FormName.ScripBrowse, LanguageConstant.ScripBrowse);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    SpotWatchHistorical.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(12));
                    SpotWatchHistorical.this.lblScripBrowse.setText("<html><u><b>" + SpotWatchHistorical.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></u></html>");
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SpotWatchHistorical.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(0));
                    SpotWatchHistorical.this.lblScripBrowse.setText("<html><b>" + SpotWatchHistorical.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
                }
            });
            this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
            this.collapsiblePane.add((Component)this.pnlHistoricalDataContainer);
            JPanel pnl = new JPanel();
            pnl.setBackground(Color.red);
            pnl.setLayout(new BorderLayout());
            pnl.add((Component)this.collapsiblePane, "Center");
            this.spliterScrollPane.setHorizontalScrollBarPolicy(30);
            this.spliterScrollPane.setVerticalScrollBarPolicy(20);
            UIManager.put("ScrollBar.background", 1);
            JScrollBar vbar = this.spliterScrollPane.getVerticalScrollBar();
            NxGScrollBarUI ui2 = new NxGScrollBarUI();
            ui2.setMyScrollBarUI(vbar);
            vbar.setPreferredSize(new Dimension(7, 0));
            this.spliterScrollPane.setHorizontalScrollBarPolicy(30);
            this.spliterScrollPane.setViewportView(pnl);
            this.splitPane.setBorder(null);
            this.splitPane.setLeftComponent(this.spliterScrollPane);
            this.setCollaspe();
            this.empty();
            this.btnScripDetail.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/scripDetail.png")));
            this.btnAnnualStatement.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/AnnualStatements.png")));
            this.btnQuarterlyStatement.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/QuarterlyStatement.png")));
            if (LogCommon.NewCount > 2) {
                this.jToolBar1.remove(this.lblNew);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLanguageValues();
    }

    private void setCollaspe() {
        boolean state = this.collapsiblePane.isCollapsed();
        if (state) {
            this.btnDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
            this.addHistoricalData(this.lastMarket, this.lastScrip);
            this.splitPane.setDividerLocation(this.dividerSize);
            this.splitPane.setDividerSize(5);
        } else {
            this.btnDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
            this.splitPane.setDividerLocation(0);
            this.splitPane.setDividerSize(0);
            this.spliterScrollPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (SpotWatchHistorical.this.collapsiblePane.isCollapsed()) {
                        SpotWatchHistorical.this.spliterScrollPane.setMinimumSize(new Dimension(0, 0));
                    } else if (SpotWatchHistorical.this.btnChange.isSelected()) {
                        SpotWatchHistorical.this.spliterScrollPane.setMinimumSize(new Dimension(0, 40));
                    } else {
                        SpotWatchHistorical.this.spliterScrollPane.setMinimumSize(new Dimension(0, 20));
                    }
                }
            });
        }
        this.splitPane.setEnabled(state);
        this.collapsiblePane.setCollapsed(!state);
    }

    private void initComponents() {
        this.pnlTools = new JPanel();
        this.lblScripBrowse = new JLabel();
        this.lblSymbol = new JLabel();
        this.txtSymbol = new JTextField();
        this.lblSymbolName = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblNew = new JLabel();
        this.btnScripDetail = new JButton();
        this.btnAnnualStatement = new JButton();
        this.btnQuarterlyStatement = new JButton();
        this.btnDetail = new JButton();
        this.btnChange = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.splitPane = new JSplitPane();
        this.collapsiblePane = new JXCollapsiblePane();
        this.pnlWatch = new JPanel();
        this.pnlTools.setPreferredSize(new Dimension(470, 26));
        this.lblScripBrowse.setIcon(new ImageIcon(this.getClass().getResource("/Images/symDetail2.png")));
        this.lblScripBrowse.setText("Scrip Browse");
        this.lblScripBrowse.setMaximumSize(new Dimension(95, 16));
        this.lblScripBrowse.setMinimumSize(new Dimension(95, 16));
        this.lblSymbol.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.lblSymbol.setText("Scrip");
        this.lblSymbol.setHorizontalTextPosition(2);
        this.txtSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpotWatchHistorical.this.txtSymbolActionPerformed(evt);
            }
        });
        this.txtSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SpotWatchHistorical.this.txtSymbolFocusGained(evt);
            }
        });
        this.lblSymbolName.setText("name");
        this.lblSymbolName.setMinimumSize(new Dimension(0, 14));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMaximumSize(new Dimension(65, 25));
        this.jToolBar1.setMinimumSize(new Dimension(65, 25));
        this.jToolBar1.setPreferredSize(new Dimension(65, 25));
        this.jToolBar1.add(this.filler1);
        this.lblNew.setIcon(new ImageIcon(this.getClass().getResource("/Images/new.gif")));
        this.lblNew.setMaximumSize(new Dimension(30, 21));
        this.lblNew.setMinimumSize(new Dimension(30, 21));
        this.lblNew.setPreferredSize(new Dimension(30, 21));
        this.jToolBar1.add(this.lblNew);
        this.btnScripDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnScripDetail.setToolTipText("Scrip Details");
        this.btnScripDetail.setFocusable(false);
        this.btnScripDetail.setHorizontalTextPosition(0);
        this.btnScripDetail.setName("SpotWatchHistorical -> btnScripDetail");
        this.btnScripDetail.setVerticalTextPosition(3);
        this.btnScripDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpotWatchHistorical.this.btnScripDetailActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnScripDetail);
        this.btnAnnualStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnAnnualStatement.setToolTipText("Annual Statements");
        this.btnAnnualStatement.setFocusable(false);
        this.btnAnnualStatement.setHorizontalTextPosition(0);
        this.btnAnnualStatement.setName("SpotWatchHistorical -> btnAnnualStatement");
        this.btnAnnualStatement.setVerticalTextPosition(3);
        this.btnAnnualStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpotWatchHistorical.this.btnAnnualStatementActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnAnnualStatement);
        this.btnQuarterlyStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnQuarterlyStatement.setToolTipText("Quarterly Statements");
        this.btnQuarterlyStatement.setFocusable(false);
        this.btnQuarterlyStatement.setHorizontalTextPosition(0);
        this.btnQuarterlyStatement.setName("SpotWatchHistorical -> btnQuarterlyStatement");
        this.btnQuarterlyStatement.setVerticalTextPosition(3);
        this.btnQuarterlyStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpotWatchHistorical.this.btnQuarterlyStatementActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnQuarterlyStatement);
        this.btnDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
        this.btnDetail.setText("Details");
        this.btnDetail.setToolTipText("Details");
        this.btnDetail.setFocusable(false);
        this.btnDetail.setHorizontalTextPosition(4);
        this.btnDetail.setMaximumSize(new Dimension(65, 23));
        this.btnDetail.setMinimumSize(new Dimension(65, 23));
        this.btnDetail.setName("SpotWatchHistorical -> btnDetail");
        this.btnDetail.setVerticalTextPosition(3);
        this.btnDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpotWatchHistorical.this.btnDetailActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnDetail);
        this.btnChange.setIcon(new ImageIcon(this.getClass().getResource("/Images/switch16.png")));
        this.btnChange.setFocusable(false);
        this.btnChange.setHorizontalTextPosition(0);
        this.btnChange.setName("SpotWatchHistorical -> btnChange");
        this.btnChange.setVerticalTextPosition(3);
        this.btnChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpotWatchHistorical.this.btnChangeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnChange);
        GroupLayout pnlToolsLayout = new GroupLayout(this.pnlTools);
        this.pnlTools.setLayout(pnlToolsLayout);
        pnlToolsLayout.setHorizontalGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlToolsLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblScripBrowse, -2, 95, -2).addGap(13, 13, 13).addComponent(this.lblSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSymbolName, -1, 43, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jToolBar1, -2, 193, -2)));
        pnlToolsLayout.setVerticalGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlToolsLayout.createSequentialGroup().addGap(2, 2, 2).addGroup(pnlToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblScripBrowse, -2, 22, -2).addComponent(this.lblSymbol, -2, 22, -2).addComponent(this.txtSymbol, -2, 22, -2).addComponent(this.lblSymbolName, -2, 22, -2).addComponent(this.jToolBar1, -2, 22, -2))));
        this.splitPane.setOrientation(0);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setLeftComponent((Component)this.collapsiblePane);
        this.pnlWatch.setLayout(new BorderLayout());
        this.splitPane.setBottomComponent(this.pnlWatch);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, -1, 150, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlTools, -1, 472, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlTools, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)));
    }

    private void btnDetailActionPerformed(ActionEvent evt) {
        this.setCollaspe();
    }

    private void btnQuarterlyStatementActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.QuarterStatement, LanguageConstant.QuarterlyStatements);
    }

    private void txtSymbolFocusGained(FocusEvent evt) {
        this.txtSymbol.selectAll();
    }

    private void txtSymbolActionPerformed(ActionEvent evt) {
        String symbol = this.txtSymbol.getText();
        String temp = symbol + ":" + UtilKSE.GetMarketFromsymbol((String)symbol) + ";";
        if (this.SpotSymbols.contains(temp)) {
            this.Mwh.AddSymbolInMarketWatch(symbol + ";" + UtilKSE.GetMarketFromsymbol((String)symbol), false, false);
        }
        this.txtSymbol.select(0, this.txtSymbol.getText().length());
    }

    private void btnChangeActionPerformed(ActionEvent evt) {
        this.pnlHistoricalDataContainer.setLayout();
        this.dividerSize = this.btnChange.isSelected() ? 160 : 88;
        if (this.splitPane.getDividerSize() > 0) {
            this.splitPane.setDividerLocation(this.dividerSize);
        }
    }

    private void btnAnnualStatementActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.Statement, LanguageConstant.AnnualStatements);
    }

    private void btnQuarterActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.QuarterStatement, LanguageConstant.QuarterlyStatements);
    }

    private void btnScripDetailActionPerformed(ActionEvent evt) {
        this.mediator.openScripDetails(LogsKSE.SelectedSymbol);
        LogCommon.NewCount += 2;
    }

    public synchronized void MarketWatchMessageReceived(MarketWatchEvent event) {
        this.mediator.MarketWatchMessageReceived(event, null);
    }

    public void addHistoricalData(String market, String scrip) {
        if (scrip.length() > 0) {
            Util.setMessage((JLabel)this.lblSymbolName, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
            this.pnlHistoricalDataContainer.addHistoricalData(market, scrip);
        }
    }

    public void setMarketData(String market, String scrip, MarketWatchBean b) {
        this.Mwh.setMarketData(market, scrip, b.period, b.marketcap, b.pricetoearning, b.dividendYield, b.pricetobook, b.eps, b.outstandingshares, b._52weekavgvol, b._52weekhigh, b._52weeklow);
    }

    public void SymbolRemove(String Symbol, String Market) {
        this.Mwh.RemoveSymbolFromWatch(Symbol + ";" + Market);
    }

    public void SymbolRemove(String string, boolean b) {
        this.empty();
    }

    private void empty() {
        this.lblSymbolName.setText("");
        this.txtSymbol.setText("");
        this.pnlHistoricalDataContainer.empty();
    }

    public void SendFeedRequest() {
        if (this.SpotSymbols.size() > 0 && this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase("Spot Watch")) {
            this.mediator.SendMsgToFeedServer("MKT-FEED|" + this.SpotSymbols, "Spot Watch Historical : SendFeedRequest");
        }
    }

    public void setSymbol(String str) {
        this.LoadSpot = false;
        this.Mwh.RemoveAllSymbolFromWatch();
        this.isLastScrip = false;
        StringBuilder sb = new StringBuilder();
        String[] Symbols = str.split("\\;", -1);
        for (int i = 0; i < Symbols.length; ++i) {
            if (Symbols[i].length() <= 0 || Symbols[i].indexOf(":") <= 0) continue;
            String[] sym = Symbols[i].split("\\:", -1);
            String payout = "";
            if (MarketWatch.Payout.containsKey(sym[0])) {
                payout = (String)MarketWatch.Payout.get(sym[0]);
            }
            this.Mwh.AddSymbolInSpotMarketWatch(sym[0], sym[1], payout, false, false);
            this.SpotSymbols.add(sym[0] + ":" + sym[1] + ";");
            sb.append(sym[0]).append(":").append(sym[1]).append(";");
        }
        this.SendFeedRequest();
        this.Mwh.SelectRow(0);
        this.isLastScrip = true;
        this.isScripLoaded = true;
        this.mediator.setMarketData("MarketWatchAllScrip", sb.toString(), "", null, this);
        Util.ScrollToFirstOrLastRow((boolean)true, (JTable)this.Mwh.GetTable(), (JScrollPane)this.Mwh.scrollPane);
    }

    public void AddSymbol(String Symbol) {
        if (Symbol.indexOf(":") > 0) {
            String[] scripMarket = Symbol.split("\\:", -1);
            String payout = "";
            if (MarketWatch.Payout.containsKey(scripMarket[0])) {
                payout = (String)MarketWatch.Payout.get(scripMarket[0]);
            }
            this.Mwh.AddSymbolInSpotMarketWatch(scripMarket[0], scripMarket[1], payout, false, false);
            if (!this.SpotSymbols.contains(Symbol)) {
                this.SpotSymbols.add(Symbol);
                this.SendFeedRequest();
            }
        } else {
            String payout = "";
            if (MarketWatch.Payout.containsKey(Symbol)) {
                payout = (String)MarketWatch.Payout.get(Symbol);
            }
            this.Mwh.AddSymbolInSpotMarketWatch(Symbol, Utilities.GetMarketFromsymbol((String)Symbol), payout, false, false);
            String scripMarket = Symbol + ":" + Utilities.GetMarketFromsymbol((String)Symbol) + ";";
            if (!this.SpotSymbols.contains(scripMarket)) {
                this.SpotSymbols.add(scripMarket);
                this.SendFeedRequest();
            }
        }
    }

    public void SetEmpty(String symbol, boolean isNew) {
        this.txtSymbol.setText("");
        this.lblSymbolName.setText("");
        this.lastMarket = "";
        this.lastScrip = "";
        this.pnlHistoricalDataContainer.empty();
    }

    public void SetSymbol(String symbol, boolean isNew) {
        this.txtSymbol.setText(symbol);
        String market = UtilKSE.GetMarketFromsymbol((String)symbol);
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText("Invalid Scrip");
        } else {
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        }
        this.lastMarket = market;
        this.lastScrip = symbol;
        if (this.isLastScrip && !isNew && !this.collapsiblePane.isCollapsed()) {
            this.addHistoricalData(market, symbol);
        }
    }

    public void SetSymbol(String symbol) {
        this.txtSymbol.setText(symbol);
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText("Invalid Scrip");
        } else {
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        }
    }

    public void GetSymbol() {
        if (this.LoadSpot) {
            LoadLogs log = new LoadLogs("SpotSymbol=", true);
            new ThreadWithName(log, "SpotSymbol").start();
        } else {
            this.SendFeedRequest();
        }
    }

    private void setLanguageValues() {
        this.lblScripBrowse.setText(this.languageCentre.getValue(LanguageConstant.ScripBrowse));
        this.lblSymbol.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.btnScripDetail.setToolTipText(this.languageCentre.getValue(LanguageConstant.ScripDetails));
        this.btnAnnualStatement.setToolTipText(this.languageCentre.getValue(LanguageConstant.AnnualStatements));
        this.btnQuarterlyStatement.setToolTipText(this.languageCentre.getValue(LanguageConstant.QuarterlyStatements));
        this.btnDetail.setText(this.languageCentre.getValue(LanguageConstant.Details));
        this.btnDetail.setToolTipText(this.languageCentre.getValue(LanguageConstant.Details));
    }
}

