/*
 * Decompiled with CFR 0.152.
 */
package notification;

import common.gui.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import notification.NewJPanel;

public class Toaster {
    private int toasterWidth = 223;
    private int toasterHeight = 92;
    private int spaceBetweenToaster = 5;
    private int spaceFromRight = 2;
    private int step = 5;
    private int stepTime = 20;
    private int displayTime = 7000;
    private int currentNumberOfToaster = 0;
    private int maxToaster = 0;
    private int maxToasterInSceen;
    private Font font = new Font("Tahoma", 1, 12);
    private Color borderColor = new Color(245, 153, 15);
    private Color toasterColor = Color.WHITE;
    private Color messageColor = Color.BLACK;
    int margin;
    boolean useAlwaysOnTop = true;
    private static final long serialVersionUID = 1L;
    SingleToaster singleToaster;

    public void showToaster(Toaster to, String title, String msg, String type) {
        this.singleToaster = new SingleToaster(to, title, msg, type);
        this.singleToaster.animate();
    }

    public void showToaster(Icon icon, String msg, Toaster to, String str) {
    }

    public Font getToasterMessageFont() {
        return this.font;
    }

    public void setToasterMessageFont(Font f) {
        this.font = f;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getDisplayTime() {
        return this.displayTime;
    }

    public void setDisplayTime(int displayTime) {
        this.displayTime = displayTime;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public Color getMessageColor() {
        return this.messageColor;
    }

    public void setMessageColor(Color messageColor) {
        this.messageColor = messageColor;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getStepTime() {
        return this.stepTime;
    }

    public void setStepTime(int stepTime) {
        this.stepTime = stepTime;
    }

    public Color getToasterColor() {
        return this.toasterColor;
    }

    public void setToasterColor(Color toasterColor) {
        this.toasterColor = toasterColor;
    }

    public int getToasterHeight() {
        return this.toasterHeight;
    }

    public void setToasterHeight(int toasterHeight) {
        this.toasterHeight = toasterHeight;
    }

    public int getToasterWidth() {
        return this.toasterWidth;
    }

    public void setToasterWidth(int toasterWidth) {
        this.toasterWidth = toasterWidth;
    }

    class Animation
    extends Thread {
        SingleToaster toaster;
        private boolean isPause = false;

        public Animation(SingleToaster toaster) {
            this.toaster = toaster;
            this.setName("Animation" + toaster.msg);
        }

        public void setPause(boolean pause) {
            this.isPause = pause;
        }

        public void Close() {
            this.toaster.setVisible(false);
        }

        public void setToasterLocation(final int x, final int y) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Animation.this.toaster.setLocation(x, y);
                }
            });
        }

        public void setToasterVisible(final boolean isVisible) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Animation.this.toaster.setVisible(isVisible);
                }
            });
        }

        protected void animateVertically(int posx, int fromY, int toY) throws InterruptedException {
            this.setToasterLocation(posx, fromY);
            if (toY < fromY) {
                for (int i = fromY; i > toY; i -= Toaster.this.step) {
                    this.setToasterLocation(posx, i);
                    Thread.sleep(Toaster.this.stepTime);
                }
            } else {
                for (int i = fromY; i < toY; i += Toaster.this.step) {
                    while (this.isPause) {
                        Thread.sleep(Toaster.this.stepTime);
                    }
                    this.setToasterLocation(posx, i);
                    Thread.sleep(Toaster.this.stepTime);
                }
            }
        }

        private void move() throws InterruptedException {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle screenRect = ge.getMaximumWindowBounds();
            int startYPosition = screenRect.height - Toaster.this.toasterHeight;
            int posx = screenRect.width - Toaster.this.toasterWidth - Toaster.this.spaceFromRight;
            this.setToasterLocation(posx, startYPosition);
        }

        @Override
        public void run() {
            try {
                boolean animateFromBottom = true;
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Rectangle screenRect = ge.getMaximumWindowBounds();
                int screenHeight = screenRect.height;
                int startYPosition = 0;
                int stopYPosition = 0;
                if (screenRect.y > 0) {
                    animateFromBottom = false;
                }
                Toaster.this.maxToasterInSceen = screenHeight / Toaster.this.toasterHeight;
                int posx = screenRect.width - Toaster.this.toasterWidth - Toaster.this.spaceFromRight;
                this.setToasterLocation(posx, screenHeight);
                this.setToasterVisible(true);
                if (Toaster.this.useAlwaysOnTop) {
                    this.toaster.setAlwaysOnTop(true);
                }
                if (animateFromBottom) {
                    startYPosition = screenHeight;
                    stopYPosition = startYPosition - Toaster.this.toasterHeight - 25;
                    if (Toaster.this.currentNumberOfToaster > 0) {
                        stopYPosition -= Toaster.this.maxToaster % Toaster.this.maxToasterInSceen * Toaster.this.toasterHeight + Toaster.this.spaceBetweenToaster * Toaster.this.maxToaster;
                    }
                }
                Toaster.this.currentNumberOfToaster++;
                Toaster.this.maxToaster++;
                this.animateVertically(posx, startYPosition, stopYPosition);
                Thread.sleep(Toaster.this.displayTime);
                while (this.isPause) {
                    Thread.sleep(Toaster.this.stepTime);
                }
                this.animateVertically(posx, stopYPosition, startYPosition);
                Toaster.this.currentNumberOfToaster--;
                Toaster.this.maxToaster--;
                if (Toaster.this.maxToaster < 0) {
                    Toaster.this.maxToaster = 0;
                }
                this.setToasterVisible(false);
                this.toaster.dispose();
            }
            catch (Exception e) {
                if (this.toaster != null) {
                    this.toaster.dispose();
                }
                e.printStackTrace();
            }
        }
    }

    class SingleToaster
    extends JWindow
    implements MouseListener {
        NewJPanel innerPanel = null;
        public Animation animation = new Animation(this);
        private Toaster tot;
        private String title;
        private String msg;

        public SingleToaster(Toaster to, String title, String msg, String type) {
            this.tot = to;
            this.title = title;
            this.msg = msg;
            this.initComponents(type);
            Util.setWindowOpaque((Window)this, (boolean)false);
            this.setAlwaysOnTop(true);
        }

        private void initComponents(String type) {
            this.setSize(Toaster.this.toasterWidth, Toaster.this.toasterHeight);
            this.innerPanel = new NewJPanel(this, this.tot, this.title, this.msg, type);
            this.addMouseListener(this);
            this.innerPanel.setOpaque(false);
            this.getContentPane().add(this.innerPanel);
        }

        public void animate() {
            this.animation.start();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.animation.setPause(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.animation.setPause(false);
        }
    }
}

