/*
 * Decompiled with CFR 0.152.
 */
package testing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.StandardGradientPaintTransformer;

public class BarChartDemo9
extends ApplicationFrame {
    private static final long serialVersionUID = 1L;

    public BarChartDemo9(String s) {
        super(s);
        CategoryDataset categorydataset = BarChartDemo9.createDataset();
        JFreeChart jfreechart = BarChartDemo9.createChart(categorydataset);
        ChartPanel chartpanel = new ChartPanel(jfreechart);
        chartpanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)chartpanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultcategorydataset = new DefaultCategoryDataset();
        defaultcategorydataset.addValue(410.0, (Comparable)((Object)"Network Traffic"), (Comparable)((Object)"Monday"));
        defaultcategorydataset.addValue(680.0, (Comparable)((Object)"Network Traffic"), (Comparable)((Object)"Tuesday"));
        defaultcategorydataset.addValue(530.0, (Comparable)((Object)"Network Traffic"), (Comparable)((Object)"Wednesday"));
        defaultcategorydataset.addValue(570.0, (Comparable)((Object)"Network Traffic"), (Comparable)((Object)"Thursday"));
        defaultcategorydataset.addValue(330.0, (Comparable)((Object)"Network Traffic"), (Comparable)((Object)"Friday"));
        return defaultcategorydataset;
    }

    private static JFreeChart createChart(CategoryDataset categorydataset) {
        JFreeChart jfreechart = ChartFactory.createBarChart((String)"Bar Chart Demo 9", null, (String)"Value", (CategoryDataset)categorydataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        TextTitle texttitle = jfreechart.getTitle();
        texttitle.setBorder(0.0, 0.0, 1.0, 0.0);
        texttitle.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.red, 350.0f, 0.0f, Color.white, true));
        jfreechart.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.yellow, 350.0f, 0.0f, Color.white, true));
        CategoryPlot categoryplot = (CategoryPlot)jfreechart.getPlot();
        categoryplot.setNoDataMessage("NO DATA!");
        categoryplot.setBackgroundPaint(null);
        categoryplot.setInsets(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        categoryplot.setOutlinePaint((Paint)Color.black);
        categoryplot.setRangeGridlinePaint((Paint)Color.gray);
        categoryplot.setRangeGridlineStroke((Stroke)new BasicStroke(1.0f));
        Paint[] apaint = BarChartDemo9.createPaint();
        CustomBarRenderer custombarrenderer = new CustomBarRenderer(apaint);
        custombarrenderer.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_HORIZONTAL));
        categoryplot.setRenderer((CategoryItemRenderer)custombarrenderer);
        NumberAxis numberaxis = (NumberAxis)categoryplot.getRangeAxis();
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberaxis.setRange(0.0, 800.0);
        numberaxis.setTickMarkPaint((Paint)Color.black);
        return jfreechart;
    }

    private static Paint[] createPaint() {
        Paint[] apaint = new Paint[]{new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 0.0f, Color.red), new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 0.0f, Color.green), new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 0.0f, Color.blue), new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 0.0f, Color.orange), new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 0.0f, Color.magenta)};
        return apaint;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jfreechart = BarChartDemo9.createChart(BarChartDemo9.createDataset());
        return new ChartPanel(jfreechart);
    }

    public static void main(String[] args) {
        BarChartDemo9 barchartdemo9 = new BarChartDemo9("Bar Chart Demo 9");
        barchartdemo9.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)barchartdemo9));
        barchartdemo9.setVisible(true);
    }

    static class CustomBarRenderer
    extends BarRenderer {
        private static final long serialVersionUID = 1L;
        private Paint[] colors;

        public Paint getItemPaint(int i, int j) {
            return this.colors[j % this.colors.length];
        }

        public CustomBarRenderer(Paint[] apaint) {
            this.colors = apaint;
        }
    }
}

