/*
 * Decompiled with CFR 0.152.
 */
package windows;

import CustomComponent.MyTime;
import MyDocking.TradeCast;
import common.gui.util.AppConfig;
import common.gui.util.ImageUtil;
import common.gui.util.MyColors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class About
extends JDialog {
    private LanguageCentre languageCentre = new LanguageCentre();
    private JLabel lblBGImage;
    private JLabel lblImage;
    private JLabel lblMessage;
    private JLabel lblYear;

    public About(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setBounds(0, 0, 637, 370);
        this.setLocationRelativeTo(null);
        this.setTitle(this.languageCentre.getValue(LanguageConstant.AboutTradeCast));
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                About.this.Dispose();
                TradeCast.getInstance().GetTopWindow();
            }
        });
        this.lblImage.setIcon(null);
        new Thread(new Runnable(){

            @Override
            public void run() {
                About.this.setBGImage();
                About.this.setHouseLogo();
            }
        }).start();
        this.lblImage.setVisible(AppConfig.isShowLogo);
        this.setText();
        this.setYear();
    }

    private void Dispose() {
        this.dispose();
    }

    private void setBGImage() {
        block4: {
            this.lblBGImage.setIcon(null);
            Image img = null;
            try {
                img = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/HouseBGImage.png"));
                if (img == null) {
                    ImageIcon imw = new ImageIcon(this.getClass().getResource("/Images/TC_Login1.jpg"));
                    img = imw.getImage();
                    this.lblBGImage.setIcon(new ImageIcon(img));
                } else {
                    this.lblBGImage.setIcon(new ImageIcon(img));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (img != null) break block4;
                ImageIcon imw = new ImageIcon(this.getClass().getResource("/Images/TC_Login1.jpg"));
                img = imw.getImage();
                this.lblBGImage.setIcon(new ImageIcon(img));
            }
        }
        this.setText();
        this.setYear();
        this.repaint();
    }

    private void setHouseLogo() {
        try {
            BufferedImage image = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/HouseLogo.png"));
            if (image != null) {
                this.lblImage.setIcon(new ImageIcon(image));
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        this.setText();
        this.setYear();
        this.repaint();
    }

    private void initComponents() {
        this.lblImage = new JLabel();
        this.lblMessage = new JLabel();
        this.lblYear = new JLabel();
        this.lblBGImage = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(637, 339));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                About.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(null);
        this.getContentPane().add(this.lblImage);
        this.lblImage.setBounds(444, 18, 160, 130);
        this.lblMessage.setText("<html><div><br /><span style=\"font-family:Calibri;font-size:18px; font-weight:bold; color:#313131; \">Trade Cast - Online Trading Plateform</span><br /><span style=\"font-family:Calibri;font-size:11px; font-weight:bold; color:#303030; \">Part of CATALYST IT Solution's Financial ERP Suite 'Brokerage Prelude'<br />\u00a9 2010 - 2011 CATALYST IT Solutions (Pvt.) Limited. <span style=\"font-style:italic\">All Rights Reserved</span><br /></span><br /><span style=\"font-family:Calibri;font-size:10px; font-weight:bold; color:#656565; \">This computer Program is secured license from CATALYST IT Solutions (Pvt.) Limited. Unauthorized reproduction & distribution of this program, or any portion of it, without CATALYST's involvement is strictly prohibeted. if found anyone guilty, he o she will be implicated under the rule of law.</span>     </div></html>");
        this.lblMessage.setVerticalAlignment(1);
        this.getContentPane().add(this.lblMessage);
        this.lblMessage.setBounds(30, 110, 560, 190);
        this.lblYear.setHorizontalAlignment(4);
        this.lblYear.setText(" ");
        this.getContentPane().add(this.lblYear);
        this.lblYear.setBounds(244, 320, 380, 20);
        this.lblBGImage.setBackground(new Color(255, 255, 255));
        this.lblBGImage.setOpaque(true);
        this.getContentPane().add(this.lblBGImage);
        this.lblBGImage.setBounds(0, 0, 630, 340);
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.Dispose();
        TradeCast.getInstance().GetTopWindow();
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<div>");
        sb.append("<br />");
        if (MyColors.LoginWindowTextColor == null) {
            sb.append("<span style='font-family:Calibri;font-size:18px; font-weight:bold; color:#303030; '>");
        } else {
            sb.append("<span style='font-family:Calibri;font-size:18px; font-weight:bold; color:#").append(AppConfig.GetSixCharacterHexColor((String)System.getProperty("LoginWindowTextColor"))).append("; '>");
        }
        sb.append("Trade Cast v");
        sb.append(AppConfig.version.trim());
        sb.append(" - Online Trading Platform");
        sb.append("<br />");
        sb.append("</span>");
        sb.append("<br />");
        if (MyColors.LoginWindowTextColor == null) {
            sb.append("<span style='font-family:Calibri;font-size:10px; font-weight:bold; color:#656565; '>");
        } else {
            sb.append("<span style='font-family:Calibri;font-size:10px; font-weight:bold; color:#").append(AppConfig.GetSixCharacterHexColor((String)System.getProperty("LoginWindowTextColor"))).append("; '>");
        }
        sb.append("This Software is designed and developed by CATALYST IT Solutions (Pvt.) Limited, and has been provided to ");
        sb.append("<font size=4>");
        sb.append(AppConfig.companyName);
        sb.append("</font>");
        sb.append(" under license for restricted use.");
        sb.append("<br />");
        sb.append("The software is protected by copyright laws. Unauthorised reproduction, distribution, ");
        sb.append("use or possession of this software, or any portion of it, will result in severe civil and criminal penalties.");
        sb.append("</span>");
        sb.append("</div>");
        sb.append("</html>");
        this.lblMessage.setText(sb.toString());
    }

    private void setYear() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<div>");
        String year = MyTime.getInstance().getYear();
        if (MyColors.LoginWindowTextColor == null) {
            sb.append("<span style='font-family: Calibiri Regular; font-size:7px; color:#2d2d2d; '>");
        } else {
            sb.append("<span style='font-family: Calibiri Regular; font-size:7px; color:#").append(AppConfig.GetSixCharacterHexColor((String)System.getProperty("LoginWindowTextColor"))).append("; '>");
        }
        sb.append("Copyright 2010 - ").append(year).append(" CATALYST IT Solutions (Pvt.) Limited.<span style=\"font-style:italic\">All Rights Reserved.</span>");
        sb.append("</span>");
        sb.append("</div>");
        sb.append("</html>");
        this.lblYear.setText(sb.toString());
    }
}

