/*
 * Decompiled with CFR 0.152.
 */
package windows;

import Control.JasperFileChooser;
import CustomComponent.MyOptionPane;
import CustomComponent.MyTime;
import Utilities.CompressManager;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.NxGTable;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kse.gui.bean.ClosePriceExportBean;
import kse.gui.model.ClosePriceExportModel;
import kse.gui.render.ClosePriceExportRender;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class ClosePriceExport
extends JPanel {
    private AutoCompleteSupport autoCompleteMarket;
    private Vector<String> columns = new Vector();
    private Vector<ClosePriceExportBean> rows = new Vector();
    private ClosePriceExportModel model;
    private ClosePriceExportRender render;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnExport;
    private JButton btnLoad;
    private JComboBox cbMarkets;
    private JLabel lblMarket;
    private JLabel lblMessage;
    private JScrollPane scrollPane;
    private NxGTable table;

    public ClosePriceExport() {
        this.initComponents();
        this.initTable();
        this.setMarkets();
    }

    private void initTable() {
        this.columns.add("Market");
        this.columns.add("Scrip");
        this.columns.add("Close Price");
        this.columns.add("Open Price");
        this.columns.add("High");
        this.columns.add("Low");
        this.columns.add("Direction");
        this.columns.add("Change");
        this.columns.add("Total Trade");
        this.columns.add("Total Volume");
        this.columns.add("Value");
        this.model = new ClosePriceExportModel(this.rows, this.columns);
        this.table.setModel((TableModel)this.model);
        this.render = new ClosePriceExportRender();
        for (int k = 0; k < this.model.getColumnCount(); ++k) {
            this.table.getColumn((Object)this.model.getColumnName(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        this.table.setColumnControlVisible(false);
        this.table.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING});
        this.tableDataChange(false);
    }

    private void tableDataChange(final boolean isPackAll) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.addNotify();
            if (isPackAll) {
                this.table.packAll();
            }
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClosePriceExport.this.model.fireTableDataChanged();
                    ClosePriceExport.this.table.addNotify();
                    if (isPackAll) {
                        ClosePriceExport.this.table.packAll();
                    }
                    ClosePriceExport.this.table.repaint();
                }
            });
        }
    }

    private void setMarkets() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ClosePriceExport.this.autoCompleteMarket != null && ClosePriceExport.this.autoCompleteMarket.isInstalled()) {
                    ClosePriceExport.this.autoCompleteMarket.uninstall();
                }
                Vector<String> allMarket = new Vector<String>();
                allMarket.addElement("REG");
                allMarket.addElement("FUT");
                Collections.sort(allMarket);
                ClosePriceExport.this.cbMarkets.setModel(new DefaultComboBoxModel(allMarket));
                ClosePriceExport.this.autoCompleteMarket = AutoCompleteSupport.install((JComboBox)ClosePriceExport.this.cbMarkets, (EventList)GlazedLists.eventListOf((Object[])allMarket.toArray()));
                ClosePriceExport.this.cbMarkets.setSelectedItem("REG");
                ClosePriceExport.this.autoCompleteMarket.setStrict(true);
            }
        });
    }

    private void initComponents() {
        this.btnLoad = new JButton();
        this.lblMarket = new JLabel();
        this.cbMarkets = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.table = new NxGTable();
        this.btnExport = new JButton();
        this.lblMessage = new JLabel();
        this.btnLoad.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnLoad.setText("Load");
        this.btnLoad.setName("ClosePriceExport -> btnLoad");
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClosePriceExport.this.btnLoadActionPerformed(evt);
            }
        });
        this.lblMarket.setText("Market");
        this.table.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Status"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.btnExport.setIcon(new ImageIcon(this.getClass().getResource("/Images/xls.png")));
        this.btnExport.setText("Export");
        this.btnExport.setName("ClosePriceExport -> btnExport");
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClosePriceExport.this.btnExportActionPerformed(evt);
            }
        });
        this.lblMessage.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblMarket, -2, 40, -2).addGap(10, 10, 10).addComponent(this.cbMarkets, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLoad, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExport, -2, 100, -2).addGap(0, 93, Short.MAX_VALUE)).addComponent(this.scrollPane)).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMarket, -2, 23, -2).addComponent(this.cbMarkets, -2, 23, -2).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnLoad).addComponent(this.btnExport)))).addGap(5, 5, 5).addComponent(this.scrollPane, -1, 415, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMessage, -2, 22, -2).addGap(5, 5, 5)));
    }

    private void btnLoadActionPerformed(ActionEvent evt) {
        if (this.getMarket().equalsIgnoreCase("")) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select market");
            this.cbMarkets.requestFocus();
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ClosePriceExport.this.rows.clear();
                    ClosePriceExport.this.tableDataChange(false);
                    Util.setMessage((JLabel)ClosePriceExport.this.lblMessage, (MessageType)MessageType.Loading, (String)ClosePriceExport.this.languageCentre.getValue(LanguageConstant.Loading));
                    String data = ClosePriceExport.this.getData();
                    ClosePriceExport.this.parseData(data);
                    ClosePriceExport.this.tableDataChange(true);
                    Util.setMessage((JLabel)ClosePriceExport.this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(ClosePriceExport.this.rows.size() + "")) + " rocords found"));
                }
            }).start();
        }
    }

    private void btnExportActionPerformed(ActionEvent evt) {
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Close Price Export - " + MyTime.getInstance().getDate()));
        fc.addCSVFileFilter();
        fc.showSaveDialog(this);
        String FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion();
        if (fc.getSelectedFile() != null) {
            try {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.rows.size(); ++i) {
                    ClosePriceExportBean b = this.rows.elementAt(i);
                    sb.append(b).append(Util.LineSeparator);
                }
                this.CustomExport(FileName, sb.toString());
                MyOptionPane.showMessage(MessageType.Sussess, "Close price export successfully", false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                MyOptionPane.showMessage(MessageType.Error, "Error in exporting close price", false);
            }
        }
    }

    private String getMarket() {
        if (this.cbMarkets.getSelectedItem() == null) {
            return "";
        }
        String a = this.cbMarkets.getSelectedItem().toString();
        return a;
    }

    private void CustomExport(String ReportName, String data) throws Exception {
        OutputStreamWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(new File(ReportName));
            fileWriter.write(data);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private String getData() {
        try {
            byte[] result = WebService.getInstance().getPort().getCompressedData("Date", "ClosePriceByMarket=", this.getMarket());
            String data = CompressManager.unzipStringFromBytes(result);
            return data;
        }
        catch (Exception ex) {
            Logger.getLogger(ClosePriceExport.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    private void parseData(String data) {
        if (data == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"No record found");
        } else if (data.trim().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"No record found");
        } else if (data.indexOf("|") > 0) {
            String[] allRows = data.split("\\|", -1);
            for (int i = 0; i < allRows.length - 1; ++i) {
                String singleRow = allRows[i];
                ClosePriceExportBean b = ClosePriceExportBean.parse((String)singleRow);
                this.rows.add(b);
            }
        }
    }
}

