/*
 * Decompiled with CFR 0.152.
 */
package windows;

import Utilities.LogsTC;
import common.bean.ExchangeStateBean;
import common.gui.util.LogCommon;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import windows.ExchangeStats;
import windows.pmex.buyingpower.PMEX_BuyingPower_Dock;

public class CustomCombo
extends JPanel {
    private ArrayList<String> Market;
    final int Left = 0;
    final int Right = 1;
    private int Max = 3;
    ExchangeStats ES;
    private final PMEX_BuyingPower_Dock netPosition;
    private JButton btnLeft;
    private JButton btnRight;
    private JPanel jPanel1;
    private JLabel lblTitle;
    private JTextField txtMarket;

    public CustomCombo(ExchangeStats ES, PMEX_BuyingPower_Dock netPosition, boolean isNetPosition) {
        this.initComponents();
        this.Market = new ArrayList();
        if (isNetPosition) {
            this.Market.addAll(LogsTC.accountAll.keySet());
            if (this.Market.size() > 0) {
                this.txtMarket.setText(this.Market.get(0));
            } else {
                this.txtMarket.setText("No Account");
                this.btnLeft.setEnabled(false);
                this.btnRight.setEnabled(false);
            }
            this.Max = this.Market.size() - 1;
            this.lblTitle.setText(" Account");
            if (netPosition != null) {
                netPosition.accountChanged(this.txtMarket.getText());
            }
        } else {
            this.Market.add("KSE 100");
            this.Market.add("KSE 30");
            this.Market.add("KMI 30");
            this.Market.add("KMIALLSHR");
            this.Market.add("BKTi");
            this.Market.add("OGTi");
            this.Market.add("ALLSHR");
            this.Max = this.Market.size() - 1;
            this.lblTitle.setText(" KSE Indices");
        }
        this.ES = ES;
        this.netPosition = netPosition;
    }

    public String getMarket() {
        String Mkt = this.txtMarket.getText();
        Mkt = Mkt.replace(" ", "");
        return Mkt;
    }

    private void ChangeMarket(int Dir) {
        int MarketIndex = this.Market.indexOf(this.txtMarket.getText());
        if (Dir == 0) {
            if (MarketIndex > 0) {
                this.txtMarket.setText(this.Market.get(--MarketIndex).toString());
            } else {
                MarketIndex = this.Max;
                this.txtMarket.setText(this.Market.get(MarketIndex).toString());
            }
        }
        if (Dir == 1) {
            if (MarketIndex < this.Max) {
                this.txtMarket.setText(this.Market.get(++MarketIndex).toString());
            } else {
                MarketIndex = 0;
                this.txtMarket.setText(this.Market.get(MarketIndex).toString());
            }
        }
        String Mkt = this.txtMarket.getText();
        Mkt = Mkt.replace(" ", "").toUpperCase();
        if (this.ES != null) {
            this.ES.update((ExchangeStateBean)LogCommon.ExStatsFeedMap.get(Mkt));
        }
        if (this.netPosition != null) {
            this.netPosition.accountChanged(this.txtMarket.getText());
        }
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.jPanel1 = new JPanel();
        this.btnRight = new JButton();
        this.txtMarket = new JTextField();
        this.btnLeft = new JButton();
        this.lblTitle.setFont(new Font("Tahoma", 1, 11));
        this.lblTitle.setHorizontalAlignment(0);
        this.lblTitle.setText(" KSE Indices");
        this.btnRight.setText(">");
        this.btnRight.setBorder(null);
        this.btnRight.setMaximumSize(new Dimension(7, 15));
        this.btnRight.setMinimumSize(new Dimension(7, 15));
        this.btnRight.setName("CustomCombo -> btnRight");
        this.btnRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomCombo.this.btnRightActionPerformed(evt);
            }
        });
        this.txtMarket.setEditable(false);
        this.txtMarket.setHorizontalAlignment(0);
        this.txtMarket.setText("KSE 100");
        this.txtMarket.setAlignmentX(2.0f);
        this.txtMarket.setBorder(null);
        this.btnLeft.setText("<");
        this.btnLeft.setBorder(null);
        this.btnLeft.setMaximumSize(new Dimension(7, 15));
        this.btnLeft.setMinimumSize(new Dimension(7, 15));
        this.btnLeft.setName("CustomCombo -> btnLeft");
        this.btnLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomCombo.this.btnLeftActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnLeft, -2, 16, -2).addGap(1, 1, 1).addComponent(this.txtMarket, -1, 58, Short.MAX_VALUE).addGap(1, 1, 1).addComponent(this.btnRight, -2, 16, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnLeft, -2, 20, -2).addComponent(this.txtMarket, -2, 20, -2).addComponent(this.btnRight, -2, 20, -2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblTitle, -2, 70, -2).addGap(0, 0, 0).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(9, 9, 9)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTitle, -2, 20, -2).addComponent(this.jPanel1, -2, -1, -2));
    }

    private void btnRightActionPerformed(ActionEvent evt) {
        this.ChangeMarket(1);
    }

    private void btnLeftActionPerformed(ActionEvent evt) {
        this.ChangeMarket(0);
    }
}

