/*
 * Decompiled with CFR 0.152.
 */
package windows;

import CATALYST.Control.MarketFeed;
import MessageWindow.ReadWrite;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import RendersNModels.DQDataModel;
import RendersNModels.DQEnum;
import RendersNModels.DetailQuoteMarketRender;
import RendersNModels.DetailQuoteRenderer;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.text.Document;
import languages.LanguageCentre;
import languages.LanguageConstant;
import windows.CustomPanel;
import windows.DQSetting;

public class DetailedQuote
extends CustomPanel {
    public static Hashtable<String, String> DQFeed = new Hashtable();
    public static Hashtable<String, String> symbolDetailQuote = new Hashtable();
    String mbpFeed;
    DefaultTableModel model = new DefaultTableModel(new Object[][]{{null, null, null, -999999, -999999, -999999, -999999}}, new String[]{"Mkt", "Scrip", "Description", "BVol", "Buy", "Sell", "SVol"}){

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0 || column == 1;
        }
    };
    Mediator mediator = Mediator.getInstance();
    public String Market = "";
    public String Symbol = "";
    private String LastMBPMsg = "";
    JComboBox cbMarket = new JComboBox<String>(LogCommon.markets);
    JTextField txtSymbol = new JTextField();
    public static double bidQty = -999999.0;
    public static double bid = -999999.0;
    public static double offer = -999999.0;
    public static double offerQty = -999999.0;
    public static Color ColorbidQty = Color.LIGHT_GRAY;
    public static Color Colorbid = Color.LIGHT_GRAY;
    public static Color Coloroffer = Color.LIGHT_GRAY;
    public static Color ColorofferQty = Color.LIGHT_GRAY;
    public boolean FirstTime = true;
    private LanguageCentre languageCentre = new LanguageCentre();
    private DQDataModel m_data = null;
    Timer Timer_BuyVol = null;
    Timer Timer_Buy = null;
    Timer Timer_SellVol = null;
    Timer Timer_Sell = null;
    int delay = 5000;
    int Selectedrow = -1;
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private final String tit = "Settings";
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblGraphsAndCharts;
    private JLabel lblScripBrowse;
    private JLabel lblScripDetails;
    private JLabel lblScripName;
    private JLabel lblSetting;
    private JTable table;
    private JTable tblDetails;

    public DetailedQuote() {
        this.m_data = new DQDataModel(this);
        this.initComponents();
        this.Timer_Buy = new Timer(0, null);
        this.Timer_BuyVol = new Timer(0, null);
        this.Timer_SellVol = new Timer(0, null);
        this.Timer_Sell = new Timer(0, null);
        this.SetTimer(this.Timer_Buy, 0);
        this.SetTimer(this.Timer_BuyVol, 1);
        this.SetTimer(this.Timer_SellVol, 2);
        this.SetTimer(this.Timer_Sell, 3);
        this.mediator.setDetailedQuote(this);
        this.lblScripBrowse.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
        this.lblScripBrowse.setPreferredSize(new Dimension(100, 16));
        this.lblScripBrowse.setMinimumSize(new Dimension(100, 16));
        this.lblScripBrowse.setMaximumSize(new Dimension(100, 16));
        this.lblSetting.setPreferredSize(new Dimension(65, 16));
        this.lblSetting.setMinimumSize(new Dimension(65, 16));
        this.lblSetting.setMaximumSize(new Dimension(65, 16));
        this.lblSetting.setText("<html><b>Settings</b></html>");
        this.lblSetting.setCursor(Cursor.getPredefinedCursor(12));
        this.lblGraphsAndCharts.setPreferredSize(new Dimension(130, 16));
        this.lblGraphsAndCharts.setMinimumSize(new Dimension(130, 16));
        this.lblGraphsAndCharts.setMaximumSize(new Dimension(130, 16));
        this.lblGraphsAndCharts.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.GraphsAndCharts) + "</b></html>");
        this.lblGraphsAndCharts.setCursor(Cursor.getPredefinedCursor(12));
        if (AppConfig.GraphURL.length() <= 0) {
            this.lblGraphsAndCharts.setVisible(false);
        }
        this.lblScripDetails.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/scripDetail.png")));
        this.lblScripDetails.setPreferredSize(new Dimension(90, 16));
        this.lblScripDetails.setMinimumSize(new Dimension(90, 16));
        this.lblScripDetails.setMaximumSize(new Dimension(90, 16));
        this.lblScripDetails.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripDetail) + "</b></html>");
        this.lblScripDetails.setCursor(Cursor.getPredefinedCursor(12));
        this.lblScripDetails.setVisible(AppConfig.isHistoricalDataWatch);
        this.setRender();
        this.setTable();
        this.tblDetails.setSelectionMode(0);
        this.tblDetails.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getFirstIndex() > -1) {
                    DetailedQuote.this.Selectedrow = e.getFirstIndex();
                }
            }
        });
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        this.tableDataChange();
    }

    public void SelectRow() {
        if (this.Selectedrow > -1) {
            this.tblDetails.addRowSelectionInterval(0, this.Selectedrow);
        }
    }

    private void SetTimer(Timer timer, final int i) {
        ActionListener Task2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (i == 0) {
                    Colorbid = MyColors.MktBG;
                } else if (i == 1) {
                    ColorbidQty = MyColors.MktBG;
                } else if (i == 2) {
                    ColorofferQty = MyColors.MktBG;
                } else if (i == 3) {
                    Coloroffer = MyColors.MktBG;
                }
                DetailedQuote.this.model.fireTableDataChanged();
            }
        };
        timer.setRepeats(false);
        timer.setInitialDelay(this.delay);
        timer.setDelay(this.delay);
        timer.addActionListener(Task2);
        timer.start();
    }

    public void setRenderPrefrences() {
        bidQty = -999999.0;
        bid = -999999.0;
        offer = -999999.0;
        offerQty = -999999.0;
        this.mediator.SendMsgToFeedServer("DQ-FEED|", "Detail Quote Closing");
    }

    private void emptyTableMkt() {
        this.table.setValueAt("", 0, 1);
        this.table.setValueAt("", 0, 2);
        this.table.setValueAt("", 0, 3);
        this.table.setValueAt("", 0, 4);
        this.table.setValueAt("", 0, 5);
        this.table.setValueAt("", 0, 6);
        this.FirstTime = true;
    }

    private void setTable() {
        this.table.setModel(this.model);
        this.table.setRowHeight(16);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(38);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(152);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(70);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point p = e.getPoint();
                int row = DetailedQuote.this.table.rowAtPoint(p);
                int column = DetailedQuote.this.table.columnAtPoint(p);
                String vol = DetailedQuote.this.table.getColumnModel().getColumn(column).getIdentifier().toString();
                if (vol.equalsIgnoreCase("Scrip")) {
                    DetailedQuote.this.table.setToolTipText("Double click here to change scrip");
                }
            }
        });
        this.tblDetails.setTableHeader(null);
        this.tblDetails.setRowHeight(17);
        this.tblDetails.getColumnModel().getColumn(0).setPreferredWidth(130);
        this.tblDetails.getColumnModel().getColumn(1).setPreferredWidth(105);
        this.tblDetails.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.tblDetails.getColumnModel().getColumn(3).setPreferredWidth(85);
        this.cbMarket.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DetailedQuote.this.AddSymbol(false, DetailedQuote.this.table.getValueAt(0, 0).toString(), DetailedQuote.this.table.getValueAt(0, 1).toString());
            }
        });
        DefaultCellEditor editor = new DefaultCellEditor(this.cbMarket);
        this.table.getColumn("Mkt").setCellEditor(editor);
        this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
        this.txtSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailedQuote.this.Symbol = DetailedQuote.this.txtSymbol.getText().trim();
                DetailedQuote.this.Market = DetailedQuote.this.table.getValueAt(0, 0).toString();
                DetailedQuote.this.AddSymbol(DetailedQuote.this.Market, DetailedQuote.this.Symbol);
            }
        });
        this.txtSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DetailedQuote.this.txtSymbol.selectAll();
            }
        });
        this.txtSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (DetailedQuote.this.txtSymbol.getText().length() <= 0) {
                    DetailedQuote.this.lblScripName.setText(" ");
                }
            }
        });
        DefaultCellEditor editor2 = new DefaultCellEditor(this.txtSymbol);
        this.table.getColumn("Scrip").setCellEditor(editor2);
        this.table.setDefaultRenderer(Object.class, new DetailQuoteMarketRender());
    }

    public synchronized void UpdateMkt() {
        if (this.Symbol == null) {
            this.setTitle("Invalid");
            this.emptyTable();
            return;
        }
        if (this.Symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(this.Symbol.trim())) {
            this.setTitle("Invalid");
            this.emptyTable();
            return;
        }
        String mkt = this.table.getValueAt(0, 0).toString();
        MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(this.Symbol, mkt);
        if (mktFeed != null) {
            try {
                bidQty = Double.parseDouble(this.table.getValueAt(0, 3).toString().replaceAll("\\,", ""));
            }
            catch (NumberFormatException ex) {
                bidQty = 0.0;
            }
            try {
                bid = Double.parseDouble(this.table.getValueAt(0, 4).toString().replaceAll("\\,", ""));
            }
            catch (NumberFormatException ex) {
                bid = 0.0;
            }
            try {
                offer = Double.parseDouble(this.table.getValueAt(0, 5).toString().replaceAll("\\,", ""));
            }
            catch (NumberFormatException ex) {
                offer = 0.0;
            }
            try {
                offerQty = Double.parseDouble(this.table.getValueAt(0, 6).toString().replaceAll("\\,", ""));
            }
            catch (NumberFormatException ex) {
                offerQty = 0.0;
            }
            if (mktFeed.svol.trim().equalsIgnoreCase("")) {
                mktFeed.svol = "0.0";
            }
            if (Double.parseDouble(mktFeed.buy.replaceAll("\\,", "")) > bid) {
                if (!this.FirstTime) {
                    Colorbid = MyColors.MarketWatchIncreaseColor;
                }
                this.Timer_Buy.restart();
            } else if (Double.parseDouble(mktFeed.bvol.replaceAll("\\,", "")) < bid) {
                Colorbid = MyColors.MarketWatchDecreaseColor;
                this.Timer_Buy.restart();
            }
            if (Double.parseDouble(mktFeed.bvol.replaceAll("\\,", "")) > bidQty) {
                if (!this.FirstTime) {
                    ColorbidQty = MyColors.MarketWatchIncreaseColor;
                }
                this.Timer_BuyVol.restart();
            } else if (Double.parseDouble(mktFeed.bvol.replaceAll("\\,", "")) < bidQty) {
                ColorbidQty = MyColors.MarketWatchDecreaseColor;
                this.Timer_BuyVol.restart();
            }
            if (Double.parseDouble(mktFeed.svol.replaceAll("\\,", "")) > offerQty) {
                if (!this.FirstTime) {
                    ColorofferQty = MyColors.MarketWatchIncreaseColor;
                }
                this.Timer_SellVol.restart();
            } else if (Double.parseDouble(mktFeed.svol.replaceAll("\\,", "")) < offerQty) {
                ColorofferQty = MyColors.MarketWatchDecreaseColor;
                this.Timer_SellVol.restart();
            }
            if (Double.parseDouble(mktFeed.sell.replaceAll("\\,", "")) > offer) {
                if (!this.FirstTime) {
                    Coloroffer = MyColors.MarketWatchIncreaseColor;
                }
                this.Timer_Sell.restart();
            } else if (Double.parseDouble(mktFeed.sell.replaceAll("\\,", "")) < offer) {
                Coloroffer = MyColors.MarketWatchDecreaseColor;
                this.Timer_Sell.restart();
            }
            this.FirstTime = false;
            String symbol = this.Symbol;
            if (symbol.indexOf("-") >= 0) {
                symbol = symbol.split("\\-", -1)[0];
            }
            this.table.setValueAt(this.mediator.getSymbolTitle(symbol), 0, 2);
            this.table.setValueAt(mktFeed.bvol, 0, 3);
            this.table.setValueAt(mktFeed.buy, 0, 4);
            this.table.setValueAt(mktFeed.sell, 0, 5);
            this.table.setValueAt(mktFeed.svol, 0, 6);
        } else {
            this.mediator.sendFeedSymbols(this.Symbol + ":" + this.table.getValueAt(0, 0).toString(), "Detail Quote : UpdateMKT");
            this.emptyTable();
        }
    }

    public void UpdateSymbolDetailQuote(String result) {
        if (result.indexOf(";") > 0) {
            symbolDetailQuote.put(this.Symbol, result);
            this.Update("Detail Quote : UpdateSymbolDetailQuote");
        } else if (result.equalsIgnoreCase("Exception")) {
            this.lblScripName.setForeground(Color.BLACK);
            this.lblScripName.setText("Error in loading Symbol Detailed Quote");
            this.lblScripName.setIcon(null);
        }
    }

    public synchronized void Update(String action) {
        if (this.Symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(this.Symbol.trim())) {
            this.lblScripName.setText("Invalid Scrip");
            this.setTitle("Invalid");
            this.emptyTable();
            return;
        }
        String mkt = this.table.getValueAt(0, 0).toString();
        MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(this.Symbol, mkt);
        if (mktFeed != null) {
            if (this.lblScripName.getIcon() != null) {
                this.lblScripName.setIcon(null);
                this.lblScripName.setText("Change scrip by double clicking the scrip cell");
            }
            this.m_data.setDataValues(mktFeed);
            if (symbolDetailQuote.containsKey(this.Symbol)) {
                String result = symbolDetailQuote.get(this.Symbol);
                this.m_data.setDataValues(this.Symbol, result, mktFeed);
            } else {
                LoadLogs loadLogs = new LoadLogs("SymbolDetailQuote=", true);
                new ThreadWithName(loadLogs, "SymbolDetailQuote").start();
            }
            String cps = this.mediator.logsCommon.getCaps(this.Symbol, mkt);
            this.m_data.setDataValues(cps, mktFeed);
        } else {
            this.mediator.sendFeedSymbols(this.Symbol + ":" + this.table.getValueAt(0, 0).toString(), action);
            this.emptyTable();
            this.lblScripName.setText("  ");
            this.lblScripName.setIcon(null);
        }
    }

    public void updateBidOffer(String result) {
        boolean iSymbol = false;
        boolean iMarket = true;
        int iLastPrice = 2;
        int iBuy = 3;
        int iSell = 4;
        int totBuyVolume = 0;
        int totBuy = 0;
        int totSellVolume = 0;
        int totSell = 0;
        String smb = "";
        String buy = "";
        String sell = "";
        this.mbpFeed = result;
        if (this.mbpFeed != null && this.mbpFeed.indexOf("|") >= 0) {
            String[] feeds = this.mbpFeed.split("\\|", -1);
            for (int iteration = 0; iteration < feeds.length; ++iteration) {
                if (feeds[iteration].trim().length() <= 0 || feeds[iteration].indexOf(";") < 0) continue;
                String[] feed = feeds[iteration].split("\\;", -1);
                smb = feed[0];
                buy = feed[3];
                sell = feed[4];
                String[] BuyValues = buy.split("\\$", -1);
                String[] SellValues = sell.split("\\$", -1);
                for (int j = 0; j < BuyValues.length - 1; ++j) {
                    String[] BuyVal = BuyValues[j].split("\\,", -1);
                    totBuy += Integer.parseInt(BuyVal[0].trim());
                    totBuyVolume += Integer.parseInt(BuyVal[1].trim());
                }
                for (int k = 0; k < SellValues.length - 1; ++k) {
                    String[] SellVal = SellValues[k].split("\\,", -1);
                    totSell += Integer.parseInt(SellVal[0].trim());
                    totSellVolume += Integer.parseInt(SellVal[1].trim());
                }
            }
        } else {
            return;
        }
        DQFeed.put(smb, result);
        this.m_data.setDataValues(totBuyVolume + "", totSellVolume + "", totBuy + "", totSell + "");
    }

    public void updateMinMax() {
        this.Update("Detail Quote : updateMinMax");
    }

    public void AddSymbol(String Market, String Symbol) {
        this.AddSymbol(true, Market, Symbol);
    }

    private void AddSymbol(boolean AddMarket, String Market, String Symbol) {
        this.emptyTable();
        this.emptyTableMkt();
        this.Market = Market;
        this.Symbol = Symbol;
        if (Symbol == null) {
            this.lblScripName.setText("Please enter Symbol");
            return;
        }
        if (Symbol.equalsIgnoreCase("")) {
            this.mediator.SendMsgToFeedServer("DQ-FEED|", "Detail Quote : AddSymbol");
            this.lblScripName.setText("Please enter Symbol");
            return;
        }
        this.Symbol = Symbol;
        if (AddMarket) {
            this.SendDQMessage(Symbol, Market);
            this.table.setValueAt(Market, 0, 0);
        } else {
            String mkt = this.table.getValueAt(0, 0).toString();
            this.SendDQMessage(Symbol, mkt);
        }
        this.table.setValueAt(Symbol, 0, 1);
        if (Symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(Symbol.trim())) {
            this.lblScripName.setText("Invalid Scrip");
            this.setTitle("Invalid");
            return;
        }
        this.mediator.SetSymbolAndNameTitle("Detailed Quote", Symbol);
        this.lblScripName.setText("Loading....");
        this.lblScripName.setIcon(this.loaderIcon);
        if (symbolDetailQuote.containsKey(Symbol)) {
            this.UpdateSymbolDetailQuote(symbolDetailQuote.get(Symbol));
        } else {
            LoadLogs loadLogs = new LoadLogs("SymbolDetailQuote=", true);
            new Thread(loadLogs).start();
        }
        this.UpdateMkt();
        this.Update("Detail Quote : AddSymbol");
        if (DQFeed.containsKey(Symbol)) {
            this.updateBidOffer(DQFeed.get(Symbol));
        }
    }

    public void setTitle(String inv) {
        if (inv.equalsIgnoreCase("Invalid")) {
            this.mediator.SetSymbolAndNameTitle(LanguageConstant.DetailedQuote, "");
            this.lblScripName.setText("Invalid Scrip");
            return;
        }
        if (this.Symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(this.Symbol.trim())) {
            this.mediator.SetSymbolAndNameTitle("Detailed Quote", "");
            this.lblScripName.setText("Invalid Scrip");
        } else {
            this.mediator.SetSymbolAndNameTitle("Detailed Quote", this.Symbol);
        }
    }

    public void emptyTable() {
        ((DQDataModel)this.tblDetails.getModel()).Clear();
        for (int i = 2; i < this.table.getColumnCount(); ++i) {
            this.table.setValueAt("", 0, i);
            Colorbid = MyColors.MktBG;
            ColorbidQty = MyColors.MktBG;
            ColorofferQty = MyColors.MktBG;
            Coloroffer = MyColors.MktBG;
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblDetails = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.table = new JTable();
        this.lblScripName = new JLabel();
        this.lblScripBrowse = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.lblSetting = new JLabel();
        this.lblGraphsAndCharts = new JLabel();
        this.jLabel1 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.lblScripDetails = new JLabel();
        this.jScrollPane1.setName("jScrollPane1");
        this.tblDetails.setModel(this.m_data);
        this.tblDetails.setName("tblDetails");
        this.tblDetails.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DetailedQuote.this.tblDetailsMousePressed(evt);
            }
        });
        this.tblDetails.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                DetailedQuote.this.tblDetailsMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tblDetails);
        this.jScrollPane2.setName("jScrollPane2");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, "0", "0", "0", "0"}}, new String[]{"Market", "Scrip", "Description", "BVol", "Buy", "Sell", "SVol"}));
        this.table.setName("table");
        this.table.setSelectionForeground(new Color(0, 0, 0));
        this.jScrollPane2.setViewportView(this.table);
        this.lblScripName.setText("  ");
        this.lblScripName.setVerticalAlignment(1);
        this.lblScripName.setName("lblScripName");
        this.lblScripBrowse.setFont(new Font("Tahoma", 1, 11));
        this.lblScripBrowse.setIcon(new ImageIcon(this.getClass().getResource("/Images/symDetail2.png")));
        this.lblScripBrowse.setText("Scrip Browse");
        this.lblScripBrowse.setName("lblScripBrowse");
        this.lblScripBrowse.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DetailedQuote.this.lblScripBrowseMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DetailedQuote.this.lblScripBrowseMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DetailedQuote.this.lblScripBrowseMousePressed(evt);
            }
        });
        this.jSeparator1.setName("jSeparator1");
        this.lblSetting.setFont(new Font("Tahoma", 1, 11));
        this.lblSetting.setHorizontalAlignment(2);
        this.lblSetting.setIcon(new ImageIcon(this.getClass().getResource("/Images/option.png")));
        this.lblSetting.setText("Settings");
        this.lblSetting.setName("lblSetting");
        this.lblSetting.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DetailedQuote.this.lblSettingMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DetailedQuote.this.lblSettingMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DetailedQuote.this.lblSettingMousePressed(evt);
            }
        });
        this.lblGraphsAndCharts.setFont(new Font("Tahoma", 1, 11));
        this.lblGraphsAndCharts.setHorizontalAlignment(4);
        this.lblGraphsAndCharts.setIcon(new ImageIcon(this.getClass().getResource("/Images/graph.png")));
        this.lblGraphsAndCharts.setText("Charts And Graphs");
        this.lblGraphsAndCharts.setName("lblGraphsAndCharts");
        this.lblGraphsAndCharts.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DetailedQuote.this.lblGraphsAndChartsMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DetailedQuote.this.lblGraphsAndChartsMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DetailedQuote.this.lblGraphsAndChartsMousePressed(evt);
            }
        });
        this.jLabel1.setText("  ");
        this.jLabel1.setName("jLabel1");
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setName("jSeparator2");
        this.lblScripDetails.setFont(new Font("Tahoma", 1, 11));
        this.lblScripDetails.setHorizontalAlignment(4);
        this.lblScripDetails.setIcon(new ImageIcon(this.getClass().getResource("/Images/graph.png")));
        this.lblScripDetails.setText("Scrip Details");
        this.lblScripDetails.setName("lblScripDetails");
        this.lblScripDetails.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DetailedQuote.this.lblScripDetailsMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DetailedQuote.this.lblScripDetailsMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DetailedQuote.this.lblScripDetailsMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblScripBrowse).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblSetting, -2, 71, -2).addGap(10, 10, 10).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblScripDetails).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblGraphsAndCharts)).addComponent(this.lblScripName, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -2, 44, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jLabel1)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGraphsAndCharts).addComponent(this.lblScripBrowse).addComponent(this.lblSetting, -2, 16, -2).addComponent(this.lblScripDetails))).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 16, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 102, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addComponent(this.lblScripName)));
    }

    private void tblDetailsMouseMoved(MouseEvent evt) {
    }

    private void tblDetailsMousePressed(MouseEvent evt) {
    }

    private void lblScripBrowseMouseEntered(MouseEvent evt) {
        this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(12));
        this.lblScripBrowse.setText("<html><u><b>" + this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></u></html>");
    }

    private void lblScripBrowseMouseExited(MouseEvent evt) {
        this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(0));
        this.lblScripBrowse.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
    }

    private void lblScripBrowseMousePressed(MouseEvent evt) {
        this.mediator.tradecast.ShowDynamicForm(FormName.ScripBrowse, LanguageConstant.ScripBrowse);
    }

    private void lblSettingMouseEntered(MouseEvent evt) {
        this.lblSetting.setText("<html><u><b>Settings</b></u></html>");
    }

    private void lblSettingMouseExited(MouseEvent evt) {
        this.lblSetting.setText("<html><b>Settings</b></html>");
    }

    private void lblSettingMousePressed(MouseEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DQSetting(DetailedQuote.this.mediator.detailedQuote);
            }
        });
    }

    private void lblGraphsAndChartsMouseEntered(MouseEvent evt) {
        this.lblGraphsAndCharts.setText("<html><u><b>" + this.languageCentre.getValue(LanguageConstant.GraphsAndCharts) + "</b></u></html>");
    }

    private void lblGraphsAndChartsMouseExited(MouseEvent evt) {
        this.lblGraphsAndCharts.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.GraphsAndCharts) + "</b></html>");
    }

    private void lblGraphsAndChartsMousePressed(MouseEvent evt) {
        TradeCast.getInstance().ShowGraphWindow(FormName.GraphsAndCharts, this.languageCentre.getValue(LanguageConstant.GraphsAndCharts), this.Market, this.Symbol);
    }

    private void lblScripDetailsMouseEntered(MouseEvent evt) {
        this.lblScripDetails.setText("<html><u><b>" + this.languageCentre.getValue(LanguageConstant.ScripDetail) + "</b></u></html>");
    }

    private void lblScripDetailsMouseExited(MouseEvent evt) {
        this.lblScripDetails.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripDetail) + "</b></html>");
    }

    private void lblScripDetailsMousePressed(MouseEvent evt) {
        this.mediator.openScripDetails(this.Symbol);
    }

    private void setRender() {
        this.tblDetails.setDefaultRenderer(Object.class, new DetailQuoteRenderer());
    }

    public void SendDQMessage(String Symbol, String Market) {
        if (!this.LastMBPMsg.equalsIgnoreCase(Symbol + ":" + Market)) {
            if (Symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(Symbol.trim())) {
                this.lblScripName.setText("Invalid Scrip");
            }
            this.LastMBPMsg = Symbol + ":" + Market;
            this.mediator.SendMsgToFeedServer("DQ-FEED|" + this.LastMBPMsg, "Detail Quote : SendDQMessage");
        }
    }

    public void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DetailedQuote.this.table.addNotify();
                    DetailedQuote.this.table.repaint();
                }
            });
        }
    }

    static {
        Hashtable<Dimension, DQEnum> view2 = new ReadWrite().ReadDQ();
        if (view2 != null) {
            DQSetting.view = view2;
            DQSetting.rowCount = (int)Math.ceil(new Double(DQSetting.view.size()) / new Double(4.0));
        } else {
            DQSetting.view.clear();
            int i = 0;
            int ceil = (int)Math.ceil(new Double(DQEnum.values().length) / new Double(2.0));
            for (DQEnum key : DQEnum.values()) {
                if (++i <= ceil) {
                    DQSetting.view.put(new Dimension(i - 1, 0), key);
                    DQSetting.view.put(new Dimension(i - 1, 1), key);
                    continue;
                }
                DQSetting.view.put(new Dimension(i - 1 - ceil, 2), key);
                DQSetting.view.put(new Dimension(i - 1 - ceil, 3), key);
            }
            new ReadWrite().writeDQ(DQSetting.view);
            DQSetting.rowCount = (int)Math.ceil(new Double(DQSetting.view.size()) / new Double(4.0));
        }
    }
}

