/*
 * Decompiled with CFR 0.152.
 */
package windows;

import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.CompressManager;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kse.gui.bean.EXBenefitsBean;
import kse.gui.model.ExBenefitsModel;
import kse.gui.render.ExBenefitsRender;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class ExBenefitsWindow
extends JPanel {
    private AutoCompleteSupport autoCom;
    private Vector<String> column = new Vector();
    private Vector<EXBenefitsBean> rows = new Vector();
    private ExBenefitsModel model = null;
    private ExBenefitsRender render = null;
    private AutoCompleteSupport autoCompleteScrip;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnGet;
    public JComboBox cbScrip;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblAccount;
    private JLabel lblMsg;
    private JXTable table;
    public JXDatePicker txtFromDate;
    public JXDatePicker txtToDate;

    public ExBenefitsWindow() {
        this.initComponents();
        this.txtFromDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtToDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtFromDate.setDate(new Date(System.currentTimeMillis()));
        this.txtToDate.setDate(new Date(System.currentTimeMillis()));
        this.initTable();
        this.setAllScrip();
    }

    private void initTable() {
        this.column.add("Scrip");
        this.column.add("Name");
        this.column.add("Date");
        this.column.add("1st Day of Book Closure");
        this.column.add("Face Value");
        this.column.add("Devidend(%)");
        this.column.add("Bonus Share(%)");
        this.column.add("Right Share(%)");
        this.column.add("Premium");
        this.model = new ExBenefitsModel(this.rows, this.column);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        this.table.setModel((TableModel)this.model);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(true);
        this.tableDataChange();
        this.setRender();
    }

    private void setRender() {
        this.render = new ExBenefitsRender((JTable)this.table);
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)this.render);
    }

    public void setAllScrip() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ExBenefitsWindow.this.autoCompleteScrip != null && ExBenefitsWindow.this.autoCompleteScrip.isInstalled()) {
                        ExBenefitsWindow.this.autoCompleteScrip.uninstall();
                    }
                    Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
                    allScrip.addElement("ALL");
                    Collections.sort(allScrip);
                    ExBenefitsWindow.this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
                    ExBenefitsWindow.this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)ExBenefitsWindow.this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
                    ExBenefitsWindow.this.cbScrip.setSelectedItem("ALL");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void initComponents() {
        this.lblAccount = new JLabel();
        this.cbScrip = new JComboBox();
        this.btnGet = new JButton();
        this.jLabel3 = new JLabel();
        this.txtFromDate = new JXDatePicker();
        this.jLabel4 = new JLabel();
        this.txtToDate = new JXDatePicker();
        this.lblMsg = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JXTable();
        this.lblAccount.setHorizontalAlignment(2);
        this.lblAccount.setText("Scrip");
        this.cbScrip.setEditable(true);
        this.cbScrip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExBenefitsWindow.this.cbScripActionPerformed(evt);
            }
        });
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setMaximumSize(new Dimension(49, 22));
        this.btnGet.setMinimumSize(new Dimension(49, 22));
        this.btnGet.setName("ExBenefitsWindow -> btnGet");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExBenefitsWindow.this.btnGetActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("From Date");
        this.txtFromDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExBenefitsWindow.this.txtFromDateActionPerformed(evt);
            }
        });
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("To Date");
        this.txtToDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExBenefitsWindow.this.txtToDateActionPerformed(evt);
            }
        });
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblMsg, -2, 525, -2).addGap(0, 104, Short.MAX_VALUE)).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.lblAccount, -2, 40, -2).addGap(0, 0, 0).addComponent(this.cbScrip, -2, 100, -2).addGap(0, 0, 0).addComponent(this.jLabel3, -2, 70, -2).addGap(0, 0, 0).addComponent((Component)this.txtFromDate, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel4, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtToDate, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGet, -2, 84, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAccount, -2, 22, -2).addComponent(this.cbScrip, -2, 22, -2).addComponent(this.jLabel3, -2, 22, -2).addComponent((Component)this.txtFromDate, -2, -1, -2).addComponent(this.jLabel4, -2, 22, -2).addComponent((Component)this.txtToDate, -2, -1, -2).addComponent(this.btnGet, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 287, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addComponent(this.lblMsg, -2, 16, -2)));
    }

    private void cbScripActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            this.txtFromDate.requestFocus();
        }
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.getData();
    }

    private void txtFromDateActionPerformed(ActionEvent evt) {
        this.txtToDate.requestFocus();
    }

    private void txtToDateActionPerformed(ActionEvent evt) {
        this.getData();
    }

    private void getData() {
        if (this.checkValidate()) {
            new Thread("Ex Benefits Window"){

                @Override
                public void run() {
                    try {
                        ExBenefitsWindow.this.clearAllValues();
                        Util.setMessage((JLabel)ExBenefitsWindow.this.lblMsg, (MessageType)MessageType.Loading, (String)ExBenefitsWindow.this.languageCentre.getValue(LanguageConstant.Loading));
                        String fromdate = LogsTC.dateFormatAcc.format(ExBenefitsWindow.this.txtFromDate.getDate());
                        String todate = LogsTC.dateFormatAcc.format(ExBenefitsWindow.this.txtToDate.getDate());
                        byte[] data = WebService.getInstance().getPort().getOrderHistory(LogCommon.UserID, ExBenefitsWindow.this.cbScrip.getSelectedItem().toString().trim(), fromdate, todate, "", "", "", "ExBenefits");
                        String result = CompressManager.unzipStringFromBytes((byte[])data);
                        ExBenefitsWindow.this.setData(result);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Util.setMessage((JLabel)ExBenefitsWindow.this.lblMsg, (MessageType)MessageType.Error, (String)"Error in loading data");
                    }
                }
            }.start();
        }
    }

    private synchronized void setData(String result) {
        this.rows.clear();
        Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.EMPTY, (String)"");
        if (result != null) {
            if (result.indexOf("|") > 0) {
                String[] allRows = result.split("\\|", -1);
                for (int i = 0; i < allRows.length - 1; ++i) {
                    String row = allRows[i];
                    EXBenefitsBean b = EXBenefitsBean.parse((String)row);
                    this.rows.add(b);
                }
            }
            this.tableDataChange();
            if (this.rows.size() <= 0) {
                Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"No record found");
            }
        } else {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"No record found");
        }
    }

    private void clearAllValues() {
        this.rows.clear();
        this.tableDataChange();
    }

    private boolean checkValidate() {
        if (this.cbScrip.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select scrip");
            this.cbScrip.requestFocus();
            return true;
        }
        if (this.cbScrip.getSelectedItem().toString().trim().length() <= 0) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select scrip");
            this.cbScrip.requestFocus();
            return true;
        }
        if (this.txtFromDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select From date.");
            this.txtFromDate.requestFocus();
            return false;
        }
        if (this.txtToDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select To date.");
            this.txtFromDate.requestFocus();
            return false;
        }
        if (this.txtToDate.getDate().compareTo(this.txtFromDate.getDate()) < 0) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Error, (String)"From date should be greater then or equal to To date.");
            this.txtFromDate.requestFocus();
            return false;
        }
        return true;
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
            this.table.packAll();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExBenefitsWindow.this.model.fireTableDataChanged();
                    ExBenefitsWindow.this.table.addNotify();
                    ExBenefitsWindow.this.table.repaint();
                    ExBenefitsWindow.this.table.packAll();
                }
            });
        }
    }
}

