/*
 * Decompiled with CFR 0.152.
 */
package windows;

import Beans.ExchangeHistory;
import CustomComponent.CustomComboEditor;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LogsTC;
import common.bean.ExchangeStateBean;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.sql.Date;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.EventListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import languages.LanguageConstant;
import windows.CustomCombo;

public class ExchangeStats
extends JPanel
implements ActionListener,
EventListener {
    Mediator mediator = Mediator.getInstance();
    static ExchangeStats THIS = null;
    JTable table = null;
    JScrollPane scrollPane = null;
    JPanel topPanel = null;
    ExStatsTableModel tabModel = null;
    double per = 0.0;
    double per100 = 0.0;
    double per30 = 0.0;
    double perAll = 0.0;
    double HighPer = 0.0;
    double LowPer = 0.0;
    private JPopupMenu popup = null;
    boolean AllView = true;
    private JMenuItem menuMarket = new JMenuItem("All Market View");
    private JMenuItem menuDetail = new JMenuItem("Detail View");
    private CustomCombo customcmb = null;
    private int ScreenWidth;
    private int cVol = 0;
    public long mktVol = 0L;
    private Color green = new Color(0, 153, 0);

    public ExchangeStats() {
        this.mediator.setExSats(this);
        THIS = this;
        this.ScreenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.setPreferredSize(new Dimension(this.ScreenWidth, 23));
        this.setMaximumSize(new Dimension(this.ScreenWidth, 23));
    }

    public String getMarket() {
        return this.customcmb.getMarket().toUpperCase() + "";
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void init(String ExStatsAllView) {
        this.AllView = ExStatsAllView.equalsIgnoreCase("TRUE");
        this.tabModel = new ExStatsTableModel(this.AllView);
        this.table = new JTable(this.tabModel);
        this.table.setPreferredSize(new Dimension(this.ScreenWidth, 23));
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowHeight(21);
        this.table.setTableHeader(null);
        this.table.setAutoResizeMode(3);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(142);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(148);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(166);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(165);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(28);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(28);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(28);
        this.table.getColumnModel().getColumn(7).setPreferredWidth(51);
        this.setUpMarketColumn(this.table, this.table.getColumnModel().getColumn(0));
        this.setUpIndexColumn(this.table, this.table.getColumnModel().getColumn(1));
        this.setUpHighColumn(this.table, this.table.getColumnModel().getColumn(2));
        this.setUpLowColumn(this.table, this.table.getColumnModel().getColumn(3));
        this.setUpOtherColumn(this.table, this.table.getColumnModel().getColumn(4), "Adv");
        this.setUpOtherColumn(this.table, this.table.getColumnModel().getColumn(5), "Dec");
        this.setUpOtherColumn(this.table, this.table.getColumnModel().getColumn(6), "UnC");
        this.setUpOtherColumn(this.table, this.table.getColumnModel().getColumn(7), "Vol");
        this.setUpOtherColumn(this.table, this.table.getColumnModel().getColumn(8), "Mkt.Vol");
        this.SettingTable();
        this.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 300, Short.MAX_VALUE));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                int row = ExchangeStats.this.table.rowAtPoint(p);
                int column = ExchangeStats.this.table.columnAtPoint(p);
                String vol = ExchangeStats.this.table.getColumnModel().getColumn(column).getIdentifier().toString();
                if (vol.equalsIgnoreCase("Mkt.Vol")) {
                    TradeCast.getInstance().ShowDynamicForm(FormName.IndicesSummery, LanguageConstant.IndicesSummary);
                } else if (vol.equalsIgnoreCase("Market")) {
                    TradeCast.getInstance().ShowGraphWindow(FormName.IndexGraph, LanguageConstant.IndexGraph, "", "");
                }
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point p = e.getPoint();
                int row = ExchangeStats.this.table.rowAtPoint(p);
                int column = ExchangeStats.this.table.columnAtPoint(p);
                String vol = ExchangeStats.this.table.getColumnModel().getColumn(column).getIdentifier().toString();
                ExchangeStats.this.table.setCursor(Cursor.getPredefinedCursor(0));
                if (vol.equalsIgnoreCase("Market")) {
                    ExchangeStats.this.table.setCursor(Cursor.getPredefinedCursor(12));
                } else if (vol.equalsIgnoreCase("Vol")) {
                    ExchangeStats.this.table.setToolTipText("Volume " + Util.format0digit((String)(ExchangeStats.this.cVol + "")));
                } else if (vol.equalsIgnoreCase("Mkt.Vol")) {
                    ExchangeStats.this.table.setToolTipText("All Shares Market Volume " + Util.format0digit((String)(ExchangeStats.this.mktVol + "")));
                    ExchangeStats.this.table.setCursor(Cursor.getPredefinedCursor(12));
                } else if (vol.equalsIgnoreCase("UnC")) {
                    ExchangeStats.this.table.setToolTipText("UnChanged");
                } else if (vol.equalsIgnoreCase("Adv")) {
                    ExchangeStats.this.table.setToolTipText("Advancers");
                } else if (vol.equalsIgnoreCase("Dec")) {
                    ExchangeStats.this.table.setToolTipText("Decliners");
                } else {
                    ExchangeStats.this.table.setToolTipText("");
                }
            }
        });
    }

    public void setPreviousVolumes(String result) {
        if (result.indexOf("|") >= 0) {
            try {
                String[] allMarket = result.split("\\|", -1);
                for (int i = 0; i < allMarket.length; ++i) {
                    if (allMarket[i].indexOf(";") < 0) continue;
                    String[] market = allMarket[i].split(";", -1);
                    ExchangeHistory exh = new ExchangeHistory();
                    exh.index = market[0];
                    exh.indexVal = Double.parseDouble(market[1]);
                    exh.volume = Long.parseLong(market[2]);
                    exh.value = Double.parseDouble(market[3]);
                    exh.high = Double.parseDouble(market[4]);
                    exh.low = Double.parseDouble(market[5]);
                    exh.change = Double.parseDouble(market[6]);
                    exh.highchange = exh.high - (exh.indexVal - exh.change);
                    exh.lowchange = exh.low - (exh.indexVal - exh.change);
                    SimpleDateFormat ts = new SimpleDateFormat("yyyy-MM-dd");
                    exh.date = new Date(ts.parse(market[7]).getTime());
                    LogsTC.ExchangeHistory.put(exh.index.trim().replaceAll(" ", "").toUpperCase(), exh);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void SettingTable() {
        if (this.AllView) {
            for (int k = 1; k < this.tabModel.getColumnCount(); ++k) {
                this.table.getColumn(this.tabModel.getColumnName(k)).setCellRenderer(new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JLabel ret = (JLabel)super.getTableCellRendererComponent(tblDataTable, value, isSelected, hasFocus, row, column);
                        ret.setHorizontalAlignment(4);
                        ret.setFont(LogCommon.IndicesFont);
                        String Val = value.toString();
                        if (Val.trim().equalsIgnoreCase("") || Val == null) {
                            Val = "0";
                        }
                        double d = 0.0;
                        switch (column) {
                            case 1: 
                            case 4: 
                            case 7: {
                                d = Util.round((double)Double.valueOf(Val), (int)2);
                                ret.setForeground(ExchangeStats.this.green);
                                ret.setText(String.valueOf(d));
                                break;
                            }
                            case 2: {
                                d = Util.round((double)Double.valueOf(Val), (int)2);
                                if (d >= 0.0) {
                                    ret.setForeground(ExchangeStats.this.green);
                                } else {
                                    ret.setForeground(Color.red);
                                }
                                ret.setText(String.valueOf(d) + "  (" + ExchangeStats.this.per100 + "%)");
                                break;
                            }
                            case 5: {
                                d = Util.round((double)Double.valueOf(Val), (int)2);
                                if (d >= 0.0) {
                                    ret.setForeground(ExchangeStats.this.green);
                                } else {
                                    ret.setForeground(Color.red);
                                }
                                ret.setText(String.valueOf(d) + "  (" + Util.format2digit((String)(ExchangeStats.this.per30 + "")) + "%)");
                                break;
                            }
                            case 8: {
                                d = Util.round((double)Double.valueOf(Val), (int)2);
                                if (d >= 0.0) {
                                    ret.setForeground(ExchangeStats.this.green);
                                } else {
                                    ret.setForeground(Color.red);
                                }
                                ret.setText(String.valueOf(d) + "  (" + Util.format2digit((String)(ExchangeStats.this.perAll + "")) + "%)");
                                break;
                            }
                            case 9: {
                                ret.setForeground(Color.black);
                                break;
                            }
                        }
                        return ret;
                    }
                });
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JMenuItem) {
            JMenuItem _menuItem = (JMenuItem)source;
            if (_menuItem.getText().equalsIgnoreCase("All Market View")) {
                this.AllView = true;
                this.menuDetail.setEnabled(true);
                this.menuMarket.setEnabled(false);
            } else if (_menuItem.getText().equalsIgnoreCase("Detail View")) {
                this.AllView = false;
                this.menuDetail.setEnabled(false);
                this.menuMarket.setEnabled(true);
            }
            this.tabModel = new ExStatsTableModel(this.AllView);
            this.table.setModel(this.tabModel);
            this.tabModel.redraw();
            if (!this.AllView) {
                this.setUpMarketColumn(this.table, this.table.getColumnModel().getColumn(0));
            }
            this.SettingTable();
            this.updateUI();
        }
    }

    public void update(ExchangeStateBean ExRate) {
        if (ExRate == null) {
            return;
        }
        this.per = ExRate.getIndexChange() / (ExRate.getIndex() - ExRate.getIndexChange()) * 100.0;
        this.per = Util.round((double)this.per, (int)2);
        this.HighPer = ExRate.getHighChange() / (ExRate.getHigh() - ExRate.getHighChange()) * 100.0;
        this.HighPer = Util.round((double)this.HighPer, (int)2);
        this.LowPer = ExRate.getLowChange() / (ExRate.getLow() - ExRate.getLowChange()) * 100.0;
        this.LowPer = Util.round((double)this.LowPer, (int)2);
        this.tabModel.setValueAt(ExRate.getMarket(), 0, 0);
        this.tabModel.setValueAt(ExRate, 0, 1);
        this.tabModel.setValueAt(ExRate, 0, 2);
        this.tabModel.setValueAt(ExRate, 0, 3);
        this.tabModel.setValueAt(ExRate.getAdvancers(), 0, 4);
        this.tabModel.setValueAt(ExRate.getDecliners(), 0, 5);
        this.tabModel.setValueAt(ExRate.getUnchanged(), 0, 6);
        try {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setGroupingUsed(true);
            this.cVol = ExRate.getCVol();
            Integer CVol = ExRate.getCVol();
            String v = Util.inMillion((long)Long.parseLong(CVol + "".replaceAll("\\,", "")));
            this.tabModel.setValueAt(v, 0, 7);
        }
        catch (Exception e) {
            this.tabModel.setValueAt(ExRate.getCVol(), 0, 7);
            e.printStackTrace();
        }
        ExchangeStateBean EX_FOR_MARKETVOLUME = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get("ALLSHR");
        try {
            String v = Util.inMillion((long)Long.parseLong(EX_FOR_MARKETVOLUME.getCVol() + "".replaceAll("\\,", "")));
            this.tabModel.setValueAt(v, 0, 8);
            this.mktVol = EX_FOR_MARKETVOLUME.getCVol();
        }
        catch (NumberFormatException ex) {
            this.tabModel.setValueAt(EX_FOR_MARKETVOLUME.getCVol(), 0, 8);
            ex.printStackTrace();
        }
        this.tabModel.refresh();
    }

    public void setUpMarketColumn(JTable table, TableColumn sportColumn) {
        CustomCombo cmb;
        this.customcmb = cmb = new CustomCombo(this, null, false);
        sportColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                cmb.setFont(LogCommon.IndicesFont);
                return cmb;
            }
        });
        sportColumn.setCellEditor(new CustomComboEditor(cmb));
    }

    public void setUpIndexColumn(JTable table, TableColumn Column) {
        Column.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                ExchangeStateBean EX = null;
                if (value instanceof ExchangeStateBean) {
                    EX = (ExchangeStateBean)value;
                }
                if (EX == null) {
                    EX = ExchangeStateBean.parse((String)"");
                }
                double d = Util.round((double)EX.getIndex(), (int)2);
                JLabel lblIndex = new JLabel();
                lblIndex.setText(Util.format2digit((String)(d + "")));
                lblIndex.setHorizontalAlignment(4);
                lblIndex.setFont(LogCommon.IndicesFont);
                JLabel lblBar = new JLabel(" ( ");
                lblBar.setFont(LogCommon.IndicesFont);
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                panel.add(lblIndex);
                panel.add(lblBar);
                double change = Util.round((double)EX.getIndexChange(), (int)2);
                JLabel lblchange = new JLabel();
                lblchange.setText(Util.format2digit((String)(change + "")) + " ");
                panel.add(lblchange);
                JLabel lblimg = new JLabel();
                if (change == 0.0) {
                    lblimg.setIcon(ExchangeStats.loadImage("level.png"));
                    lblimg.setForeground(Color.BLUE);
                    lblchange.setForeground(Color.BLUE);
                    lblIndex.setForeground(Color.BLUE);
                    lblBar.setForeground(Color.BLUE);
                } else if (change > 0.0) {
                    lblimg.setIcon(ExchangeStats.loadImage("up.png"));
                    lblimg.setForeground(ExchangeStats.this.green);
                    lblchange.setForeground(ExchangeStats.this.green);
                    lblIndex.setForeground(ExchangeStats.this.green);
                    lblBar.setForeground(ExchangeStats.this.green);
                } else {
                    lblimg.setIcon(ExchangeStats.loadImage("down.png"));
                    lblimg.setForeground(Color.red);
                    lblchange.setForeground(Color.red);
                    lblIndex.setForeground(Color.red);
                    lblBar.setForeground(Color.red);
                }
                panel.add(lblimg);
                lblimg.setText(Util.format2digit((String)(ExchangeStats.this.per + "")) + "% )");
                lblchange.setFont(LogCommon.IndicesFont);
                return panel;
            }
        });
    }

    public void setUpHighColumn(JTable table, TableColumn Column) {
        Column.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                ExchangeStateBean EX = null;
                if (value instanceof ExchangeStateBean) {
                    EX = (ExchangeStateBean)value;
                }
                if (EX == null) {
                    EX = ExchangeStateBean.parse((String)"");
                }
                value = EX.getHigh();
                double d = Util.round((double)Double.valueOf(value.toString()), (int)2);
                JLabel lblHedaer = new JLabel("High: ");
                lblHedaer.setFont(LogCommon.IndicesFont);
                JLabel lblHigh = new JLabel();
                lblHigh.setText(Util.format2digit((String)(d + "")));
                lblHigh.setFont(LogCommon.IndicesFont);
                JLabel lblBar = new JLabel(" ( ");
                lblBar.setFont(LogCommon.IndicesFont);
                lblBar.setForeground(ExchangeStats.this.green);
                JLabel lblChange = new JLabel();
                lblChange.setText(Util.format2digit((String)(EX.getHighChange() + "")) + " ");
                lblChange.setForeground(ExchangeStats.this.green);
                JLabel lblper = new JLabel();
                lblper.setIcon(ExchangeStats.loadImage("up.png"));
                lblper.setText(Util.format2digit((String)(ExchangeStats.this.HighPer + "")) + "% )");
                lblper.setFont(LogCommon.IndicesFont);
                lblper.setForeground(ExchangeStats.this.green);
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                panel.add(lblHedaer);
                panel.add(lblHigh);
                panel.add(lblBar);
                panel.add(lblChange);
                panel.add(lblper);
                lblChange.setFont(LogCommon.IndicesFont);
                return panel;
            }
        });
    }

    public void setUpLowColumn(JTable table, TableColumn Column) {
        Column.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                ExchangeStateBean EX = null;
                if (value instanceof ExchangeStateBean) {
                    EX = (ExchangeStateBean)value;
                }
                if (EX == null) {
                    EX = ExchangeStateBean.parse((String)"");
                }
                value = EX.getLow();
                double d = Util.round((double)Double.valueOf(value.toString()), (int)2);
                JLabel lblHedaer = new JLabel("Low: ");
                lblHedaer.setFont(LogCommon.IndicesFont);
                JLabel lblLow = new JLabel();
                lblLow.setText(Util.format2digit((String)(d + "")));
                lblLow.setFont(LogCommon.IndicesFont);
                JLabel lblBar = new JLabel(" ( ");
                lblBar.setFont(LogCommon.IndicesFont);
                lblBar.setForeground(Color.red);
                JLabel lblChange = new JLabel();
                lblChange.setText(Util.format2digit((String)(EX.getLowChange() + "")) + " ");
                lblChange.setForeground(Color.RED);
                JLabel lblper = new JLabel();
                lblper.setIcon(ExchangeStats.loadImage("down.png"));
                lblper.setText(Util.format2digit((String)(ExchangeStats.this.LowPer + "")) + "% )");
                lblper.setFont(LogCommon.IndicesFont);
                lblper.setForeground(Color.RED);
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                panel.add(lblHedaer);
                panel.add(lblLow);
                panel.add(lblBar);
                panel.add(lblChange);
                panel.add(lblper);
                lblChange.setFont(LogCommon.IndicesFont);
                return panel;
            }
        });
    }

    public void setUpOtherColumn(JTable table, TableColumn Column, final String ColName) {
        Column.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = new JLabel();
                lbl.setText(" " + value.toString());
                JLabel lblHedaer = new JLabel(ColName + ":");
                lblHedaer.setFont(LogCommon.IndicesFont);
                lbl.setFont(LogCommon.IndicesFont);
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                panel.add(lblHedaer);
                panel.add(lbl);
                if (ColName.equalsIgnoreCase("Adv")) {
                    lbl.setToolTipText("Advancers");
                    lbl.setForeground(ExchangeStats.this.green);
                } else if (ColName.equalsIgnoreCase("Dec")) {
                    lbl.setToolTipText("Decliners");
                    lbl.setForeground(Color.RED);
                } else if (ColName.equalsIgnoreCase("UnC")) {
                    lbl.setToolTipText("UnChanged");
                    lbl.setForeground(Color.blue);
                } else if (ColName.equalsIgnoreCase("Vol")) {
                    lbl.setToolTipText("Volume");
                    lbl.setForeground(Color.black);
                } else if (ColName.equalsIgnoreCase("Mkt.Vol")) {
                    lbl.setToolTipText("Market Volume");
                    lbl.setForeground(Color.black);
                }
                if (ColName.equalsIgnoreCase("Mkt.Vol")) {
                    lbl.setFont(new Font(lbl.getFont().getFamily(), 1, lbl.getFont().getSize()));
                }
                return panel;
            }
        });
    }

    public void createPopupMenu() {
        this.popup = new JPopupMenu();
        this.menuMarket.addActionListener(this);
        this.popup.add(this.menuMarket);
        this.menuDetail.addActionListener(this);
        this.popup.add(this.menuDetail);
        this.menuDetail.setEnabled(false);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ExchangeStats.this.popup.show(ExchangeStats.this.table, e.getX(), e.getY());
                }
            }
        });
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("FrameDemo");
                frame.setDefaultCloseOperation(3);
                ExchangeStats panel = new ExchangeStats();
                panel.setSize(Toolkit.getDefaultToolkit().getScreenSize());
                frame.getContentPane().add((Component)panel, "Center");
                frame.pack();
                frame.setVisible(true);
                frame.setBounds(0, 0, 1200, 80);
                panel.init("False");
            }
        });
    }

    public void Refressh() {
        this.tableDataChange();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExchangeStats.this.table.addNotify();
                    ExchangeStats.this.table.repaint();
                }
            });
        }
    }

    public static ImageIcon loadImage(String imageNum) {
        String path = "/Images/" + imageNum;
        int MAX_IMAGE_SIZE = 2400;
        int count = 0;
        BufferedInputStream imgStream = new BufferedInputStream(THIS.getClass().getResourceAsStream(path));
        if (imgStream != null) {
            byte[] buf = new byte[MAX_IMAGE_SIZE];
            try {
                count = imgStream.read(buf);
                imgStream.close();
            }
            catch (IOException ioe) {
                Mediator.getInstance().println("Couldn't read stream from file: " + path);
                return null;
            }
            if (count <= 0) {
                Mediator.getInstance().println("Empty file: " + path);
                return null;
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(buf));
        }
        Mediator.getInstance().println("Couldn't find file: " + path);
        return null;
    }

    class ExPopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        ExPopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class ExStatsTableModel
    extends AbstractTableModel {
        public String[] columnNames = new String[]{"Market", "Index", "High", "Low", "Adv", "Dec", "UnC", "Vol", "Mkt.Vol"};
        private Object[][] data = new Object[][]{{"KSE100", null, null, null, "0", "0", "0", "0", "0"}};

        public ExStatsTableModel(Boolean AllView) {
            if (AllView.booleanValue()) {
                this.columnNames = new String[]{"Market", "Index", "Change", "Market ", "Index ", "Change ", "Market  ", "Index  ", "Change  ", "Current Volume"};
                this.data = new Object[][]{{"KSE100", "0.0", "0.0", "KSE30", "0.0", "0.0", "ALLSHR", "0.0", "0.0", "0"}};
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
        }

        public void refresh() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.fireTableDataChanged();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExStatsTableModel.this.fireTableDataChanged();
                    }
                });
            }
        }

        public void redraw() {
            this.fireTableStructureChanged();
        }
    }
}

