/*
 * Decompiled with CFR 0.152.
 */
package windows;

import Beans.ExchangeHistory;
import CustomComponent.NxGPanelGradeint;
import CustomComponent.NxGTableCellRender;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LoadLogs;
import Utilities.LogsTC;
import Utilities.ThreadWithName;
import common.bean.ExchangeStateBean;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import windows.ExchangeStats;

public class ExchangeStatsSummery
extends JPanel {
    Mediator mediator = Mediator.getInstance();
    ExStatsSummeryTableModel CurrentStatsModel;
    ExStatsSummeryTableModel PreviousStatsModel;
    public String SelectedMarket;
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    int ExStatsSelectedRow = -1;
    int PrevExStatsSelectedRow = -1;
    boolean SelectExStats = true;
    private static final int changeWidth = 38;
    private static final int imageWidth = 17;
    private static final int perChangeWidth = 50;
    ExchangeStatsSummeryCellRenderer currentIndexRender = new ExchangeStatsSummeryCellRenderer();
    ExchangeStatsSummeryCellRenderer previousIndexRender = new ExchangeStatsSummeryCellRenderer();
    private LanguageCentre languageCentre = new LanguageCentre();
    final Cursor handCursor = new Cursor(12);
    final Cursor defaultCursor = new Cursor(0);
    private JTable CurrentExStatsTable;
    private JTable PreviousExstatsTable;
    private JComboBox cmbMarket;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JPanel pnlExchange;
    private JPanel pnlPreviouseindices;
    private JPanel pnlcurrentindices;
    private JTextField txtAdvancers;
    private JTextField txtAllMarket;
    private JTextField txtAllNumberOfTrades;
    private JTextField txtAllStatus;
    private JTextField txtAllValue;
    private JTextField txtAllVolume;
    private JTextField txtDecliners;
    private JTextField txtNumberOfTrades;
    private JTextField txtStatus;
    private JTextField txtTotalSymbols;
    private JTextField txtUnchanged;
    private JTextField txtValue;
    private JTextField txtVolume;

    public ExchangeStatsSummery() {
        this.mediator.setExchangeStatsSummery(this);
        this.CurrentStatsModel = new ExStatsSummeryTableModel();
        this.PreviousStatsModel = new ExStatsSummeryTableModel();
        this.initComponents();
        this.updatestatus("  ");
        this.cmbMarket.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
        this.SelectedMarket = this.cmbMarket.getSelectedItem().toString();
        this.LoadExStatsSummeryByAverage();
        JTableHeader header = this.CurrentExStatsTable.getTableHeader();
        ExStatsSummeryTableModel exStatsSummeryTableModel = this.CurrentStatsModel;
        exStatsSummeryTableModel.getClass();
        header.addMouseListener(exStatsSummeryTableModel.new ExStatsSummeryTableModel.ColumnListener(this.CurrentExStatsTable));
        header.setReorderingAllowed(true);
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        JTableHeader header2 = this.PreviousExstatsTable.getTableHeader();
        ExStatsSummeryTableModel exStatsSummeryTableModel2 = this.PreviousStatsModel;
        exStatsSummeryTableModel2.getClass();
        header2.addMouseListener(exStatsSummeryTableModel2.new ExStatsSummeryTableModel.ColumnListener(this.PreviousExstatsTable));
        header2.setReorderingAllowed(true);
        ((JLabel)((Object)header2.getDefaultRenderer())).setHorizontalAlignment(0);
        this.SetCellRenderer();
        this.updateExChangeStats();
        this.updatePreviousExChangeStats();
        this.CurrentExStatsTable.setRowHeight(23);
        this.PreviousExstatsTable.setRowHeight(23);
        this.CurrentExStatsTable.setSelectionMode(0);
        this.PreviousExstatsTable.setSelectionMode(0);
        this.CurrentExStatsTable.getColumnModel().getColumn(0).setMaxWidth(80);
        this.PreviousExstatsTable.getColumnModel().getColumn(0).setMaxWidth(80);
        this.CurrentExStatsTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.PreviousExstatsTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.CurrentExStatsTable.getColumnModel().getColumn(4).setMaxWidth(100);
        this.PreviousExstatsTable.getColumnModel().getColumn(4).setMaxWidth(100);
        this.CurrentExStatsTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        this.PreviousExstatsTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        this.CurrentExStatsTable.getColumnModel().getColumn(5).setMaxWidth(120);
        this.PreviousExstatsTable.getColumnModel().getColumn(5).setMaxWidth(120);
        this.CurrentExStatsTable.getColumnModel().getColumn(5).setPreferredWidth(120);
        this.PreviousExstatsTable.getColumnModel().getColumn(5).setPreferredWidth(120);
        this.CurrentExStatsTable.setSelectionMode(0);
        this.CurrentExStatsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getFirstIndex() > -1) {
                    ExchangeStatsSummery.this.ExStatsSelectedRow = e.getFirstIndex();
                }
            }
        });
        this.PreviousExstatsTable.setSelectionMode(0);
        this.PreviousExstatsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getFirstIndex() > -1) {
                    ExchangeStatsSummery.this.PrevExStatsSelectedRow = e.getFirstIndex();
                }
            }
        });
        this.txtAllMarket.setVisible(false);
        this.txtAllNumberOfTrades.setVisible(false);
        this.txtAllVolume.setVisible(false);
        this.txtAllValue.setVisible(false);
        this.txtAllStatus.setVisible(false);
        this.setLanguageValues();
    }

    public void SelectExStatsRow() {
        if (this.ExStatsSelectedRow > -1) {
            this.CurrentExStatsTable.addRowSelectionInterval(0, this.ExStatsSelectedRow);
        }
    }

    private void initComponents() {
        this.pnlExchange = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.txtTotalSymbols = new JTextField();
        this.txtAdvancers = new JTextField();
        this.txtDecliners = new JTextField();
        this.txtUnchanged = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.txtAllMarket = new JTextField();
        this.cmbMarket = new JComboBox();
        this.jLabel9 = new JLabel();
        this.txtAllNumberOfTrades = new JTextField();
        this.txtAllValue = new JTextField();
        this.txtAllVolume = new JTextField();
        this.txtAllStatus = new JTextField();
        this.txtNumberOfTrades = new JTextField();
        this.txtVolume = new JTextField();
        this.txtValue = new JTextField();
        this.txtStatus = new JTextField();
        this.pnlPreviouseindices = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.PreviousExstatsTable = new JTable(this.PreviousStatsModel);
        this.pnlcurrentindices = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.CurrentExStatsTable = new JTable(this.CurrentStatsModel);
        this.jSeparator1 = new JSeparator();
        this.lblMessage = new JLabel();
        this.pnlExchange.setBorder(BorderFactory.createTitledBorder("Exchange"));
        this.pnlExchange.setName("pnlExchange");
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Advancers");
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Decliners");
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 1));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText(" Un Changed ");
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont(this.jLabel4.getFont().getStyle() | 1));
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Total Symbols");
        this.jLabel4.setName("jLabel4");
        this.txtTotalSymbols.setEditable(false);
        this.txtTotalSymbols.setHorizontalAlignment(4);
        this.txtTotalSymbols.setText("0");
        this.txtTotalSymbols.setBorder(BorderFactory.createBevelBorder(1));
        this.txtTotalSymbols.setName("txtTotalSymbols");
        this.txtAdvancers.setEditable(false);
        this.txtAdvancers.setForeground(new Color(51, 204, 0));
        this.txtAdvancers.setHorizontalAlignment(4);
        this.txtAdvancers.setText("0");
        this.txtAdvancers.setBorder(BorderFactory.createBevelBorder(1));
        this.txtAdvancers.setName("txtAdvancers");
        this.txtDecliners.setEditable(false);
        this.txtDecliners.setForeground(new Color(255, 51, 51));
        this.txtDecliners.setHorizontalAlignment(4);
        this.txtDecliners.setText("0");
        this.txtDecliners.setBorder(BorderFactory.createBevelBorder(1));
        this.txtDecliners.setName("txtDecliners");
        this.txtUnchanged.setEditable(false);
        this.txtUnchanged.setForeground(new Color(51, 51, 255));
        this.txtUnchanged.setHorizontalAlignment(4);
        this.txtUnchanged.setText("0");
        this.txtUnchanged.setBorder(BorderFactory.createBevelBorder(1));
        this.txtUnchanged.setName("txtUnchanged");
        this.jLabel5.setFont(this.jLabel5.getFont().deriveFont(this.jLabel5.getFont().getStyle() | 1));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("Market");
        this.jLabel5.setName("jLabel5");
        this.jLabel6.setFont(this.jLabel6.getFont().deriveFont(this.jLabel6.getFont().getStyle() | 1));
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("Number of Trades");
        this.jLabel6.setName("jLabel6");
        this.jLabel7.setFont(this.jLabel7.getFont().deriveFont(this.jLabel7.getFont().getStyle() | 1));
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("Volume");
        this.jLabel7.setName("jLabel7");
        this.jLabel8.setFont(this.jLabel8.getFont().deriveFont(this.jLabel8.getFont().getStyle() | 1));
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setText("Value");
        this.jLabel8.setName("jLabel8");
        this.txtAllMarket.setEditable(false);
        this.txtAllMarket.setText("ALL");
        this.txtAllMarket.setBorder(BorderFactory.createBevelBorder(1));
        this.txtAllMarket.setName("txtAllMarket");
        this.cmbMarket.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbMarket.setName("cmbMarket");
        this.cmbMarket.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExchangeStatsSummery.this.cmbMarketItemStateChanged(evt);
            }
        });
        this.jLabel9.setFont(this.jLabel9.getFont().deriveFont(this.jLabel9.getFont().getStyle() | 1));
        this.jLabel9.setHorizontalAlignment(0);
        this.jLabel9.setText("Status");
        this.jLabel9.setName("jLabel9");
        this.txtAllNumberOfTrades.setEditable(false);
        this.txtAllNumberOfTrades.setHorizontalAlignment(4);
        this.txtAllNumberOfTrades.setText("0");
        this.txtAllNumberOfTrades.setBorder(BorderFactory.createBevelBorder(1));
        this.txtAllNumberOfTrades.setName("txtAllNumberOfTrades");
        this.txtAllValue.setEditable(false);
        this.txtAllValue.setHorizontalAlignment(4);
        this.txtAllValue.setText("0");
        this.txtAllValue.setBorder(BorderFactory.createBevelBorder(1));
        this.txtAllValue.setName("txtAllValue");
        this.txtAllVolume.setEditable(false);
        this.txtAllVolume.setHorizontalAlignment(4);
        this.txtAllVolume.setText("0");
        this.txtAllVolume.setBorder(BorderFactory.createBevelBorder(1));
        this.txtAllVolume.setName("txtAllVolume");
        this.txtAllStatus.setEditable(false);
        this.txtAllStatus.setBorder(BorderFactory.createBevelBorder(1));
        this.txtAllStatus.setName("txtAllStatus");
        this.txtNumberOfTrades.setEditable(false);
        this.txtNumberOfTrades.setHorizontalAlignment(4);
        this.txtNumberOfTrades.setText("0");
        this.txtNumberOfTrades.setBorder(BorderFactory.createBevelBorder(1));
        this.txtNumberOfTrades.setName("txtNumberOfTrades");
        this.txtVolume.setEditable(false);
        this.txtVolume.setHorizontalAlignment(4);
        this.txtVolume.setText("0");
        this.txtVolume.setBorder(BorderFactory.createBevelBorder(1));
        this.txtVolume.setName("txtVolume");
        this.txtValue.setEditable(false);
        this.txtValue.setHorizontalAlignment(4);
        this.txtValue.setText("0");
        this.txtValue.setBorder(BorderFactory.createBevelBorder(1));
        this.txtValue.setName("txtValue");
        this.txtStatus.setEditable(false);
        this.txtStatus.setHorizontalAlignment(0);
        this.txtStatus.setText("Open");
        this.txtStatus.setBorder(BorderFactory.createBevelBorder(1));
        this.txtStatus.setName("txtStatus");
        GroupLayout pnlExchangeLayout = new GroupLayout(this.pnlExchange);
        this.pnlExchange.setLayout(pnlExchangeLayout);
        pnlExchangeLayout.setHorizontalGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExchangeLayout.createSequentialGroup().addGap(8, 8, 8).addGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.txtAdvancers).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtDecliners).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtUnchanged).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtTotalSymbols).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExchangeLayout.createSequentialGroup().addComponent(this.jLabel5, -1, 85, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6, -1, 105, Short.MAX_VALUE)).addGroup(pnlExchangeLayout.createSequentialGroup().addComponent(this.cmbMarket, 0, 85, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtNumberOfTrades, -1, 109, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExchangeLayout.createSequentialGroup().addComponent(this.txtVolume, -1, 132, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtValue, -1, 124, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtStatus, -1, 98, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, pnlExchangeLayout.createSequentialGroup().addComponent(this.jLabel7, -1, 132, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8, -1, 94, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9, -1, 98, Short.MAX_VALUE))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, pnlExchangeLayout.createSequentialGroup().addContainerGap(344, Short.MAX_VALUE).addComponent(this.txtAllMarket, -1, 138, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtAllNumberOfTrades, -1, 63, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtAllVolume, -2, 132, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtAllValue, -1, 64, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtAllStatus, -1, 98, Short.MAX_VALUE).addGap(20, 20, 20)));
        pnlExchangeLayout.setVerticalGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExchangeLayout.createSequentialGroup().addGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel9).addComponent(this.jLabel6, -2, 14, -2).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbMarket, GroupLayout.Alignment.TRAILING, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtValue, -2, -1, -2).addComponent(this.txtStatus, -2, -1, -2).addComponent(this.txtVolume, -2, -1, -2).addComponent(this.txtNumberOfTrades, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtAllMarket, -2, -1, -2).addComponent(this.txtAllNumberOfTrades, -2, -1, -2).addComponent(this.txtAllVolume, -2, -1, -2).addComponent(this.txtAllValue, -2, -1, -2).addComponent(this.txtAllStatus, -2, -1, -2))).addGroup(pnlExchangeLayout.createSequentialGroup().addGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExchangeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtAdvancers, -2, -1, -2).addComponent(this.txtDecliners, -2, -1, -2).addComponent(this.txtUnchanged, -2, -1, -2).addComponent(this.txtTotalSymbols, -2, -1, -2))));
        this.pnlPreviouseindices.setBorder(BorderFactory.createTitledBorder("Previous Indices"));
        this.pnlPreviouseindices.setName("pnlPreviouseindices");
        this.pnlPreviouseindices.setPreferredSize(new Dimension(845, 150));
        this.jScrollPane1.setName("jScrollPane1");
        this.PreviousExstatsTable.setModel(this.PreviousStatsModel);
        this.PreviousExstatsTable.setName("PreviousExstatsTable");
        this.PreviousExstatsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExchangeStatsSummery.this.PreviousExstatsTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ExchangeStatsSummery.this.PreviousExstatsTableMouseExited(evt);
            }
        });
        this.PreviousExstatsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ExchangeStatsSummery.this.PreviousExstatsTableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.PreviousExstatsTable);
        GroupLayout pnlPreviouseindicesLayout = new GroupLayout(this.pnlPreviouseindices);
        this.pnlPreviouseindices.setLayout(pnlPreviouseindicesLayout);
        pnlPreviouseindicesLayout.setHorizontalGroup(pnlPreviouseindicesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 883, Short.MAX_VALUE));
        pnlPreviouseindicesLayout.setVerticalGroup(pnlPreviouseindicesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 124, Short.MAX_VALUE));
        this.pnlcurrentindices.setBorder(BorderFactory.createTitledBorder("Indices"));
        this.pnlcurrentindices.setName("pnlcurrentindices");
        this.pnlcurrentindices.setPreferredSize(new Dimension(845, 150));
        this.jScrollPane2.setName("jScrollPane2");
        this.CurrentExStatsTable.setModel(this.CurrentStatsModel);
        this.CurrentExStatsTable.setName("CurrentExStatsTable");
        this.CurrentExStatsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExchangeStatsSummery.this.CurrentExStatsTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ExchangeStatsSummery.this.CurrentExStatsTableMouseExited(evt);
            }
        });
        this.CurrentExStatsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ExchangeStatsSummery.this.CurrentExStatsTableMouseMoved(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.CurrentExStatsTable);
        GroupLayout pnlcurrentindicesLayout = new GroupLayout(this.pnlcurrentindices);
        this.pnlcurrentindices.setLayout(pnlcurrentindicesLayout);
        pnlcurrentindicesLayout.setHorizontalGroup(pnlcurrentindicesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 883, Short.MAX_VALUE));
        pnlcurrentindicesLayout.setVerticalGroup(pnlcurrentindicesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 123, Short.MAX_VALUE));
        this.jSeparator1.setName("jSeparator1");
        this.lblMessage.setText(" ");
        this.lblMessage.setName("lblMessage");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlExchange, -1, -1, Short.MAX_VALUE).addComponent(this.pnlPreviouseindices, -1, 895, Short.MAX_VALUE).addComponent(this.pnlcurrentindices, -1, 895, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 895, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblMessage, -2, 599, -2).addContainerGap(286, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlExchange, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlcurrentindices, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlPreviouseindices, -1, 151, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addGap(0, 0, 0).addComponent(this.lblMessage, -2, 19, -2)));
    }

    private void cmbMarketItemStateChanged(ItemEvent evt) {
        this.SelectedMarket = evt.getItem().toString();
        this.LoadExStatsSummeryByAverage();
    }

    private void CurrentExStatsTableMouseClicked(MouseEvent evt) {
        ListSelectionModel model = this.PreviousExstatsTable.getSelectionModel();
        int temp = this.PrevExStatsSelectedRow;
        this.PrevExStatsSelectedRow = -1;
        this.SelectExStats = true;
        model.removeSelectionInterval(0, temp);
        this.PreviousStatsModel.refresh();
        this.updateUI();
        int row = this.PreviousExstatsTable.rowAtPoint(evt.getPoint());
        int col = this.PreviousExstatsTable.columnAtPoint(evt.getPoint());
        if (col == 0) {
            ExchangeStateBean exrate = (ExchangeStateBean)this.PreviousExstatsTable.getValueAt(row, 0);
            TradeCast.getInstance().ShowGraphWindow(FormName.IndexGraph, LanguageConstant.IndexGraph, exrate.getMarket().replace(" ", ""), "");
        }
    }

    private void PreviousExstatsTableMouseClicked(MouseEvent evt) {
        ListSelectionModel model = this.CurrentExStatsTable.getSelectionModel();
        int temp = this.ExStatsSelectedRow;
        this.ExStatsSelectedRow = -1;
        this.SelectExStats = false;
        model.removeSelectionInterval(0, temp);
        this.CurrentStatsModel.refresh();
        this.updateUI();
    }

    private void CurrentExStatsTableMouseMoved(MouseEvent evt) {
        TableColumnModel colModel = this.CurrentExStatsTable.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        int mColIndex = this.CurrentExStatsTable.convertColumnIndexToModel(vColIndex);
        if (this.languageCentre.getValue(LanguageConstant.Indices).equalsIgnoreCase(this.CurrentExStatsTable.getColumnName(mColIndex).toString())) {
            this.CurrentExStatsTable.setCursor(this.handCursor);
        } else {
            this.CurrentExStatsTable.setCursor(this.defaultCursor);
        }
        int row = this.CurrentExStatsTable.rowAtPoint(evt.getPoint());
        if (row != this.currentIndexRender.getRowNo()) {
            this.currentIndexRender.setRowNo(row);
            this.repaint();
        }
    }

    private void CurrentExStatsTableMouseExited(MouseEvent evt) {
        this.currentIndexRender.setRowNo(-1);
    }

    private void PreviousExstatsTableMouseExited(MouseEvent evt) {
        this.previousIndexRender.setRowNo(-1);
    }

    private void PreviousExstatsTableMouseMoved(MouseEvent evt) {
        int row = this.PreviousExstatsTable.rowAtPoint(evt.getPoint());
        if (row != this.previousIndexRender.getRowNo()) {
            this.previousIndexRender.setRowNo(row);
            this.repaint();
        }
    }

    public void updateExChangeStats() {
        ExchangeStateBean ExRate = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get("KSE100");
        this.CurrentStatsModel.AddNewIndex(ExRate);
        ExRate = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get("KSE30");
        this.CurrentStatsModel.AddNewIndex(ExRate);
        ExRate = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get("KMI30");
        this.CurrentStatsModel.AddNewIndex(ExRate);
        ExRate = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get("ALLSHR");
        this.CurrentStatsModel.AddNewIndex(ExRate);
        ExRate = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get("KMIALLSHR");
        this.CurrentStatsModel.AddNewIndex(ExRate);
        ExRate = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get("OGTI");
        this.CurrentStatsModel.AddNewIndex(ExRate);
        ExRate = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get("BKTI");
        this.CurrentStatsModel.AddNewIndex(ExRate);
        if (ExRate != null) {
            this.txtAdvancers.setText(String.valueOf(ExRate.getAdvancers()));
            this.txtDecliners.setText(String.valueOf(ExRate.getDecliners()));
            this.txtUnchanged.setText(String.valueOf(ExRate.getUnchanged()));
            this.txtTotalSymbols.setText(String.valueOf(ExRate.getAdvancers() + ExRate.getDecliners() + ExRate.getUnchanged()));
            this.txtAllVolume.setText(UtilKSE.getFormattedValue((double)ExRate.getCVol(), (String)"###,###"));
            this.txtAllValue.setText(UtilKSE.getFormattedValue((double)ExRate.getVal(), (String)"###,###.##"));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.CurrentStatsModel.refresh();
            this.updateUI();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExchangeStatsSummery.this.CurrentStatsModel.refresh();
                    ExchangeStatsSummery.this.updateUI();
                }
            });
        }
        if (this.SelectExStats) {
            this.SelectExStatsRow();
        }
        this.LoadExStatsSummeryByAverage();
    }

    private void updatePreviousExChangeStats() {
        if (LogsTC.ExchangeHistory.containsKey("KSE100")) {
            this.PreviousStatsModel.AddNewIndex(this.getExchangeRate(LogsTC.ExchangeHistory.get("KSE100")));
        }
        if (LogsTC.ExchangeHistory.containsKey("KSE30")) {
            this.PreviousStatsModel.AddNewIndex(this.getExchangeRate(LogsTC.ExchangeHistory.get("KSE30")));
        }
        if (LogsTC.ExchangeHistory.containsKey("KMI30")) {
            this.PreviousStatsModel.AddNewIndex(this.getExchangeRate(LogsTC.ExchangeHistory.get("KMI30")));
        }
        if (LogsTC.ExchangeHistory.containsKey("ALLSHR")) {
            this.PreviousStatsModel.AddNewIndex(this.getExchangeRate(LogsTC.ExchangeHistory.get("ALLSHR")));
        }
        if (LogsTC.ExchangeHistory.containsKey("KMIALLSHR")) {
            this.PreviousStatsModel.AddNewIndex(this.getExchangeRate(LogsTC.ExchangeHistory.get("KMIALLSHR")));
        }
        if (LogsTC.ExchangeHistory.containsKey("OGTI")) {
            this.PreviousStatsModel.AddNewIndex(this.getExchangeRate(LogsTC.ExchangeHistory.get("OGTI")));
        }
        if (LogsTC.ExchangeHistory.containsKey("BKTI")) {
            this.PreviousStatsModel.AddNewIndex(this.getExchangeRate(LogsTC.ExchangeHistory.get("BKTI")));
        }
        this.PreviousStatsModel.refresh();
        this.updateUI();
    }

    private ExchangeStateBean getExchangeRate(ExchangeHistory ex) {
        ExchangeStateBean ExRate = ExchangeStateBean.parse((String)"");
        ExRate.setMarket(ex.index.toUpperCase());
        ExRate.setIndex(ex.indexVal);
        ExRate.setIndexChange(ex.change);
        ExRate.setHigh(ex.high);
        ExRate.setHighChange(ex.highchange);
        ExRate.setLow(ex.low);
        ExRate.setLowChange(ex.lowchange);
        ExRate.setCVol((int)ex.volume);
        ExRate.setVal(ex.value);
        return ExRate;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private void SetCellRenderer() {
        int i;
        this.currentIndexRender.setSelectColorStart(new Color(227, 207, 117));
        this.currentIndexRender.setSelectColorEnd(new Color(239, 228, 176));
        this.previousIndexRender.setSelectColorStart(new Color(227, 207, 117));
        this.previousIndexRender.setSelectColorEnd(new Color(239, 228, 176));
        this.currentIndexRender.setRoleOverColorEnd(new Color(153, 217, 234));
        this.currentIndexRender.setRoleOverColorStart(new Color(81, 191, 219));
        this.previousIndexRender.setRoleOverColorEnd(new Color(153, 217, 234));
        this.previousIndexRender.setRoleOverColorStart(new Color(81, 191, 219));
        for (i = 0; i < this.CurrentExStatsTable.getColumnModel().getColumnCount(); ++i) {
            this.CurrentExStatsTable.getColumnModel().getColumn(i).setCellRenderer(this.currentIndexRender);
        }
        for (i = 0; i < this.PreviousExstatsTable.getColumnModel().getColumnCount(); ++i) {
            this.PreviousExstatsTable.getColumnModel().getColumn(i).setCellRenderer(this.previousIndexRender);
        }
    }

    private void LoadExStatsSummeryByAverage() {
        this.updatestatus(this.languageCentre.getValue(LanguageConstant.Loading));
        this.lblMessage.setIcon(this.loaderIcon);
        this.setMarketComboEnable(false);
        LoadLogs UPPERCAPPEDSYMBOLS = new LoadLogs("ExStatsSummeryByAverage=", true);
        new ThreadWithName(UPPERCAPPEDSYMBOLS, "ExStatsSummeryByAverage").start();
    }

    public void SetExStatsSummeryByAverage(String result) {
        try {
            this.updatestatus(" ");
            this.lblMessage.setIcon(null);
            String[] Rows = result.split("\\|", -1);
            if (Rows.length > 1) {
                String[] Values2 = Rows[0].split("\\;", -1);
                if (Values2.length > 4) {
                    this.txtAllMarket.setText(Values2[0]);
                    this.txtAllNumberOfTrades.setText(UtilKSE.getFormattedValue((String)Values2[2], (String)"###,###"));
                }
                if ((Values2 = Rows[1].split("\\;", -1)).length > 4) {
                    this.cmbMarket.setSelectedItem(Values2[0].toString());
                    this.txtNumberOfTrades.setText(UtilKSE.getFormattedValue((String)Values2[2], (String)"###,###"));
                    this.txtVolume.setText(UtilKSE.getFormattedValue((String)Values2[3], (String)"###,###"));
                    this.txtValue.setText(UtilKSE.getFormattedValue((String)Values2[4], (String)"###,###.##"));
                    if (Values2[1].trim().equalsIgnoreCase("Halted")) {
                        this.txtStatus.setText(this.languageCentre.getValue(LanguageConstant.Close));
                    } else {
                        this.txtStatus.setText(" " + Values2[1]);
                    }
                }
            }
        }
        catch (Exception e) {
            this.mediator.PrintLog(e, "");
            this.updatestatus(this.languageCentre.getValue(LanguageConstant.ErrorInUpdatingExchangeStatistics));
        }
    }

    public void updatestatus(String string) {
        this.lblMessage.setText(string);
        this.lblMessage.setIcon(null);
    }

    public void setMarketComboEnable(boolean isEnable) {
        this.cmbMarket.setEnabled(isEnable);
        if (isEnable) {
            this.cmbMarket.requestFocus();
        }
    }

    private void setLanguageValues() {
        this.pnlExchange.setBorder(BorderFactory.createTitledBorder(this.languageCentre.getValue(LanguageConstant.Exchange)));
        this.jLabel1.setText(this.languageCentre.getValue(LanguageConstant.Advancers));
        this.jLabel2.setText(this.languageCentre.getValue(LanguageConstant.Decliners));
        this.jLabel3.setText(this.languageCentre.getValue(LanguageConstant.UnChanged));
        this.jLabel4.setText(this.languageCentre.getValue(LanguageConstant.TotalSymbols));
        this.jLabel5.setText(this.languageCentre.getValue(LanguageConstant.Market));
        this.jLabel6.setText(this.languageCentre.getValue(LanguageConstant.NumberOfTrades));
        this.jLabel7.setText(this.languageCentre.getValue(LanguageConstant.Volume));
        this.jLabel8.setText(this.languageCentre.getValue(LanguageConstant.Value));
        this.txtAllMarket.setText(this.languageCentre.getValue(LanguageConstant.ALL));
        this.jLabel9.setText(this.languageCentre.getValue(LanguageConstant.Status));
        this.txtStatus.setText(this.languageCentre.getValue(LanguageConstant.Open));
        this.pnlcurrentindices.setBorder(BorderFactory.createTitledBorder(this.languageCentre.getValue(LanguageConstant.Indices)));
        this.pnlPreviouseindices.setBorder(BorderFactory.createTitledBorder(this.languageCentre.getValue(LanguageConstant.PreviousIndices)));
    }

    class ExStatsSummeryTableModel
    extends AbstractTableModel {
        protected int sortCol = 0;
        protected boolean isSortAsc = true;
        protected int m_result = 0;
        protected int columnsCount = 1;
        public String[] columnNames = new String[]{ExchangeStatsSummery.access$700(ExchangeStatsSummery.this).getValue(LanguageConstant.Indices), ExchangeStatsSummery.access$700(ExchangeStatsSummery.this).getValue(LanguageConstant.Index), ExchangeStatsSummery.access$700(ExchangeStatsSummery.this).getValue(LanguageConstant.High), ExchangeStatsSummery.access$700(ExchangeStatsSummery.this).getValue(LanguageConstant.Low), ExchangeStatsSummery.access$700(ExchangeStatsSummery.this).getValue(LanguageConstant.Volume), ExchangeStatsSummery.access$700(ExchangeStatsSummery.this).getValue(LanguageConstant.Value)};
        public Vector m_vector = new Vector();
        public Hashtable<String, ExchangeStateBean> ht = new Hashtable();

        ExStatsSummeryTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.m_vector == null ? 0 : this.m_vector.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int nRow, int nCol) {
            if (nRow < 0 || nRow >= this.getRowCount()) {
                return "";
            }
            ExchangeStateBean row = (ExchangeStateBean)this.m_vector.elementAt(nRow);
            return row;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        public void refresh() {
            this.fireTableDataChanged();
        }

        public void redraw() {
            this.fireTableStructureChanged();
        }

        public void AddNewIndex(ExchangeStateBean ExRates) {
            boolean Added = false;
            if (ExRates == null) {
                return;
            }
            for (int i = 0; i < this.m_vector.size(); ++i) {
                ExchangeStateBean OldExRates = (ExchangeStateBean)this.m_vector.get(i);
                if (!OldExRates.getMarket().replaceAll(" ", "").equalsIgnoreCase(ExRates.getMarket()) || ExRates.getMarket().trim().length() <= 0) continue;
                if (ExRates.getMarket().equalsIgnoreCase("KSE100")) {
                    ExRates.setMarket("KSE 100");
                }
                if (ExRates.getMarket().equalsIgnoreCase("KSE30")) {
                    ExRates.setMarket("KSE 30");
                }
                if (ExRates.getMarket().equalsIgnoreCase("KMI30")) {
                    ExRates.setMarket("KMI 30");
                }
                if (ExRates.getMarket().equalsIgnoreCase("KMIALLSHR")) {
                    ExRates.setMarket("KMI ALL SHR");
                }
                this.m_vector.setElementAt(ExRates, i);
                Added = true;
                break;
            }
            if (!Added && ExRates.getMarket().trim().length() > 0) {
                if (ExRates.getMarket().equalsIgnoreCase("KSE100")) {
                    ExRates.setMarket("KSE 100");
                }
                if (ExRates.getMarket().equalsIgnoreCase("KSE30")) {
                    ExRates.setMarket("KSE 30");
                }
                if (ExRates.getMarket().equalsIgnoreCase("KMI30")) {
                    ExRates.setMarket("KMI 30");
                }
                if (ExRates.getMarket().equalsIgnoreCase("KMIALLSHR")) {
                    ExRates.setMarket("KMI ALL SHR");
                }
                this.m_vector.addElement(ExRates);
            }
        }

        public void DefualtSort() {
            Collections.sort(this.m_vector, new ExchangeStatsComparator(0, true));
            this.refresh();
        }

        class ColumnListener
        extends MouseAdapter {
            protected JTable table;

            public ColumnListener(JTable t) {
                this.table = t;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int columnModelIndex;
                TableColumnModel colModel = this.table.getColumnModel();
                int modelIndex = colModel.getColumn(columnModelIndex = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
                if (modelIndex < 0) {
                    return;
                }
                if (ExStatsSummeryTableModel.this.sortCol == modelIndex) {
                    ExStatsSummeryTableModel.this.isSortAsc = !ExStatsSummeryTableModel.this.isSortAsc;
                } else {
                    ExStatsSummeryTableModel.this.sortCol = modelIndex;
                }
                for (int i = 0; i < ExStatsSummeryTableModel.this.columnsCount; ++i) {
                    TableColumn column = colModel.getColumn(i);
                    column.setHeaderValue(ExStatsSummeryTableModel.this.getColumnName(column.getModelIndex()));
                }
                this.table.getTableHeader().repaint();
                Collections.sort(ExStatsSummeryTableModel.this.m_vector, new ExchangeStatsComparator(ExStatsSummeryTableModel.this.sortCol, ExStatsSummeryTableModel.this.isSortAsc));
                this.table.tableChanged(new TableModelEvent(ExStatsSummeryTableModel.this));
                this.table.repaint();
            }
        }
    }

    private class ExchangeStatsComparator
    implements Comparator {
        protected int m_sortCol;
        protected boolean m_sortAsc;

        public ExchangeStatsComparator(int sortCol, boolean sortAsc) {
            this.m_sortCol = sortCol;
            this.m_sortAsc = sortAsc;
        }

        public int compare(Object o1, Object o2) {
            ExchangeStateBean s1 = null;
            ExchangeStateBean s2 = null;
            if (o1 instanceof ExchangeStateBean && o2 instanceof ExchangeStateBean) {
                s1 = (ExchangeStateBean)o1;
                s2 = (ExchangeStateBean)o2;
            }
            int result = 0;
            switch (this.m_sortCol) {
                case 0: {
                    result = s1.getMarket().toString().compareTo(s2.getMarket().toString());
                    break;
                }
                case 1: {
                    double d1 = s1.getIndex();
                    double d2 = s2.getIndex();
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 2: {
                    double d1 = s1.getHigh();
                    double d2 = s2.getHigh();
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 3: {
                    double d1 = s1.getLow();
                    double d2 = s2.getLow();
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 4: {
                    double d1 = Double.parseDouble(String.valueOf(s1.getCVol()));
                    double d2 = Double.parseDouble(String.valueOf(s2.getCVol()));
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 5: {
                    double d1 = s1.getVal();
                    double d2 = s2.getVal();
                    int n = d1 < d2 ? -1 : (result = d1 > d2 ? 1 : 0);
                }
            }
            if (!this.m_sortAsc) {
                result = -result;
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ExchangeStatsComparator) {
                ExchangeStatsComparator compObj = (ExchangeStatsComparator)obj;
                return compObj.m_sortCol == this.m_sortCol && compObj.m_sortAsc == this.m_sortAsc;
            }
            return false;
        }
    }

    public class ExchangeStatsSummeryCellRenderer
    extends NxGTableCellRender {
        @Override
        public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (tblDataTable != null && (header = tblDataTable.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            String ColName = tblDataTable.getColumnName(column);
            NxGPanelGradeint panel = new NxGPanelGradeint();
            panel.setLayout(new BoxLayout(panel, 0));
            if (row % 2 == 0) {
                panel.setGradient(this.getOddColorStart(), this.getOddColorEnd());
            } else {
                panel.setGradient(this.getEvenColorStart(), this.getEvenColorEnd());
            }
            if (isSelected) {
                panel.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
                panel.setForeground(Color.WHITE);
            }
            if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
                panel.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
                panel.setForeground(Color.WHITE);
            }
            ExchangeStateBean ExRates = null;
            if (value instanceof ExchangeStateBean) {
                ExRates = (ExchangeStateBean)value;
            }
            if (ColName.equalsIgnoreCase(ExchangeStatsSummery.this.languageCentre.getValue(LanguageConstant.Indices))) {
                JLabel lblIndices = new JLabel();
                lblIndices.setText(ExRates.getMarket());
                lblIndices.setFont(new Font("Tahoma", 1, 11));
                panel.add(Box.createRigidArea(new Dimension(5, 5)));
                panel.add(lblIndices);
                return panel;
            }
            if (ColName.equalsIgnoreCase(ExchangeStatsSummery.this.languageCentre.getValue(LanguageConstant.Index))) {
                panel.add(Box.createHorizontalGlue());
                JLabel lblIndex = new JLabel();
                panel.add(lblIndex);
                panel.add(Box.createRigidArea(new Dimension(5, 5)));
                JLabel lblOpenBrace = new JLabel();
                lblOpenBrace.setMaximumSize(new Dimension(5, tblDataTable.getRowHeight()));
                lblOpenBrace.setMinimumSize(new Dimension(5, tblDataTable.getRowHeight()));
                lblOpenBrace.setPreferredSize(new Dimension(5, tblDataTable.getRowHeight()));
                panel.add(lblOpenBrace);
                JLabel lblchange = new JLabel();
                lblchange.setMaximumSize(new Dimension(38, tblDataTable.getRowHeight()));
                lblchange.setMinimumSize(new Dimension(38, tblDataTable.getRowHeight()));
                lblchange.setPreferredSize(new Dimension(38, tblDataTable.getRowHeight()));
                lblchange.setHorizontalAlignment(4);
                panel.add(lblchange);
                JLabel lblimg = new JLabel();
                lblimg.setMaximumSize(new Dimension(17, tblDataTable.getRowHeight()));
                lblimg.setMinimumSize(new Dimension(17, tblDataTable.getRowHeight()));
                lblimg.setPreferredSize(new Dimension(17, tblDataTable.getRowHeight()));
                lblimg.setHorizontalAlignment(0);
                panel.add(lblimg);
                JLabel lblPerChange = new JLabel();
                lblPerChange.setMaximumSize(new Dimension(50, tblDataTable.getRowHeight()));
                lblPerChange.setMinimumSize(new Dimension(50, tblDataTable.getRowHeight()));
                lblPerChange.setPreferredSize(new Dimension(50, tblDataTable.getRowHeight()));
                lblPerChange.setHorizontalAlignment(4);
                panel.add(lblPerChange);
                double d = Util.round((double)ExRates.getIndex(), (int)2);
                lblIndex.setText(Util.format2digit((String)(d + "")));
                lblOpenBrace.setText("(");
                double change = Util.round((double)ExRates.getIndexChange(), (int)2);
                lblchange.setText(Util.format2digit((String)(change + "")));
                if (change >= 0.0) {
                    lblimg.setIcon(ExchangeStats.loadImage("up.png"));
                    lblchange.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                    lblIndex.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                    lblOpenBrace.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                    lblPerChange.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                } else {
                    lblimg.setIcon(ExchangeStats.loadImage("down.png"));
                    lblchange.setForeground(Color.red);
                    lblIndex.setForeground(Color.red);
                    lblOpenBrace.setForeground(Color.red);
                    lblPerChange.setForeground(Color.red);
                }
                String ss = Util.format2digit((String)(ExRates.getIndexChange() / (ExRates.getIndex() - ExRates.getIndexChange()) * 100.0 + ""));
                if (ss.equalsIgnoreCase("-0.00")) {
                    lblPerChange.setText("0.00 %)");
                } else {
                    lblPerChange.setText(ss + " %)");
                }
                lblchange.setFont(AppConfig.defaultBoldFontExStats2);
                lblPerChange.setFont(AppConfig.defaultBoldFontExStats2);
                lblOpenBrace.setFont(AppConfig.defaultBoldFontExStats2);
                lblIndex.setFont(new Font("Tahoma", 1, 11));
                panel.add(Box.createRigidArea(new Dimension(3, 3)));
                return panel;
            }
            if (ColName.equalsIgnoreCase(ExchangeStatsSummery.this.languageCentre.getValue(LanguageConstant.High))) {
                panel.add(Box.createHorizontalGlue());
                JLabel lblHigh = new JLabel();
                panel.add(lblHigh);
                panel.add(Box.createRigidArea(new Dimension(5, 5)));
                JLabel lblOpenBrace = new JLabel();
                lblOpenBrace.setMaximumSize(new Dimension(5, tblDataTable.getRowHeight()));
                lblOpenBrace.setMinimumSize(new Dimension(5, tblDataTable.getRowHeight()));
                lblOpenBrace.setPreferredSize(new Dimension(5, tblDataTable.getRowHeight()));
                panel.add(lblOpenBrace);
                JLabel lblChange = new JLabel();
                lblChange.setMaximumSize(new Dimension(38, tblDataTable.getRowHeight()));
                lblChange.setMinimumSize(new Dimension(38, tblDataTable.getRowHeight()));
                lblChange.setPreferredSize(new Dimension(38, tblDataTable.getRowHeight()));
                lblChange.setHorizontalAlignment(4);
                panel.add(lblChange);
                JLabel lblimg = new JLabel();
                lblimg.setMaximumSize(new Dimension(17, tblDataTable.getRowHeight()));
                lblimg.setMinimumSize(new Dimension(17, tblDataTable.getRowHeight()));
                lblimg.setPreferredSize(new Dimension(17, tblDataTable.getRowHeight()));
                lblimg.setHorizontalAlignment(0);
                panel.add(lblimg);
                JLabel lblPerChange = new JLabel();
                lblPerChange.setMaximumSize(new Dimension(50, tblDataTable.getRowHeight()));
                lblPerChange.setMinimumSize(new Dimension(50, tblDataTable.getRowHeight()));
                lblPerChange.setPreferredSize(new Dimension(50, tblDataTable.getRowHeight()));
                lblPerChange.setHorizontalAlignment(4);
                panel.add(lblPerChange);
                double d = Util.round((double)ExRates.getHigh(), (int)2);
                lblHigh.setText(Util.format2digit((String)(d + "")));
                lblOpenBrace.setText("(");
                double change = Util.round((double)ExRates.getHighChange(), (int)2);
                lblChange.setText(Util.format2digit((String)(change + "")));
                if (change >= 0.0) {
                    lblimg.setIcon(ExchangeStats.loadImage("up.png"));
                    lblOpenBrace.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                    lblChange.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                    lblHigh.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                    lblPerChange.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                } else {
                    lblimg.setIcon(ExchangeStats.loadImage("down.png"));
                    lblOpenBrace.setForeground(Color.red);
                    lblChange.setForeground(Color.red);
                    lblHigh.setForeground(Color.red);
                    lblPerChange.setForeground(Color.red);
                }
                String ss = Util.format2digit((String)(ExRates.getHighChange() / (ExRates.getHigh() - ExRates.getHighChange()) * 100.0 + ""));
                if (ss.equalsIgnoreCase("-0.00")) {
                    lblPerChange.setText("0.00 %)");
                } else {
                    lblPerChange.setText(ss + " %)");
                }
                lblChange.setFont(AppConfig.defaultBoldFontExStats2);
                lblPerChange.setFont(AppConfig.defaultBoldFontExStats2);
                lblimg.setFont(AppConfig.defaultBoldFontExStats2);
                lblHigh.setFont(new Font("Tahoma", 1, 11));
                panel.add(Box.createRigidArea(new Dimension(3, 3)));
                return panel;
            }
            if (ColName.equalsIgnoreCase(ExchangeStatsSummery.this.languageCentre.getValue(LanguageConstant.Low))) {
                double d = Util.round((double)ExRates.getLow(), (int)2);
                panel.add(Box.createHorizontalGlue());
                JLabel lblLow = new JLabel();
                panel.add(lblLow);
                panel.add(Box.createRigidArea(new Dimension(5, 5)));
                JLabel lblOpenBrace = new JLabel();
                lblOpenBrace.setMaximumSize(new Dimension(5, tblDataTable.getRowHeight()));
                lblOpenBrace.setMinimumSize(new Dimension(5, tblDataTable.getRowHeight()));
                lblOpenBrace.setPreferredSize(new Dimension(5, tblDataTable.getRowHeight()));
                panel.add(lblOpenBrace);
                JLabel lblChange = new JLabel();
                lblChange.setMaximumSize(new Dimension(38, tblDataTable.getRowHeight()));
                lblChange.setMinimumSize(new Dimension(38, tblDataTable.getRowHeight()));
                lblChange.setPreferredSize(new Dimension(38, tblDataTable.getRowHeight()));
                lblChange.setHorizontalAlignment(4);
                panel.add(lblChange);
                JLabel lblimg = new JLabel();
                lblimg.setMaximumSize(new Dimension(17, tblDataTable.getRowHeight()));
                lblimg.setMinimumSize(new Dimension(17, tblDataTable.getRowHeight()));
                lblimg.setPreferredSize(new Dimension(17, tblDataTable.getRowHeight()));
                lblimg.setHorizontalAlignment(0);
                panel.add(lblimg);
                JLabel lblPerChange = new JLabel();
                lblPerChange.setMaximumSize(new Dimension(50, tblDataTable.getRowHeight()));
                lblPerChange.setMinimumSize(new Dimension(50, tblDataTable.getRowHeight()));
                lblPerChange.setPreferredSize(new Dimension(50, tblDataTable.getRowHeight()));
                lblPerChange.setHorizontalAlignment(4);
                panel.add(lblPerChange);
                lblLow.setText(Util.format2digit((String)(d + "")));
                lblLow.setHorizontalAlignment(4);
                double change = Util.round((double)ExRates.getLowChange(), (int)2);
                lblOpenBrace.setText("(");
                lblChange.setText(Util.format2digit((String)(change + "")));
                if (change >= 0.0) {
                    lblimg.setIcon(ExchangeStats.loadImage("up.png"));
                    lblChange.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                    lblLow.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                    lblOpenBrace.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                    lblPerChange.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                } else {
                    lblimg.setIcon(ExchangeStats.loadImage("down.png"));
                    lblChange.setForeground(Color.red);
                    lblLow.setForeground(Color.red);
                    lblOpenBrace.setForeground(Color.red);
                    lblPerChange.setForeground(Color.red);
                }
                String ss = Util.format2digit((String)(ExRates.getLowChange() / (ExRates.getLow() - ExRates.getLowChange()) * 100.0 + ""));
                if (ss.equalsIgnoreCase("-0.00")) {
                    lblPerChange.setText("0.00 %)");
                } else {
                    lblPerChange.setText(ss + " %)");
                }
                lblChange.setFont(AppConfig.defaultBoldFontExStats2);
                lblOpenBrace.setFont(AppConfig.defaultBoldFontExStats2);
                lblPerChange.setFont(AppConfig.defaultBoldFontExStats2);
                lblLow.setFont(new Font("Tahoma", 1, 11));
                panel.add(Box.createRigidArea(new Dimension(3, 3)));
                return panel;
            }
            if (ColName.equalsIgnoreCase(ExchangeStatsSummery.this.languageCentre.getValue(LanguageConstant.Volume))) {
                JLabel lblVolume = new JLabel();
                lblVolume.setHorizontalAlignment(4);
                lblVolume.setText(Util.format0digit((String)String.valueOf(ExRates.getCVol())));
                lblVolume.setFont(new Font("Tahoma", 1, 11));
                panel.add(Box.createHorizontalGlue());
                panel.add(lblVolume);
                panel.add(Box.createRigidArea(new Dimension(5, 5)));
                return panel;
            }
            if (ColName.equalsIgnoreCase(ExchangeStatsSummery.this.languageCentre.getValue(LanguageConstant.Value))) {
                JLabel lblValue = new JLabel();
                lblValue.setHorizontalAlignment(4);
                lblValue.setText(Util.format2digit((String)(ExRates.getVal() + "")));
                lblValue.setFont(new Font("Tahoma", 1, 11));
                panel.add(Box.createHorizontalGlue());
                panel.add(lblValue);
                panel.add(Box.createRigidArea(new Dimension(5, 5)));
                return panel;
            }
            return panel;
        }
    }
}

