/*
 * Decompiled with CFR 0.152.
 */
package windows;

import Beans.FundTransferBean;
import CATALYST.Socket.EncryptDecrypt;
import CustomComponent.DocumentType;
import CustomComponent.NxGPassword;
import CustomComponent.NxGTextField;
import MyDocking.Mediator;
import RendersNModels.FundTransferRender;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.NxGTable;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import languages.LanguageCentre;

public class FundTransfer
extends JPanel {
    private LanguageCentre languageCentre = new LanguageCentre();
    DefaultTableModel model = new DefaultTableModel();
    private ArrayList<FundTransferBean> rows = new ArrayList();
    private SimpleDateFormat dt = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
    private JButton btnTransfer;
    public JComboBox cbAccountNo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JLabel lblMessage;
    private JLabel lblOrderHeader;
    private JLabel lblPinCode;
    private JScrollPane scrollPane;
    private NxGTable table;
    private JTextField txtApprovedFund;
    private JTextField txtAvailableFund;
    private JTextField txtFundAllocated;
    private NxGTextField txtFundTransfer;
    private NxGPassword txtPinCode;
    private JTextField txtRemaining;

    public FundTransfer() {
        this.initComponents();
        Mediator.getInstance().setFundTransfer(this);
        this.lblOrderHeader.setText("<html> <b> Fund Transfer and Allocation Summary </b> <html>");
        this.setAccounts();
        this.setForDocument();
        this.getFundAllocationInfo();
        this.initTable();
    }

    private void setAccounts() {
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
    }

    private void setForDocument() {
        this.txtPinCode.setDocument(DocumentType.NUMERIC, 4);
        this.txtFundTransfer.setDocument(DocumentType.NUMERIC, 10);
    }

    private void initComponents() {
        this.lblMessage = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.jLabel4 = new JLabel();
        this.txtFundAllocated = new JTextField();
        this.txtAvailableFund = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.txtRemaining = new JTextField();
        this.btnTransfer = new JButton();
        this.lblPinCode = new JLabel();
        this.txtPinCode = new NxGPassword();
        this.txtFundTransfer = new NxGTextField();
        this.jLabel7 = new JLabel();
        this.txtApprovedFund = new JTextField();
        this.jPanel2 = new JPanel();
        this.scrollPane = new JScrollPane();
        this.table = new NxGTable();
        this.lblOrderHeader = new JLabel();
        this.jLabel1 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.setLayout(null);
        this.lblMessage.setText(" ");
        this.add(this.lblMessage);
        this.lblMessage.setBounds(20, 350, 510, 20);
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 345, 730, 3);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(" Transfer Fund "));
        this.jPanel1.setLayout(null);
        this.jLabel2.setText("Available Fund");
        this.jPanel1.add(this.jLabel2);
        this.jLabel2.setBounds(20, 50, 80, 22);
        this.jLabel3.setText("Account");
        this.jPanel1.add(this.jLabel3);
        this.jLabel3.setBounds(20, 80, 80, 22);
        this.cbAccountNo.setEditable(true);
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FundTransfer.this.cbAccountNoItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.cbAccountNo);
        this.cbAccountNo.setBounds(110, 80, 120, 22);
        this.jLabel4.setText("Fund Transfer");
        this.jPanel1.add(this.jLabel4);
        this.jLabel4.setBounds(20, 140, 80, 22);
        this.txtFundAllocated.setEditable(false);
        this.txtFundAllocated.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtFundAllocated);
        this.txtFundAllocated.setBounds(110, 110, 120, 22);
        this.txtAvailableFund.setEditable(false);
        this.txtAvailableFund.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtAvailableFund);
        this.txtAvailableFund.setBounds(110, 50, 120, 22);
        this.jLabel5.setText("Fund Allocated");
        this.jPanel1.add(this.jLabel5);
        this.jLabel5.setBounds(20, 110, 80, 22);
        this.jLabel6.setText("Remaining");
        this.jPanel1.add(this.jLabel6);
        this.jLabel6.setBounds(20, 170, 80, 22);
        this.txtRemaining.setEditable(false);
        this.txtRemaining.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtRemaining);
        this.txtRemaining.setBounds(110, 170, 120, 22);
        this.btnTransfer.setIcon(new ImageIcon(this.getClass().getResource("/Images/MenuFundTransfer.png")));
        this.btnTransfer.setText("Transfer");
        this.btnTransfer.setName("FundTransfer -> btnTransfer");
        this.btnTransfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FundTransfer.this.btnTransferActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnTransfer);
        this.btnTransfer.setBounds(110, 230, 120, 25);
        this.lblPinCode.setHorizontalAlignment(2);
        this.lblPinCode.setText("PIN");
        this.jPanel1.add(this.lblPinCode);
        this.lblPinCode.setBounds(20, 200, 80, 22);
        this.jPanel1.add(this.txtPinCode);
        this.txtPinCode.setBounds(110, 200, 120, 22);
        this.txtFundTransfer.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FundTransfer.this.txtFundTransferKeyReleased(evt);
            }
        });
        this.jPanel1.add(this.txtFundTransfer);
        this.txtFundTransfer.setBounds(110, 140, 120, 22);
        this.jLabel7.setText("Approved Fund");
        this.jPanel1.add(this.jLabel7);
        this.jLabel7.setBounds(20, 20, 80, 22);
        this.txtApprovedFund.setEditable(false);
        this.txtApprovedFund.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtApprovedFund);
        this.txtApprovedFund.setBounds(110, 20, 120, 22);
        this.add(this.jPanel1);
        this.jPanel1.setBounds(470, 70, 250, 270);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(" Transfer Allocation Summary "));
        this.table.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Trader", "Account No", "Fund Allocated", "Fund Date"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{true, false, false, true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                FundTransfer.this.tableMousePressed(evt);
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.scrollPane, -1, 428, Short.MAX_VALUE).addGap(5, 5, 5)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 243, Short.MAX_VALUE));
        this.add(this.jPanel2);
        this.jPanel2.setBounds(10, 70, 450, 270);
        this.lblOrderHeader.setIcon(new ImageIcon(this.getClass().getResource("/Images/FundTransfer.png")));
        this.lblOrderHeader.setText("-------");
        this.add(this.lblOrderHeader);
        this.lblOrderHeader.setBounds(28, 0, 360, 60);
        this.jLabel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/Images/HeaderBG.png")));
        this.jLabel1.setOpaque(true);
        this.add(this.jLabel1);
        this.jLabel1.setBounds(0, 0, 730, 60);
        this.add(this.jSeparator2);
        this.jSeparator2.setBounds(0, 60, 730, 3);
        this.jSeparator3.setOrientation(1);
        this.add(this.jSeparator3);
        this.jSeparator3.setBounds(465, 90, 3, 230);
    }

    private void cbAccountNoItemStateChanged(ItemEvent evt) {
        if (this.cbAccountNo.getSelectedItem() != null) {
            this.txtFundAllocated.setText("");
            String account = this.cbAccountNo.getSelectedItem() + "";
            for (FundTransferBean fundTransferBean : this.rows) {
                if (!fundTransferBean.getAccount().equalsIgnoreCase(account)) continue;
                this.txtFundAllocated.setText(Util.format0digit((String)(fundTransferBean.getFundAllocated() + "")));
                break;
            }
        }
    }

    private void tableMousePressed(MouseEvent evt) {
        if (this.table.getSelectedRow() >= 0) {
            FundTransferBean b = this.rows.get(this.table.getSelectedRow());
            this.cbAccountNo.setSelectedItem(b.getAccount());
            this.txtFundAllocated.setText(Util.format0digit((String)(b.getFundAllocated() + "")));
        }
    }

    private void txtFundTransferKeyReleased(KeyEvent evt) {
        String af = this.txtAvailableFund.getText().replaceAll(",", "");
        long availableFund = Long.parseLong(af);
        String ft = this.txtFundTransfer.getText().replaceAll(",", "");
        long fundTransfer = Long.parseLong(ft);
        long rem = availableFund - fundTransfer;
        this.txtRemaining.setText(Util.format0digit((String)(rem + "")));
    }

    private void btnTransferActionPerformed(ActionEvent evt) {
        if (this.isValidInput()) {
            String af = this.txtAvailableFund.getText().replaceAll(",", "");
            long availableFund = Long.parseLong(af);
            String ft = this.txtFundTransfer.getText().replaceAll(",", "");
            long fundTransfer = Long.parseLong(ft);
            if (fundTransfer > availableFund) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)("You cannot Transfer fund more then available fund(" + this.txtAvailableFund.getText() + ")"));
                this.txtFundTransfer.requestFocus();
            } else {
                this.submitRequest();
            }
        }
    }

    private void getFundAllocationInfo() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FundTransfer.this.txtAvailableFund.setText("");
                Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Loading, (String)"Loading information");
                try {
                    String result = WebService.getInstance().getPort().getInfo(EncryptDecrypt.getInstance().EncryptText(LogCommon.UserID), "FundAllocationInfo=", "");
                    Mediator.getInstance().println("FundAllocationInfo = " + result);
                    if (result.indexOf("$") >= 0) {
                        String[] data = result.split("\\$", -1);
                        if (data.length > 0) {
                            String fundInfo = data[0];
                            String accountInfo = data[1];
                            if (fundInfo.indexOf(";") >= 0) {
                                String[] fund = fundInfo.split("\\;", -1);
                                if (fund.length > 0) {
                                    FundTransfer.this.txtApprovedFund.setText(Util.format0digit((String)fund[0]));
                                    FundTransfer.this.txtAvailableFund.setText(Util.format0digit((String)fund[1]));
                                }
                            } else if (fundInfo.indexOf("Exception") >= 0) {
                                Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Available Fund");
                            }
                            if (accountInfo.indexOf("|") >= 0) {
                                String[] fundRow = accountInfo.split("\\|", -1);
                                for (int i = 0; i < fundRow.length; ++i) {
                                    String[] row;
                                    String rowData = fundRow[i];
                                    if (rowData.indexOf(";") < 0 || (row = rowData.split("\\;", -1)).length <= 0) continue;
                                    FundTransferBean b = new FundTransferBean();
                                    b.setTrader(row[0]);
                                    b.setAccount(row[1]);
                                    b.setFundAllocated(Long.parseLong(row[2]));
                                    b.setFundDate(FundTransfer.this.dt.parse(row[3]));
                                    FundTransfer.this.rows.add(b);
                                }
                            } else if (fundInfo.indexOf("Exception") >= 0) {
                                Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Account Fund");
                            }
                        } else {
                            Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading data");
                        }
                    } else {
                        Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Information, (String)"No record found");
                    }
                    if (result.equalsIgnoreCase("Exception")) {
                        Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Available Fund");
                    } else {
                        Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                    }
                }
                catch (Exception ex) {
                    Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Available Fund");
                    ex.printStackTrace();
                    Mediator.getInstance().WriteExceptionInClientMachine(ex);
                }
                FundTransfer.this.addRows();
            }
        }).start();
    }

    private void initTable() {
        ((JLabel)((Object)this.table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        this.model = (DefaultTableModel)this.table.getModel();
        this.table.setModel((TableModel)this.model);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new FundTransferRender());
        this.table.setRowHeight(18);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnControlVisible(false);
    }

    private void addRows() {
        for (int i = 0; i < this.rows.size(); ++i) {
            FundTransferBean bean = this.rows.get(i);
            this.model.addRow(new Object[]{bean.getTrader(), bean.getAccount(), bean.getFundAllocated(), this.dt.format(bean.getFundDate())});
        }
        this.tableDataChange();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
            this.table.packAll();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FundTransfer.this.model.fireTableDataChanged();
                    FundTransfer.this.table.addNotify();
                    FundTransfer.this.table.repaint();
                    FundTransfer.this.table.packAll();
                }
            });
        }
    }

    private boolean isValidInput() {
        boolean isValid = false;
        if (this.txtAvailableFund.getText().trim().length() < 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Fund not Available");
            this.txtAvailableFund.requestFocus();
        } else if (this.cbAccountNo.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select Account No");
            this.cbAccountNo.requestFocus();
        } else if (this.cbAccountNo.getSelectedItem().toString().trim().length() < 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select Account No");
            this.cbAccountNo.requestFocus();
        } else if (this.txtFundTransfer.getText().trim().length() < 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter fund transfer amount");
            this.txtFundTransfer.requestFocus();
        } else if (this.txtPinCode.getText().trim().length() < 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter PIN");
            this.txtPinCode.requestFocus();
        } else {
            isValid = true;
        }
        return isValid;
    }

    private void reset() {
        this.emptyTable();
        this.getFundAllocationInfo();
        this.txtApprovedFund.setText("");
        this.txtAvailableFund.setText("");
        this.cbAccountNo.setSelectedItem("");
        this.txtFundAllocated.setText("");
        this.txtFundTransfer.setText("");
        this.txtRemaining.setText("");
        this.txtPinCode.setText("");
    }

    private void emptyTable() {
        for (int i = 0; i < this.rows.size(); ++i) {
            this.model.removeRow(0);
        }
        this.rows.clear();
        this.tableDataChange();
    }

    private void submitRequest() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait while we are processing your request...");
                FundTransfer.this.btnTransfer.setEnabled(false);
                String userId = EncryptDecrypt.getInstance().EncryptText(LogCommon.UserID);
                String account = EncryptDecrypt.getInstance().EncryptText(FundTransfer.this.cbAccountNo.getSelectedItem() + "");
                String PIN = EncryptDecrypt.getInstance().EncryptText(FundTransfer.this.txtPinCode.getText());
                String fund = FundTransfer.this.txtFundTransfer.getText();
                try {
                    String result = WebService.getInstance().getPort().getAccountStatement(userId, account, PIN, fund, "FundTransfer");
                    Mediator.getInstance().println("FundTransfer = " + result);
                    FundTransfer.this.btnTransfer.setEnabled(true);
                    if (result.equalsIgnoreCase("Error")) {
                        Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Server is not avaiable");
                    } else if (result.equalsIgnoreCase("Exception")) {
                        Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Your request is not fulfill at this time");
                    } else if (result.equalsIgnoreCase("InvalidFund")) {
                        Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Provided fund figure is not correct");
                    } else if (result.equalsIgnoreCase("AccountNotAssign")) {
                        Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)("Account(" + FundTransfer.this.cbAccountNo.getSelectedItem() + ") is not assigned to you, please select correct Account No"));
                        FundTransfer.this.cbAccountNo.requestFocus();
                    } else if (result.equalsIgnoreCase("InvalidPIN")) {
                        Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Your provided PIN is invalid");
                        FundTransfer.this.txtPinCode.requestFocus();
                    } else if (result.equalsIgnoreCase("FundNotAvaialable")) {
                        Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"your Account No does not have sufficient funds");
                        FundTransfer.this.txtFundTransfer.requestFocus();
                    } else if (result.equalsIgnoreCase("FundTransfer")) {
                        Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Sussess, (String)"Your request Fund have been transferred");
                        FundTransfer.this.reset();
                    }
                }
                catch (Exception ex) {
                    Util.setMessage((JLabel)FundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in submitting request");
                    Mediator.getInstance().WriteExceptionInClientMachine(ex);
                }
            }
        }).start();
    }
}

