/*
 * Decompiled with CFR 0.152.
 */
package windows;

import Beans.TechnicalsBean;
import Beans.ValueBean;
import BeansContainer.AllContainer;
import BeansContainer.CompanySnapshotContainer;
import BeansContainer.FundamentalsContainer;
import BeansContainer.PerformanceContainer;
import BeansContainer.TechnicalsContainer;
import BeansContainer.ValuationContainer;
import CATALYST.Control.MarketFeed;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Screener.HeaderPanel;
import Screener.HistPanelColumn;
import Screener.HistoricalPanel;
import Utilities.LogsTC;
import com.google.gson.Gson;
import common.gui.component.JTextFieldFilter;
import common.gui.component.NxGScrollBarUI;
import common.gui.layout.NxGWrapLayout;
import common.gui.util.AppConfig;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Document;
import kse.util.HistoricalDataType;

public class HistoricalData
extends JPanel {
    HistoricalPanel historicalPanel = null;
    JPanel pnlComp = null;
    Mediator mediator = Mediator.getInstance();
    TradeCast tradeCast = TradeCast.getInstance();
    private String market = "REG";
    private String scrip = "";
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JLabel lblMessage;
    private JTextField txtScrip;

    public HistoricalData(String Scrip) {
        this.initComponents();
        this.txtScrip.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
        this.mediator.setHData(this);
        this.historicalPanel = new HistoricalPanel(null);
        this.setScrollPane();
        this.txtScrip.addFocusListener(null);
        this.lblMessage.setText(" ");
    }

    public void setinfo() {
        this.setFontOnComponent(this.lblMessage, this.lblMessage.getFont().deriveFont(1));
        this.lblMessage.setText(this.mediator.getSymbolTitle(this.scrip));
        this.historicalPanel.addHistoricalData(this.market, this.scrip);
    }

    private void setFontOnComponent(final JComponent com, final Font font) {
        if (SwingUtilities.isEventDispatchThread()) {
            com.setFont(font);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    com.setFont(font);
                }
            });
        }
    }

    private void setScrollPane() {
        this.jScrollPane1.setHorizontalScrollBarPolicy(30);
        this.jScrollPane1.setVerticalScrollBarPolicy(20);
        UIManager.put("ScrollBar.background", 1);
        JScrollBar vbar = this.jScrollPane1.getVerticalScrollBar();
        NxGScrollBarUI ui2 = new NxGScrollBarUI();
        ui2.setMyScrollBarUI(vbar);
        vbar.setPreferredSize(new Dimension(7, 0));
        this.jScrollPane1.setHorizontalScrollBarPolicy(30);
        NxGWrapLayout layoutData = new NxGWrapLayout(0);
        layoutData.setHgap(0);
        layoutData.setVgap(0);
        this.jScrollPane1.setViewportView(this.historicalPanel);
    }

    private void initComponents() {
        this.txtScrip = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lblMessage = new JLabel();
        this.txtScrip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoricalData.this.txtScripActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Scrip");
        this.lblMessage.setText("A");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel2).addGap(4, 4, 4).addComponent(this.txtScrip, -2, 40, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addComponent(this.lblMessage, -1, 138, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jLabel2)).addComponent(this.txtScrip, -2, -1, -2)).addGap(6, 6, 6).addComponent(this.jScrollPane1, -1, 60, Short.MAX_VALUE).addGap(4, 4, 4).addComponent(this.lblMessage).addGap(3, 3, 3)));
    }

    private void txtScripActionPerformed(ActionEvent evt) {
        this.scrip = this.txtScrip.getText().toString();
        this.setinfo();
    }

    public void addHistoricalData(String market, String scrip) {
        this.market = market;
        this.scrip = scrip;
        if (scrip != null && scrip.trim().length() > 0) {
            new Thread(new HistoricalDataLoad(market, scrip)).start();
        }
    }

    private String getHistoricalDataSingleAndAdd(String type, String market, String scrip) {
        Gson gson = new Gson();
        String val = this.getHistoricalDataFromServer(type, market, scrip);
        if (val != null) {
            AllContainer allContainer = (AllContainer)gson.fromJson(val, AllContainer.class);
            LogsTC.HistoricalData.put(scrip, allContainer);
            this.updateTechnicals(market, scrip, allContainer);
            this.setHistoricalData(market, scrip, allContainer);
        } else {
            this.setBackground(Color.WHITE);
            this.empty();
        }
        return "";
    }

    private String getHistoricalDataFromServer(String type, String market, String scrip) {
        try {
            String inputLine;
            System.err.println("Type = " + type + " , Market = " + market + " , Scrip = " + scrip);
            String encodedUrl = URLEncoder.encode(scrip, "UTF-8");
            String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/DataServiceServlet?service=" + type + "&scrip=" + encodedUrl;
            StringBuilder sb = new StringBuilder();
            URL url = new URL(call);
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine);
            }
            in.close();
            Mediator.getInstance().println("Historical Value URL = " + call);
            Mediator.getInstance().println("Historical Value HTML = " + sb.toString());
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void empty() {
        this.removeAll();
        this.repaint();
    }

    private void setHistoricalData(String market, String scrip, final AllContainer allContainer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistoricalData.this.setBackground(Color.WHITE);
                HistoricalData.this.empty();
                if (allContainer != null) {
                    FundamentalsContainer fundamentalsContainer = allContainer.getFundamentalsContainer();
                    PerformanceContainer performanceContainer = allContainer.getPerformanceContainer();
                    TechnicalsContainer technicalsContainer = allContainer.getTechnicalsContainer();
                    ValuationContainer valuationContainer = allContainer.getValuationContainer();
                    CompanySnapshotContainer companySnapshotContainer = allContainer.getCompanySnapshotContainer();
                    HistoricalData.this.addValuesPanelColumn(HistoricalDataType.Valuations, valuationContainer.list);
                    HistoricalData.this.addValuesPanelColumn(HistoricalDataType.Fundamentals, fundamentalsContainer.list);
                    HistoricalData.this.addValuesPanelColumn(HistoricalDataType.Performance, performanceContainer.list);
                    HistoricalData.this.addValuesPanelColumn(HistoricalDataType.Technicals, technicalsContainer.list);
                    HistoricalData.this.repaint();
                }
            }
        });
    }

    private void addHeaderColumn(JPanel p, HistoricalDataType type) {
        ImageIcon icon = null;
        if (type == HistoricalDataType.Fundamentals) {
            icon = new ImageIcon(this.getClass().getResource("/Images/fundamental12.png"));
        } else if (type == HistoricalDataType.Performance) {
            icon = new ImageIcon(this.getClass().getResource("/Images/performance12.png"));
        } else if (type == HistoricalDataType.Technicals) {
            icon = new ImageIcon(this.getClass().getResource("/Images/technical12.png"));
        } else if (type == HistoricalDataType.Valuations) {
            icon = new ImageIcon(this.getClass().getResource("/Images/valuation12.png"));
        }
        HeaderPanel lblTitle = new HeaderPanel();
        lblTitle.setHeader(type.toString(), icon);
        p.add(lblTitle);
    }

    private void addValuesPanelColumn(HistoricalDataType type, List list) {
        JLabel lblSpace = new JLabel();
        NxGWrapLayout layoutSingleData = new NxGWrapLayout(0);
        layoutSingleData.setHgap(0);
        layoutSingleData.setVgap(0);
        JPanel pnlSingleData = new JPanel((LayoutManager)layoutSingleData);
        pnlSingleData.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
        NxGWrapLayout layoutData = new NxGWrapLayout(1);
        layoutData.setHgap(0);
        layoutData.setVgap(0);
        JPanel pnlData = new JPanel((LayoutManager)layoutData);
        pnlData.setBackground(Color.WHITE);
        this.addHeaderColumn(pnlData, type);
        for (int i = 0; i < list.size(); ++i) {
            ValueBean bean = (ValueBean)list.get(i);
            HistPanelColumn pnlValue = new HistPanelColumn(bean.title, bean.title_tooltip, bean.value, bean.value_tooltip, bean.color);
            pnlData.add(pnlValue);
        }
        this.add(pnlData);
        this.repaint();
    }

    private void updateTechnicals(String Market, String scrip, AllContainer allContainer) {
        TechnicalsContainer ValCont = allContainer.getTechnicalsContainer();
        ValCont.list.clear();
        MarketFeed feed = Mediator.getInstance().MwPanel.GetSingleFeed(scrip, Market);
        if (feed != null) {
            double high = Double.parseDouble(feed.high);
            double low = Double.parseDouble(feed.low);
            double closePrice = Double.parseDouble(feed.closePrice);
            double pivot = (high + low + closePrice) / 3.0;
            double support1 = 2.0 * pivot - high;
            double support2 = pivot - (high - low);
            double support3 = pivot - 2.0 * (high - low);
            double resistance1 = 2.0 * pivot - low;
            double resistance2 = pivot + (high - low);
            double resistance3 = pivot + 2.0 * (high - low);
            TechnicalsBean highBean = new TechnicalsBean();
            highBean.title = "High";
            highBean.value = Util.format2digit((String)(high + ""));
            ValCont.add(highBean);
            TechnicalsBean lowBean = new TechnicalsBean();
            lowBean.title = "Low";
            lowBean.value = Util.format2digit((String)("" + low));
            ValCont.add(lowBean);
            TechnicalsBean closePriceBean = new TechnicalsBean();
            closePriceBean.title = "Close Price";
            closePriceBean.value = Util.format2digit((String)("" + closePrice));
            ValCont.add(closePriceBean);
            TechnicalsBean support1Bean = new TechnicalsBean();
            support1Bean.title = "Support-1";
            support1Bean.value = Util.format2digit((String)("" + support1));
            ValCont.add(support1Bean);
            TechnicalsBean support2Bean = new TechnicalsBean();
            support2Bean.title = "Support-2";
            support2Bean.value = Util.format2digit((String)("" + support2));
            ValCont.add(support2Bean);
            TechnicalsBean support3Bean = new TechnicalsBean();
            support3Bean.title = "Support-3";
            support3Bean.value = Util.format2digit((String)("" + support3));
            ValCont.add(support3Bean);
            TechnicalsBean resistance1Bean = new TechnicalsBean();
            resistance1Bean.title = "Resistance-1";
            resistance1Bean.value = Util.format2digit((String)("" + resistance1));
            ValCont.add(resistance1Bean);
            TechnicalsBean resistance2Bean = new TechnicalsBean();
            resistance2Bean.title = "Resistance-2";
            resistance2Bean.value = Util.format2digit((String)("" + resistance2));
            ValCont.add(resistance2Bean);
            TechnicalsBean resistance3Bean = new TechnicalsBean();
            resistance3Bean.title = "Resistance-3";
            resistance3Bean.value = Util.format2digit((String)("" + resistance3));
            ValCont.add(resistance3Bean);
        }
    }

    public void AddSymbol(String Symbol_, String Market) {
        if (!this.scrip.equalsIgnoreCase(Symbol_)) {
            this.txtScrip.setText(Symbol_);
            this.scrip = Symbol_;
            this.market = Market;
            this.setinfo();
        }
    }

    private class HistoricalDataLoad
    extends Thread {
        private final String market2;
        private final String scrip2;

        public HistoricalDataLoad(String market, String scrip) {
            this.market2 = market;
            this.scrip2 = scrip;
            this.setName("loaddata (" + market + " , " + scrip + ")");
        }

        @Override
        public void run() {
            HistoricalData.this.empty();
            try {
                if (LogsTC.HistoricalData.containsKey(this.scrip2)) {
                    HistoricalData.this.updateTechnicals(this.market2, this.scrip2, LogsTC.HistoricalData.get(this.scrip2));
                    HistoricalData.this.setHistoricalData(this.market2, this.scrip2, LogsTC.HistoricalData.get(this.scrip2));
                } else {
                    HistoricalData.this.getHistoricalDataSingleAndAdd("HistoricalData", this.market2, this.scrip2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

