/*
 * Decompiled with CFR 0.152.
 */
package windows;

import CATALYST.Control.Utilities;
import CustomComponent.ForgetMouseListner;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LoadLogs;
import Utilities.LogsTC;
import common.gui.component.JTextFieldFilter;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXTitledSeparator;

public class JSInternalBankTransfer
extends JPanel
implements FocusListener {
    Mediator mediator = Mediator.getInstance();
    double accountExposure = 0.0;
    JTextComponent editor1;
    LanguageCentre languageCentre = new LanguageCentre();
    private final String linkText = this.languageCentre.getValue(LanguageConstant.CashWithdrawalStatement);
    private final String commentsText = "Please enter your comments (if required)";
    private static String CNIC = "";
    private static String branchCity = "";
    public static final int diff = 80;
    private List<String> fundAccoutList = new ArrayList<String>();
    private Map<String, String> fundAccountBranchMap = new HashMap<String, String>();
    private Map<String, FundBankName> accountInfo = new HashMap<String, FundBankName>();
    private static String banksName = "";
    private JButton btnFetchTitle;
    private JButton btnSubmit;
    private ButtonGroup buttonGroup;
    public JComboBox cbAccountNo;
    private JComboBox cbBankName;
    private JComboBox cbBranchCity;
    private JRadioButton isChequeDelivery;
    private JRadioButton isChequePickup;
    private JRadioButton isFundTransfer;
    private JCheckBox isOtherAccount;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator4;
    private JXTitledSeparator jXTitledSeparator2;
    private JXTitledSeparator jXTitledSeparator6;
    private JLabel lblCashWithdrawalStatementLink;
    private JLabel lblChequeDeliveryLogo;
    private JLabel lblChequePickupLogo;
    private JLabel lblForgetPinCode;
    private JTextField lblFundAccount;
    private JTextField lblFundBankName;
    private JTextField lblFundBranchName;
    private JTextField lblFundTitle;
    private JLabel lblMessage;
    private JLabel lblTransferLogo;
    private ButtonGroup rbGroup;
    private JSeparator sepBottom;
    private JSeparator sepComments;
    private JSeparator sepOnline;
    private JTextField txtAmount;
    private JTextField txtAvbAmount;
    private JTextPane txtDescription;
    private JPasswordField txtPinCode;
    private JTextField txtRemainingAmount;

    public JSInternalBankTransfer() {
        this.mediator.setjSInternalBankTransfer(this);
        this.initComponents();
        this.txtAmount.setDocument((Document)new JTextFieldFilter("0123456789."));
        this.editor1 = (JTextComponent)this.cbAccountNo.getEditor().getEditorComponent();
        this.editor1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    JSInternalBankTransfer.this.setAmountRequest();
                    JSInternalBankTransfer.this.txtPinCode.requestFocus();
                }
            }
        });
        Vector<Object> v = new Vector<Object>(Arrays.asList(LogsTC.accountAll.keySet().toArray()));
        v.add(0, "");
        Collections.sort(v);
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(v.toArray()));
        if (LogCommon.preferredAccount.equalsIgnoreCase("")) {
            this.cbAccountNo.setSelectedItem("");
        } else {
            this.cbAccountNo.setSelectedItem(LogCommon.preferredAccount);
        }
        this.txtAmount.addFocusListener(this);
        this.txtPinCode.addFocusListener(this);
        this.txtAvbAmount.setBackground(Color.WHITE);
        this.txtRemainingAmount.setBackground(Color.WHITE);
        ForgetMouseListner forgetMouseListner = new ForgetMouseListner(this.lblForgetPinCode);
        this.lblForgetPinCode.setForeground(MyColors.ForgotPincodeFG);
        this.lblForgetPinCode.setText("<html>Forgot PIN?</html>");
        this.lblCashWithdrawalStatementLink.setText("<html>" + this.linkText + "</html>");
        this.lblCashWithdrawalStatementLink.setCursor(Cursor.getPredefinedCursor(12));
        this.lblForgetPinCode.addMouseListener(forgetMouseListner);
        this.txtDescription.setDocument(new LimitedLinesDocument(199, 199));
        this.txtDescription.setText("Please enter your comments (if required)");
        this.txtPinCode.setText(LogCommon.pinCode);
        this.txtPinCode.setDocument((Document)new JTextFieldFilter("0123456789", 4));
        this.cbBankName.setVisible(false);
        this.setAmountRequest();
        this.setFormDynamic();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                JSInternalBankTransfer.this.cbAccountNo.requestFocus();
            }
        }.start();
    }

    public void setBankNames(String result) {
        if (result.indexOf("|") >= 0) {
            String banks = "Please select|" + result;
            this.cbBankName.setModel(new DefaultComboBoxModel<String>(banks.split("\\|", -1)));
            this.cbBankName.removeItem("");
            banksName = result;
        }
    }

    public void setBranchs(String branchs) {
        String tmp = branchs;
        if (tmp.indexOf("#") > 0) {
            tmp = "Please Select a Branch#" + tmp;
            LogsKSE.Branches = Utilities.split((String)tmp, (char)'#');
        }
    }

    public void setTitle(String result) {
        this.lblFundTitle.setText(result);
    }

    public void fetchTitle() {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        String account = this.cbAccountNo.getSelectedItem().toString().trim();
        String pincode = this.txtPinCode.getText();
        String amt = this.txtAmount.getText().trim();
        double amount = 0.0;
        try {
            amount = Double.parseDouble(amt);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (account.length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select account");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (pincode.length() <= 3) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter PIN");
            this.txtPinCode.requestFocus();
            return;
        }
        if (amt.length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter amount");
            this.txtAmount.requestFocus();
            return;
        }
        if (amount <= 0.0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"You cannot withdraw Zero Rupees");
            this.txtAmount.requestFocus();
            return;
        }
        if (amount > this.accountExposure) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Insufficient available amount");
            this.txtAmount.requestFocus();
            return;
        }
        if (this.lblFundAccount.getText().trim().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please provide Fund Transfer Account information");
            this.lblFundAccount.requestFocus();
            return;
        }
        new Thread(){

            @Override
            public void run() {
                String result = "";
                try {
                    Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait while submitting...");
                    JSInternalBankTransfer.this.btnFetchTitle.setEnabled(false);
                    String clientInfo = WebService.getInstance().getPort().getClientInfo(LogCommon.UserID, JSInternalBankTransfer.this.getAccount(), "");
                    String[] FieldValues2 = clientInfo.split("\\|")[0].split("\\;", -1);
                    CNIC = FieldValues2[9];
                    result = WebService.getInstance().getPort().getInfo(LogCommon.UserID, "FetchTitle=", JSInternalBankTransfer.this.lblFundAccount.getText().toString() + "|" + CNIC);
                    Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                    if (result.indexOf("|") >= 0 || result.length() < 1) {
                        Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in fetching title.");
                        JSInternalBankTransfer.this.btnFetchTitle.setEnabled(true);
                        JSInternalBankTransfer.this.btnSubmit.setEnabled(false);
                    } else {
                        JSInternalBankTransfer.this.setTitle(result);
                        JSInternalBankTransfer.this.btnFetchTitle.setEnabled(true);
                        JSInternalBankTransfer.this.btnSubmit.setEnabled(true);
                    }
                }
                catch (Exception ex) {
                    Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in submitting request");
                    JSInternalBankTransfer.this.btnFetchTitle.setEnabled(true);
                    JSInternalBankTransfer.this.btnSubmit.setEnabled(false);
                    Mediator.getInstance().PrintLog(ex, result);
                }
            }
        }.start();
    }

    public void initiateFundTransferRequest() {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        String account = this.cbAccountNo.getSelectedItem().toString().trim();
        String pincode = this.txtPinCode.getText();
        String amt = this.txtAmount.getText().trim();
        double amount = 0.0;
        try {
            amount = Double.parseDouble(amt);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (account.length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select account");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (pincode.length() <= 3) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter PIN");
            this.txtPinCode.requestFocus();
            return;
        }
        if (amt.length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter amount");
            this.txtAmount.requestFocus();
            return;
        }
        if (amount <= 0.0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"You cannot withdraw Zero Rupees");
            this.txtAmount.requestFocus();
            return;
        }
        if (amount > this.accountExposure) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Insufficient available amount");
            this.txtAmount.requestFocus();
            return;
        }
        if (this.isFundTransfer.isSelected()) {
            if (this.lblFundAccount.getText().trim().length() <= 0) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please provide Fund Transfer Account information");
                this.lblFundAccount.requestFocus();
                return;
            }
            if (this.lblFundTitle.getText().trim().length() <= 0) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please provide Fund Transfer Title information");
                this.lblFundTitle.requestFocus();
                return;
            }
        }
        new Thread(){

            @Override
            public void run() {
                String result = "";
                try {
                    Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait while submitting...");
                    JSInternalBankTransfer.this.btnFetchTitle.setEnabled(false);
                    JSInternalBankTransfer.this.btnSubmit.setEnabled(false);
                    result = WebService.getInstance().getPort().getInfo(LogCommon.UserID, "JSFundTransfer=", JSInternalBankTransfer.this.lblFundAccount.getText().toString() + "|" + CNIC + "|" + JSInternalBankTransfer.this.txtAmount.getText().trim());
                    Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                    if (result.indexOf("|") >= 0 || result.length() < 1) {
                        Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in transaction.");
                        JSInternalBankTransfer.this.btnFetchTitle.setEnabled(true);
                        JSInternalBankTransfer.this.btnSubmit.setEnabled(false);
                    }
                    if (result.equalsIgnoreCase("00")) {
                        JSInternalBankTransfer.this.reset();
                        JOptionPane.showMessageDialog(TradeCast.getInstance().frame, "Your request has been submitted.               ", JSInternalBankTransfer.this.languageCentre.getValue(LanguageConstant.CashWithdrawalRequest), 1);
                        TradeCast.getInstance().CloseForm(FormName.JSinternalBankFundTransfer);
                    } else if (result.equalsIgnoreCase("46")) {
                        Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Transaction Rejected");
                        JSInternalBankTransfer.this.txtPinCode.requestFocus();
                    } else if (result.equalsIgnoreCase("96")) {
                        Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Message Format Error");
                        JSInternalBankTransfer.this.txtPinCode.requestFocus();
                    } else if (result.equalsIgnoreCase("68")) {
                        Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Timed out");
                        JSInternalBankTransfer.this.txtPinCode.requestFocus();
                    } else if (result.equalsIgnoreCase("07")) {
                        Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Unauthorized Access");
                        JSInternalBankTransfer.this.txtPinCode.requestFocus();
                    } else if (result.equalsIgnoreCase("Error")) {
                        Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in submitting");
                    } else {
                        Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)result);
                    }
                    JSInternalBankTransfer.this.btnFetchTitle.setEnabled(true);
                }
                catch (Exception ex) {
                    Util.setMessage((JLabel)JSInternalBankTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in submitting request");
                    JSInternalBankTransfer.this.btnFetchTitle.setEnabled(true);
                    Mediator.getInstance().PrintLog(ex, result);
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    private void reset() {
        try {
            this.cbAccountNo.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.txtPinCode.setText("");
        this.txtAvbAmount.setText("");
        this.txtRemainingAmount.setText("");
        this.txtAmount.setText("");
        this.isChequeDelivery.setSelected(true);
        this.lblFundBankName.setText("");
        this.lblFundBranchName.setText("");
        this.lblFundAccount.setText("");
        this.lblFundTitle.setText("");
        this.txtDescription.setText("Please enter your comments (if required)");
        this.setType();
    }

    public void SetReponseMsg(String str) {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        if (str.indexOf("Successfully") >= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Sussess, (String)(str + "!"));
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)str);
        }
    }

    public void setAccountAmount(String result) {
        this.mediator.println("setAccountAmount = " + result);
        if (result.equalsIgnoreCase("Exception")) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Amount");
            return;
        }
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        if (result.indexOf("|") >= 0) {
            String[] values = result.split("\\|", -1);
            String state = values[0];
            String amount = values[1];
            if (state.equalsIgnoreCase("true")) {
                try {
                    this.accountExposure = Double.parseDouble(amount);
                    this.txtAvbAmount.setText(Util.format2digit((String)amount));
                    this.setRemainingAmount();
                }
                catch (Exception ex) {
                    this.accountExposure = 0.0;
                    ex.printStackTrace();
                    this.txtAvbAmount.setText("0.00");
                    this.setRemainingAmount();
                }
            } else {
                this.txtAvbAmount.setText("0.00");
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)state);
                this.accountExposure = 0.0;
            }
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Account Avaiable Amount");
            this.txtAvbAmount.setText("0.00");
        }
    }

    public void setAmountRequest() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return;
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().length() > 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)"Loading Avaiable Amount");
            LoadLogs availableAmount = new LoadLogs("AvailableAmountByAccount=", true);
            new Thread(availableAmount).start();
        } else {
            this.txtAvbAmount.setText("");
            this.txtRemainingAmount.setText("");
            this.txtAmount.setText("");
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        }
    }

    public void setBranchNames(String result) {
        if (result.indexOf("|") >= 0) {
            String branch = "Please select|" + result;
            this.cbBranchCity.setModel(new DefaultComboBoxModel<String>(branch.split("\\|", -1)));
            this.cbBranchCity.removeItem("");
            branchCity = result;
        }
    }

    public void txtAmountActionPerformed(ActionEvent e) {
        this.isChequeDelivery.requestFocus();
        this.setRemainingAmount();
    }

    private void initComponents() {
        this.rbGroup = new ButtonGroup();
        this.buttonGroup = new ButtonGroup();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.lblMessage = new JLabel();
        this.sepBottom = new JSeparator();
        this.jLabel6 = new JLabel();
        this.btnFetchTitle = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jLabel7 = new JLabel();
        this.txtAvbAmount = new JTextField();
        this.txtAmount = new JTextField();
        this.txtPinCode = new JPasswordField();
        this.jLabel8 = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.lblForgetPinCode = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.txtRemainingAmount = new JTextField();
        this.jXTitledSeparator2 = new JXTitledSeparator();
        this.isChequeDelivery = new JRadioButton();
        this.isChequePickup = new JRadioButton();
        this.isFundTransfer = new JRadioButton();
        this.cbBranchCity = new JComboBox();
        this.lblChequePickupLogo = new JLabel();
        this.lblChequeDeliveryLogo = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtDescription = new JTextPane();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jXTitledSeparator6 = new JXTitledSeparator();
        this.sepComments = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.sepOnline = new JSeparator();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.lblCashWithdrawalStatementLink = new JLabel();
        this.lblTransferLogo = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jLabel26 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel10 = new JLabel();
        this.isOtherAccount = new JCheckBox();
        this.lblFundBankName = new JTextField();
        this.lblFundBranchName = new JTextField();
        this.lblFundAccount = new JTextField();
        this.lblFundTitle = new JTextField();
        this.cbBankName = new JComboBox();
        this.btnSubmit = new JButton();
        this.setLayout(null);
        this.jLabel3.setFont(new Font("Tahoma", 1, 14));
        this.jLabel3.setText("JS Bank Fund Transfer");
        this.add(this.jLabel3);
        this.jLabel3.setBounds(30, 0, 250, 70);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/Images/withdrawalHeader.png")));
        this.add(this.jLabel4);
        this.jLabel4.setBounds(330, 0, 70, 70);
        this.add(this.lblMessage);
        this.lblMessage.setBounds(30, 550, 280, 20);
        this.add(this.sepBottom);
        this.sepBottom.setBounds(-10, 540, 470, 2);
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/Images/HeaderBG.png")));
        this.add(this.jLabel6);
        this.jLabel6.setBounds(-80, 0, 600, 70);
        this.btnFetchTitle.setFont(new Font("Tahoma", 0, 10));
        this.btnFetchTitle.setIcon(new ImageIcon(this.getClass().getResource("/Images/submit.png")));
        this.btnFetchTitle.setText("Fetch");
        this.btnFetchTitle.setName("WithdrawalChequeAndBankRequest -> btnSubmit");
        this.btnFetchTitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSInternalBankTransfer.this.btnFetchTitleActionPerformed(evt);
            }
        });
        this.add(this.btnFetchTitle);
        this.btnFetchTitle.setBounds(10, 460, 90, 25);
        this.add(this.jSeparator2);
        this.jSeparator2.setBounds(0, 70, 450, 2);
        this.jLabel7.setText("Please select the account for which you wish to make Cash Withdrawal");
        this.add(this.jLabel7);
        this.jLabel7.setBounds(30, 80, 350, 20);
        this.txtAvbAmount.setEditable(false);
        this.txtAvbAmount.setHorizontalAlignment(4);
        this.txtAvbAmount.setFocusable(false);
        this.add(this.txtAvbAmount);
        this.txtAvbAmount.setBounds(50, 190, 100, 20);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSInternalBankTransfer.this.txtAmountActionPerformed(evt);
            }
        });
        this.txtAmount.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JSInternalBankTransfer.this.txtAmountFocusLost(evt);
            }
        });
        this.txtAmount.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JSInternalBankTransfer.this.txtAmountKeyReleased(evt);
            }
        });
        this.add(this.txtAmount);
        this.txtAmount.setBounds(180, 190, 100, 20);
        this.txtPinCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSInternalBankTransfer.this.txtPinCodeActionPerformed(evt);
            }
        });
        this.add(this.txtPinCode);
        this.txtPinCode.setBounds(310, 105, 100, 20);
        this.jLabel8.setText("Account No");
        this.add(this.jLabel8);
        this.jLabel8.setBounds(30, 105, 70, 20);
        this.cbAccountNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSInternalBankTransfer.this.cbAccountNoActionPerformed(evt);
            }
        });
        this.cbAccountNo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JSInternalBankTransfer.this.cbAccountNoKeyPressed(evt);
            }
        });
        this.add(this.cbAccountNo);
        this.cbAccountNo.setBounds(100, 105, 181, 20);
        this.lblForgetPinCode.setText("Forgot PIN?");
        this.add(this.lblForgetPinCode);
        this.lblForgetPinCode.setBounds(312, 130, 60, 20);
        this.jLabel11.setHorizontalAlignment(0);
        this.jLabel11.setText("PIN");
        this.add(this.jLabel11);
        this.jLabel11.setBounds(280, 105, 30, 20);
        this.jLabel1.setText(" Available Amount");
        this.add(this.jLabel1);
        this.jLabel1.setBounds(50, 170, 86, 14);
        this.jLabel12.setText("PKR");
        this.add(this.jLabel12);
        this.jLabel12.setBounds(30, 190, 20, 20);
        this.jLabel13.setText(" Withdrawal Amount");
        this.add(this.jLabel13);
        this.jLabel13.setBounds(180, 170, 100, 14);
        this.jLabel14.setHorizontalAlignment(0);
        this.jLabel14.setText("=");
        this.add(this.jLabel14);
        this.jLabel14.setBounds(280, 190, 30, 20);
        this.jLabel15.setHorizontalAlignment(0);
        this.jLabel15.setText("-");
        this.add(this.jLabel15);
        this.jLabel15.setBounds(150, 190, 30, 20);
        this.jLabel16.setText("Remaining Amount");
        this.add(this.jLabel16);
        this.jLabel16.setBounds(310, 170, 89, 14);
        this.txtRemainingAmount.setEditable(false);
        this.txtRemainingAmount.setHorizontalAlignment(4);
        this.txtRemainingAmount.setFocusable(false);
        this.txtRemainingAmount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSInternalBankTransfer.this.txtRemainingAmountActionPerformed(evt);
            }
        });
        this.add(this.txtRemainingAmount);
        this.txtRemainingAmount.setBounds(310, 190, 100, 20);
        this.jXTitledSeparator2.setTitle("");
        this.jXTitledSeparator2.setBackground(new Color(255, 102, 0));
        this.add((Component)this.jXTitledSeparator2);
        this.jXTitledSeparator2.setBounds(-10, 150, 470, 10);
        this.buttonGroup.add(this.isChequeDelivery);
        this.isChequeDelivery.setSelected(true);
        this.isChequeDelivery.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JSInternalBankTransfer.this.isChequeDeliveryItemStateChanged(evt);
            }
        });
        this.add(this.isChequeDelivery);
        this.isChequeDelivery.setBounds(10, 245, 21, 20);
        this.buttonGroup.add(this.isChequePickup);
        this.isChequePickup.setMaximumSize(new Dimension(99, 20));
        this.isChequePickup.setMinimumSize(new Dimension(99, 20));
        this.isChequePickup.setPreferredSize(new Dimension(99, 20));
        this.isChequePickup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JSInternalBankTransfer.this.isChequePickupItemStateChanged(evt);
            }
        });
        this.add(this.isChequePickup);
        this.isChequePickup.setBounds(10, 315, 20, 20);
        this.buttonGroup.add(this.isFundTransfer);
        this.isFundTransfer.setMaximumSize(new Dimension(225, 20));
        this.isFundTransfer.setMinimumSize(new Dimension(225, 20));
        this.isFundTransfer.setPreferredSize(new Dimension(225, 20));
        this.isFundTransfer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JSInternalBankTransfer.this.isFundTransferItemStateChanged(evt);
            }
        });
        this.add(this.isFundTransfer);
        this.isFundTransfer.setBounds(10, 385, 20, 20);
        this.cbBranchCity.setEnabled(false);
        this.add(this.cbBranchCity);
        this.cbBranchCity.setBounds(310, 300, 100, 20);
        this.lblChequePickupLogo.setIcon(new ImageIcon(this.getClass().getResource("/Images/chequepickup.png")));
        this.lblChequePickupLogo.setOpaque(true);
        this.lblChequePickupLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JSInternalBankTransfer.this.lblChequePickupLogoMousePressed(evt);
            }
        });
        this.add(this.lblChequePickupLogo);
        this.lblChequePickupLogo.setBounds(40, 300, 48, 48);
        this.lblChequeDeliveryLogo.setIcon(new ImageIcon(this.getClass().getResource("/Images/chequeDelivery.png")));
        this.lblChequeDeliveryLogo.setOpaque(true);
        this.lblChequeDeliveryLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JSInternalBankTransfer.this.lblChequeDeliveryLogoMousePressed(evt);
            }
        });
        this.add(this.lblChequeDeliveryLogo);
        this.lblChequeDeliveryLogo.setBounds(40, 230, 48, 48);
        this.jLabel2.setText("Please select this option if you would like us to send cheque at");
        this.add(this.jLabel2);
        this.jLabel2.setBounds(110, 250, 320, 20);
        this.txtDescription.setText("Please enter your comments (if required)");
        this.txtDescription.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JSInternalBankTransfer.this.txtDescriptionMousePressed(evt);
            }
        });
        this.txtDescription.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                JSInternalBankTransfer.this.txtDescriptionFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                JSInternalBankTransfer.this.txtDescriptionFocusLost(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.txtDescription);
        this.add(this.jScrollPane1);
        this.jScrollPane1.setBounds(70, 500, 340, 30);
        this.jLabel18.setText("your registered Address.");
        this.add(this.jLabel18);
        this.jLabel18.setBounds(110, 270, 300, 20);
        this.jLabel19.setText("our branches.");
        this.add(this.jLabel19);
        this.jLabel19.setBounds(110, 340, 320, 20);
        this.jLabel20.setText("Please select this option if you would like to pickup cheque from ");
        this.add(this.jLabel20);
        this.jLabel20.setBounds(110, 320, 320, 20);
        this.jXTitledSeparator6.setTitle("");
        this.add((Component)this.jXTitledSeparator6);
        this.jXTitledSeparator6.setBounds(-10, 210, 470, 20);
        this.add(this.sepComments);
        this.sepComments.setBounds(0, 490, 440, 2);
        this.add(this.jSeparator4);
        this.jSeparator4.setBounds(30, 290, 380, 2);
        this.add(this.sepOnline);
        this.sepOnline.setBounds(30, 360, 380, 2);
        this.jLabel23.setFont(new Font("Tahoma", 1, 11));
        this.jLabel23.setText("Cheque Pickup ");
        this.add(this.jLabel23);
        this.jLabel23.setBounds(100, 300, 100, 20);
        this.jLabel24.setFont(new Font("Tahoma", 1, 11));
        this.jLabel24.setText("Cheque Delivery");
        this.add(this.jLabel24);
        this.jLabel24.setBounds(100, 230, 120, 20);
        this.lblCashWithdrawalStatementLink.setFont(new Font("Tahoma", 1, 11));
        this.lblCashWithdrawalStatementLink.setIcon(new ImageIcon(this.getClass().getResource("/Images/withdrawlStatement.png")));
        this.lblCashWithdrawalStatementLink.setText("Cash Withdrawal Statement");
        this.lblCashWithdrawalStatementLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JSInternalBankTransfer.this.lblCashWithdrawalStatementLinkMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JSInternalBankTransfer.this.lblCashWithdrawalStatementLinkMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                JSInternalBankTransfer.this.lblCashWithdrawalStatementLinkMousePressed(evt);
            }
        });
        this.add(this.lblCashWithdrawalStatementLink);
        this.lblCashWithdrawalStatementLink.setBounds(28, 130, 180, 20);
        this.lblTransferLogo.setIcon(new ImageIcon(this.getClass().getResource("/Images/transfer.png")));
        this.lblTransferLogo.setOpaque(true);
        this.lblTransferLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JSInternalBankTransfer.this.lblTransferLogoMousePressed(evt);
            }
        });
        this.add(this.lblTransferLogo);
        this.lblTransferLogo.setBounds(50, 370, 48, 48);
        this.jLabel22.setText("Remarks");
        this.add(this.jLabel22);
        this.jLabel22.setBounds(10, 500, 60, 20);
        this.jLabel25.setFont(new Font("Tahoma", 1, 11));
        this.jLabel25.setText("Fund Transfer");
        this.add(this.jLabel25);
        this.jLabel25.setBounds(110, 370, 100, 20);
        this.jLabel26.setText("Bank");
        this.add(this.jLabel26);
        this.jLabel26.setBounds(110, 390, 55, 20);
        this.jLabel9.setText("Branch");
        this.add(this.jLabel9);
        this.jLabel9.setBounds(110, 415, 55, 20);
        this.jLabel27.setText("Account #");
        this.add(this.jLabel27);
        this.jLabel27.setBounds(110, 440, 55, 20);
        this.jLabel10.setText("Title");
        this.add(this.jLabel10);
        this.jLabel10.setBounds(110, 465, 55, 20);
        this.isOtherAccount.setText("Other Account");
        this.isOtherAccount.setEnabled(false);
        this.isOtherAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSInternalBankTransfer.this.isOtherAccountActionPerformed(evt);
            }
        });
        this.add(this.isOtherAccount);
        this.isOtherAccount.setBounds(210, 365, 140, 23);
        this.lblFundBankName.setEditable(false);
        this.add(this.lblFundBankName);
        this.lblFundBankName.setBounds(170, 390, 240, 20);
        this.lblFundBranchName.setEditable(false);
        this.add(this.lblFundBranchName);
        this.lblFundBranchName.setBounds(170, 415, 240, 20);
        this.add(this.lblFundAccount);
        this.lblFundAccount.setBounds(170, 440, 240, 20);
        this.lblFundTitle.setEditable(false);
        this.add(this.lblFundTitle);
        this.lblFundTitle.setBounds(170, 465, 240, 20);
        this.add(this.cbBankName);
        this.cbBankName.setBounds(170, 390, 240, 20);
        this.btnSubmit.setIcon(new ImageIcon(this.getClass().getResource("/Images/submit.png")));
        this.btnSubmit.setText("Submit");
        this.btnSubmit.setName("WithdrawalChequeAndBankRequest -> btnSubmit");
        this.btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSInternalBankTransfer.this.btnSubmitActionPerformed(evt);
            }
        });
        this.add(this.btnSubmit);
        this.btnSubmit.setBounds(320, 550, 90, 25);
    }

    private void btnFetchTitleActionPerformed(ActionEvent evt) {
        this.fetchTitle();
    }

    private void txtPinCodeActionPerformed(ActionEvent evt) {
        this.txtAmount.requestFocus();
    }

    private void cbAccountNoActionPerformed(ActionEvent evt) {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return;
        }
        this.setAmountRequest();
        this.setFundBankInfo();
    }

    private void cbAccountNoKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.txtPinCode.requestFocus();
        }
    }

    private void isChequePickupItemStateChanged(ItemEvent evt) {
        this.setType();
    }

    private void isChequeDeliveryItemStateChanged(ItemEvent evt) {
        this.setType();
    }

    private void txtRemainingAmountActionPerformed(ActionEvent evt) {
    }

    private void txtAmountFocusLost(FocusEvent evt) {
        this.setRemainingAmount();
    }

    private void txtDescriptionMousePressed(MouseEvent evt) {
    }

    private void txtDescriptionFocusGained(FocusEvent evt) {
        String text = this.txtDescription.getText().trim();
        if (text.equalsIgnoreCase("Please enter your comments (if required)")) {
            this.txtDescription.setText("");
        }
    }

    private void txtDescriptionFocusLost(FocusEvent evt) {
        String text = this.txtDescription.getText().trim();
        if (text.equalsIgnoreCase("")) {
            this.txtDescription.setText("Please enter your comments (if required)");
        }
    }

    private void txtAmountKeyReleased(KeyEvent evt) {
        this.setRemainingAmount();
    }

    private void lblChequePickupLogoMousePressed(MouseEvent evt) {
        this.isChequePickup.setSelected(true);
    }

    private void lblChequeDeliveryLogoMousePressed(MouseEvent evt) {
        this.isChequeDelivery.setSelected(true);
    }

    private void lblCashWithdrawalStatementLinkMouseEntered(MouseEvent evt) {
        this.lblCashWithdrawalStatementLink.setText("<html><u>" + this.linkText + "</u></html>");
    }

    private void lblCashWithdrawalStatementLinkMouseExited(MouseEvent evt) {
        this.lblCashWithdrawalStatementLink.setText("<html>" + this.linkText + "</html>");
    }

    private void lblCashWithdrawalStatementLinkMousePressed(MouseEvent evt) {
        this.lblCashWithdrawalStatementLink.setText("<html>" + this.linkText + "</html>");
        TradeCast.getInstance().ShowDynamicForm(FormName.WithDrawStatement, LanguageConstant.CashWithdrawalStatement);
    }

    private void isFundTransferItemStateChanged(ItemEvent evt) {
        this.setType();
        this.cbBankName.setEnabled(this.isFundTransfer.isSelected());
        this.isOtherAccount.setEnabled(this.isFundTransfer.isSelected());
        this.lblFundBankName.setEnabled(this.isFundTransfer.isSelected());
        this.lblFundBranchName.setEnabled(this.isFundTransfer.isSelected());
        this.lblFundAccount.setEnabled(this.isFundTransfer.isSelected());
        this.lblFundTitle.setEnabled(this.isFundTransfer.isSelected());
    }

    private void lblTransferLogoMousePressed(MouseEvent evt) {
        this.isFundTransfer.setSelected(true);
    }

    private void isOtherAccountActionPerformed(ActionEvent evt) {
        this.lblFundBankName.setText("");
        this.lblFundBranchName.setText("");
        this.lblFundAccount.setText("");
        this.lblFundTitle.setText("");
        if (this.isOtherAccount.isSelected()) {
            this.lblFundBankName.setEditable(true);
            this.lblFundBranchName.setEditable(true);
            this.lblFundAccount.setEditable(true);
            this.lblFundTitle.setEditable(true);
            this.lblFundBankName.setVisible(false);
            this.cbBankName.setEnabled(true);
            this.cbBankName.setVisible(true);
        } else {
            this.lblFundBankName.setEditable(false);
            this.lblFundBranchName.setEditable(false);
            this.lblFundAccount.setEditable(false);
            this.lblFundTitle.setEditable(false);
            this.lblFundBankName.setVisible(true);
            this.cbBankName.setEnabled(false);
            this.cbBankName.setVisible(false);
        }
    }

    private void btnSubmitActionPerformed(ActionEvent evt) {
        this.initiateFundTransferRequest();
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source == this.txtPinCode) {
            this.txtPinCode.selectAll();
        } else if (source == this.txtAmount) {
            this.txtAmount.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void setType() {
        this.cbBranchCity.setEnabled(this.isChequePickup.isSelected());
        this.setFundBankInfo();
    }

    private void setRemainingAmount() {
        try {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)" ");
            double amount = Double.parseDouble(this.txtAmount.getText().trim());
            this.txtRemainingAmount.setText(Util.format2digit((String)(this.accountExposure - amount + "")));
            if (amount > this.accountExposure) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Insufficient available amount");
                return;
            }
        }
        catch (Exception ex) {
            this.txtRemainingAmount.setText(Util.format2digit((String)(this.accountExposure + "")));
        }
    }

    public String getAccount() {
        String acc = "";
        if (this.cbAccountNo.getSelectedItem() != null) {
            acc = this.cbAccountNo.getSelectedItem().toString();
        }
        return acc;
    }

    public void setFundBankName(String result) {
        this.mediator.println("setFundBankName = " + result);
        if (result.indexOf("|") > 0) {
            String[] all = result.split("\\|", -1);
            for (int i = 0; i < all.length; ++i) {
                if (all[i].trim().length() <= 0) continue;
                String[] data = all[i].split("\\;", -1);
                FundBankName fb = new FundBankName();
                fb.account = data[0];
                fb.bacnkAccountNo = data[1];
                fb.bankName = data[2];
                fb.accountTitle = data[3];
                fb.branchName = data[4];
                this.accountInfo.put(fb.account, fb);
            }
        }
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Bank info loaded");
    }

    private void setFundBankInfo() {
        if (this.isFundTransfer.isSelected()) {
            if (this.accountInfo.containsKey(this.getAccount())) {
                if (!this.isOtherAccount.isSelected()) {
                    FundBankName fb = this.accountInfo.get(this.getAccount());
                    this.lblFundBankName.setText(" " + fb.bankName);
                    this.lblFundBranchName.setText(" " + fb.branchName);
                    this.lblFundAccount.setText(" " + fb.bacnkAccountNo);
                    this.lblFundTitle.setText(" " + fb.accountTitle);
                } else {
                    this.lblFundBankName.setText("");
                    this.lblFundBranchName.setText("");
                    this.lblFundAccount.setText("");
                    this.lblFundTitle.setText("");
                }
            } else {
                this.lblFundBankName.setText("");
                this.lblFundBranchName.setText("");
                this.lblFundAccount.setText("");
                this.lblFundTitle.setText("");
            }
        } else {
            this.lblFundBankName.setText("");
            this.lblFundBranchName.setText("");
            this.lblFundAccount.setText("");
            this.lblFundTitle.setText("");
        }
    }

    private void setFormDynamic() {
        Rectangle bound = this.isChequeDelivery.getBounds();
        int difference = bound.y;
        bound = this.isFundTransfer.getBounds();
        difference = bound.y - difference;
        this.btnSubmit.setEnabled(false);
        this.isFundTransfer.setSelected(true);
        this.lblCashWithdrawalStatementLink.setVisible(false);
        this.isOtherAccount.setVisible(false);
        this.isChequeDelivery.setVisible(false);
        this.lblChequeDeliveryLogo.setVisible(false);
        this.jLabel24.setVisible(false);
        this.jLabel2.setVisible(false);
        this.jLabel18.setVisible(false);
        this.jSeparator4.setVisible(false);
        this.isChequePickup.setVisible(false);
        this.lblChequePickupLogo.setVisible(false);
        this.jLabel23.setVisible(false);
        this.jLabel20.setVisible(false);
        this.jLabel19.setVisible(false);
        this.cbBranchCity.setVisible(false);
        this.sepOnline.setVisible(false);
        bound = this.lblTransferLogo.getBounds();
        this.lblTransferLogo.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        bound = this.jLabel25.getBounds();
        this.jLabel25.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        bound = this.isFundTransfer.getBounds();
        this.isFundTransfer.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        bound = this.isOtherAccount.getBounds();
        this.isOtherAccount.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        bound = this.jLabel10.getBounds();
        this.jLabel10.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        bound = this.jLabel9.getBounds();
        this.jLabel9.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        this.jLabel9.setVisible(false);
        bound = this.jLabel26.getBounds();
        this.jLabel26.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        this.jLabel26.setVisible(false);
        bound = this.jLabel27.getBounds();
        this.jLabel27.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        this.jLabel27.setText("IBAN #");
        bound = this.lblFundBankName.getBounds();
        this.lblFundBankName.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        this.lblFundBankName.setVisible(false);
        bound = this.lblFundBranchName.getBounds();
        this.lblFundBranchName.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        this.lblFundBranchName.setVisible(false);
        bound = this.lblFundAccount.getBounds();
        this.lblFundAccount.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        bound = this.lblFundTitle.getBounds();
        this.lblFundTitle.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        bound = this.sepComments.getBounds();
        this.sepComments.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        bound = this.txtDescription.getBounds();
        this.txtDescription.setBounds(bound.x, bound.y - difference, bound.width, 150);
        bound = this.jScrollPane1.getBounds();
        this.jScrollPane1.setBounds(bound.x, bound.y - difference, bound.width, 150);
        bound = this.jLabel22.getBounds();
        this.jLabel22.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        bound = this.cbBankName.getBounds();
        this.cbBankName.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
        bound = this.btnFetchTitle.getBounds();
        this.btnFetchTitle.setBounds(bound.x, bound.y - difference, bound.width, bound.height);
    }

    private class FundBankName {
        public String account;
        public String bacnkAccountNo;
        public String bankName;
        public String accountTitle;
        public String branchName;

        private FundBankName() {
        }
    }

    private class LimitedLinesDocument
    extends DefaultStyledDocument {
        private static final long serialVersionUID = 1L;
        private static final String EOL = "\n";
        private final int maxLines;
        private final int maxChars;

        public LimitedLinesDocument(int maxLines, int maxChars) {
            this.maxLines = maxLines;
            this.maxChars = maxChars;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet attribute) throws BadLocationException {
            boolean ok = true;
            String currentText = this.getText(0, this.getLength());
            if (str.contains(EOL)) {
                if (this.occurs(currentText, EOL) >= this.maxLines - 1) {
                    ok = false;
                }
            } else {
                String[] lines = currentText.split(EOL);
                int lineBeginPos = 0;
                for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
                    int lineLength = lines[lineNum].length();
                    int lineEndPos = lineBeginPos + lineLength;
                    if (lineBeginPos <= offs && offs <= lineEndPos && lineLength + 1 > this.maxChars) {
                        ok = false;
                        break;
                    }
                    lineBeginPos = lineEndPos;
                    ++lineBeginPos;
                }
            }
            if (ok) {
                super.insertString(offs, str, attribute);
            }
        }

        private int occurs(String str, String subStr) {
            int occurrences = 0;
            int fromIndex = 0;
            while (fromIndex > -1) {
                fromIndex = str.indexOf(subStr, occurrences == 0 ? fromIndex : fromIndex + subStr.length());
                if (fromIndex <= -1) continue;
                ++occurrences;
            }
            return occurrences;
        }
    }
}

