/*
 * Decompiled with CFR 0.152.
 */
package windows;

import MyDocking.Mediator;
import Utilities.CompressManager;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class MarketDataExport
extends JPanel {
    AutoCompleteSupport autoCompleteMarket;
    Mediator mediator = Mediator.getInstance();
    JFileChooser chooser;
    private JButton btnDownload;
    private JComboBox cbMarkets;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;

    public MarketDataExport() {
        this.initComponents();
        this.setMarkets();
        this.mediator.setMarketDataExport(this);
        this.chooser = new JFileChooser();
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".csv") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "CSV Files";
            }
        });
    }

    public void setMarkets() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MarketDataExport.this.autoCompleteMarket != null && MarketDataExport.this.autoCompleteMarket.isInstalled()) {
                    MarketDataExport.this.autoCompleteMarket.uninstall();
                }
                Vector<String> allMarket = new Vector<String>();
                allMarket.addElement("ALL");
                for (int i = 0; i < LogCommon.markets.length; ++i) {
                    allMarket.addElement(LogCommon.markets[i]);
                }
                Collections.sort(allMarket);
                MarketDataExport.this.cbMarkets.setModel(new DefaultComboBoxModel(allMarket));
                MarketDataExport.this.autoCompleteMarket = AutoCompleteSupport.install((JComboBox)MarketDataExport.this.cbMarkets, (EventList)GlazedLists.eventListOf((Object[])allMarket.toArray()));
                MarketDataExport.this.cbMarkets.setSelectedItem("ALL");
                MarketDataExport.this.autoCompleteMarket.setStrict(true);
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbMarkets = new JComboBox();
        this.btnDownload = new JButton();
        this.jSeparator1 = new JSeparator();
        this.lblMessage = new JLabel();
        this.jLabel1.setText("Market");
        this.btnDownload.setIcon(new ImageIcon(this.getClass().getResource("/Images/download.png")));
        this.btnDownload.setText("Download");
        this.btnDownload.setName("MarketDataExport -> btnDownload");
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarketDataExport.this.btnDownloadActionPerformed(evt);
            }
        });
        this.lblMessage.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -2, 290, -2).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(13, 13, 13).addComponent(this.cbMarkets, -2, 110, -2).addGap(14, 14, 14).addComponent(this.btnDownload, -2, 100, -2)).addComponent(this.lblMessage, -2, 240, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 23, -2).addComponent(this.cbMarkets, -2, 23, -2).addComponent(this.btnDownload, -2, 23, -2)).addGap(7, 7, 7).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addComponent(this.lblMessage)));
    }

    private void btnDownloadActionPerformed(ActionEvent evt) {
        if (this.cbMarkets.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select Market");
            this.cbMarkets.requestFocus();
            return;
        }
        if (this.cbMarkets.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select Market");
            this.cbMarkets.requestFocus();
            return;
        }
        this.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getData() {
        block17: {
            try {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait while loading");
                String market = this.cbMarkets.getSelectedItem().toString();
                byte[] dat = WebService.getInstance().getPort().getCompressedData(market, "MarketDataExport=", market);
                String data = CompressManager.unzipStringFromBytes(dat);
                String name = "Market Data Export.csv";
                File f = new File(System.getProperty("user.home") + "/" + name);
                this.chooser.setSelectedFile(f);
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please provide file and location");
                int returnVal = this.chooser.showSaveDialog(this);
                if (returnVal == 0) {
                    File file = this.chooser.getSelectedFile();
                    String fileName = file.getName();
                    if (fileName.indexOf(".csv") < 0) {
                        fileName = fileName + ".csv";
                    }
                    String parent = file.getParent();
                    String path = parent + Util.FileSeparator + fileName;
                    BufferedWriter bw = null;
                    FileWriter fw = null;
                    try {
                        fw = new FileWriter(path);
                        bw = new BufferedWriter(fw);
                        bw.write(data);
                        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Sussess, (String)"Market data has been exported");
                        break block17;
                    }
                    catch (IOException e) {
                        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Error in file exporting");
                        e.printStackTrace();
                        break block17;
                    }
                    finally {
                        try {
                            if (bw != null) {
                                bw.close();
                            }
                            if (fw != null) {
                                fw.close();
                            }
                        }
                        catch (IOException ex) {
                            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Error in file exporting");
                            ex.printStackTrace();
                        }
                    }
                }
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)name);
            }
            catch (Exception ex) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Error in Loading");
                ex.printStackTrace();
            }
        }
    }
}

